# CLDR Tools

This is a stub page, for further details see the top [README](../README.md#contributing) or <https://cldr.unicode.org>.

## Spotless

Like other projects, CLDR uses a source formatter to ensure a consistent code style automatically, and it uses a single common formatter to avoid spurious diff noise in code reviews.  This is now enforced via a [formatter](https://github.com/google/google-java-format) that is [configured in the Maven build](../.github/workflows/maven.yml) via a [Maven plugin](https://github.com/diffplug/spotless/tree/main/plugin-maven) and checked by continuous integration on pull requests.

When creating pull requests, you can check the formatting locally using the command `mvn --file=tools/pom.xml spotless:check`.  You can apply the formatter's changes using the command `mvn --file=tools/pom.xml spotless:apply`.  Continuous integration errors for formatting can be fixed by committing the changes resulting from applying the formatter locally and pushing the new commit.

Some IDEs can integrate the formatter via plugins, which can minimize the need to manually run the formatter separately.  The following links for specific IDEs may work:

* Eclipse: Follow the [instructions](https://source.android.com/devices/tech/test_infra/tradefed/development/eclipse#auto_format) in the "Auto format" section. You can alternatively use this link for [`android-formatting.xml`](https://raw.githubusercontent.com/aosp-mirror/platform_development/master/ide/eclipse/android-formatting.xml).
* VSCode: Follow the [instructions](https://code.visualstudio.com/docs/java/java-linting#_formatter) in "Applying formatter settings", but use the same `android-formatting.xml` link mentioned for Eclipse (ex: `"java.format.settings.url": "https://raw.githubusercontent.com/aosp-mirror/platform_development/master/ide/eclipse/android-formatting.xml",`).  Also use the profile name corresponding to that XML file: (ex: `"java.format.settings.profile": "Android",`).
* IntelliJ: Use the [official plugin](https://plugins.jetbrains.com/plugin/8527-google-java-format/) for the formatter.

(This documentation is from the Unicode project [https://github.com/unicode-org/unicodetools](unicodetools))
