/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class PieChart
extends Applet {
    String title;
    Font font;
    FontMetrics fontMetrics;
    int titleHeight = 15;
    int columns;
    public int round = 1000;
    public float[] values;
    Color[] colors;
    public String[] labels;
    public float[] percent;
    public float[] angle;
    public float[] degree;
    public float[] radian;
    public float[] rawinput;
    int maxLabelWidth = 0;
    int maxValueWidth = 0;
    int max = 0;
    int strWidth = 0;
    public boolean showLabel = true;
    public boolean showPercent = false;
    public boolean showRadians = false;
    public boolean showDegrees = false;
    public boolean showInput = true;
    String unit;
    int lx = 0;
    int ly = 0;
    int cx = 0;
    int cy = 0;
    int smallfont = 16;
    int largefont = 18;
    int alpha = 255;

    public synchronized void init() {
        String string;
        String string2 = this.getParameter("smallfont");
        if (string2 != null && string2.length() > 0) {
            this.smallfont = Integer.parseInt(string2);
        }
        if ((string2 = this.getParameter("largefont")) != null && string2.length() > 0) {
            this.largefont = Integer.parseInt(string2);
        }
        this.font = new Font("Sanserif", 1, this.smallfont);
        this.fontMetrics = this.getFontMetrics(this.font);
        string2 = this.getParameter("alpha");
        if (string2 != null && string2.length() > 0) {
            this.alpha = Integer.parseInt(string2);
        }
        if ((string2 = this.getParameter("bgcolor")) == null) {
            this.setBackground(Color.white);
        } else if (string2.equals("red")) {
            this.setBackground(Color.red);
        } else if (string2.equals("green")) {
            this.setBackground(Color.green);
        } else if (string2.equals("blue")) {
            this.setBackground(Color.blue);
        } else if (string2.equals("pink")) {
            this.setBackground(Color.pink);
        } else if (string2.equals("orange")) {
            this.setBackground(Color.orange);
        } else if (string2.equals("magenta")) {
            this.setBackground(Color.magenta);
        } else if (string2.equals("cyan")) {
            this.setBackground(Color.cyan);
        } else if (string2.equals("white")) {
            this.setBackground(Color.white);
        } else if (string2.equals("yellow")) {
            this.setBackground(Color.yellow);
        } else if (string2.equals("gray")) {
            this.setBackground(Color.gray);
        } else if (string2.equals("darkGray")) {
            this.setBackground(Color.darkGray);
        } else {
            this.setBackground(Color.white);
        }
        this.title = this.getParameter("title");
        if (this.title == null) {
            this.title = "WIMS Pie Chart";
        }
        this.unit = this.getParameter("unit");
        if (this.unit == null) {
            this.unit = "";
        }
        this.columns = (string = this.getParameter("columns")) == null ? 5 : Integer.parseInt(string);
        string = this.getParameter("rounding");
        if (string != null) {
            this.round = Integer.parseInt(string);
            if (this.round < 1) {
                this.round = 100;
            }
        }
        if ((string = this.getParameter("showdegrees")) == null) {
            this.showDegrees = false;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showDegrees = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showDegrees = false;
            }
        }
        string = this.getParameter("showradians");
        if (string == null) {
            this.showRadians = false;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showRadians = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showRadians = false;
            }
        }
        string = this.getParameter("showinput");
        if (string == null) {
            this.showInput = true;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showInput = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showInput = false;
            }
        }
        string = this.getParameter("showlabel");
        if (string == null) {
            this.showLabel = false;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showLabel = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showLabel = false;
            }
        }
        string = this.getParameter("showpercent");
        if (string == null) {
            this.showPercent = false;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showPercent = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showPercent = false;
            }
        }
        this.radian = new float[this.columns];
        this.degree = new float[this.columns];
        this.rawinput = new float[this.columns];
        this.values = new float[this.columns];
        this.colors = new Color[this.columns];
        this.labels = new String[this.columns];
        this.percent = new float[this.columns];
        this.angle = new float[this.columns];
        Object var3_3 = null;
        float f = 0.0f;
        for (int i = 0; i < this.columns; ++i) {
            float f2;
            float f3;
            String string3 = this.getParameter("Pvalue" + (i + 1));
            this.values[i] = f3 = Float.valueOf(string3.trim()).floatValue();
            this.rawinput[i] = f2 = Float.valueOf(string3).floatValue();
            f += this.values[i];
            String string4 = this.getParameter("Plabel" + (i + 1));
            this.labels[i] = string4 != null ? string4 : "";
            this.maxLabelWidth = Math.max(this.fontMetrics.stringWidth(this.labels[i]), this.maxLabelWidth);
            string4 = this.getParameter("Pcolor" + (i + 1));
            if (string4 != null) {
                if (string4.indexOf(",") != -1) {
                    int n;
                    int[] nArray;
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                    int n2 = stringTokenizer.countTokens();
                    if (n2 == 3) {
                        nArray = new int[3];
                        for (n = 0; n < 3; ++n) {
                            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        this.colors[i] = new Color(nArray[0], nArray[1], nArray[2]);
                        System.out.println("color " + nArray[0] + "," + nArray[1] + "," + nArray[2]);
                        continue;
                    }
                    if (n2 == 4) {
                        nArray = new int[4];
                        for (n = 0; n < 4; ++n) {
                            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        this.colors[i] = new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
                        System.out.println("color " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3]);
                        continue;
                    }
                    this.colors[i] = Color.gray;
                    System.out.println("error syntax is value=\"R:G:B\" or value=\"R:G:B:alpha\"");
                    continue;
                }
                if (string4.equals("red")) {
                    this.colors[i] = new Color(255, 0, 0, this.alpha);
                    continue;
                }
                if (string4.equals("green")) {
                    this.colors[i] = new Color(0, 255, 0, this.alpha);
                    continue;
                }
                if (string4.equals("blue")) {
                    this.colors[i] = new Color(0, 0, 255, this.alpha);
                    continue;
                }
                if (string4.equals("pink")) {
                    this.colors[i] = new Color(255, 0, 255, this.alpha);
                    continue;
                }
                if (string4.equals("orange")) {
                    this.colors[i] = new Color(255, 210, 0, this.alpha);
                    continue;
                }
                if (string4.equals("magenta")) {
                    this.colors[i] = new Color(255, 0, 255, this.alpha);
                    continue;
                }
                if (string4.equals("cyan")) {
                    this.colors[i] = new Color(0, 255, 255, this.alpha);
                    continue;
                }
                if (string4.equals("white")) {
                    this.colors[i] = new Color(255, 255, 255, this.alpha);
                    continue;
                }
                if (string4.equals("yellow")) {
                    this.colors[i] = new Color(255, 255, 0, this.alpha);
                    continue;
                }
                if (string4.equals("gray")) {
                    this.colors[i] = new Color(139, 137, 137, this.alpha);
                    continue;
                }
                if (string4.equals("darkGray")) {
                    this.colors[i] = new Color(49, 79, 79, this.alpha);
                    continue;
                }
                this.colors[i] = new Color(139, 137, 137, this.alpha);
                continue;
            }
            this.colors[i] = Color.gray;
        }
        float f4 = 100.0f / f;
        for (int i = 0; i < this.columns; ++i) {
            this.percent[i] = (float)Math.round((float)this.round * this.values[i] * f4) / (float)this.round;
            this.angle[i] = (float)Math.round((double)this.round * 3.6 * (double)this.values[i] * (double)f4) / (float)this.round;
            this.degree[i] = (float)Math.round((double)((float)this.round * this.percent[i]) * 3.6) / (float)this.round;
            this.radian[i] = (float)Math.round((float)this.round * this.angle[i] / 180.0f) / (float)this.round;
        }
    }

    public synchronized void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = 0;
        int n6 = 100;
        n3 = n4 = Math.min(this.getSize().width - n6, this.getSize().height - n6);
        n2 = 50;
        n = 50;
        if (this.getSize().width > n3) {
            n = (this.getSize().width - n3) / 2;
        }
        this.cx = n + n3 / 2;
        this.cy = n2 + n4 / 2;
        n5 = n3 / 2;
        this.strWidth = this.fontMetrics.stringWidth(this.title);
        Font font = new Font("Sanserif", 1, this.largefont);
        graphics.setFont(font);
        graphics.setColor(Color.red);
        graphics.drawString(this.title, (this.getSize().width - this.strWidth) / 2, 15);
        graphics.setFont(this.font);
        int n7 = 90;
        boolean bl5 = false;
        int n8 = 0;
        int n9 = (int)(this.angle[0] / 2.0f);
        for (int i = 0; i < this.columns; ++i) {
            int n10;
            int n11 = Math.round(this.angle[i]);
            graphics.setColor(this.colors[i]);
            if (i == this.columns - 1) {
                n11 = 360 - n8;
                graphics.fillArc(n, n2, n3, n4, n7, -n11);
                graphics.setColor(Color.black);
                graphics.drawArc(n, n2, n3, n4, n7, -n11);
                this.lx = (int)((double)this.cx + (double)n5 * Math.cos((float)n9 * 3.14f / 180.0f - 1.57f));
                this.ly = (int)((double)this.cy + (double)n5 * Math.sin((float)n9 * 3.14f / 180.0f - 1.57f));
                this.adjustLabel(i);
                n10 = this.ly + 15;
                if (this.showLabel) {
                    graphics.drawString(this.labels[i], this.lx, this.ly);
                    if (this.showDegrees) {
                        graphics.drawString(String.valueOf(this.degree[i]) + "\u00b0", this.lx, n10);
                        break;
                    }
                    if (this.showRadians) {
                        graphics.drawString(String.valueOf(this.radian[i]) + "\u03c0 rad", this.lx, n10);
                        break;
                    }
                    if (this.showPercent) {
                        graphics.drawString(String.valueOf(this.percent[i]) + " %", this.lx, n10);
                        break;
                    }
                    if (!this.showInput) break;
                    graphics.drawString(String.valueOf(this.rawinput[i]) + "  " + this.unit, this.lx, n10);
                    break;
                }
                if (this.showDegrees) {
                    graphics.drawString(String.valueOf(this.degree[i]) + "\u00b0", this.lx, n10);
                    break;
                }
                if (this.showRadians) {
                    graphics.drawString(String.valueOf(this.radian[i]) + "\u03c0 rad", this.lx, n10);
                    break;
                }
                if (this.showPercent) {
                    graphics.drawString(String.valueOf(Math.round((float)this.round * this.percent[i]) / this.round) + " %", this.lx, n10);
                    break;
                }
                if (!this.showInput) break;
                graphics.drawString(String.valueOf(this.rawinput[i]) + "  " + this.unit, this.lx, n10);
                break;
            }
            graphics.fillArc(n, n2, n3, n4, n7, -n11);
            graphics.setColor(Color.black);
            graphics.drawArc(n, n2, n3, n4, n7, -n11);
            n10 = (int)((double)this.cx + (double)n5 * Math.cos((float)(n8 += n11) * 3.14f / 180.0f - 1.57f));
            int n12 = (int)((double)this.cy + (double)n5 * Math.sin((float)n8 * 3.14f / 180.0f - 1.57f));
            graphics.drawLine(this.cx, this.cy, n10, n12);
            this.lx = (int)((double)this.cx + (double)n5 * Math.cos((float)n9 * 3.14f / 180.0f - 1.57f));
            this.ly = (int)((double)this.cy + (double)n5 * Math.sin((float)n9 * 3.14f / 180.0f - 1.57f));
            this.adjustLabel(i);
            int n13 = this.ly + 15;
            if (this.showLabel) {
                graphics.drawString(this.labels[i], this.lx, this.ly);
                if (this.showDegrees) {
                    graphics.drawString(String.valueOf(this.degree[i]) + "\u00b0", this.lx, n13);
                } else if (this.showRadians) {
                    graphics.drawString(String.valueOf(this.radian[i]) + "\u03c0 rad", this.lx, n13);
                } else if (this.showPercent) {
                    graphics.drawString(String.valueOf(this.percent[i]) + " %", this.lx, n13);
                } else if (this.showInput) {
                    graphics.drawString(String.valueOf(this.rawinput[i]) + "  " + this.unit, this.lx, n13);
                }
            } else if (this.showDegrees) {
                graphics.drawString(String.valueOf(this.degree[i]) + "\u00b0", this.lx, n13);
            } else if (this.showRadians) {
                graphics.drawString(String.valueOf(this.radian[i]) + "\u03c0 rad", this.lx, n13);
            } else if (this.showPercent) {
                graphics.drawString(String.valueOf(Math.round((float)this.round * this.percent[i]) / this.round) + " %", this.lx, n13);
            } else if (this.showInput) {
                graphics.drawString(String.valueOf(this.rawinput[i]) + "  " + this.unit, this.lx, n13);
            }
            n9 += (int)(this.angle[i] / 2.0f + this.angle[i + 1] / 2.0f);
            n7 += -n11;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(this.cx, this.cy, this.cx, this.cy - n5);
    }

    private void adjustLabel(int n) {
        if (this.lx > this.cx && this.ly < this.cy) {
            this.lx += 5;
            this.ly -= 5;
        }
        if (this.lx > this.cx && this.ly > this.cy) {
            this.lx += 5;
            this.ly += 10;
        }
        if (this.lx < this.cx && this.ly > this.cy) {
            this.strWidth = this.fontMetrics.stringWidth(this.labels[n]);
            this.lx -= this.strWidth + 5;
            if (this.lx < 0) {
                this.lx = 0;
            }
        }
        if (this.lx < this.cx && this.ly < this.cy) {
            this.strWidth = this.fontMetrics.stringWidth(this.labels[n]);
            this.lx -= this.strWidth + 5;
            if (this.lx < 0) {
                this.lx = 0;
            }
        }
    }

    public String ReadApplet() {
        int n = this.values.length;
        String string = "";
        if (n == 0) {
            string = "error empty answer";
        } else {
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                String string3 = this.labels[i];
                float f = this.rawinput[i];
                string = string + "segment " + i + " [ " + string3 + " ] = " + f + "\n";
            }
        }
        return string;
    }

    public void SetApplet(String string) {
        int n;
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        float[] fArray = new float[n2];
        float f = 0.0f;
        for (n = 0; n < n2; ++n) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 0) {
                string3 = "0";
            }
            float f2 = Float.valueOf(string3).floatValue();
            System.out.println("input = " + f2 + "\n");
            this.rawinput[n] = f2;
            fArray[n] = f2;
            f += f2;
        }
        for (n = 0; n < n2; ++n) {
            float f3 = fArray[n];
            this.angle[n] = 360.0f * f3 / f;
            this.percent[n] = 100.0f * f3 / f;
            this.radian[n] = f3 / f;
            this.degree[n] = 360.0f * f3 / f;
        }
        this.repaint();
    }
}

