/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestChartXYInvertedAxis.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkAxis.h"
#include "vtkChartXY.h"
#include "vtkContextScene.h"
#include "vtkContextView.h"
#include "vtkFloatArray.h"
#include "vtkNew.h"
#include "vtkPlot.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkSmartPointer.h"
#include "vtkTable.h"
#include "vtkTesting.h"

static const char *TestChartXYInvertedAxisLog =
"# StreamVersion 1\n"
"RenderEvent 0 0 0 0 0 0 0\n"
"TimerEvent 0 0 0 0 0 0 0\n"
"EnterEvent 397 52 0 0 0 0 0\n"
"MouseMoveEvent 397 52 0 0 0 0 0\n"
"MouseMoveEvent 388 52 0 0 0 0 0\n"
"MouseMoveEvent 384 52 0 0 0 0 0\n"
"MouseMoveEvent 380 52 0 0 0 0 0\n"
"MouseMoveEvent 379 52 0 0 0 0 0\n"
"MouseMoveEvent 378 52 0 0 0 0 0\n"
"MouseMoveEvent 377 52 0 0 0 0 0\n"
"MouseMoveEvent 375 52 0 0 0 0 0\n"
"MouseMoveEvent 372 52 0 0 0 0 0\n"
"MouseMoveEvent 369 51 0 0 0 0 0\n"
"TimerEvent 369 51 0 0 0 0 0\n"
"MouseMoveEvent 365 50 0 0 0 0 0\n"
"MouseMoveEvent 360 48 0 0 0 0 0\n"
"MouseMoveEvent 353 47 0 0 0 0 0\n"
"MouseMoveEvent 346 43 0 0 0 0 0\n"
"MouseMoveEvent 340 41 0 0 0 0 0\n"
"MouseMoveEvent 335 39 0 0 0 0 0\n"
"TimerEvent 335 39 0 0 0 0 0\n"
"MouseMoveEvent 329 39 0 0 0 0 0\n"
"MouseMoveEvent 326 39 0 0 0 0 0\n"
"MouseMoveEvent 323 39 0 0 0 0 0\n"
"MouseMoveEvent 319 41 0 0 0 0 0\n"
"MouseMoveEvent 315 41 0 0 0 0 0\n"
"MouseMoveEvent 311 41 0 0 0 0 0\n"
"TimerEvent 311 41 0 0 0 0 0\n"
"MouseMoveEvent 310 41 0 0 0 0 0\n"
"MouseMoveEvent 309 41 0 0 0 0 0\n"
"MouseMoveEvent 308 42 0 0 0 0 0\n"
"MouseMoveEvent 305 45 0 0 0 0 0\n"
"MouseMoveEvent 301 48 0 0 0 0 0\n"
"MouseMoveEvent 297 55 0 0 0 0 0\n"
"TimerEvent 297 55 0 0 0 0 0\n"
"MouseMoveEvent 289 64 0 0 0 0 0\n"
"MouseMoveEvent 283 74 0 0 0 0 0\n"
"MouseMoveEvent 276 82 0 0 0 0 0\n"
"MouseMoveEvent 268 90 0 0 0 0 0\n"
"MouseMoveEvent 262 95 0 0 0 0 0\n"
"MouseMoveEvent 256 99 0 0 0 0 0\n"
"TimerEvent 256 99 0 0 0 0 0\n"
"MouseMoveEvent 254 101 0 0 0 0 0\n"
"MouseMoveEvent 253 102 0 0 0 0 0\n"
"MouseMoveEvent 252 102 0 0 0 0 0\n"
"TimerEvent 252 102 0 0 0 0 0\n"
"MouseMoveEvent 251 103 0 0 0 0 0\n"
"MouseMoveEvent 249 105 0 0 0 0 0\n"
"MouseMoveEvent 247 107 0 0 0 0 0\n"
"MouseMoveEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelForwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 1 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 1 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 1 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseWheelBackwardEvent 246 108 0 0 0 0 0\n"
"TimerEvent 246 108 0 0 0 0 0\n"
"MouseMoveEvent 245 109 0 0 0 0 0\n"
"MouseMoveEvent 245 113 0 0 0 0 0\n"
"MouseMoveEvent 244 118 0 0 0 0 0\n"
"MouseMoveEvent 242 122 0 0 0 0 0\n"
"MouseMoveEvent 242 125 0 0 0 0 0\n"
"MouseMoveEvent 240 133 0 0 0 0 0\n"
"TimerEvent 240 133 0 0 0 0 0\n"
"MouseMoveEvent 236 142 0 0 0 0 0\n"
"MouseMoveEvent 234 151 0 0 0 0 0\n"
"MouseMoveEvent 232 159 0 0 0 0 0\n"
"MouseMoveEvent 230 166 0 0 0 0 0\n"
"MouseMoveEvent 228 174 0 0 0 0 0\n"
"MouseMoveEvent 227 180 0 0 0 0 0\n"
"TimerEvent 227 180 0 0 0 0 0\n"
"MouseMoveEvent 225 184 0 0 0 0 0\n"
"MouseMoveEvent 225 188 0 0 0 0 0\n"
"MouseMoveEvent 223 192 0 0 0 0 0\n"
"MouseMoveEvent 223 193 0 0 0 0 0\n"
"MouseMoveEvent 222 195 0 0 0 0 0\n"
"MouseMoveEvent 222 198 0 0 0 0 0\n"
"TimerEvent 222 198 0 0 0 0 0\n"
"MouseMoveEvent 220 202 0 0 0 0 0\n"
"MouseMoveEvent 220 203 0 0 0 0 0\n"
"MouseMoveEvent 219 205 0 0 0 0 0\n"
"TimerEvent 219 205 0 0 0 0 0\n"
"MouseMoveEvent 218 207 0 0 0 0 0\n"
"TimerEvent 218 207 0 0 0 0 0\n"
"MouseMoveEvent 217 208 0 0 0 0 0\n"
"MouseMoveEvent 216 208 0 0 0 0 0\n"
"MouseMoveEvent 214 208 0 0 0 0 0\n"
"MouseMoveEvent 212 208 0 0 0 0 0\n"
"MouseMoveEvent 210 207 0 0 0 0 0\n"
"MouseMoveEvent 209 206 0 0 0 0 0\n"
"TimerEvent 209 206 0 0 0 0 0\n"
"MouseMoveEvent 207 205 0 0 0 0 0\n"
"MouseMoveEvent 205 203 0 0 0 0 0\n"
"MouseMoveEvent 203 201 0 0 0 0 0\n"
"MouseMoveEvent 201 199 0 0 0 0 0\n"
"MouseMoveEvent 200 198 0 0 0 0 0\n"
"MouseMoveEvent 198 196 0 0 0 0 0\n"
"TimerEvent 198 196 0 0 0 0 0\n"
"MouseMoveEvent 197 195 0 0 0 0 0\n"
"MouseMoveEvent 196 194 0 0 0 0 0\n"
"TimerEvent 196 194 0 0 0 0 0\n"
"MouseMoveEvent 195 193 0 0 0 0 0\n"
"MouseMoveEvent 195 192 0 0 0 0 0\n"
"MouseMoveEvent 194 190 0 0 0 0 0\n"
"MouseMoveEvent 193 189 0 0 0 0 0\n"
"MouseMoveEvent 192 187 0 0 0 0 0\n"
"MouseMoveEvent 192 186 0 0 0 0 0\n"
"TimerEvent 192 186 0 0 0 0 0\n"
"MouseMoveEvent 191 185 0 0 0 0 0\n"
"MouseMoveEvent 189 182 0 0 0 0 0\n"
"MouseMoveEvent 188 181 0 0 0 0 0\n"
"MouseMoveEvent 187 179 0 0 0 0 0\n"
"MouseMoveEvent 186 178 0 0 0 0 0\n"
"MouseMoveEvent 185 175 0 0 0 0 0\n"
"TimerEvent 185 175 0 0 0 0 0\n"
"MouseMoveEvent 184 172 0 0 0 0 0\n"
"MouseMoveEvent 182 168 0 0 0 0 0\n"
"MouseMoveEvent 181 166 0 0 0 0 0\n"
"MouseMoveEvent 180 162 0 0 0 0 0\n"
"MouseMoveEvent 178 159 0 0 0 0 0\n"
"MouseMoveEvent 176 156 0 0 0 0 0\n"
"TimerEvent 176 156 0 0 0 0 0\n"
"MouseMoveEvent 174 153 0 0 0 0 0\n"
"MouseMoveEvent 173 150 0 0 0 0 0\n"
"MouseMoveEvent 172 148 0 0 0 0 0\n"
"MouseMoveEvent 171 147 0 0 0 0 0\n"
"MouseMoveEvent 170 145 0 0 0 0 0\n"
"MouseMoveEvent 169 143 0 0 0 0 0\n"
"TimerEvent 169 143 0 0 0 0 0\n"
"MouseMoveEvent 169 142 0 0 0 0 0\n"
"MouseMoveEvent 168 139 0 0 0 0 0\n"
"MouseMoveEvent 167 138 0 0 0 0 0\n"
"MouseMoveEvent 167 137 0 0 0 0 0\n"
"TimerEvent 167 137 0 0 0 0 0\n"
"MouseMoveEvent 167 136 0 0 0 0 0\n"
"MouseMoveEvent 166 135 0 0 0 0 0\n"
"MouseMoveEvent 166 134 0 0 0 0 0\n"
"MouseMoveEvent 165 132 0 0 0 0 0\n"
"TimerEvent 165 132 0 0 0 0 0\n"
"MouseMoveEvent 165 131 0 0 0 0 0\n"
"MouseMoveEvent 164 129 0 0 0 0 0\n"
"MouseMoveEvent 164 127 0 0 0 0 0\n"
"MouseMoveEvent 163 125 0 0 0 0 0\n"
"MouseMoveEvent 162 123 0 0 0 0 0\n"
"MouseMoveEvent 161 122 0 0 0 0 0\n"
"TimerEvent 161 122 0 0 0 0 0\n"
"MouseMoveEvent 160 120 0 0 0 0 0\n"
"MouseMoveEvent 160 119 0 0 0 0 0\n"
"MouseMoveEvent 158 116 0 0 0 0 0\n"
"MouseMoveEvent 157 114 0 0 0 0 0\n"
"MouseMoveEvent 156 112 0 0 0 0 0\n"
"MouseMoveEvent 154 109 0 0 0 0 0\n"
"TimerEvent 154 109 0 0 0 0 0\n"
"MouseMoveEvent 153 107 0 0 0 0 0\n"
"MouseMoveEvent 152 105 0 0 0 0 0\n"
"MouseMoveEvent 151 103 0 0 0 0 0\n"
"MouseMoveEvent 151 102 0 0 0 0 0\n"
"MouseMoveEvent 150 101 0 0 0 0 0\n"
"TimerEvent 150 101 0 0 0 0 0\n"
"MouseMoveEvent 150 100 0 0 0 0 0\n"
"MouseMoveEvent 149 98 0 0 0 0 0\n"
"MouseMoveEvent 149 97 0 0 0 0 0\n"
"TimerEvent 149 97 0 0 0 0 0\n"
"MouseMoveEvent 148 96 0 0 0 0 0\n"
"MouseMoveEvent 147 94 0 0 0 0 0\n"
"TimerEvent 147 94 0 0 0 0 0\n"
"MouseMoveEvent 146 93 0 0 0 0 0\n"
"MouseMoveEvent 145 92 0 0 0 0 0\n"
"TimerEvent 145 92 0 0 0 0 0\n"
"MouseMoveEvent 144 91 0 0 0 0 0\n"
"MouseMoveEvent 143 90 0 0 0 0 0\n"
"MouseMoveEvent 142 90 0 0 0 0 0\n"
"MouseMoveEvent 141 90 0 0 0 0 0\n"
"TimerEvent 141 90 0 0 0 0 0\n"
"MouseMoveEvent 140 90 0 0 0 0 0\n"
"MouseMoveEvent 139 91 0 0 0 0 0\n"
"MouseMoveEvent 137 92 0 0 0 0 0\n"
"MouseMoveEvent 136 92 0 0 0 0 0\n"
"MouseMoveEvent 135 93 0 0 0 0 0\n"
"MouseMoveEvent 132 94 0 0 0 0 0\n"
"TimerEvent 132 94 0 0 0 0 0\n"
"MouseMoveEvent 131 95 0 0 0 0 0\n"
"MouseMoveEvent 130 96 0 0 0 0 0\n"
"MouseMoveEvent 128 98 0 0 0 0 0\n"
"MouseMoveEvent 128 100 0 0 0 0 0\n"
"MouseMoveEvent 127 102 0 0 0 0 0\n"
"TimerEvent 127 102 0 0 0 0 0\n"
"MouseMoveEvent 127 103 0 0 0 0 0\n"
"MouseMoveEvent 127 104 0 0 0 0 0\n"
"MouseMoveEvent 127 106 0 0 0 0 0\n"
"MouseMoveEvent 127 107 0 0 0 0 0\n"
"MouseMoveEvent 127 108 0 0 0 0 0\n"
"MouseMoveEvent 127 109 0 0 0 0 0\n"
"TimerEvent 127 109 0 0 0 0 0\n"
"MouseMoveEvent 127 110 0 0 0 0 0\n"
"MouseMoveEvent 127 111 0 0 0 0 0\n"
"MouseMoveEvent 127 112 0 0 0 0 0\n"
"MouseMoveEvent 127 114 0 0 0 0 0\n"
"MouseMoveEvent 127 115 0 0 0 0 0\n"
"TimerEvent 127 115 0 0 0 0 0\n"
"MouseMoveEvent 127 116 0 0 0 0 0\n"
"MouseMoveEvent 127 118 0 0 0 0 0\n"
"MouseMoveEvent 128 119 0 0 0 0 0\n"
"TimerEvent 128 119 0 0 0 0 0\n"
"MouseMoveEvent 128 120 0 0 0 0 0\n"
"MouseMoveEvent 129 121 0 0 0 0 0\n"
"TimerEvent 129 121 0 0 0 0 0\n"
"MouseMoveEvent 129 122 0 0 0 0 0\n"
"MouseMoveEvent 129 123 0 0 0 0 0\n"
"MouseMoveEvent 129 125 0 0 0 0 0\n"
"MouseMoveEvent 129 126 0 0 0 0 0\n"
"MouseMoveEvent 129 128 0 0 0 0 0\n"
"MouseMoveEvent 129 130 0 0 0 0 0\n"
"TimerEvent 129 130 0 0 0 0 0\n"
"MouseMoveEvent 130 132 0 0 0 0 0\n"
"MouseMoveEvent 130 134 0 0 0 0 0\n"
"MouseMoveEvent 131 136 0 0 0 0 0\n"
"MouseMoveEvent 131 139 0 0 0 0 0\n"
"MouseMoveEvent 132 142 0 0 0 0 0\n"
"MouseMoveEvent 132 144 0 0 0 0 0\n"
"TimerEvent 132 144 0 0 0 0 0\n"
"MouseMoveEvent 132 146 0 0 0 0 0\n"
"MouseMoveEvent 133 148 0 0 0 0 0\n"
"MouseMoveEvent 133 149 0 0 0 0 0\n"
"MouseMoveEvent 133 151 0 0 0 0 0\n"
"MouseMoveEvent 133 153 0 0 0 0 0\n"
"MouseMoveEvent 133 154 0 0 0 0 0\n"
"TimerEvent 133 154 0 0 0 0 0\n"
"MouseMoveEvent 133 156 0 0 0 0 0\n"
"MouseMoveEvent 133 159 0 0 0 0 0\n"
"MouseMoveEvent 133 161 0 0 0 0 0\n"
"MouseMoveEvent 134 163 0 0 0 0 0\n"
"MouseMoveEvent 134 164 0 0 0 0 0\n"
"MouseMoveEvent 135 166 0 0 0 0 0\n"
"TimerEvent 135 166 0 0 0 0 0\n"
"MouseMoveEvent 135 167 0 0 0 0 0\n"
"MouseMoveEvent 135 168 0 0 0 0 0\n"
"MouseMoveEvent 136 169 0 0 0 0 0\n"
"MouseMoveEvent 136 170 0 0 0 0 0\n"
"TimerEvent 136 170 0 0 0 0 0\n"
"MouseMoveEvent 136 171 0 0 0 0 0\n"
"MouseMoveEvent 137 172 0 0 0 0 0\n"
"MouseMoveEvent 138 173 0 0 0 0 0\n"
"MouseMoveEvent 139 175 0 0 0 0 0\n"
"TimerEvent 139 175 0 0 0 0 0\n"
"MouseMoveEvent 140 176 0 0 0 0 0\n"
"MouseMoveEvent 141 177 0 0 0 0 0\n"
"MouseMoveEvent 142 179 0 0 0 0 0\n"
"TimerEvent 142 179 0 0 0 0 0\n"
"MouseMoveEvent 144 181 0 0 0 0 0\n"
"MouseMoveEvent 145 183 0 0 0 0 0\n"
"MouseMoveEvent 147 185 0 0 0 0 0\n"
"MouseMoveEvent 148 186 0 0 0 0 0\n"
"MouseMoveEvent 149 187 0 0 0 0 0\n"
"MouseMoveEvent 150 189 0 0 0 0 0\n"
"TimerEvent 150 189 0 0 0 0 0\n"
"MouseMoveEvent 151 190 0 0 0 0 0\n"
"MouseMoveEvent 152 192 0 0 0 0 0\n"
"MouseMoveEvent 153 193 0 0 0 0 0\n"
"MouseMoveEvent 154 195 0 0 0 0 0\n"
"TimerEvent 154 195 0 0 0 0 0\n"
"MouseMoveEvent 154 196 0 0 0 0 0\n"
"MouseMoveEvent 155 197 0 0 0 0 0\n"
"MouseMoveEvent 157 200 0 0 0 0 0\n"
"MouseMoveEvent 157 202 0 0 0 0 0\n"
"MouseMoveEvent 158 203 0 0 0 0 0\n"
"MouseMoveEvent 159 204 0 0 0 0 0\n"
"TimerEvent 159 204 0 0 0 0 0\n"
"MouseMoveEvent 159 205 0 0 0 0 0\n"
"MouseMoveEvent 159 206 0 0 0 0 0\n"
"MouseMoveEvent 160 207 0 0 0 0 0\n"
"MouseMoveEvent 161 210 0 0 0 0 0\n"
"MouseMoveEvent 162 211 0 0 0 0 0\n"
"TimerEvent 162 211 0 0 0 0 0\n"
"MouseMoveEvent 163 213 0 0 0 0 0\n"
"MouseMoveEvent 164 214 0 0 0 0 0\n"
"MouseMoveEvent 166 216 0 0 0 0 0\n"
"MouseMoveEvent 167 218 0 0 0 0 0\n"
"TimerEvent 167 218 0 0 0 0 0\n"
"MouseMoveEvent 168 219 0 0 0 0 0\n"
"MouseMoveEvent 169 220 0 0 0 0 0\n"
"MouseMoveEvent 170 222 0 0 0 0 0\n"
"MouseMoveEvent 172 224 0 0 0 0 0\n"
"MouseMoveEvent 173 225 0 0 0 0 0\n"
"MouseMoveEvent 174 226 0 0 0 0 0\n"
"TimerEvent 174 226 0 0 0 0 0\n"
"MouseMoveEvent 175 227 0 0 0 0 0\n"
"MouseMoveEvent 176 228 0 0 0 0 0\n"
"TimerEvent 176 228 0 0 0 0 0\n"
"MouseMoveEvent 176 229 0 0 0 0 0\n"
"MouseMoveEvent 176 230 0 0 0 0 0\n"
"MouseMoveEvent 177 231 0 0 0 0 0\n"
"MouseMoveEvent 177 232 0 0 0 0 0\n"
"TimerEvent 177 232 0 0 0 0 0\n"
"MouseMoveEvent 178 233 0 0 0 0 0\n"
"MouseMoveEvent 179 234 0 0 0 0 0\n"
"TimerEvent 179 234 0 0 0 0 0\n"
"MouseMoveEvent 180 235 0 0 0 0 0\n"
"MouseMoveEvent 181 236 0 0 0 0 0\n"
"TimerEvent 181 236 0 0 0 0 0\n"
"MouseMoveEvent 182 237 0 0 0 0 0\n"
"TimerEvent 182 237 0 0 0 0 0\n"
"MouseMoveEvent 183 238 0 0 0 0 0\n"
"TimerEvent 183 238 0 0 0 0 0\n"
"MouseMoveEvent 185 238 0 0 0 0 0\n"
"MouseMoveEvent 186 238 0 0 0 0 0\n"
"TimerEvent 186 238 0 0 0 0 0\n"
"MouseMoveEvent 187 237 0 0 0 0 0\n"
"MouseMoveEvent 187 236 0 0 0 0 0\n"
"MouseMoveEvent 187 235 0 0 0 0 0\n"
"MouseMoveEvent 186 234 0 0 0 0 0\n"
"TimerEvent 186 234 0 0 0 0 0\n"
"MouseMoveEvent 185 232 0 0 0 0 0\n"
"MouseMoveEvent 185 231 0 0 0 0 0\n"
"MouseMoveEvent 185 230 0 0 0 0 0\n"
"MouseMoveEvent 185 229 0 0 0 0 0\n"
"TimerEvent 185 229 0 0 0 0 0\n"
"MouseMoveEvent 185 228 0 0 0 0 0\n"
"MouseMoveEvent 185 227 0 0 0 0 0\n"
"MouseMoveEvent 185 225 0 0 0 0 0\n"
"MouseMoveEvent 185 224 0 0 0 0 0\n"
"TimerEvent 185 224 0 0 0 0 0\n"
"MouseMoveEvent 185 223 0 0 0 0 0\n"
"MouseMoveEvent 185 222 0 0 0 0 0\n"
"MouseMoveEvent 185 220 0 0 0 0 0\n"
"MouseMoveEvent 185 219 0 0 0 0 0\n"
"MouseMoveEvent 186 217 0 0 0 0 0\n"
"MouseMoveEvent 188 214 0 0 0 0 0\n"
"TimerEvent 188 214 0 0 0 0 0\n"
"MouseMoveEvent 190 211 0 0 0 0 0\n"
"MouseMoveEvent 192 208 0 0 0 0 0\n"
"MouseMoveEvent 194 206 0 0 0 0 0\n"
"MouseMoveEvent 197 203 0 0 0 0 0\n"
"MouseMoveEvent 201 200 0 0 0 0 0\n"
"MouseMoveEvent 204 196 0 0 0 0 0\n"
"TimerEvent 204 196 0 0 0 0 0\n"
"MouseMoveEvent 208 192 0 0 0 0 0\n"
"MouseMoveEvent 214 188 0 0 0 0 0\n"
"MouseMoveEvent 219 184 0 0 0 0 0\n"
"MouseMoveEvent 225 180 0 0 0 0 0\n"
"MouseMoveEvent 230 176 0 0 0 0 0\n"
"MouseMoveEvent 232 175 0 0 0 0 0\n"
"TimerEvent 232 175 0 0 0 0 0\n"
"MouseMoveEvent 233 174 0 0 0 0 0\n"
"MouseMoveEvent 235 172 0 0 0 0 0\n"
"MouseMoveEvent 237 170 0 0 0 0 0\n"
"MouseMoveEvent 239 169 0 0 0 0 0\n"
"MouseMoveEvent 241 167 0 0 0 0 0\n"
"MouseMoveEvent 243 165 0 0 0 0 0\n"
"TimerEvent 243 165 0 0 0 0 0\n"
"MouseMoveEvent 246 163 0 0 0 0 0\n"
"MouseMoveEvent 249 161 0 0 0 0 0\n"
"MouseMoveEvent 252 158 0 0 0 0 0\n"
"MouseMoveEvent 254 156 0 0 0 0 0\n"
"MouseMoveEvent 257 154 0 0 0 0 0\n"
"MouseMoveEvent 259 152 0 0 0 0 0\n"
"TimerEvent 259 152 0 0 0 0 0\n"
"MouseMoveEvent 261 150 0 0 0 0 0\n"
"MouseMoveEvent 263 148 0 0 0 0 0\n"
"MouseMoveEvent 267 145 0 0 0 0 0\n"
"MouseMoveEvent 270 143 0 0 0 0 0\n"
"MouseMoveEvent 273 140 0 0 0 0 0\n"
"MouseMoveEvent 278 136 0 0 0 0 0\n"
"TimerEvent 278 136 0 0 0 0 0\n"
"MouseMoveEvent 279 135 0 0 0 0 0\n"
"TimerEvent 279 135 0 0 0 0 0\n"
"LeftButtonPressEvent 279 135 0 0 0 0 0\n"
"MouseMoveEvent 278 135 0 0 0 0 0\n"
"MouseMoveEvent 277 135 0 0 0 0 0\n"
"MouseMoveEvent 275 135 0 0 0 0 0\n"
"MouseMoveEvent 272 136 0 0 0 0 0\n"
"MouseMoveEvent 269 137 0 0 0 0 0\n"
"MouseMoveEvent 265 139 0 0 0 0 0\n"
"TimerEvent 265 139 0 0 0 0 0\n"
"MouseMoveEvent 261 139 0 0 0 0 0\n"
"MouseMoveEvent 257 141 0 0 0 0 0\n"
"MouseMoveEvent 253 142 0 0 0 0 0\n"
"MouseMoveEvent 247 143 0 0 0 0 0\n"
"MouseMoveEvent 242 145 0 0 0 0 0\n"
"MouseMoveEvent 237 145 0 0 0 0 0\n"
"TimerEvent 237 145 0 0 0 0 0\n"
"MouseMoveEvent 235 146 0 0 0 0 0\n"
"MouseMoveEvent 232 147 0 0 0 0 0\n"
"MouseMoveEvent 230 148 0 0 0 0 0\n"
"MouseMoveEvent 227 148 0 0 0 0 0\n"
"MouseMoveEvent 224 149 0 0 0 0 0\n"
"TimerEvent 224 149 0 0 0 0 0\n"
"MouseMoveEvent 221 151 0 0 0 0 0\n"
"MouseMoveEvent 217 152 0 0 0 0 0\n"
"MouseMoveEvent 213 154 0 0 0 0 0\n"
"MouseMoveEvent 210 156 0 0 0 0 0\n"
"MouseMoveEvent 208 157 0 0 0 0 0\n"
"MouseMoveEvent 205 158 0 0 0 0 0\n"
"TimerEvent 205 158 0 0 0 0 0\n"
"MouseMoveEvent 203 159 0 0 0 0 0\n"
"MouseMoveEvent 202 159 0 0 0 0 0\n"
"MouseMoveEvent 200 160 0 0 0 0 0\n"
"MouseMoveEvent 199 160 0 0 0 0 0\n"
"MouseMoveEvent 198 161 0 0 0 0 0\n"
"MouseMoveEvent 196 161 0 0 0 0 0\n"
"TimerEvent 196 161 0 0 0 0 0\n"
"MouseMoveEvent 195 161 0 0 0 0 0\n"
"MouseMoveEvent 194 162 0 0 0 0 0\n"
"MouseMoveEvent 192 162 0 0 0 0 0\n"
"MouseMoveEvent 191 163 0 0 0 0 0\n"
"TimerEvent 191 163 0 0 0 0 0\n"
"MouseMoveEvent 190 163 0 0 0 0 0\n"
"MouseMoveEvent 189 163 0 0 0 0 0\n"
"MouseMoveEvent 188 163 0 0 0 0 0\n"
"MouseMoveEvent 187 163 0 0 0 0 0\n"
"TimerEvent 187 163 0 0 0 0 0\n"
"MouseMoveEvent 186 163 0 0 0 0 0\n"
"MouseMoveEvent 185 163 0 0 0 0 0\n"
"MouseMoveEvent 184 163 0 0 0 0 0\n"
"TimerEvent 184 163 0 0 0 0 0\n"
"LeftButtonReleaseEvent 184 163 0 0 0 0 0\n"
"MouseMoveEvent 183 164 0 0 0 0 0\n"
"MouseMoveEvent 185 166 0 0 0 0 0\n"
"MouseMoveEvent 185 167 0 0 0 0 0\n"
"MouseMoveEvent 186 169 0 0 0 0 0\n"
"TimerEvent 186 169 0 0 0 0 0\n"
"MouseMoveEvent 187 171 0 0 0 0 0\n"
"TimerEvent 187 171 0 0 0 0 0\n"
"MouseWheelBackwardEvent 187 171 0 0 0 0 0\n"
"TimerEvent 187 171 0 0 0 0 0\n"
"MouseWheelBackwardEvent 187 171 0 0 0 1 0\n"
"TimerEvent 187 171 0 0 0 0 0\n"
"MouseWheelBackwardEvent 187 171 0 0 0 0 0\n"
"TimerEvent 187 171 0 0 0 0 0\n"
"MouseMoveEvent 187 172 0 0 0 0 0\n"
"MouseMoveEvent 187 173 0 0 0 0 0\n"
"MouseMoveEvent 187 174 0 0 0 0 0\n"
"MouseMoveEvent 187 175 0 0 0 0 0\n"
"MouseMoveEvent 188 177 0 0 0 0 0\n"
"TimerEvent 188 177 0 0 0 0 0\n"
"MouseMoveEvent 188 178 0 0 0 0 0\n"
"MouseMoveEvent 189 179 0 0 0 0 0\n"
"MouseMoveEvent 189 180 0 0 0 0 0\n"
"MouseMoveEvent 190 181 0 0 0 0 0\n"
"TimerEvent 190 181 0 0 0 0 0\n"
"MouseMoveEvent 190 182 0 0 0 0 0\n"
"MouseMoveEvent 191 183 0 0 0 0 0\n"
"MouseMoveEvent 191 184 0 0 0 0 0\n"
"TimerEvent 191 184 0 0 0 0 0\n"
"MouseMoveEvent 192 186 0 0 0 0 0\n"
"MouseMoveEvent 192 187 0 0 0 0 0\n"
"MouseMoveEvent 192 188 0 0 0 0 0\n"
"TimerEvent 192 188 0 0 0 0 0\n"
"MouseMoveEvent 192 189 0 0 0 0 0\n"
"MouseMoveEvent 192 190 0 0 0 0 0\n"
"MouseMoveEvent 192 191 0 0 0 0 0\n"
"TimerEvent 192 191 0 0 0 0 0\n"
"MouseMoveEvent 192 192 0 0 0 0 0\n"
"TimerEvent 192 192 0 0 0 0 0\n"
"MouseMoveEvent 193 193 0 0 0 0 0\n"
"MouseMoveEvent 193 192 0 0 0 0 0\n"
"TimerEvent 193 192 0 0 0 0 0\n"
"MouseMoveEvent 194 191 0 0 0 0 0\n"
"MouseMoveEvent 194 189 0 0 0 0 0\n"
"MouseMoveEvent 194 188 0 0 0 0 0\n"
"MouseMoveEvent 194 186 0 0 0 0 0\n"
"MouseMoveEvent 194 185 0 0 0 0 0\n"
"MouseMoveEvent 194 184 0 0 0 0 0\n"
"TimerEvent 194 184 0 0 0 0 0\n"
"MouseMoveEvent 194 183 0 0 0 0 0\n"
"MouseMoveEvent 194 182 0 0 0 0 0\n"
"MouseMoveEvent 194 181 0 0 0 0 0\n"
"MouseMoveEvent 194 180 0 0 0 0 0\n"
"TimerEvent 194 180 0 0 0 0 0\n"
"MouseMoveEvent 194 179 0 0 0 0 0\n"
"MouseMoveEvent 194 178 0 0 0 0 0\n"
"TimerEvent 194 178 0 0 0 0 0\n"
"MouseMoveEvent 194 177 0 0 0 0 0\n"
"TimerEvent 194 177 0 0 0 0 0\n"
"MouseMoveEvent 195 176 0 0 0 0 0\n"
"MouseMoveEvent 196 176 0 0 0 0 0\n"
"TimerEvent 196 176 0 0 0 0 0\n"
"MouseMoveEvent 198 174 0 0 0 0 0\n"
"MouseMoveEvent 198 173 0 0 0 0 0\n"
"MouseMoveEvent 199 172 0 0 0 0 0\n"
"MouseMoveEvent 199 171 0 0 0 0 0\n"
"MouseMoveEvent 200 170 0 0 0 0 0\n"
"TimerEvent 200 170 0 0 0 0 0\n"
"MouseMoveEvent 200 169 0 0 0 0 0\n"
"MouseMoveEvent 201 168 0 0 0 0 0\n"
"MouseMoveEvent 201 167 0 0 0 0 0\n"
"TimerEvent 201 167 0 0 0 0 0\n"
"MouseMoveEvent 202 166 0 0 0 0 0\n"
"MouseMoveEvent 203 166 0 0 0 0 0\n"
"MouseMoveEvent 206 166 0 0 0 0 0\n"
"MouseMoveEvent 209 166 0 0 0 0 0\n"
"MouseMoveEvent 211 167 0 0 0 0 0\n"
"MouseMoveEvent 213 168 0 0 0 0 0\n"
"TimerEvent 213 168 0 0 0 0 0\n"
"MouseMoveEvent 216 168 0 0 0 0 0\n"
"MouseMoveEvent 218 169 0 0 0 0 0\n"
"MouseMoveEvent 221 171 0 0 0 0 0\n"
"MouseMoveEvent 225 173 0 0 0 0 0\n"
"MouseMoveEvent 228 175 0 0 0 0 0\n"
"MouseMoveEvent 230 176 0 0 0 0 0\n"
"TimerEvent 230 176 0 0 0 0 0\n"
"MouseMoveEvent 233 178 0 0 0 0 0\n"
"MouseMoveEvent 234 179 0 0 0 0 0\n"
"MouseMoveEvent 235 180 0 0 0 0 0\n"
"MouseMoveEvent 237 181 0 0 0 0 0\n"
"TimerEvent 237 181 0 0 0 0 0\n"
"MouseMoveEvent 238 181 0 0 0 0 0\n"
"MouseMoveEvent 239 182 0 0 0 0 0\n"
"MouseMoveEvent 240 183 0 0 0 0 0\n"
"MouseMoveEvent 240 185 0 0 0 0 0\n"
"TimerEvent 240 185 0 0 0 0 0\n"
"MouseMoveEvent 240 187 0 0 0 0 0\n"
"MouseMoveEvent 240 188 0 0 0 0 0\n"
"MouseMoveEvent 240 189 0 0 0 0 0\n"
"MouseMoveEvent 240 190 0 0 0 0 0\n"
"TimerEvent 240 190 0 0 0 0 0\n"
"MouseMoveEvent 239 192 0 0 0 0 0\n"
"MouseMoveEvent 238 193 0 0 0 0 0\n"
"MouseMoveEvent 237 194 0 0 0 0 0\n"
"MouseMoveEvent 235 196 0 0 0 0 0\n"
"MouseMoveEvent 235 197 0 0 0 0 0\n"
"TimerEvent 235 197 0 0 0 0 0\n"
"MouseMoveEvent 234 199 0 0 0 0 0\n"
"MouseMoveEvent 233 201 0 0 0 0 0\n"
"MouseMoveEvent 232 203 0 0 0 0 0\n"
"MouseMoveEvent 232 204 0 0 0 0 0\n"
"MouseMoveEvent 231 207 0 0 0 0 0\n"
"MouseMoveEvent 231 208 0 0 0 0 0\n"
"TimerEvent 231 208 0 0 0 0 0\n"
"MouseMoveEvent 230 210 0 0 0 0 0\n"
"MouseMoveEvent 229 213 0 0 0 0 0\n"
"MouseMoveEvent 229 215 0 0 0 0 0\n"
"MouseMoveEvent 228 217 0 0 0 0 0\n"
"MouseMoveEvent 228 218 0 0 0 0 0\n"
"MouseMoveEvent 228 219 0 0 0 0 0\n"
"TimerEvent 228 219 0 0 0 0 0\n"
"MouseMoveEvent 227 220 0 0 0 0 0\n"
"TimerEvent 227 220 0 0 0 0 0\n"
"MouseMoveEvent 229 219 0 0 0 0 0\n"
"MouseMoveEvent 230 219 0 0 0 0 0\n"
"TimerEvent 230 219 0 0 0 0 0\n"
"MouseMoveEvent 232 218 0 0 0 0 0\n"
"MouseMoveEvent 233 217 0 0 0 0 0\n"
"MouseMoveEvent 235 216 0 0 0 0 0\n"
"MouseMoveEvent 236 215 0 0 0 0 0\n"
"MouseMoveEvent 239 214 0 0 0 0 0\n"
"TimerEvent 239 214 0 0 0 0 0\n"
"MouseMoveEvent 241 212 0 0 0 0 0\n"
"MouseMoveEvent 244 210 0 0 0 0 0\n"
"MouseMoveEvent 248 207 0 0 0 0 0\n"
"MouseMoveEvent 254 203 0 0 0 0 0\n"
"MouseMoveEvent 261 199 0 0 0 0 0\n"
"MouseMoveEvent 267 195 0 0 0 0 0\n"
"TimerEvent 267 195 0 0 0 0 0\n"
"MouseMoveEvent 270 193 0 0 0 0 0\n"
"MouseMoveEvent 271 192 0 0 0 0 0\n"
"TimerEvent 271 192 0 0 0 0 0\n"
"MouseMoveEvent 273 190 0 0 0 0 0\n"
"MouseMoveEvent 275 188 0 0 0 0 0\n"
"MouseMoveEvent 277 186 0 0 0 0 0\n"
"MouseMoveEvent 280 184 0 0 0 0 0\n"
"MouseMoveEvent 284 180 0 0 0 0 0\n"
"MouseMoveEvent 285 179 0 0 0 0 0\n"
"TimerEvent 285 179 0 0 0 0 0\n"
"MouseMoveEvent 286 178 0 0 0 0 0\n"
"TimerEvent 286 178 0 0 0 0 0\n"
"LeftButtonPressEvent 286 178 0 0 0 0 0\n"
"MouseMoveEvent 285 178 0 0 0 0 0\n"
"MouseMoveEvent 283 178 0 0 0 0 0\n"
"MouseMoveEvent 282 178 0 0 0 0 0\n"
"MouseMoveEvent 281 178 0 0 0 0 0\n"
"MouseMoveEvent 279 178 0 0 0 0 0\n"
"TimerEvent 279 178 0 0 0 0 0\n"
"MouseMoveEvent 278 178 0 0 0 0 0\n"
"MouseMoveEvent 276 178 0 0 0 0 0\n"
"MouseMoveEvent 274 178 0 0 0 0 0\n"
"MouseMoveEvent 272 178 0 0 0 0 0\n"
"MouseMoveEvent 270 178 0 0 0 0 0\n"
"MouseMoveEvent 269 178 0 0 0 0 0\n"
"TimerEvent 269 178 0 0 0 0 0\n"
"MouseMoveEvent 268 178 0 0 0 0 0\n"
"MouseMoveEvent 267 178 0 0 0 0 0\n"
"MouseMoveEvent 265 178 0 0 0 0 0\n"
"MouseMoveEvent 264 178 0 0 0 0 0\n"
"MouseMoveEvent 263 178 0 0 0 0 0\n"
"MouseMoveEvent 260 178 0 0 0 0 0\n"
"TimerEvent 260 178 0 0 0 0 0\n"
"MouseMoveEvent 257 178 0 0 0 0 0\n"
"MouseMoveEvent 254 178 0 0 0 0 0\n"
"MouseMoveEvent 251 178 0 0 0 0 0\n"
"MouseMoveEvent 248 178 0 0 0 0 0\n"
"MouseMoveEvent 246 178 0 0 0 0 0\n"
"MouseMoveEvent 244 178 0 0 0 0 0\n"
"TimerEvent 244 178 0 0 0 0 0\n"
"MouseMoveEvent 243 178 0 0 0 0 0\n"
"MouseMoveEvent 242 178 0 0 0 0 0\n"
"MouseMoveEvent 240 178 0 0 0 0 0\n"
"TimerEvent 240 178 0 0 0 0 0\n"
"MouseMoveEvent 239 178 0 0 0 0 0\n"
"MouseMoveEvent 236 177 0 0 0 0 0\n"
"MouseMoveEvent 233 177 0 0 0 0 0\n"
"MouseMoveEvent 229 177 0 0 0 0 0\n"
"MouseMoveEvent 224 177 0 0 0 0 0\n"
"MouseMoveEvent 217 177 0 0 0 0 0\n"
"TimerEvent 217 177 0 0 0 0 0\n"
"MouseMoveEvent 212 176 0 0 0 0 0\n"
"MouseMoveEvent 209 176 0 0 0 0 0\n"
"MouseMoveEvent 207 176 0 0 0 0 0\n"
"MouseMoveEvent 205 176 0 0 0 0 0\n"
"MouseMoveEvent 204 176 0 0 0 0 0\n"
"TimerEvent 204 176 0 0 0 0 0\n"
"MouseMoveEvent 203 176 0 0 0 0 0\n"
"MouseMoveEvent 202 176 0 0 0 0 0\n"
"MouseMoveEvent 201 176 0 0 0 0 0\n"
"TimerEvent 201 176 0 0 0 0 0\n"
"MouseMoveEvent 200 176 0 0 0 0 0\n"
"MouseMoveEvent 199 176 0 0 0 0 0\n"
"MouseMoveEvent 198 176 0 0 0 0 0\n"
"MouseMoveEvent 197 176 0 0 0 0 0\n"
"MouseMoveEvent 195 177 0 0 0 0 0\n"
"TimerEvent 195 177 0 0 0 0 0\n"
"MouseMoveEvent 194 177 0 0 0 0 0\n"
"TimerEvent 194 177 0 0 0 0 0\n"
"LeftButtonReleaseEvent 194 177 0 0 0 0 0\n"
"MouseMoveEvent 193 178 0 0 0 0 0\n"
"MouseMoveEvent 194 180 0 0 0 0 0\n"
"MouseMoveEvent 195 181 0 0 0 0 0\n"
"MouseMoveEvent 196 183 0 0 0 0 0\n"
"TimerEvent 196 183 0 0 0 0 0\n"
"MouseMoveEvent 197 184 0 0 0 0 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseWheelBackwardEvent 197 184 0 0 0 0 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseWheelBackwardEvent 197 184 0 0 0 1 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseWheelForwardEvent 197 184 0 0 0 0 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseWheelForwardEvent 197 184 0 0 0 1 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseWheelForwardEvent 197 184 0 0 0 0 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseWheelForwardEvent 197 184 0 0 0 1 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseWheelForwardEvent 197 184 0 0 0 0 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseWheelForwardEvent 197 184 0 0 0 1 0\n"
"TimerEvent 197 184 0 0 0 0 0\n"
"MouseMoveEvent 198 184 0 0 0 0 0\n"
"MouseMoveEvent 199 184 0 0 0 0 0\n"
"MouseMoveEvent 203 184 0 0 0 0 0\n"
"MouseMoveEvent 205 184 0 0 0 0 0\n"
"MouseMoveEvent 208 186 0 0 0 0 0\n"
"MouseMoveEvent 210 186 0 0 0 0 0\n"
"TimerEvent 210 186 0 0 0 0 0\n"
"MouseMoveEvent 213 187 0 0 0 0 0\n"
"MouseMoveEvent 219 188 0 0 0 0 0\n"
"MouseMoveEvent 232 191 0 0 0 0 0\n"
"MouseMoveEvent 248 193 0 0 0 0 0\n"
"MouseMoveEvent 261 195 0 0 0 0 0\n"
"MouseMoveEvent 271 196 0 0 0 0 0\n"
"TimerEvent 271 196 0 0 0 0 0\n"
"MouseMoveEvent 275 196 0 0 0 0 0\n"
"MouseMoveEvent 276 197 0 0 0 0 0\n"
"MouseMoveEvent 279 198 0 0 0 0 0\n"
"MouseMoveEvent 280 199 0 0 0 0 0\n"
"TimerEvent 280 199 0 0 0 0 0\n"
"MouseMoveEvent 281 200 0 0 0 0 0\n"
"MouseMoveEvent 281 201 0 0 0 0 0\n"
"MouseMoveEvent 281 202 0 0 0 0 0\n"
"MouseMoveEvent 280 204 0 0 0 0 0\n"
"TimerEvent 280 204 0 0 0 0 0\n"
"MouseMoveEvent 279 205 0 0 0 0 0\n"
"MouseMoveEvent 276 206 0 0 0 0 0\n"
"MouseMoveEvent 274 206 0 0 0 0 0\n"
"MouseMoveEvent 271 208 0 0 0 0 0\n"
"MouseMoveEvent 269 209 0 0 0 0 0\n"
"MouseMoveEvent 266 210 0 0 0 0 0\n"
"TimerEvent 266 210 0 0 0 0 0\n"
"MouseMoveEvent 263 212 0 0 0 0 0\n"
"MouseMoveEvent 262 213 0 0 0 0 0\n"
"MouseMoveEvent 261 214 0 0 0 0 0\n"
"MouseMoveEvent 260 215 0 0 0 0 0\n"
"MouseMoveEvent 259 216 0 0 0 0 0\n"
"MouseMoveEvent 257 218 0 0 0 0 0\n"
"TimerEvent 257 218 0 0 0 0 0\n"
"MouseMoveEvent 256 219 0 0 0 0 0\n"
"MouseMoveEvent 256 220 0 0 0 0 0\n"
"MouseMoveEvent 255 221 0 0 0 0 0\n"
"TimerEvent 255 221 0 0 0 0 0\n"
"LeftButtonPressEvent 255 221 0 0 0 0 0\n"
"MouseMoveEvent 254 222 0 0 0 0 0\n"
"MouseMoveEvent 254 220 0 0 0 0 0\n"
"MouseMoveEvent 254 215 0 0 0 0 0\n"
"MouseMoveEvent 254 207 0 0 0 0 0\n"
"MouseMoveEvent 254 195 0 0 0 0 0\n"
"MouseMoveEvent 254 183 0 0 0 0 0\n"
"TimerEvent 254 183 0 0 0 0 0\n"
"MouseMoveEvent 254 172 0 0 0 0 0\n"
"MouseMoveEvent 254 162 0 0 0 0 0\n"
"MouseMoveEvent 254 151 0 0 0 0 0\n"
"MouseMoveEvent 254 140 0 0 0 0 0\n"
"MouseMoveEvent 254 130 0 0 0 0 0\n"
"MouseMoveEvent 254 117 0 0 0 0 0\n"
"TimerEvent 254 117 0 0 0 0 0\n"
"MouseMoveEvent 254 104 0 0 0 0 0\n"
"MouseMoveEvent 254 92 0 0 0 0 0\n"
"MouseMoveEvent 254 79 0 0 0 0 0\n"
"MouseMoveEvent 254 68 0 0 0 0 0\n"
"MouseMoveEvent 254 57 0 0 0 0 0\n"
"MouseMoveEvent 254 51 0 0 0 0 0\n"
"TimerEvent 254 51 0 0 0 0 0\n"
"MouseMoveEvent 254 46 0 0 0 0 0\n"
"MouseMoveEvent 254 43 0 0 0 0 0\n"
"MouseMoveEvent 254 41 0 0 0 0 0\n"
"MouseMoveEvent 254 40 0 0 0 0 0\n"
"MouseMoveEvent 254 39 0 0 0 0 0\n"
"MouseMoveEvent 254 38 0 0 0 0 0\n"
"TimerEvent 254 38 0 0 0 0 0\n"
"MouseMoveEvent 254 37 0 0 0 0 0\n"
"MouseMoveEvent 254 36 0 0 0 0 0\n"
"MouseMoveEvent 254 35 0 0 0 0 0\n"
"MouseMoveEvent 254 34 0 0 0 0 0\n"
"TimerEvent 254 34 0 0 0 0 0\n"
"MouseMoveEvent 254 33 0 0 0 0 0\n"
"MouseMoveEvent 254 32 0 0 0 0 0\n"
"TimerEvent 254 32 0 0 0 0 0\n"
"MouseMoveEvent 254 34 0 0 0 0 0\n"
"MouseMoveEvent 254 37 0 0 0 0 0\n"
"MouseMoveEvent 254 40 0 0 0 0 0\n"
"MouseMoveEvent 254 44 0 0 0 0 0\n"
"MouseMoveEvent 254 50 0 0 0 0 0\n"
"MouseMoveEvent 254 52 0 0 0 0 0\n"
"TimerEvent 254 52 0 0 0 0 0\n"
"MouseMoveEvent 254 55 0 0 0 0 0\n"
"MouseMoveEvent 254 59 0 0 0 0 0\n"
"MouseMoveEvent 254 64 0 0 0 0 0\n"
"MouseMoveEvent 254 69 0 0 0 0 0\n"
"MouseMoveEvent 254 74 0 0 0 0 0\n"
"MouseMoveEvent 254 80 0 0 0 0 0\n"
"TimerEvent 254 80 0 0 0 0 0\n"
"MouseMoveEvent 254 85 0 0 0 0 0\n"
"MouseMoveEvent 254 90 0 0 0 0 0\n"
"MouseMoveEvent 254 96 0 0 0 0 0\n"
"MouseMoveEvent 254 101 0 0 0 0 0\n"
"MouseMoveEvent 253 107 0 0 0 0 0\n"
"MouseMoveEvent 251 112 0 0 0 0 0\n"
"TimerEvent 251 112 0 0 0 0 0\n"
"MouseMoveEvent 250 117 0 0 0 0 0\n"
"MouseMoveEvent 248 121 0 0 0 0 0\n"
"MouseMoveEvent 248 122 0 0 0 0 0\n"
"MouseMoveEvent 247 125 0 0 0 0 0\n"
"MouseMoveEvent 247 126 0 0 0 0 0\n"
"TimerEvent 247 126 0 0 0 0 0\n"
"MouseMoveEvent 247 127 0 0 0 0 0\n"
"MouseMoveEvent 247 128 0 0 0 0 0\n"
"MouseMoveEvent 247 130 0 0 0 0 0\n"
"MouseMoveEvent 247 131 0 0 0 0 0\n"
"MouseMoveEvent 247 133 0 0 0 0 0\n"
"MouseMoveEvent 247 135 0 0 0 0 0\n"
"TimerEvent 247 135 0 0 0 0 0\n"
"MouseMoveEvent 247 138 0 0 0 0 0\n"
"MouseMoveEvent 247 141 0 0 0 0 0\n"
"MouseMoveEvent 247 145 0 0 0 0 0\n"
"MouseMoveEvent 247 148 0 0 0 0 0\n"
"MouseMoveEvent 247 151 0 0 0 0 0\n"
"MouseMoveEvent 247 155 0 0 0 0 0\n"
"TimerEvent 247 155 0 0 0 0 0\n"
"MouseMoveEvent 247 159 0 0 0 0 0\n"
"MouseMoveEvent 247 161 0 0 0 0 0\n"
"MouseMoveEvent 247 163 0 0 0 0 0\n"
"MouseMoveEvent 246 166 0 0 0 0 0\n"
"MouseMoveEvent 246 168 0 0 0 0 0\n"
"MouseMoveEvent 246 170 0 0 0 0 0\n"
"TimerEvent 246 170 0 0 0 0 0\n"
"MouseMoveEvent 246 172 0 0 0 0 0\n"
"MouseMoveEvent 246 175 0 0 0 0 0\n"
"MouseMoveEvent 246 177 0 0 0 0 0\n"
"MouseMoveEvent 246 180 0 0 0 0 0\n"
"MouseMoveEvent 246 183 0 0 0 0 0\n"
"MouseMoveEvent 246 185 0 0 0 0 0\n"
"TimerEvent 246 185 0 0 0 0 0\n"
"MouseMoveEvent 246 187 0 0 0 0 0\n"
"MouseMoveEvent 246 189 0 0 0 0 0\n"
"MouseMoveEvent 246 192 0 0 0 0 0\n"
"MouseMoveEvent 246 194 0 0 0 0 0\n"
"MouseMoveEvent 246 196 0 0 0 0 0\n"
"MouseMoveEvent 246 198 0 0 0 0 0\n"
"TimerEvent 246 198 0 0 0 0 0\n"
"MouseMoveEvent 246 201 0 0 0 0 0\n"
"MouseMoveEvent 246 202 0 0 0 0 0\n"
"MouseMoveEvent 246 205 0 0 0 0 0\n"
"MouseMoveEvent 246 207 0 0 0 0 0\n"
"MouseMoveEvent 246 209 0 0 0 0 0\n"
"MouseMoveEvent 246 211 0 0 0 0 0\n"
"TimerEvent 246 211 0 0 0 0 0\n"
"MouseMoveEvent 246 214 0 0 0 0 0\n"
"MouseMoveEvent 246 217 0 0 0 0 0\n"
"MouseMoveEvent 246 220 0 0 0 0 0\n"
"MouseMoveEvent 246 222 0 0 0 0 0\n"
"MouseMoveEvent 245 225 0 0 0 0 0\n"
"MouseMoveEvent 245 227 0 0 0 0 0\n"
"TimerEvent 245 227 0 0 0 0 0\n"
"MouseMoveEvent 244 229 0 0 0 0 0\n"
"MouseMoveEvent 244 230 0 0 0 0 0\n"
"MouseMoveEvent 243 233 0 0 0 0 0\n"
"MouseMoveEvent 243 235 0 0 0 0 0\n"
"MouseMoveEvent 242 237 0 0 0 0 0\n"
"MouseMoveEvent 240 240 0 0 0 0 0\n"
"TimerEvent 240 240 0 0 0 0 0\n"
"MouseMoveEvent 240 242 0 0 0 0 0\n"
"MouseMoveEvent 239 244 0 0 0 0 0\n"
"MouseMoveEvent 238 245 0 0 0 0 0\n"
"MouseMoveEvent 237 247 0 0 0 0 0\n"
"MouseMoveEvent 236 248 0 0 0 0 0\n"
"MouseMoveEvent 235 250 0 0 0 0 0\n"
"TimerEvent 235 250 0 0 0 0 0\n"
"MouseMoveEvent 234 251 0 0 0 0 0\n"
"MouseMoveEvent 233 252 0 0 0 0 0\n"
"MouseMoveEvent 232 253 0 0 0 0 0\n"
"MouseMoveEvent 231 255 0 0 0 0 0\n"
"MouseMoveEvent 230 256 0 0 0 0 0\n"
"TimerEvent 230 256 0 0 0 0 0\n"
"MouseMoveEvent 229 257 0 0 0 0 0\n"
"MouseMoveEvent 228 258 0 0 0 0 0\n"
"MouseMoveEvent 227 260 0 0 0 0 0\n"
"MouseMoveEvent 226 261 0 0 0 0 0\n"
"TimerEvent 226 261 0 0 0 0 0\n"
"MouseMoveEvent 225 262 0 0 0 0 0\n"
"MouseMoveEvent 223 262 0 0 0 0 0\n"
"MouseMoveEvent 219 262 0 0 0 0 0\n"
"MouseMoveEvent 215 261 0 0 0 0 0\n"
"MouseMoveEvent 208 259 0 0 0 0 0\n"
"MouseMoveEvent 204 257 0 0 0 0 0\n"
"TimerEvent 204 257 0 0 0 0 0\n"
"MouseMoveEvent 203 256 0 0 0 0 0\n"
"TimerEvent 203 256 0 0 0 0 0\n"
"MouseMoveEvent 202 256 0 0 0 0 0\n"
"MouseMoveEvent 201 256 0 0 0 0 0\n"
"MouseMoveEvent 200 255 0 0 0 0 0\n"
"MouseMoveEvent 199 254 0 0 0 0 0\n"
"MouseMoveEvent 198 251 0 0 0 0 0\n"
"TimerEvent 198 251 0 0 0 0 0\n"
"MouseMoveEvent 196 248 0 0 0 0 0\n"
"MouseMoveEvent 193 245 0 0 0 0 0\n"
"MouseMoveEvent 189 240 0 0 0 0 0\n"
"MouseMoveEvent 185 235 0 0 0 0 0\n"
"MouseMoveEvent 178 228 0 0 0 0 0\n"
"MouseMoveEvent 170 222 0 0 0 0 0\n"
"TimerEvent 170 222 0 0 0 0 0\n"
"MouseMoveEvent 164 216 0 0 0 0 0\n"
"MouseMoveEvent 159 211 0 0 0 0 0\n"
"MouseMoveEvent 154 205 0 0 0 0 0\n"
"MouseMoveEvent 150 201 0 0 0 0 0\n"
"MouseMoveEvent 146 198 0 0 0 0 0\n"
"MouseMoveEvent 142 194 0 0 0 0 0\n"
"TimerEvent 142 194 0 0 0 0 0\n"
"MouseMoveEvent 138 189 0 0 0 0 0\n"
"MouseMoveEvent 133 185 0 0 0 0 0\n"
"MouseMoveEvent 129 177 0 0 0 0 0\n"
"MouseMoveEvent 125 173 0 0 0 0 0\n"
"MouseMoveEvent 123 169 0 0 0 0 0\n"
"MouseMoveEvent 122 165 0 0 0 0 0\n"
"TimerEvent 122 165 0 0 0 0 0\n"
"MouseMoveEvent 120 161 0 0 0 0 0\n"
"MouseMoveEvent 118 157 0 0 0 0 0\n"
"MouseMoveEvent 116 153 0 0 0 0 0\n"
"MouseMoveEvent 113 149 0 0 0 0 0\n"
"MouseMoveEvent 111 145 0 0 0 0 0\n"
"MouseMoveEvent 109 141 0 0 0 0 0\n"
"TimerEvent 109 141 0 0 0 0 0\n"
"MouseMoveEvent 102 137 0 0 0 0 0\n"
"MouseMoveEvent 98 133 0 0 0 0 0\n"
"MouseMoveEvent 94 132 0 0 0 0 0\n"
"MouseMoveEvent 93 131 0 0 0 0 0\n"
"MouseMoveEvent 90 129 0 0 0 0 0\n"
"TimerEvent 90 129 0 0 0 0 0\n"
"MouseMoveEvent 89 129 0 0 0 0 0\n"
"TimerEvent 89 129 0 0 0 0 0\n"
"MouseMoveEvent 89 133 0 0 0 0 0\n"
"MouseMoveEvent 89 137 0 0 0 0 0\n"
"MouseMoveEvent 87 141 0 0 0 0 0\n"
"MouseMoveEvent 85 144 0 0 0 0 0\n"
"TimerEvent 85 144 0 0 0 0 0\n"
"MouseMoveEvent 85 145 0 0 0 0 0\n"
"MouseMoveEvent 84 146 0 0 0 0 0\n"
"MouseMoveEvent 83 147 0 0 0 0 0\n"
"MouseMoveEvent 82 148 0 0 0 0 0\n"
"MouseMoveEvent 81 149 0 0 0 0 0\n"
"MouseMoveEvent 80 150 0 0 0 0 0\n"
"TimerEvent 80 150 0 0 0 0 0\n"
"MouseMoveEvent 79 150 0 0 0 0 0\n"
"MouseMoveEvent 78 150 0 0 0 0 0\n"
"MouseMoveEvent 76 151 0 0 0 0 0\n"
"MouseMoveEvent 74 152 0 0 0 0 0\n"
"MouseMoveEvent 73 152 0 0 0 0 0\n"
"TimerEvent 73 152 0 0 0 0 0\n"
"MouseMoveEvent 71 153 0 0 0 0 0\n"
"MouseMoveEvent 69 154 0 0 0 0 0\n"
"MouseMoveEvent 67 155 0 0 0 0 0\n"
"MouseMoveEvent 66 156 0 0 0 0 0\n"
"MouseMoveEvent 63 157 0 0 0 0 0\n"
"MouseMoveEvent 62 158 0 0 0 0 0\n"
"TimerEvent 62 158 0 0 0 0 0\n"
"MouseMoveEvent 60 159 0 0 0 0 0\n"
"MouseMoveEvent 58 160 0 0 0 0 0\n"
"MouseMoveEvent 56 162 0 0 0 0 0\n"
"MouseMoveEvent 55 163 0 0 0 0 0\n"
"MouseMoveEvent 54 164 0 0 0 0 0\n"
"MouseMoveEvent 52 166 0 0 0 0 0\n"
"TimerEvent 52 166 0 0 0 0 0\n"
"MouseMoveEvent 51 167 0 0 0 0 0\n"
"MouseMoveEvent 50 169 0 0 0 0 0\n"
"MouseMoveEvent 49 170 0 0 0 0 0\n"
"MouseMoveEvent 48 172 0 0 0 0 0\n"
"MouseMoveEvent 48 174 0 0 0 0 0\n"
"MouseMoveEvent 47 176 0 0 0 0 0\n"
"TimerEvent 47 176 0 0 0 0 0\n"
"MouseMoveEvent 47 178 0 0 0 0 0\n"
"MouseMoveEvent 47 179 0 0 0 0 0\n"
"MouseMoveEvent 47 181 0 0 0 0 0\n"
"MouseMoveEvent 47 183 0 0 0 0 0\n"
"MouseMoveEvent 47 184 0 0 0 0 0\n"
"MouseMoveEvent 47 186 0 0 0 0 0\n"
"TimerEvent 47 186 0 0 0 0 0\n"
"MouseMoveEvent 46 188 0 0 0 0 0\n"
"MouseMoveEvent 46 190 0 0 0 0 0\n"
"MouseMoveEvent 45 191 0 0 0 0 0\n"
"MouseMoveEvent 45 193 0 0 0 0 0\n"
"MouseMoveEvent 45 194 0 0 0 0 0\n"
"MouseMoveEvent 45 196 0 0 0 0 0\n"
"TimerEvent 45 196 0 0 0 0 0\n"
"MouseMoveEvent 45 197 0 0 0 0 0\n"
"MouseMoveEvent 45 198 0 0 0 0 0\n"
"MouseMoveEvent 45 199 0 0 0 0 0\n"
"MouseMoveEvent 45 200 0 0 0 0 0\n"
"TimerEvent 45 200 0 0 0 0 0\n"
"MouseMoveEvent 45 201 0 0 0 0 0\n"
"MouseMoveEvent 45 202 0 0 0 0 0\n"
"MouseMoveEvent 45 204 0 0 0 0 0\n"
"MouseMoveEvent 45 205 0 0 0 0 0\n"
"MouseMoveEvent 45 206 0 0 0 0 0\n"
"MouseMoveEvent 45 208 0 0 0 0 0\n"
"TimerEvent 45 208 0 0 0 0 0\n"
"MouseMoveEvent 45 210 0 0 0 0 0\n"
"MouseMoveEvent 45 211 0 0 0 0 0\n"
"MouseMoveEvent 45 213 0 0 0 0 0\n"
"MouseMoveEvent 45 215 0 0 0 0 0\n"
"MouseMoveEvent 46 217 0 0 0 0 0\n"
"MouseMoveEvent 47 219 0 0 0 0 0\n"
"TimerEvent 47 219 0 0 0 0 0\n"
"MouseMoveEvent 47 221 0 0 0 0 0\n"
"MouseMoveEvent 48 223 0 0 0 0 0\n"
"MouseMoveEvent 48 225 0 0 0 0 0\n"
"MouseMoveEvent 48 227 0 0 0 0 0\n"
"MouseMoveEvent 49 228 0 0 0 0 0\n"
"MouseMoveEvent 49 229 0 0 0 0 0\n"
"TimerEvent 49 229 0 0 0 0 0\n"
"MouseMoveEvent 49 230 0 0 0 0 0\n"
"MouseMoveEvent 49 231 0 0 0 0 0\n"
"MouseMoveEvent 49 232 0 0 0 0 0\n"
"MouseMoveEvent 49 234 0 0 0 0 0\n"
"MouseMoveEvent 49 235 0 0 0 0 0\n"
"MouseMoveEvent 50 236 0 0 0 0 0\n"
"TimerEvent 50 236 0 0 0 0 0\n"
"MouseMoveEvent 51 237 0 0 0 0 0\n"
"MouseMoveEvent 52 238 0 0 0 0 0\n"
"MouseMoveEvent 53 239 0 0 0 0 0\n"
"MouseMoveEvent 54 240 0 0 0 0 0\n"
"MouseMoveEvent 55 242 0 0 0 0 0\n"
"MouseMoveEvent 56 243 0 0 0 0 0\n"
"TimerEvent 56 243 0 0 0 0 0\n"
"MouseMoveEvent 57 244 0 0 0 0 0\n"
"MouseMoveEvent 59 246 0 0 0 0 0\n"
"MouseMoveEvent 60 247 0 0 0 0 0\n"
"MouseMoveEvent 62 249 0 0 0 0 0\n"
"MouseMoveEvent 63 250 0 0 0 0 0\n"
"TimerEvent 63 250 0 0 0 0 0\n"
"MouseMoveEvent 64 251 0 0 0 0 0\n"
"MouseMoveEvent 65 252 0 0 0 0 0\n"
"MouseMoveEvent 66 252 0 0 0 0 0\n"
"MouseMoveEvent 67 253 0 0 0 0 0\n"
"MouseMoveEvent 69 253 0 0 0 0 0\n"
"MouseMoveEvent 70 253 0 0 0 0 0\n"
"TimerEvent 70 253 0 0 0 0 0\n"
"MouseMoveEvent 71 254 0 0 0 0 0\n"
"MouseMoveEvent 73 254 0 0 0 0 0\n"
"MouseMoveEvent 75 254 0 0 0 0 0\n"
"MouseMoveEvent 76 255 0 0 0 0 0\n"
"MouseMoveEvent 78 255 0 0 0 0 0\n"
"MouseMoveEvent 79 255 0 0 0 0 0\n"
"TimerEvent 79 255 0 0 0 0 0\n"
"MouseMoveEvent 81 255 0 0 0 0 0\n"
"MouseMoveEvent 83 255 0 0 0 0 0\n"
"MouseMoveEvent 86 256 0 0 0 0 0\n"
"MouseMoveEvent 89 256 0 0 0 0 0\n"
"MouseMoveEvent 94 256 0 0 0 0 0\n"
"MouseMoveEvent 102 257 0 0 0 0 0\n"
"TimerEvent 102 257 0 0 0 0 0\n"
"MouseMoveEvent 110 257 0 0 0 0 0\n"
"MouseMoveEvent 119 260 0 0 0 0 0\n"
"MouseMoveEvent 127 260 0 0 0 0 0\n"
"MouseMoveEvent 134 260 0 0 0 0 0\n"
"MouseMoveEvent 141 261 0 0 0 0 0\n"
"MouseMoveEvent 148 263 0 0 0 0 0\n"
"TimerEvent 148 263 0 0 0 0 0\n"
"MouseMoveEvent 155 263 0 0 0 0 0\n"
"MouseMoveEvent 160 263 0 0 0 0 0\n"
"MouseMoveEvent 166 264 0 0 0 0 0\n"
"MouseMoveEvent 168 264 0 0 0 0 0\n"
"MouseMoveEvent 170 265 0 0 0 0 0\n"
"MouseMoveEvent 171 265 0 0 0 0 0\n"
"TimerEvent 171 265 0 0 0 0 0\n"
"MouseMoveEvent 173 265 0 0 0 0 0\n"
"MouseMoveEvent 175 265 0 0 0 0 0\n"
"MouseMoveEvent 179 265 0 0 0 0 0\n"
"MouseMoveEvent 183 265 0 0 0 0 0\n"
"MouseMoveEvent 188 265 0 0 0 0 0\n"
"MouseMoveEvent 195 265 0 0 0 0 0\n"
"TimerEvent 195 265 0 0 0 0 0\n"
"MouseMoveEvent 202 265 0 0 0 0 0\n"
"MouseMoveEvent 209 265 0 0 0 0 0\n"
"MouseMoveEvent 216 265 0 0 0 0 0\n"
"MouseMoveEvent 223 265 0 0 0 0 0\n"
"MouseMoveEvent 228 265 0 0 0 0 0\n"
"MouseMoveEvent 233 265 0 0 0 0 0\n"
"TimerEvent 233 265 0 0 0 0 0\n"
"MouseMoveEvent 234 265 0 0 0 0 0\n"
"MouseMoveEvent 235 265 0 0 0 0 0\n"
"MouseMoveEvent 236 265 0 0 0 0 0\n"
"TimerEvent 236 265 0 0 0 0 0\n"
"MouseMoveEvent 238 265 0 0 0 0 0\n"
"MouseMoveEvent 240 265 0 0 0 0 0\n"
"MouseMoveEvent 242 265 0 0 0 0 0\n"
"MouseMoveEvent 243 265 0 0 0 0 0\n"
"MouseMoveEvent 245 265 0 0 0 0 0\n"
"MouseMoveEvent 246 265 0 0 0 0 0\n"
"TimerEvent 246 265 0 0 0 0 0\n"
"MouseMoveEvent 249 264 0 0 0 0 0\n"
"MouseMoveEvent 251 263 0 0 0 0 0\n"
"MouseMoveEvent 254 262 0 0 0 0 0\n"
"MouseMoveEvent 257 261 0 0 0 0 0\n"
"MouseMoveEvent 261 260 0 0 0 0 0\n"
"MouseMoveEvent 263 259 0 0 0 0 0\n"
"TimerEvent 263 259 0 0 0 0 0\n"
"MouseMoveEvent 266 259 0 0 0 0 0\n"
"MouseMoveEvent 268 258 0 0 0 0 0\n"
"MouseMoveEvent 269 257 0 0 0 0 0\n"
"MouseMoveEvent 271 256 0 0 0 0 0\n"
"MouseMoveEvent 274 255 0 0 0 0 0\n"
"TimerEvent 274 255 0 0 0 0 0\n"
"MouseMoveEvent 277 253 0 0 0 0 0\n"
"MouseMoveEvent 278 252 0 0 0 0 0\n"
"MouseMoveEvent 279 251 0 0 0 0 0\n"
"MouseMoveEvent 280 250 0 0 0 0 0\n"
"TimerEvent 280 250 0 0 0 0 0\n"
"MouseMoveEvent 281 249 0 0 0 0 0\n"
"MouseMoveEvent 282 248 0 0 0 0 0\n"
"MouseMoveEvent 282 247 0 0 0 0 0\n"
"MouseMoveEvent 282 246 0 0 0 0 0\n"
"MouseMoveEvent 282 243 0 0 0 0 0\n"
"MouseMoveEvent 283 241 0 0 0 0 0\n"
"TimerEvent 283 241 0 0 0 0 0\n"
"MouseMoveEvent 284 239 0 0 0 0 0\n"
"MouseMoveEvent 284 237 0 0 0 0 0\n"
"MouseMoveEvent 284 236 0 0 0 0 0\n"
"MouseMoveEvent 284 234 0 0 0 0 0\n"
"MouseMoveEvent 284 232 0 0 0 0 0\n"
"MouseMoveEvent 285 229 0 0 0 0 0\n"
"TimerEvent 285 229 0 0 0 0 0\n"
"MouseMoveEvent 286 226 0 0 0 0 0\n"
"MouseMoveEvent 286 225 0 0 0 0 0\n"
"MouseMoveEvent 286 223 0 0 0 0 0\n"
"MouseMoveEvent 287 221 0 0 0 0 0\n"
"MouseMoveEvent 287 220 0 0 0 0 0\n"
"MouseMoveEvent 287 218 0 0 0 0 0\n"
"TimerEvent 287 218 0 0 0 0 0\n"
"MouseMoveEvent 287 216 0 0 0 0 0\n"
"MouseMoveEvent 288 214 0 0 0 0 0\n"
"MouseMoveEvent 288 212 0 0 0 0 0\n"
"MouseMoveEvent 288 211 0 0 0 0 0\n"
"MouseMoveEvent 288 209 0 0 0 0 0\n"
"MouseMoveEvent 289 207 0 0 0 0 0\n"
"TimerEvent 289 207 0 0 0 0 0\n"
"MouseMoveEvent 290 205 0 0 0 0 0\n"
"MouseMoveEvent 290 204 0 0 0 0 0\n"
"MouseMoveEvent 291 203 0 0 0 0 0\n"
"MouseMoveEvent 291 202 0 0 0 0 0\n"
"MouseMoveEvent 292 201 0 0 0 0 0\n"
"TimerEvent 292 201 0 0 0 0 0\n"
"MouseMoveEvent 292 200 0 0 0 0 0\n"
"MouseMoveEvent 293 199 0 0 0 0 0\n"
"MouseMoveEvent 294 197 0 0 0 0 0\n"
"MouseMoveEvent 294 195 0 0 0 0 0\n"
"MouseMoveEvent 295 192 0 0 0 0 0\n"
"MouseMoveEvent 296 190 0 0 0 0 0\n"
"TimerEvent 296 190 0 0 0 0 0\n"
"MouseMoveEvent 297 187 0 0 0 0 0\n"
"TimerEvent 297 187 0 0 0 0 0\n"
"LeftButtonReleaseEvent 297 187 0 0 0 0 0\n"
"MouseMoveEvent 296 186 0 0 0 0 0\n"
"MouseMoveEvent 292 186 0 0 0 0 0\n"
"MouseMoveEvent 289 186 0 0 0 0 0\n"
"MouseMoveEvent 283 186 0 0 0 0 0\n"
"MouseMoveEvent 278 185 0 0 0 0 0\n"
"MouseMoveEvent 275 185 0 0 0 0 0\n"
"TimerEvent 275 185 0 0 0 0 0\n"
"MouseMoveEvent 273 184 0 0 0 0 0\n"
"MouseMoveEvent 272 184 0 0 0 0 0\n"
"MouseMoveEvent 268 184 0 0 0 0 0\n"
"MouseMoveEvent 263 184 0 0 0 0 0\n"
"MouseMoveEvent 255 184 0 0 0 0 0\n"
"MouseMoveEvent 244 184 0 0 0 0 0\n"
"TimerEvent 244 184 0 0 0 0 0\n"
"MouseMoveEvent 230 184 0 0 0 0 0\n"
"MouseMoveEvent 216 184 0 0 0 0 0\n"
"MouseMoveEvent 202 187 0 0 0 0 0\n"
"MouseMoveEvent 188 189 0 0 0 0 0\n"
"MouseMoveEvent 177 191 0 0 0 0 0\n"
"MouseMoveEvent 167 193 0 0 0 0 0\n"
"TimerEvent 167 193 0 0 0 0 0\n"
"MouseMoveEvent 159 196 0 0 0 0 0\n"
"MouseMoveEvent 151 199 0 0 0 0 0\n"
"MouseMoveEvent 140 202 0 0 0 0 0\n"
"MouseMoveEvent 132 206 0 0 0 0 0\n"
"MouseMoveEvent 125 208 0 0 0 0 0\n"
"MouseMoveEvent 120 211 0 0 0 0 0\n"
"TimerEvent 120 211 0 0 0 0 0\n"
"MouseMoveEvent 116 214 0 0 0 0 0\n"
"MouseMoveEvent 114 216 0 0 0 0 0\n"
"MouseMoveEvent 113 218 0 0 0 0 0\n"
"MouseMoveEvent 112 222 0 0 0 0 0\n"
"MouseMoveEvent 109 228 0 0 0 0 0\n"
"MouseMoveEvent 109 233 0 0 0 0 0\n"
"TimerEvent 109 233 0 0 0 0 0\n"
"MouseMoveEvent 109 239 0 0 0 0 0\n"
"MouseMoveEvent 109 242 0 0 0 0 0\n"
"MouseMoveEvent 109 245 0 0 0 0 0\n"
"MouseMoveEvent 109 247 0 0 0 0 0\n"
"MouseMoveEvent 109 250 0 0 0 0 0\n"
"MouseMoveEvent 110 252 0 0 0 0 0\n"
"TimerEvent 110 252 0 0 0 0 0\n"
"MouseMoveEvent 111 254 0 0 0 0 0\n"
"MouseMoveEvent 111 255 0 0 0 0 0\n"
"MouseMoveEvent 111 256 0 0 0 0 0\n"
"MouseMoveEvent 111 257 0 0 0 0 0\n"
"MouseMoveEvent 111 258 0 0 0 0 0\n"
"MouseMoveEvent 111 259 0 0 0 0 0\n"
"TimerEvent 111 259 0 0 0 0 0\n"
"MouseMoveEvent 112 260 0 0 0 0 0\n"
"MouseMoveEvent 113 261 0 0 0 0 0\n"
"TimerEvent 113 261 0 0 0 0 0\n"
"MouseMoveEvent 114 261 0 0 0 0 0\n"
"MouseMoveEvent 115 261 0 0 0 0 0\n"
"MouseMoveEvent 117 260 0 0 0 0 0\n"
"MouseMoveEvent 119 258 0 0 0 0 0\n"
"MouseMoveEvent 121 256 0 0 0 0 0\n"
"TimerEvent 121 256 0 0 0 0 0\n"
"MouseMoveEvent 122 255 0 0 0 0 0\n"
"MouseMoveEvent 125 253 0 0 0 0 0\n"
"MouseMoveEvent 128 251 0 0 0 0 0\n"
"MouseMoveEvent 131 249 0 0 0 0 0\n"
"MouseMoveEvent 133 248 0 0 0 0 0\n"
"MouseMoveEvent 134 248 0 0 0 0 0\n"
"TimerEvent 134 248 0 0 0 0 0\n"
"MouseMoveEvent 135 247 0 0 0 0 0\n"
"MouseMoveEvent 136 247 0 0 0 0 0\n"
"MouseMoveEvent 137 247 0 0 0 0 0\n"
"MouseMoveEvent 138 247 0 0 0 0 0\n"
"MouseMoveEvent 139 247 0 0 0 0 0\n"
"TimerEvent 139 247 0 0 0 0 0\n"
"MouseMoveEvent 140 247 0 0 0 0 0\n"
"MouseMoveEvent 141 247 0 0 0 0 0\n"
"MouseMoveEvent 142 247 0 0 0 0 0\n"
"MouseMoveEvent 144 247 0 0 0 0 0\n"
"MouseMoveEvent 145 247 0 0 0 0 0\n"
"TimerEvent 145 247 0 0 0 0 0\n"
"MouseMoveEvent 146 247 0 0 0 0 0\n"
"MouseMoveEvent 147 247 0 0 0 0 0\n"
"MouseMoveEvent 148 248 0 0 0 0 0\n"
"MouseMoveEvent 149 249 0 0 0 0 0\n"
"TimerEvent 149 249 0 0 0 0 0\n"
"MouseMoveEvent 150 250 0 0 0 0 0\n"
"MouseMoveEvent 151 251 0 0 0 0 0\n"
"MouseMoveEvent 152 252 0 0 0 0 0\n"
"MouseMoveEvent 153 253 0 0 0 0 0\n"
"MouseMoveEvent 153 254 0 0 0 0 0\n"
"MouseMoveEvent 154 255 0 0 0 0 0\n"
"TimerEvent 154 255 0 0 0 0 0\n"
"MouseMoveEvent 155 256 0 0 0 0 0\n"
"MouseMoveEvent 156 257 0 0 0 0 0\n"
"TimerEvent 156 257 0 0 0 0 0\n"
"MouseMoveEvent 157 258 0 0 0 0 0\n"
"MouseMoveEvent 157 259 0 0 0 0 0\n"
"TimerEvent 157 259 0 0 0 0 0\n"
"MouseMoveEvent 158 261 0 0 0 0 0\n"
"MouseMoveEvent 159 262 0 0 0 0 0\n"
"MouseMoveEvent 160 263 0 0 0 0 0\n"
"MouseMoveEvent 160 264 0 0 0 0 0\n"
"TimerEvent 160 264 0 0 0 0 0\n"
"MouseMoveEvent 161 265 0 0 0 0 0\n"
"MouseMoveEvent 162 266 0 0 0 0 0\n"
"RightButtonPressEvent 162 266 0 0 0 0 0\n"
"TimerEvent 162 266 0 0 0 0 0\n"
"MouseMoveEvent 162 264 0 0 0 0 0\n"
"MouseMoveEvent 163 260 0 0 0 0 0\n"
"MouseMoveEvent 165 254 0 0 0 0 0\n"
"MouseMoveEvent 165 247 0 0 0 0 0\n"
"MouseMoveEvent 167 239 0 0 0 0 0\n"
"MouseMoveEvent 168 230 0 0 0 0 0\n"
"TimerEvent 168 230 0 0 0 0 0\n"
"MouseMoveEvent 170 220 0 0 0 0 0\n"
"MouseMoveEvent 170 210 0 0 0 0 0\n"
"MouseMoveEvent 172 200 0 0 0 0 0\n"
"MouseMoveEvent 174 190 0 0 0 0 0\n"
"MouseMoveEvent 174 180 0 0 0 0 0\n"
"MouseMoveEvent 175 170 0 0 0 0 0\n"
"TimerEvent 175 170 0 0 0 0 0\n"
"MouseMoveEvent 175 160 0 0 0 0 0\n"
"MouseMoveEvent 175 150 0 0 0 0 0\n"
"MouseMoveEvent 175 140 0 0 0 0 0\n"
"MouseMoveEvent 175 130 0 0 0 0 0\n"
"MouseMoveEvent 175 122 0 0 0 0 0\n"
"MouseMoveEvent 175 113 0 0 0 0 0\n"
"TimerEvent 175 113 0 0 0 0 0\n"
"MouseMoveEvent 175 107 0 0 0 0 0\n"
"MouseMoveEvent 175 103 0 0 0 0 0\n"
"MouseMoveEvent 175 100 0 0 0 0 0\n"
"MouseMoveEvent 176 99 0 0 0 0 0\n"
"MouseMoveEvent 176 98 0 0 0 0 0\n"
"MouseMoveEvent 176 97 0 0 0 0 0\n"
"TimerEvent 176 97 0 0 0 0 0\n"
"MouseMoveEvent 176 96 0 0 0 0 0\n"
"MouseMoveEvent 176 95 0 0 0 0 0\n"
"MouseMoveEvent 176 94 0 0 0 0 0\n"
"MouseMoveEvent 177 92 0 0 0 0 0\n"
"TimerEvent 177 92 0 0 0 0 0\n"
"MouseMoveEvent 178 91 0 0 0 0 0\n"
"MouseMoveEvent 179 90 0 0 0 0 0\n"
"MouseMoveEvent 181 86 0 0 0 0 0\n"
"MouseMoveEvent 183 84 0 0 0 0 0\n"
"MouseMoveEvent 185 82 0 0 0 0 0\n"
"MouseMoveEvent 188 80 0 0 0 0 0\n"
"TimerEvent 188 80 0 0 0 0 0\n"
"MouseMoveEvent 190 79 0 0 0 0 0\n"
"MouseMoveEvent 194 77 0 0 0 0 0\n"
"MouseMoveEvent 197 76 0 0 0 0 0\n"
"MouseMoveEvent 201 75 0 0 0 0 0\n"
"MouseMoveEvent 205 75 0 0 0 0 0\n"
"MouseMoveEvent 210 74 0 0 0 0 0\n"
"TimerEvent 210 74 0 0 0 0 0\n"
"MouseMoveEvent 215 74 0 0 0 0 0\n"
"MouseMoveEvent 221 74 0 0 0 0 0\n"
"MouseMoveEvent 225 74 0 0 0 0 0\n"
"MouseMoveEvent 227 74 0 0 0 0 0\n"
"MouseMoveEvent 230 74 0 0 0 0 0\n"
"MouseMoveEvent 234 74 0 0 0 0 0\n"
"TimerEvent 234 74 0 0 0 0 0\n"
"MouseMoveEvent 237 74 0 0 0 0 0\n"
"MouseMoveEvent 239 74 0 0 0 0 0\n"
"MouseMoveEvent 241 74 0 0 0 0 0\n"
"MouseMoveEvent 243 75 0 0 0 0 0\n"
"MouseMoveEvent 245 75 0 0 0 0 0\n"
"MouseMoveEvent 247 76 0 0 0 0 0\n"
"TimerEvent 247 76 0 0 0 0 0\n"
"MouseMoveEvent 248 76 0 0 0 0 0\n"
"TimerEvent 248 76 0 0 0 0 0\n"
"MouseMoveEvent 250 77 0 0 0 0 0\n"
"MouseMoveEvent 252 77 0 0 0 0 0\n"
"MouseMoveEvent 254 77 0 0 0 0 0\n"
"MouseMoveEvent 255 77 0 0 0 0 0\n"
"MouseMoveEvent 257 78 0 0 0 0 0\n"
"MouseMoveEvent 259 78 0 0 0 0 0\n"
"TimerEvent 259 78 0 0 0 0 0\n"
"MouseMoveEvent 262 78 0 0 0 0 0\n"
"MouseMoveEvent 264 78 0 0 0 0 0\n"
"MouseMoveEvent 265 78 0 0 0 0 0\n"
"MouseMoveEvent 267 79 0 0 0 0 0\n"
"TimerEvent 267 79 0 0 0 0 0\n"
"MouseMoveEvent 269 80 0 0 0 0 0\n"
"TimerEvent 269 80 0 0 0 0 0\n"
"RightButtonReleaseEvent 269 80 0 0 0 0 0\n"
"TimerEvent 269 80 0 0 0 0 0\n"
"MouseMoveEvent 270 81 0 0 0 0 0\n"
"MouseMoveEvent 271 82 0 0 0 0 0\n"
"MouseMoveEvent 273 84 0 0 0 0 0\n"
"MouseMoveEvent 276 87 0 0 0 0 0\n"
"MouseMoveEvent 278 89 0 0 0 0 0\n"
"MouseMoveEvent 280 91 0 0 0 0 0\n"
"TimerEvent 280 91 0 0 0 0 0\n"
"MouseMoveEvent 281 92 0 0 0 0 0\n"
"MouseMoveEvent 284 94 0 0 0 0 0\n"
"MouseMoveEvent 285 95 0 0 0 0 0\n"
"MouseMoveEvent 287 96 0 0 0 0 0\n"
"MouseMoveEvent 289 97 0 0 0 0 0\n"
"MouseMoveEvent 291 98 0 0 0 0 0\n"
"TimerEvent 291 98 0 0 0 0 0\n"
"MouseMoveEvent 292 99 0 0 0 0 0\n"
"MouseMoveEvent 293 100 0 0 0 0 0\n"
"MouseMoveEvent 294 101 0 0 0 0 0\n"
"MouseMoveEvent 295 101 0 0 0 0 0\n"
"TimerEvent 295 101 0 0 0 0 0\n"
"LeftButtonPressEvent 295 101 0 0 0 0 0\n"
"MouseMoveEvent 296 102 0 0 0 0 0\n"
"MouseMoveEvent 294 103 0 0 0 0 0\n"
"MouseMoveEvent 291 104 0 0 0 0 0\n"
"MouseMoveEvent 286 106 0 0 0 0 0\n"
"MouseMoveEvent 282 108 0 0 0 0 0\n"
"MouseMoveEvent 276 109 0 0 0 0 0\n"
"TimerEvent 276 109 0 0 0 0 0\n"
"MouseMoveEvent 271 111 0 0 0 0 0\n"
"MouseMoveEvent 264 112 0 0 0 0 0\n"
"MouseMoveEvent 256 115 0 0 0 0 0\n"
"MouseMoveEvent 249 117 0 0 0 0 0\n"
"MouseMoveEvent 243 119 0 0 0 0 0\n"
"MouseMoveEvent 239 121 0 0 0 0 0\n"
"TimerEvent 239 121 0 0 0 0 0\n"
"MouseMoveEvent 235 123 0 0 0 0 0\n"
"MouseMoveEvent 234 123 0 0 0 0 0\n"
"MouseMoveEvent 233 124 0 0 0 0 0\n"
"MouseMoveEvent 232 124 0 0 0 0 0\n"
"MouseMoveEvent 231 125 0 0 0 0 0\n"
"TimerEvent 231 125 0 0 0 0 0\n"
"MouseMoveEvent 230 125 0 0 0 0 0\n"
"MouseMoveEvent 229 125 0 0 0 0 0\n"
"MouseMoveEvent 228 125 0 0 0 0 0\n"
"MouseMoveEvent 227 126 0 0 0 0 0\n"
"TimerEvent 227 126 0 0 0 0 0\n"
"MouseMoveEvent 225 126 0 0 0 0 0\n"
"MouseMoveEvent 223 127 0 0 0 0 0\n"
"MouseMoveEvent 222 127 0 0 0 0 0\n"
"MouseMoveEvent 220 128 0 0 0 0 0\n"
"MouseMoveEvent 219 128 0 0 0 0 0\n"
"MouseMoveEvent 217 129 0 0 0 0 0\n"
"TimerEvent 217 129 0 0 0 0 0\n"
"MouseMoveEvent 216 129 0 0 0 0 0\n"
"MouseMoveEvent 214 130 0 0 0 0 0\n"
"MouseMoveEvent 212 131 0 0 0 0 0\n"
"TimerEvent 212 131 0 0 0 0 0\n"
"MouseMoveEvent 211 131 0 0 0 0 0\n"
"MouseMoveEvent 210 132 0 0 0 0 0\n"
"MouseMoveEvent 209 133 0 0 0 0 0\n"
"TimerEvent 209 133 0 0 0 0 0\n"
"MouseMoveEvent 208 134 0 0 0 0 0\n"
"MouseMoveEvent 206 135 0 0 0 0 0\n"
"TimerEvent 206 135 0 0 0 0 0\n"
"MouseMoveEvent 205 136 0 0 0 0 0\n"
"MouseMoveEvent 204 137 0 0 0 0 0\n"
"MouseMoveEvent 203 138 0 0 0 0 0\n"
"TimerEvent 203 138 0 0 0 0 0\n"
"MouseMoveEvent 201 139 0 0 0 0 0\n"
"LeftButtonReleaseEvent 201 139 0 0 0 0 0\n"
"MouseMoveEvent 200 139 0 0 0 0 0\n"
"MouseMoveEvent 198 139 0 0 0 0 0\n"
"MouseMoveEvent 195 140 0 0 0 0 0\n"
"MouseMoveEvent 189 141 0 0 0 0 0\n"
"MouseMoveEvent 180 143 0 0 0 0 0\n"
"TimerEvent 180 143 0 0 0 0 0\n"
"MouseMoveEvent 166 144 0 0 0 0 0\n"
"MouseMoveEvent 152 146 0 0 0 0 0\n"
"MouseMoveEvent 138 148 0 0 0 0 0\n"
"MouseMoveEvent 126 150 0 0 0 0 0\n"
"MouseMoveEvent 118 152 0 0 0 0 0\n"
"MouseMoveEvent 111 152 0 0 0 0 0\n"
"TimerEvent 111 152 0 0 0 0 0\n"
"MouseMoveEvent 110 153 0 0 0 0 0\n"
"MouseMoveEvent 109 154 0 0 0 0 0\n"
"MouseMoveEvent 108 155 0 0 0 0 0\n"
"TimerEvent 108 155 0 0 0 0 0\n"
"MouseMoveEvent 108 156 0 0 0 0 0\n"
"MouseMoveEvent 108 157 0 0 0 0 0\n"
"MouseMoveEvent 108 158 0 0 0 0 0\n"
"MouseMoveEvent 108 159 0 0 0 0 0\n"
"MouseMoveEvent 108 160 0 0 0 0 0\n"
"MouseMoveEvent 108 161 0 0 0 0 0\n"
"TimerEvent 108 161 0 0 0 0 0\n"
"MouseMoveEvent 108 162 0 0 0 0 0\n"
"MouseMoveEvent 108 163 0 0 0 0 0\n"
"MouseMoveEvent 108 164 0 0 0 0 0\n"
"MouseMoveEvent 108 165 0 0 0 0 0\n"
"MouseMoveEvent 108 166 0 0 0 0 0\n"
"MouseMoveEvent 108 167 0 0 0 0 0\n"
"TimerEvent 108 167 0 0 0 0 0\n"
"MouseMoveEvent 108 168 0 0 0 0 0\n"
"MouseMoveEvent 108 169 0 0 0 0 0\n"
"MouseMoveEvent 109 170 0 0 0 0 0\n"
"MouseMoveEvent 110 171 0 0 0 0 0\n"
"TimerEvent 110 171 0 0 0 0 0\n"
"MouseMoveEvent 111 172 0 0 0 0 0\n"
"MouseMoveEvent 112 173 0 0 0 0 0\n"
"MouseMoveEvent 113 174 0 0 0 0 0\n"
"MouseMoveEvent 114 174 0 0 0 0 0\n"
"TimerEvent 114 174 0 0 0 0 0\n"
"MouseMoveEvent 115 174 0 0 0 0 0\n"
"MouseMoveEvent 116 175 0 0 0 0 0\n"
"TimerEvent 116 175 0 0 0 0 0\n"
"MouseMoveEvent 116 176 0 0 0 0 0\n"
"MouseMoveEvent 117 177 0 0 0 0 0\n"
"MouseMoveEvent 117 178 0 0 0 0 0\n"
"MouseMoveEvent 117 179 0 0 0 0 0\n"
"MouseMoveEvent 117 181 0 0 0 0 0\n"
"TimerEvent 117 181 0 0 0 0 0\n"
"MouseMoveEvent 117 182 0 0 0 0 0\n"
"MouseMoveEvent 117 183 0 0 0 0 0\n"
"MouseMoveEvent 117 184 0 0 0 0 0\n"
"MouseMoveEvent 117 185 0 0 0 0 0\n"
"MouseMoveEvent 117 187 0 0 0 0 0\n"
"MouseMoveEvent 117 188 0 0 0 0 0\n"
"TimerEvent 117 188 0 0 0 0 0\n"
"MouseMoveEvent 117 189 0 0 0 0 0\n"
"MouseMoveEvent 117 190 0 0 0 0 0\n"
"MouseMoveEvent 117 192 0 0 0 0 0\n"
"MouseMoveEvent 117 193 0 0 0 0 0\n"
"TimerEvent 117 193 0 0 0 0 0\n"
"MouseMoveEvent 117 194 0 0 0 0 0\n"
"MouseMoveEvent 117 195 0 0 0 0 0\n"
"MouseMoveEvent 117 196 0 0 0 0 0\n"
"TimerEvent 117 196 0 0 0 0 0\n"
"MouseMoveEvent 117 197 0 0 0 0 0\n"
"MouseMoveEvent 118 198 0 0 0 0 0\n"
"TimerEvent 118 198 0 0 0 0 0\n"
"MouseMoveEvent 118 197 0 0 0 0 0\n"
"MouseMoveEvent 118 196 0 0 0 0 0\n"
"TimerEvent 118 196 0 0 0 0 0\n"
"MouseMoveEvent 119 195 0 0 0 0 0\n"
"TimerEvent 119 195 0 0 0 0 0\n"
"MouseMoveEvent 120 194 0 0 0 0 0\n"
"MouseMoveEvent 121 195 0 0 0 0 0\n"
"TimerEvent 121 195 0 0 0 0 0\n"
;

//----------------------------------------------------------------------------
int TestChartXYInvertedAxis( int argc, char * argv[] )
{
  // Set up a 2D scene, add an XY chart to it
  vtkNew<vtkContextView> view;
  view->GetRenderWindow()->SetSize(400, 300);
  vtkNew<vtkChartXY> chart;
  view->GetScene()->AddItem(chart.GetPointer());

  // Create a table with some points in it...
  vtkNew<vtkTable> table;
  vtkNew<vtkFloatArray> arrX;
  arrX->SetName("X Axis");
  table->AddColumn(arrX.GetPointer());
  vtkNew<vtkFloatArray> arrC;
  arrC->SetName("Cosine");
  table->AddColumn(arrC.GetPointer());
  vtkNew<vtkFloatArray> arrS;
  arrS->SetName("Sine");
  table->AddColumn(arrS.GetPointer());
  vtkNew<vtkFloatArray> arrS2;
  arrS2->SetName("Sine2");
  table->AddColumn(arrS2.GetPointer());
  vtkNew<vtkFloatArray> arr1;
  arr1->SetName("One");
  table->AddColumn(arr1.GetPointer());
  // Test charting with a few more points...
  int numPoints = 69;
  float inc = 7.5 / (numPoints-1);
  table->SetNumberOfRows(numPoints);
  for (int i = 0; i < numPoints; ++i)
    {
    table->SetValue(i, 0, i * inc);
    table->SetValue(i, 1, cos(i * inc) + 0.0);
    table->SetValue(i, 2, sin(i * inc) + 0.0);
    table->SetValue(i, 3, sin(i * inc) + 0.5);
    table->SetValue(i, 4, 1.0);
    }

  // Add multiple line plots, setting the colors etc
  vtkPlot *line = chart->AddPlot(vtkChart::LINE);
  line->SetInputData(table.GetPointer(), 0, 1);
  line->SetColor(0, 255, 0, 255);
  line->SetWidth(1.0);
  line = chart->AddPlot(vtkChart::LINE);
  line->SetInputData(table.GetPointer(), 0, 2);
  line->SetColor(255, 0, 0, 255);
  line->SetWidth(5.0);
  line = chart->AddPlot(vtkChart::LINE);
  line->SetInputData(table.GetPointer(), 0, 3);
  line->SetColor(0, 0, 255, 255);
  line->SetWidth(4.0);

  // Invert the Y axis
  chart->GetAxis(vtkAxis::LEFT)->SetBehavior(vtkAxis::FIXED);
  chart->GetAxis(vtkAxis::LEFT)->SetUnscaledRange(2.0, -2.0);
  chart->GetAxis(vtkAxis::BOTTOM)->SetBehavior(vtkAxis::FIXED);
  chart->GetAxis(vtkAxis::BOTTOM)->SetUnscaledRange(10.0, 0.0);

  // Render the scene and compare the image to a reference image
  view->GetRenderWindow()->SetMultiSamples(0);
  view->GetInteractor()->Initialize();

  return vtkTesting::InteractorEventLoop(argc, argv,
                                         view->GetInteractor(),
                                         TestChartXYInvertedAxisLog);
}
