vertices_dt=read.table("raw_graph_vertices.txt", header=TRUE, stringsAsFactors=FALSE);
raw_predictions=read.table("raw_predictions.txt", header=FALSE, stringsAsFactors=FALSE)[[1]];

stats_dt=read.table("stats_for_output.txt", header=TRUE, stringsAsFactors=FALSE);
z_mean=stats_dt$mean_core_01;
z_sd=stats_dt$sd_core_01;

transformed_predictions=(raw_predictions*z_sd)+z_mean;

predictions_dt=data.frame(gnn_score=transformed_predictions);

result_detailed=cbind(vertices_dt, predictions_dt);

result_summary=data.frame(
  sum_of_gnn_scores=sum(result_detailed$gnn_score),
  sum_of_areas=sum(result_detailed$area),
  average_gnn_score=sum(result_detailed$gnn_score)/sum(result_detailed$area));

write.table(result_detailed, file="results_detailed.txt", quote=FALSE, col.names=TRUE, row.names=FALSE, sep=" ");
write.table(result_summary, file="results_summary.txt", quote=FALSE, col.names=TRUE, row.names=FALSE, sep=" ");
