// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Sensor.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.sensors {
  public class Sensor_4_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.Sensor:4.0.1", null);

    public Sensor_4_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Sensor_4_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Sensor_4_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Sensor_4_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_NOT_SUPPORTED = 1;

    public const int NUMERIC = 0;

    public const int DISCRETE_ON_OFF = 1;

    public const int DISCRETE_MULTI = 2;

    public enum OnOffState {
      OFF,
      ON,
    }

    public const int UNSPECIFIED = 0;

    public const int VOLTAGE = 1;

    public const int CURRENT = 2;

    public const int UNBALANCE_CURRENT = 3;

    public const int POWER = 4;

    public const int POWER_FACTOR = 5;

    public const int ENERGY = 6;

    public const int FREQUENCY = 7;

    public const int TEMPERATURE = 8;

    public const int HUMIDITY = 9;

    public const int AIR_FLOW = 10;

    public const int AIR_PRESSURE = 11;

    public const int CONTACT_CLOSURE = 12;

    public const int ON_OFF_SENSOR = 13;

    public const int TRIP_SENSOR = 14;

    public const int VIBRATION = 15;

    public const int WATER_LEAK = 16;

    public const int SMOKE_DETECTOR = 17;

    public const int TOTAL_HARMONIC_DISTORTION = 18;

    public const int MASS = 19;

    public const int ELECTRICAL_RESISTANCE = 20;

    public const int FLUX = 21;

    public const int LUMINOUS_INTENSITY = 22;

    public const int ACCELERATION = 23;

    public const int MAGNETIC_FLUX_DENSITY = 24;

    public const int ELECTRIC_FIELD_STRENGTH = 25;

    public const int MAGNETIC_FIELD_STRENGTH = 26;

    public const int ANGLE = 27;

    public const int SELECTION = 28;

    public const int FAULT_STATE = 29;

    public const int POWER_QUALITY = 30;

    public const int ROTATIONAL_SPEED = 31;

    public const int LUMINOUS_ENERGY = 32;

    public const int LUMINOUS_FLUX = 33;

    public const int ILLUMINANCE = 34;

    public const int LUMINOUS_EMITTANCE = 35;

    public const int MOTION = 36;

    public const int OCCUPANCY = 37;

    public const int TAMPER = 38;

    public const int DRY_CONTACT = 39;

    public const int POWERED_DRY_CONTACT = 40;

    public const int ABSOLUTE_HUMIDITY = 41;

    public const int NONE = 0;

    public const int VOLT = 1;

    public const int AMPERE = 2;

    public const int WATT = 3;

    public const int VOLT_AMP = 4;

    public const int WATT_HOUR = 5;

    public const int VOLT_AMP_HOUR = 6;

    public const int DEGREE_CELSIUS = 7;

    public const int HZ = 8;

    public const int PERCENT = 9;

    public const int METER_PER_SEC = 10;

    public const int PASCAL = 11;

    public const int G = 12;

    public const int RPM = 13;

    public const int METER = 14;

    public const int HOUR = 15;

    public const int MINUTE = 16;

    public const int SECOND = 17;

    public const int VOLT_AMP_REACTIVE = 18;

    public const int VOLT_AMP_REACTIVE_HOUR = 19;

    public const int GRAM = 20;

    public const int OHM = 21;

    public const int LITERS_PER_HOUR = 22;

    public const int CANDELA = 23;

    public const int METER_PER_SQARE_SEC = 24;

    public const int TESLA = 25;

    public const int VOLT_PER_METER = 26;

    public const int VOLT_PER_AMPERE = 27;

    public const int DEGREE = 28;

    public const int DEGREE_FAHRENHEIT = 29;

    public const int KELVIN = 30;

    public const int JOULE = 31;

    public const int COULOMB = 32;

    public const int NIT = 33;

    public const int LUMEN = 34;

    public const int LUMEN_SECOND = 35;

    public const int LUX = 36;

    public const int PSI = 37;

    public const int NEWTON = 38;

    public const int FOOT = 39;

    public const int FOOT_PER_SEC = 40;

    public const int CUBIC_METER = 41;

    public const int RADIANT = 42;

    public const int STERADIANT = 43;

    public const int HENRY = 44;

    public const int FARAD = 45;

    public const int MOL = 46;

    public const int BECQUEREL = 47;

    public const int GRAY = 48;

    public const int SIEVERT = 49;

    public const int G_PER_CUBIC_METER = 50;

    public class TypeSpec : ICloneable {
      public object Clone() {
        TypeSpec copy = new TypeSpec();
        copy.readingtype = this.readingtype;
        copy.type = this.type;
        copy.unit = this.unit;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["readingtype"] = this.readingtype;
        json["type"] = this.type;
        json["unit"] = this.unit;
        return json;
      }

      public static TypeSpec Decode(LightJson.JsonObject json, Agent agent) {
        TypeSpec inst = new TypeSpec();
        inst.readingtype = (int)json["readingtype"];
        inst.type = (int)json["type"];
        inst.unit = (int)json["unit"];
        return inst;
      }

      public int readingtype = 0;
      public int type = 0;
      public int unit = 0;
    }

    public class TypeSpecChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.Sensor_4_0_1.TypeSpecChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.sensors.Sensor_4_0_1.TypeSpec oldTypeSpec = new Com.Raritan.Idl.sensors.Sensor_4_0_1.TypeSpec();
      public Com.Raritan.Idl.sensors.Sensor_4_0_1.TypeSpec newTypeSpec = new Com.Raritan.Idl.sensors.Sensor_4_0_1.TypeSpec();
    }

    public class GetTypeSpecResult {
      public Com.Raritan.Idl.sensors.Sensor_4_0_1.TypeSpec _ret_;
    }

    public GetTypeSpecResult getTypeSpec() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTypeSpec", _parameters);
      var _ret = new GetTypeSpecResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.Sensor_4_0_1.TypeSpec.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getTypeSpec(AsyncRpcResponse<GetTypeSpecResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTypeSpec(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTypeSpec(AsyncRpcResponse<GetTypeSpecResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTypeSpec", _parameters,
        _result => {
          try {
            var _ret = new GetTypeSpecResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.Sensor_4_0_1.TypeSpec.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetTypeResult {
      public int _ret_;
    }

    public SetTypeResult setType(int type, int unit) {
      var _parameters = new LightJson.JsonObject();
      _parameters["type"] = type;
      _parameters["unit"] = unit;

      var _result = RpcCall("setType", _parameters);
      var _ret = new SetTypeResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setType(int type, int unit, AsyncRpcResponse<SetTypeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setType(type, unit, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setType(int type, int unit, AsyncRpcResponse<SetTypeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["type"] = type;
        _parameters["unit"] = unit;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setType", _parameters,
        _result => {
          try {
            var _ret = new SetTypeResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
