#include "packagename.h"

#include <string>

#include "runcommandforparsing.h"

PackageName::NameWithArchitecture PackageName::extractArchitecture(const string& name) {
    size_t pos = name.rfind(':');
    if (pos == std::string::npos) {
        return {.name = name, .architecture = ""};
    }
    return {.name = name.substr(0, pos), .architecture = name.substr(pos + 1)};
}

string PackageName::determineDefaultArchitecture() {
    string name;
    auto lineProcessor = [&name](const std::string& line) {
        name = line;
    };
    NApplication::runCommandForParsing("dpkg --print-architecture", lineProcessor);
    return name;
}

const string& PackageName::defaultArchitecture() {
    static string architecture = determineDefaultArchitecture();
    return architecture;
}
