/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToMolproEcpInput
extends AbstractBasisSetXmlToText {
    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readECP(data, elementList);
    }

    @Override
    protected void addHeaderECP(StringBuffer output, Element root) {
        output.append("! Effective core Potentials \n");
        output.append("! ------------------------- \n");
    }

    @Override
    protected void addElementDescriptionECP(StringBuffer output, Element potentials, String element) {
        String nelec = potentials.getAttributeValue("numElectronsReplaced");
        int size = potentials.getChildren("potential", BSEProperties.mBseNs).size() - 1;
        output.append("ECP, " + element.toLowerCase() + ", " + nelec + ", " + size + " ;" + "\n");
    }

    @Override
    protected void readCmlMatrixECP(StringBuffer output, Matrix matrix, String element, String shell, String potentialType) throws FormatException {
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        output.append(rows + "; !" + "  " + potentialType + " " + "\n");
        try {
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    output.append(matrix.getValue(i, j));
                    if (j != columns - 1) {
                        output.append(",");
                        continue;
                    }
                    output.append(";");
                }
                output.append("\n");
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }
}

