/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security.peer;

import com.workingdogs.village.Record;
import java.util.Map;
import java.util.Vector;
import org.apache.turbine.om.BaseObject;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.SecurityObject;
import org.apache.turbine.om.security.TurbineGroup;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.GroupSet;

public class GroupPeer
extends BasePeer {
    private static final TurbineMapBuilder mapBuilder = (TurbineMapBuilder)BasePeer.getMapBuilder();
    private static final String TABLE_NAME = mapBuilder.getTableGroup();
    public static final String GROUP_ID = mapBuilder.getGroup_GroupId();
    public static final String NAME = mapBuilder.getGroup_Name();
    public static final String OBJECTDATA = mapBuilder.getGroup_ObjectData();
    private static final String SEQUENCE_NAME = mapBuilder.getSequenceGroup();

    public static GroupSet retrieveSet() throws Exception {
        return GroupPeer.retrieveSet(new Criteria());
    }

    public static GroupSet retrieveSet(Criteria criteria) throws Exception {
        Vector results = GroupPeer.doSelect(criteria);
        GroupSet rs = new GroupSet();
        int i = 0;
        while (i < results.size()) {
            rs.add((Group)results.elementAt(i));
            ++i;
        }
        return rs;
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        criteria.addSelectColumn(GROUP_ID).addSelectColumn(NAME).addSelectColumn(OBJECTDATA);
        if (criteria.getOrderByColumns() == null || criteria.getOrderByColumns().size() == 0) {
            criteria.addAscendingOrderByColumn(NAME);
        }
        Vector rows = BasePeer.doSelect(criteria);
        Vector<Group> results = new Vector<Group>();
        int i = 0;
        while (i < rows.size()) {
            Group obj = TurbineSecurity.getNewGroup(null);
            Record row = (Record)rows.elementAt(i);
            ((SecurityObject)((Object)obj)).setPrimaryKey(row.getValue(1).asInt());
            ((SecurityObject)((Object)obj)).setName(row.getValue(2).asString());
            byte[] objectData = row.getValue(3).asBytes();
            Map temp = (Map)ObjectUtils.deserialize(objectData);
            if (temp != null) {
                ((SecurityObject)((Object)obj)).setAttributes(temp);
            }
            results.addElement(obj);
            ++i;
        }
        return results;
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put(GROUP_ID, criteria.remove(GROUP_ID));
        BasePeer.doUpdate(selectCriteria, criteria);
    }

    public static boolean checkExists(Group group) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(GROUP_ID);
        criteria.add(NAME, ((SecurityObject)((Object)group)).getName());
        Vector results = BasePeer.doSelect(criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple groups named '" + ((TurbineGroup)group).getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static String getTableName() {
        return TABLE_NAME;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static Criteria buildCriteria(Group group) {
        Criteria criteria = new Criteria();
        criteria.add(NAME, ((SecurityObject)((Object)group)).getName());
        if (!((BaseObject)((Object)group)).isNew()) {
            criteria.add(GROUP_ID, ((BaseObject)((Object)group)).getPrimaryKey());
        }
        return criteria;
    }
}

