/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.chefproject.service.ServerConfigurationService;

public class Email {
    protected static final String SERVER_PROP = "mail.smtp.host";
    protected static final String CONTENT_TYPE = "text/plain";

    public static void sendMail(InternetAddress from, InternetAddress[] to, String subject, String content, InternetAddress[] headerTo, InternetAddress[] replyTo) {
        Properties props = new Properties();
        props.put(SERVER_PROP, ServerConfigurationService.getString("email.smtp", ""));
        Session session = Session.getDefaultInstance(props, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            ((Message)msg).setFrom(from);
            if (headerTo != null) {
                ((Message)msg).setRecipients(Message.RecipientType.TO, headerTo);
            } else {
                ((Message)msg).setRecipients(Message.RecipientType.TO, to);
            }
            ((Message)msg).setSubject(subject);
            ((Message)msg).setContent(content, CONTENT_TYPE);
            if (replyTo != null) {
                ((Message)msg).setReplyTo(replyTo);
            }
            if (headerTo != null) {
                Transport.send(msg, to);
            } else {
                Transport.send(msg);
            }
        }
        catch (MessagingException e) {
            // empty catch block
        }
    }

    public static void send(String fromStr, String toStr, String subject, String content, String headerToStr, String replyToStr) {
        try {
            InternetAddress from = new InternetAddress(fromStr);
            StringTokenizer tokens = new StringTokenizer(toStr, ", ");
            InternetAddress[] to = new InternetAddress[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                String next = tokens.nextToken();
                to[i] = new InternetAddress(next);
                ++i;
            }
            InternetAddress[] headerTo = null;
            if (headerToStr != null) {
                headerTo = new InternetAddress[]{new InternetAddress(headerToStr)};
            }
            InternetAddress[] replyTo = null;
            if (replyToStr != null) {
                replyTo = new InternetAddress[]{new InternetAddress(replyToStr)};
            }
            Email.sendMail(from, to, subject, content, headerTo, replyTo);
        }
        catch (AddressException e) {
            // empty catch block
        }
    }

    static {
        SERVER_PROP = SERVER_PROP;
        CONTENT_TYPE = CONTENT_TYPE;
    }
}

