/***************************** LICENSE START ***********************************

 Copyright 2018 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQECLAYERLINE_H
#define MVQECLAYERLINE_H

#include "MvQRequestPanelLine.h"
#include "MvIconParameter.h"

#include <QPixmap>
#include <QSet>
#include <QString>

class QColor;
class QComboBox;

class RequestPanel;
class MvQStyleDb;

class MvQEcLayerLine : public MvQRequestPanelLine, public ParameterScanner
{
    Q_OBJECT

public:
    MvQEcLayerLine(RequestPanel& owner, const MvIconParameter& param);
    ~MvQEcLayerLine() {}

    void refresh(const vector<string>&);
    void widgetClicked();

public slots:
    void slotHelperEdited(const vector<string>&);

protected:
    void next(const MvIconParameter&, const char* first, const char* second);
    void updateHelper();

    QPixmap pix_;
    QSize pixSize_;
    QLabel* pixLabel_;
    QLabel* nameLabel_;
};

#endif  //MVQECLAYERLINE_H
