/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.element.table.TableCalculationSettingsElement;
import org.odftoolkit.odfdom.dom.element.table.TableConsolidationElement;
import org.odftoolkit.odfdom.dom.element.table.TableContentValidationsElement;
import org.odftoolkit.odfdom.dom.element.table.TableDataPilotTablesElement;
import org.odftoolkit.odfdom.dom.element.table.TableDatabaseRangesElement;
import org.odftoolkit.odfdom.dom.element.table.TableDdeLinksElement;
import org.odftoolkit.odfdom.dom.element.table.TableLabelRangesElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedExpressionsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTrackedChangesElement;
import org.odftoolkit.odfdom.dom.element.text.TextAlphabeticalIndexAutoMarkFileElement;
import org.odftoolkit.odfdom.dom.element.text.TextDdeConnectionDeclsElement;
import org.odftoolkit.odfdom.dom.element.text.TextSequenceDeclsElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserFieldDeclsElement;
import org.odftoolkit.odfdom.dom.element.text.TextVariableDeclsElement;
import org.odftoolkit.odfdom.dom.attribute.table.TableProtectionKeyAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableProtectionKeyDigestAlgorithmAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableStructureProtectedAttribute;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:spreadsheet}.
 *
 */
public class OfficeSpreadsheetElement extends OdfElement {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.OFFICE, "spreadsheet");

	/**
	 * Create the instance of <code>OfficeSpreadsheetElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeSpreadsheetElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:spreadsheet}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableProtectionKeyAttribute</code> , See {@odf.attribute table:protection-key}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableProtectionKeyAttribute() {
		TableProtectionKeyAttribute attr = (TableProtectionKeyAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "protection-key");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return null;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableProtectionKeyAttribute</code> , See {@odf.attribute table:protection-key}
	 *
	 * @param tableProtectionKeyValue   The type is <code>String</code>
	 */
	public void setTableProtectionKeyAttribute(String tableProtectionKeyValue) {
		TableProtectionKeyAttribute attr = new TableProtectionKeyAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(tableProtectionKeyValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableProtectionKeyDigestAlgorithmAttribute</code> , See {@odf.attribute table:protection-key-digest-algorithm}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableProtectionKeyDigestAlgorithmAttribute() {
		TableProtectionKeyDigestAlgorithmAttribute attr = (TableProtectionKeyDigestAlgorithmAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "protection-key-digest-algorithm");
		if (attr != null) {
			return String.valueOf(attr.getValue());
		}
		return TableProtectionKeyDigestAlgorithmAttribute.DEFAULT_VALUE;
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableProtectionKeyDigestAlgorithmAttribute</code> , See {@odf.attribute table:protection-key-digest-algorithm}
	 *
	 * @param tableProtectionKeyDigestAlgorithmValue   The type is <code>String</code>
	 */
	public void setTableProtectionKeyDigestAlgorithmAttribute(String tableProtectionKeyDigestAlgorithmValue) {
		TableProtectionKeyDigestAlgorithmAttribute attr = new TableProtectionKeyDigestAlgorithmAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setValue(tableProtectionKeyDigestAlgorithmValue);
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableStructureProtectedAttribute</code> , See {@odf.attribute table:structure-protected}
	 *
	 * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public Boolean getTableStructureProtectedAttribute() {
		TableStructureProtectedAttribute attr = (TableStructureProtectedAttribute) getOdfAttribute(OdfDocumentNamespace.TABLE, "structure-protected");
		if (attr != null) {
			return Boolean.valueOf(attr.booleanValue());
		}
		return Boolean.valueOf(TableStructureProtectedAttribute.DEFAULT_VALUE);
	}

	/**
	 * Sets the value of ODFDOM attribute representation <code>TableStructureProtectedAttribute</code> , See {@odf.attribute table:structure-protected}
	 *
	 * @param tableStructureProtectedValue   The type is <code>Boolean</code>
	 */
	public void setTableStructureProtectedAttribute(Boolean tableStructureProtectedValue) {
		TableStructureProtectedAttribute attr = new TableStructureProtectedAttribute((OdfFileDom) this.ownerDocument);
		setOdfAttribute(attr);
		attr.setBooleanValue(tableStructureProtectedValue.booleanValue());
	}

	/**
	 * Create child element {@odf.element table:calculation-settings}.
	 *
	 * @return the element {@odf.element table:calculation-settings}
	 */
	public TableCalculationSettingsElement newTableCalculationSettingsElement() {
		TableCalculationSettingsElement tableCalculationSettings = ((OdfFileDom) this.ownerDocument).newOdfElement(TableCalculationSettingsElement.class);
		this.appendChild(tableCalculationSettings);
		return tableCalculationSettings;
	}

	/**
	 * Create child element {@odf.element table:consolidation}.
	 *
	 * @param tableFunctionValue  the <code>String</code> value of <code>TableFunctionAttribute</code>, see {@odf.attribute  table:function} at specification
	 * @param tableSourceCellRangeAddressesValue  the <code>String</code> value of <code>TableSourceCellRangeAddressesAttribute</code>, see {@odf.attribute  table:source-cell-range-addresses} at specification
	 * @param tableTargetCellAddressValue  the <code>String</code> value of <code>TableTargetCellAddressAttribute</code>, see {@odf.attribute  table:target-cell-address} at specification
	 * @return the element {@odf.element table:consolidation}
	 */
	 public TableConsolidationElement newTableConsolidationElement(String tableFunctionValue, String tableSourceCellRangeAddressesValue, String tableTargetCellAddressValue) {
		TableConsolidationElement tableConsolidation = ((OdfFileDom) this.ownerDocument).newOdfElement(TableConsolidationElement.class);
		tableConsolidation.setTableFunctionAttribute(tableFunctionValue);
		tableConsolidation.setTableSourceCellRangeAddressesAttribute(tableSourceCellRangeAddressesValue);
		tableConsolidation.setTableTargetCellAddressAttribute(tableTargetCellAddressValue);
		this.appendChild(tableConsolidation);
		return tableConsolidation;
	}

	/**
	 * Create child element {@odf.element table:content-validations}.
	 *
	 * @return the element {@odf.element table:content-validations}
	 */
	public TableContentValidationsElement newTableContentValidationsElement() {
		TableContentValidationsElement tableContentValidations = ((OdfFileDom) this.ownerDocument).newOdfElement(TableContentValidationsElement.class);
		this.appendChild(tableContentValidations);
		return tableContentValidations;
	}

	/**
	 * Create child element {@odf.element table:data-pilot-tables}.
	 *
	 * @return the element {@odf.element table:data-pilot-tables}
	 */
	public TableDataPilotTablesElement newTableDataPilotTablesElement() {
		TableDataPilotTablesElement tableDataPilotTables = ((OdfFileDom) this.ownerDocument).newOdfElement(TableDataPilotTablesElement.class);
		this.appendChild(tableDataPilotTables);
		return tableDataPilotTables;
	}

	/**
	 * Create child element {@odf.element table:database-ranges}.
	 *
	 * @return the element {@odf.element table:database-ranges}
	 */
	public TableDatabaseRangesElement newTableDatabaseRangesElement() {
		TableDatabaseRangesElement tableDatabaseRanges = ((OdfFileDom) this.ownerDocument).newOdfElement(TableDatabaseRangesElement.class);
		this.appendChild(tableDatabaseRanges);
		return tableDatabaseRanges;
	}

	/**
	 * Create child element {@odf.element table:dde-links}.
	 *
	 * @return the element {@odf.element table:dde-links}
	 */
	public TableDdeLinksElement newTableDdeLinksElement() {
		TableDdeLinksElement tableDdeLinks = ((OdfFileDom) this.ownerDocument).newOdfElement(TableDdeLinksElement.class);
		this.appendChild(tableDdeLinks);
		return tableDdeLinks;
	}

	/**
	 * Create child element {@odf.element table:label-ranges}.
	 *
	 * @return the element {@odf.element table:label-ranges}
	 */
	public TableLabelRangesElement newTableLabelRangesElement() {
		TableLabelRangesElement tableLabelRanges = ((OdfFileDom) this.ownerDocument).newOdfElement(TableLabelRangesElement.class);
		this.appendChild(tableLabelRanges);
		return tableLabelRanges;
	}

	/**
	 * Create child element {@odf.element table:named-expressions}.
	 *
	 * @return the element {@odf.element table:named-expressions}
	 */
	public TableNamedExpressionsElement newTableNamedExpressionsElement() {
		TableNamedExpressionsElement tableNamedExpressions = ((OdfFileDom) this.ownerDocument).newOdfElement(TableNamedExpressionsElement.class);
		this.appendChild(tableNamedExpressions);
		return tableNamedExpressions;
	}

	/**
	 * Create child element {@odf.element table:table}.
	 *
	 * @return the element {@odf.element table:table}
	 */
	public TableTableElement newTableTableElement() {
		TableTableElement tableTable = ((OdfFileDom) this.ownerDocument).newOdfElement(TableTableElement.class);
		this.appendChild(tableTable);
		return tableTable;
	}

	/**
	 * Create child element {@odf.element table:tracked-changes}.
	 *
	 * @return the element {@odf.element table:tracked-changes}
	 */
	public TableTrackedChangesElement newTableTrackedChangesElement() {
		TableTrackedChangesElement tableTrackedChanges = ((OdfFileDom) this.ownerDocument).newOdfElement(TableTrackedChangesElement.class);
		this.appendChild(tableTrackedChanges);
		return tableTrackedChanges;
	}

	/**
	 * Create child element {@odf.element text:alphabetical-index-auto-mark-file}.
	 *
	 * @param xlinkHrefValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return the element {@odf.element text:alphabetical-index-auto-mark-file}
	 */
	 public TextAlphabeticalIndexAutoMarkFileElement newTextAlphabeticalIndexAutoMarkFileElement(String xlinkHrefValue, String xlinkTypeValue) {
		TextAlphabeticalIndexAutoMarkFileElement textAlphabeticalIndexAutoMarkFile = ((OdfFileDom) this.ownerDocument).newOdfElement(TextAlphabeticalIndexAutoMarkFileElement.class);
		textAlphabeticalIndexAutoMarkFile.setXlinkHrefAttribute(xlinkHrefValue);
		textAlphabeticalIndexAutoMarkFile.setXlinkTypeAttribute(xlinkTypeValue);
		this.appendChild(textAlphabeticalIndexAutoMarkFile);
		return textAlphabeticalIndexAutoMarkFile;
	}

	/**
	 * Create child element {@odf.element text:dde-connection-decls}.
	 *
	 * @return the element {@odf.element text:dde-connection-decls}
	 */
	public TextDdeConnectionDeclsElement newTextDdeConnectionDeclsElement() {
		TextDdeConnectionDeclsElement textDdeConnectionDecls = ((OdfFileDom) this.ownerDocument).newOdfElement(TextDdeConnectionDeclsElement.class);
		this.appendChild(textDdeConnectionDecls);
		return textDdeConnectionDecls;
	}

	/**
	 * Create child element {@odf.element text:sequence-decls}.
	 *
	 * @return the element {@odf.element text:sequence-decls}
	 */
	public TextSequenceDeclsElement newTextSequenceDeclsElement() {
		TextSequenceDeclsElement textSequenceDecls = ((OdfFileDom) this.ownerDocument).newOdfElement(TextSequenceDeclsElement.class);
		this.appendChild(textSequenceDecls);
		return textSequenceDecls;
	}

	/**
	 * Create child element {@odf.element text:user-field-decls}.
	 *
	 * @return the element {@odf.element text:user-field-decls}
	 */
	public TextUserFieldDeclsElement newTextUserFieldDeclsElement() {
		TextUserFieldDeclsElement textUserFieldDecls = ((OdfFileDom) this.ownerDocument).newOdfElement(TextUserFieldDeclsElement.class);
		this.appendChild(textUserFieldDecls);
		return textUserFieldDecls;
	}

	/**
	 * Create child element {@odf.element text:variable-decls}.
	 *
	 * @return the element {@odf.element text:variable-decls}
	 */
	public TextVariableDeclsElement newTextVariableDeclsElement() {
		TextVariableDeclsElement textVariableDecls = ((OdfFileDom) this.ownerDocument).newOdfElement(TextVariableDeclsElement.class);
		this.appendChild(textVariableDecls);
		return textVariableDecls;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
