# - Try to find astrometry.net
# Once done this will define
#
#  ASTROMETRYNET_FOUND - system has ASTROMETRYNET
#  ASTROMETRYNET_EXECUTABLE - the primary astrometry.net executable
#  ASTROMETRYNET_INCLUDE_DIR - the ASTROMETRYNET include directory
#  ASTROMETRYNET_LIBRARIES - Link these to use ASTROMETRYNET

# Copyright (c) 2013, Jasem Mutlaq <mutlaqja@ikarustech.com>
# Based on FindLibfacile by Carsten Niehaus, <cniehaus@gmx.de>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

if (ASTROMETRYNET_INCLUDE_DIR AND ASTROMETRYNET_LIBRARIES AND ASTROMETRYNET_EXECUTABLE)

  # in cache already
  set(ASTROMETRYNET_FOUND TRUE)
  message(STATUS "Found ASTROMETRYNET: ${ASTROMETRYNET_LIBRARIES}, ${ASTROMETRYNET_INCLUDE_DIR}")


else (ASTROMETRYNET_INCLUDE_DIR AND ASTROMETRYNET_LIBRARIES AND ASTROMETRYNET_EXECUTABLE)

  if (NOT WIN32)
    find_package(PkgConfig)
    if (PKG_CONFIG_FOUND)
      pkg_check_modules(PC_ASTROMETRYNET ASTROMETRYNET)
    endif (PKG_CONFIG_FOUND)
  endif (NOT WIN32)

  find_path(ASTROMETRYNET_INCLUDE_DIR dualtree_rangesearch.h
    PATHS
    ${PC_ASTROMETRYNET_INCLUDE_DIRS}
    ${_obIncDir}
    ${GNUWIN32_DIR}/include
    ${GNUWIN32_DIR}/local/include
    PATH_SUFFIXES astrometry
  )

  find_library(ASTROMETRYNET_LIBRARIES NAMES astrometry
    PATHS
    ${PC_ASTROMETRYNET_LIBRARY_DIRS}
    ${_obLinkDir}
    ${GNUWIN32_DIR}/lib
    ${GNUWIN32_DIR}/local/lib
    PATH_SUFFIXES astrometry
  )

   set(ASTROMETRYNET_EXECUTABLE ASTROMETRYNET_EXECUTABLE-NOTFOUND)
   find_program(ASTROMETRYNET_EXECUTABLE NAMES solve-field)

  if(ASTROMETRYNET_INCLUDE_DIR AND ASTROMETRYNET_LIBRARIES AND ASTROMETRYNET_EXECUTABLE)
    set(ASTROMETRYNET_FOUND TRUE)
  else (ASTROMETRYNET_INCLUDE_DIR AND ASTROMETRYNET_LIBRARIES AND ASTROMETRYNET_EXECUTABLE)
    set(ASTROMETRYNET_FOUND FALSE)
  endif(ASTROMETRYNET_INCLUDE_DIR AND ASTROMETRYNET_LIBRARIES AND ASTROMETRYNET_EXECUTABLE)

  if (ASTROMETRYNET_FOUND)
    if (NOT ASTROMETRYNET_FIND_QUIETLY)
      message(STATUS "Found astrometry.net: ${ASTROMETRYNET_LIBRARIES}, ${ASTROMETRYNET_INCLUDE_DIR}")
    endif (NOT ASTROMETRYNET_FIND_QUIETLY)
  else (ASTROMETRYNET_FOUND)
    if (ASTROMETRYNET_FIND_REQUIRED)
      message(FATAL_ERROR "astrometry.net not found. Please install astrometry.net and try again.")
    endif (ASTROMETRYNET_FIND_REQUIRED)
  endif (ASTROMETRYNET_FOUND)

  mark_as_advanced(ASTROMETRYNET_INCLUDE_DIR ASTROMETRYNET_LIBRARIES)

endif (ASTROMETRYNET_INCLUDE_DIR AND ASTROMETRYNET_LIBRARIES AND ASTROMETRYNET_EXECUTABLE)
