# -* -coding: iso-8859-1 -*-
# -----------------------------------------------------------------------------
# tls/__init__.py - TLS support for the Kaa Framework
# -----------------------------------------------------------------------------
# $Id: __init__.py 4289 2010-01-27 20:08:12Z dmeyer $
#
# This module wraps TLS for client and server based on tlslite. See
# http://trevp.net/tlslite/docs/public/tlslite.TLSConnection.TLSConnection-class.html
# for more information about optional paramater.
#
# -----------------------------------------------------------------------------
# Copyright 2008-2009 Dirk Meyer, Jason Tackaberry
#
# Please see the file AUTHORS for a complete list of authors.
#
# This library is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version
# 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA
#
# -----------------------------------------------------------------------------

from common import *

try:
    from m2 import M2TLSSocket
except ImportError:
    M2TLSSocket = None

try:
    from tlslite import TLSAuthenticationError, TLSKey, TLSLiteConnection, TLSLiteSocket
except ImportError:
    TLSLiteSocket = None

try:
    from gnutls import GNUTLSSocket
except ImportError:
    GNUTLSSocket = None

# FIXME: for now, keep TLSLiteSocket as general TLSSocket object. This
# must change since tlslite is not maintained anymore. IMHO the best
# solution would be to use gnutls but the python-gnutls bindings have
# no SRP support.
TLSSocket = TLSLiteSocket or M2TLSSocket or GNUTLSSocket

if TLSLiteSocket == M2TLSSocket == None:
    raise ImportError('No suitable TLS backend found: tried tlslite, M2Crypto and gnutls')
