# ITK Release 4.0

This work is supported by ARRA funding from the NLM. The [kick-off
meeting](http://visual.nlm.nih.gov/itk/itk2010/agenda.html) for this
project took place from June 28-July 2 2010 in Bethesda. A beta version
of the software will be available by the end of March 2011. Bug fixes
will continue to be contributed to the ITK version 3 code.

## Download

-   [Download](https://itk.org/Wiki/ITK_Release_4/Download)

## Release Notes

-   [Release
    Notes](https://itk.org/Wiki/ITK_Release_4/Migration_Plan/Release_Notes)

## LICENSE Change

Starting with ITKv4-Alpha-01, the ITK toolkit is distributed under the
Apache 2.0 License.

More details here:

-   [Licensing](https://itk.org/Wiki/ITK_Release_4/Licensing)

## Revision Control

-   Adopt a modern revision control system
    -   Move from cvs to [git](https://git-scm.com) for distributed
        source code management
    -   [ITK Git Instructions](https://itk.org/Wiki/ITK/Git)

## Code Review

-   Adopt a code review system
    -   [ITK Gerrit](https://review.source.kitware.com/p/ITK)
    -   Powered by [Gerrit Code
        Review](https://code.google.com/p/gerrit/)

## Modern C++

-   [Modern C++](https://itk.org/Wiki/ITK_Release_4/Modern_C++)

<!-- -->

-   Take advantage of advances in C++
    -   Target popular compilers that are compatible with the C++98
        and/or C++03 standard
        (https://en.wikipedia.org/wiki/C%2B%2B03\#Language\_standard).
    -   Specifically remove support for Visual Studio prior to 7.1
        (e.g., 6 and 7.0), Borland version 5.5, Sun Studio compilers
        prior to 5.9, IRIX compilers, MWORKS compilers, cygwin 1.5
        (newer versions may work, but are not being targeted), and gcc
        prior to 3.4

## Wrapping

-   Improved ITK Wrapping at the class level (WrapITK)
    -   [Wrapping](https://itk.org/Wiki/ITK_Release_4/Wrapping)
    -   Particularly for Python 2.x, Python 3, Java and C\#

## Simplify

-   Addition of [Simple ITK Layer](https://itk.org/Wiki/ITK_Release_4/SimpleITK)

## Modularize

-   Refactor for [Modularity](https://itk.org/Wiki/ITK_Release_4/Modularization)
    -   ITKCore, ITKRegistrationModule, and Optional Modules

## Testing Crowdsourcing

-   [Testing
    Crowdsourcing](https://itk.org/Wiki/ITK_Release_4/Testing_Crowdsourcing)

## Improve Software Process

-   Enhanced project management tools and software processes

### Data Management

-   Better management for Testing
    Data
-   Data Collection [MIDAS](https://itk.org/Wiki/ITK_Release_4/Data_Collection)

### Distributed Testing (cdash@home)

-   Testing On Demand
    [cdash@home](https://itk.org/Wiki/ITK_Release_4/Testing_On_Demand)

### Testing Framework

-   [New unit testing framework](https://itk.org/Wiki/ITK_Release_4/UnitTesting)
    based on [Google Test](https://code.google.com/p/googletest/)
    -   Particularly to support module development, testing, and
        maintenance

### Coding Style

-   [Coding Style](https://itk.org/Wiki/ITK_Release_4/Coding_Style)

## Revise

### FEM

-   [Refactoring itk::FEM framework -
    V4](https://itk.org/Wiki/Refactoring_itk::FEM_framework_-_V4)

### Level Sets

-   [Refactoring Level-Set framework -
    V4](https://itk.org/Wiki/Refactoring_Level-Set_framework_-_V4)

### DICOM

-   Improved DICOM support
    -   DICOM
    -   Including communications with PACS
    -   Support Streaming interface
    -   Add filter to support Siemens MOSAIC images
    -   Information Object Definition verification

### Image Registration Framework

-   [Enhancing Image Registration
    Framework](https://itk.org/Wiki/ITK_Release_4/Enhancing_Image_Registration_Framework)

### Spatial Objects

-   [ Spatial Object Refactoring project
    page](https://itk.org/Wiki/ITK_Release_4/SpatialObjects)

### Global Code Review

-   [ Global Code Review](https://itk.org/Wiki/ITK_Release_4/Global_Code_Review)

## Accelerate

### GPU

-   [GPU Acceleration - V4](https://itk.org/Wiki/ITK_Release_4/GPU_Acceleration)
    -   With support for distributed computing in the future

<!-- -->

-   [GPU Acceleration - V4 (deprecated
    link)](https://itk.org/Wiki/GPU_Acceleration_-_V4)

### Numerical Libraries

-   [Refactor Numerical
    Libraries](https://itk.org/Wiki/ITK_Release_4/Refactor_Numerical_Libraries)

## Release schedules

-   [Release Schedules](https://itk.org/Wiki/ITK_Release_4/ReleaseSchedules)

## The Team

[The Team](https://itk.org/Wiki/ITK_Release_4/The_Team)

## Wish List

[Wish List](https://itk.org/Wiki/ITK_Release_4/Wish_List)

## Migration Plan (Developers)

[Migration Plan](https://itk.org/Wiki/ITK_Release_4/Migration_Plan)

## Migration Guide (for Users)

[Users Migration Guide](https://itk.org/Wiki/ITK_Release_4/Users_Migration_Guide)

## Software Guide (Update)

[Software Guide Update](https://itk.org/Wiki/ITK_Release_4/Software_Guide_Update)

## A2D2 Projects

[A2D2 Projects](https://itk.org/Wiki/ITK_Release_4/A2D2_Projects)

## New Fields

ITKv4 will provide improved support for

-   [Video](https://itk.org/Wiki/ITK_Release_4/Video)
-   [Microscopy](https://itk.org/Wiki/ITK_Release_4/Microscopy)
-   [Remote Sensing](https://itk.org/Wiki/ITK_Release_4/Remote_Sensing)

## Discussion Points

[Discussion Points](https://itk.org/Wiki/ITK_Release_4/Discussion_Points)

## Outreach

[Outreach](https://itk.org/Wiki/ITK_Release_4/Outreach)

## New Code Contribution Process

[New Code Contribution
Process](https://itk.org/Wiki/ITK_Release_4/New_Code_Contribution_Process)
