/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2008-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#ifndef makeParcelInjectionModels_H
#define makeParcelInjectionModels_H

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include <lagrangianIntermediate/KinematicCloud_.H>

#include <lagrangianIntermediate/ConeInjection.H>
#include <lagrangianIntermediate/ConeInjectionMP.H>
#include <lagrangianIntermediate/FieldActivatedInjection.H>
#include <lagrangianIntermediate/KinematicLookupTableInjection.H>
#include <lagrangianIntermediate/ManualInjection.H>
#include <lagrangianIntermediate/NoInjection.H>
#include <lagrangianIntermediate/PatchInjection.H>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#define makeParcelInjectionModels(ParcelType)                                 \
                                                                              \
    makeInjectionModel(KinematicCloud<ParcelType>);                           \
                                                                              \
    makeInjectionModelType                                                    \
    (                                                                         \
        ConeInjection,                                                        \
        KinematicCloud,                                                       \
        ParcelType                                                            \
    );                                                                        \
    makeInjectionModelType                                                    \
    (                                                                         \
        ConeInjectionMP,                                                      \
        KinematicCloud,                                                       \
        ParcelType                                                            \
    );                                                                        \
    makeInjectionModelType                                                    \
    (                                                                         \
        FieldActivatedInjection,                                              \
        KinematicCloud,                                                       \
        ParcelType                                                            \
    );                                                                        \
    makeInjectionModelType                                                    \
    (                                                                         \
        KinematicLookupTableInjection,                                        \
        KinematicCloud,                                                       \
        ParcelType                                                            \
    );                                                                        \
    makeInjectionModelType                                                    \
    (                                                                         \
        ManualInjection,                                                      \
        KinematicCloud,                                                       \
        ParcelType                                                            \
    );                                                                        \
    makeInjectionModelType                                                    \
    (                                                                         \
        NoInjection,                                                          \
        KinematicCloud,                                                       \
        ParcelType                                                            \
    );                                                                        \
    makeInjectionModelType                                                    \
    (                                                                         \
        PatchInjection,                                                       \
        KinematicCloud,                                                       \
        ParcelType                                                            \
    );


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************ vim: set sw=4 sts=4 et: ************************ //
