/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::block

Description
    Creates a single block of cells from point coordinates,
    numbers of cells in each direction and expansion ratio


SourceFiles
    block.C
    blockIO.C


\*---------------------------------------------------------------------------*/

#ifndef block_H
#define block_H

#include <OpenFOAM/pointField.H>
#include <OpenFOAM/labelList.H>

#include "../../generation/blockMesh/blockDescriptor.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

class Istream;
class Ostream;

/*---------------------------------------------------------------------------*\
                           Class block Declaration
\*---------------------------------------------------------------------------*/

class block
{
    // Private data

        //- block definition
        blockDescriptor BlockDef;

        //- list of vertices
        pointField Vertices;

        //- list of cells
        labelListList Cells;

        //- boundary patches
        labelListListList BoundaryPatches;


    // private member functions

        label vtxLabel(label i, label j, label k);

        void blockPoints();

        void blockCells();

        void blockBoundary();

public:

    // Constructors

        //- from the block definition
        block(const blockDescriptor&);

        //- as copy
        block(const block&);

        //- clone function
        autoPtr<block> clone() const
        {
            notImplemented("block::clone()");
            return autoPtr<block>(NULL);
        }

    // Destructor

        ~block();


    // Member Functions

        // Access

        const blockDescriptor& blockDef() const;
        const pointField& points() const;
        const labelListList& cells() const;
        const labelListListList& boundaryPatches() const;


    // IOstream Operators

        friend Ostream& operator<<(Ostream&, const block&);
};


inline Istream& operator>>(Istream& is, block*)
{
    notImplemented("Istream& operator>>(Istream& is, block*)");
    return is;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************ vim: set sw=4 sts=4 et: ************************ //
