/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file plugins.h
 * \brief Plugins header
 */

#ifndef PLUGINS_H
#define PLUGINS_H

#define PLUGIN_LOADER_VERSION	0x19

#define PLUGIN_TYPE_LOOKUP		0x01
#define PLUGIN_TYPE_BOOK		0x02
#define PLUGIN_TYPE_FAX			0x03
#define PLUGIN_TYPE_PASSWORD	0x04
#define PLUGIN_TYPE_AUDIO		0x08

#define MODULE_INIT( TYPE, NAME, DATA, CLOSE, PRE_INIT )\
	G_MODULE_EXPORT int InitPlugin( struct sPlugin *psPlugin ) {\
		int ( *PreInit )( void );\
		psPlugin -> pnName = strdup( NAME );\
		psPlugin -> nVersion = PLUGIN_LOADER_VERSION;\
		psPlugin -> nType = TYPE;\
		psPlugin -> pData = DATA;\
		psPlugin -> Close = CLOSE;\
		PreInit = PRE_INIT;\
		if ( PreInit ) PreInit();\
		return 0;\
	}

struct sPerson;

typedef enum eRegExpType {
	perLine = 1,
	named = 2
} eRegExpType;

struct sLookup {
	gboolean bPrefix;
	gchar *pnService;
	gchar *pnUrl;
	eRegExpType eLookupType;
	gchar *pnName;
	gchar *pnStreet;
	gchar *pnCity;
	gchar *pnPattern;
};

struct sAddressBook {
	int ( *ReadBook )( void );
	int ( *SaveBook )( void );
	int nReadFlags;
	int nWriteFlags;
	void ( *Preferences )( void );
};

struct sFax {
	int ( *Init )( int nController, int DebugLevel );
	int ( *Receive )( const char *pnFile, int nBitrate, int nEcm, const char *SenderMsn, char *pnNumber, const char *pnSenderNumber, const char *pnSenderName, int nManualHookUp );
	int ( *Send )(  const char *pnFile, int nBitrate, int nEcm, int nController, const char *SenderMsn, const char *pnNumber, const char *pnSenderNumber, const char *pnSenderName, int nCallAnonymous, char *pnReportDir );
	int ( *Close )( void );
};

struct sPassword {
	const gchar *( *GetPassword )( struct sProfile *psProfile );
	void ( *SetPassword )( struct sProfile *psProfile, const gchar *pnPassword );
	void ( *RemovePassword )( struct sProfile *psProfile );
};

struct sAudio {
	int ( *Init )( unsigned char nChannels, unsigned short nRate, unsigned char nBits );
	gpointer ( *Open )( void );
	int ( *Write )( gpointer pPriv, unsigned char *pnBuffer, unsigned int nLen );
	int ( *Read )( gpointer pPriv, unsigned char *pnBuffer, unsigned int nMaxLen );
	int ( *Close )(  gpointer pPriv, gboolean bForce );
	int ( *Deinit )( void );
	void ( *Preferences )( void );
};

struct sPlugin {
	char *pnName;
	int nVersion;
	int nType;
	void *pData;
	int ( *Close )( void );

	GModule *psModule;
} __attribute__((packed));

GList *psPluginList;
struct sProfile;

struct sLookup *getDefaultLookupPlugin( struct sProfile *psProfile );
struct sAddressBook *getDefaultBookPlugin( struct sProfile *psProfile );
struct sFax *getDefaultFaxPlugin( struct sProfile *psProfile );
struct sPassword *getDefaultPasswordPlugin( struct sProfile *psProfile );
struct sAudio *getDefaultAudioPlugin( struct sProfile *psProfile );
struct sPlugin *findPlugin( gint nType, const gchar *pnName );
void setDefaultPlugin( struct sProfile *psProfile, int nType, const char *pnName );
void PluginsLoad( char *pnPluginDir );
void PluginsUnload( void );

#endif
