/* SPDX-FileCopyrightText: 2024 - Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gtex-tree-model-node.h"

/**
 * SECTION:tree-model-node
 * @title: GtexTreeModelNode
 * @short_description: #GtkTreeModel based on #GNode
 *
 * WIP, to implement.
 */

struct _GtexTreeModelNodePrivate
{
	gint something;
};

G_DEFINE_TYPE_WITH_PRIVATE (GtexTreeModelNode, gtex_tree_model_node, G_TYPE_OBJECT)

static void
gtex_tree_model_node_finalize (GObject *object)
{

	G_OBJECT_CLASS (gtex_tree_model_node_parent_class)->finalize (object);
}

static void
gtex_tree_model_node_class_init (GtexTreeModelNodeClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	object_class->finalize = gtex_tree_model_node_finalize;
}

static void
gtex_tree_model_node_init (GtexTreeModelNode *model)
{
	model->priv = gtex_tree_model_node_get_instance_private (model);
}

/**
 * gtex_tree_model_node_new:
 *
 * Returns: (transfer full): a new #GtexTreeModelNode object.
 */
GtexTreeModelNode *
gtex_tree_model_node_new (void)
{
	return g_object_new (GTEX_TYPE_TREE_MODEL_NODE, NULL);
}
