#ifndef __qmakesettingstab__
#define __qmakesettingstab__

/**
@file
Subclass of QmakeSettingsTabBase, which is generated by wxFormBuilder.
*/
class QmakeConf;

#include "qmakesettingsbasedlg.h"

/** Implementing QmakeSettingsTabBase */
class QmakeSettingsTab : public QmakeSettingsTabBase
{
	wxString       m_name;
	wxArrayString  GetSpecList(const wxString &qmakePath);

public:
	/** Constructor */
	QmakeSettingsTab( wxWindow* parent, const wxString &name );

	void Load(QmakeConf *conf);
	void Save(QmakeConf *conf);
	void OnFileSelected(wxFileDirPickerEvent &event);

	void SetTabName(const wxString& name) {
		this->m_name = name;
	}
	const wxString& GetTabName() const {
		return m_name;
	}
};

#endif // __qmakesettingstab__
