/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:00:20 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GFF3AttributeBuilder;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GFFStreamFeature_ESTest extends GFFStreamFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      // Undeclared exception!
      try { 
        GFFStreamFeature.readFromStream((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Key key0 = Key.CDS;
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature(key0, (Location) null, (QualifierVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature((Feature) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(emblStreamFeature0, false);
      // Undeclared exception!
      try { 
        gFFStreamFeature0.getAutoNumber("9L", '_');
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(emblStreamFeature0);
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Key key0 = new Key("}", false);
      Range range0 = new Range(52);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      gFFStreamFeature0.setGffSeqName("");
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("", gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Key key0 = new Key("}", false);
      Range range0 = new Range(52);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      String string0 = gFFStreamFeature0.getGffSeqName();
      assertNull(string0);
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      boolean boolean0 = GFFStreamFeature.isGTF((Feature) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      StringReader stringReader0 = new StringReader("S|1yFU7m?(v");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      try { 
        GFFStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // invalid GFF line: 8 fields needed (got 1 fields) from: S|1yFU7m?(v
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Key key0 = new Key("}", false);
      Range range0 = new Range(52);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      gFFStreamFeature0.getPrefix("", '6');
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Key key0 = new Key("}", false);
      Range range0 = new Range(52);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      gFFStreamFeature0.getSegmentID(rangeVector0);
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Key key0 = new Key("}", false);
      Range range0 = new Range(52);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertNotNull(string0);
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      Hashtable<String, Range> hashtable0 = databaseStreamFeature0.getSegmentRangeStore();
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertTrue(databaseStreamFeature0.isVisible());
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertNotNull(hashtable0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature("Auto hide scrollbar");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // invalid GFF line: 8 fields needed (got 1 fields) from: Auto hide scrollbar
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      GFFStreamFeature.removeAttribute((String) null);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(emblStreamFeature0);
      databaseStreamFeature0.getChadoGene();
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertTrue(databaseStreamFeature0.isVisible());
      assertFalse(databaseStreamFeature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      GFFStreamFeature.includeAttribute("Y");
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Key key0 = new Key("}", false);
      Range range0 = new Range(52);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0, false);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Key key0 = new Key("}", false);
      Range range0 = new Range(52);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, false);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFFStreamFeature0.prepareProcessors(gFF3AttributeBuilder0);
  }
}
