#include "resource.hpp"

namespace Resource {
namespace GameBoy {
const unsigned char BootDMG0[256] = {
  49,254,255,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,119,62,252,224,
  71,33,4,1,229,17,203,0,26,19,190,32,107,35,125,254,52,32,245,6,25,120,134,35,5,32,251,134,32,90,209,33,
  16,128,26,205,169,0,205,170,0,19,123,254,52,32,243,62,24,33,47,153,14,12,50,61,40,9,13,32,249,17,236,255,
  25,24,241,103,62,100,87,224,66,62,145,224,64,4,30,2,205,188,0,14,19,36,124,30,131,254,98,40,6,30,193,254,
  100,32,6,123,226,12,62,135,226,240,66,144,224,66,21,32,221,5,32,105,22,32,24,214,62,145,224,64,30,20,205,188,
  0,240,71,238,255,224,71,24,243,79,6,4,197,203,17,23,193,203,17,23,5,32,245,34,35,34,35,201,14,12,240,68,
  254,144,32,250,13,32,247,29,32,242,201,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,
  137,0,14,220,204,110,230,221,221,217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,255,255,60,224,80,
};
const unsigned char BootDMG1[256] = {
  49,254,255,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,119,62,252,224,
  71,17,4,1,33,16,128,26,205,149,0,205,150,0,19,123,254,52,32,243,17,216,0,6,8,26,19,34,35,5,32,249,
  62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,103,62,100,87,224,66,62,145,224,64,4,
  30,2,14,12,240,68,254,144,32,250,13,32,247,29,32,242,14,19,36,124,30,131,254,98,40,6,30,193,254,100,32,6,
  123,226,12,62,135,226,240,66,144,224,66,21,32,210,5,32,79,22,32,24,203,79,6,4,197,203,17,23,193,203,17,23,
  5,32,245,34,35,34,35,201,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,
  220,204,110,230,221,221,217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,
  33,4,1,17,168,0,26,19,190,32,254,35,125,254,52,32,245,6,25,120,134,35,5,32,251,134,32,254,62,1,224,80,
};
const unsigned char BootMGB[256] = {
  49,254,255,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,119,62,252,224,
  71,17,4,1,33,16,128,26,205,149,0,205,150,0,19,123,254,52,32,243,17,216,0,6,8,26,19,34,35,5,32,249,
  62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,103,62,100,87,224,66,62,145,224,64,4,
  30,2,14,12,240,68,254,144,32,250,13,32,247,29,32,242,14,19,36,124,30,131,254,98,40,6,30,193,254,100,32,6,
  123,226,12,62,135,226,240,66,144,224,66,21,32,210,5,32,79,22,32,24,203,79,6,4,197,203,17,23,193,203,17,23,
  5,32,245,34,35,34,35,201,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,
  220,204,110,230,221,221,217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,
  33,4,1,17,168,0,26,19,190,32,254,35,125,254,52,32,245,6,25,120,134,35,5,32,251,134,32,254,62,255,224,80,
};
}
namespace GameBoyColor {
const unsigned char BootCGB0[2048] = {
  49,254,255,62,2,195,124,0,211,0,152,160,18,211,0,128,0,64,30,83,208,0,31,66,28,0,20,42,77,25,140,126,
  0,124,49,110,74,69,82,74,0,0,255,83,31,124,255,3,31,0,255,31,167,0,239,27,31,0,239,27,0,124,0,0,
  255,3,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,220,204,110,230,221,221,
  217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,88,67,224,112,62,252,
  224,71,205,117,2,205,0,2,38,208,205,3,2,33,0,254,14,160,175,34,13,32,252,17,4,1,33,16,128,76,26,226,
  12,205,187,3,205,188,3,19,123,254,52,32,241,17,114,0,6,8,26,19,34,35,5,32,249,205,229,3,62,1,224,79,
  62,145,224,64,33,178,152,6,78,14,68,205,134,2,175,224,79,14,128,33,66,0,6,24,242,12,190,32,254,35,5,32,
  247,33,52,1,6,25,120,134,44,5,32,251,134,32,254,205,17,3,24,2,0,0,205,208,5,175,224,112,62,17,224,80,
  33,0,128,175,34,203,108,40,251,201,42,18,19,13,32,250,201,229,33,15,255,203,134,203,70,40,252,225,201,17,0,255,
  33,3,208,14,15,62,48,18,62,32,18,26,47,161,203,55,71,62,16,18,26,47,161,176,79,126,169,230,240,71,42,169,
  161,176,50,71,121,119,62,48,18,201,62,128,224,104,224,106,14,107,42,226,5,32,251,74,9,67,14,105,42,226,5,32,
  251,201,197,213,229,33,0,216,6,1,22,63,30,64,205,74,2,225,209,193,201,62,128,224,38,224,17,62,243,224,18,224,
  37,62,119,224,36,201,205,17,2,205,98,2,121,254,56,32,20,229,175,224,79,33,167,153,62,56,34,60,254,63,32,250,
  62,1,224,79,225,197,229,33,67,1,203,126,204,137,5,225,193,205,17,2,121,214,48,210,251,2,121,254,1,202,251,2,
  125,254,209,40,33,197,6,3,14,1,22,3,126,230,248,177,34,21,32,248,12,121,254,6,32,240,17,17,0,25,5,32,
  231,17,161,255,25,193,4,120,30,131,254,98,40,6,30,193,254,100,32,7,123,224,19,62,135,224,20,250,2,208,254,0,
  40,10,61,234,2,208,121,254,1,202,134,2,13,194,134,2,201,14,38,205,63,3,205,17,2,205,98,2,13,32,244,205,
  17,2,62,1,224,79,205,51,3,205,54,3,175,224,79,205,51,3,201,33,8,0,17,81,255,14,5,205,10,2,201,197,
  213,229,33,64,216,14,32,126,230,31,254,31,40,1,60,87,42,7,7,7,230,7,71,58,7,7,7,230,24,176,254,31,
  40,1,60,15,15,15,71,230,224,178,34,120,230,3,95,126,15,15,230,31,254,31,40,1,60,7,7,179,34,13,32,199,
  225,209,193,201,14,0,26,230,240,203,73,40,2,203,55,71,35,126,176,34,26,230,15,203,73,32,2,203,55,71,35,126,
  176,34,19,203,65,40,13,213,17,248,255,203,73,40,3,17,8,0,25,209,12,121,254,24,32,204,201,71,213,22,4,88,
  203,16,23,203,19,23,21,32,246,209,34,35,34,35,201,62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,
  46,15,24,243,201,62,1,224,79,205,0,2,17,7,6,33,128,128,6,48,14,4,26,34,35,34,35,19,13,32,247,5,
  32,242,17,4,1,205,132,3,1,168,255,9,205,132,3,1,248,255,9,17,114,0,14,8,35,26,34,19,13,32,249,33,
  194,152,6,8,62,8,14,16,34,13,32,252,17,16,0,25,5,32,243,175,224,79,33,194,152,62,8,34,60,254,24,32,
  2,46,226,254,40,32,3,33,2,153,254,56,32,237,33,216,8,17,64,216,6,8,62,255,18,19,18,19,14,2,205,10,
  2,62,0,18,19,18,19,19,19,5,32,234,205,98,2,33,75,1,126,254,51,32,11,46,68,30,48,42,187,32,73,28,
  24,4,46,75,30,1,42,187,32,62,46,52,1,16,0,42,128,71,13,32,250,234,0,208,33,199,6,14,0,42,184,40,
  8,12,121,254,79,32,246,24,31,121,214,65,56,28,33,22,7,22,0,95,25,250,55,1,87,126,186,40,13,17,14,0,
  25,121,131,79,214,94,56,237,14,0,33,51,7,6,0,9,126,230,31,234,6,208,234,8,208,126,230,224,7,7,7,234,
  9,208,234,11,208,205,233,4,201,17,145,7,33,0,217,250,11,208,71,14,30,203,64,32,2,19,19,26,34,32,2,27,
  27,203,72,32,2,19,19,26,34,19,19,32,2,27,27,203,80,40,5,27,43,26,34,19,26,34,19,13,32,215,33,0,
  217,17,0,218,205,100,5,201,33,18,0,250,5,208,7,7,6,0,79,9,17,64,216,6,8,229,14,2,205,10,2,19,
  19,19,19,19,19,225,5,32,240,17,66,216,14,2,205,10,2,17,74,216,14,2,205,10,2,43,43,17,68,216,14,2,
  205,10,2,201,14,96,42,229,197,33,232,7,6,0,79,9,14,8,205,10,2,193,225,13,32,236,201,250,8,208,17,24,
  0,60,61,40,3,25,32,250,201,205,29,2,120,230,255,40,15,33,228,8,6,0,42,185,40,8,4,120,254,12,32,246,
  24,45,120,234,5,208,62,30,234,2,208,17,11,0,25,86,122,230,31,95,33,8,208,58,34,123,119,122,230,224,7,7,
  7,95,33,11,208,58,34,123,119,205,233,4,205,40,5,201,205,17,2,250,67,1,203,127,40,4,224,76,24,40,62,4,
  224,76,62,1,224,108,33,0,218,205,123,5,6,16,22,0,30,8,205,74,2,33,122,0,250,0,208,71,14,2,42,184,
  204,207,3,13,32,248,201,1,15,63,126,255,255,192,0,192,240,241,3,124,252,254,254,3,7,7,15,224,224,240,240,30,
  62,126,254,15,15,31,31,255,255,0,0,1,1,1,3,255,255,225,224,192,240,249,251,31,127,248,224,243,253,62,30,224,
  240,249,127,62,124,248,224,248,240,240,248,0,0,127,127,7,15,159,191,158,31,255,255,15,30,62,60,241,251,127,127,254,
  222,223,159,31,63,62,60,248,248,0,0,3,3,7,7,255,255,193,192,243,231,247,243,192,192,192,192,31,31,30,62,63,
  31,62,62,128,0,0,0,124,31,7,0,15,255,254,0,124,248,240,0,31,15,15,0,124,248,248,0,63,62,28,0,15,
  15,15,0,124,255,255,0,0,248,248,0,7,15,15,0,129,255,255,0,243,225,128,0,224,255,127,0,252,240,192,0,62,
  124,124,0,0,0,0,0,0,136,22,54,209,219,242,60,140,146,61,92,88,201,62,112,29,89,105,25,53,168,20,170,117,
  149,153,52,111,21,255,151,75,144,23,16,57,247,246,162,73,78,67,104,224,139,240,206,12,41,232,183,134,154,82,1,157,
  113,156,189,93,109,103,63,107,179,70,40,165,198,211,39,97,24,102,106,191,13,244,66,69,70,65,65,82,66,69,75,69,
  75,32,82,45,85,82,65,82,32,73,78,65,73,76,73,67,69,32,82,124,8,18,163,162,7,135,75,32,18,101,168,22,
  169,134,177,104,160,135,102,18,161,48,60,18,133,18,100,27,7,6,111,110,110,174,175,111,178,175,178,168,171,111,175,134,
  174,162,162,18,175,19,18,161,110,175,175,173,6,76,110,175,175,18,124,172,168,106,110,19,160,45,168,43,172,100,172,109,
  135,188,96,180,19,114,124,181,174,174,124,124,101,162,108,100,133,128,176,64,136,32,104,222,0,112,222,32,120,32,32,56,
  32,176,144,32,176,160,224,176,192,152,182,72,128,224,80,30,30,88,32,184,224,136,176,16,32,0,16,32,224,24,224,24,
  0,24,224,32,168,224,32,24,224,0,32,24,216,200,24,224,0,224,64,40,40,40,24,224,96,32,24,224,0,0,8,224,
  24,48,208,208,208,32,224,232,255,127,191,50,208,0,0,0,159,99,121,66,176,21,203,4,255,127,49,110,74,69,0,0,
  255,127,239,27,0,2,0,0,255,127,31,66,242,28,0,0,255,127,148,82,74,41,0,0,255,127,255,3,47,1,0,0,
  255,127,239,3,214,1,0,0,255,127,181,66,200,61,0,0,116,126,255,3,128,1,0,0,255,103,172,119,19,26,107,45,
  214,126,255,75,117,33,0,0,255,83,95,74,82,126,0,0,255,79,210,126,76,58,224,28,237,3,255,127,95,37,0,0,
  106,3,31,2,255,3,255,127,255,127,223,1,18,1,0,0,31,35,95,3,242,0,9,0,255,127,234,3,31,1,0,0,
  159,41,26,0,12,0,0,0,255,127,127,2,31,0,0,0,255,127,224,3,6,2,32,1,255,127,235,126,31,0,0,124,
  255,127,255,63,0,126,31,0,255,127,255,3,31,0,0,0,255,3,31,0,12,0,0,0,255,127,63,3,147,1,0,0,
  0,0,0,66,127,3,255,127,255,127,140,126,0,124,0,0,255,127,239,27,128,97,0,0,255,127,0,124,224,3,31,124,
  31,0,255,3,64,65,66,32,33,34,128,129,130,16,17,18,18,176,121,184,173,22,23,7,186,5,124,19,0,0,0,0,
};
const unsigned char BootCGB1[2048] = {
  49,254,255,62,2,195,124,0,211,0,152,160,18,211,0,128,0,64,30,83,208,0,31,66,28,0,20,42,77,25,140,126,
  0,124,49,110,74,69,82,74,0,0,255,83,31,124,255,3,31,0,255,31,167,0,239,27,31,0,239,27,0,124,0,0,
  255,3,206,237,102,102,204,13,0,11,3,115,0,131,0,12,0,13,0,8,17,31,136,137,0,14,220,204,110,230,221,221,
  217,153,187,187,103,99,110,14,236,204,221,220,153,159,187,185,51,62,60,66,185,165,185,165,66,60,88,67,224,112,62,252,
  224,71,205,117,2,205,0,2,38,208,205,3,2,33,0,254,14,160,175,34,13,32,252,17,4,1,33,16,128,76,26,226,
  12,205,198,3,205,199,3,19,123,254,52,32,241,17,114,0,6,8,26,19,34,35,5,32,249,205,240,3,62,1,224,79,
  62,145,224,64,33,178,152,6,78,14,68,205,145,2,175,224,79,14,128,33,66,0,6,24,242,12,190,32,254,35,5,32,
  247,33,52,1,6,25,120,134,44,5,32,251,134,32,254,205,28,3,24,2,0,0,205,208,5,175,224,112,62,17,224,80,
  33,0,128,175,34,203,108,40,251,201,42,18,19,13,32,250,201,229,33,15,255,203,134,203,70,40,252,225,201,17,0,255,
  33,3,208,14,15,62,48,18,62,32,18,26,47,161,203,55,71,62,16,18,26,47,161,176,79,126,169,230,240,71,42,169,
  161,176,50,71,121,119,62,48,18,201,62,128,224,104,224,106,14,107,42,226,5,32,251,74,9,67,14,105,42,226,5,32,
  251,201,197,213,229,33,0,216,6,1,22,63,30,64,205,74,2,225,209,193,201,62,128,224,38,224,17,62,243,224,18,224,
  37,62,119,224,36,33,48,255,175,14,16,34,47,13,32,251,201,205,17,2,205,98,2,121,254,56,32,20,229,175,224,79,
  33,167,153,62,56,34,60,254,63,32,250,62,1,224,79,225,197,229,33,67,1,203,126,204,137,5,225,193,205,17,2,121,
  214,48,210,6,3,121,254,1,202,6,3,125,254,209,40,33,197,6,3,14,1,22,3,126,230,248,177,34,21,32,248,12,
  121,254,6,32,240,17,17,0,25,5,32,231,17,161,255,25,193,4,120,30,131,254,98,40,6,30,193,254,100,32,7,123,
  224,19,62,135,224,20,250,2,208,254,0,40,10,61,234,2,208,121,254,1,202,145,2,13,194,145,2,201,14,38,205,74,
  3,205,17,2,205,98,2,13,32,244,205,17,2,62,1,224,79,205,62,3,205,65,3,175,224,79,205,62,3,201,33,8,
  0,17,81,255,14,5,205,10,2,201,197,213,229,33,64,216,14,32,126,230,31,254,31,40,1,60,87,42,7,7,7,230,
  7,71,58,7,7,7,230,24,176,254,31,40,1,60,15,15,15,71,230,224,178,34,120,230,3,95,126,15,15,230,31,254,
  31,40,1,60,7,7,179,34,13,32,199,225,209,193,201,14,0,26,230,240,203,73,40,2,203,55,71,35,126,176,34,26,
  230,15,203,73,32,2,203,55,71,35,126,176,34,19,203,65,40,13,213,17,248,255,203,73,40,3,17,8,0,25,209,12,
  121,254,24,32,204,201,71,213,22,4,88,203,16,23,203,19,23,21,32,246,209,34,35,34,35,201,62,25,234,16,153,33,
  47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,201,62,1,224,79,205,0,2,17,7,6,33,128,128,14,192,26,
  34,35,34,35,19,13,32,247,17,4,1,205,143,3,1,168,255,9,205,143,3,1,248,255,9,17,114,0,14,8,35,26,
  34,19,13,32,249,33,194,152,6,8,62,8,14,16,34,13,32,252,17,16,0,25,5,32,243,175,224,79,33,194,152,62,
  8,34,60,254,24,32,2,46,226,254,40,32,3,33,2,153,254,56,32,237,33,216,8,17,64,216,6,8,62,255,18,19,
  18,19,14,2,205,10,2,62,0,18,19,18,19,19,19,5,32,234,205,98,2,33,75,1,126,254,51,32,11,46,68,30,
  48,42,187,32,73,28,24,4,46,75,30,1,42,187,32,62,46,52,1,16,0,42,128,71,13,32,250,234,0,208,33,199,
  6,14,0,42,184,40,8,12,121,254,79,32,246,24,31,121,214,65,56,28,33,22,7,22,0,95,25,250,55,1,87,126,
  186,40,13,17,14,0,25,121,131,79,214,94,56,237,14,0,33,51,7,6,0,9,126,230,31,234,8,208,126,230,224,7,
  7,7,234,11,208,205,233,4,201,17,145,7,33,0,217,250,11,208,71,14,30,203,64,32,2,19,19,26,34,32,2,27,
  27,203,72,32,2,19,19,26,34,19,19,32,2,27,27,203,80,40,5,27,43,26,34,19,26,34,19,13,32,215,33,0,
  217,17,0,218,205,100,5,201,33,18,0,250,5,208,7,7,6,0,79,9,17,64,216,6,8,229,14,2,205,10,2,19,
  19,19,19,19,19,225,5,32,240,17,66,216,14,2,205,10,2,17,74,216,14,2,205,10,2,43,43,17,68,216,14,2,
  205,10,2,201,14,96,42,229,197,33,232,7,6,0,79,9,14,8,205,10,2,193,225,13,32,236,201,250,8,208,17,24,
  0,60,61,40,3,25,32,250,201,205,29,2,120,230,255,40,15,33,228,8,6,0,42,185,40,8,4,120,254,12,32,246,
  24,45,120,234,5,208,62,30,234,2,208,17,11,0,25,86,122,230,31,95,33,8,208,58,34,123,119,122,230,224,7,7,
  7,95,33,11,208,58,34,123,119,205,233,4,205,40,5,201,205,17,2,250,67,1,203,127,40,4,224,76,24,40,62,4,
  224,76,62,1,224,108,33,0,218,205,123,5,6,16,22,0,30,8,205,74,2,33,122,0,250,0,208,71,14,2,42,184,
  204,218,3,13,32,248,201,1,15,63,126,255,255,192,0,192,240,241,3,124,252,254,254,3,7,7,15,224,224,240,240,30,
  62,126,254,15,15,31,31,255,255,0,0,1,1,1,3,255,255,225,224,192,240,249,251,31,127,248,224,243,253,62,30,224,
  240,249,127,62,124,248,224,248,240,240,248,0,0,127,127,7,15,159,191,158,31,255,255,15,30,62,60,241,251,127,127,254,
  222,223,159,31,63,62,60,248,248,0,0,3,3,7,7,255,255,193,192,243,231,247,243,192,192,192,192,31,31,30,62,63,
  31,62,62,128,0,0,0,124,31,7,0,15,255,254,0,124,248,240,0,31,15,15,0,124,248,248,0,63,62,28,0,15,
  15,15,0,124,255,255,0,0,248,248,0,7,15,15,0,129,255,255,0,243,225,128,0,224,255,127,0,252,240,192,0,62,
  124,124,0,0,0,0,0,0,136,22,54,209,219,242,60,140,146,61,92,88,201,62,112,29,89,105,25,53,168,20,170,117,
  149,153,52,111,21,255,151,75,144,23,16,57,247,246,162,73,78,67,104,224,139,240,206,12,41,232,183,134,154,82,1,157,
  113,156,189,93,109,103,63,107,179,70,40,165,198,211,39,97,24,102,106,191,13,244,66,69,70,65,65,82,66,69,75,69,
  75,32,82,45,85,82,65,82,32,73,78,65,73,76,73,67,69,32,82,124,8,18,163,162,7,135,75,32,18,101,168,22,
  169,134,177,104,160,135,102,18,161,48,60,18,133,18,100,27,7,6,111,110,110,174,175,111,178,175,178,168,171,111,175,134,
  174,162,162,18,175,19,18,161,110,175,175,173,6,76,110,175,175,18,124,172,168,106,110,19,160,45,168,43,172,100,172,109,
  135,188,96,180,19,114,124,181,174,174,124,124,101,162,108,100,133,128,176,64,136,32,104,222,0,112,222,32,120,32,32,56,
  32,176,144,32,176,160,224,176,192,152,182,72,128,224,80,30,30,88,32,184,224,136,176,16,32,0,16,32,224,24,224,24,
  0,24,224,32,168,224,32,24,224,0,32,24,216,200,24,224,0,224,64,40,40,40,24,224,96,32,24,224,0,0,8,224,
  24,48,208,208,208,32,224,232,255,127,191,50,208,0,0,0,159,99,121,66,176,21,203,4,255,127,49,110,74,69,0,0,
  255,127,239,27,0,2,0,0,255,127,31,66,242,28,0,0,255,127,148,82,74,41,0,0,255,127,255,3,47,1,0,0,
  255,127,239,3,214,1,0,0,255,127,181,66,200,61,0,0,116,126,255,3,128,1,0,0,255,103,172,119,19,26,107,45,
  214,126,255,75,117,33,0,0,255,83,95,74,82,126,0,0,255,79,210,126,76,58,224,28,237,3,255,127,95,37,0,0,
  106,3,31,2,255,3,255,127,255,127,223,1,18,1,0,0,31,35,95,3,242,0,9,0,255,127,234,3,31,1,0,0,
  159,41,26,0,12,0,0,0,255,127,127,2,31,0,0,0,255,127,224,3,6,2,32,1,255,127,235,126,31,0,0,124,
  255,127,255,63,0,126,31,0,255,127,255,3,31,0,0,0,255,3,31,0,12,0,0,0,255,127,63,3,147,1,0,0,
  0,0,0,66,127,3,255,127,255,127,140,126,0,124,0,0,255,127,239,27,128,97,0,0,255,127,0,124,224,3,31,124,
  31,0,255,3,64,65,66,32,33,34,128,129,130,16,17,18,18,176,121,184,173,22,23,7,186,5,124,19,0,0,0,0,
};
}
namespace MegaDrive {
const unsigned char TMSS[2048] = {
  0,255,255,0,0,0,2,2,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,
  83,69,71,65,32,71,69,78,69,83,73,83,32,32,32,32,40,67,41,83,69,71,65,32,49,57,57,48,46,77,65,89,
  71,69,78,69,83,73,83,32,79,83,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,71,69,78,69,83,73,83,32,79,83,32,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  79,83,32,48,48,48,48,48,48,48,48,45,48,48,91,116,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  0,0,0,0,0,0,7,255,0,255,0,0,0,255,255,255,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,85,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  96,254,75,250,0,106,76,221,31,224,16,41,239,1,2,0,0,15,103,8,35,124,83,69,71,65,47,0,48,20,112,0,
  44,64,78,102,114,23,26,29,56,133,218,71,81,201,255,248,40,188,64,0,0,128,54,128,56,20,8,4,0,1,102,248,
  40,188,129,4,143,2,40,188,192,0,0,0,118,31,38,128,81,203,255,252,40,188,64,0,0,16,120,19,38,128,81,204,
  255,252,122,3,23,93,0,17,81,205,255,250,96,60,0,0,128,0,0,0,63,255,0,0,1,0,0,160,0,0,0,161,
  17,0,0,161,18,0,0,192,0,0,0,192,0,4,4,20,48,60,7,108,0,0,0,0,255,0,129,55,0,1,1,0,
  0,255,255,0,0,128,159,191,223,255,65,248,192,0,67,250,0,22,76,217,124,240,48,60,0,63,48,217,81,200,255,252,
  78,184,192,0,96,254,32,83,69,71,69,148,0,3,0,0,0,247,83,69,71,65,0,161,64,0,0,161,65,1,0,192,
  0,4,0,192,0,0,0,161,0,1,8,211,0,0,190,184,1,0,103,34,184,184,1,0,102,8,12,56,0,65,1,4,
  103,20,8,147,0,0,16,22,2,0,0,15,103,6,36,188,0,0,0,0,78,117,8,147,0,0,78,185,0,0,7,140,
  40,188,76,32,0,0,42,153,81,206,255,252,78,185,0,0,7,156,56,188,129,68,48,60,0,60,97,32,56,188,129,4,
  16,22,2,0,0,15,103,6,36,188,0,0,0,0,8,211,0,0,112,0,32,64,46,88,32,88,78,208,50,60,149,206,
  81,201,255,254,81,200,255,246,78,117,0,1,14,238,14,232,1,17,17,0,17,0,1,16,17,0,1,16,17,0,1,16,
  17,17,17,16,17,0,1,16,17,0,1,16,0,0,0,0,17,17,17,0,17,0,1,16,17,0,1,16,17,17,17,0,
  17,0,1,16,17,0,1,16,17,17,17,0,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,0,0,0,
  17,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,17,17,0,17,0,1,16,17,0,1,16,17,0,1,16,
  17,0,1,16,17,0,1,16,17,17,17,0,0,0,0,0,17,17,17,16,17,0,0,0,17,0,0,0,17,17,17,0,
  17,0,0,0,17,0,0,0,17,17,17,16,0,0,0,0,17,17,17,16,17,0,0,0,17,0,0,0,17,17,17,0,
  17,0,0,0,17,0,0,0,17,0,0,0,0,0,0,0,17,17,17,16,17,0,1,16,17,0,0,0,17,0,17,16,
  17,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,17,17,17,16,
  17,0,1,16,17,0,1,16,17,0,1,16,0,0,0,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,
  0,17,16,0,0,17,16,0,0,17,16,0,0,0,0,0,0,0,1,16,0,0,1,16,0,0,1,16,0,0,1,16,
  0,0,1,16,1,16,1,16,1,17,17,16,0,0,0,0,17,0,1,16,17,0,17,0,17,17,16,0,17,17,16,0,
  17,0,17,0,17,0,1,16,17,0,1,16,0,0,0,0,1,16,0,0,1,16,0,0,1,16,0,0,1,16,0,0,
  1,16,0,0,1,16,0,0,1,17,17,16,0,0,0,0,17,0,1,16,17,16,17,16,17,17,17,16,17,1,1,16,
  17,0,1,16,17,0,1,16,17,0,1,16,0,0,0,0,17,0,1,16,17,16,1,16,17,17,1,16,17,1,17,16,
  17,0,17,16,17,0,1,16,17,0,1,16,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,0,1,16,
  17,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,17,17,16,
  17,0,0,0,17,0,0,0,17,0,0,0,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,0,1,16,
  17,0,17,16,17,0,17,16,17,17,17,16,0,0,0,0,17,17,17,16,17,0,1,16,17,0,1,16,17,17,17,0,
  17,0,1,16,17,0,1,16,17,0,1,16,0,0,0,0,17,17,17,16,17,0,1,16,17,0,0,0,17,17,17,16,
  0,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,17,17,16,0,17,16,0,0,17,16,0,0,17,16,0,
  0,17,16,0,0,17,16,0,0,17,16,0,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,17,0,1,16,
  17,0,1,16,17,0,1,16,17,17,17,16,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,17,0,1,16,
  1,16,17,0,0,17,16,0,0,1,0,0,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,17,1,1,16,
  17,17,17,16,17,16,17,16,17,0,1,16,0,0,0,0,17,0,1,16,17,0,1,16,17,16,17,16,1,17,17,0,
  17,16,17,16,17,0,1,16,17,0,1,16,0,0,0,0,17,0,1,16,17,0,1,16,17,0,1,16,1,16,17,0,
  0,17,16,0,0,17,16,0,0,17,16,0,0,0,0,0,17,17,17,16,0,0,17,16,0,1,17,0,0,17,16,0,
  1,17,0,0,17,16,0,0,17,17,17,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,16,0,0,1,16,0,0,0,0,0,0,2,34,34,0,34,0,2,32,34,0,0,0,2,34,34,0,
  0,0,2,32,34,0,2,32,2,34,34,0,0,0,0,0,2,34,34,32,34,0,0,0,34,0,0,0,34,34,34,0,
  34,0,0,0,34,0,0,0,2,34,34,32,0,0,0,0,2,34,34,0,34,0,2,32,34,0,0,0,34,0,34,32,
  34,0,2,32,34,0,2,32,2,34,34,32,0,0,0,0,0,2,32,0,0,34,34,0,0,34,34,0,2,32,2,32,
  2,32,2,32,34,0,0,34,34,2,34,34,0,0,0,0,32,32,32,112,114,111,100,117,99,101,100,32,98,121,32,111,
  114,255,32,117,110,100,101,114,32,108,105,99,101,110,115,101,32,102,114,111,109,255,115,101,103,97,44,101,110,116,101,114,
  112,114,105,115,101,115,32,108,116,100,123,0,48,25,40,188,192,2,0,0,58,153,81,200,255,252,78,117,40,133,114,0,
  18,25,107,8,102,2,78,117,58,129,96,242,6,133,1,0,0,0,96,232,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char SVP[2048] = {
  8,96,252,0,0,1,149,239,0,0,0,0,148,5,0,101,8,64,0,0,0,13,0,56,0,131,8,128,0,0,0,15,
  0,15,8,48,0,0,8,240,0,0,8,224,131,250,8,224,8,28,0,192,8,16,8,96,8,32,252,4,0,193,0,194,
  0,193,0,194,0,193,0,194,8,224,0,228,8,224,8,0,0,12,0,60,104,0,83,86,76,80,252,0,0,60,0,19,
  168,0,3,255,77,80,252,56,232,0,0,1,76,80,252,0,0,49,168,0,28,0,200,0,224,0,0,131,0,60,8,48,
  0,0,0,19,0,35,0,67,20,48,20,49,20,50,21,48,21,49,30,252,0,108,11,51,200,0,128,0,0,227,8,224,
  8,28,0,192,11,51,11,195,56,1,76,112,252,83,3,102,3,231,3,51,200,0,8,0,0,227,0,12,0,60,200,0,
  128,0,0,227,8,224,8,28,0,192,0,60,0,28,0,193,56,1,76,112,252,102,3,102,3,51,2,196,56,1,76,112,
  252,109,3,102,2,51,3,196,56,1,76,112,252,115,3,102,3,51,4,196,56,1,76,112,252,121,3,102,2,51,5,196,
  56,1,76,112,252,127,3,102,3,55,3,195,56,1,76,112,252,133,3,102,3,59,3,255,144,6,5,59,5,255,3,55,
  131,15,4,55,8,48,0,0,76,64,252,151,152,1,131,3,131,11,4,51,2,247,3,102,184,0,14,4,3,51,160,0,
  76,112,252,169,3,247,144,7,5,51,5,247,8,48,0,1,14,4,3,59,160,0,76,112,252,180,3,255,144,7,5,59,
  5,255,6,4,152,1,14,4,3,51,3,247,144,3,5,51,8,48,0,0,144,2,5,247,3,59,3,255,144,3,5,59,
  8,48,0,0,144,2,5,255,3,27,3,39,0,55,3,31,3,35,128,7,144,2,4,243,3,23,3,47,0,55,0,19,
  8,48,0,0,144,2,4,247,0,49,130,3,4,51,184,1,77,80,252,222,2,55,200,0,128,0,4,55,184,0,2,243,
  144,2,4,243,6,4,184,1,77,80,252,236,2,51,2,247,144,6,4,51,4,247,3,102,2,51,2,247,3,102,184,0,
  4,59,4,63,0,35,12,3,0,31,3,51,120,0,76,112,252,255,3,247,144,6,5,51,5,247,8,32,0,1,3,59,
  120,0,76,112,253,8,0,50,152,2,0,35,76,0,253,13,3,59,3,255,144,6,5,59,5,255,2,59,2,255,144,3,
  4,59,4,255,3,51,3,247,144,3,5,51,5,247,76,64,253,28,2,63,152,1,4,63,2,63,131,15,0,19,8,48,
  0,0,76,64,253,36,152,1,130,11,131,11,77,112,253,45,4,59,4,31,3,55,152,1,5,55,2,51,56,1,4,51,
  76,112,253,13,3,51,4,51,3,55,4,55,184,0,0,50,120,0,77,80,253,67,120,3,77,80,253,67,2,51,2,247,
  144,6,4,51,4,247,0,50,184,1,77,80,253,76,2,59,2,255,144,6,4,59,4,255,2,51,2,247,2,27,2,47,
  3,102,3,51,152,64,76,0,253,86,3,51,184,255,136,0,254,227,74,16,4,19,3,102,24,17,18,49,152,18,20,49,
  12,15,0,2,8,16,0,4,2,36,0,55,5,51,5,247,2,53,5,59,2,57,5,63,3,10,13,2,253,113,76,0,
  252,143,4,53,4,245,2,63,56,1,4,63,76,112,253,100,3,102,3,10,13,2,253,126,76,0,253,85,8,32,0,1,
  0,55,144,2,24,10,4,52,4,244,144,6,4,52,4,244,3,10,13,2,253,141,76,0,253,81,0,55,144,2,24,8,
  4,52,4,244,24,14,4,52,4,244,2,5,2,5,8,48,0,3,15,8,18,49,20,50,28,10,2,54,5,52,2,54,
  5,52,2,54,5,52,2,54,5,52,26,8,8,48,0,1,15,9,28,10,2,54,5,51,2,54,5,55,3,52,5,59,
  3,52,5,63,3,10,13,2,253,183,76,0,252,156,4,59,4,255,2,54,5,51,2,54,5,55,3,52,5,59,3,52,
  5,63,3,10,13,2,253,198,76,0,252,156,5,51,5,247,2,59,5,59,2,63,5,63,3,10,13,2,253,209,76,0,
  252,143,144,2,144,2,144,2,144,2,144,2,144,2,144,2,144,2,4,53,4,245,7,9,56,1,15,9,76,112,253,169,
  2,5,2,5,7,8,56,1,15,8,76,112,253,154,3,102,3,10,13,2,253,237,76,0,253,85,8,32,0,1,0,55,
  144,2,144,6,24,10,4,52,4,244,144,6,4,52,4,244,3,10,13,2,253,253,76,0,253,81,0,55,144,2,24,8,
  4,52,4,244,24,14,4,52,4,244,8,48,0,3,15,8,18,49,20,50,28,10,2,54,5,52,2,54,5,52,2,6,
  2,6,2,54,5,52,2,54,5,52,26,8,8,48,0,1,15,9,28,10,2,54,5,51,2,54,5,55,3,52,5,59,
  3,52,5,63,3,10,13,2,254,39,76,0,252,156,4,59,4,255,2,54,5,51,2,54,5,55,3,52,5,59,3,52,
  5,63,3,10,13,2,254,54,76,0,252,156,5,51,5,247,2,59,5,59,2,63,5,63,3,10,13,2,254,65,76,0,
  252,143,144,2,144,2,144,2,144,2,144,2,144,2,144,2,144,2,4,53,4,245,7,9,56,1,15,9,77,112,254,84,
  2,5,2,5,76,0,254,25,7,8,56,1,15,8,76,112,254,8,3,102,3,10,13,2,254,95,76,0,253,85,8,32,
  0,1,0,55,144,2,24,10,4,52,4,244,144,6,4,52,4,244,3,10,13,2,254,110,76,0,253,81,0,55,144,2,
  24,8,4,52,4,244,24,14,4,52,4,244,8,48,0,3,15,8,18,49,20,50,28,10,2,54,5,52,2,54,5,52,
  2,54,5,52,2,54,5,52,26,8,8,48,0,1,15,9,28,10,2,54,5,51,2,54,5,55,3,52,5,59,3,52,
  5,63,3,10,13,2,254,150,76,0,252,156,4,59,4,255,2,54,5,51,2,54,5,55,3,52,5,59,3,52,5,63,
  3,10,13,2,254,165,76,0,252,156,5,51,5,247,2,59,5,59,2,63,5,63,3,10,13,2,254,176,76,0,252,143,
  144,2,144,2,144,2,144,2,144,2,144,2,144,2,144,2,4,53,4,245,7,9,56,1,15,9,76,112,254,136,2,5,
  2,5,7,8,56,1,15,8,76,112,254,121,3,102,184,0,8,16,1,0,4,53,4,21,4,53,4,53,4,53,4,53,
  4,53,4,53,4,53,4,21,4,53,4,53,4,53,4,53,4,53,4,53,4,53,4,21,4,53,4,53,4,53,4,53,
  4,53,4,53,3,102,0,0,0,6,0,12,0,18,0,25,0,31,0,37,0,43,0,49,0,56,0,62,0,68,0,74,
  0,80,0,86,0,92,0,97,0,103,0,109,0,115,0,120,0,126,0,131,0,136,0,142,0,147,0,152,0,157,0,162,
  0,167,0,171,0,176,0,181,0,185,0,189,0,193,0,197,0,201,0,205,0,209,0,212,0,216,0,219,0,222,0,225,
  0,228,0,231,0,234,0,236,0,238,0,241,0,243,0,244,0,246,0,248,0,249,0,251,0,252,0,253,0,254,0,254,
  0,255,0,255,0,255,1,0,0,255,0,255,0,255,0,254,0,254,0,253,0,252,0,251,0,249,0,248,0,246,0,244,
  0,243,0,241,0,238,0,236,0,234,0,231,0,228,0,225,0,222,0,219,0,216,0,212,0,209,0,205,0,201,0,197,
  0,193,0,189,0,185,0,181,0,176,0,171,0,167,0,162,0,157,0,152,0,147,0,142,0,136,0,131,0,126,0,120,
  0,115,0,109,0,103,0,97,0,92,0,86,0,80,0,74,0,68,0,62,0,56,0,49,0,43,0,37,0,31,0,25,
  0,18,0,12,0,6,0,0,255,250,255,244,255,238,255,231,255,225,255,219,255,213,255,207,255,200,255,194,255,188,255,182,
  255,176,255,170,255,164,255,159,255,153,255,147,255,141,255,136,255,130,255,125,255,120,255,114,255,109,255,104,255,99,255,94,
  255,89,255,85,255,80,255,75,255,71,255,67,255,63,255,59,255,55,255,51,255,47,255,44,255,40,255,37,255,34,255,31,
  255,28,255,25,255,22,255,20,255,18,255,15,255,13,255,12,255,10,255,8,255,7,255,5,255,4,255,3,255,2,255,2,
  255,1,255,1,255,1,255,0,255,1,255,1,255,1,255,2,255,2,255,3,255,4,255,5,255,7,255,8,255,10,255,12,
  255,13,255,15,255,18,255,20,255,22,255,25,255,28,255,31,255,34,255,37,255,40,255,44,255,47,255,51,255,55,255,59,
  255,63,255,67,255,71,255,75,255,80,255,85,255,89,255,94,255,99,255,104,255,109,255,114,255,120,255,125,255,130,255,136,
  255,141,255,147,255,153,255,159,255,164,255,170,255,176,255,182,255,188,255,194,255,200,255,207,255,213,255,219,255,225,255,231,
  255,238,255,244,255,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,8,3,250,3,252,3,254,
};
}
namespace Mega32X {
const unsigned char Vector[256] = {
  0,0,0,0,0,136,2,0,0,136,2,6,0,136,2,12,0,136,2,18,0,136,2,24,0,136,2,30,0,136,2,36,
  0,136,2,42,0,136,2,48,0,136,2,54,0,136,2,60,0,136,2,66,0,136,2,72,0,136,2,78,0,136,2,84,
  0,136,2,90,0,136,2,96,0,136,2,102,0,136,2,108,0,136,2,114,0,136,2,120,0,136,2,126,0,136,2,132,
  0,136,2,138,0,136,2,144,0,136,2,150,0,136,2,156,0,136,2,162,0,136,2,168,0,136,2,174,0,136,2,180,
  0,136,2,186,0,136,2,192,0,136,2,198,0,136,2,204,0,136,2,210,0,136,2,216,0,136,2,222,0,136,2,228,
  0,136,2,234,0,136,2,240,0,136,2,246,0,136,2,252,0,136,3,2,0,136,3,8,0,136,3,14,0,136,3,20,
  8,249,0,0,0,161,81,7,18,128,8,185,0,0,0,161,81,7,78,117,72,231,1,64,8,249,0,0,0,161,81,7,
  67,249,0,161,48,241,126,7,18,152,210,252,0,2,81,207,255,248,8,185,0,0,0,161,81,7,76,223,2,128,78,117,
};
const unsigned char SH2BootM[2048] = {
  0,0,1,64,6,4,0,0,0,0,1,64,6,4,0,0,0,0,1,60,0,0,0,0,0,0,1,60,32,16,4,0,
  32,16,4,32,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,175,254,0,9,
  208,26,64,14,224,0,225,0,226,0,227,0,228,0,229,0,230,0,231,0,232,0,233,0,234,0,235,0,236,0,237,0,
  238,0,216,111,217,111,96,134,25,0,96,134,25,1,96,134,25,2,96,134,25,3,96,134,25,4,96,134,25,5,96,134,
  25,6,222,102,78,30,216,119,224,0,40,1,196,0,200,2,139,16,208,7,225,1,48,24,136,0,139,252,193,1,216,99,
  224,159,40,0,0,27,175,254,0,9,0,0,0,0,0,240,0,1,0,0,216,93,224,0,40,0,217,91,224,17,41,0,
  216,96,217,95,224,0,40,5,112,1,40,5,112,1,40,5,112,1,40,5,112,1,57,128,139,245,216,90,217,88,224,0,
  225,2,226,1,211,5,56,24,100,129,36,57,32,57,52,0,139,6,112,1,57,128,139,246,160,8,0,9,0,0,255,255,
  208,1,194,8,175,252,0,9,83,68,69,82,216,77,217,76,224,0,40,6,40,6,40,6,40,6,57,128,139,249,196,0,
  200,1,139,89,221,67,220,6,219,6,103,197,96,125,102,213,97,109,49,0,139,8,59,192,139,247,160,13,0,9,0,0,
  0,0,3,108,0,0,7,108,208,2,194,8,224,128,192,0,175,250,0,9,83,81,69,82,216,22,217,23,97,145,96,29,
  136,0,137,15,217,21,103,146,208,21,55,8,71,1,209,21,39,25,119,1,224,0,211,20,98,133,34,57,48,44,32,57,
  71,16,139,249,193,20,221,42,104,214,105,214,96,214,209,15,56,28,209,15,57,28,226,4,97,134,41,18,121,4,48,40,
  136,0,139,249,80,210,64,46,104,210,208,10,194,8,72,43,0,9,0,0,34,0,2,0,34,0,1,142,34,0,1,164,
  0,0,2,0,0,63,255,255,0,0,255,255,34,0,0,0,6,0,0,0,77,95,79,75,209,35,198,8,49,0,139,252,
  224,128,192,0,196,0,200,128,137,252,216,19,89,128,80,129,90,130,91,132,120,32,211,17,228,0,226,4,97,134,41,18,
  121,4,48,40,51,40,51,64,137,1,136,0,139,246,208,2,194,8,75,46,74,43,0,9,77,95,79,75,32,0,64,0,
  0,0,3,72,255,255,255,224,255,255,254,146,255,255,254,145,34,0,3,212,34,0,4,0,36,0,0,24,0,1,255,224,
  38,0,0,0,38,4,0,0,165,90,0,1,165,90,0,168,165,90,0,85,165,90,10,184,165,90,0,8,165,90,0,0,
  165,90,0,89,255,255,132,70,95,67,68,95,70,252,39,0,75,249,0,161,0,0,112,1,12,173,77,65,82,83,48,236,
  102,0,3,230,8,45,0,7,81,1,103,248,74,173,0,8,103,16,74,109,0,12,103,10,8,45,0,0,81,1,102,0,
  3,184,16,45,0,1,2,0,0,15,103,6,43,120,5,90,64,0,114,0,44,65,78,102,65,249,0,0,4,212,97,0,
  1,82,97,0,1,118,71,249,0,0,4,232,67,249,0,160,0,0,69,249,0,192,0,17,62,60,1,0,112,0,59,71,
  17,0,59,71,18,0,1,45,17,0,102,250,116,37,18,219,81,202,255,252,59,64,18,0,59,64,17,0,59,71,18,0,
  20,155,20,155,20,155,20,155,65,249,0,0,4,192,67,249,0,255,0,0,34,216,34,216,34,216,34,216,34,216,34,216,
  34,216,34,216,65,249,0,255,0,0,78,208,27,124,0,1,81,1,65,249,0,0,6,188,209,252,0,136,0,0,78,208,
  4,4,48,60,7,108,0,0,0,0,255,0,129,55,0,2,1,0,0,0,175,1,217,31,17,39,0,33,38,0,249,119,
  237,176,221,225,253,225,237,71,237,79,209,225,241,8,217,193,209,225,241,249,243,237,86,54,233,233,159,191,223,255,77,65,
  82,83,32,73,110,105,116,105,97,108,32,38,32,83,101,99,117,114,105,116,121,32,80,114,111,103,114,97,109,32,32,32,
  32,32,32,32,32,32,32,67,97,114,116,114,105,100,103,101,32,86,101,114,115,105,111,110,32,32,32,32,67,111,112,121,
  114,105,103,104,116,32,83,69,71,65,32,69,78,84,69,82,80,82,73,83,69,83,44,76,84,68,46,32,49,57,57,52,
  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
  32,32,82,79,77,32,86,101,114,115,105,111,110,32,49,46,48,0,72,231,192,64,67,249,0,192,0,4,48,17,48,60,
  128,0,50,60,1,0,62,60,0,18,16,24,50,128,208,65,81,207,255,248,76,223,2,3,78,117,72,231,129,192,65,249,
  0,0,6,62,67,249,0,192,0,4,50,152,50,152,50,152,50,152,50,152,50,152,50,152,34,152,51,65,255,252,48,17,
  8,0,0,1,102,248,50,152,50,152,112,0,34,188,192,0,0,0,126,15,51,64,255,252,51,64,255,252,51,64,255,252,
  51,64,255,252,81,207,255,238,34,188,64,0,0,16,126,9,51,64,255,252,51,64,255,252,51,64,255,252,51,64,255,252,
  81,207,255,238,76,223,3,129,78,117,129,20,143,1,147,255,148,255,149,0,150,0,151,128,64,0,0,128,129,4,143,2,
  72,231,193,64,67,249,0,161,81,128,8,169,0,7,255,128,102,248,62,60,0,255,112,0,114,0,51,124,0,255,0,4,
  51,65,0,6,51,64,0,8,78,113,8,41,0,1,0,11,102,248,6,65,1,0,81,207,255,232,76,223,2,131,78,117,
  72,231,129,128,65,249,0,161,82,0,8,168,0,7,255,0,102,248,62,60,0,31,32,192,32,192,32,192,32,192,81,207,
  255,246,76,223,1,129,78,117,65,249,0,255,0,0,62,60,7,255,112,0,32,192,32,192,32,192,32,192,32,192,32,192,
  32,192,32,192,81,207,255,238,59,124,0,0,18,0,126,10,81,207,255,254,67,249,0,161,81,0,112,0,35,64,0,32,
  35,64,0,36,27,124,0,3,81,1,46,121,0,136,0,0,8,145,0,7,102,250,112,0,51,64,0,2,51,64,0,4,
  51,64,0,6,35,64,0,8,35,64,0,12,51,64,0,16,51,64,0,48,51,64,0,50,51,64,0,56,51,64,0,128,
  51,64,0,130,8,169,0,0,0,139,102,248,97,0,255,18,8,233,0,0,0,139,103,248,97,0,255,6,8,169,0,0,
  0,139,97,0,255,60,48,60,0,64,34,41,0,32,12,129,83,81,69,82,103,0,0,146,48,60,0,128,34,41,0,32,
  12,129,83,68,69,82,103,0,0,128,33,252,0,136,2,162,0,112,48,60,0,2,114,0,18,45,0,1,20,41,0,128,
  225,74,130,66,8,1,0,15,102,10,8,1,0,6,103,0,0,88,96,8,8,1,0,6,102,0,0,78,112,32,65,249,
  0,136,0,0,60,40,1,142,74,70,103,0,0,16,52,41,0,40,12,66,0,0,103,246,180,70,102,44,112,0,35,64,
  0,40,35,64,0,44,62,20,44,124,255,255,255,192,76,214,127,249,68,252,0,0,96,20,67,249,0,161,81,0,51,64,
  0,6,48,60,128,0,96,4,68,252,0,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char SH2BootS[1024] = {
  0,0,1,64,6,3,248,0,0,0,1,64,6,3,248,0,0,0,1,60,0,0,0,0,0,0,1,60,32,16,4,0,
  32,16,4,32,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,
  0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,0,0,1,60,175,254,0,9,
  208,20,64,14,224,0,225,0,226,0,227,0,228,0,229,0,230,0,231,0,232,0,233,0,234,0,235,0,236,0,237,0,
  238,0,216,37,217,37,96,134,25,0,96,134,25,1,96,134,25,2,96,134,25,3,96,134,25,4,96,134,25,5,96,134,
  25,6,222,28,78,30,196,0,200,2,139,5,0,27,175,254,0,9,0,0,0,0,0,240,216,26,224,0,40,0,217,24,
  224,17,41,0,196,0,200,1,139,22,176,8,0,9,221,22,80,210,64,46,104,210,208,33,194,9,72,43,0,9,210,5,
  224,40,225,1,48,24,136,0,139,252,198,8,50,0,139,247,0,11,0,9,77,95,79,75,209,23,198,8,49,0,139,252,
  191,237,0,9,216,9,90,131,91,133,208,20,194,9,75,46,74,43,0,9,32,0,64,0,0,0,2,28,255,255,255,224,
  255,255,254,146,255,255,254,145,34,0,3,228,36,0,0,24,0,2,0,0,38,0,0,0,38,4,0,0,165,90,0,1,
  165,90,0,168,165,90,0,85,165,90,10,184,165,90,0,8,165,90,0,0,165,90,0,89,95,67,68,95,83,95,79,75,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
}
namespace Nintendo64 {
const unsigned char CIC6101[1024] = {
  50,34,104,34,17,117,78,140,217,110,138,143,16,117,201,16,195,16,195,17,195,240,192,240,175,42,240,143,120,154,240,198,
  241,162,240,160,48,32,194,240,143,120,167,225,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  225,64,130,130,16,134,104,77,138,135,117,77,139,17,117,104,125,0,104,97,47,16,117,34,77,155,152,76,96,47,17,117,
  34,77,161,104,125,0,104,97,105,4,96,120,176,102,1,102,104,125,104,97,47,16,117,34,77,187,184,29,1,188,155,0,
  31,84,201,110,67,201,110,66,201,110,65,201,110,64,125,17,75,16,195,17,74,16,195,17,73,16,195,17,72,16,224,70,
  240,171,240,171,240,171,171,1,0,122,84,80,120,167,125,48,42,27,88,21,92,240,171,42,171,0,0,0,0,0,0,0,
  52,32,104,48,44,139,53,32,104,48,36,31,84,211,110,67,211,110,66,211,110,65,211,110,64,120,139,50,34,104,125,48,
  32,16,85,16,85,16,101,172,85,171,84,100,241,183,1,172,100,1,171,84,1,170,85,84,1,168,194,225,14,0,0,0,
  25,74,241,136,181,90,113,195,222,97,16,237,158,140,201,110,152,201,110,225,192,96,224,223,201,110,156,193,48,192,192,192,
  49,192,192,192,49,39,80,15,16,1,103,201,49,17,72,16,195,48,110,185,72,193,120,171,142,72,182,181,0,0,0,0,
  47,80,101,97,33,123,97,84,80,120,123,97,121,88,123,88,122,84,80,120,122,88,8,122,88,1,0,122,84,80,120,153,
  100,15,125,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  48,32,16,84,104,49,33,27,89,104,20,101,80,1,84,104,106,0,85,100,89,137,50,34,104,48,33,240,128,49,240,128,
  225,14,48,34,100,77,168,174,122,32,88,100,92,125,1,165,100,1,164,84,1,84,165,0,0,0,125,0,0,0,0,0,
  50,32,26,84,240,143,240,143,31,100,100,15,151,100,240,128,120,240,128,120,138,51,138,241,236,50,32,31,100,194,100,15,
  225,14,100,240,143,120,240,143,120,158,51,158,50,32,31,100,100,15,125,100,84,121,88,84,121,88,176,51,176,0,0,0,
  0,116,0,76,64,77,65,78,66,79,67,0,0,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char CIC6102[1024] = {
  50,34,104,34,17,117,78,140,217,110,138,143,16,117,201,16,195,16,195,17,195,240,192,240,175,42,240,143,120,154,240,198,
  225,64,130,130,16,134,104,77,138,135,117,77,139,17,117,104,125,0,104,97,47,16,117,34,77,155,152,76,96,47,17,117,
  241,162,240,160,48,32,194,240,143,120,167,225,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  34,77,161,104,125,0,104,97,105,4,96,120,176,102,1,102,104,125,104,97,47,16,117,34,77,187,184,29,1,188,155,0,
  31,84,201,110,67,201,110,66,201,110,65,201,110,64,125,17,75,16,195,17,74,16,195,17,73,16,195,17,72,16,224,70,
  52,32,104,48,44,139,53,32,104,48,36,31,84,211,110,67,211,110,66,211,110,65,211,110,64,120,139,50,34,104,125,48,
  240,171,240,171,240,171,171,1,0,122,84,80,120,167,125,48,42,27,88,21,92,240,171,42,171,0,0,0,0,0,0,0,
  32,16,85,16,85,16,101,172,85,171,84,100,241,183,1,172,100,1,171,84,1,170,85,84,1,168,194,225,14,0,0,0,
  25,74,241,136,181,90,113,195,222,97,16,237,158,140,201,110,152,201,110,225,192,96,224,223,201,110,156,193,48,192,192,192,
  47,80,101,97,33,123,97,84,80,120,123,97,121,88,123,88,122,84,80,120,122,88,8,122,88,1,0,122,84,80,120,153,
  49,192,192,192,49,39,80,15,16,1,103,201,49,17,72,16,195,48,110,185,72,193,120,171,142,72,182,181,0,0,0,0,
  100,15,125,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  48,32,16,84,104,49,33,27,89,104,20,101,80,1,84,104,106,0,85,100,89,137,50,34,104,48,33,240,128,49,240,128,
  50,32,26,84,240,143,240,143,31,100,100,15,151,100,240,128,120,240,128,120,138,51,138,241,236,50,32,31,100,194,100,15,
  225,14,48,34,100,77,168,174,122,32,88,100,92,125,1,165,100,1,164,84,1,84,165,0,0,0,125,0,0,0,0,0,
  225,14,100,240,143,120,240,143,120,158,51,158,50,32,31,100,100,15,125,100,84,121,88,84,121,88,176,51,176,0,0,0,
  0,116,0,76,64,77,65,78,66,79,67,0,0,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char CIC6105[1024] = {
  50,34,104,34,17,117,78,140,217,110,138,143,16,117,201,16,195,16,195,17,195,240,192,240,175,42,240,143,120,154,240,198,
  241,162,240,160,48,32,194,240,143,120,167,225,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  225,64,130,130,16,134,104,77,138,135,117,77,139,17,117,104,125,0,104,97,47,16,117,34,77,155,152,76,96,47,17,117,
  34,77,161,104,125,0,104,97,105,4,96,120,176,102,1,102,104,125,104,97,47,16,117,34,77,187,184,29,1,188,155,0,
  31,84,201,110,67,201,110,66,201,110,65,201,110,64,125,17,75,16,195,17,74,16,195,17,73,16,195,17,72,16,224,70,
  240,171,240,171,240,171,171,1,0,122,84,80,120,167,125,48,42,27,88,21,92,240,171,42,171,0,0,0,0,0,0,0,
  52,32,104,48,44,139,53,32,104,48,36,31,84,211,110,67,211,110,66,211,110,65,211,110,64,120,139,50,34,104,125,48,
  32,16,85,16,85,16,101,172,85,171,84,100,241,183,1,172,100,1,171,84,1,170,85,84,1,168,194,225,14,0,0,0,
  25,74,241,136,181,90,113,195,222,97,16,237,158,140,201,110,152,201,110,225,192,96,224,223,201,110,156,193,48,192,192,192,
  49,192,192,192,49,39,80,15,16,1,103,201,49,17,72,16,195,48,110,185,72,193,120,171,142,72,182,181,0,0,0,0,
  47,80,101,97,33,123,97,84,80,120,123,97,121,88,123,88,122,84,80,120,122,88,8,122,88,1,0,122,84,80,120,153,
  100,15,125,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  48,32,16,84,104,49,33,27,89,104,20,101,80,1,84,104,106,0,85,100,89,137,50,34,104,48,33,240,128,49,240,128,
  225,14,48,34,100,77,168,174,122,32,88,100,92,125,1,165,100,1,164,84,1,84,165,0,0,0,125,0,0,0,0,0,
  50,32,26,84,240,143,240,143,31,100,100,15,151,100,240,128,120,240,128,120,138,51,138,241,236,50,32,31,100,194,100,15,
  225,14,100,240,143,120,240,143,120,158,51,158,50,32,31,100,21,97,226,64,0,0,0,0,0,0,0,0,0,0,0,0,
  0,116,0,76,64,77,65,78,66,79,67,0,0,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  100,15,175,100,72,8,0,84,73,4,0,122,84,80,110,7,0,122,123,0,121,84,80,120,72,8,0,84,73,4,0,122,
  84,80,110,7,0,122,123,0,121,84,80,120,128,51,128,96,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char CIC7101[1024] = {
  50,34,104,34,17,117,78,140,217,110,138,143,16,117,201,17,195,16,195,17,195,240,192,240,175,42,240,143,120,154,240,198,
  241,162,240,160,48,32,194,240,143,120,167,225,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  225,64,130,130,16,134,104,77,138,135,117,77,139,17,117,104,125,0,104,97,47,16,117,34,77,155,152,76,96,47,17,117,
  34,77,161,104,125,0,104,97,105,4,96,120,176,102,1,102,104,125,104,97,47,16,117,34,77,187,184,29,1,188,155,0,
  31,84,201,110,67,201,110,66,201,110,65,201,110,64,125,17,75,16,195,17,74,16,195,17,73,16,195,17,72,16,224,70,
  240,171,240,171,240,171,171,1,0,122,84,80,120,167,125,48,42,27,88,21,92,240,171,42,171,0,0,0,0,0,0,0,
  52,32,104,48,44,139,53,32,104,48,36,31,84,211,110,67,211,110,66,211,110,65,211,110,64,120,139,50,34,104,125,48,
  32,16,85,16,85,16,101,172,85,171,84,100,241,183,1,172,100,1,171,84,1,170,85,84,1,168,194,225,14,0,0,0,
  20,47,53,241,130,33,119,17,153,136,21,23,85,202,201,110,152,201,110,225,192,96,224,223,201,110,156,193,48,192,192,192,
  49,192,192,192,49,39,80,15,16,1,103,201,49,17,72,16,195,48,110,187,72,193,124,16,107,171,142,72,182,181,0,0,
  47,80,101,97,33,123,97,84,80,120,123,97,121,88,123,88,122,84,80,120,122,88,8,122,88,1,0,122,84,80,120,153,
  100,15,125,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  48,32,16,84,104,49,33,27,89,104,20,101,80,1,84,104,106,0,85,100,89,137,50,34,104,48,33,240,128,49,240,128,
  225,14,48,34,100,77,168,174,122,32,88,100,92,125,1,165,100,1,164,84,1,84,165,0,0,0,125,0,0,0,0,0,
  50,32,26,84,240,143,240,143,31,100,100,15,151,100,240,128,120,240,128,120,138,51,138,241,236,50,32,31,100,194,100,15,
  225,14,100,240,143,120,240,143,120,158,51,158,50,32,31,100,100,15,125,100,84,121,88,84,121,88,176,51,176,0,0,0,
  0,116,0,76,64,77,65,78,66,79,67,0,0,143,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char PIFSM5[1024] = {
  17,37,117,46,117,200,51,36,203,53,46,199,124,17,111,146,20,150,25,111,198,28,84,56,32,155,102,203,102,1,154,49,
  42,199,161,42,197,42,197,53,46,80,65,67,49,43,92,96,63,46,71,99,225,64,0,0,0,0,0,0,0,0,0,0,
  225,169,225,14,227,16,226,77,227,155,227,149,224,249,227,0,227,113,31,88,27,88,16,88,150,125,52,37,24,92,156,125,
  100,21,103,100,117,27,1,166,181,0,21,103,100,19,117,27,1,176,97,79,96,17,117,28,1,184,100,103,125,0,0,0,
  104,88,142,0,104,84,46,67,17,117,40,18,117,187,79,157,78,185,63,47,73,225,211,53,46,75,185,225,201,240,198,63,
  47,72,183,64,243,239,49,32,104,205,242,109,53,41,97,72,96,124,92,100,243,50,187,53,187,240,198,38,84,104,127,0,
  0,75,125,21,117,125,46,17,117,119,128,99,53,46,75,225,128,73,150,65,227,64,18,208,18,208,54,196,196,196,55,196,
  196,196,55,39,80,15,16,1,103,54,19,72,18,208,55,213,110,183,72,185,120,169,140,72,180,98,40,117,121,187,0,0,
  25,74,241,136,181,90,113,195,222,97,16,237,158,140,60,43,241,20,62,36,84,102,5,0,102,84,102,11,102,84,120,148,
  63,46,125,34,16,117,17,117,42,116,103,49,243,50,36,79,179,24,180,20,104,120,243,117,122,84,104,16,117,225,219,0,
  98,193,203,46,99,72,133,98,17,38,117,34,17,117,205,63,46,99,73,146,98,193,71,99,74,152,98,16,84,110,243,128,
  51,36,16,85,111,198,51,120,162,52,42,201,99,63,47,75,225,192,98,46,203,53,46,21,117,71,109,0,224,203,0,0,
  19,208,19,208,37,19,117,48,44,203,63,46,71,48,37,79,152,47,192,138,192,138,198,37,17,117,40,16,79,156,98,38,
  117,25,40,117,24,117,97,224,48,84,1,178,92,84,1,180,92,126,84,125,88,125,0,0,0,0,0,0,0,0,0,0,
  52,192,134,192,134,192,225,109,198,63,47,65,53,46,69,38,84,104,125,243,239,42,20,159,34,17,117,42,116,15,184,117,
  103,52,72,167,243,38,155,75,170,155,49,243,50,50,34,242,86,179,155,242,95,35,226,24,53,240,198,224,172,0,0,0,
  92,84,15,157,88,78,225,35,79,133,104,80,120,113,80,113,120,151,102,1,150,24,102,104,84,15,128,84,133,242,64,51,
  35,184,92,84,15,225,216,88,78,225,35,79,168,112,104,88,112,88,183,102,56,1,102,104,84,15,162,84,168,0,0,189,
  63,47,74,137,75,242,73,195,125,34,18,117,125,16,101,100,1,144,100,1,143,125,104,75,154,126,74,162,243,38,126,104,
  67,66,80,104,88,104,120,80,243,117,104,93,125,56,32,31,111,226,142,120,80,1,226,131,120,175,102,1,226,128,125,0,
  102,226,111,1,134,125,1,159,104,52,68,49,104,148,16,111,160,120,111,159,120,155,102,1,154,125,102,104,120,226,243,124,
  102,101,102,100,104,85,104,103,101,103,100,104,89,104,80,66,67,88,100,80,104,52,124,67,120,49,100,226,192,0,0,0,
  85,100,85,104,120,139,102,1,138,186,102,80,67,66,88,100,80,104,96,48,123,0,85,100,123,85,96,80,123,0,85,80,
  123,85,104,103,104,97,123,0,49,104,103,102,104,123,176,187,104,102,104,21,107,183,125,104,226,111,104,124,52,64,71,125,
  31,84,213,110,67,213,110,66,213,110,65,213,110,64,96,160,19,75,18,208,19,74,18,208,19,73,18,208,19,72,18,208,
  120,125,126,36,16,117,35,79,163,34,19,117,17,117,35,79,175,125,81,104,102,104,81,104,103,104,125,0,0,0,0,0,
  19,208,18,208,48,42,199,199,61,45,243,91,48,43,192,142,213,61,47,243,91,53,240,198,200,224,203,104,62,32,104,80,
  15,125,84,29,107,171,104,194,194,158,175,104,199,199,158,63,158,53,38,104,125,120,125,102,1,187,24,102,125,0,0,0,
  49,43,69,243,219,37,19,117,195,17,117,50,32,199,141,197,197,197,197,227,192,31,121,122,88,150,125,47,80,101,97,33,
  123,97,84,80,120,123,97,121,88,123,88,122,84,80,120,122,88,8,122,88,1,0,122,84,80,120,180,100,15,125,157,0,
  54,32,16,84,104,54,34,104,20,101,80,1,84,104,106,0,85,100,89,135,33,194,55,33,194,227,113,54,41,17,117,241,
  169,0,41,79,159,16,117,92,100,84,33,85,100,85,125,53,39,104,102,104,85,104,103,104,89,100,88,68,110,64,96,125,
};
const unsigned char PIFNTSC[1984] = {
  60,9,52,0,64,137,96,0,60,9,0,6,53,41,228,99,64,137,128,0,60,8,164,4,141,8,0,16,49,8,0,1,
  81,0,255,253,60,8,164,4,36,8,0,10,60,1,164,4,172,40,0,16,60,8,164,4,141,8,0,24,49,8,0,1,
  85,0,255,253,60,8,164,4,36,8,0,3,60,1,164,96,172,40,0,16,36,8,3,255,60,1,164,64,172,40,0,12,
  60,1,164,64,172,32,0,36,60,1,164,64,172,32,0,16,60,1,164,80,172,32,0,0,60,1,164,80,172,32,0,4,
  60,8,164,4,141,8,0,16,49,8,0,4,85,0,255,253,60,8,164,4,60,11,164,0,60,12,191,192,60,13,191,192,
  37,107,16,0,37,140,0,212,37,173,7,28,141,137,0,0,37,140,0,4,37,107,0,4,21,141,255,252,173,105,255,252,
  60,11,164,0,60,29,164,0,37,107,16,0,1,96,0,8,55,189,31,240,60,13,191,192,141,168,7,252,37,173,7,192,
  49,8,0,128,85,0,255,252,60,13,191,192,141,168,0,36,60,11,176,0,0,8,156,194,50,115,0,1,0,8,188,130,
  18,96,0,2,50,247,0,1,60,11,166,0,0,8,178,2,49,10,0,255,0,8,172,66,141,168,0,60,36,9,0,16,
  50,214,0,255,50,181,0,1,36,20,0,1,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,168,0,60,60,12,164,96,36,8,0,255,173,136,0,20,173,136,0,24,36,8,0,15,173,136,0,28,
  36,8,0,3,173,136,0,32,141,105,0,0,60,13,164,16,37,140,0,0,49,40,0,255,173,136,0,20,0,9,66,2,
  173,136,0,24,0,9,68,2,173,136,0,28,0,9,69,2,173,136,0,32,141,175,0,12,32,8,15,192,33,107,0,64,
  49,239,0,1,17,224,0,7,37,173,0,12,60,13,164,16,141,175,0,12,37,173,0,12,49,239,0,32,85,224,255,252,
  60,13,164,16,60,13,164,0,37,173,0,0,0,8,48,37,33,173,0,64,141,105,0,0,33,8,255,252,33,107,0,4,
  33,173,0,4,21,0,255,251,173,169,255,252,60,8,108,7,53,8,137,101,1,72,0,25,0,0,32,18,36,132,0,1,
  60,5,164,0,36,165,0,64,4,17,0,19,0,0,0,0,39,189,255,208,20,160,0,2,175,191,0,28,0,192,40,37,
  39,166,0,44,4,17,0,255,39,167,0,40,143,164,0,40,143,174,0,44,1,196,16,35,20,64,0,2,0,64,24,37,
  0,128,24,37,143,191,0,28,39,189,0,48,0,96,16,37,3,224,0,8,0,0,0,0,39,189,255,32,175,191,0,60,
  175,183,0,52,175,182,0,48,175,181,0,44,175,180,0,40,175,179,0,36,175,178,0,32,175,177,0,28,175,176,0,24,
  140,174,0,0,0,0,24,37,39,163,0,180,39,162,0,116,1,196,128,38,36,66,0,16,172,80,255,244,172,80,255,248,
  172,80,255,252,20,67,255,251,172,80,255,240,140,176,0,0,0,0,136,37,0,160,176,37,36,23,0,32,2,0,160,37,
  142,208,0,0,38,49,0,1,36,15,3,239,142,211,0,4,38,214,0,4,1,241,32,35,2,32,48,37,4,17,255,204,
  2,0,40,37,143,163,0,116,143,164,0,120,2,0,40,37,0,67,24,33,175,163,0,116,4,17,255,197,2,32,48,37,
  143,184,0,124,60,5,108,7,175,162,0,120,3,16,200,38,175,185,0,124,52,165,137,101,38,4,0,5,4,17,255,188,
  2,32,48,37,143,168,0,128,2,144,8,43,0,72,72,33,16,32,0,7,175,169,0,128,143,164,0,152,2,0,40,37,
  4,17,255,179,2,32,48,37,16,0,0,4,175,162,0,152,143,170,0,152,1,80,88,33,175,171,0,152,50,130,0,31,
  143,174,0,132,2,226,24,35,0,112,104,4,0,80,96,6,1,141,168,37,0,112,200,6,0,80,192,4,1,213,120,33,
  175,175,0,132,3,25,40,37,143,164,0,144,4,17,255,160,2,32,48,37,143,163,0,140,175,162,0,144,2,3,8,43,
  80,32,0,8,143,171,0,132,143,168,0,128,2,17,80,33,1,3,72,33,1,42,24,38,16,0,0,5,175,163,0,140,
  143,171,0,132,1,112,96,33,1,131,24,38,175,163,0,140,0,20,22,194,143,175,0,136,2,226,24,35,0,112,112,6,
  0,80,104,4,1,174,144,37,0,112,64,4,0,80,200,6,1,242,192,33,175,184,0,136,3,40,40,37,143,164,0,148,
  4,17,255,131,2,32,48,37,36,1,3,240,18,33,0,57,175,162,0,148,143,164,0,176,2,64,40,37,4,17,255,124,
  2,32,48,37,0,16,30,194,2,227,80,35,1,83,88,6,0,115,72,4,1,43,40,37,0,64,32,37,4,17,255,116,
  2,32,48,37,175,162,0,176,143,164,0,172,2,160,40,37,4,17,255,111,2,32,48,37,50,18,0,31,2,242,160,35,
  2,147,104,4,2,83,96,6,1,141,40,37,0,64,32,37,4,17,255,103,2,32,48,37,143,169,0,168,50,99,0,31,
  2,80,112,6,2,144,120,4,2,227,200,35,1,207,56,37,3,51,64,4,0,115,192,6,143,173,0,156,3,8,80,37,
  1,39,88,33,1,106,96,33,175,162,0,172,175,172,0,168,2,96,40,37,2,32,48,37,4,17,255,85,1,176,32,33,
  143,174,0,160,175,162,0,156,2,96,40,37,2,32,48,37,4,17,255,79,1,208,32,38,143,175,0,148,143,184,0,164,
  175,162,0,160,1,240,200,38,3,56,64,33,16,0,255,115,175,168,0,164,143,163,0,116,0,0,136,37,39,179,0,116,
  36,21,0,16,36,20,0,1,175,163,0,100,175,163,0,104,175,163,0,108,175,163,0,112,142,112,0,0,143,173,0,100,
  50,2,0,31,2,226,88,35,1,112,80,4,0,80,72,6,1,42,96,37,1,172,112,33,2,14,8,43,16,32,0,5,
  175,174,0,100,143,175,0,104,1,240,200,33,16,0,0,6,175,185,0,104,143,164,0,104,2,0,40,37,4,17,255,44,
  2,32,48,37,175,162,0,104,50,24,0,2,0,24,64,66,50,18,0,1,85,18,0,6,143,164,0,108,143,171,0,108,
  1,112,72,33,16,0,0,6,175,169,0,108,143,164,0,108,2,0,40,37,4,17,255,30,2,32,48,37,175,162,0,108,
  86,146,0,6,143,164,0,112,143,170,0,112,1,80,104,38,16,0,0,6,175,173,0,112,143,164,0,112,2,0,40,37,
  4,17,255,19,2,32,48,37,175,162,0,112,38,49,0,1,22,53,255,209,38,115,0,4,143,164,0,100,143,165,0,104,
  4,17,255,11,2,32,48,37,143,172,0,112,143,174,0,108,143,176,0,24,143,177,0,28,143,178,0,32,143,179,0,36,
  143,180,0,40,143,181,0,44,143,182,0,48,143,183,0,52,143,191,0,60,0,64,32,37,39,189,0,224,4,17,0,8,
  1,142,40,38,0,133,0,25,0,0,112,16,172,206,0,0,0,0,120,18,172,239,0,0,3,224,0,8,0,0,0,0,
  60,11,191,192,141,104,7,240,60,10,255,255,48,132,255,255,1,10,64,36,0,136,32,37,37,107,7,192,60,9,164,128,
  141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,173,100,0,48,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,141,104,0,60,
  36,9,0,32,173,101,0,52,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  173,104,0,60,32,9,0,16,33,41,255,255,85,32,255,255,33,41,255,255,141,104,0,60,49,10,0,128,80,10,255,250,
  32,9,0,16,36,10,0,64,1,10,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  173,104,0,60,60,11,164,0,37,107,0,0,33,107,0,64,1,96,0,8,0,0,0,0,0,0,0,0,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char PIFPAL[1984] = {
  60,9,52,0,64,137,96,0,60,9,0,6,53,41,228,99,64,137,128,0,60,8,164,4,141,8,0,16,49,8,0,1,
  81,0,255,253,60,8,164,4,36,8,0,10,60,1,164,4,172,40,0,16,60,8,164,4,141,8,0,24,49,8,0,1,
  85,0,255,253,60,8,164,4,36,8,0,3,60,1,164,96,172,40,0,16,36,8,3,255,60,1,164,64,172,40,0,12,
  60,1,164,64,172,32,0,36,60,1,164,64,172,32,0,16,60,1,164,80,172,32,0,0,60,1,164,80,172,32,0,4,
  60,8,164,4,141,8,0,16,49,8,0,4,85,0,255,253,60,8,164,4,60,11,164,0,60,12,191,192,60,13,191,192,
  37,107,16,0,37,140,0,212,37,173,7,32,141,137,0,0,37,140,0,4,37,107,0,4,21,141,255,252,173,105,255,252,
  60,11,164,0,60,29,164,0,37,107,16,0,1,96,0,8,55,189,31,240,60,13,191,192,141,168,7,252,37,173,7,192,
  49,8,0,128,85,0,255,252,60,13,191,192,141,168,0,36,60,11,176,0,0,8,188,130,0,8,156,194,50,247,0,1,
  50,115,0,1,18,96,0,2,54,247,0,6,60,11,166,0,0,8,178,2,49,10,0,255,0,8,172,66,141,168,0,60,
  36,9,0,16,50,214,0,255,50,181,0,1,36,20,0,0,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,
  85,32,255,253,60,9,164,128,173,168,0,60,60,12,164,96,36,8,0,255,173,136,0,20,173,136,0,24,36,8,0,15,
  173,136,0,28,36,8,0,3,173,136,0,32,141,105,0,0,60,13,164,16,37,140,0,0,49,40,0,255,173,136,0,20,
  0,9,66,2,173,136,0,24,0,9,68,2,173,136,0,28,0,9,69,2,173,136,0,32,141,175,0,12,32,8,15,192,
  33,107,0,64,49,239,0,1,17,224,0,7,37,173,0,12,60,13,164,16,141,175,0,12,37,173,0,12,49,239,0,32,
  85,224,255,252,60,13,164,16,60,13,164,0,37,173,0,0,0,8,48,37,33,173,0,64,141,105,0,0,33,8,255,252,
  33,107,0,4,33,173,0,4,21,0,255,251,173,169,255,252,60,8,108,7,53,8,137,101,1,72,0,25,0,0,32,18,
  36,132,0,1,60,5,164,0,36,165,0,64,4,17,0,19,0,0,0,0,39,189,255,208,20,160,0,2,175,191,0,28,
  0,192,40,37,39,166,0,44,4,17,0,255,39,167,0,40,143,164,0,40,143,174,0,44,1,196,16,35,20,64,0,2,
  0,64,24,37,0,128,24,37,143,191,0,28,39,189,0,48,0,96,16,37,3,224,0,8,0,0,0,0,39,189,255,32,
  175,191,0,60,175,183,0,52,175,182,0,48,175,181,0,44,175,180,0,40,175,179,0,36,175,178,0,32,175,177,0,28,
  175,176,0,24,140,174,0,0,0,0,24,37,39,163,0,180,39,162,0,116,1,196,128,38,36,66,0,16,172,80,255,244,
  172,80,255,248,172,80,255,252,20,67,255,251,172,80,255,240,140,176,0,0,0,0,136,37,0,160,176,37,36,23,0,32,
  2,0,160,37,142,208,0,0,38,49,0,1,36,15,3,239,142,211,0,4,38,214,0,4,1,241,32,35,2,32,48,37,
  4,17,255,204,2,0,40,37,143,163,0,116,143,164,0,120,2,0,40,37,0,67,24,33,175,163,0,116,4,17,255,197,
  2,32,48,37,143,184,0,124,60,5,108,7,175,162,0,120,3,16,200,38,175,185,0,124,52,165,137,101,38,4,0,5,
  4,17,255,188,2,32,48,37,143,168,0,128,2,144,8,43,0,72,72,33,16,32,0,7,175,169,0,128,143,164,0,152,
  2,0,40,37,4,17,255,179,2,32,48,37,16,0,0,4,175,162,0,152,143,170,0,152,1,80,88,33,175,171,0,152,
  50,130,0,31,143,174,0,132,2,226,24,35,0,112,104,4,0,80,96,6,1,141,168,37,0,112,200,6,0,80,192,4,
  1,213,120,33,175,175,0,132,3,25,40,37,143,164,0,144,4,17,255,160,2,32,48,37,143,163,0,140,175,162,0,144,
  2,3,8,43,80,32,0,8,143,171,0,132,143,168,0,128,2,17,80,33,1,3,72,33,1,42,24,38,16,0,0,5,
  175,163,0,140,143,171,0,132,1,112,96,33,1,131,24,38,175,163,0,140,0,20,22,194,143,175,0,136,2,226,24,35,
  0,112,112,6,0,80,104,4,1,174,144,37,0,112,64,4,0,80,200,6,1,242,192,33,175,184,0,136,3,40,40,37,
  143,164,0,148,4,17,255,131,2,32,48,37,36,1,3,240,18,33,0,57,175,162,0,148,143,164,0,176,2,64,40,37,
  4,17,255,124,2,32,48,37,0,16,30,194,2,227,80,35,1,83,88,6,0,115,72,4,1,43,40,37,0,64,32,37,
  4,17,255,116,2,32,48,37,175,162,0,176,143,164,0,172,2,160,40,37,4,17,255,111,2,32,48,37,50,18,0,31,
  2,242,160,35,2,147,104,4,2,83,96,6,1,141,40,37,0,64,32,37,4,17,255,103,2,32,48,37,143,169,0,168,
  50,99,0,31,2,80,112,6,2,144,120,4,2,227,200,35,1,207,56,37,3,51,64,4,0,115,192,6,143,173,0,156,
  3,8,80,37,1,39,88,33,1,106,96,33,175,162,0,172,175,172,0,168,2,96,40,37,2,32,48,37,4,17,255,85,
  1,176,32,33,143,174,0,160,175,162,0,156,2,96,40,37,2,32,48,37,4,17,255,79,1,208,32,38,143,175,0,148,
  143,184,0,164,175,162,0,160,1,240,200,38,3,56,64,33,16,0,255,115,175,168,0,164,143,163,0,116,0,0,136,37,
  39,179,0,116,36,21,0,16,36,20,0,1,175,163,0,100,175,163,0,104,175,163,0,108,175,163,0,112,142,112,0,0,
  143,173,0,100,50,2,0,31,2,226,88,35,1,112,80,4,0,80,72,6,1,42,96,37,1,172,112,33,2,14,8,43,
  16,32,0,5,175,174,0,100,143,175,0,104,1,240,200,33,16,0,0,6,175,185,0,104,143,164,0,104,2,0,40,37,
  4,17,255,44,2,32,48,37,175,162,0,104,50,24,0,2,0,24,64,66,50,18,0,1,85,18,0,6,143,164,0,108,
  143,171,0,108,1,112,72,33,16,0,0,6,175,169,0,108,143,164,0,108,2,0,40,37,4,17,255,30,2,32,48,37,
  175,162,0,108,86,146,0,6,143,164,0,112,143,170,0,112,1,80,104,38,16,0,0,6,175,173,0,112,143,164,0,112,
  2,0,40,37,4,17,255,19,2,32,48,37,175,162,0,112,38,49,0,1,22,53,255,209,38,115,0,4,143,164,0,100,
  143,165,0,104,4,17,255,11,2,32,48,37,143,172,0,112,143,174,0,108,143,176,0,24,143,177,0,28,143,178,0,32,
  143,179,0,36,143,180,0,40,143,181,0,44,143,182,0,48,143,183,0,52,143,191,0,60,0,64,32,37,39,189,0,224,
  4,17,0,8,1,142,40,38,0,133,0,25,0,0,112,16,172,206,0,0,0,0,120,18,172,239,0,0,3,224,0,8,
  0,0,0,0,60,11,191,192,141,104,7,240,60,10,255,255,48,132,255,255,1,10,64,36,0,136,32,37,37,107,7,192,
  60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,173,100,0,48,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,60,9,164,128,
  141,104,0,60,36,9,0,32,173,101,0,52,1,9,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,104,0,60,32,9,0,16,33,41,255,255,85,32,255,255,33,41,255,255,141,104,0,60,49,10,0,128,
  80,10,255,250,32,9,0,16,36,10,0,64,1,10,64,37,60,9,164,128,141,41,0,24,49,41,0,2,85,32,255,253,
  60,9,164,128,173,104,0,60,60,11,164,0,37,107,0,0,33,107,0,64,1,96,0,8,0,0,0,0,0,0,0,0,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
}
namespace SuperFamicom {
const unsigned char IPLROM[64] = {
  205,239,189,232,0,198,29,208,252,143,170,244,143,187,245,120,204,244,208,251,47,25,235,244,208,252,126,244,208,11,228,245,
  203,244,215,0,252,208,243,171,1,16,239,126,244,16,235,186,246,218,0,186,244,196,244,221,93,208,219,31,0,0,192,255,
};
const unsigned char Cx4[3072] = {
  255,255,255,0,0,128,0,0,64,170,170,42,0,0,32,153,153,25,85,85,21,36,73,18,0,0,16,227,56,14,204,204,
  12,232,162,11,170,170,10,157,216,9,146,36,9,136,136,8,0,0,8,135,135,7,113,28,7,161,188,6,102,102,6,97,
  24,6,116,209,5,178,144,5,85,85,5,184,30,5,78,236,4,161,189,4,73,146,4,238,105,4,68,68,4,8,33,4,
  0,0,4,248,224,3,195,195,3,58,168,3,56,142,3,159,117,3,80,94,3,52,72,3,51,51,3,56,31,3,48,12,
  3,11,250,2,186,232,2,45,216,2,89,200,2,49,185,2,170,170,2,188,156,2,92,143,2,130,130,2,39,118,2,67,
  106,2,208,94,2,200,83,2,36,73,2,224,62,2,247,52,2,99,43,2,34,34,2,46,25,2,132,16,2,32,8,2,
  0,0,2,31,248,1,124,240,1,19,233,1,225,225,1,230,218,1,29,212,1,133,205,1,28,199,1,224,192,1,207,186,
  1,232,180,1,40,175,1,142,169,1,26,164,1,200,158,1,153,153,1,139,148,1,156,143,1,203,138,1,24,134,1,129,
  129,1,5,125,1,164,120,1,93,116,1,46,112,1,22,108,1,22,104,1,44,100,1,88,96,1,152,92,1,237,88,1,
  85,85,1,208,81,1,94,78,1,253,74,1,174,71,1,111,68,1,65,65,1,34,62,1,19,59,1,19,56,1,33,53,
  1,62,50,1,104,47,1,159,44,1,228,41,1,53,39,1,146,36,1,251,33,1,112,31,1,240,28,1,123,26,1,17,
  24,1,177,21,1,92,19,1,17,17,1,207,14,1,151,12,1,104,10,1,66,8,1,36,6,1,16,4,1,4,2,1,
  0,0,1,3,254,0,15,252,0,35,250,0,62,248,0,96,246,0,137,244,0,185,242,0,240,240,0,46,239,0,115,237,
  0,189,235,0,14,234,0,101,232,0,194,230,0,37,229,0,142,227,0,252,225,0,112,224,0,233,222,0,103,221,0,235,
  219,0,116,218,0,1,217,0,148,215,0,43,214,0,199,212,0,104,211,0,13,210,0,182,208,0,100,207,0,22,206,0,
  204,204,0,135,203,0,69,202,0,7,201,0,206,199,0,152,198,0,101,197,0,55,196,0,12,195,0,228,193,0,192,192,
  0,160,191,0,130,190,0,105,189,0,82,188,0,62,187,0,46,186,0,33,185,0,23,184,0,15,183,0,11,182,0,9,
  181,0,11,180,0,15,179,0,22,178,0,31,177,0,44,176,0,58,175,0,76,174,0,96,173,0,118,172,0,143,171,0,
  170,170,0,200,169,0,232,168,0,10,168,0,47,167,0,85,166,0,126,165,0,169,164,0,215,163,0,6,163,0,55,162,
  0,107,161,0,160,160,0,216,159,0,17,159,0,76,158,0,137,157,0,200,156,0,9,156,0,76,155,0,144,154,0,215,
  153,0,31,153,0,104,152,0,180,151,0,1,151,0,79,150,0,160,149,0,242,148,0,69,148,0,154,147,0,241,146,0,
  73,146,0,162,145,0,253,144,0,90,144,0,184,143,0,23,143,0,120,142,0,218,141,0,61,141,0,162,140,0,8,140,
  0,112,139,0,216,138,0,66,138,0,174,137,0,26,137,0,136,136,0,247,135,0,103,135,0,217,134,0,75,134,0,191,
  133,0,52,133,0,169,132,0,33,132,0,153,131,0,18,131,0,140,130,0,8,130,0,132,129,0,2,129,0,128,128,0,
  0,0,0,0,0,16,158,160,22,122,182,27,0,0,32,239,198,35,28,49,39,255,84,42,60,65,45,0,0,48,176,152,
  50,229,16,53,245,108,55,86,176,57,212,221,59,189,247,61,0,0,64,61,248,65,219,225,67,12,190,69,222,141,71,58,
  82,73,241,11,75,185,187,76,56,98,78,0,0,80,149,149,81,112,35,83,254,169,84,162,41,86,183,162,87,144,21,89,
  121,130,90,186,233,91,148,75,93,67,168,94,0,0,96,254,82,97,112,161,98,131,235,99,96,49,101,50,115,102,29,177,
  103,68,235,104,202,33,106,205,84,107,108,132,108,194,176,109,235,217,110,0,0,112,24,35,113,74,67,114,173,96,115,84,
  123,116,84,147,117,191,168,118,168,187,119,31,204,120,52,218,121,249,229,122,122,239,123,200,246,124,239,251,125,253,254,126,
  0,0,128,1,255,128,15,252,129,52,247,130,123,240,131,238,231,132,152,221,133,130,209,134,182,195,135,61,180,136,31,163,
  137,102,144,138,25,124,139,65,102,140,228,78,141,11,54,142,188,27,143,0,0,144,219,226,144,86,196,145,117,164,146,65,
  131,147,189,96,148,241,60,149,226,23,150,150,241,150,17,202,151,89,161,152,115,119,153,100,76,154,49,32,155,222,242,155,
  112,196,156,235,148,157,84,100,158,175,50,159,0,0,160,74,204,160,146,151,161,220,97,162,42,43,163,130,243,163,230,186,
  164,90,129,165,225,70,166,126,11,167,53,207,167,9,146,168,253,83,169,19,21,170,80,213,170,180,148,171,69,83,172,3,
  17,173,242,205,173,21,138,174,110,69,175,0,0,176,204,185,176,214,114,177,32,43,178,172,226,178,124,153,179,147,79,180,
  243,4,181,157,185,181,149,109,182,220,32,183,117,211,183,96,133,184,160,54,185,56,231,185,40,151,186,115,70,187,26,245,
  187,32,163,188,134,80,189,78,253,189,121,169,190,9,85,191,0,0,192,95,170,192,40,84,193,92,253,193,253,165,194,13,
  78,195,140,245,195,125,156,196,225,66,197,184,232,197,5,142,198,201,50,199,6,215,199,187,122,200,235,29,201,152,192,201,
  193,98,202,105,4,203,145,165,203,58,70,204,100,230,204,18,134,205,68,37,206,252,195,206,58,98,207,0,0,208,78,157,
  208,38,58,209,137,214,209,119,114,210,243,13,211,252,168,211,148,67,212,188,221,212,116,119,213,190,16,214,155,169,214,11,
  66,215,15,218,215,169,113,216,216,8,217,159,159,217,254,53,218,245,203,218,133,97,219,176,246,219,118,139,220,216,31,221,
  215,179,221,115,71,222,173,218,222,134,109,223,0,0,224,25,146,224,212,35,225,48,181,225,48,70,226,210,214,226,25,103,
  227,4,247,227,148,134,228,203,21,229,168,164,229,45,51,230,90,193,230,47,79,231,173,220,231,214,105,232,169,246,232,38,
  131,233,80,15,234,38,155,234,168,38,235,217,177,235,183,60,236,67,199,236,127,81,237,106,219,237,6,101,238,82,238,238,
  80,119,239,0,0,240,97,136,240,118,16,241,62,152,241,186,31,242,234,166,242,207,45,243,105,180,243,185,58,244,192,192,
  244,125,70,245,242,203,245,30,81,246,2,214,246,159,90,247,245,222,247,5,99,248,206,230,248,82,106,249,144,237,249,138,
  112,250,63,243,250,177,117,251,223,247,251,202,121,252,114,251,252,216,124,253,251,253,253,222,126,254,127,255,254,223,127,255,
  0,0,0,58,36,3,85,72,6,50,108,9,178,143,12,183,178,15,32,213,18,208,246,21,166,23,25,133,55,28,78,86,
  31,225,115,34,32,144,37,237,170,40,40,196,43,179,219,46,112,241,49,64,5,53,4,23,56,159,38,59,242,51,62,224,
  62,65,73,71,68,16,77,71,24,80,74,67,80,77,114,77,80,137,71,83,105,62,86,247,49,89,20,34,92,164,14,95,
  138,247,97,169,220,100,229,189,103,32,155,106,64,116,109,39,73,112,186,25,115,221,229,117,116,173,120,101,112,123,147,46,
  126,228,231,128,60,156,131,130,75,134,154,245,136,107,154,139,217,57,142,204,211,144,42,104,147,217,246,149,191,127,152,197,
  2,155,209,127,157,202,246,159,153,103,162,36,210,164,85,54,167,20,148,169,73,235,171,221,59,174,186,133,176,201,200,178,
  243,4,181,34,58,183,65,104,185,58,143,187,249,174,189,103,199,191,112,216,193,0,226,195,3,228,197,101,222,199,18,209,
  201,247,187,203,2,159,205,31,122,207,61,77,209,72,24,211,49,219,212,228,149,214,82,72,216,105,242,217,26,148,219,83,
  45,221,5,190,222,33,70,224,151,197,225,89,60,227,89,170,228,135,15,230,215,107,231,59,191,232,166,9,234,11,75,235,
  94,131,236,147,178,237,157,216,238,115,245,239,8,9,241,82,19,242,71,20,243,221,11,244,10,250,244,198,222,245,7,186,
  246,197,139,247,247,83,248,151,18,249,157,199,249,1,115,250,190,20,251,205,172,251,39,59,252,201,191,252,171,58,253,203,
  171,253,35,19,254,175,112,254,109,196,254,87,14,255,109,78,255,171,132,255,15,177,255,151,211,255,67,236,255,16,251,255,
  0,0,0,249,162,0,246,69,1,248,232,1,1,140,2,20,47,3,52,210,3,100,117,4,165,24,5,251,187,5,104,95,
  6,239,2,7,146,166,7,84,74,8,56,238,8,64,146,9,110,54,10,199,218,10,76,127,11,1,36,12,231,200,12,2,
  110,13,85,19,14,227,184,14,174,94,15,185,4,16,8,171,16,158,81,17,125,248,17,169,159,18,37,71,19,244,238,19,
  25,151,20,153,63,21,117,232,21,178,145,22,83,59,23,92,229,23,209,143,24,180,58,25,10,230,25,216,145,26,32,62,
  27,231,234,27,49,152,28,2,70,29,95,244,29,76,163,30,206,82,31,234,2,32,163,179,32,0,101,33,5,23,34,184,
  201,34,30,125,35,60,49,36,24,230,36,185,155,37,36,82,38,95,9,39,113,193,39,97,122,40,54,52,41,246,238,41,
  170,170,42,89,103,43,10,37,44,199,227,44,152,163,45,133,100,46,153,38,47,220,233,47,89,174,48,27,116,49,44,59,
  50,152,3,51,107,205,51,177,152,52,120,101,53,206,51,54,193,3,55,96,213,55,187,168,56,228,125,57,236,84,58,230,
  45,59,230,8,60,1,230,60,77,197,61,227,166,62,220,138,63,82,113,64,98,90,65,44,70,66,208,52,67,113,38,68,
  55,27,69,74,19,70,214,14,71,12,14,72,32,17,73,76,24,74,205,35,75,234,51,76,236,72,77,39,99,78,249,130,
  79,201,168,80,10,213,81,63,8,83,252,66,84,234,133,85,204,209,86,130,39,88,21,136,89,188,244,90,237,110,92,108,
  248,93,105,147,95,163,66,97,165,9,99,30,237,100,129,243,102,23,38,105,34,147,107,165,82,110,124,147,113,180,206,117,
  0,0,0,36,3,0,72,6,0,109,9,0,147,12,0,186,15,0,226,18,0,11,22,0,54,25,0,99,28,0,147,31,
  0,196,34,0,249,37,0,48,41,0,107,44,0,169,47,0,235,50,0,50,54,0,124,57,0,203,60,0,31,64,0,121,
  67,0,216,70,0,61,74,0,168,77,0,25,81,0,146,84,0,17,88,0,153,91,0,40,95,0,192,98,0,96,102,0,
  9,106,0,188,109,0,122,113,0,65,117,0,20,121,0,242,124,0,220,128,0,210,132,0,213,136,0,230,140,0,5,145,
  0,51,149,0,112,153,0,190,157,0,28,162,0,139,166,0,13,171,0,162,175,0,75,180,0,9,185,0,220,189,0,198,
  194,0,200,199,0,227,204,0,24,210,0,103,215,0,211,220,0,93,226,0,6,232,0,207,237,0,187,243,0,202,249,0,
  0,0,1,92,6,1,226,12,1,148,19,1,115,26,1,131,33,1,198,40,1,62,48,1,239,55,1,220,63,1,8,72,
  1,119,80,1,45,89,1,45,98,1,125,107,1,34,117,1,33,127,1,128,137,1,68,148,1,118,159,1,28,171,1,62,
  183,1,231,195,1,31,209,1,241,222,1,105,237,1,149,252,1,131,12,2,68,29,2,233,46,2,134,65,2,51,85,2,
  9,106,2,37,128,2,167,151,2,181,176,2,120,203,2,35,232,2,236,6,3,21,40,3,235,75,3,198,114,3,16,157,
  3,71,203,3,2,254,3,247,53,4,5,116,4,63,185,4,255,6,5,249,94,5,93,195,5,9,55,6,207,189,6,230,
  92,7,151,27,8,109,4,9,54,39,10,198,156,11,129,142,13,233,70,16,255,90,20,113,38,27,72,188,40,181,123,81,
  255,255,255,16,251,255,67,236,255,151,211,255,15,177,255,171,132,255,109,78,255,87,14,255,109,196,254,175,112,254,35,19,
  254,203,171,253,171,58,253,201,191,252,39,59,252,205,172,251,190,20,251,1,115,250,157,199,249,151,18,249,247,83,248,197,
  139,247,7,186,246,198,222,245,10,250,244,221,11,244,71,20,243,82,19,242,8,9,241,115,245,239,157,216,238,147,178,237,
  94,131,236,11,75,235,166,9,234,59,191,232,215,107,231,135,15,230,89,170,228,89,60,227,151,197,225,33,70,224,5,190,
  222,83,45,221,26,148,219,105,242,217,82,72,216,228,149,214,49,219,212,72,24,211,61,77,209,31,122,207,2,159,205,247,
  187,203,18,209,201,101,222,199,3,228,197,0,226,195,112,216,193,103,199,191,249,174,189,58,143,187,65,104,185,34,58,183,
  243,4,181,201,200,178,186,133,176,221,59,174,73,235,171,20,148,169,85,54,167,36,210,164,153,103,162,202,246,159,209,127,
  157,197,2,155,191,127,152,217,246,149,42,104,147,204,211,144,217,57,142,107,154,139,154,245,136,130,75,134,60,156,131,228,
  231,128,147,46,126,101,112,123,116,173,120,221,229,117,186,25,115,39,73,112,64,116,109,32,155,106,229,189,103,169,220,100,
  138,247,97,164,14,95,20,34,92,247,49,89,105,62,86,137,71,83,114,77,80,67,80,77,24,80,74,16,77,71,73,71,
  68,224,62,65,242,51,62,159,38,59,4,23,56,64,5,53,112,241,49,179,219,46,40,196,43,237,170,40,32,144,37,225,
  115,34,78,86,31,133,55,28,166,23,25,208,246,21,32,213,18,183,178,15,178,143,12,50,108,9,85,72,6,58,36,3,
};
const unsigned char DSP1[8192] = {
  0,192,151,7,0,193,6,32,192,2,48,192,16,192,151,129,128,18,12,128,145,7,0,192,0,0,11,160,64,144,0,0,
  11,128,64,144,0,0,11,96,64,144,0,0,11,76,64,144,0,0,11,172,6,144,200,70,144,0,0,11,128,71,144,0,
  0,11,60,7,144,240,70,144,0,0,11,116,64,144,0,0,11,204,7,144,252,71,144,0,0,11,248,8,144,60,73,144,
  0,0,11,148,64,144,0,0,11,232,9,144,124,77,144,0,0,11,136,14,144,100,80,144,0,0,11,184,64,144,0,0,
  11,0,0,11,28,17,144,32,82,144,0,0,11,204,64,144,0,0,11,136,18,144,240,82,144,0,0,11,0,0,11,164,
  83,144,0,0,11,56,19,144,188,83,144,194,3,192,4,0,192,29,0,18,4,65,145,29,32,21,244,0,146,225,64,0,
  64,224,84,32,224,83,0,0,10,92,65,145,0,0,10,68,65,145,0,128,11,202,255,223,208,128,18,42,0,0,2,16,
  192,232,0,168,37,0,0,109,0,0,0,0,37,69,8,192,80,128,84,33,128,18,100,129,148,0,0,11,10,0,224,2,
  4,192,208,0,83,33,128,18,76,129,148,194,3,192,232,0,160,26,0,19,48,0,20,124,65,148,209,0,64,69,16,192,
  80,0,21,21,0,19,109,0,0,0,0,33,168,65,148,160,1,145,0,0,49,192,1,148,194,255,223,33,128,77,0,0,
  10,184,1,145,0,0,49,192,65,148,65,0,224,32,128,83,42,128,18,208,129,148,96,0,21,96,0,21,42,128,19,0,
  0,37,0,128,113,232,0,168,197,3,192,80,128,20,0,130,148,69,12,192,80,128,21,37,128,19,27,0,19,0,0,101,
  24,194,145,16,0,18,20,66,148,193,255,223,32,128,83,65,0,224,32,128,83,232,0,168,202,3,192,208,128,20,104,194,
  145,80,130,148,69,12,192,80,128,21,37,128,19,27,0,19,0,128,37,76,130,148,0,0,72,0,0,64,35,128,19,16,
  128,21,18,0,19,100,130,148,0,0,8,108,1,160,18,0,18,116,66,148,16,0,83,16,0,19,0,0,72,16,0,19,
  250,64,17,242,64,20,160,2,148,254,160,20,172,194,148,66,12,192,254,160,21,192,2,160,210,0,0,254,160,20,184,130,
  148,66,12,192,0,160,21,192,2,160,66,12,192,222,160,21,33,0,0,0,16,4,21,0,19,251,16,0,15,16,37,31,
  80,19,33,0,0,0,16,4,21,0,19,251,16,0,15,16,37,31,80,19,33,0,0,0,16,4,21,0,19,251,16,0,
  15,16,37,31,16,83,10,1,192,29,0,19,0,0,37,52,67,145,0,0,10,64,67,145,44,67,148,65,0,224,0,0,
  64,193,255,223,0,0,64,0,0,53,44,67,148,0,0,64,0,0,53,36,3,148,0,0,64,16,96,18,200,67,145,104,
  3,148,0,32,10,0,0,9,104,3,146,0,0,8,5,25,192,27,129,10,97,129,9,99,0,37,21,0,19,109,128,9,
  222,0,36,48,0,20,26,0,19,10,0,33,16,0,21,156,3,146,193,255,223,29,0,19,0,0,36,48,0,20,26,0,
  19,0,0,33,16,0,21,188,3,146,193,255,223,208,3,150,0,0,10,0,96,73,193,255,223,194,11,192,0,96,64,16,
  0,18,228,67,148,8,4,168,0,0,64,42,128,19,29,0,19,208,128,20,224,0,22,8,4,168,42,128,19,29,0,19,
  208,128,20,224,0,86,32,128,18,44,196,148,44,128,19,29,128,37,1,0,192,36,132,148,193,255,255,0,128,53,0,0,
  103,202,255,223,208,128,18,44,128,19,29,128,37,1,0,192,72,132,148,193,255,255,0,128,5,0,128,53,0,0,103,92,
  4,168,92,4,168,100,1,0,242,64,0,243,64,0,254,0,0,116,4,168,116,4,168,100,1,0,44,2,0,60,6,37,
  12,0,37,100,1,37,31,0,83,197,69,192,0,128,11,160,132,144,0,0,11,0,128,9,46,0,0,27,1,19,130,53,
  192,109,128,37,37,0,53,26,0,0,98,1,0,97,128,20,45,0,0,2,0,101,16,96,18,220,4,148,0,32,10,0,
  0,9,60,69,146,69,135,192,27,1,19,109,1,37,96,1,21,98,1,0,110,129,50,43,128,19,21,128,37,43,128,19,
  99,128,37,0,0,21,21,0,19,109,0,21,32,0,20,28,5,146,65,0,224,50,0,0,0,128,37,44,133,146,194,255,
  223,56,5,150,0,128,10,0,224,73,0,96,64,32,224,83,16,96,18,84,5,148,0,32,10,0,0,9,144,69,146,133,
  200,192,98,1,0,27,1,19,109,1,53,96,0,18,26,128,37,37,128,19,96,129,21,97,128,20,45,128,19,0,0,37,
  144,5,150,26,0,0,65,0,224,208,96,84,32,224,83,36,128,19,207,255,223,0,2,0,47,6,0,47,68,0,47,64,
  0,47,34,0,66,0,0,4,0,192,47,0,0,200,4,168,35,96,0,244,128,10,31,134,9,212,133,146,194,255,223,47,
  198,19,63,134,21,31,4,64,4,0,192,47,0,0,200,4,168,35,96,0,244,128,10,31,192,9,0,134,146,194,255,223,
  47,192,19,47,2,0,47,32,0,31,32,0,63,6,0,47,64,0,47,64,0,207,255,223,50,4,64,36,128,19,15,0,
  208,0,2,0,47,6,0,47,68,0,47,64,0,47,34,0,66,0,0,4,0,192,47,0,0,200,4,168,0,128,11,35,
  96,11,244,128,10,31,134,9,47,198,19,63,134,21,31,4,64,4,0,192,47,0,0,200,4,168,0,128,11,35,96,11,
  244,128,10,31,192,9,47,192,19,47,2,0,47,32,0,31,32,0,63,6,0,47,64,0,47,64,0,15,0,208,50,4,
  64,172,198,151,138,0,0,180,198,151,157,0,0,0,0,33,22,0,19,0,0,160,200,198,151,129,0,0,208,198,151,146,
  0,0,232,0,168,76,3,168,22,0,19,228,198,151,38,128,19,0,0,160,240,198,151,138,0,0,221,0,0,18,0,37,
  0,199,151,138,128,53,221,0,0,0,128,53,16,199,151,154,0,39,221,0,0,0,128,53,0,0,39,8,1,168,0,128,
  8,140,4,168,220,1,168,22,0,0,0,0,160,60,199,151,138,0,0,221,0,0,18,0,53,76,199,151,138,128,39,221,
  0,0,0,0,53,92,199,151,154,128,39,221,0,0,0,0,53,0,128,39,22,0,0,116,199,151,38,0,0,0,0,160,
  128,199,151,138,0,0,221,0,0,18,0,53,144,199,151,138,128,39,221,0,0,0,0,53,160,199,151,138,128,39,221,0,
  0,0,0,53,176,199,151,154,128,39,221,0,0,0,0,52,0,128,38,38,0,0,0,0,160,204,199,151,129,0,0,200,
  4,168,42,128,19,220,199,151,157,0,0,26,128,33,38,128,19,33,128,33,240,199,151,38,128,19,0,0,160,4,60,192,
  0,200,151,143,2,0,8,200,151,143,6,17,16,200,151,143,50,0,24,200,151,143,32,0,32,200,151,143,8,0,200,4,
  168,47,128,19,2,4,192,232,0,168,76,3,168,0,8,0,31,8,19,47,0,1,232,0,168,28,2,19,47,8,33,31,
  16,0,241,18,0,200,4,168,46,32,0,44,160,19,28,192,33,250,212,37,0,128,5,47,180,19,33,160,49,12,8,33,
  47,192,53,19,0,39,47,160,19,30,128,1,49,128,52,0,0,38,8,1,168,29,96,19,236,128,5,0,0,33,220,1,
  168,4,60,192,0,0,5,31,62,0,1,128,1,8,1,168,29,98,19,236,128,5,0,0,36,220,1,168,208,200,151,144,
  126,21,246,2,0,220,200,151,246,6,0,0,0,5,31,0,0,236,200,151,22,0,0,0,0,160,248,200,151,129,0,0,
  4,16,192,4,201,151,143,0,0,200,4,168,19,96,19,60,0,0,0,0,37,45,128,19,32,201,151,154,128,36,61,0,
  37,22,128,37,48,201,151,38,0,0,0,0,160,60,201,151,129,0,0,132,16,192,72,201,151,143,32,0,80,201,151,143,
  96,0,88,201,151,143,32,0,96,201,151,143,0,0,200,4,168,46,224,19,28,32,19,250,96,37,13,128,37,250,0,37,
  31,160,36,47,32,0,241,0,0,200,4,168,46,224,19,28,0,19,152,201,151,154,0,37,13,128,37,250,0,36,31,160,
  37,0,32,0,47,32,0,241,0,0,200,4,168,46,224,19,246,32,0,28,32,19,250,64,37,13,128,37,250,0,37,212,
  201,151,22,128,36,220,201,151,38,0,0,0,0,160,132,14,192,236,201,151,143,2,0,244,201,151,143,6,0,252,201,151,
  143,0,0,196,51,192,8,202,151,143,16,0,31,80,0,20,202,151,143,16,0,31,38,0,194,31,192,36,202,151,129,0,
  0,224,5,168,130,29,192,52,202,151,145,0,0,148,5,168,68,18,192,47,192,19,1,0,192,5,31,192,196,31,192,242,
  64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,68,29,192,44,2,0,
  60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,5,27,
  192,196,27,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,68,
  29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,0,37,84,1,37,
  31,0,19,5,23,192,196,23,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,
  37,31,0,19,68,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,
  0,37,84,1,37,31,0,19,2,0,192,197,202,192,196,51,192,243,64,0,254,0,0,132,14,192,60,16,1,13,0,37,
  27,0,36,223,144,33,47,176,19,27,0,19,223,144,33,47,194,19,60,16,1,13,0,37,27,0,36,223,144,33,47,176,
  19,27,0,19,223,144,33,47,198,19,60,16,1,13,0,37,27,0,36,223,144,33,47,176,19,27,0,19,223,144,33,47,
  208,19,241,0,0,228,0,168,4,19,192,31,16,19,47,128,19,66,253,255,1,128,196,0,0,5,232,0,168,76,3,168,
  220,1,168,19,0,19,154,0,17,125,0,0,33,128,36,58,128,20,0,0,36,44,140,148,145,0,0,2,0,192,56,12,
  160,42,128,19,0,128,33,0,128,13,4,16,192,47,0,0,200,4,168,4,18,192,31,48,0,47,128,19,232,0,168,76,
  3,168,132,18,192,31,16,19,47,240,19,133,202,192,251,1,0,97,129,33,45,128,19,100,1,37,29,0,19,250,216,33,
  45,192,19,0,128,36,47,0,0,4,16,192,252,0,0,98,1,33,27,1,19,0,128,37,45,128,19,100,129,33,44,128,
  19,100,1,1,250,0,37,29,0,0,100,128,33,47,128,19,232,0,168,76,3,168,196,18,192,31,16,19,47,128,19,68,
  50,192,241,0,0,66,252,255,232,0,168,76,3,168,4,50,192,26,0,0,241,0,0,232,0,168,29,0,19,0,0,36,
  220,1,168,19,0,0,132,38,192,241,26,0,228,0,168,132,18,192,28,16,19,0,0,33,0,128,5,220,1,168,4,3,
  192,246,72,0,48,205,151,54,64,0,68,50,192,28,0,19,0,0,33,196,27,192,28,2,19,250,0,33,132,46,192,0,
  64,5,88,205,151,22,0,0,31,34,19,0,0,36,0,64,5,108,205,151,22,0,0,31,0,0,0,0,160,68,2,192,
  128,205,151,159,0,0,132,17,192,31,0,19,68,2,192,66,0,192,252,128,21,47,88,33,0,0,5,194,1,192,232,0,
  168,76,3,168,4,19,192,28,16,19,0,128,5,46,0,33,19,0,0,220,1,168,196,15,192,31,2,0,31,0,0,196,
  18,192,49,0,0,28,16,19,2,0,33,0,128,5,220,1,168,132,15,192,31,2,0,31,0,19,132,17,192,244,0,0,
  72,46,150,196,15,192,252,64,0,252,34,33,22,0,19,252,192,33,24,206,151,38,128,19,252,0,33,36,206,151,22,0,
  19,0,128,33,48,206,151,38,0,0,56,206,151,144,128,19,144,205,145,4,0,160,196,15,192,252,64,0,252,34,37,22,
  0,19,252,192,37,71,0,192,96,206,151,38,128,19,252,0,37,22,0,19,0,128,37,38,0,0,7,0,192,144,128,19,
  144,205,145,4,0,160,4,47,192,77,0,192,144,206,151,138,0,0,223,16,33,31,18,19,160,206,151,138,0,0,223,16,
  33,31,22,19,176,206,151,154,0,0,223,16,33,31,20,0,242,16,0,241,80,0,0,144,4,0,0,6,8,1,168,132,
  29,192,0,0,11,31,144,9,47,0,0,4,11,192,241,16,0,242,64,0,0,144,4,0,0,6,8,1,168,68,29,192,
  0,0,11,31,144,9,47,0,0,4,7,192,241,16,0,242,64,0,0,144,4,0,0,6,8,1,168,4,29,192,0,0,
  11,31,144,9,47,0,0,1,0,192,132,61,192,124,2,168,132,61,192,241,0,0,196,60,192,31,64,0,31,64,0,31,
  0,19,132,29,192,197,28,192,242,64,0,243,64,0,254,0,0,4,31,192,44,2,0,60,6,37,12,0,37,84,1,37,
  31,0,19,196,30,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,132,30,192,44,2,0,60,6,37,12,0,
  37,84,1,37,31,0,19,68,28,192,0,16,4,242,0,0,28,2,168,132,51,192,0,144,5,0,0,7,216,15,146,113,
  0,0,8,1,168,76,3,168,68,28,192,31,16,0,47,0,0,132,51,192,241,0,0,228,0,168,68,28,192,28,16,19,
  0,0,33,19,128,5,46,0,0,2,2,192,0,128,21,220,1,168,68,28,192,31,32,19,60,16,0,2,0,33,0,128,
  5,220,1,168,132,28,192,31,32,19,60,16,0,2,0,33,0,128,5,220,1,168,22,0,0,132,28,192,80,208,151,246,
  64,0,88,208,151,246,0,0,0,0,160,100,208,151,141,0,0,10,32,192,4,2,192,116,208,151,157,0,53,31,40,19,
  250,8,53,31,88,19,0,0,37,0,0,5,2,2,192,232,0,168,76,3,168,4,19,192,28,16,19,0,0,37,19,128,
  5,46,0,0,220,1,168,132,18,192,60,16,0,19,0,19,2,0,37,0,128,5,220,1,168,68,2,192,29,0,19,250,
  64,0,61,0,37,250,0,0,30,0,0,68,46,192,241,130,37,35,0,0,242,0,0,196,31,192,60,64,0,12,34,37,
  60,64,37,22,0,19,12,128,36,0,128,37,16,209,151,38,128,19,0,0,160,130,203,192,16,128,20,37,128,19,100,0,
  0,44,209,151,130,0,0,67,128,11,47,64,0,60,209,151,129,64,0,47,34,0,47,38,0,76,209,151,143,122,0,63,
  0,0,200,4,168,244,0,0,44,192,19,29,128,37,47,160,19,108,209,151,145,128,37,47,126,0,200,4,168,244,0,0,
  44,192,19,250,162,37,47,192,19,250,128,37,47,192,19,29,128,37,47,162,19,250,196,37,47,164,19,0,32,0,250,196,
  37,47,160,19,241,128,37,47,122,0,200,4,168,244,0,0,28,64,19,250,32,37,31,64,19,0,0,36,31,66,19,250,
  6,0,250,6,36,31,2,19,44,4,37,31,4,19,18,0,37,31,36,19,250,166,21,0,0,37,250,70,21,31,166,37,
  47,192,19,1,0,192,250,166,21,0,0,36,250,70,21,31,166,36,47,0,0,4,0,160,130,203,192,16,128,20,37,128,
  19,44,210,151,129,0,0,100,0,0,28,64,0,60,210,151,131,0,0,60,192,37,72,210,151,158,0,0,12,130,37,250,
  160,37,38,128,19,60,160,37,28,134,37,250,192,37,104,210,151,38,128,19,60,192,37,12,128,37,0,128,37,124,210,151,
  38,0,0,0,0,160,130,203,192,16,128,20,37,128,19,148,210,151,129,0,0,100,0,0,28,2,0,164,210,151,131,0,
  0,60,134,37,176,210,151,158,0,0,12,192,37,250,134,37,38,128,19,60,130,37,28,192,37,250,130,37,208,210,151,38,
  128,19,60,134,37,12,128,37,0,128,37,228,210,151,38,0,0,0,0,160,130,203,192,32,0,21,21,0,19,100,0,0,
  0,211,151,140,64,0,18,0,53,0,128,39,16,211,151,140,64,0,0,0,53,0,128,39,32,211,151,156,0,0,0,0,
  53,0,128,39,38,0,0,0,0,160,66,85,213,193,63,192,20,128,10,47,0,8,64,19,148,193,63,192,80,211,151,20,
  128,10,46,128,3,120,147,145,2,0,8,84,19,148,0,128,10,60,211,148,6,0,192,0,0,160,1,0,196,0,0,18,
  64,0,17,14,64,196,19,128,11,0,0,21,136,147,144,1,0,248,48,0,17,22,0,0,0,0,160,2,0,193,21,0,
  9,172,211,151,102,128,8,168,147,145,0,0,160,188,211,151,6,64,192,0,0,160,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,0,2,0,4,0,8,0,16,0,32,0,64,0,128,0,0,1,0,2,0,4,0,8,0,16,0,32,
  0,64,255,127,0,64,0,32,0,16,0,8,0,4,0,2,0,1,128,0,64,0,32,0,1,0,8,0,4,0,2,0,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,128,229,255,0,1,255,127,2,127,8,126,18,125,31,124,48,123,69,122,93,121,120,120,151,119,186,118,
  223,117,7,117,51,116,97,115,147,114,199,113,254,112,56,112,117,111,180,110,246,109,58,109,129,108,202,107,22,107,100,106,
  180,105,7,105,91,104,178,103,11,103,102,102,196,101,35,101,132,100,231,99,76,99,179,98,28,98,134,97,242,96,96,96,
  208,95,65,95,181,94,41,94,159,93,23,93,145,92,12,92,136,91,6,91,133,90,6,90,136,89,11,89,144,88,22,88,
  157,87,38,87,176,86,59,86,200,85,85,85,228,84,116,84,5,84,152,83,43,83,191,82,85,82,236,81,131,81,28,81,
  182,80,80,80,236,79,137,79,38,79,197,78,100,78,5,78,166,77,72,77,236,76,144,76,52,76,218,75,129,75,40,75,
  208,74,121,74,35,74,205,73,121,73,37,73,209,72,127,72,45,72,220,71,140,71,60,71,237,70,159,70,81,70,4,70,
  184,69,108,69,33,69,215,68,141,68,68,68,252,67,180,67,109,67,38,67,224,66,154,66,85,66,17,66,205,65,137,65,
  70,65,4,65,194,64,129,64,64,64,255,63,247,65,225,67,189,69,141,71,81,73,11,75,187,76,97,78,255,79,148,81,
  34,83,169,84,40,86,162,87,20,89,129,90,233,91,74,93,167,94,255,95,82,97,160,98,234,99,48,101,114,102,176,103,
  234,104,32,106,83,107,131,108,175,109,217,110,255,111,34,113,66,114,95,115,122,116,146,117,167,118,186,119,203,120,217,121,
  229,122,238,123,245,124,250,125,254,126,255,127,32,0,64,0,0,0,36,3,71,6,106,9,139,12,171,15,200,18,226,21,
  248,24,11,28,25,31,35,34,40,37,38,40,31,43,17,46,251,48,222,51,186,54,140,57,86,60,23,63,206,65,122,68,
  28,71,180,73,63,76,191,78,51,81,155,83,245,85,66,88,130,90,180,92,215,94,236,96,242,98,232,100,207,102,166,104,
  109,106,36,108,202,109,95,111,226,112,85,114,181,115,4,117,65,118,108,119,132,120,138,121,125,122,93,123,41,124,227,124,
  138,125,29,126,157,126,9,127,98,127,167,127,216,127,246,127,255,127,246,127,216,127,167,127,98,127,9,127,157,126,29,126,
  138,125,227,124,41,124,93,123,125,122,138,121,132,120,108,119,65,118,4,117,181,115,85,114,226,112,95,111,202,109,36,108,
  109,106,166,104,207,102,232,100,242,98,236,96,215,94,180,92,130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,
  28,71,122,68,206,65,23,63,86,60,140,57,186,54,222,51,251,48,17,46,31,43,38,40,40,37,35,34,25,31,11,28,
  248,24,226,21,200,18,171,15,139,12,106,9,71,6,36,3,255,127,246,127,216,127,167,127,98,127,9,127,157,126,29,126,
  138,125,227,124,41,124,93,123,125,122,138,121,132,120,108,119,65,118,4,117,181,115,85,114,226,112,95,111,202,109,36,108,
  109,106,166,104,207,102,232,100,242,98,236,96,215,94,180,92,130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,
  28,71,122,68,206,65,23,63,86,60,140,57,186,54,222,51,251,48,17,46,31,43,38,40,40,37,35,34,25,31,11,28,
  248,24,226,21,200,18,171,15,139,12,106,9,71,6,36,3,0,0,220,252,185,249,150,246,117,243,85,240,56,237,30,234,
  8,231,245,227,231,224,221,221,216,218,218,215,225,212,239,209,5,207,34,204,70,201,116,198,170,195,233,192,50,190,134,187,
  228,184,76,182,193,179,65,177,205,174,101,172,11,170,190,167,126,165,76,163,41,161,20,159,14,157,24,155,49,153,90,151,
  147,149,220,147,54,146,161,144,30,143,171,141,75,140,252,138,191,137,148,136,124,135,118,134,131,133,163,132,215,131,29,131,
  118,130,227,129,99,129,247,128,158,128,89,128,40,128,10,128,136,100,128,0,255,3,24,1,2,0,128,0,0,64,215,63,
  175,63,134,63,93,63,52,63,12,63,227,62,186,62,145,62,104,62,64,62,23,62,238,61,197,61,156,61,116,61,75,61,
  34,61,249,60,208,60,167,60,127,60,86,60,45,60,4,60,219,59,178,59,137,59,96,59,55,59,14,59,229,58,188,58,
  147,58,105,58,64,58,23,58,238,57,197,57,156,57,114,57,73,57,32,57,246,56,205,56,164,56,122,56,81,56,39,56,
  254,55,212,55,170,55,129,55,87,55,45,55,4,55,218,54,176,54,134,54,92,54,50,54,9,54,223,53,180,53,138,53,
  96,53,54,53,12,53,225,52,183,52,141,52,98,52,56,52,13,52,227,51,184,51,141,51,99,51,56,51,13,51,226,50,
  183,50,140,50,97,50,54,50,11,50,223,49,180,49,136,49,93,49,49,49,6,49,218,48,174,48,131,48,87,48,43,48,
  255,47,210,47,166,47,122,47,77,47,33,47,244,46,200,46,155,46,110,46,65,46,20,46,231,45,186,45,141,45,96,45,
  50,45,5,45,215,44,169,44,123,44,77,44,31,44,241,43,195,43,148,43,102,43,55,43,9,43,218,42,171,42,124,42,
  76,42,29,42,237,41,190,41,142,41,94,41,46,41,254,40,206,40,157,40,109,40,60,40,11,40,218,39,169,39,119,39,
  70,39,20,39,226,38,176,38,126,38,76,38,25,38,231,37,180,37,129,37,77,37,26,37,230,36,178,36,126,36,74,36,
  21,36,225,35,172,35,118,35,65,35,11,35,214,34,159,34,105,34,50,34,252,33,196,33,141,33,85,33,29,33,229,32,
  173,32,116,32,59,32,1,32,199,31,141,31,83,31,24,31,221,30,161,30,102,30,41,30,237,29,176,29,114,29,53,29,
  246,28,184,28,121,28,57,28,249,27,184,27,119,27,54,27,244,26,177,26,110,26,42,26,230,25,161,25,92,25,21,25,
  206,24,135,24,63,24,245,23,172,23,97,23,21,23,201,22,124,22,46,22,223,21,142,21,61,21,235,20,151,20,66,20,
  236,19,149,19,60,19,226,18,134,18,40,18,201,17,103,17,4,17,158,16,54,16,204,15,95,15,239,14,123,14,4,14,
  137,13,10,13,134,12,253,11,109,11,214,10,54,10,141,9,215,8,17,8,54,7,62,6,25,5,154,3,0,0,255,127,
  0,1,128,0,31,2,200,0,206,0,72,0,38,10,122,39,206,0,136,100,172,20,1,0,249,0,252,0,255,0,252,0,
  249,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char DSP1B[8192] = {
  0,192,151,7,0,193,6,32,192,2,48,192,16,192,151,129,128,18,12,128,145,7,0,192,0,0,11,160,64,144,0,0,
  11,128,64,144,0,0,11,96,64,144,0,0,11,76,64,144,0,0,11,176,6,144,204,70,144,0,0,11,132,71,144,0,
  0,11,64,7,144,244,70,144,0,0,11,116,64,144,0,0,11,208,7,144,0,72,144,0,0,11,252,8,144,64,73,144,
  0,0,11,148,64,144,0,0,11,236,9,144,128,77,144,0,0,11,140,14,144,104,80,144,0,0,11,184,64,144,0,0,
  11,0,0,11,32,17,144,36,82,144,0,0,11,204,64,144,0,0,11,140,18,144,244,82,144,0,0,11,0,0,11,168,
  83,144,0,0,11,60,19,144,192,83,144,194,3,192,4,0,192,29,0,18,4,65,145,29,32,21,244,0,146,225,64,0,
  64,224,84,32,224,83,0,0,10,92,65,145,0,0,10,68,65,145,0,128,11,202,255,223,208,128,18,42,0,0,2,16,
  192,232,0,168,37,0,0,109,0,0,0,0,37,69,8,192,80,128,84,33,128,18,100,129,148,0,0,11,10,0,224,2,
  4,192,208,0,83,33,128,18,76,129,148,194,3,192,232,0,160,26,0,19,48,0,20,124,65,148,209,0,64,69,16,192,
  80,0,21,21,0,19,109,0,0,0,0,33,168,65,148,160,1,145,0,0,49,192,1,148,194,255,223,33,128,77,0,0,
  10,184,1,145,0,0,49,192,65,148,65,0,224,32,128,83,42,128,18,208,129,148,96,0,21,96,0,21,42,128,19,0,
  0,37,0,128,113,232,0,168,197,3,192,80,128,20,0,130,148,69,12,192,80,128,21,37,128,19,27,0,19,0,0,101,
  24,194,145,16,0,18,20,66,148,193,255,223,32,128,83,65,0,224,32,128,83,232,0,168,202,3,192,208,128,20,104,194,
  145,80,130,148,69,12,192,80,128,21,37,128,19,27,0,19,0,128,37,76,130,148,0,0,72,0,0,64,35,128,19,16,
  128,21,18,0,19,100,130,148,0,0,8,108,1,160,18,0,18,116,66,148,16,0,83,16,0,19,0,0,72,16,0,19,
  250,64,17,242,64,20,160,2,148,254,160,20,172,194,148,66,12,192,254,160,21,192,2,160,210,0,0,254,160,20,184,130,
  148,66,12,192,0,160,21,192,2,160,66,12,192,222,160,21,33,0,0,0,16,4,21,0,19,251,16,0,15,16,37,31,
  80,19,33,0,0,0,16,4,21,0,19,251,16,0,15,16,37,31,80,19,33,0,0,0,16,4,21,0,19,251,16,0,
  15,16,37,31,16,83,10,1,192,29,0,19,0,0,37,52,67,145,0,0,10,64,67,145,44,67,148,65,0,224,0,0,
  64,193,255,223,0,0,64,0,0,53,44,67,148,0,0,64,0,0,53,36,3,148,0,0,64,16,96,18,200,67,145,104,
  3,148,0,32,10,0,0,9,104,3,146,0,0,8,5,25,192,27,129,10,97,129,9,99,0,37,21,0,19,109,128,9,
  222,0,36,48,0,20,26,0,19,10,0,33,16,0,21,156,3,146,193,255,223,29,0,19,0,0,36,48,0,20,26,0,
  19,0,0,33,16,0,21,188,3,146,193,255,223,208,3,150,0,0,10,0,96,73,193,255,223,194,11,192,0,96,64,16,
  0,18,228,67,148,8,4,168,0,0,64,42,128,19,29,0,19,208,128,20,224,0,22,8,4,168,42,128,19,29,0,19,
  208,128,20,224,0,86,32,128,18,44,196,148,44,128,19,29,128,37,1,0,192,36,132,148,193,255,255,0,128,53,0,0,
  103,202,255,223,208,128,18,44,128,19,29,128,37,1,0,192,72,132,148,193,255,255,0,128,5,0,128,53,0,0,103,92,
  4,168,92,4,168,100,1,0,242,64,0,243,64,0,254,0,0,116,4,168,116,4,168,100,1,0,44,2,0,60,6,37,
  12,0,37,100,1,37,31,0,83,0,128,11,156,132,144,0,0,11,0,128,9,26,0,0,1,240,223,13,8,192,46,0,
  50,130,53,192,13,16,192,26,128,37,37,0,0,98,1,0,97,128,20,45,0,0,2,0,101,16,96,18,224,4,148,0,
  32,10,0,0,9,64,69,146,197,134,192,27,1,19,109,1,37,96,1,21,98,1,0,110,129,50,43,128,19,21,128,37,
  43,128,19,99,128,37,0,0,21,21,0,19,109,0,21,32,0,20,32,5,146,65,0,224,50,0,0,0,128,37,48,133,
  146,194,255,223,60,5,150,0,128,10,0,224,73,0,96,64,32,224,83,16,96,18,88,5,148,0,32,10,0,0,9,148,
  69,146,5,200,192,98,1,0,27,1,19,109,1,53,96,0,18,26,128,37,37,128,19,96,129,21,97,128,20,45,128,19,
  0,0,37,148,5,150,26,0,0,65,0,224,208,96,84,32,224,83,36,128,19,207,255,223,0,2,0,47,6,0,47,68,
  0,47,64,0,47,34,0,66,0,0,4,0,192,47,0,0,204,4,168,35,96,0,244,128,10,31,134,9,216,133,146,194,
  255,223,47,198,19,63,134,21,31,4,64,4,0,192,47,0,0,204,4,168,35,96,0,244,128,10,31,192,9,4,134,146,
  194,255,223,47,192,19,47,2,0,47,32,0,31,32,0,63,6,0,47,64,0,47,64,0,207,255,223,50,4,64,36,128,
  19,15,0,208,0,2,0,47,6,0,47,68,0,47,64,0,47,34,0,66,0,0,4,0,192,47,0,0,204,4,168,0,
  128,11,35,96,11,244,128,10,31,134,9,47,198,19,63,134,21,31,4,64,4,0,192,47,0,0,204,4,168,0,128,11,
  35,96,11,244,128,10,31,192,9,47,192,19,47,2,0,47,32,0,31,32,0,63,6,0,47,64,0,47,64,0,15,0,
  208,50,4,64,176,198,151,138,0,0,184,198,151,157,0,0,0,0,33,22,0,19,0,0,160,204,198,151,129,0,0,212,
  198,151,146,0,0,232,0,168,76,3,168,22,0,19,232,198,151,38,128,19,0,0,160,244,198,151,138,0,0,221,0,0,
  18,0,37,4,199,151,138,128,53,221,0,0,0,128,53,20,199,151,154,0,39,221,0,0,0,128,53,0,0,39,8,1,
  168,0,128,8,140,4,168,220,1,168,22,0,0,0,0,160,64,199,151,138,0,0,221,0,0,18,0,53,80,199,151,138,
  128,39,221,0,0,0,0,53,96,199,151,154,128,39,221,0,0,0,0,53,0,128,39,22,0,0,120,199,151,38,0,0,
  0,0,160,132,199,151,138,0,0,221,0,0,18,0,53,148,199,151,138,128,39,221,0,0,0,0,53,164,199,151,138,128,
  39,221,0,0,0,0,53,180,199,151,154,128,39,221,0,0,0,0,52,0,128,38,38,0,0,0,0,160,208,199,151,129,
  0,0,204,4,168,42,128,19,224,199,151,157,0,0,26,128,33,38,128,19,33,128,33,244,199,151,38,128,19,0,0,160,
  4,60,192,4,200,151,143,2,0,12,200,151,143,6,17,20,200,151,143,50,0,28,200,151,143,32,0,36,200,151,143,8,
  0,204,4,168,47,128,19,2,4,192,232,0,168,76,3,168,0,8,0,31,8,19,47,0,1,232,0,168,28,2,19,47,
  8,33,31,16,0,241,18,0,204,4,168,46,32,0,44,160,19,28,192,33,250,212,37,0,128,5,47,180,19,33,160,49,
  12,8,33,47,192,53,19,0,39,47,160,19,30,128,1,49,128,52,0,0,38,8,1,168,29,96,19,236,128,5,0,0,
  33,220,1,168,4,60,192,0,0,5,31,62,0,1,128,1,8,1,168,29,98,19,236,128,5,0,0,36,220,1,168,212,
  200,151,144,126,21,246,2,0,224,200,151,246,6,0,0,0,5,31,0,0,240,200,151,22,0,0,0,0,160,252,200,151,
  129,0,0,4,16,192,8,201,151,143,0,0,204,4,168,19,96,19,60,0,0,0,0,37,45,128,19,36,201,151,154,128,
  36,61,0,37,22,128,37,52,201,151,38,0,0,0,0,160,64,201,151,129,0,0,132,16,192,76,201,151,143,32,0,84,
  201,151,143,96,0,92,201,151,143,32,0,100,201,151,143,0,0,204,4,168,46,224,19,28,32,19,250,96,37,13,128,37,
  250,0,37,31,160,36,47,32,0,241,0,0,204,4,168,46,224,19,28,0,19,156,201,151,154,0,37,13,128,37,250,0,
  36,31,160,37,0,32,0,47,32,0,241,0,0,204,4,168,46,224,19,246,32,0,28,32,19,250,64,37,13,128,37,250,
  0,37,216,201,151,22,128,36,224,201,151,38,0,0,0,0,160,132,14,192,240,201,151,143,2,0,248,201,151,143,6,0,
  0,202,151,143,0,0,196,51,192,12,202,151,143,16,0,31,80,0,24,202,151,143,16,0,31,38,0,194,31,192,40,202,
  151,129,0,0,228,5,168,130,29,192,56,202,151,145,0,0,152,5,168,68,18,192,47,192,19,1,0,192,5,31,192,196,
  31,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,68,29,192,
  44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,
  19,5,27,192,196,27,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,
  0,19,68,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,6,37,12,0,37,
  84,1,37,31,0,19,5,23,192,196,23,192,242,64,0,243,64,0,254,0,0,132,29,192,44,2,0,60,6,37,12,0,
  37,84,1,37,31,0,19,68,29,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,4,29,192,44,2,0,60,
  6,37,12,0,37,84,1,37,31,0,19,2,0,192,69,202,192,196,51,192,243,64,0,254,0,0,132,14,192,60,16,1,
  13,0,37,27,0,36,223,144,33,47,176,19,27,0,19,223,144,33,47,194,19,60,16,1,13,0,37,27,0,36,223,144,
  33,47,176,19,27,0,19,223,144,33,47,198,19,60,16,1,13,0,37,27,0,36,223,144,33,47,176,19,27,0,19,223,
  144,33,47,208,19,241,0,0,228,0,168,4,19,192,31,16,19,47,128,19,66,253,255,1,128,196,0,0,5,232,0,168,
  76,3,168,220,1,168,19,0,19,154,0,17,125,0,0,33,128,36,58,128,20,0,0,36,48,140,148,145,0,0,2,0,
  192,60,12,160,42,128,19,0,128,33,0,128,13,4,16,192,47,0,0,204,4,168,4,18,192,31,48,0,47,128,19,232,
  0,168,76,3,168,132,18,192,31,16,19,47,240,19,5,202,192,251,1,0,97,129,33,45,128,19,100,1,37,29,0,19,
  250,216,33,45,192,19,0,128,36,47,0,0,4,16,192,252,0,0,98,1,33,27,1,19,0,128,37,45,128,19,100,129,
  33,44,128,19,100,1,1,250,0,37,29,0,0,100,128,33,47,128,19,232,0,168,76,3,168,196,18,192,31,16,19,47,
  128,19,68,50,192,241,0,0,66,252,255,232,0,168,76,3,168,4,50,192,26,0,0,241,0,0,232,0,168,29,0,19,
  0,0,36,220,1,168,19,0,0,132,38,192,241,26,0,228,0,168,132,18,192,28,16,19,0,0,33,0,128,5,220,1,
  168,4,3,192,246,72,0,52,205,151,54,64,0,68,50,192,28,0,19,0,0,33,196,27,192,28,2,19,250,0,33,132,
  46,192,0,64,5,92,205,151,22,0,0,31,34,19,0,0,36,0,64,5,112,205,151,22,0,0,31,0,0,0,0,160,
  68,2,192,132,205,151,159,0,0,132,17,192,31,0,19,68,2,192,66,0,192,252,128,21,47,88,33,0,0,5,194,1,
  192,232,0,168,76,3,168,4,19,192,28,16,19,0,128,5,46,0,33,19,0,0,220,1,168,196,15,192,31,2,0,31,
  0,0,196,18,192,49,0,0,28,16,19,2,0,33,0,128,5,220,1,168,132,15,192,31,2,0,31,0,19,132,17,192,
  244,0,0,76,46,150,196,15,192,252,64,0,252,34,33,22,0,19,252,192,33,28,206,151,38,128,19,252,0,33,40,206,
  151,22,0,19,0,128,33,52,206,151,38,0,0,60,206,151,144,128,19,148,205,145,4,0,160,196,15,192,252,64,0,252,
  34,37,22,0,19,252,192,37,71,0,192,100,206,151,38,128,19,252,0,37,22,0,19,0,128,37,38,0,0,7,0,192,
  144,128,19,148,205,145,4,0,160,4,47,192,77,0,192,148,206,151,138,0,0,223,16,33,31,18,19,164,206,151,138,0,
  0,223,16,33,31,22,19,180,206,151,154,0,0,223,16,33,31,20,0,242,16,0,241,80,0,0,144,4,0,0,6,8,
  1,168,132,29,192,0,0,11,31,144,9,47,0,0,4,11,192,241,16,0,242,64,0,0,144,4,0,0,6,8,1,168,
  68,29,192,0,0,11,31,144,9,47,0,0,4,7,192,241,16,0,242,64,0,0,144,4,0,0,6,8,1,168,4,29,
  192,0,0,11,31,144,9,47,0,0,1,0,192,132,61,192,124,2,168,132,61,192,241,0,0,196,60,192,31,64,0,31,
  64,0,31,0,19,132,29,192,197,28,192,242,64,0,243,64,0,254,0,0,4,31,192,44,2,0,60,6,37,12,0,37,
  84,1,37,31,0,19,196,30,192,44,2,0,60,6,37,12,0,37,84,1,37,31,0,19,132,30,192,44,2,0,60,6,
  37,12,0,37,84,1,37,31,0,19,68,28,192,0,16,4,242,0,0,28,2,168,132,51,192,0,144,5,0,0,7,220,
  15,146,113,0,0,8,1,168,76,3,168,68,28,192,31,16,0,47,0,0,132,51,192,241,0,0,228,0,168,68,28,192,
  28,16,19,0,0,33,19,128,5,46,0,0,2,2,192,0,128,21,220,1,168,68,28,192,31,32,19,60,16,0,2,0,
  33,0,128,5,220,1,168,132,28,192,31,32,19,60,16,0,2,0,33,0,128,5,220,1,168,22,0,0,132,28,192,84,
  208,151,246,64,0,92,208,151,246,0,0,0,0,160,104,208,151,141,0,0,10,32,192,4,2,192,120,208,151,157,0,53,
  31,40,19,250,8,53,31,88,19,0,0,37,0,0,5,2,2,192,232,0,168,76,3,168,4,19,192,28,16,19,0,0,
  37,19,128,5,46,0,0,220,1,168,132,18,192,60,16,0,19,0,19,2,0,37,0,128,5,220,1,168,68,2,192,29,
  0,19,250,64,0,61,0,37,250,0,0,30,0,0,68,46,192,241,130,37,35,0,0,242,0,0,196,31,192,60,64,0,
  12,34,37,60,64,37,22,0,19,12,128,36,0,128,37,20,209,151,38,128,19,0,0,160,2,203,192,16,128,20,37,128,
  19,100,0,0,48,209,151,130,0,0,67,128,11,47,64,0,64,209,151,129,64,0,47,34,0,47,38,0,80,209,151,143,
  122,0,63,0,0,204,4,168,244,0,0,44,192,19,29,128,37,47,160,19,112,209,151,145,128,37,47,126,0,204,4,168,
  244,0,0,44,192,19,250,162,37,47,192,19,250,128,37,47,192,19,29,128,37,47,162,19,250,196,37,47,164,19,0,32,
  0,250,196,37,47,160,19,241,128,37,47,122,0,204,4,168,244,0,0,28,64,19,250,32,37,31,64,19,0,0,36,31,
  66,19,250,6,0,250,6,36,31,2,19,44,4,37,31,4,19,18,0,37,31,36,19,250,166,21,0,0,37,250,70,21,
  31,166,37,47,192,19,1,0,192,250,166,21,0,0,36,250,70,21,31,166,36,47,0,0,4,0,160,2,203,192,16,128,
  20,37,128,19,48,210,151,129,0,0,100,0,0,28,64,0,64,210,151,131,0,0,60,192,37,76,210,151,158,0,0,12,
  130,37,250,160,37,38,128,19,60,160,37,28,134,37,250,192,37,108,210,151,38,128,19,60,192,37,12,128,37,0,128,37,
  128,210,151,38,0,0,0,0,160,2,203,192,16,128,20,37,128,19,152,210,151,129,0,0,100,0,0,28,2,0,168,210,
  151,131,0,0,60,134,37,180,210,151,158,0,0,12,192,37,250,134,37,38,128,19,60,130,37,28,192,37,250,130,37,212,
  210,151,38,128,19,60,134,37,12,128,37,0,128,37,232,210,151,38,0,0,0,0,160,2,203,192,32,0,21,21,0,19,
  100,0,0,4,211,151,140,64,0,18,0,53,0,128,39,20,211,151,140,64,0,0,0,53,0,128,39,36,211,151,156,0,
  0,0,0,53,0,128,39,38,0,0,0,0,160,66,85,213,193,63,192,20,128,10,47,0,8,68,19,148,193,63,192,84,
  211,151,20,128,10,46,128,3,124,147,145,2,0,8,88,19,148,0,128,10,64,211,148,6,0,192,0,0,160,1,0,196,
  0,0,18,64,0,17,14,64,196,19,128,11,0,0,21,140,147,144,1,0,248,48,0,17,22,0,0,0,0,160,2,0,
  193,21,0,9,176,211,151,102,128,8,172,147,145,0,0,160,192,211,151,70,64,192,0,0,160,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,0,2,0,4,0,8,0,16,0,32,0,64,0,128,0,0,1,0,2,0,4,0,8,0,16,0,32,
  0,64,255,127,0,64,0,32,0,16,0,8,0,4,0,2,0,1,128,0,64,0,32,0,1,0,8,0,4,0,2,0,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,128,229,255,0,1,255,127,2,127,8,126,18,125,31,124,48,123,69,122,93,121,120,120,151,119,186,118,
  223,117,7,117,51,116,97,115,147,114,199,113,254,112,56,112,117,111,180,110,246,109,58,109,129,108,202,107,22,107,100,106,
  180,105,7,105,91,104,178,103,11,103,102,102,196,101,35,101,132,100,231,99,76,99,179,98,28,98,134,97,242,96,96,96,
  208,95,65,95,181,94,41,94,159,93,23,93,145,92,12,92,136,91,6,91,133,90,6,90,136,89,11,89,144,88,22,88,
  157,87,38,87,176,86,59,86,200,85,85,85,228,84,116,84,5,84,152,83,43,83,191,82,85,82,236,81,131,81,28,81,
  182,80,80,80,236,79,137,79,38,79,197,78,100,78,5,78,166,77,72,77,236,76,144,76,52,76,218,75,129,75,40,75,
  208,74,121,74,35,74,205,73,121,73,37,73,209,72,127,72,45,72,220,71,140,71,60,71,237,70,159,70,81,70,4,70,
  184,69,108,69,33,69,215,68,141,68,68,68,252,67,180,67,109,67,38,67,224,66,154,66,85,66,17,66,205,65,137,65,
  70,65,4,65,194,64,129,64,64,64,255,63,247,65,225,67,189,69,141,71,81,73,11,75,187,76,97,78,255,79,148,81,
  34,83,169,84,40,86,162,87,20,89,129,90,233,91,74,93,167,94,255,95,82,97,160,98,234,99,48,101,114,102,176,103,
  234,104,32,106,83,107,131,108,175,109,217,110,255,111,34,113,66,114,95,115,122,116,146,117,167,118,186,119,203,120,217,121,
  229,122,238,123,245,124,250,125,254,126,255,127,0,0,36,3,71,6,106,9,139,12,171,15,200,18,226,21,248,24,11,28,
  25,31,35,34,40,37,38,40,31,43,17,46,251,48,222,51,186,54,140,57,86,60,23,63,206,65,122,68,28,71,180,73,
  63,76,191,78,51,81,155,83,245,85,66,88,130,90,180,92,215,94,236,96,242,98,232,100,207,102,166,104,109,106,36,108,
  202,109,95,111,226,112,85,114,181,115,4,117,65,118,108,119,132,120,138,121,125,122,93,123,41,124,227,124,138,125,29,126,
  157,126,9,127,98,127,167,127,216,127,246,127,255,127,246,127,216,127,167,127,98,127,9,127,157,126,29,126,138,125,227,124,
  41,124,93,123,125,122,138,121,132,120,108,119,65,118,4,117,181,115,85,114,226,112,95,111,202,109,36,108,109,106,166,104,
  207,102,232,100,242,98,236,96,215,94,180,92,130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,28,71,122,68,
  206,65,23,63,86,60,140,57,186,54,222,51,251,48,17,46,31,43,38,40,40,37,35,34,25,31,11,28,248,24,226,21,
  200,18,171,15,139,12,106,9,71,6,36,3,255,127,246,127,216,127,167,127,98,127,9,127,157,126,29,126,138,125,227,124,
  41,124,93,123,125,122,138,121,132,120,108,119,65,118,4,117,181,115,85,114,226,112,95,111,202,109,36,108,109,106,166,104,
  207,102,232,100,242,98,236,96,215,94,180,92,130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,28,71,122,68,
  206,65,23,63,86,60,140,57,186,54,222,51,251,48,17,46,31,43,38,40,40,37,35,34,25,31,11,28,248,24,226,21,
  200,18,171,15,139,12,106,9,71,6,36,3,0,0,220,252,185,249,150,246,117,243,85,240,56,237,30,234,8,231,245,227,
  231,224,221,221,216,218,218,215,225,212,239,209,5,207,34,204,70,201,116,198,170,195,233,192,50,190,134,187,228,184,76,182,
  193,179,65,177,205,174,101,172,11,170,190,167,126,165,76,163,41,161,20,159,14,157,24,155,49,153,90,151,147,149,220,147,
  54,146,161,144,30,143,171,141,75,140,252,138,191,137,148,136,124,135,118,134,131,133,163,132,215,131,29,131,118,130,227,129,
  99,129,247,128,158,128,89,128,40,128,10,128,136,100,128,0,255,3,22,1,2,0,128,0,0,64,215,63,175,63,134,63,
  93,63,52,63,12,63,227,62,186,62,145,62,104,62,64,62,23,62,238,61,197,61,156,61,116,61,75,61,34,61,249,60,
  208,60,167,60,127,60,86,60,45,60,4,60,219,59,178,59,137,59,96,59,55,59,14,59,229,58,188,58,147,58,105,58,
  64,58,23,58,238,57,197,57,156,57,114,57,73,57,32,57,246,56,205,56,164,56,122,56,81,56,39,56,254,55,212,55,
  170,55,129,55,87,55,45,55,4,55,218,54,176,54,134,54,92,54,50,54,9,54,223,53,180,53,138,53,96,53,54,53,
  12,53,225,52,183,52,141,52,98,52,56,52,13,52,227,51,184,51,141,51,99,51,56,51,13,51,226,50,183,50,140,50,
  97,50,54,50,11,50,223,49,180,49,136,49,93,49,49,49,6,49,218,48,174,48,131,48,87,48,43,48,255,47,210,47,
  166,47,122,47,77,47,33,47,244,46,200,46,155,46,110,46,65,46,20,46,231,45,186,45,141,45,96,45,50,45,5,45,
  215,44,169,44,123,44,77,44,31,44,241,43,195,43,148,43,102,43,55,43,9,43,218,42,171,42,124,42,76,42,29,42,
  237,41,190,41,142,41,94,41,46,41,254,40,206,40,157,40,109,40,60,40,11,40,218,39,169,39,119,39,70,39,20,39,
  226,38,176,38,126,38,76,38,25,38,231,37,180,37,129,37,77,37,26,37,230,36,178,36,126,36,74,36,21,36,225,35,
  172,35,118,35,65,35,11,35,214,34,159,34,105,34,50,34,252,33,196,33,141,33,85,33,29,33,229,32,173,32,116,32,
  59,32,1,32,199,31,141,31,83,31,24,31,221,30,161,30,102,30,41,30,237,29,176,29,114,29,53,29,246,28,184,28,
  121,28,57,28,249,27,184,27,119,27,54,27,244,26,177,26,110,26,42,26,230,25,161,25,92,25,21,25,206,24,135,24,
  63,24,245,23,172,23,97,23,21,23,201,22,124,22,46,22,223,21,142,21,61,21,235,20,151,20,66,20,236,19,149,19,
  60,19,226,18,134,18,40,18,201,17,103,17,4,17,158,16,54,16,204,15,95,15,239,14,123,14,4,14,137,13,10,13,
  134,12,253,11,109,11,214,10,54,10,141,9,215,8,17,8,54,7,62,6,25,5,154,3,0,0,255,127,0,1,128,0,
  29,2,200,0,206,0,72,0,38,10,122,39,206,0,136,100,172,20,1,0,249,0,252,0,255,0,252,0,249,0,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char DSP2[8192] = {
  7,0,193,197,255,192,22,0,19,12,192,151,130,0,0,20,128,11,68,192,144,0,128,11,108,192,144,0,128,11,140,192,
  144,97,128,11,60,192,144,12,1,168,4,0,160,72,16,168,4,0,160,0,128,11,164,192,144,0,128,11,196,192,144,97,
  128,11,100,192,144,192,1,168,4,0,160,224,17,168,4,0,160,0,128,11,220,192,144,97,128,11,132,192,144,160,2,168,
  4,0,160,40,17,168,4,0,160,97,128,11,156,192,144,120,9,168,4,0,160,152,20,168,4,0,160,0,128,11,244,192,
  144,97,128,11,188,192,144,88,9,168,4,0,160,152,18,168,4,0,160,97,128,11,212,192,144,220,9,168,4,0,160,100,
  24,168,4,0,160,97,128,11,236,192,144,196,14,168,4,0,160,136,23,168,4,0,160,97,128,11,4,193,144,116,15,168,
  4,0,160,68,27,168,4,0,160,74,224,223,13,64,192,194,0,192,24,193,151,128,0,18,21,0,49,96,128,19,21,0,
  19,111,130,13,0,0,37,52,193,151,128,0,18,21,0,49,96,128,19,21,0,19,111,134,13,0,0,37,80,193,151,128,
  0,18,21,0,49,96,128,19,21,0,19,111,130,13,0,0,37,108,193,151,144,0,18,21,0,49,96,128,19,21,0,19,
  111,6,13,38,2,3,0,128,15,0,0,13,0,6,3,0,0,13,0,2,3,156,193,151,38,0,13,0,6,3,168,193,
  151,22,0,15,176,193,151,22,0,0,184,193,151,16,0,83,77,224,223,10,64,192,195,0,192,4,2,192,208,193,151,128,
  0,18,128,8,168,111,14,37,224,193,151,128,0,18,128,8,168,111,46,37,208,33,150,4,2,192,49,0,0,0,2,3,
  0,0,13,0,6,3,0,0,13,0,2,3,0,0,13,50,38,3,22,0,15,0,130,3,0,128,13,0,134,3,40,194,
  151,22,128,13,49,130,3,0,128,13,0,166,3,60,194,151,38,128,15,164,8,168,40,98,150,76,194,151,22,128,13,49,
  130,3,0,128,13,0,128,3,4,18,192,100,194,151,38,128,15,164,8,168,112,194,151,22,128,13,49,130,3,0,128,13,
  0,166,3,100,34,150,136,194,151,38,128,15,144,194,151,38,128,19,152,194,151,0,0,64,160,194,151,128,0,18,74,224,
  223,13,64,192,18,0,19,35,0,37,196,1,192,188,194,151,128,0,18,128,8,168,111,14,37,228,2,150,208,194,151,128,
  0,18,128,8,168,111,78,37,188,2,160,228,194,151,128,0,18,21,0,49,111,136,8,21,0,19,111,10,37,40,196,145,
  0,195,151,128,0,18,21,0,49,111,8,0,21,0,19,111,0,37,4,2,192,28,195,151,128,0,18,128,8,168,111,14,
  37,68,67,150,48,195,151,128,0,18,128,8,168,111,46,37,28,3,160,68,195,151,128,0,18,21,0,49,111,136,8,21,
  0,19,111,10,37,40,196,145,96,195,151,128,0,18,21,0,49,111,8,0,21,0,19,111,0,37,196,33,192,124,195,151,
  128,0,18,128,8,168,111,14,37,164,3,150,144,195,151,128,0,18,128,8,168,111,78,37,124,3,160,164,195,151,128,0,
  18,21,0,49,111,136,8,21,0,19,111,10,37,40,196,145,192,195,151,128,0,18,21,0,49,111,8,0,21,0,19,111,
  0,37,4,34,192,220,195,151,128,0,18,128,8,168,111,14,37,32,128,19,240,195,151,128,0,18,21,0,49,111,8,0,
  21,0,19,111,10,37,40,68,150,12,196,151,128,0,18,21,0,49,111,8,0,21,0,19,111,46,37,220,3,160,40,196,
  151,144,0,18,21,0,49,111,136,13,21,0,19,111,0,37,196,1,192,33,130,3,0,128,13,0,134,3,0,128,13,0,
  130,3,0,128,13,0,198,3,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,116,196,151,38,128,19,0,128,13,
  0,2,3,0,0,13,0,70,3,140,196,151,22,0,15,0,130,3,0,128,13,0,134,3,0,128,13,164,196,151,22,0,
  19,0,0,13,0,130,3,0,128,13,0,198,3,220,4,150,192,196,151,38,128,15,0,2,3,0,0,13,0,6,3,0,
  0,13,116,4,160,220,196,151,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,0,2,3,248,196,151,38,0,13,
  0,0,3,32,128,19,196,17,192,12,197,151,22,0,15,0,128,13,0,130,3,0,128,13,0,134,3,0,128,13,40,197,
  151,22,0,19,0,0,13,0,130,3,0,128,13,0,198,3,84,5,150,68,197,151,38,128,15,216,8,168,40,5,160,84,
  197,151,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,0,2,3,112,197,151,38,0,13,50,0,3,0,128,8,
  104,200,145,4,2,192,42,128,19,140,197,151,22,0,15,0,128,13,0,130,3,0,128,13,0,134,3,0,128,13,168,197,
  151,22,0,19,0,0,13,0,130,3,0,128,13,0,166,3,212,69,150,196,197,151,38,128,15,24,9,168,168,5,160,212,
  197,151,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,0,2,3,240,197,151,38,0,13,0,0,3,4,18,192,
  32,128,19,0,128,13,8,198,151,22,0,15,0,130,3,0,128,13,0,134,3,0,128,13,32,198,151,22,0,19,0,0,
  13,0,130,3,0,128,13,0,166,3,76,70,150,60,198,151,38,128,15,24,9,168,32,6,160,76,198,151,38,128,15,0,
  2,3,0,0,13,0,6,3,0,0,13,0,2,3,104,198,151,38,0,13,210,0,3,0,128,8,104,200,145,196,33,192,
  42,128,19,132,198,151,22,0,15,0,128,13,0,130,3,0,128,13,0,134,3,0,128,13,160,198,151,22,0,19,0,0,
  13,0,130,3,0,128,13,0,198,3,204,6,150,188,198,151,38,128,15,216,8,168,160,6,160,204,198,151,38,128,15,0,
  2,3,0,0,13,0,6,3,0,0,13,0,2,3,232,198,151,38,0,13,0,0,3,196,49,192,32,128,19,0,128,13,
  0,199,151,22,0,15,0,130,3,0,128,13,0,134,3,0,128,13,24,199,151,22,0,19,0,0,13,0,130,3,0,128,
  13,0,198,3,68,7,150,52,199,151,38,128,15,216,8,168,24,7,160,68,199,151,38,128,15,0,2,3,0,0,13,0,
  6,3,0,0,13,0,2,3,96,199,151,38,0,13,210,0,3,0,128,8,104,200,145,4,34,192,42,128,19,124,199,151,
  22,0,15,0,128,13,0,130,3,0,128,13,0,134,3,0,128,13,152,199,151,22,0,19,0,0,13,0,130,3,0,128,
  13,0,166,3,196,71,150,180,199,151,38,128,15,24,9,168,152,7,160,196,199,151,38,128,15,0,2,3,0,0,13,0,
  6,3,0,0,13,0,2,3,224,199,151,38,0,13,0,0,3,4,50,192,32,128,19,0,128,13,248,199,151,22,0,15,
  0,130,3,0,128,13,0,134,3,0,128,13,16,200,151,22,0,19,0,0,13,0,130,3,0,128,13,0,166,3,60,72,
  150,44,200,151,38,128,15,24,9,168,16,8,160,60,200,151,38,128,15,0,2,3,0,0,13,0,6,3,0,0,13,0,
  2,3,88,200,151,38,128,19,0,0,13,0,0,3,104,200,151,22,0,15,112,200,151,22,0,19,120,200,151,0,0,64,
  21,0,49,111,8,0,21,0,19,111,10,37,144,200,151,128,0,18,21,0,49,111,8,0,21,0,83,0,2,3,0,0,
  13,0,6,3,176,200,151,38,0,13,50,2,3,0,0,13,0,38,3,196,200,151,22,0,15,0,130,3,0,128,13,0,
  134,67,0,2,3,0,0,13,0,6,3,0,0,13,232,200,151,38,128,19,0,128,13,0,2,3,0,0,13,0,70,3,
  0,201,151,22,0,15,0,130,3,0,128,13,0,134,3,0,128,77,0,2,3,0,0,13,0,6,3,0,0,13,40,201,
  151,38,128,19,0,128,13,0,2,3,0,0,13,0,38,3,64,201,151,22,0,15,0,130,3,0,128,13,0,134,3,0,
  128,77,133,255,192,97,1,0,96,201,151,144,0,18,0,0,15,27,0,19,0,0,37,30,0,83,120,201,151,128,0,18,
  69,254,192,31,32,0,98,0,0,193,63,192,144,201,151,144,0,18,31,32,0,0,0,19,16,128,18,172,201,145,98,0,
  0,47,1,0,96,0,18,188,73,145,97,0,0,0,0,1,18,64,10,0,192,2,0,0,2,32,0,17,22,0,0,212,
  201,151,32,128,83,220,201,151,128,0,18,18,0,0,19,0,0,188,78,145,5,255,192,244,201,151,143,20,8,15,52,0,
  104,74,145,244,41,150,0,2,0,12,202,151,143,20,8,15,52,0,104,74,145,12,42,150,0,6,0,36,202,151,143,28,
  8,15,60,0,104,74,145,36,42,150,0,2,0,60,202,151,143,28,8,15,60,0,104,74,145,60,42,150,0,14,0,84,
  202,151,143,20,8,15,52,0,104,74,145,84,42,150,100,129,8,44,205,145,112,202,151,143,30,21,0,0,3,31,62,19,
  0,128,8,44,205,145,112,106,150,140,202,151,143,30,21,0,0,3,31,56,19,0,128,8,184,204,145,164,202,151,143,26,
  21,0,0,3,31,58,19,0,128,8,184,204,145,164,106,150,192,202,151,143,26,21,0,0,3,31,56,19,0,128,8,68,
  204,145,216,202,151,143,22,21,0,0,3,31,54,19,0,128,8,68,204,145,216,106,150,244,202,151,143,22,21,0,0,3,
  31,40,19,0,128,8,208,203,145,12,203,151,143,10,21,0,0,3,31,42,19,0,128,8,208,203,145,12,107,150,40,203,
  151,143,10,21,0,0,3,31,40,19,0,128,8,92,203,145,64,203,151,143,14,21,0,0,3,31,46,19,0,128,8,92,
  203,145,64,107,150,92,203,151,7,0,201,159,14,21,0,0,3,31,0,0,193,3,192,98,0,2,0,128,2,132,75,145,
  193,3,192,140,203,145,98,0,0,32,0,17,31,20,10,0,0,2,31,84,0,112,43,150,193,3,192,98,0,2,0,128,
  2,180,75,145,193,3,192,188,203,145,98,0,0,32,0,17,31,20,10,0,0,2,31,82,0,228,11,160,208,203,151,159,
  10,21,7,0,201,0,0,3,31,0,19,193,3,192,98,0,2,0,128,2,248,75,145,193,3,192,0,204,145,98,0,0,
  32,0,17,31,28,10,0,0,2,31,92,0,228,43,150,193,3,192,98,0,2,0,128,2,40,76,145,193,3,192,48,204,
  145,98,0,0,32,0,17,31,28,10,0,0,2,31,94,0,88,12,160,68,204,151,159,22,21,7,0,201,0,0,3,31,
  0,19,193,3,192,98,0,2,0,128,2,108,76,145,193,3,192,116,204,145,98,0,0,32,0,17,31,28,10,0,0,2,
  31,92,0,88,44,150,193,3,192,98,0,2,0,128,2,156,76,145,193,3,192,164,204,145,98,0,0,32,0,17,31,28,
  10,0,0,2,31,82,0,204,12,160,184,204,151,159,26,21,7,0,201,0,0,3,31,0,19,193,3,192,98,0,2,0,
  128,2,224,76,145,193,3,192,232,204,145,98,0,0,32,0,17,31,20,10,0,0,2,31,84,0,204,44,150,193,3,192,
  98,0,2,0,128,2,16,77,145,193,3,192,24,205,145,98,0,0,32,0,17,31,20,10,0,0,2,31,86,0,64,13,
  160,44,205,151,159,30,21,7,0,201,0,0,3,31,0,19,193,3,192,98,0,2,0,128,2,84,77,145,193,3,192,92,
  205,145,98,0,0,32,0,17,31,20,10,0,0,2,31,84,0,64,45,150,193,3,192,98,0,2,0,128,2,132,77,145,
  193,3,192,140,205,145,98,0,0,32,0,17,31,20,10,0,0,2,31,10,0,241,30,0,50,20,2,0,42,1,7,0,
  193,22,128,8,180,206,145,241,30,0,0,20,2,0,42,1,192,205,151,22,128,8,180,206,145,180,109,150,241,30,0,0,
  20,2,0,44,1,220,205,151,22,128,8,180,206,145,241,26,0,0,20,2,0,46,1,244,205,151,22,128,8,180,206,145,
  232,109,150,241,26,0,0,20,2,0,44,1,16,206,151,22,128,8,180,206,145,241,22,0,0,28,2,0,42,1,40,206,
  151,22,128,8,180,206,145,28,110,150,241,22,0,0,28,2,0,52,1,68,206,151,22,128,8,180,206,145,241,10,0,0,
  28,2,0,54,1,92,206,151,22,128,8,180,206,145,80,110,150,241,10,0,0,28,2,0,52,1,120,206,151,22,128,8,
  180,206,145,241,14,0,0,20,2,0,58,1,144,206,151,22,128,8,180,206,145,132,110,150,241,14,0,0,20,2,0,0,
  1,172,206,151,22,128,8,180,206,151,0,0,64,7,0,209,0,0,64,10,224,223,13,64,192,204,206,151,128,0,18,108,
  79,145,0,0,8,32,128,19,0,128,37,4,79,145,232,206,151,128,128,18,47,0,0,66,0,8,0,128,9,36,128,33,
  232,14,145,4,207,151,144,128,18,10,2,194,45,128,19,65,128,53,0,128,15,0,0,8,92,79,148,20,0,0,38,128,
  19,253,0,8,0,128,53,0,128,15,92,79,148,20,0,0,64,207,151,38,128,19,253,0,8,0,128,53,20,128,15,92,
  79,148,64,15,160,92,207,151,38,0,0,100,207,151,0,0,64,7,76,196,16,0,83,7,0,193,120,207,151,128,0,18,
  31,0,0,193,63,192,136,207,151,128,0,18,0,0,15,0,0,1,31,32,0,193,63,192,160,207,151,128,0,18,31,0,
  0,193,63,192,176,207,151,128,0,18,0,0,15,0,0,1,31,66,0,193,63,192,200,207,151,128,0,18,31,0,0,193,
  63,192,216,207,151,128,0,18,0,0,15,0,2,1,240,34,5,194,63,192,240,207,151,128,128,18,47,0,0,194,63,192,
  0,208,151,144,128,18,0,128,15,0,130,1,240,128,7,22,0,0,0,0,15,28,208,151,22,0,0,44,144,146,7,0,
  209,44,208,151,38,0,0,0,128,15,56,208,151,38,0,0,64,208,151,0,0,64,7,0,193,76,208,151,128,0,18,31,
  0,0,193,63,192,194,63,192,96,208,151,128,0,18,0,0,15,0,0,1,31,32,0,193,63,192,120,208,151,128,0,18,
  31,0,0,193,63,192,136,208,151,128,0,18,0,0,15,0,0,1,31,64,0,241,2,0,160,208,151,128,128,18,47,0,
  0,194,63,192,176,208,151,128,128,18,0,128,15,0,128,1,32,32,20,194,63,192,200,208,151,128,128,18,47,0,0,194,
  63,192,216,208,151,144,128,18,0,128,15,0,128,1,47,2,0,242,2,0,22,0,0,240,128,6,0,0,15,252,208,151,
  22,0,0,12,145,146,7,0,209,12,209,151,38,0,0,0,128,15,24,209,151,38,0,0,32,209,151,0,0,64,207,255,
  223,44,209,151,128,0,18,3,0,196,194,63,192,60,209,151,128,128,18,0,128,15,16,128,17,193,63,192,80,209,151,128,
  0,18,42,0,0,194,63,192,96,209,151,144,128,18,0,128,15,16,128,17,45,128,19,33,128,49,0,128,11,176,209,144,
  38,128,15,132,209,151,38,0,0,0,0,33,0,0,11,240,0,2,152,209,151,22,0,15,160,209,151,22,0,0,168,209,
  151,0,0,64,38,128,15,180,209,151,38,0,0,0,0,33,0,0,11,48,0,17,200,209,151,22,0,15,208,209,151,22,
  0,0,216,209,151,0,0,64,207,255,223,228,209,151,128,0,18,3,0,196,194,63,192,244,209,151,128,128,18,0,128,15,
  16,128,17,193,63,192,8,210,151,128,0,18,42,0,0,194,63,192,24,210,151,144,128,18,0,128,15,16,128,17,45,128,
  19,33,128,49,0,128,11,104,210,144,38,128,15,60,210,151,38,0,0,0,0,33,0,0,11,240,0,2,80,210,151,22,
  0,15,88,210,151,22,0,0,96,210,151,0,0,64,38,128,15,108,210,151,38,0,0,0,0,33,0,0,11,48,0,17,
  128,210,151,22,0,15,136,210,151,22,0,0,144,210,151,0,0,64,7,0,193,3,0,192,160,210,151,128,0,18,63,32,
  0,63,32,0,31,0,0,193,63,192,184,210,151,128,0,18,0,0,15,0,0,1,31,32,0,193,63,192,208,210,151,128,
  0,18,31,0,0,74,0,192,205,255,255,193,63,192,232,210,151,128,0,18,0,0,15,0,0,1,31,32,0,194,63,192,
  0,211,151,128,128,18,63,32,0,63,32,0,47,0,0,194,63,192,24,211,151,128,128,18,0,128,15,0,128,1,47,32,
  0,193,63,192,48,211,151,128,0,18,31,0,0,68,211,145,67,0,192,193,63,192,72,211,151,144,0,18,7,0,201,0,
  0,15,0,0,1,31,0,0,48,0,17,112,19,145,7,0,209,0,0,64,132,4,192,15,0,192,196,4,192,207,7,192,
  132,0,192,241,32,0,242,64,12,31,160,12,47,32,0,241,32,0,242,64,12,31,160,12,47,32,0,0,32,4,0,128,
  6,188,147,144,4,0,192,241,32,0,208,19,160,4,1,192,31,32,0,47,96,0,65,0,192,0,32,1,32,128,19,242,
  64,12,31,160,12,47,34,0,241,0,0,0,0,9,31,32,0,0,66,4,132,83,148,241,32,0,242,64,12,31,160,12,
  47,32,0,241,32,0,242,64,12,31,160,12,47,32,0,0,32,4,0,128,6,56,212,144,4,1,192,31,32,0,47,96,
  0,65,0,192,0,0,1,31,0,0,4,0,192,246,0,0,7,0,193,241,32,0,242,32,15,76,212,151,22,0,0,84,
  212,151,38,0,0,4,1,192,241,160,15,100,212,151,38,0,0,242,0,0,112,212,151,22,0,15,120,212,151,22,0,0,
  128,212,151,38,128,15,136,212,151,38,0,0,144,212,151,0,0,64,7,0,193,3,0,192,160,212,151,128,0,18,63,32,
  0,63,32,0,31,0,0,193,63,192,184,212,151,128,0,18,0,0,15,0,0,1,31,32,0,193,63,192,208,212,151,128,
  0,18,31,0,0,74,0,192,205,255,255,193,63,192,232,212,151,128,0,18,0,0,15,0,0,1,31,32,0,194,63,192,
  0,213,151,128,128,18,63,32,0,63,32,0,47,0,0,194,63,192,24,213,151,128,128,18,0,128,15,0,128,1,47,32,
  0,193,63,192,48,213,151,128,0,18,31,0,0,68,213,145,67,0,192,193,63,192,72,213,151,144,0,18,7,0,201,0,
  0,15,0,0,1,31,0,0,48,0,17,112,21,145,7,0,209,0,0,64,3,0,192,196,0,192,1,0,224,0,0,2,
  172,21,148,67,0,224,241,64,0,242,32,0,0,0,10,0,128,10,0,128,9,164,149,144,0,0,9,31,64,0,47,0,
  0,196,1,192,1,0,224,0,0,2,232,21,148,48,0,19,19,0,0,241,64,0,242,32,0,0,0,10,0,128,10,0,
  128,9,224,149,144,0,0,9,31,64,0,47,0,0,132,0,192,241,32,0,242,64,12,31,160,12,47,66,0,15,0,192,
  196,4,192,143,7,192,132,0,192,241,32,0,242,64,12,31,160,12,47,32,0,241,32,0,242,64,12,31,160,12,47,32,
  0,0,32,4,0,128,6,68,150,148,4,0,192,241,32,0,88,22,160,4,1,192,31,32,0,47,96,0,65,0,192,0,
  32,1,32,128,19,242,64,12,31,160,12,47,34,0,241,0,0,0,0,9,31,32,0,0,66,4,12,86,148,241,32,0,
  242,64,12,31,160,12,47,32,0,241,32,0,242,64,12,31,160,12,47,32,0,0,32,4,0,128,6,192,214,148,4,1,
  192,31,32,0,47,96,0,65,0,192,0,0,1,31,0,0,49,0,0,0,0,50,244,86,145,68,0,192,241,64,0,242,
  32,0,0,0,10,0,128,10,0,128,9,236,150,144,0,0,9,31,64,0,47,0,0,49,0,0,208,0,18,40,87,145,
  68,1,192,241,64,0,242,32,0,0,0,10,0,128,10,0,128,9,32,151,144,0,0,9,31,64,0,47,0,0,4,0,
  192,246,0,0,7,0,193,241,32,0,242,32,15,60,215,151,22,0,0,68,215,151,38,0,0,4,1,192,241,160,15,84,
  215,151,38,0,0,242,0,0,96,215,151,22,0,15,104,215,151,22,0,0,112,215,151,38,128,15,120,215,151,38,0,0,
  128,215,151,0,0,64,7,0,192,0,128,11,160,215,144,0,128,11,84,216,144,192,23,160,0,128,11,184,215,144,52,24,
  160,172,215,151,7,0,193,0,0,64,7,0,193,0,0,64,66,85,213,193,63,192,20,128,10,47,0,8,200,23,148,193,
  63,192,216,215,151,20,128,10,46,128,3,4,152,145,2,0,8,220,23,148,0,128,10,196,215,148,6,0,192,252,215,151,
  172,23,160,1,0,196,0,0,18,64,0,17,14,64,196,19,128,11,0,0,21,20,152,144,1,0,248,48,0,17,22,0,
  0,44,216,151,172,23,160,2,0,193,1,0,192,21,0,9,64,216,151,102,128,8,60,152,145,76,216,151,172,23,160,84,
  216,151,6,64,192,92,216,151,172,23,160,10,224,223,13,64,192,108,216,151,128,0,18,0,0,15,19,0,15,0,0,9,
  0,0,11,18,0,33,136,216,151,128,32,18,0,0,9,31,64,11,31,0,19,0,2,33,0,128,8,164,216,151,128,0,
  18,31,0,0,65,128,8,0,0,9,20,0,33,164,152,145,192,216,151,144,0,18,7,0,209,31,0,19,50,0,0,4,
  1,192,31,64,0,31,64,0,31,32,0,220,26,168,132,0,192,31,32,0,242,0,0,31,32,0,241,0,0,0,128,12,
  0,0,12,0,128,12,0,0,12,0,128,12,0,0,12,0,128,12,0,0,12,0,128,12,0,0,12,0,128,12,0,0,
  12,31,32,19,47,32,0,31,32,0,31,32,0,15,4,192,0,32,0,15,30,192,4,0,192,242,0,0,4,30,192,31,
  0,0,65,128,8,0,0,9,20,0,19,84,153,145,13,2,194,68,0,192,241,0,0,0,0,8,31,0,0,160,90,145,
  4,2,192,243,0,0,52,0,0,250,0,0,132,0,192,241,32,0,0,0,3,176,89,145,1,192,255,0,0,50,0,0,
  15,180,25,160,209,0,0,196,0,192,2,32,192,0,128,3,232,217,145,26,0,0,1,60,192,208,0,18,68,2,192,243,
  0,0,52,0,0,194,3,192,0,128,2,8,26,160,26,0,0,193,3,192,208,0,18,68,2,192,243,0,0,52,0,0,
  2,60,192,0,128,2,32,0,17,31,0,0,196,0,192,1,32,192,0,0,3,31,0,0,52,26,145,68,2,192,241,0,
  0,0,0,9,31,0,0,196,1,192,241,64,0,242,64,0,35,0,0,0,64,5,0,160,7,0,32,0,47,32,0,31,
  0,0,48,128,20,52,218,145,0,128,11,4,2,192,241,0,0,32,0,21,31,0,0,108,153,144,132,0,192,1,32,192,
  0,0,3,31,0,0,108,25,145,4,2,192,241,0,0,0,0,9,31,0,0,108,25,160,4,0,192,241,0,0,4,30,
  192,246,0,0,7,0,193,0,32,8,212,90,145,188,218,151,246,0,0,66,0,8,0,128,9,36,0,0,188,26,145,212,
  218,151,0,0,64,131,4,192,241,0,0,0,0,12,31,0,0,4,27,144,16,32,19,241,0,0,0,0,13,0,0,11,
  31,64,19,0,64,0,241,128,12,0,0,12,31,64,0,32,128,17,0,32,4,48,91,144,31,32,0,65,0,192,0,0,
  1,31,64,0,49,0,0,0,0,8,19,32,0,224,26,145,0,64,64,7,0,193,0,0,64,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,
  1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,
  3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,
  1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,
  3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,
  1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,
  3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,
  1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,
  3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,
  1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,
  3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,
  1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,
  3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,3,0,2,0,3,1,2,1,
  1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,1,
  3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,3,2,2,2,3,3,2,3,
  1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,1,2,0,2,1,3,0,3,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  3,0,3,0,3,0,3,0,2,0,2,0,2,0,2,0,3,1,3,1,3,1,3,1,2,1,2,1,2,1,2,1,
  3,0,3,0,3,0,3,0,2,0,2,0,2,0,2,0,3,1,3,1,3,1,3,1,2,1,2,1,2,1,2,1,
  3,0,3,0,3,0,3,0,2,0,2,0,2,0,2,0,3,1,3,1,3,1,3,1,2,1,2,1,2,1,2,1,
  3,0,3,0,3,0,3,0,2,0,2,0,2,0,2,0,3,1,3,1,3,1,3,1,2,1,2,1,2,1,2,1,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,
  3,2,3,2,3,2,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,
  3,2,3,2,3,2,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,
  3,2,3,2,3,2,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,
  3,2,3,2,3,2,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,
  1,2,1,2,1,2,1,2,0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3,0,3,0,3,0,3,0,3,
  1,2,1,2,1,2,1,2,0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3,0,3,0,3,0,3,0,3,
  1,2,1,2,1,2,1,2,0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3,0,3,0,3,0,3,0,3,
  1,2,1,2,1,2,1,2,0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3,0,3,0,3,0,3,0,3,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  0,0,0,0,0,0,0,0,16,16,0,0,143,0,129,127,240,0,15,0,128,127,240,0,80,0,128,8,15,0,255,0,
};
const unsigned char DSP3[8192] = {
  0,192,151,4,0,192,7,0,193,6,32,192,2,48,192,20,192,151,129,128,18,16,128,145,7,0,192,18,0,11,28,72,
  144,184,72,145,0,0,11,124,70,144,0,0,11,148,73,144,0,0,11,84,65,144,0,0,11,220,71,144,80,0,160,0,
  0,11,208,64,144,0,0,11,236,64,144,66,85,213,193,63,192,20,128,10,47,0,8,108,0,148,193,63,192,124,192,151,
  20,128,10,46,128,3,164,128,145,2,0,8,128,0,148,0,128,10,104,192,148,6,0,192,0,0,160,1,0,196,0,0,
  18,64,0,17,14,64,196,19,128,11,0,0,21,180,128,144,1,0,248,48,0,17,22,0,0,0,0,160,2,0,193,1,
  0,192,21,0,9,220,192,151,102,128,8,216,128,145,0,0,160,236,192,151,6,192,192,0,0,160,32,128,19,69,0,0,
  68,3,192,16,0,19,47,32,0,31,2,0,241,192,17,242,32,12,31,2,0,56,1,144,7,0,208,22,2,0,40,193,
  151,79,0,192,146,2,0,7,0,192,241,194,12,47,2,12,242,32,0,31,192,8,47,34,0,16,129,148,84,0,64,0,
  0,11,0,68,144,6,32,192,132,7,192,15,0,224,104,193,151,129,32,0,13,16,192,10,56,192,224,0,21,30,0,0,
  128,193,151,159,0,0,66,0,192,252,0,168,0,0,8,204,65,145,168,1,148,2,2,192,252,0,168,212,1,160,0,0,
  8,184,1,145,248,0,168,200,1,160,194,0,192,252,0,168,0,0,9,0,0,9,0,0,9,0,0,9,48,0,21,19,
  128,17,212,0,15,242,0,11,0,128,12,47,128,17,226,0,12,0,128,11,8,194,144,36,0,0,226,0,0,31,128,9,
  45,0,0,44,2,160,36,0,15,226,0,1,31,128,9,193,3,192,45,0,18,44,2,145,209,0,0,0,0,9,26,0,
  0,0,128,20,136,129,145,194,3,192,224,128,18,96,66,145,1,4,192,32,0,20,212,0,0,242,0,0,0,128,12,0,
  0,8,80,2,145,47,0,0,4,0,192,248,0,168,0,0,9,30,0,21,16,0,21,19,2,19,31,2,0,130,0,192,
  252,0,168,2,4,192,31,130,21,37,0,0,98,0,0,49,160,5,47,2,8,19,0,0,124,2,145,10,56,192,205,63,
  192,2,0,0,196,7,192,243,0,0,252,0,168,20,0,0,242,2,0,252,0,168,0,0,5,69,6,192,18,0,0,96,
  1,18,96,1,21,21,128,11,1,8,192,32,0,21,4,195,144,20,128,11,241,128,11,0,128,11,208,128,21,36,0,15,
  24,3,160,20,128,11,241,128,11,0,128,11,208,128,21,36,0,0,224,0,18,98,0,0,0,128,2,80,195,145,130,0,
  224,16,128,21,38,0,0,52,195,151,248,0,168,2,2,192,16,0,21,16,0,21,16,128,21,252,0,168,22,0,0,49,
  0,0,2,0,8,19,0,0,96,195,151,184,2,145,4,0,160,108,195,151,129,0,0,242,0,11,0,128,12,47,32,0,
  242,0,11,0,128,12,47,32,0,242,0,11,0,128,12,47,32,0,242,0,11,0,128,12,47,32,0,242,0,11,0,128,
  12,47,32,0,242,0,11,0,128,12,47,32,0,242,0,11,0,128,12,47,32,0,242,0,11,0,128,12,47,96,64,212,
  195,151,242,32,11,0,128,12,224,128,18,46,0,0,242,32,11,0,128,12,224,128,18,0,128,15,0,128,17,38,0,64,
  0,0,11,108,68,144,205,63,192,12,196,151,131,0,0,7,0,193,6,0,192,108,3,168,108,3,168,108,3,168,108,3,
  168,108,3,168,108,3,168,108,3,168,56,196,151,129,0,0,7,0,192,216,3,168,212,3,168,212,3,168,212,3,168,84,
  196,151,49,0,0,0,0,8,19,96,0,20,4,145,0,0,160,6,32,192,132,7,192,15,0,224,120,196,151,129,32,0,
  13,16,192,10,56,192,224,0,21,30,0,0,144,196,151,159,0,0,66,0,192,252,0,168,0,0,8,220,68,145,184,4,
  148,2,2,192,252,0,168,228,4,160,0,0,8,200,4,145,248,0,168,216,4,160,194,0,192,252,0,168,0,0,9,0,
  0,9,0,0,9,0,0,9,48,0,21,19,128,17,212,0,15,242,0,11,0,128,12,47,128,17,226,0,12,0,128,11,
  24,197,144,36,0,0,226,0,0,31,128,9,45,0,0,60,5,160,36,0,15,226,0,1,31,128,9,193,3,192,45,0,
  18,60,5,145,209,0,0,0,0,9,26,0,0,0,128,20,152,132,145,194,3,192,224,128,18,112,69,145,1,4,192,32,
  0,20,212,0,0,242,0,0,0,128,12,0,0,8,96,5,145,47,0,0,4,0,192,248,0,168,0,0,9,30,0,21,
  16,0,21,19,2,19,31,2,0,130,0,192,252,0,168,2,4,192,31,130,21,37,0,0,98,0,0,49,160,5,47,2,
  8,19,0,0,140,5,145,10,56,192,205,63,192,2,0,0,196,7,192,243,0,0,252,0,168,20,0,0,242,2,0,252,
  0,168,0,0,5,69,6,192,18,0,0,96,1,18,96,1,21,21,128,11,1,8,192,32,0,21,20,198,144,20,128,11,
  241,128,11,0,128,11,208,128,21,36,0,15,40,6,160,20,128,11,241,128,11,0,128,11,208,128,21,36,0,0,224,0,
  18,98,0,0,0,128,2,96,198,145,130,0,224,16,128,21,38,0,0,68,198,151,248,0,168,194,1,192,16,0,21,16,
  0,21,16,128,21,252,0,168,22,0,0,49,0,0,2,0,8,19,0,0,112,198,151,200,5,145,4,0,160,0,0,11,
  192,78,144,7,0,192,196,30,192,140,198,151,138,0,0,241,16,0,31,48,0,241,16,0,31,48,0,241,16,0,31,48,
  0,241,16,0,31,48,0,180,198,151,141,0,0,188,198,151,129,0,0,18,0,12,208,6,144,4,0,160,193,62,192,0,
  128,11,16,128,21,36,0,0,35,0,0,244,0,0,7,0,192,236,198,151,129,16,0,208,0,20,31,0,0,30,0,0,
  44,71,148,5,7,192,96,1,20,84,71,144,241,0,0,96,1,20,40,71,144,241,0,0,96,1,20,31,0,0,80,7,
  160,197,7,192,96,1,21,84,71,144,241,0,0,96,1,21,80,71,144,241,0,0,96,1,21,31,0,0,7,0,208,84,
  199,151,129,0,0,224,32,20,31,0,0,120,71,148,2,72,192,32,0,20,136,71,144,132,7,160,2,16,192,32,0,21,
  136,71,144,7,0,208,162,64,0,241,128,12,38,0,0,148,199,151,172,135,148,22,0,0,160,199,151,6,0,224,188,6,
  160,6,0,0,15,32,0,180,199,151,246,80,0,188,199,151,6,0,224,196,199,151,143,32,0,65,0,0,52,0,9,31,
  0,0,188,6,160,7,0,192,196,30,192,2,32,192,47,32,0,236,199,151,129,128,21,0,0,12,232,7,144,4,0,160,
  197,43,192,29,0,19,98,1,33,0,128,50,96,0,18,32,0,17,0,0,79,0,0,11,188,77,144,69,43,192,4,0,
  192,66,0,0,48,200,151,129,128,17,96,129,21,96,129,18,96,0,21,96,128,21,21,0,0,99,0,0,37,0,0,110,
  0,0,88,200,151,129,0,0,58,0,11,31,32,0,0,8,168,31,32,0,112,200,151,145,0,0,10,0,11,31,64,0,
  0,8,168,0,32,5,22,0,0,58,0,0,241,64,0,0,8,168,31,64,0,10,0,0,241,32,0,0,8,168,0,0,
  4,172,200,151,22,0,0,0,0,160,184,200,151,129,128,17,0,0,11,26,0,0,200,200,151,145,0,0,0,0,11,29,
  0,19,18,0,49,0,0,12,22,128,33,228,200,151,0,128,12,38,0,0,0,0,160,20,0,0,244,0,9,63,0,64,
  99,1,0,100,0,0,21,0,0,244,0,0,241,32,0,78,16,12,144,73,144,253,64,0,250,0,0,2,0,192,52,0,
  0,244,0,0,241,0,0,0,0,12,124,73,144,209,16,0,0,32,4,76,9,148,0,0,10,96,0,20,104,9,144,225,
  0,0,0,0,4,100,9,148,0,0,10,96,0,20,0,144,12,65,0,0,0,0,9,20,0,19,48,9,160,4,0,0,
  65,0,0,47,0,9,20,0,19,16,9,160,0,0,64,0,0,11,240,73,144,7,0,208,193,62,192,195,255,255,244,8,
  168,244,8,168,244,8,168,244,8,168,197,9,192,129,10,192,0,9,168,69,9,192,129,10,192,0,9,168,197,8,192,129,
  10,192,0,9,168,69,8,192,65,10,192,0,9,168,7,0,192,4,0,160,0,0,11,160,74,144,193,9,192,205,255,199,
  0,202,151,144,0,20,21,0,0,100,1,0,241,16,0,254,0,20,36,10,145,6,0,192,0,0,160,100,0,0,243,0,
  0,5,10,192,16,0,19,52,0,17,96,0,21,19,0,19,242,32,0,32,128,17,28,202,148,240,0,17,52,74,145,224,
  128,18,38,0,0,10,0,0,96,202,151,210,0,0,96,128,20,42,0,11,124,74,144,148,74,145,100,10,160,212,0,0,
  226,0,0,0,128,2,38,0,0,140,202,151,100,10,160,22,0,0,152,202,151,52,10,160,206,255,255,205,30,192,168,202,
  151,129,128,17,0,0,11,224,0,21,20,0,0,243,0,0,192,202,151,141,0,0,200,202,151,154,0,0,52,0,0,241,
  0,0,226,16,12,40,75,144,20,11,148,209,160,4,240,138,148,0,128,10,0,0,4,252,10,148,0,0,10,32,0,21,
  18,0,0,0,0,20,20,11,144,46,80,0,69,0,0,49,0,0,0,0,9,0,0,9,19,0,0,208,10,160,1,0,
  0,84,0,12,60,75,148,193,255,199,0,0,2,22,0,0,64,203,151,6,0,0,0,0,160,4,61,192,79,0,192,4,
  60,192,111,33,0,111,0,0,196,60,192,79,236,192,4,61,192,138,2,192,242,32,0,253,96,0,0,160,5,241,160,53,
  37,0,0,13,0,194,194,3,192,96,0,21,152,11,148,0,0,5,26,128,18,37,0,0,1,51,192,98,0,37,20,0,
  0,209,128,2,84,141,145,0,0,11,3,229,192,5,230,192,204,11,144,67,227,192,69,228,192,196,61,192,47,32,0,63,
  32,0,31,32,0,20,0,0,97,1,0,98,1,2,84,77,145,10,1,192,29,0,19,67,128,2,100,0,49,31,64,0,
  47,34,15,31,192,15,47,64,0,132,62,192,143,1,192,196,60,192,138,2,192,245,32,0,97,33,0,98,65,5,29,224,
  5,0,160,5,241,32,0,0,160,53,95,64,0,37,0,0,96,0,21,69,230,192,80,12,148,0,0,5,30,0,11,92,
  12,144,133,228,192,10,1,192,100,1,0,243,0,0,20,0,0,97,1,0,50,0,2,16,77,145,29,0,0,97,129,53,
  45,0,2,168,204,144,16,128,20,172,140,144,0,1,0,242,1,0,96,129,18,224,128,17,47,0,0,16,13,160,194,255,
  255,100,1,0,96,129,20,16,205,144,0,64,5,16,77,144,19,0,4,16,13,144,13,0,194,194,3,192,10,128,18,78,
  0,0,37,0,0,1,51,192,98,0,37,20,0,0,49,128,2,16,141,145,4,0,0,31,2,15,31,0,0,196,61,192,
  31,0,0,132,62,192,79,1,192,20,12,160,132,62,192,241,0,0,0,0,8,31,0,0,20,12,145,196,61,192,0,32,
  1,84,77,145,245,32,0,241,0,0,98,1,0,100,0,0,243,0,0,20,0,0,0,128,2,48,128,17,47,0,0,68,
  61,192,242,64,0,241,128,20,0,0,9,31,160,9,96,139,145,0,0,64,132,61,192,31,0,0,197,226,192,76,11,168,
  69,226,192,76,11,168,197,225,192,76,11,168,69,225,192,76,11,168,197,224,192,76,11,168,69,224,192,76,11,168,241,32,
  0,242,64,9,31,128,20,120,141,145,0,0,64,0,0,11,252,77,144,196,62,192,193,63,192,250,64,0,19,0,0,212,
  205,151,130,0,18,31,32,21,0,128,15,48,160,18,45,0,0,47,0,53,0,0,11,22,0,0,0,0,160,0,0,11,
  84,64,144,7,0,193,195,63,192,194,236,192,196,62,192,49,0,0,24,206,151,128,0,18,16,128,21,16,128,21,37,0,
  0,250,64,0,49,0,0,7,0,192,56,206,151,130,0,18,31,160,15,48,160,18,96,0,18,47,32,11,97,1,0,96,
  129,23,45,128,4,104,142,144,226,0,0,116,14,160,116,142,148,0,128,5,0,128,5,45,128,15,132,62,192,0,32,5,
  19,0,4,160,78,144,148,14,148,0,0,5,0,0,5,19,128,17,38,0,0,168,14,160,49,128,17,38,0,0,168,206,
  151,16,0,21,0,0,53,0,0,11,22,0,0,0,0,160,0,0,11,64,83,144,196,62,192,193,63,192,19,0,0,212,
  206,151,130,0,18,31,160,15,48,160,18,47,0,0,4,0,160,132,60,192,245,0,0,195,63,192,49,0,0,2,0,18,
  196,62,192,250,64,0,132,62,192,31,160,15,48,160,18,96,0,18,47,32,11,97,1,0,96,128,23,45,128,4,52,143,
  144,226,0,0,64,15,160,64,143,148,0,128,5,0,128,5,45,64,0,47,128,15,132,62,192,0,32,5,19,0,4,108,
  79,144,100,15,148,0,0,5,0,0,5,19,192,17,112,15,160,49,192,17,31,0,21,46,0,53,0,0,11,19,0,64,
  196,60,192,245,0,0,196,62,192,250,64,0,241,32,0,96,32,18,242,32,11,97,1,0,96,128,23,45,128,4,180,143,
  144,226,0,0,192,15,160,192,143,148,0,128,5,0,128,5,45,64,0,47,0,0,132,62,192,0,32,5,18,64,4,236,
  15,144,47,0,0,32,128,21,0,128,53,0,128,11,35,0,64,252,15,148,0,32,0,0,0,5,0,64,5,31,0,0,
  16,0,21,0,0,53,0,0,11,19,0,64,13,0,194,60,16,148,193,3,192,58,0,18,21,0,0,1,51,192,0,0,
  37,20,0,0,97,0,0,0,0,1,31,0,64,193,3,192,58,0,18,21,0,0,1,51,192,0,0,37,20,0,0,97,
  0,0,0,0,10,0,0,2,31,0,64,138,2,192,132,63,192,66,44,192,0,160,5,253,0,0,0,128,53,37,0,0,
  132,61,192,242,32,0,96,128,21,47,0,0,132,63,192,1,0,192,0,0,1,168,16,145,236,14,168,172,16,160,128,15,
  168,7,0,192,54,0,0,180,208,151,6,0,192,7,0,193,4,62,192,63,64,0,242,0,0,35,128,11,208,208,151,129,
  0,0,47,0,15,16,209,144,16,16,168,196,61,192,244,0,0,193,63,192,2,62,254,244,208,151,144,0,18,0,0,15,
  8,17,148,47,0,64,32,0,17,31,0,64,16,16,168,196,61,192,244,0,0,193,63,192,32,209,151,144,0,18,18,0,
  15,52,17,148,0,0,64,0,128,1,47,0,64,2,243,192,132,61,192,16,128,21,37,0,0,111,0,0,2,58,192,16,
  128,21,36,0,0,254,0,0,132,60,192,194,236,192,16,128,21,16,128,21,47,32,9,0,0,9,194,236,192,16,128,21,
  16,128,21,47,128,19,4,61,192,0,128,1,196,63,192,47,0,0,176,209,145,0,128,9,0,128,9,47,0,0,236,14,
  168,236,14,168,132,63,192,15,0,192,100,16,168,132,63,192,241,32,0,242,64,9,31,128,9,33,160,4,184,145,145,31,
  0,0,68,61,192,0,0,4,176,17,145,0,0,64,132,63,192,1,0,192,0,0,1,0,18,145,236,14,168,4,18,160,
  128,15,168,7,0,192,138,2,192,132,63,192,66,44,192,54,0,0,0,160,5,253,0,0,0,128,53,37,0,0,132,61,
  192,242,32,0,96,128,21,0,128,11,36,0,0,242,0,0,64,210,151,193,7,192,7,0,193,84,210,144,0,128,15,0,
  128,11,0,128,11,0,128,11,16,128,18,32,0,20,112,18,145,194,255,255,38,0,0,116,210,151,0,0,64,2,243,192,
  132,61,192,16,128,21,37,0,0,111,0,0,2,58,192,16,128,21,36,0,0,254,0,0,68,62,192,47,0,0,132,60,
  192,194,236,192,16,128,21,16,128,21,47,32,9,0,0,9,194,236,192,16,128,21,16,128,21,47,128,19,4,61,192,0,
  128,1,196,63,192,47,0,0,132,63,192,15,0,192,232,17,168,132,63,192,241,32,0,242,64,9,31,128,9,33,160,4,
  232,146,145,31,0,0,68,61,192,0,0,4,224,18,145,68,62,192,244,0,0,15,0,64,195,63,192,49,0,0,40,211,
  151,146,0,18,4,61,192,31,160,15,48,128,18,47,0,64,0,0,11,216,86,144,32,19,168,1,0,192,60,17,168,65,
  0,192,60,17,168,129,0,192,60,17,168,193,0,192,60,17,168,1,1,192,60,17,168,65,1,192,60,17,168,7,0,192,
  198,255,255,132,211,151,132,60,192,15,102,192,4,61,192,1,0,192,0,0,1,184,83,145,68,61,192,242,0,0,31,128,
  8,33,0,0,112,13,168,28,20,160,130,226,192,131,1,192,10,1,192,37,128,17,97,128,8,0,0,11,20,0,0,5,
  230,192,97,129,8,0,1,2,29,1,0,248,83,145,241,1,0,96,0,18,0,0,49,31,0,0,49,0,0,0,0,8,
  19,0,0,196,19,145,68,61,192,242,0,9,31,128,8,33,0,0,112,13,168,7,0,208,6,0,192,32,19,168,1,0,
  192,124,18,168,65,0,192,124,18,168,129,0,192,124,18,168,193,0,192,124,18,168,1,1,192,124,18,168,65,1,192,124,
  18,168,7,0,192,198,255,255,0,0,160,68,61,192,241,64,0,0,0,9,31,0,0,4,60,192,111,33,0,111,0,0,
  196,60,192,79,236,192,4,61,192,138,2,192,242,32,0,253,96,0,0,160,5,241,160,53,37,0,0,13,0,194,194,3,
  192,96,0,21,184,20,148,0,0,5,26,128,18,37,0,0,1,51,192,98,0,37,20,0,0,209,128,2,116,150,145,0,
  0,11,3,229,192,5,230,192,236,20,144,67,227,192,69,228,192,196,61,192,47,32,0,63,32,0,31,32,0,20,0,0,
  97,1,0,98,1,2,116,86,145,10,1,192,29,0,19,67,128,2,100,0,49,31,64,0,47,34,15,31,192,15,47,64,
  0,132,62,192,143,1,192,196,60,192,138,2,192,245,32,0,97,33,0,98,65,5,29,224,5,0,160,5,241,32,0,0,
  160,53,95,64,0,37,0,0,96,0,21,69,230,192,112,21,148,0,0,5,30,0,11,124,21,144,133,228,192,10,1,192,
  100,1,0,243,0,0,20,0,0,97,1,0,50,0,2,48,86,145,29,0,0,97,129,53,45,0,2,200,213,144,16,128,
  20,204,149,144,0,1,0,242,1,0,96,129,18,224,128,17,47,0,0,48,22,160,194,255,255,100,1,0,96,129,20,48,
  214,144,0,64,5,48,86,144,19,0,4,48,22,144,13,0,194,194,3,192,10,128,18,78,0,0,37,0,0,1,51,192,
  98,0,37,20,0,0,49,128,2,48,150,145,4,0,0,31,2,15,31,0,0,196,61,192,31,0,0,132,62,192,79,1,
  192,52,21,160,132,62,192,241,0,0,0,0,8,31,0,0,52,21,145,196,61,192,0,32,1,116,86,145,245,32,0,241,
  0,0,98,1,0,100,0,0,243,0,0,20,0,0,0,128,2,48,128,17,47,0,0,4,61,192,241,0,0,0,0,8,
  31,32,0,128,20,145,0,0,64,132,61,192,31,0,0,69,224,192,100,20,168,197,224,192,100,20,168,69,225,192,100,20,
  168,197,225,192,100,20,168,69,226,192,100,20,168,197,226,192,100,20,168,241,32,0,242,64,9,31,128,20,148,150,145,0,
  0,64,0,0,11,184,87,144,32,19,168,1,0,192,60,17,168,65,0,192,60,17,168,129,0,192,60,17,168,193,0,192,
  60,17,168,1,1,192,60,17,168,65,1,192,60,17,168,7,0,192,198,255,255,28,215,151,132,60,192,15,102,192,4,61,
  192,1,0,192,0,0,1,80,87,145,68,61,192,242,0,0,31,128,8,33,0,0,140,22,168,28,20,160,130,226,192,131,
  1,192,10,1,192,37,128,17,97,128,8,0,0,11,20,0,0,5,230,192,97,129,8,0,1,2,29,1,0,144,87,145,
  241,1,0,96,0,18,0,0,49,31,0,0,49,0,0,0,0,8,19,0,0,92,23,145,68,61,192,242,0,9,31,128,
  8,33,0,0,140,22,168,28,20,160,196,62,192,250,0,0,4,58,192,195,63,192,193,63,192,204,215,151,142,0,0,2,
  0,18,16,0,21,0,128,15,48,128,18,45,0,0,0,0,53,0,0,11,22,0,0,244,215,151,15,32,0,15,32,0,
  15,32,0,15,32,0,15,32,0,15,0,0,4,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,128,0,64,0,32,0,16,0,8,0,4,0,2,0,1,128,0,64,0,32,0,16,0,8,0,4,0,2,0,1,0,
  2,0,4,0,8,0,16,0,32,0,64,0,128,0,0,1,0,0,15,0,0,4,0,2,64,1,0,4,0,2,64,0,
  125,0,126,0,126,0,123,0,124,0,125,0,123,0,124,0,2,0,32,0,48,0,0,0,13,0,25,0,38,0,50,0,
  62,0,74,0,86,0,98,0,109,0,121,0,132,0,142,0,152,0,162,0,172,0,181,0,190,0,198,0,206,0,213,0,
  220,0,226,0,231,0,236,0,241,0,245,0,248,0,251,0,253,0,255,0,0,1,0,1,0,1,255,0,253,0,251,0,
  248,0,245,0,241,0,237,0,231,0,226,0,220,0,213,0,206,0,198,0,190,0,181,0,172,0,162,0,153,0,142,0,
  132,0,121,0,110,0,98,0,86,0,74,0,62,0,50,0,38,0,25,0,13,0,0,0,243,255,231,255,219,255,206,255,
  194,255,182,255,170,255,158,255,147,255,135,255,125,255,114,255,104,255,94,255,84,255,75,255,66,255,58,255,50,255,43,255,
  37,255,30,255,25,255,20,255,15,255,11,255,8,255,5,255,3,255,1,255,0,255,0,255,0,255,1,255,3,255,5,255,
  8,255,11,255,15,255,19,255,24,255,30,255,36,255,43,255,50,255,58,255,66,255,75,255,84,255,93,255,103,255,114,255,
  124,255,135,255,146,255,158,255,169,255,181,255,194,255,206,255,218,255,231,255,243,255,43,0,127,0,32,0,255,0,0,255,
  190,255,0,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,193,255,1,0,2,0,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,255,3,0,4,0,5,0,71,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,255,6,0,7,0,8,0,
  9,0,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  208,255,10,0,11,0,12,0,13,0,14,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,215,255,15,0,16,0,17,0,18,0,19,0,20,0,83,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,21,0,22,0,23,0,24,0,25,0,26,0,27,0,
  89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,255,28,0,29,0,30,0,
  31,0,32,0,33,0,34,0,35,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  242,255,36,0,37,0,38,0,39,0,40,0,41,0,42,0,43,0,44,0,104,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,253,255,45,0,46,0,47,0,48,0,49,0,50,0,51,0,52,0,53,0,54,0,113,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,255,55,0,56,0,57,0,58,0,59,0,60,0,61,0,
  62,0,63,0,64,0,65,0,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,0,0,1,0,2,0,
  3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,
  226,255,12,0,13,0,14,0,15,0,16,0,17,0,18,0,19,0,20,0,21,0,22,0,23,0,24,0,80,0,0,0,
  0,0,0,0,0,0,0,0,241,255,25,0,26,0,27,0,28,0,29,0,30,0,31,0,32,0,33,0,34,0,35,0,
  36,0,37,0,38,0,93,0,0,0,0,0,0,0,0,0,203,255,39,0,40,0,41,0,42,0,43,0,44,0,45,0,
  46,0,47,0,48,0,49,0,50,0,51,0,52,0,53,0,107,0,0,0,0,0,0,0,220,255,0,0,1,0,2,0,
  3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,12,0,13,0,14,0,15,0,68,0,0,0,0,0,
  238,255,16,0,17,0,18,0,19,0,20,0,21,0,22,0,23,0,24,0,25,0,26,0,27,0,28,0,29,0,30,0,
  31,0,32,0,84,0,0,0,238,255,33,0,34,0,35,0,36,0,37,0,38,0,39,0,40,0,41,0,42,0,43,0,
  44,0,45,0,46,0,47,0,48,0,49,0,50,0,101,0,190,255,0,0,172,254,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,193,255,1,0,2,0,173,254,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  197,255,3,0,4,0,5,0,175,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,202,255,6,0,7,0,8,0,9,0,178,254,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,255,10,0,11,0,12,0,13,0,14,0,182,254,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,255,15,0,16,0,17,0,
  18,0,19,0,20,0,187,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  223,255,21,0,22,0,23,0,24,0,25,0,26,0,27,0,193,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,232,255,28,0,29,0,30,0,31,0,32,0,33,0,34,0,35,0,200,254,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,242,255,36,0,37,0,38,0,39,0,40,0,41,0,42,0,
  43,0,44,0,208,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,255,45,0,46,0,47,0,
  48,0,49,0,50,0,51,0,52,0,53,0,54,0,217,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  199,255,55,0,56,0,57,0,58,0,59,0,60,0,61,0,62,0,63,0,64,0,65,0,227,254,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,212,255,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,
  11,0,172,254,0,0,0,0,0,0,0,0,0,0,0,0,226,255,12,0,13,0,14,0,15,0,16,0,17,0,18,0,
  19,0,20,0,21,0,22,0,23,0,24,0,184,254,0,0,0,0,0,0,0,0,0,0,241,255,25,0,26,0,27,0,
  28,0,29,0,30,0,31,0,32,0,33,0,34,0,35,0,36,0,37,0,38,0,197,254,0,0,0,0,0,0,0,0,
  203,255,39,0,40,0,41,0,42,0,43,0,44,0,45,0,46,0,47,0,48,0,49,0,50,0,51,0,52,0,53,0,
  211,254,0,0,0,0,0,0,220,255,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,
  11,0,12,0,13,0,14,0,15,0,172,254,0,0,0,0,238,255,16,0,17,0,18,0,19,0,20,0,21,0,22,0,
  23,0,24,0,25,0,26,0,27,0,28,0,29,0,30,0,31,0,32,0,188,254,0,0,238,255,33,0,34,0,35,0,
  36,0,37,0,38,0,39,0,40,0,41,0,42,0,43,0,44,0,45,0,46,0,47,0,48,0,49,0,50,0,205,254,
  84,1,24,2,16,1,176,0,204,0,176,0,136,0,176,0,68,0,176,0,0,0,176,0,254,0,7,255,2,0,255,0,
  248,0,7,0,254,0,238,0,255,7,0,2,239,0,0,248,0,7,238,0,255,255,255,255,255,255,0,0,0,0,1,0,
  1,0,1,0,1,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,1,0,1,0,1,0,1,0,0,0,
  0,0,255,255,255,255,0,0,255,255,1,0,0,0,1,0,1,0,0,0,0,0,255,255,255,255,255,255,255,255,0,0,
  255,255,1,0,0,0,1,0,1,0,0,0,0,0,255,255,255,255,255,255,0,0,0,0,0,0,68,0,136,0,204,0,
  16,1,84,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
};
const unsigned char DSP4[8192] = {
  198,255,255,4,192,151,145,0,0,0,0,11,140,64,144,0,0,11,84,64,144,0,0,11,60,64,144,0,0,11,52,64,
  144,164,16,145,20,1,160,4,1,145,144,19,160,0,0,11,76,64,144,44,27,145,56,11,160,4,1,145,244,25,160,0,
  0,11,116,64,144,0,0,11,108,64,144,156,26,145,8,1,160,4,1,145,12,25,160,0,0,11,132,64,144,4,1,145,
  144,16,160,4,1,145,248,6,160,0,0,11,204,64,144,0,0,11,180,64,144,0,0,11,172,64,144,72,26,145,168,1,
  160,4,1,145,252,11,160,0,0,11,196,64,144,4,1,145,108,16,160,4,1,145,108,1,160,0,0,11,236,64,144,0,
  0,11,228,64,144,16,27,145,220,6,160,4,1,145,196,25,160,0,0,11,252,64,144,4,1,145,172,16,160,0,0,145,
  100,1,160,0,0,160,70,0,192,12,193,151,0,0,160,6,0,192,1,0,192,28,193,151,138,0,0,3,0,224,206,255,
  223,44,193,151,141,0,0,18,0,37,0,0,11,0,128,53,0,128,11,0,128,18,80,1,144,48,128,17,38,0,0,84,
  193,151,22,0,0,92,193,151,0,0,160,12,6,168,180,1,160,132,4,192,1,0,224,31,0,0,116,5,168,1,0,192,
  128,193,151,138,0,21,112,68,148,3,192,255,206,63,192,4,0,192,36,5,168,68,0,192,36,5,168,52,2,160,132,4,
  192,1,0,224,31,0,0,116,5,168,1,0,192,188,193,151,138,0,21,112,68,148,3,192,255,206,63,192,4,0,192,36,
  5,168,68,0,192,84,5,168,52,2,160,1,0,192,232,193,151,138,0,21,104,68,148,132,0,192,241,14,0,242,0,0,
  4,0,192,0,14,5,0,142,7,31,14,0,47,0,0,196,0,192,241,14,0,242,0,0,68,0,192,0,14,5,0,142,
  7,31,14,0,47,0,0,3,192,255,206,63,192,132,0,192,36,5,168,196,0,192,36,5,168,4,44,192,80,194,151,159,
  56,0,242,0,0,38,0,0,45,140,20,0,138,37,104,194,151,38,0,0,241,26,13,31,16,0,47,142,4,0,128,12,
  47,216,20,132,194,151,253,48,13,0,128,37,0,128,12,47,200,4,47,170,20,241,84,0,31,28,0,246,0,0,253,12,
  0,0,128,37,176,194,151,38,0,0,241,0,0,47,6,36,192,194,151,52,68,148,52,68,145,19,0,0,241,0,0,32,
  0,20,52,68,148,52,68,145,47,48,0,0,128,4,248,130,148,32,0,21,52,68,148,52,68,145,22,54,0,252,194,151,
  242,72,0,32,128,17,20,195,148,60,6,168,68,20,192,31,90,0,53,0,20,27,0,0,96,67,145,31,28,0,250,10,
  0,241,32,0,242,64,53,31,160,39,47,10,0,250,68,0,241,32,0,242,64,53,31,160,39,47,88,0,241,0,0,0,
  0,9,31,28,0,40,3,145,3,224,255,14,0,193,68,32,192,2,255,255,246,128,21,47,22,0,120,195,151,241,80,0,
  0,28,5,242,0,20,22,128,8,47,6,0,144,195,151,250,10,0,241,32,0,242,64,53,31,160,39,47,14,0,241,0,
  0,48,0,20,192,3,148,6,224,255,0,4,0,216,3,160,0,0,20,212,67,148,6,224,192,0,4,0,216,3,160,246,
  4,0,216,195,151,250,68,0,241,32,0,242,64,53,31,160,39,47,130,20,241,0,0,0,0,8,31,70,0,104,3,145,
  241,30,0,0,0,11,0,52,5,31,10,0,241,30,0,0,0,11,0,26,5,31,78,0,1,0,224,31,14,0,31,34,
  0,6,0,224,228,1,160,68,24,192,241,4,0,0,0,11,0,0,5,31,68,0,241,42,0,0,0,11,0,0,5,31,
  12,0,6,0,192,92,196,151,6,0,224,228,1,160,0,0,8,116,68,148,0,0,160,0,0,8,204,68,148,68,28,192,
  128,196,151,138,0,0,136,196,151,129,0,0,29,0,5,31,12,0,241,0,0,0,0,37,31,10,0,241,0,0,0,0,
  37,31,0,0,196,28,192,241,0,0,184,196,151,128,0,21,31,14,20,31,0,0,228,1,160,0,0,8,204,68,148,4,
  28,192,216,196,151,138,0,0,224,196,151,129,0,0,29,0,5,31,12,0,241,0,0,0,0,37,31,10,0,241,0,0,
  0,0,37,31,0,0,132,28,192,241,0,0,16,197,151,128,0,21,31,14,20,31,0,0,228,1,160,36,197,151,129,0,
  0,18,0,15,48,0,18,48,128,18,64,133,148,0,128,17,0,128,15,0,0,5,31,14,0,0,128,7,47,14,64,84,
  197,151,129,0,0,0,0,5,31,14,0,100,197,151,130,0,0,0,128,7,47,14,64,6,0,192,4,0,192,124,197,151,
  143,14,0,132,197,151,143,12,0,159,6,0,144,197,151,143,48,0,152,197,151,143,18,0,160,197,151,143,76,0,168,197,
  151,143,42,0,176,197,151,143,14,0,184,197,151,143,12,0,159,10,0,145,0,0,200,197,151,128,0,21,31,24,20,212,
  197,151,143,196,13,220,197,151,143,48,21,0,0,12,31,36,20,236,197,151,143,14,0,244,197,151,143,46,0,252,197,151,
  143,14,0,4,198,151,143,78,64,6,0,192,132,4,192,20,198,151,193,7,224,144,0,18,31,32,0,1,248,192,144,0,
  18,31,32,0,1,0,223,128,0,18,31,0,64,132,8,192,31,32,0,63,70,0,3,1,192,6,0,192,80,198,151,138,
  0,0,88,198,151,14,0,192,69,23,192,146,0,0,96,128,18,241,160,4,45,0,0,146,0,37,96,1,18,0,0,17,
  30,0,0,96,128,18,241,160,4,45,0,0,130,0,37,96,1,18,0,0,17,30,0,0,96,128,18,241,192,4,45,64,
  0,0,0,37,96,1,18,0,0,17,22,0,0,188,198,151,49,0,0,0,0,8,19,0,0,76,6,145,132,8,192,241,
  32,0,243,0,64,2,0,192,67,72,200,1,30,192,36,0,8,63,128,9,232,6,145,0,0,160,2,0,192,3,4,196,
  1,30,192,36,0,8,63,128,9,4,7,145,0,0,160,46,128,11,136,135,144,104,135,148,0,128,9,208,135,148,0,128,
  9,236,135,148,0,128,9,8,136,148,0,128,9,36,136,148,0,128,9,64,136,148,0,128,9,92,136,148,0,128,9,120,
  136,148,0,128,9,148,136,148,65,0,192,0,0,75,3,128,192,36,0,0,241,0,0,0,0,15,48,0,20,164,73,148,
  0,0,15,31,128,9,131,128,192,208,135,148,0,128,9,236,135,148,0,128,9,8,136,148,0,128,9,36,136,148,0,128,
  9,64,136,148,0,128,9,92,136,148,0,128,9,120,136,148,0,128,9,148,136,148,65,0,192,0,0,75,36,0,0,241,
  0,0,48,0,20,120,73,148,26,0,15,120,73,148,223,128,9,36,0,0,241,0,0,48,0,20,96,73,148,26,0,15,
  96,73,148,223,128,9,36,0,0,241,0,0,48,0,20,72,73,148,26,0,15,72,73,148,223,128,9,36,0,0,241,0,
  0,48,0,20,48,73,148,26,0,15,48,73,148,223,128,9,36,0,0,241,0,0,48,0,20,24,73,148,26,0,15,24,
  73,148,223,128,9,36,0,0,241,0,0,48,0,20,0,73,148,26,0,15,0,73,148,223,128,9,36,0,0,241,0,0,
  48,0,20,232,72,148,26,0,15,232,72,148,223,128,9,36,0,0,1,0,0,0,0,11,188,8,144,3,128,192,241,0,
  0,48,0,20,131,128,192,208,72,148,31,0,77,241,0,0,48,0,20,26,0,15,208,72,144,223,0,64,0,128,8,164,
  137,148,36,0,0,241,0,0,48,0,21,31,0,0,0,128,8,164,137,148,36,0,0,241,0,0,48,0,21,31,0,0,
  0,128,8,164,137,148,36,0,0,241,0,0,48,0,21,31,0,0,0,128,8,164,137,148,36,0,0,241,0,0,48,0,
  21,31,0,0,0,128,8,164,137,148,36,0,0,241,0,0,48,0,21,31,0,0,0,128,8,164,137,148,36,0,0,241,
  0,0,48,0,21,31,0,0,0,128,8,164,137,148,36,0,0,241,0,0,48,0,21,31,0,0,1,128,8,164,137,148,
  0,0,11,164,9,144,131,0,192,36,0,0,241,0,0,48,0,21,31,0,0,65,0,192,0,0,75,65,0,192,0,0,
  75,46,128,11,0,138,144,224,137,148,0,128,9,44,138,148,0,128,9,72,138,148,0,128,9,100,138,148,0,128,9,128,
  138,148,65,0,192,0,0,75,3,64,192,36,0,0,241,0,0,0,0,15,48,0,20,48,75,148,0,0,15,31,128,9,
  67,64,192,44,138,148,0,128,9,72,138,148,0,128,9,100,138,148,0,128,9,128,138,148,0,128,9,65,0,192,0,0,
  75,36,0,0,241,0,0,48,0,20,4,75,148,26,0,15,4,75,148,223,128,9,36,0,0,241,0,0,48,0,20,236,
  74,148,26,0,15,236,74,148,223,128,9,36,0,0,241,0,0,48,0,20,212,74,148,26,0,15,212,74,148,223,128,9,
  36,0,0,1,0,0,0,0,11,168,10,144,3,64,192,241,0,0,48,0,20,67,64,192,188,74,148,31,0,77,241,0,
  0,48,0,20,26,0,15,188,74,144,223,0,64,0,128,8,48,139,148,36,0,0,241,0,0,48,0,21,31,0,0,0,
  128,8,48,139,148,36,0,0,241,0,0,48,0,21,31,0,0,0,128,8,48,139,148,36,0,0,241,0,0,48,0,21,
  31,0,0,1,128,8,48,139,148,0,0,11,48,11,144,131,0,192,36,0,0,241,0,0,48,0,21,31,0,0,65,0,
  192,0,0,75,65,0,192,0,0,75,6,0,192,4,30,192,64,203,151,143,32,0,72,203,151,143,88,0,80,203,151,143,
  0,0,241,6,0,92,203,151,143,2,0,100,203,151,143,34,0,108,203,151,143,2,0,116,203,151,143,0,0,68,30,192,
  128,203,151,145,0,0,0,28,5,19,0,4,152,11,148,63,0,0,0,6,0,143,64,0,160,203,151,129,0,0,26,0,
  18,248,75,148,124,75,145,1,0,192,184,203,151,128,0,20,192,203,151,141,0,0,0,26,37,0,26,5,31,32,20,212,
  203,151,141,0,5,0,26,37,0,26,5,31,34,20,232,203,151,143,64,0,168,13,168,124,11,160,0,0,160,6,0,192,
  4,30,192,4,204,151,143,32,0,12,204,151,143,88,0,20,204,151,143,0,0,241,6,0,32,204,151,143,2,0,40,204,
  151,143,34,0,48,204,151,143,2,0,56,204,151,143,0,0,68,30,192,68,204,151,129,0,0,0,28,5,19,0,4,92,
  12,148,63,0,0,16,6,20,96,204,151,138,0,21,192,76,148,64,76,145,1,0,192,116,204,151,128,0,20,124,204,151,
  143,64,0,132,204,151,141,0,0,0,26,37,0,26,5,31,32,20,152,204,151,141,0,5,0,26,37,0,26,5,31,34,
  20,172,204,151,143,64,0,168,13,168,1,0,192,64,12,160,0,128,18,0,0,12,0,64,145,0,0,12,232,76,144,0,
  0,12,224,76,144,4,13,160,0,13,145,0,13,160,0,0,12,248,76,144,0,13,145,0,13,160,0,13,145,0,13,160,
  0,0,160,3,224,223,8,205,151,130,0,0,0,128,11,48,128,18,42,128,20,28,205,151,129,0,0,36,205,151,143,0,
  20,29,128,5,0,128,37,47,192,20,56,205,151,129,0,0,64,205,151,143,0,20,29,128,4,0,128,36,80,205,151,138,
  0,0,88,205,151,144,128,21,38,0,0,100,205,151,45,128,20,22,154,37,0,154,5,47,160,20,241,0,0,124,205,151,
  128,0,21,29,0,0,0,154,37,0,154,5,47,162,20,148,205,151,143,64,0,168,13,168,1,0,192,64,12,160,1,0,
  192,172,205,151,143,32,21,136,78,145,0,64,5,31,2,0,184,15,168,206,3,192,4,50,192,241,10,0,19,0,4,220,
  77,145,116,14,148,0,0,21,228,77,148,49,2,0,0,0,4,248,13,148,0,0,21,116,78,148,68,50,192,241,10,0,
  19,0,4,12,78,145,116,14,148,0,0,21,60,78,148,241,74,0,242,32,0,0,32,0,47,32,0,31,14,0,129,59,
  192,31,14,0,112,15,168,116,78,144,68,38,192,49,2,0,0,72,4,80,14,148,0,0,21,116,78,148,68,50,192,242,
  0,0,20,7,168,116,78,144,4,50,192,241,0,0,36,16,168,68,50,192,216,15,168,6,0,192,120,206,151,6,0,192,
  68,46,192,168,13,160,68,46,192,1,0,192,144,206,151,143,32,21,108,79,145,0,64,5,31,2,0,184,15,168,206,1,
  192,4,50,192,241,10,0,19,0,4,192,78,145,88,15,148,0,0,21,200,78,148,49,2,0,0,0,4,220,14,148,0,
  0,21,88,79,148,68,50,192,241,10,0,19,0,4,240,78,145,88,15,148,0,0,21,32,79,148,241,74,0,242,32,0,
  0,32,0,47,32,0,31,14,0,129,59,192,31,14,0,148,15,168,88,79,144,68,38,192,49,2,0,0,72,4,52,15,
  148,0,0,21,88,79,148,68,50,192,242,0,0,172,9,168,88,79,144,4,50,192,241,0,0,12,16,168,68,50,192,216,
  15,168,6,0,192,92,207,151,6,0,192,68,46,192,140,14,160,0,0,64,242,0,0,20,7,168,144,79,144,132,50,192,
  241,0,0,36,16,168,196,50,192,216,15,168,0,0,64,242,0,0,172,9,168,180,79,144,132,50,192,241,0,0,12,16,
  168,196,50,192,216,15,168,0,0,64,241,0,0,188,207,151,128,12,21,31,76,0,241,0,0,204,207,151,144,12,21,31,
  0,84,193,63,192,19,64,2,30,0,15,242,0,0,48,128,18,16,128,17,70,0,192,244,207,151,38,46,0,252,207,151,
  246,0,13,4,208,151,0,0,64,3,64,192,14,0,192,48,0,18,56,80,145,78,85,213,56,16,160,3,64,192,142,170,
  234,48,0,18,56,80,145,206,255,255,196,59,192,1,0,0,242,64,2,244,128,12,0,0,1,31,128,12,100,144,144,132,
  59,192,241,160,13,47,64,9,31,0,64,196,59,192,47,0,64,4,60,192,2,0,192,47,32,0,116,48,150,132,59,192,
  1,60,192,31,160,13,47,0,0,0,0,160,4,60,192,246,32,0,152,208,151,148,48,150,0,0,160,12,6,168,184,16,
  160,132,4,192,1,0,224,31,0,0,6,0,192,4,0,192,192,208,151,143,14,0,200,208,151,143,12,0,159,6,0,212,
  208,151,143,48,0,220,208,151,143,18,0,228,208,151,143,76,0,236,208,151,143,42,0,244,208,151,143,14,0,252,208,151,
  143,12,0,159,10,0,145,0,0,12,209,151,128,0,21,31,24,20,24,209,151,143,196,13,32,209,151,143,48,21,0,0,
  12,31,36,20,1,0,192,52,209,151,138,0,21,128,83,148,3,192,255,206,63,192,4,28,192,76,209,151,129,0,0,84,
  209,151,141,0,0,0,0,37,31,0,0,68,28,192,104,209,151,129,0,0,112,209,151,141,0,0,0,0,37,31,0,0,
  4,44,192,132,209,151,159,56,0,242,6,0,38,0,0,241,26,13,31,16,0,47,142,4,0,128,12,47,216,20,168,209,
  151,253,48,13,0,128,37,0,128,12,47,200,4,47,170,20,241,84,0,31,28,0,242,12,0,38,0,0,241,0,0,47,
  6,20,216,209,151,76,83,148,76,83,145,19,0,0,241,0,0,32,0,20,76,83,148,76,83,145,47,48,0,0,128,4,
  16,146,148,32,0,21,76,83,148,76,83,145,22,54,0,20,210,151,242,72,0,32,128,17,44,210,148,60,6,168,68,20,
  192,31,90,0,53,0,20,27,0,0,120,82,145,31,28,0,250,10,0,241,32,0,242,64,53,31,160,39,47,10,0,250,
  68,0,241,32,0,242,64,53,31,160,39,47,88,0,241,0,0,0,0,9,31,28,0,64,18,145,3,224,255,14,0,193,
  68,32,192,2,255,255,246,128,21,47,22,0,144,210,151,241,80,0,0,28,5,242,0,20,22,128,8,47,6,0,168,210,
  151,250,10,0,241,32,0,242,64,53,31,160,39,47,14,0,241,0,0,48,0,20,216,18,148,6,224,255,0,4,0,240,
  18,160,0,0,20,236,82,148,6,224,192,0,4,0,240,18,160,246,4,0,240,210,151,250,68,0,241,32,0,242,64,53,
  31,160,39,47,130,20,241,0,0,0,0,8,31,70,0,128,18,145,241,30,0,0,0,11,0,52,5,31,10,0,241,30,
  0,0,0,11,0,26,5,31,78,0,1,0,224,31,14,0,31,34,0,6,0,224,48,17,160,68,24,192,241,4,0,0,
  0,11,0,0,5,31,68,0,241,42,0,0,0,11,0,0,5,31,12,0,6,0,192,116,211,151,6,0,224,48,17,160,
  0,0,8,0,0,148,136,211,151,0,0,160,6,0,192,4,28,192,76,21,168,4,32,192,76,21,168,4,48,192,76,21,
  168,4,52,192,76,21,168,4,56,192,76,21,168,4,44,192,76,21,168,4,60,192,76,21,168,4,40,192,76,21,168,2,
  0,192,68,2,192,47,0,0,96,21,168,132,21,168,4,1,192,250,0,0,4,8,192,228,21,168,228,21,168,228,21,168,
  204,21,168,28,22,168,4,4,192,80,22,168,132,22,168,132,21,168,60,85,148,68,16,192,241,32,0,0,0,4,12,85,
  145,4,8,192,228,21,168,228,21,168,228,21,168,204,21,168,4,4,192,1,0,192,0,34,5,112,20,148,16,32,20,0,
  0,5,112,20,145,4,44,192,241,54,0,2,255,255,32,32,18,31,0,0,68,4,192,1,0,192,0,34,5,164,84,148,
  164,84,145,16,32,20,0,0,5,164,20,145,68,44,192,241,54,0,2,255,255,32,32,18,31,0,0,132,4,192,156,22,
  168,196,4,192,192,22,168,68,2,192,0,128,5,216,148,145,4,12,192,0,128,5,248,212,148,248,212,145,68,2,192,47,
  0,0,4,4,192,156,22,168,68,4,192,192,22,168,132,60,192,241,64,0,31,64,0,31,0,0,4,12,192,184,23,168,
  132,12,192,228,22,168,48,21,160,4,8,192,228,21,168,228,21,168,228,21,168,204,21,168,4,12,192,228,22,168,132,12,
  192,228,22,168,28,22,168,6,0,224,20,20,160,68,2,192,246,0,0,68,213,151,0,0,160,2,1,192,80,213,151,143,
  160,8,80,149,145,0,0,64,68,1,192,100,213,151,143,32,0,108,213,151,143,32,0,116,213,151,143,32,0,124,213,151,
  143,0,64,4,1,192,1,0,192,140,213,151,143,20,21,200,85,148,26,0,0,2,0,192,160,213,151,128,128,20,47,160,
  20,172,213,151,143,32,0,180,213,151,128,128,20,47,160,20,192,213,151,143,32,64,0,0,64,67,28,0,244,0,0,1,
  0,192,216,213,151,157,0,5,248,21,160,67,28,0,244,0,0,1,0,192,240,213,151,141,0,5,52,0,37,31,6,4,
  0,0,12,31,10,20,67,18,0,244,0,0,52,0,5,31,14,4,31,34,64,4,8,192,241,8,0,31,6,20,31,46,
  0,241,8,0,31,6,20,31,46,0,241,8,0,31,6,20,31,46,0,241,8,0,31,6,20,31,0,64,1,0,192,31,
  32,0,31,68,0,196,24,168,19,0,0,196,24,168,0,0,15,48,0,17,22,0,0,116,214,151,6,0,224,28,22,168,
  0,0,64,4,0,192,1,0,192,31,32,0,31,32,0,31,32,0,31,0,64,1,0,192,0,14,5,188,22,148,241,16,
  0,0,12,5,18,0,4,188,86,148,47,128,84,32,128,84,1,0,192,0,14,5,224,86,148,241,16,0,0,18,5,18,
  0,4,224,22,148,47,128,84,32,128,84,1,0,192,0,0,4,176,87,148,176,87,145,31,32,0,31,78,0,19,22,5,
  0,22,4,56,87,145,50,0,0,30,142,20,176,215,148,176,215,145,35,0,0,196,24,168,196,24,168,1,0,0,0,64,
  8,30,64,0,28,23,145,0,14,0,241,22,0,31,10,0,0,18,4,88,23,148,48,0,21,176,87,148,176,87,145,19,
  0,0,54,0,0,140,24,168,196,24,168,30,80,20,104,215,151,246,0,5,2,1,192,32,0,20,31,32,0,31,16,0,
  168,24,168,196,24,168,0,0,15,0,0,17,144,215,151,22,0,0,49,64,0,0,64,8,19,0,0,92,23,145,168,215,
  151,0,0,64,6,0,192,168,23,160,1,0,192,0,0,4,240,22,148,132,88,145,243,14,0,241,22,0,0,22,4,236,
  87,148,50,0,0,16,128,20,132,216,148,132,216,145,35,0,0,241,28,0,48,0,20,0,18,4,0,0,8,44,24,148,
  30,0,0,48,0,21,132,88,148,132,88,145,19,0,0,196,24,168,196,24,168,1,0,0,0,64,9,30,64,0,20,24,
  145,54,0,0,196,24,168,30,80,20,56,216,151,129,1,192,0,0,5,22,0,0,130,0,192,32,0,20,31,32,0,31,
  16,0,196,24,168,0,0,15,0,0,17,100,216,151,22,0,0,49,64,0,0,64,8,19,0,0,48,24,145,124,216,151,
  0,0,64,6,0,192,124,24,160,0,16,0,241,22,0,0,16,4,164,24,144,1,0,192,31,22,64,0,22,64,0,16,
  0,241,22,0,0,14,4,192,24,144,193,63,192,31,8,64,0,8,64,245,4,0,251,8,0,241,6,0,242,6,53,31,
  134,39,47,16,0,0,146,5,33,158,4,248,152,148,0,0,4,4,89,148,0,2,5,31,52,64,0,30,0,241,28,0,
  31,52,64,241,2,0,31,52,64,6,0,192,10,96,192,132,0,192,24,217,151,143,0,0,4,0,192,116,25,168,116,25,
  168,250,66,0,96,25,168,0,38,0,56,217,151,96,25,168,0,34,0,68,217,151,96,25,168,0,46,0,80,217,151,96,
  25,168,88,217,151,0,0,160,241,64,0,242,0,4,29,0,0,0,128,37,38,0,64,1,0,252,31,0,0,124,217,151,
  130,0,0,33,128,2,45,128,20,0,130,37,47,2,14,18,0,2,29,0,20,0,4,37,31,132,14,33,128,2,45,128,
  20,0,134,37,47,6,14,18,0,2,29,0,20,0,8,37,31,168,78,36,26,168,172,9,168,232,89,144,4,50,192,241,
  0,0,12,16,168,68,50,192,216,15,168,0,0,160,6,0,192,236,217,151,0,0,160,36,26,168,20,7,168,24,90,144,
  4,50,192,241,0,0,36,16,168,68,50,192,216,15,168,0,0,160,6,0,192,28,218,151,0,0,160,6,0,192,4,50,
  192,44,218,151,143,32,0,2,0,192,56,218,151,143,142,21,64,218,151,159,14,64,6,0,192,138,170,192,5,0,196,2,
  0,192,4,0,192,3,252,255,206,3,192,128,26,168,128,26,168,128,26,168,128,26,168,38,0,0,120,218,151,0,0,160,
  128,218,151,141,0,0,97,128,14,48,128,18,0,0,37,0,0,18,16,128,81,66,85,213,193,63,192,20,128,10,47,0,
  8,164,26,148,193,63,192,180,218,151,20,128,10,46,128,3,224,154,145,2,0,8,184,26,148,0,128,10,160,218,148,6,
  0,192,216,218,151,0,0,160,1,0,196,0,0,18,64,0,17,14,64,196,19,128,11,0,0,21,240,154,144,1,0,248,
  48,0,17,22,0,0,8,219,151,0,0,160,2,0,193,1,0,192,21,0,9,102,128,8,32,219,151,24,155,145,0,0,
  160,6,0,193,48,219,151,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,64,0,32,85,21,0,16,204,12,170,10,36,9,0,8,28,7,102,6,209,5,85,5,236,4,146,4,68,4,
  0,4,195,3,142,3,94,3,51,3,12,3,232,2,200,2,170,2,143,2,118,2,94,2,73,2,52,2,34,2,16,2,
  0,2,240,1,225,1,212,1,199,1,186,1,175,1,164,1,153,1,143,1,134,1,125,1,116,1,108,1,100,1,92,1,
  85,1,78,1,71,1,65,1,59,1,53,1,47,1,41,1,36,1,31,1,26,1,21,1,17,1,12,1,8,1,4,1,
  0,1,252,0,248,0,244,0,240,0,237,0,234,0,230,0,227,0,224,0,221,0,218,0,215,0,212,0,210,0,207,0,
  204,0,202,0,199,0,197,0,195,0,192,0,190,0,188,0,186,0,184,0,182,0,0,124,224,3,31,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char SGB1[256] = {
  49,254,255,62,48,224,0,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,
  119,62,252,224,71,33,95,192,14,8,175,50,13,32,252,17,79,1,62,251,14,6,245,6,0,26,27,50,128,71,13,32,
  248,50,241,50,14,14,214,2,254,239,32,234,17,4,1,33,16,128,26,205,211,0,205,212,0,19,123,254,52,32,243,17,
  230,0,6,8,26,19,34,35,5,32,249,62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,
  62,145,224,64,33,0,192,14,0,62,0,226,62,48,226,6,16,30,8,42,87,203,66,62,16,32,2,62,32,226,62,48,
  226,203,26,29,32,239,5,32,232,62,32,226,62,48,226,205,194,0,125,254,96,32,210,14,19,62,193,226,12,62,7,226,
  24,58,22,4,240,68,254,144,32,250,30,0,29,32,253,21,32,242,201,79,6,4,197,203,17,23,193,203,17,23,5,32,
  245,34,35,34,35,201,60,66,185,165,185,165,66,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,1,224,80,
};
const unsigned char SGB2[256] = {
  49,254,255,62,48,224,0,175,33,255,159,50,203,124,32,251,33,38,255,14,17,62,128,50,226,12,62,243,226,50,62,119,
  119,62,252,224,71,33,95,192,14,8,175,50,13,32,252,17,79,1,62,251,14,6,245,6,0,26,27,50,128,71,13,32,
  248,50,241,50,14,14,214,2,254,239,32,234,17,4,1,33,16,128,26,205,211,0,205,212,0,19,123,254,52,32,243,17,
  230,0,6,8,26,19,34,35,5,32,249,62,25,234,16,153,33,47,153,14,12,61,40,8,50,13,32,249,46,15,24,243,
  62,145,224,64,33,0,192,14,0,62,0,226,62,48,226,6,16,30,8,42,87,203,66,62,16,32,2,62,32,226,62,48,
  226,203,26,29,32,239,5,32,232,62,32,226,62,48,226,205,194,0,125,254,96,32,210,14,19,62,193,226,12,62,7,226,
  24,58,22,4,240,68,254,144,32,250,30,0,29,32,253,21,32,242,201,79,6,4,197,203,17,23,193,203,17,23,5,32,
  245,34,35,34,35,201,60,66,185,165,185,165,66,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,255,224,80,
};
const unsigned char ST010[53248] = {
  54,0,0,4,192,151,4,4,192,241,0,0,0,0,2,12,0,148,0,0,11,60,64,144,0,0,11,80,64,144,0,0,
  11,56,69,144,0,0,11,228,68,144,104,0,160,0,0,11,92,0,144,0,0,11,116,4,144,120,0,160,0,0,11,212,
  5,144,124,1,160,0,0,11,204,6,144,168,1,160,4,4,192,1,0,192,31,0,0,8,0,160,4,0,192,241,0,0,
  0,0,15,206,63,192,0,0,18,31,32,0,192,4,168,31,32,0,47,0,0,132,0,192,254,0,0,194,73,192,197,43,
  192,3,44,192,11,1,0,16,0,19,36,0,37,31,128,8,49,0,0,11,1,8,19,0,0,180,0,145,68,0,192,254,
  0,0,194,117,192,197,43,192,3,44,192,11,1,0,16,0,19,36,0,37,31,128,8,49,0,0,11,1,8,19,0,0,
  232,0,145,68,0,192,241,0,0,0,0,10,0,0,9,30,0,0,194,161,192,197,43,192,3,44,192,11,1,0,16,0,
  19,36,0,37,31,128,8,49,0,0,11,1,8,19,0,0,40,1,145,132,0,192,254,0,0,194,205,192,197,43,192,3,
  44,192,11,1,0,16,0,19,36,0,37,31,128,8,49,0,0,11,1,8,19,0,0,92,1,145,104,0,160,4,0,192,
  253,32,0,250,0,0,4,2,192,16,0,19,0,0,53,31,32,0,16,0,19,0,0,37,31,0,0,104,0,160,4,24,
  192,241,0,0,196,24,192,0,0,4,4,26,192,31,0,0,68,24,192,242,0,0,68,25,192,0,128,4,68,26,192,47,
  0,0,4,0,192,31,32,0,47,0,0,212,6,168,132,25,192,0,0,4,196,25,192,31,0,0,3,192,255,48,0,18,
  36,66,145,16,2,148,3,96,255,20,2,160,3,160,192,132,25,192,241,0,0,48,0,21,31,0,0,196,25,192,241,0,
  0,16,0,18,60,2,148,0,0,10,0,0,9,0,0,11,0,0,11,0,0,11,0,0,11,30,0,0,3,64,192,48,
  0,20,120,66,144,132,26,192,241,0,0,0,0,20,112,2,144,1,0,192,31,0,0,172,2,160,132,26,192,241,0,0,
  196,26,192,0,0,5,144,2,144,193,255,255,19,0,0,4,27,192,0,0,4,164,66,144,243,0,0,132,26,192,63,0,
  0,132,25,192,241,0,0,0,0,15,195,63,192,48,0,18,192,4,168,0,0,11,0,0,11,0,0,11,0,0,11,0,
  0,11,0,128,11,0,128,11,0,128,11,0,128,11,0,128,11,46,0,0,26,0,0,132,26,192,241,0,0,0,0,15,
  195,63,192,48,0,18,29,0,0,16,0,19,0,0,53,32,128,19,0,128,37,4,0,192,31,32,0,47,0,0,10,0,
  0,16,0,19,0,0,53,32,128,19,0,128,37,132,0,192,31,32,0,47,0,0,132,24,192,241,32,0,242,0,0,4,
  0,192,0,32,4,0,128,6,206,255,199,0,128,18,132,24,192,31,32,0,47,0,0,4,25,192,241,32,0,242,0,0,
  132,0,192,0,32,4,0,128,6,206,255,199,0,128,18,4,25,192,31,32,0,47,0,0,68,27,192,241,0,0,16,0,
  18,188,3,148,3,2,192,14,32,192,196,3,160,3,32,192,14,2,192,4,26,192,241,0,0,16,0,18,220,3,148,0,
  0,10,0,0,9,48,32,20,112,4,144,241,0,0,16,0,18,248,3,148,0,0,10,0,0,9,0,32,20,112,4,144,
  196,27,192,241,0,0,4,24,192,31,0,0,4,28,192,241,0,0,16,0,18,64,4,148,195,255,195,48,0,18,68,24,
  192,31,0,0,193,255,255,68,27,192,31,0,0,92,4,160,195,255,195,48,0,18,68,24,192,31,0,0,1,0,192,68,
  27,192,31,0,0,132,27,192,241,0,0,3,2,192,48,0,17,31,0,0,104,0,160,132,0,192,250,64,0,253,64,0,
  16,0,19,0,0,53,32,128,19,253,128,37,19,0,0,46,0,0,16,0,19,0,0,53,32,128,19,0,128,37,4,2,
  192,31,32,0,47,32,0,63,32,0,15,0,0,104,0,160,18,0,0,3,44,192,48,0,21,21,0,0,97,0,0,3,
  60,192,48,128,21,37,0,0,98,0,64,132,0,192,241,0,0,0,0,15,206,63,192,0,0,18,192,4,168,68,0,192,
  26,0,0,253,0,0,19,0,19,42,0,37,46,128,19,0,192,37,10,0,0,253,0,0,58,0,37,0,128,36,4,2,
  192,31,32,0,47,0,0,104,0,160,4,0,192,241,0,0,0,0,2,80,5,148,0,0,10,0,0,9,31,32,0,241,
  0,0,0,0,2,104,5,148,0,0,10,0,0,9,31,64,0,0,0,4,132,69,144,243,32,0,254,64,0,15,32,0,
  63,0,0,1,0,192,2,0,192,4,0,192,10,94,207,253,0,0,0,128,53,0,32,37,138,93,198,253,0,0,0,128,
  53,0,0,39,0,128,12,0,0,12,14,0,224,3,0,192,0,128,21,48,0,23,4,2,192,31,32,0,104,0,160,132,
  4,192,242,0,0,241,0,0,0,128,8,14,8,192,0,128,21,37,0,0,4,0,192,31,0,0,142,0,192,0,0,20,
  104,64,144,241,0,0,14,4,192,0,0,20,104,0,144,3,8,192,2,16,192,52,0,0,241,32,0,44,38,150,0,2,
  0,254,64,0,56,102,150,0,2,0,0,0,20,148,6,144,254,32,0,76,38,150,0,2,0,241,64,0,88,102,150,0,
  2,0,31,32,0,100,38,150,0,2,0,15,0,0,36,0,0,254,32,0,120,38,150,0,2,0,241,64,0,132,102,150,
  0,2,0,31,32,0,144,38,150,0,2,0,15,0,0,49,128,9,0,0,9,19,0,0,80,0,20,28,70,144,81,0,
  0,0,0,8,21,0,0,4,0,192,241,0,0,0,0,8,31,0,0,20,6,145,104,0,160,212,6,168,104,0,160,68,
  0,192,243,0,0,196,0,192,63,0,0,4,0,192,1,0,224,0,32,2,19,0,3,14,0,224,0,0,18,0,0,11,
  14,0,208,0,0,18,48,32,17,31,96,0,241,0,0,0,0,2,36,7,148,0,0,10,0,0,9,31,32,0,241,0,
  0,0,0,2,60,7,148,0,0,10,0,0,9,31,96,0,241,32,0,0,96,4,128,71,144,241,32,0,242,96,0,3,
  8,192,30,0,0,48,0,20,1,0,0,180,71,144,0,0,11,0,128,11,88,135,145,88,135,144,66,0,192,88,7,160,
  241,32,0,242,96,0,3,8,192,46,0,0,48,128,20,2,0,0,180,199,144,0,128,11,0,0,11,140,7,145,140,7,
  144,65,0,192,140,7,160,31,32,0,47,96,0,0,0,2,240,7,145,132,0,192,1,0,208,0,0,2,20,72,145,14,
  0,224,196,0,192,241,0,0,0,0,19,0,0,18,4,2,192,31,0,64,132,0,192,1,0,208,0,0,2,20,72,145,
  4,0,192,243,32,0,254,64,0,15,32,0,63,0,0,4,0,192,241,0,0,0,0,14,0,0,12,14,248,255,0,0,
  18,14,124,192,0,32,21,0,0,5,21,0,0,97,32,0,0,0,1,14,0,224,0,0,19,4,2,192,31,0,64,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  128,3,37,3,218,2,156,2,104,2,59,2,21,2,243,1,213,1,187,1,163,1,142,1,123,1,106,1,90,1,75,1,
  62,1,50,1,38,1,28,1,18,1,9,1,0,1,248,0,240,0,233,0,227,0,220,0,214,0,209,0,203,0,198,0,
  193,0,189,0,184,0,180,0,176,0,172,0,168,0,165,0,162,0,158,0,155,0,152,0,149,0,147,0,144,0,141,0,
  139,0,136,0,134,0,132,0,130,0,128,0,126,0,124,0,122,0,120,0,118,0,116,0,115,0,113,0,111,0,110,0,
  108,0,107,0,105,0,104,0,103,0,101,0,100,0,99,0,98,0,96,0,95,0,94,0,93,0,92,0,91,0,90,0,
  89,0,88,0,87,0,86,0,85,0,84,0,83,0,82,0,81,0,81,0,80,0,79,0,78,0,77,0,77,0,76,0,
  75,0,75,0,74,0,73,0,72,0,72,0,71,0,71,0,70,0,69,0,69,0,68,0,68,0,67,0,66,0,66,0,
  65,0,65,0,64,0,64,0,63,0,63,0,62,0,62,0,61,0,61,0,60,0,60,0,59,0,59,0,58,0,58,0,
  58,0,57,0,57,0,56,0,56,0,56,0,55,0,55,0,54,0,54,0,54,0,53,0,53,0,53,0,52,0,52,0,
  52,0,51,0,51,0,51,0,50,0,50,0,50,0,49,0,49,0,49,0,48,0,48,0,48,0,48,0,47,0,47,0,
  47,0,46,0,46,0,46,0,46,0,45,0,45,0,45,0,45,0,44,0,44,0,44,0,44,0,43,0,43,0,43,0,
  0,0,36,3,72,6,106,9,140,12,171,15,200,18,226,21,249,24,11,28,26,31,35,34,40,37,38,40,31,43,17,46,
  251,48,223,51,186,54,140,57,86,60,23,63,206,65,122,68,28,71,180,73,63,76,191,78,51,81,155,83,245,85,66,88,
  130,90,179,92,215,94,235,96,241,98,232,100,207,102,166,104,109,106,35,108,201,109,94,111,226,112,84,114,181,115,4,117,
  65,118,107,119,132,120,137,121,124,122,92,123,41,124,227,124,137,125,29,126,156,126,9,127,97,127,166,127,216,127,245,127,
  255,127,245,127,216,127,166,127,97,127,9,127,156,126,29,126,137,125,227,124,41,124,92,123,124,122,137,121,132,120,107,119,
  65,118,4,117,181,115,84,114,226,112,94,111,201,109,35,108,109,106,166,104,207,102,232,100,241,98,235,96,215,94,179,92,
  130,90,66,88,245,85,155,83,51,81,191,78,63,76,180,73,28,71,122,68,206,65,23,63,86,60,140,57,186,54,223,51,
  251,48,17,46,31,43,38,40,40,37,35,34,26,31,11,28,248,24,226,21,200,18,171,15,140,12,106,9,72,6,36,3,
  0,0,220,252,184,249,149,246,116,243,85,240,56,237,30,234,7,231,245,227,230,224,221,221,216,218,218,215,225,212,239,209,
  5,207,33,204,70,201,115,198,170,195,233,192,50,190,134,187,228,184,76,182,193,179,65,177,205,174,101,172,11,170,190,167,
  126,165,77,163,41,161,20,159,15,157,24,155,49,153,90,151,147,149,221,147,55,146,162,144,30,143,172,141,75,140,252,138,
  191,137,149,136,124,135,119,134,132,133,164,132,215,131,29,131,119,130,227,129,100,129,247,128,159,128,90,128,40,128,11,128,
  1,128,11,128,40,128,90,128,159,128,247,128,100,129,227,129,119,130,29,131,215,131,164,132,132,133,119,134,125,135,149,136,
  191,137,252,138,75,140,172,141,30,143,162,144,55,146,221,147,147,149,90,151,49,153,24,155,15,157,21,159,41,161,77,163,
  126,165,190,167,11,170,102,172,205,174,65,177,193,179,77,182,228,184,134,187,51,190,233,192,170,195,116,198,71,201,34,204,
  5,207,240,209,225,212,218,215,217,218,221,221,231,224,245,227,8,231,30,234,56,237,85,240,117,243,150,246,185,249,220,252,
  0,0,36,3,72,6,106,9,140,12,171,15,200,18,226,21,249,24,11,28,26,31,35,34,40,37,38,40,31,43,17,46,
  251,48,223,51,186,54,140,57,86,60,23,63,206,65,122,68,28,71,180,73,63,76,191,78,51,81,155,83,245,85,66,88,
  130,90,179,92,215,94,235,96,241,98,232,100,207,102,166,104,109,106,35,108,201,109,94,111,226,112,84,114,181,115,4,117,
  65,118,107,119,132,120,137,121,124,122,92,123,41,124,227,124,137,125,29,126,156,126,9,127,97,127,166,127,216,127,245,127,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,64,0,32,0,19,0,13,0,10,0,8,0,7,0,6,0,5,0,5,0,4,0,4,0,3,0,3,0,3,0,3,
  0,3,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,1,0,1,0,1,
  0,64,0,45,0,32,0,24,0,19,0,16,0,13,0,11,0,10,0,9,0,8,0,7,0,7,0,6,0,6,0,5,
  0,5,0,5,0,5,0,4,0,4,0,4,0,4,0,4,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,
  0,64,0,51,0,40,0,32,0,26,0,22,0,19,0,16,0,15,0,13,0,12,0,11,0,10,0,9,0,9,0,8,
  0,8,0,7,0,7,0,6,0,6,0,6,0,6,0,5,0,5,0,5,0,5,0,5,0,4,0,4,0,4,0,4,
  0,64,0,54,0,45,0,38,0,32,0,27,0,24,0,21,0,19,0,17,0,16,0,14,0,13,0,12,0,11,0,11,
  0,10,0,9,0,9,0,8,0,8,0,8,0,7,0,7,0,7,0,6,0,6,0,6,0,6,0,6,0,5,0,5,
  0,64,0,56,0,48,0,42,0,37,0,32,0,28,0,25,0,23,0,21,0,19,0,17,0,16,0,15,0,14,0,13,
  0,12,0,12,0,11,0,10,0,10,0,10,0,9,0,9,0,8,0,8,0,8,0,7,0,7,0,7,0,7,0,7,
  0,64,0,57,0,51,0,45,0,40,0,36,0,32,0,29,0,26,0,24,0,22,0,20,0,19,0,18,0,16,0,16,
  0,15,0,14,0,13,0,12,0,12,0,11,0,11,0,10,0,10,0,10,0,9,0,9,0,9,0,8,0,8,0,8,
  0,64,0,58,0,53,0,48,0,43,0,39,0,35,0,32,0,29,0,27,0,25,0,23,0,22,0,20,0,19,0,18,
  0,17,0,16,0,15,0,14,0,14,0,13,0,13,0,12,0,12,0,11,0,11,0,10,0,10,0,10,0,9,0,9,
  0,64,0,59,0,54,0,49,0,45,0,41,0,38,0,35,0,32,0,30,0,27,0,26,0,24,0,22,0,21,0,20,
  0,19,0,18,0,17,0,16,0,16,0,15,0,14,0,14,0,13,0,13,0,12,0,12,0,11,0,11,0,11,0,10,
  0,64,0,59,0,55,0,51,0,47,0,43,0,40,0,37,0,34,0,32,0,30,0,28,0,26,0,25,0,23,0,22,
  0,21,0,20,0,19,0,18,0,17,0,16,0,16,0,15,0,15,0,14,0,14,0,13,0,13,0,12,0,12,0,12,
  0,64,0,60,0,56,0,52,0,48,0,45,0,42,0,39,0,37,0,32,0,32,0,30,0,28,0,27,0,25,0,24,
  0,23,0,22,0,21,0,20,0,19,0,18,0,17,0,17,0,16,0,16,0,15,0,14,0,14,0,14,0,13,0,13,
  0,64,0,60,0,57,0,53,0,50,0,47,0,44,0,41,0,38,0,36,0,34,0,32,0,30,0,29,0,27,0,26,
  0,25,0,23,0,22,0,21,0,20,0,20,0,19,0,18,0,18,0,17,0,16,0,16,0,15,0,15,0,14,0,14,
  0,64,0,61,0,57,0,54,0,51,0,48,0,45,0,42,0,40,0,38,0,36,0,34,0,32,0,30,0,29,0,27,
  0,26,0,25,0,24,0,23,0,22,0,21,0,20,0,20,0,19,0,18,0,18,0,17,0,16,0,16,0,16,0,15,
  0,64,0,61,0,58,0,55,0,52,0,49,0,46,0,44,0,42,0,39,0,37,0,35,0,34,0,32,0,30,0,29,
  0,28,0,27,0,25,0,24,0,23,0,23,0,22,0,21,0,20,0,20,0,19,0,18,0,18,0,17,0,17,0,16,
  0,64,0,61,0,58,0,55,0,53,0,50,0,48,0,45,0,43,0,41,0,39,0,37,0,35,0,34,0,32,0,31,
  0,29,0,28,0,27,0,26,0,25,0,24,0,23,0,22,0,22,0,21,0,20,0,19,0,19,0,18,0,18,0,17,
  0,64,0,61,0,59,0,56,0,53,0,51,0,48,0,46,0,44,0,42,0,40,0,38,0,37,0,35,0,33,0,32,
  0,31,0,29,0,28,0,27,0,26,0,25,0,24,0,24,0,23,0,22,0,21,0,21,0,20,0,19,0,19,0,18,
  0,64,0,61,0,59,0,56,0,54,0,52,0,49,0,47,0,45,0,43,0,41,0,39,0,38,0,36,0,35,0,33,
  0,32,0,31,0,30,0,29,0,27,0,27,0,26,0,25,0,24,0,23,0,22,0,22,0,21,0,21,0,20,0,19,
  0,64,0,62,0,59,0,57,0,55,0,52,0,50,0,48,0,46,0,44,0,42,0,41,0,39,0,37,0,36,0,35,
  0,33,0,32,0,31,0,30,0,29,0,28,0,27,0,26,0,25,0,24,0,24,0,23,0,22,0,22,0,21,0,20,
  0,64,0,62,0,59,0,57,0,55,0,53,0,51,0,49,0,47,0,45,0,43,0,42,0,40,0,39,0,37,0,36,
  0,34,0,33,0,32,0,31,0,30,0,29,0,28,0,27,0,26,0,25,0,25,0,24,0,23,0,23,0,22,0,21,
  0,64,0,62,0,60,0,58,0,56,0,54,0,52,0,50,0,48,0,46,0,44,0,43,0,41,0,40,0,38,0,37,
  0,35,0,34,0,33,0,32,0,31,0,30,0,29,0,28,0,27,0,26,0,26,0,25,0,24,0,24,0,23,0,22,
  0,64,0,62,0,60,0,58,0,56,0,54,0,52,0,50,0,48,0,47,0,45,0,44,0,42,0,41,0,39,0,38,
  0,37,0,35,0,34,0,33,0,32,0,31,0,30,0,29,0,28,0,27,0,27,0,26,0,25,0,25,0,24,0,23,
  0,64,0,62,0,60,0,58,0,56,0,54,0,53,0,51,0,49,0,48,0,46,0,44,0,43,0,41,0,40,0,39,
  0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,29,0,28,0,28,0,27,0,26,0,26,0,25,0,24,
  0,64,0,62,0,60,0,58,0,57,0,55,0,53,0,51,0,50,0,48,0,47,0,45,0,44,0,42,0,41,0,40,
  0,38,0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,29,0,29,0,28,0,27,0,26,0,26,0,25,
  0,64,0,62,0,60,0,59,0,57,0,55,0,54,0,52,0,50,0,49,0,47,0,46,0,44,0,43,0,42,0,40,
  0,39,0,38,0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,30,0,29,0,28,0,27,0,27,0,26,
  0,64,0,62,0,61,0,59,0,57,0,56,0,54,0,52,0,51,0,49,0,48,0,46,0,45,0,44,0,42,0,41,
  0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,30,0,29,0,28,0,27,0,27,
  0,64,0,62,0,61,0,59,0,58,0,56,0,54,0,53,0,51,0,50,0,48,0,47,0,46,0,44,0,43,0,42,
  0,41,0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,33,0,32,0,31,0,30,0,30,0,29,0,28,0,28,
  0,64,0,62,0,61,0,59,0,58,0,56,0,55,0,53,0,52,0,50,0,49,0,48,0,46,0,45,0,44,0,43,
  0,42,0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,34,0,33,0,32,0,31,0,30,0,30,0,29,0,28,
  0,64,0,62,0,61,0,59,0,58,0,57,0,55,0,54,0,52,0,51,0,50,0,48,0,47,0,46,0,45,0,43,
  0,42,0,41,0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,34,0,33,0,32,0,31,0,31,0,30,0,29,
  0,64,0,63,0,61,0,60,0,58,0,57,0,55,0,54,0,53,0,51,0,50,0,49,0,48,0,46,0,45,0,44,
  0,43,0,42,0,41,0,40,0,39,0,38,0,37,0,36,0,35,0,34,0,34,0,33,0,32,0,31,0,31,0,30,
  0,64,0,63,0,61,0,60,0,58,0,57,0,56,0,54,0,53,0,52,0,50,0,49,0,48,0,47,0,46,0,45,
  0,43,0,42,0,41,0,40,0,39,0,38,0,38,0,37,0,36,0,35,0,34,0,33,0,33,0,32,0,31,0,31,
  0,64,0,63,0,61,0,60,0,59,0,57,0,56,0,55,0,53,0,52,0,51,0,50,0,48,0,47,0,46,0,45,
  0,44,0,43,0,42,0,41,0,40,0,39,0,38,0,37,0,37,0,36,0,35,0,34,0,33,0,33,0,32,0,31,
  0,64,0,63,0,61,0,60,0,59,0,57,0,56,0,55,0,53,0,52,0,51,0,50,0,49,0,48,0,47,0,46,
  0,45,0,44,0,43,0,42,0,41,0,40,0,39,0,38,0,37,0,36,0,36,0,35,0,34,0,33,0,33,0,32,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char ST011[53248] = {
  6,0,192,7,0,241,8,192,151,7,0,193,145,0,0,2,4,192,32,0,20,52,64,144,145,0,0,2,60,192,32,0,
  20,80,0,144,0,0,160,68,37,192,159,0,0,129,86,192,144,0,21,21,0,0,104,0,0,0,0,128,0,0,8,184,
  65,145,0,0,8,56,66,145,0,0,8,228,66,145,0,0,160,0,0,160,4,3,168,0,0,160,164,3,168,0,0,160,
  248,5,168,96,11,168,112,12,168,128,13,168,52,15,168,184,16,168,168,30,168,20,31,168,196,31,168,173,9,168,125,19,
  168,253,20,168,101,28,168,170,3,168,20,31,168,196,31,168,173,9,168,58,8,168,0,32,168,72,58,168,17,55,168,197,
  57,168,118,32,168,178,47,168,146,62,168,86,10,168,168,4,168,0,0,160,118,25,168,78,26,168,0,0,160,94,29,168,
  78,26,168,0,0,160,39,1,168,0,0,160,163,2,168,0,0,160,0,0,160,35,7,168,0,0,160,0,0,160,135,11,
  168,0,0,160,251,18,168,0,0,160,0,0,160,63,43,168,0,0,160,224,3,168,248,5,168,96,11,168,112,12,168,128,
  13,168,52,15,168,184,16,168,168,30,168,20,31,168,196,31,168,173,9,168,125,19,168,253,20,168,101,28,168,170,3,168,
  20,31,168,196,31,168,173,9,168,58,8,168,0,32,168,72,58,168,17,55,168,197,57,168,118,32,168,178,47,168,146,62,
  168,86,10,168,216,5,168,0,0,160,1,0,192,10,192,255,194,63,192,20,128,18,35,128,15,208,128,19,48,128,17,47,
  0,9,2,0,194,16,128,20,192,129,145,1,0,192,194,63,192,20,128,18,35,128,15,208,128,19,48,128,17,0,128,4,
  32,130,145,0,0,9,2,0,194,16,128,20,232,129,145,6,0,192,24,194,151,0,0,160,198,63,192,36,194,151,7,0,
  192,22,0,0,48,194,151,0,0,160,6,0,192,1,0,192,10,192,255,194,63,192,20,128,18,35,128,15,208,128,19,48,
  128,17,0,128,4,180,130,145,0,0,9,2,0,194,16,128,20,68,130,145,1,0,192,2,0,194,195,255,255,20,0,9,
  63,128,8,124,130,145,1,0,192,20,0,9,194,255,255,0,128,4,204,130,145,2,0,194,16,128,20,140,130,145,6,0,
  192,172,194,151,0,0,160,70,0,192,184,194,151,7,0,192,22,0,0,196,194,151,0,0,160,134,0,192,208,194,151,7,
  0,192,22,0,0,220,194,151,0,0,160,7,0,192,1,0,192,2,0,194,21,0,9,102,128,8,248,194,151,124,130,145,
  0,0,160,65,5,192,2,32,192,6,0,192,7,0,233,20,0,9,24,195,151,143,128,8,20,131,145,1,0,192,2,5,
  192,3,224,255,20,0,9,63,128,8,48,131,145,1,224,255,4,5,192,31,0,0,132,7,192,31,0,0,4,10,192,31,
  0,0,132,12,192,31,0,0,4,15,192,31,0,0,132,17,192,31,0,0,4,20,192,31,0,0,132,22,192,31,0,0,
  4,25,192,31,0,0,129,27,192,66,5,192,3,224,255,20,0,9,63,128,8,148,131,145,0,0,64,7,0,192,6,0,
  192,172,195,151,129,0,0,180,195,151,130,0,0,7,0,193,20,0,9,246,128,8,7,0,233,20,0,9,208,195,151,246,
  128,8,204,131,145,0,0,64,65,5,192,69,27,192,20,0,0,242,0,0,32,128,18,44,196,148,4,196,145,2,24,192,
  0,128,3,35,0,0,84,0,0,242,0,0,32,128,18,32,196,145,2,24,192,0,128,3,63,0,0,20,0,0,47,0,
  0,0,1,9,66,16,192,16,128,20,232,131,145,20,0,0,242,0,0,32,128,18,88,196,145,2,24,192,0,128,3,47,
  0,0,65,34,192,69,36,192,194,1,192,20,0,0,250,0,0,84,1,0,253,0,0,223,0,0,20,0,8,239,128,8,
  100,132,145,196,36,192,129,32,192,0,0,4,4,37,192,130,32,192,0,128,4,31,0,0,196,36,192,47,0,64,67,0,
  192,68,38,192,241,0,0,48,0,20,192,4,144,1,0,192,31,0,0,132,38,192,241,0,0,48,0,20,216,4,144,1,
  0,192,31,0,0,196,38,192,241,0,0,48,0,20,240,4,144,1,0,192,31,0,0,1,0,192,196,37,192,250,0,0,
  141,0,192,2,0,192,0,128,53,0,128,11,32,0,21,68,38,192,250,0,0,13,4,192,2,0,192,0,128,53,0,128,
  11,32,0,21,132,38,192,250,0,0,13,252,255,2,0,192,0,128,53,0,128,11,32,0,21,196,38,192,250,0,0,13,
  4,192,2,0,192,0,128,53,0,128,11,32,0,21,68,39,192,0,0,5,4,38,192,250,0,0,77,85,193,2,0,192,
  0,128,37,32,0,21,19,0,0,4,39,192,250,0,0,13,0,240,2,0,192,0,128,37,32,0,21,132,37,192,31,0,
  0,49,0,0,4,39,192,250,0,0,141,255,255,2,0,192,0,128,53,0,128,11,32,0,21,196,37,192,31,0,0,0,
  0,64,168,4,168,2,0,192,132,37,192,0,128,4,47,128,20,196,37,192,0,128,4,47,0,64,129,181,193,184,10,168,
  12,11,168,12,11,168,12,11,168,12,11,168,12,11,168,12,11,168,12,11,168,184,10,168,129,176,193,66,5,192,3,0,
  192,20,0,9,63,128,8,44,134,145,1,204,193,66,5,192,3,0,192,20,0,9,63,128,8,68,134,145,196,36,192,254,
  0,0,10,0,192,66,171,193,0,128,21,36,128,20,2,97,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,20,
  208,0,21,26,0,0,130,171,193,0,128,21,36,128,20,2,97,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,
  20,208,0,21,26,0,0,194,171,193,0,128,21,36,128,20,2,97,192,243,128,21,37,0,0,97,0,0,31,0,0,48,
  0,20,208,0,21,26,0,0,77,6,192,1,0,192,0,0,53,0,0,11,0,0,10,0,0,9,4,38,192,31,0,0,
  10,0,192,194,173,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,20,208,0,
  21,26,0,0,2,174,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,20,208,
  0,21,26,0,0,66,174,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,20,
  208,0,21,26,0,0,66,176,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,0,0,48,0,
  20,208,0,21,26,0,0,194,176,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,0,0,48,
  0,20,208,0,21,26,0,0,194,178,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,0,0,
  48,0,20,208,0,21,26,0,0,2,179,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,0,
  0,48,0,20,208,0,21,26,0,0,66,179,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,0,0,31,
  0,0,48,0,20,208,0,21,26,0,0,13,10,192,1,0,192,0,0,53,0,0,11,0,0,10,0,0,9,4,38,192,
  0,0,5,31,0,0,4,37,192,254,0,0,10,0,192,194,181,193,0,128,21,36,128,20,2,97,192,243,128,21,37,0,
  0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,130,181,193,0,128,21,36,128,20,2,97,192,243,128,21,37,
  0,0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,66,181,193,0,128,21,36,128,20,2,97,192,243,128,21,
  37,0,0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,77,6,192,1,0,192,0,0,53,0,0,11,4,38,
  192,0,0,5,31,0,0,10,0,192,66,179,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,31,
  0,0,48,0,20,208,0,21,26,0,0,2,179,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,0,
  31,0,0,48,0,20,208,0,21,26,0,0,194,178,193,0,128,21,36,128,20,130,90,192,243,128,21,37,0,0,97,0,
  0,31,0,0,48,0,20,208,0,21,26,0,0,194,176,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,97,
  0,0,31,0,0,48,0,20,208,0,21,26,0,0,66,176,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,0,
  97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,66,174,193,0,128,21,36,128,20,194,93,192,243,128,21,37,0,
  0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,2,174,193,0,128,21,36,128,20,194,93,192,243,128,21,37,
  0,0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,194,173,193,0,128,21,36,128,20,194,93,192,243,128,21,
  37,0,0,97,0,0,31,0,0,48,0,20,208,0,21,26,0,0,13,10,192,1,0,192,0,0,53,0,0,11,4,38,
  192,0,0,5,31,0,0,0,0,64,20,0,9,15,0,192,20,0,9,143,0,192,20,0,9,15,1,192,20,0,9,79,
  1,192,20,0,9,79,1,192,20,0,9,79,1,192,20,0,9,79,1,192,20,0,9,79,1,192,20,0,9,15,1,192,
  20,0,9,143,0,192,0,0,64,20,0,9,15,0,192,20,0,9,207,0,192,20,0,9,79,1,192,20,0,9,143,1,
  192,20,0,9,143,1,192,20,0,9,143,1,192,20,0,9,143,1,192,20,0,9,143,1,192,20,0,9,79,1,192,20,
  0,9,207,0,192,0,0,64,65,239,193,66,2,192,67,0,192,20,0,9,63,128,8,108,139,145,1,2,192,66,5,192,
  16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,194,7,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,
  145,66,10,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,194,12,192,16,128,21,36,128,20,2,16,192,0,
  128,4,100,204,145,66,15,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,194,17,192,16,128,21,36,128,20,
  2,16,192,0,128,4,100,204,145,66,20,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,194,22,192,16,128,
  21,36,128,20,2,16,192,0,128,4,100,204,145,66,25,192,16,128,21,36,128,20,2,16,192,0,128,4,100,204,145,66,
  239,193,16,128,21,36,128,20,15,0,192,0,0,8,124,11,148,0,0,64,129,241,193,66,2,192,67,0,192,20,0,9,
  63,128,8,124,140,145,1,2,192,66,5,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,194,7,192,16,128,
  21,36,128,20,2,8,192,0,128,4,116,205,145,66,10,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,194,
  12,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,66,15,192,16,128,21,36,128,20,2,8,192,0,128,4,
  116,205,145,194,17,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,66,20,192,16,128,21,36,128,20,2,8,
  192,0,128,4,116,205,145,194,22,192,16,128,21,36,128,20,2,8,192,0,128,4,116,205,145,66,25,192,16,128,21,36,
  128,20,2,8,192,0,128,4,116,205,145,130,241,193,16,128,21,36,128,20,15,0,192,0,0,8,140,12,148,0,0,64,
  1,105,192,194,32,192,3,0,192,20,0,9,63,128,8,140,141,145,129,39,192,194,32,192,3,0,192,20,0,9,63,128,
  8,164,141,145,196,36,192,241,0,0,16,0,18,52,78,145,67,253,255,14,13,192,13,8,192,56,14,168,172,14,168,195,
  253,255,14,13,192,13,24,192,56,14,168,195,255,255,14,14,192,13,32,192,56,14,168,67,0,192,14,14,192,13,32,192,
  56,14,168,67,2,192,14,13,192,13,24,192,56,14,168,131,2,192,14,14,192,13,16,192,56,14,168,195,2,192,14,13,
  192,13,8,192,56,14,168,0,0,64,196,36,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,68,206,145,2,
  16,192,0,128,2,168,206,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,104,206,145,2,63,192,0,128,2,
  0,128,20,168,142,145,2,105,192,16,128,21,36,128,20,239,0,0,130,39,192,208,128,21,36,128,20,239,0,0,0,0,
  64,131,253,255,14,14,192,196,36,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,192,206,145,2,16,192,0,
  128,2,48,207,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,228,206,145,2,9,192,0,128,4,16,207,145,
  2,63,192,0,128,2,0,128,20,48,143,145,2,105,192,16,128,21,36,128,20,15,16,192,130,39,192,208,128,21,36,128,
  20,15,16,192,0,0,64,4,37,192,241,0,0,16,0,18,184,79,145,195,2,192,14,21,192,13,8,192,188,15,168,48,
  16,168,67,2,192,14,21,192,13,24,192,188,15,168,67,0,192,14,22,192,13,32,192,188,15,168,195,255,255,14,22,192,
  13,32,192,188,15,168,195,253,255,14,21,192,13,24,192,188,15,168,131,253,255,14,22,192,13,16,192,188,15,168,67,253,
  255,14,21,192,13,8,192,188,15,168,0,0,64,4,37,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,200,
  207,145,2,8,192,0,128,2,44,208,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,236,207,145,2,63,192,
  0,128,2,0,128,20,44,144,145,2,105,192,16,128,21,36,128,20,239,0,0,130,39,192,208,128,21,36,128,20,239,0,
  0,0,0,64,131,2,192,14,14,192,4,37,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,68,208,145,2,
  8,192,0,128,2,180,208,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,104,208,145,2,17,192,0,128,4,
  148,208,145,2,63,192,0,128,2,0,128,20,180,144,145,2,105,192,16,128,21,36,128,20,15,16,192,130,39,192,208,128,
  21,36,128,20,15,16,192,0,0,64,65,72,192,194,32,192,3,0,192,20,0,9,63,128,8,196,144,145,193,12,193,194,
  32,192,3,0,192,20,0,9,63,128,8,220,144,145,129,45,193,194,32,192,3,0,192,20,0,9,63,128,8,244,144,145,
  65,5,192,20,0,0,2,0,192,0,128,5,116,209,145,116,209,148,30,0,0,2,105,192,16,128,21,36,128,20,242,0,
  0,0,128,11,0,128,11,0,128,11,0,128,11,0,128,11,67,108,192,48,128,21,37,0,0,106,0,0,20,0,0,130,
  15,192,0,128,2,0,128,11,67,100,192,48,128,21,37,0,0,104,0,0,0,0,128,0,0,9,130,27,192,16,128,20,
  4,145,145,0,0,64,48,0,21,66,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,130,45,193,16,128,
  21,36,128,20,242,0,0,208,128,17,47,0,0,20,0,0,2,0,192,0,128,5,136,209,145,2,15,192,0,128,4,12,
  146,145,48,0,21,66,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,130,45,193,16,128,21,36,128,20,
  242,0,0,208,128,17,47,0,0,1,0,64,48,0,21,66,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,
  0,194,12,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,20,0,0,2,0,192,0,128,5,16,210,145,2,
  23,192,0,128,4,148,146,145,48,0,21,66,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,194,12,193,
  16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,1,0,64,194,69,192,16,128,21,36,128,20,2,32,192,0,128,
  1,47,0,0,2,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,131,253,255,136,17,168,116,
  17,160,2,67,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,40,193,16,128,21,36,128,20,242,0,0,
  208,128,17,47,0,0,130,67,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,40,193,16,128,21,36,128,
  20,242,0,0,208,128,17,47,0,0,116,17,160,130,69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,
  42,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,128,20,2,32,192,0,128,1,
  47,0,0,2,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,20,2,32,
  192,0,128,1,47,0,0,66,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,
  128,20,2,32,192,0,128,1,47,0,0,194,47,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,75,192,
  16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,
  0,116,17,160,130,69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,42,193,16,128,21,36,128,20,242,
  0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,2,43,193,16,128,21,
  36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,43,
  193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,
  0,0,66,45,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,32,192,
  0,128,1,47,0,0,194,45,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,
  20,2,32,192,0,128,1,47,0,0,2,48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,194,
  69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,2,43,193,16,128,21,36,128,20,242,0,0,208,128,17,
  47,0,0,2,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,45,193,16,128,21,36,128,20,242,0,
  0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,45,193,16,128,21,36,
  128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,2,48,193,
  16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,67,253,255,136,17,168,195,253,255,136,17,168,67,2,192,136,17,
  168,195,2,192,136,17,168,116,17,160,130,69,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,42,193,16,
  128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,
  66,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,128,20,2,32,192,0,128,
  1,47,0,0,194,47,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,75,192,16,128,21,36,128,20,2,
  32,192,0,128,1,47,0,0,66,48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,131,253,255,136,17,168,
  195,255,255,136,17,168,67,0,192,136,17,168,131,2,192,136,17,168,116,17,160,130,69,192,16,128,21,36,128,20,2,32,
  192,0,128,1,47,0,0,194,42,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,
  128,20,2,32,192,0,128,1,47,0,0,2,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,
  16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,43,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,
  0,2,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,66,45,193,16,128,21,36,128,20,242,0,0,208,
  128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,45,193,16,128,21,36,128,20,
  242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,194,47,193,16,128,
  21,36,128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,20,2,32,192,0,128,1,47,0,0,2,
  48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,75,192,16,128,21,36,128,20,2,32,192,0,128,1,
  47,0,0,66,48,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,194,74,192,16,128,21,36,128,
  20,2,0,224,0,128,1,47,0,0,66,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,131,
  2,192,16,18,168,116,17,160,130,77,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,18,193,16,128,21,
  36,128,20,242,0,0,208,128,17,47,0,0,2,77,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,17,
  193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,2,75,192,16,128,21,36,128,20,2,0,224,0,
  128,1,47,0,0,130,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,20,
  2,0,224,0,128,1,47,0,0,66,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,
  21,36,128,20,2,0,224,0,128,1,47,0,0,2,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,
  70,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,10,193,16,128,21,36,128,20,242,0,0,208,128,17,
  47,0,0,130,69,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,10,193,16,128,21,36,128,20,242,0,
  0,208,128,17,47,0,0,116,17,160,2,75,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,15,193,16,
  128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,74,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,
  66,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,128,20,2,0,224,0,128,
  1,47,0,0,2,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,
  0,224,0,128,1,47,0,0,2,13,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,72,192,16,128,21,
  36,128,20,2,0,224,0,128,1,47,0,0,130,12,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,
  192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,66,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,
  0,0,116,17,160,194,74,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,66,15,193,16,128,21,36,128,20,
  242,0,0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,13,193,16,128,
  21,36,128,20,242,0,0,208,128,17,47,0,0,2,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,
  12,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,128,20,2,0,224,0,128,1,
  47,0,0,66,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,195,2,192,16,18,168,67,2,192,16,18,
  168,195,253,255,16,18,168,67,253,255,16,18,168,116,17,160,2,75,192,16,128,21,36,128,20,2,0,224,0,128,1,47,
  0,0,130,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,74,192,16,128,21,36,128,20,2,0,224,
  0,128,1,47,0,0,2,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,
  20,2,0,224,0,128,1,47,0,0,130,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,69,192,16,
  128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,
  131,2,192,16,18,168,67,0,192,16,18,168,195,255,255,16,18,168,131,253,255,16,18,168,116,17,160,2,75,192,16,128,
  21,36,128,20,2,0,224,0,128,1,47,0,0,130,15,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,
  74,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,66,15,193,16,128,21,36,128,20,242,0,0,208,128,17,
  47,0,0,130,74,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,15,193,16,128,21,36,128,20,242,0,
  0,208,128,17,47,0,0,130,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,2,13,193,16,128,21,36,
  128,20,242,0,0,208,128,17,47,0,0,2,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,0,130,12,193,
  16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,2,70,192,16,128,21,36,128,20,2,0,224,0,128,1,47,0,
  0,130,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,194,69,192,16,128,21,36,128,20,2,0,224,0,
  128,1,47,0,0,66,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,130,69,192,16,128,21,36,128,20,
  2,0,224,0,128,1,47,0,0,2,10,193,16,128,21,36,128,20,242,0,0,208,128,17,47,0,0,116,17,160,193,143,
  193,194,32,192,3,0,192,20,0,9,63,128,8,180,158,145,65,5,192,20,0,0,2,0,192,0,128,5,0,223,145,0,
  223,148,131,7,192,48,128,18,0,128,11,131,109,192,48,128,21,37,0,0,194,143,193,16,128,21,36,128,20,111,0,0,
  0,0,9,130,27,192,16,128,20,196,158,145,0,0,64,68,209,193,15,0,192,132,209,193,15,0,192,78,5,192,4,0,
  0,1,0,192,0,0,5,168,95,145,168,95,148,2,16,192,10,0,192,0,128,2,80,159,145,74,0,192,221,0,0,66,
  209,193,208,128,21,36,128,20,250,0,0,194,143,193,0,128,21,36,128,20,241,0,0,194,143,193,208,128,21,36,128,20,
  0,0,4,80,95,144,66,209,193,0,128,21,36,128,20,223,0,0,66,209,193,224,128,21,36,128,20,15,0,0,1,0,
  0,0,0,9,30,0,0,130,27,192,16,128,20,40,159,145,0,0,64,1,105,192,194,32,192,3,30,222,20,0,9,63,
  128,8,208,159,145,65,78,193,194,32,192,3,0,192,20,0,9,63,128,8,232,159,145,68,209,193,241,0,0,194,143,193,
  16,128,21,36,128,20,250,0,0,130,39,192,16,128,21,36,128,20,242,0,0,35,128,11,0,128,11,0,128,11,0,128,
  11,0,128,11,141,165,192,224,128,21,37,0,0,109,0,0,30,0,0,20,0,0,130,7,192,0,128,2,48,128,17,0,
  128,11,131,113,192,48,128,21,37,0,0,104,0,0,0,0,128,66,209,193,32,0,21,20,0,20,0,0,5,252,31,145,
  0,0,64,128,0,21,2,105,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,66,78,
  193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,20,0,0,2,0,192,0,128,5,133,192,145,73,193,148,9,
  1,160,128,0,21,66,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,20,0,0,2,0,192,0,128,5,
  217,192,145,73,193,148,130,15,192,0,128,2,0,128,11,48,128,21,37,0,0,98,0,0,0,128,8,73,193,148,217,128,
  145,128,0,21,66,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,1,0,64,66,102,192,16,128,21,36,
  128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,130,75,193,16,128,21,36,128,20,66,0,192,0,128,5,
  47,0,64,130,102,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,194,75,193,16,128,
  21,36,128,20,66,0,192,0,128,5,47,0,64,194,102,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,
  128,17,47,0,0,2,76,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,194,104,192,16,128,21,36,128,20,
  194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,
  64,66,105,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,130,78,193,16,128,21,36,
  128,20,66,0,192,0,128,5,47,0,64,66,107,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,
  47,0,0,130,80,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,130,107,192,16,128,21,36,128,20,194,63,
  192,0,128,2,0,128,15,208,128,17,47,0,0,194,80,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,194,
  107,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,81,193,16,128,21,36,128,20,
  66,0,192,0,128,5,47,0,64,2,10,193,16,128,21,36,128,20,242,0,0,224,128,18,61,195,145,130,75,193,16,128,
  21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,66,10,193,16,128,21,36,128,20,242,0,0,224,128,18,113,
  195,145,194,75,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,130,10,193,16,128,21,36,128,20,
  242,0,0,224,128,18,165,195,145,2,76,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,130,12,
  193,16,128,21,36,128,20,242,0,0,224,128,18,217,195,145,2,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,
  0,64,0,0,64,2,13,193,16,128,21,36,128,20,242,0,0,224,128,18,13,196,145,130,78,193,16,128,21,36,128,20,
  66,0,192,0,128,5,47,0,64,0,0,64,2,15,193,16,128,21,36,128,20,242,0,0,224,128,18,65,196,145,130,80,
  193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,66,15,193,16,128,21,36,128,20,242,0,0,224,
  128,18,117,196,145,194,80,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,64,130,15,193,16,128,21,
  36,128,20,242,0,0,224,128,18,169,196,145,2,81,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,64,0,0,
  64,133,1,168,109,0,160,134,253,255,131,133,192,133,0,168,109,0,160,194,99,192,16,128,21,36,128,20,194,63,192,0,
  128,2,0,128,15,208,128,17,47,0,0,2,73,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,66,100,192,
  16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,130,73,193,16,128,21,36,128,20,66,0,
  192,0,128,5,47,0,0,109,0,160,77,1,168,213,2,168,133,1,168,189,1,168,101,2,168,109,0,160,77,1,168,133,
  1,168,157,2,168,189,1,168,245,1,168,45,2,168,109,0,160,133,1,168,157,2,168,245,1,168,45,2,168,70,253,255,
  131,145,192,133,0,168,198,2,192,131,149,192,133,0,168,198,253,255,131,145,192,133,0,168,70,2,192,131,149,192,133,0,
  168,109,0,160,77,1,168,213,2,168,189,1,168,101,2,168,134,253,255,131,133,192,133,0,168,134,2,192,131,137,192,133,
  0,168,198,255,255,131,157,192,133,0,168,70,0,192,131,157,192,133,0,168,109,0,160,130,75,193,16,128,21,36,128,20,
  66,0,192,0,128,5,47,0,0,194,75,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,2,76,193,16,128,
  21,36,128,20,66,0,192,0,128,5,47,0,0,2,78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,130,
  78,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,130,80,193,16,128,21,36,128,20,66,0,192,0,128,5,
  47,0,0,194,80,193,16,128,21,36,128,20,66,0,192,0,128,5,47,0,0,2,81,193,16,128,21,36,128,20,66,0,
  192,0,128,5,47,0,0,109,0,160,65,3,168,109,0,160,65,3,168,109,0,160,77,1,168,213,2,168,65,3,168,117,
  3,168,17,4,168,109,0,160,13,3,168,121,4,168,133,1,168,117,3,168,17,4,168,109,0,160,13,3,168,121,4,168,
  65,3,168,189,1,168,101,2,168,109,0,160,13,3,168,121,4,168,65,3,168,117,3,168,17,4,168,77,1,168,65,3,
  168,69,4,168,117,3,168,169,3,168,221,3,168,109,0,160,13,3,168,133,1,168,157,2,168,117,3,168,169,3,168,221,
  3,168,109,0,160,13,3,168,65,3,168,69,4,168,189,1,168,169,3,168,221,3,168,109,0,160,13,3,168,65,3,168,
  69,4,168,117,3,168,245,1,168,45,2,168,109,0,160,70,253,255,131,145,192,133,0,168,198,2,192,131,149,192,133,0,
  168,117,3,168,17,4,168,109,0,160,13,3,168,121,4,168,117,3,168,17,4,168,109,0,160,13,3,168,121,4,168,198,
  253,255,131,145,192,133,0,168,70,2,192,131,149,192,133,0,168,109,0,160,70,253,255,131,145,192,133,0,168,198,2,192,
  131,149,192,133,0,168,65,3,168,69,4,168,117,3,168,17,4,168,169,3,168,221,3,168,109,0,160,13,3,168,121,4,
  168,133,1,168,157,2,168,117,3,168,17,4,168,169,3,168,221,3,168,109,0,160,13,3,168,121,4,168,65,3,168,69,
  4,168,198,253,255,131,145,192,133,0,168,70,2,192,131,149,192,133,0,168,169,3,168,221,3,168,109,0,160,13,3,168,
  121,4,168,65,3,168,69,4,168,117,3,168,17,4,168,245,1,168,45,2,168,109,0,160,65,3,168,69,4,168,169,3,
  168,221,3,168,109,0,160,134,253,255,131,133,192,133,0,168,134,2,192,131,137,192,133,0,168,169,3,168,221,3,168,109,
  0,160,65,3,168,69,4,168,198,255,255,131,157,192,133,0,168,70,0,192,131,157,192,133,0,168,109,0,160,77,1,168,
  213,2,168,65,3,168,69,4,168,117,3,168,17,4,168,169,3,168,221,3,168,109,0,160,13,3,168,121,4,168,134,253,
  255,131,133,192,133,0,168,134,2,192,131,137,192,133,0,168,117,3,168,17,4,168,169,3,168,221,3,168,109,0,160,13,
  3,168,121,4,168,65,3,168,69,4,168,189,1,168,101,2,168,169,3,168,221,3,168,109,0,160,13,3,168,121,4,168,
  65,3,168,69,4,168,117,3,168,17,4,168,198,255,255,131,157,192,133,0,168,70,0,192,131,157,192,133,0,168,109,0,
  160,193,137,192,194,32,192,3,30,222,20,0,9,63,128,8,185,137,145,132,209,193,241,0,0,194,143,193,16,128,21,36,
  128,20,250,0,0,130,39,192,16,128,21,36,128,20,242,0,0,35,128,11,0,128,11,0,128,11,0,128,11,0,128,11,
  205,186,192,224,128,21,37,0,0,109,0,0,30,0,0,20,0,0,130,7,192,0,128,2,48,128,17,0,128,11,195,166,
  192,48,128,21,37,0,0,104,0,0,0,0,128,66,209,193,32,0,21,20,0,20,0,0,5,205,9,145,0,0,64,128,
  0,21,194,137,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,66,78,193,16,128,21,
  36,128,20,2,64,192,0,128,5,47,0,0,20,0,0,2,0,192,0,128,5,85,202,145,25,203,148,217,10,160,128,0,
  21,66,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,20,0,0,2,0,192,0,128,5,169,202,145,25,
  203,148,130,15,192,0,128,2,0,128,11,48,128,21,37,0,0,98,0,0,0,128,8,25,203,148,169,138,145,128,0,21,
  66,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,1,0,64,130,140,192,16,128,21,36,128,20,194,63,
  192,0,128,2,0,128,15,208,128,17,47,0,0,2,81,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,66,
  140,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,194,80,193,16,128,21,36,128,20,
  2,64,192,0,128,5,47,0,64,2,140,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,
  0,130,80,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,2,138,192,16,128,21,36,128,20,194,63,192,0,
  128,2,0,128,15,208,128,17,47,0,0,130,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,130,137,192,
  16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,78,193,16,128,21,36,128,20,2,64,
  192,0,128,5,47,0,64,130,135,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,
  76,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,66,135,192,16,128,21,36,128,20,194,63,192,0,128,2,
  0,128,15,208,128,17,47,0,0,194,75,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,2,135,192,16,128,
  21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,130,75,193,16,128,21,36,128,20,2,64,192,0,
  128,5,47,0,64,66,48,193,16,128,21,36,128,20,242,0,0,224,128,18,13,205,145,2,81,193,16,128,21,36,128,20,
  2,64,192,0,128,5,47,0,64,0,0,64,2,48,193,16,128,21,36,128,20,242,0,0,224,128,18,65,205,145,194,80,
  193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,194,47,193,16,128,21,36,128,20,242,0,0,224,
  128,18,117,205,145,130,80,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,194,45,193,16,128,21,
  36,128,20,242,0,0,224,128,18,169,205,145,130,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,
  64,66,45,193,16,128,21,36,128,20,242,0,0,224,128,18,221,205,145,2,78,193,16,128,21,36,128,20,2,64,192,0,
  128,5,47,0,64,0,0,64,66,43,193,16,128,21,36,128,20,242,0,0,224,128,18,17,206,145,2,76,193,16,128,21,
  36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,2,43,193,16,128,21,36,128,20,242,0,0,224,128,18,69,206,
  145,194,75,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,194,42,193,16,128,21,36,128,20,242,
  0,0,224,128,18,121,206,145,130,75,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,64,0,0,64,85,11,168,
  61,10,160,134,2,192,131,137,192,85,10,168,61,10,160,2,143,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,
  15,208,128,17,47,0,0,130,83,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,130,142,192,16,128,21,36,
  128,20,194,63,192,0,128,2,0,128,15,208,128,17,47,0,0,2,83,193,16,128,21,36,128,20,2,64,192,0,128,5,
  47,0,0,61,10,160,29,11,168,165,12,168,85,11,168,141,11,168,53,12,168,61,10,160,29,11,168,85,11,168,109,12,
  168,141,11,168,197,11,168,253,11,168,61,10,160,85,11,168,109,12,168,197,11,168,253,11,168,198,2,192,131,149,192,85,
  10,168,70,253,255,131,145,192,85,10,168,70,2,192,131,149,192,85,10,168,198,253,255,131,145,192,85,10,168,61,10,160,
  29,11,168,165,12,168,141,11,168,53,12,168,134,2,192,131,137,192,85,10,168,134,253,255,131,133,192,85,10,168,70,0,
  192,131,157,192,85,10,168,198,255,255,131,157,192,85,10,168,61,10,160,2,81,193,16,128,21,36,128,20,2,64,192,0,
  128,5,47,0,0,194,80,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,130,80,193,16,128,21,36,128,20,
  2,64,192,0,128,5,47,0,0,130,78,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,2,78,193,16,128,
  21,36,128,20,2,64,192,0,128,5,47,0,0,2,76,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,194,
  75,193,16,128,21,36,128,20,2,64,192,0,128,5,47,0,0,130,75,193,16,128,21,36,128,20,2,64,192,0,128,5,
  47,0,0,61,10,160,17,13,168,61,10,160,17,13,168,61,10,160,29,11,168,165,12,168,17,13,168,69,13,168,225,13,
  168,61,10,160,221,12,168,73,14,168,85,11,168,69,13,168,225,13,168,61,10,160,221,12,168,73,14,168,17,13,168,141,
  11,168,53,12,168,61,10,160,221,12,168,73,14,168,17,13,168,69,13,168,225,13,168,29,11,168,17,13,168,21,14,168,
  69,13,168,121,13,168,173,13,168,61,10,160,221,12,168,85,11,168,109,12,168,69,13,168,121,13,168,173,13,168,61,10,
  160,221,12,168,17,13,168,21,14,168,141,11,168,121,13,168,173,13,168,61,10,160,221,12,168,17,13,168,21,14,168,69,
  13,168,197,11,168,253,11,168,61,10,160,198,2,192,131,149,192,85,10,168,70,253,255,131,145,192,85,10,168,69,13,168,
  225,13,168,61,10,160,221,12,168,73,14,168,69,13,168,225,13,168,61,10,160,221,12,168,73,14,168,70,2,192,131,149,
  192,85,10,168,198,253,255,131,145,192,85,10,168,61,10,160,198,2,192,131,149,192,85,10,168,70,253,255,131,145,192,85,
  10,168,17,13,168,21,14,168,69,13,168,225,13,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,85,11,168,
  109,12,168,69,13,168,225,13,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,17,13,168,21,14,168,70,2,
  192,131,149,192,85,10,168,198,253,255,131,145,192,85,10,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,17,
  13,168,21,14,168,69,13,168,225,13,168,197,11,168,253,11,168,61,10,160,17,13,168,21,14,168,121,13,168,173,13,168,
  61,10,160,134,2,192,131,137,192,85,10,168,134,253,255,131,133,192,85,10,168,121,13,168,173,13,168,61,10,160,17,13,
  168,21,14,168,70,0,192,131,157,192,85,10,168,198,255,255,131,157,192,85,10,168,61,10,160,29,11,168,165,12,168,17,
  13,168,21,14,168,69,13,168,225,13,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,134,2,192,131,137,192,
  85,10,168,134,253,255,131,133,192,85,10,168,69,13,168,225,13,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,
  168,17,13,168,21,14,168,141,11,168,53,12,168,121,13,168,173,13,168,61,10,160,221,12,168,73,14,168,17,13,168,21,
  14,168,69,13,168,225,13,168,70,0,192,131,157,192,85,10,168,198,255,255,131,157,192,85,10,168,61,10,160,65,5,192,
  20,0,0,2,0,192,0,128,5,233,212,148,30,0,0,2,105,192,16,128,21,36,128,20,194,63,192,0,128,2,42,128,
  3,0,128,15,132,244,193,47,0,0,194,137,192,16,128,21,36,128,20,194,63,192,0,128,2,45,128,3,0,128,15,196,
  244,193,47,0,0,66,78,193,16,128,21,36,128,20,194,63,192,0,128,2,38,128,3,0,128,15,35,0,0,20,0,0,
  241,0,0,0,0,15,0,0,12,130,0,12,0,128,12,38,0,0,50,0,12,0,128,12,35,0,0,129,0,0,32,0,
  20,93,84,144,133,84,145,65,255,255,48,0,21,85,20,144,209,0,0,196,244,193,0,0,4,26,0,0,201,20,144,10,
  0,192,201,20,160,65,255,255,128,0,21,125,20,144,225,0,0,132,244,193,0,0,4,29,0,0,201,20,144,13,0,192,
  201,20,160,209,0,0,196,244,193,0,0,4,26,0,0,157,20,144,10,0,192,225,0,0,132,244,193,0,0,4,29,0,
  0,181,20,144,13,0,192,65,255,255,208,0,21,201,84,144,10,0,192,13,0,192,1,0,0,2,236,192,16,128,21,36,
  128,20,226,0,0,0,128,15,208,128,17,47,0,0,0,0,9,130,27,192,16,128,20,129,147,145,0,0,64,129,170,192,
  194,32,192,3,0,192,20,0,9,63,128,8,9,149,145,68,209,193,241,0,0,30,0,0,130,170,192,16,128,21,36,128,
  20,250,0,0,194,143,193,16,128,21,36,128,20,253,0,0,130,39,192,16,128,21,36,128,20,243,0,0,20,0,0,130,
  7,192,0,128,2,48,128,17,0,128,11,3,188,192,48,128,21,37,0,0,104,0,0,0,0,128,130,170,192,16,128,21,
  36,128,20,223,0,0,66,209,193,32,0,21,20,0,20,0,0,5,29,21,145,0,0,64,32,0,21,20,0,0,2,0,
  192,0,128,5,29,214,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,20,0,0,2,16,192,0,
  128,2,29,150,145,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,16,128,21,36,128,20,2,192,255,0,128,2,
  0,128,15,48,128,21,224,128,20,29,214,144,130,0,192,208,128,21,42,0,0,1,0,64,32,0,21,20,0,0,2,0,
  192,0,128,5,77,214,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,1,0,64,173,22,160,130,
  176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,
  16,128,21,36,128,20,2,192,255,0,128,2,0,128,15,48,128,21,224,128,20,173,214,144,130,0,192,208,128,21,42,0,
  0,128,0,21,20,0,0,2,0,192,0,128,5,85,214,145,45,215,148,130,176,193,16,128,21,36,128,20,242,0,0,208,
  128,21,42,0,0,20,0,0,2,16,192,0,128,2,45,151,145,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,
  16,128,21,36,128,20,2,192,255,0,128,2,0,128,15,48,128,21,224,128,20,45,215,144,130,0,192,208,128,21,42,0,
  0,1,0,64,77,23,160,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,128,0,21,20,0,0,2,
  0,192,0,128,5,53,215,145,125,215,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,1,0,64,
  130,253,255,161,21,168,121,21,160,134,253,255,81,22,168,121,21,160,194,250,255,161,21,168,66,251,255,161,21,168,121,21,
  160,66,253,255,161,21,168,130,253,255,161,21,168,194,253,255,161,21,168,66,2,192,161,21,168,194,2,192,161,21,168,121,
  21,160,66,253,255,161,21,168,130,253,255,161,21,168,194,253,255,161,21,168,194,255,255,161,21,168,66,0,192,161,21,168,
  130,2,192,161,21,168,121,21,160,130,253,255,161,21,168,194,255,255,161,21,168,66,0,192,161,21,168,130,2,192,161,21,
  168,70,253,255,81,22,168,198,253,255,81,22,168,70,2,192,81,22,168,198,2,192,81,22,168,121,21,160,66,253,255,161,
  21,168,194,253,255,161,21,168,66,2,192,161,21,168,194,2,192,161,21,168,134,253,255,81,22,168,198,255,255,81,22,168,
  70,0,192,81,22,168,134,2,192,81,22,168,121,21,160,121,21,160,130,253,255,33,22,168,121,21,160,134,253,255,49,23,
  168,121,21,160,194,250,255,33,22,168,66,251,255,33,22,168,121,21,160,66,253,255,161,21,168,130,253,255,33,22,168,194,
  253,255,33,22,168,66,2,192,33,22,168,194,2,192,161,21,168,121,21,160,66,253,255,33,22,168,130,253,255,161,21,168,
  194,253,255,33,22,168,66,2,192,33,22,168,194,2,192,33,22,168,121,21,160,66,253,255,33,22,168,130,253,255,33,22,
  168,194,253,255,161,21,168,66,2,192,161,21,168,194,2,192,33,22,168,121,21,160,66,253,255,33,22,168,130,253,255,33,
  22,168,194,253,255,33,22,168,66,2,192,33,22,168,194,2,192,33,22,168,121,21,160,66,253,255,161,21,168,130,253,255,
  33,22,168,194,253,255,33,22,168,194,255,255,33,22,168,66,0,192,33,22,168,130,2,192,33,22,168,121,21,160,66,253,
  255,33,22,168,130,253,255,161,21,168,194,253,255,33,22,168,194,255,255,33,22,168,66,0,192,33,22,168,130,2,192,161,
  21,168,121,21,160,66,253,255,33,22,168,130,253,255,33,22,168,194,253,255,161,21,168,194,255,255,33,22,168,66,0,192,
  33,22,168,130,2,192,33,22,168,121,21,160,66,253,255,33,22,168,130,253,255,33,22,168,194,253,255,33,22,168,194,255,
  255,161,21,168,66,0,192,161,21,168,130,2,192,33,22,168,121,21,160,130,253,255,33,22,168,194,255,255,33,22,168,66,
  0,192,33,22,168,130,2,192,33,22,168,70,253,255,81,22,168,198,253,255,49,23,168,70,2,192,49,23,168,198,2,192,
  81,22,168,121,21,160,130,253,255,161,21,168,194,255,255,33,22,168,66,0,192,33,22,168,130,2,192,161,21,168,70,253,
  255,49,23,168,198,253,255,49,23,168,70,2,192,49,23,168,198,2,192,49,23,168,121,21,160,130,253,255,33,22,168,194,
  255,255,33,22,168,66,0,192,33,22,168,130,2,192,33,22,168,70,253,255,49,23,168,198,253,255,81,22,168,70,2,192,
  81,22,168,198,2,192,49,23,168,121,21,160,130,253,255,33,22,168,194,255,255,161,21,168,66,0,192,161,21,168,130,2,
  192,33,22,168,70,253,255,49,23,168,198,253,255,49,23,168,70,2,192,49,23,168,198,2,192,49,23,168,121,21,160,66,
  253,255,161,21,168,194,253,255,33,22,168,66,2,192,33,22,168,194,2,192,161,21,168,134,253,255,49,23,168,198,255,255,
  49,23,168,70,0,192,49,23,168,134,2,192,49,23,168,121,21,160,66,253,255,33,22,168,194,253,255,33,22,168,66,2,
  192,33,22,168,194,2,192,33,22,168,134,253,255,81,22,168,198,255,255,49,23,168,70,0,192,49,23,168,134,2,192,81,
  22,168,121,21,160,66,253,255,33,22,168,194,253,255,161,21,168,66,2,192,161,21,168,194,2,192,33,22,168,134,253,255,
  49,23,168,198,255,255,49,23,168,70,0,192,49,23,168,134,2,192,49,23,168,121,21,160,66,253,255,33,22,168,194,253,
  255,33,22,168,66,2,192,33,22,168,194,2,192,33,22,168,134,253,255,49,23,168,198,255,255,81,22,168,70,0,192,81,
  22,168,134,2,192,49,23,168,121,21,160,132,209,193,241,0,0,30,0,0,130,170,192,16,128,21,36,128,20,250,0,0,
  194,143,193,16,128,21,36,128,20,253,0,0,130,39,192,16,128,21,36,128,20,243,0,0,20,0,0,130,7,192,0,128,
  2,48,128,17,0,128,11,3,208,192,48,128,21,37,0,0,104,0,0,0,0,128,130,170,192,16,128,21,36,128,20,223,
  0,0,66,209,193,32,0,21,20,0,20,0,0,5,109,28,145,0,0,64,32,0,21,20,0,0,2,0,192,0,128,5,
  105,221,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,20,0,0,2,8,192,0,128,2,105,157,
  145,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,16,128,21,36,128,20,194,63,192,0,128,2,48,128,21,224,
  128,20,105,221,144,130,0,192,208,128,21,42,0,0,1,0,64,32,0,21,20,0,0,2,0,192,0,128,5,153,221,148,
  130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,1,0,64,245,29,160,130,176,193,16,128,21,36,128,
  20,242,0,0,208,128,21,42,0,0,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,16,128,21,36,128,20,194,
  63,192,0,128,2,48,128,21,224,128,20,245,221,144,130,0,192,208,128,21,42,0,0,128,0,21,20,0,0,2,0,192,
  0,128,5,161,221,145,113,222,148,130,176,193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,20,0,0,2,8,
  192,0,128,2,113,158,145,194,143,193,16,128,21,36,128,20,243,0,0,2,236,192,16,128,21,36,128,20,194,63,192,0,
  128,2,48,128,21,224,128,20,113,222,144,130,0,192,208,128,21,42,0,0,1,0,64,145,30,160,130,176,193,16,128,21,
  36,128,20,242,0,0,208,128,21,42,0,0,128,0,21,20,0,0,2,0,192,0,128,5,121,222,145,193,222,148,130,176,
  193,16,128,21,36,128,20,242,0,0,208,128,21,42,0,0,1,0,64,130,2,192,241,28,168,201,28,160,134,2,192,157,
  29,168,201,28,160,66,5,192,241,28,168,194,4,192,241,28,168,201,28,160,194,2,192,241,28,168,130,2,192,241,28,168,
  66,2,192,241,28,168,194,253,255,241,28,168,66,253,255,241,28,168,201,28,160,194,2,192,241,28,168,130,2,192,241,28,
  168,66,2,192,241,28,168,66,0,192,241,28,168,194,255,255,241,28,168,130,253,255,241,28,168,201,28,160,130,2,192,241,
  28,168,66,0,192,241,28,168,194,255,255,241,28,168,130,253,255,241,28,168,198,2,192,157,29,168,70,2,192,157,29,168,
  198,253,255,157,29,168,70,253,255,157,29,168,201,28,160,194,2,192,241,28,168,66,2,192,241,28,168,194,253,255,241,28,
  168,66,253,255,241,28,168,134,2,192,157,29,168,70,0,192,157,29,168,198,255,255,157,29,168,134,253,255,157,29,168,201,
  28,160,201,28,160,130,2,192,109,29,168,201,28,160,134,2,192,117,30,168,201,28,160,66,5,192,109,29,168,194,4,192,
  109,29,168,201,28,160,194,2,192,241,28,168,130,2,192,109,29,168,66,2,192,109,29,168,194,253,255,109,29,168,66,253,
  255,241,28,168,201,28,160,194,2,192,109,29,168,130,2,192,241,28,168,66,2,192,109,29,168,194,253,255,109,29,168,66,
  253,255,109,29,168,201,28,160,194,2,192,109,29,168,130,2,192,109,29,168,66,2,192,241,28,168,194,253,255,241,28,168,
  66,253,255,109,29,168,201,28,160,194,2,192,109,29,168,130,2,192,109,29,168,66,2,192,109,29,168,194,253,255,109,29,
  168,66,253,255,109,29,168,201,28,160,194,2,192,241,28,168,130,2,192,109,29,168,66,2,192,109,29,168,66,0,192,109,
  29,168,194,255,255,109,29,168,130,253,255,109,29,168,201,28,160,194,2,192,109,29,168,130,2,192,241,28,168,66,2,192,
  109,29,168,66,0,192,109,29,168,194,255,255,109,29,168,130,253,255,241,28,168,201,28,160,194,2,192,109,29,168,130,2,
  192,109,29,168,66,2,192,241,28,168,66,0,192,109,29,168,194,255,255,109,29,168,130,253,255,109,29,168,201,28,160,194,
  2,192,109,29,168,130,2,192,109,29,168,66,2,192,109,29,168,66,0,192,241,28,168,194,255,255,241,28,168,130,253,255,
  109,29,168,201,28,160,130,2,192,109,29,168,66,0,192,109,29,168,194,255,255,109,29,168,130,253,255,109,29,168,198,2,
  192,157,29,168,70,2,192,117,30,168,198,253,255,117,30,168,70,253,255,157,29,168,201,28,160,130,2,192,241,28,168,66,
  0,192,109,29,168,194,255,255,109,29,168,130,253,255,241,28,168,198,2,192,117,30,168,70,2,192,117,30,168,198,253,255,
  117,30,168,70,253,255,117,30,168,201,28,160,130,2,192,109,29,168,66,0,192,109,29,168,194,255,255,109,29,168,130,253,
  255,109,29,168,198,2,192,117,30,168,70,2,192,157,29,168,198,253,255,157,29,168,70,253,255,117,30,168,201,28,160,130,
  2,192,109,29,168,66,0,192,241,28,168,194,255,255,241,28,168,130,253,255,109,29,168,198,2,192,117,30,168,70,2,192,
  117,30,168,198,253,255,117,30,168,70,253,255,117,30,168,201,28,160,194,2,192,241,28,168,66,2,192,109,29,168,194,253,
  255,109,29,168,66,253,255,241,28,168,134,2,192,117,30,168,70,0,192,117,30,168,198,255,255,117,30,168,134,253,255,117,
  30,168,201,28,160,194,2,192,109,29,168,66,2,192,109,29,168,194,253,255,109,29,168,66,253,255,109,29,168,134,2,192,
  157,29,168,70,0,192,117,30,168,198,255,255,117,30,168,134,253,255,157,29,168,201,28,160,194,2,192,109,29,168,66,2,
  192,241,28,168,194,253,255,241,28,168,66,253,255,109,29,168,134,2,192,117,30,168,70,0,192,117,30,168,198,255,255,117,
  30,168,134,253,255,117,30,168,201,28,160,194,2,192,109,29,168,66,2,192,109,29,168,194,253,255,109,29,168,66,253,255,
  109,29,168,134,2,192,117,30,168,70,0,192,157,29,168,198,255,255,157,29,168,134,253,255,117,30,168,201,28,160,10,0,
  192,196,32,192,1,48,193,0,0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,
  0,0,96,128,20,196,245,193,47,0,0,196,34,192,1,48,193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,
  0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,196,247,193,47,0,0,4,33,192,1,53,193,0,0,5,21,0,
  0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,4,246,193,47,0,0,4,
  35,192,1,53,193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,
  96,128,20,4,248,193,47,0,0,68,33,192,129,54,193,0,0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,
  9,21,0,0,98,0,8,21,0,0,96,128,20,68,246,193,47,0,0,68,35,192,129,54,193,0,0,5,21,0,0,210,
  0,0,96,128,20,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,68,248,193,47,0,0,132,33,192,
  1,56,193,0,0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,
  20,132,246,193,47,0,0,132,35,192,1,56,193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,0,0,9,21,
  0,0,98,0,8,21,0,0,96,128,20,132,248,193,47,0,0,196,33,192,129,57,193,0,0,5,21,0,0,210,0,0,
  96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,196,246,193,47,0,0,196,35,192,129,57,
  193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,196,
  248,193,47,0,0,4,34,192,1,59,193,0,0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,
  98,0,8,21,0,0,96,128,20,4,247,193,47,0,0,4,36,192,1,59,193,0,0,5,21,0,0,210,0,0,96,128,
  20,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,4,249,193,47,0,0,68,34,192,1,60,193,0,
  0,5,21,0,0,210,0,0,96,128,21,42,0,0,0,0,9,21,0,0,98,0,8,21,0,0,96,128,20,68,247,193,
  47,0,0,68,36,192,1,60,193,0,0,5,21,0,0,210,0,0,96,128,20,42,0,0,0,0,9,21,0,0,98,0,
  8,21,0,0,96,128,20,68,249,193,47,0,0,209,0,0,16,0,21,16,0,21,16,0,21,26,0,0,132,247,193,15,
  0,192,132,249,193,15,0,192,78,5,192,4,0,0,2,0,192,0,128,5,22,200,145,22,200,148,130,7,192,0,128,2,
  0,128,11,35,0,0,2,44,193,48,128,21,37,128,20,96,128,21,62,135,145,130,170,192,0,128,21,36,128,20,2,228,
  192,240,128,21,37,128,20,97,0,0,106,7,160,130,170,192,0,128,21,36,128,20,2,228,192,240,128,21,37,128,20,97,
  0,0,16,0,21,16,0,21,96,0,21,0,0,11,2,36,193,48,128,21,37,128,20,96,0,21,29,0,0,0,0,11,
  0,0,11,0,0,11,2,40,193,48,128,21,37,128,20,96,0,21,130,3,192,48,128,18,0,128,11,35,0,0,4,0,
  0,2,8,192,0,128,2,234,135,145,194,247,193,48,128,21,36,0,0,0,0,5,194,143,193,0,128,21,36,128,20,31,
  0,0,209,0,0,224,0,21,26,0,0,22,8,160,194,245,193,48,128,21,36,0,0,0,0,5,194,143,193,0,128,21,
  36,128,20,31,0,0,209,0,0,224,0,20,26,0,0,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,230,6,
  145,196,37,192,223,0,0,0,0,64,78,5,192,4,0,0,2,0,192,0,128,5,58,202,148,2,105,192,0,128,21,36,
  128,20,2,192,255,241,128,18,32,0,19,0,128,15,26,0,0,22,0,0,132,244,193,47,0,0,194,137,192,0,128,21,
  36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,29,0,0,19,0,0,196,244,193,47,0,0,66,78,193,0,128,
  21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,4,245,193,31,0,0,68,245,193,47,0,0,4,0,0,241,
  0,0,0,0,15,0,0,12,4,245,193,242,0,12,0,128,12,47,0,0,68,245,193,242,0,12,0,128,12,47,0,0,
  4,245,193,241,0,0,32,0,20,86,73,144,150,73,145,68,245,193,65,255,255,0,0,5,58,9,144,209,0,0,196,244,
  193,0,0,4,26,0,0,62,9,144,10,0,192,129,0,0,48,0,20,22,0,0,2,10,144,6,0,192,2,10,160,4,
  245,193,65,255,255,0,0,5,122,9,144,225,0,0,132,244,193,0,0,4,29,0,0,126,9,144,13,0,192,49,0,0,
  128,0,20,19,0,0,2,10,144,3,0,192,2,10,160,209,0,0,196,244,193,0,0,4,26,0,0,174,9,144,10,0,
  192,225,0,0,132,244,193,0,0,4,29,0,0,198,9,144,13,0,192,65,255,255,208,0,21,218,73,144,10,0,192,13,
  0,192,129,0,0,224,0,20,22,0,0,238,9,144,6,0,192,49,0,0,208,0,20,19,0,0,2,10,144,3,0,192,
  226,0,0,209,128,15,32,0,17,2,236,192,0,128,21,36,128,20,31,0,0,49,0,0,0,0,15,128,0,17,194,12,
  193,0,128,21,36,128,20,31,0,0,1,0,0,0,0,9,30,0,0,130,27,192,0,128,20,62,136,145,0,0,64,196,
  252,193,15,0,192,4,253,193,15,0,192,196,36,192,254,0,0,10,1,192,2,111,193,0,128,21,36,128,20,2,192,255,
  0,128,2,142,138,145,138,3,192,68,253,193,223,0,0,66,253,255,0,128,21,36,128,20,0,128,5,118,203,148,66,108,
  193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,192,48,128,21,218,138,148,2,
  0,192,131,1,192,33,0,0,48,128,20,238,202,144,129,1,192,66,253,255,0,128,21,36,128,20,0,128,5,26,203,145,
  195,1,192,48,0,21,2,16,192,0,128,2,26,139,145,48,0,21,130,151,193,16,128,21,37,128,20,98,0,0,196,252,
  193,0,128,5,47,0,0,66,253,255,0,128,21,36,128,20,2,16,192,0,128,2,118,139,145,66,108,193,0,128,21,36,
  128,20,2,192,255,0,128,2,118,139,145,68,253,193,194,1,192,0,128,5,47,0,0,130,253,255,0,128,21,36,128,20,
  0,128,5,86,204,148,130,108,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,
  192,48,128,21,186,139,148,2,0,192,131,1,192,33,0,0,48,128,20,206,203,144,129,1,192,130,253,255,0,128,21,36,
  128,20,0,128,5,250,203,145,195,1,192,48,0,21,2,16,192,0,128,2,250,139,145,48,0,21,130,151,193,16,128,21,
  37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,130,253,255,0,128,21,36,128,20,2,16,192,0,128,2,86,140,
  145,130,108,193,0,128,21,36,128,20,2,192,255,0,128,2,86,140,145,68,253,193,194,1,192,0,128,5,47,0,0,194,
  253,255,0,128,21,36,128,20,0,128,5,54,205,148,194,108,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,
  0,128,15,16,128,20,195,0,192,48,128,21,154,140,148,2,0,192,131,1,192,33,0,0,48,128,20,174,204,144,129,1,
  192,194,253,255,0,128,21,36,128,20,0,128,5,218,204,145,195,1,192,48,0,21,2,16,192,0,128,2,218,140,145,48,
  0,21,130,151,193,16,128,21,37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,194,253,255,0,128,21,36,128,20,
  2,16,192,0,128,2,54,141,145,194,108,193,0,128,21,36,128,20,2,192,255,0,128,2,54,141,145,68,253,193,194,1,
  192,0,128,5,47,0,0,194,255,255,0,128,21,36,128,20,0,128,5,22,206,148,194,110,193,0,128,21,36,128,20,2,
  192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,192,48,128,21,122,141,148,2,0,192,131,1,192,33,0,0,
  48,128,20,142,205,144,129,1,192,194,255,255,0,128,21,36,128,20,0,128,5,186,205,145,195,1,192,48,0,21,2,16,
  192,0,128,2,186,141,145,48,0,21,194,156,193,16,128,21,37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,194,
  255,255,0,128,21,36,128,20,2,16,192,0,128,2,22,142,145,194,110,193,0,128,21,36,128,20,2,192,255,0,128,2,
  22,142,145,68,253,193,66,1,192,0,128,5,47,0,0,66,0,192,0,128,21,36,128,20,0,128,5,246,206,148,66,111,
  193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,192,48,128,21,90,142,148,2,
  0,192,131,1,192,33,0,0,48,128,20,110,206,144,129,1,192,66,0,192,0,128,21,36,128,20,0,128,5,154,206,145,
  195,1,192,48,0,21,2,16,192,0,128,2,154,142,145,48,0,21,194,156,193,16,128,21,37,128,20,98,0,0,196,252,
  193,0,128,5,47,0,0,66,0,192,0,128,21,36,128,20,2,16,192,0,128,2,246,142,145,66,111,193,0,128,21,36,
  128,20,2,192,255,0,128,2,246,142,145,68,253,193,66,1,192,0,128,5,47,0,0,66,2,192,0,128,21,36,128,20,
  0,128,5,214,207,148,66,113,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,
  192,48,128,21,58,143,148,2,0,192,131,1,192,33,0,0,48,128,20,78,207,144,129,1,192,66,2,192,0,128,21,36,
  128,20,0,128,5,122,207,145,195,1,192,48,0,21,2,16,192,0,128,2,122,143,145,48,0,21,2,162,193,16,128,21,
  37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,66,2,192,0,128,21,36,128,20,2,16,192,0,128,2,214,143,
  145,66,113,193,0,128,21,36,128,20,2,192,255,0,128,2,214,143,145,68,253,193,194,0,192,0,128,5,47,0,0,130,
  2,192,0,128,21,36,128,20,0,128,5,182,208,148,130,113,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,
  0,128,15,16,128,20,195,0,192,48,128,21,26,144,148,2,0,192,131,1,192,33,0,0,48,128,20,46,208,144,129,1,
  192,130,2,192,0,128,21,36,128,20,0,128,5,90,208,145,195,1,192,48,0,21,2,16,192,0,128,2,90,144,145,48,
  0,21,2,162,193,16,128,21,37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,130,2,192,0,128,21,36,128,20,
  2,16,192,0,128,2,182,144,145,130,113,193,0,128,21,36,128,20,2,192,255,0,128,2,182,144,145,68,253,193,194,0,
  192,0,128,5,47,0,0,194,2,192,0,128,21,36,128,20,0,128,5,150,209,148,194,113,193,0,128,21,36,128,20,2,
  192,255,241,128,18,32,0,19,0,128,15,16,128,20,195,0,192,48,128,21,250,144,148,2,0,192,131,1,192,33,0,0,
  48,128,20,14,209,144,129,1,192,194,2,192,0,128,21,36,128,20,0,128,5,58,209,145,195,1,192,48,0,21,2,16,
  192,0,128,2,58,145,145,48,0,21,2,162,193,16,128,21,37,128,20,98,0,0,196,252,193,0,128,5,47,0,0,194,
  2,192,0,128,21,36,128,20,2,16,192,0,128,2,150,145,145,194,113,193,0,128,21,36,128,20,2,192,255,0,128,2,
  150,145,145,68,253,193,194,0,192,0,128,5,47,0,0,4,37,192,254,0,0,13,1,192,2,111,193,0,128,21,36,128,
  20,194,63,192,0,128,2,190,145,145,141,3,192,132,253,193,239,0,0,194,2,192,0,128,21,36,128,20,0,128,5,166,
  210,148,194,113,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,
  10,18,148,1,0,192,131,1,192,18,0,0,48,128,20,30,210,144,129,1,192,194,2,192,0,128,21,36,128,20,0,128,
  5,74,210,145,195,1,192,48,0,21,2,8,192,0,128,2,74,146,145,48,0,21,130,151,193,16,128,21,37,128,20,98,
  0,0,4,253,193,0,128,5,47,0,0,194,2,192,0,128,21,36,128,20,2,8,192,0,128,2,166,146,145,194,113,193,
  0,128,21,36,128,20,194,63,192,0,128,2,166,146,145,132,253,193,194,1,192,0,128,5,47,0,0,130,2,192,0,128,
  21,36,128,20,0,128,5,134,211,148,130,113,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,
  0,20,195,0,192,48,0,21,234,18,148,1,0,192,131,1,192,18,0,0,48,128,20,254,210,144,129,1,192,130,2,192,
  0,128,21,36,128,20,0,128,5,42,211,145,195,1,192,48,0,21,2,8,192,0,128,2,42,147,145,48,0,21,130,151,
  193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,47,0,0,130,2,192,0,128,21,36,128,20,2,8,192,0,
  128,2,134,147,145,130,113,193,0,128,21,36,128,20,194,63,192,0,128,2,134,147,145,132,253,193,194,1,192,0,128,5,
  47,0,0,66,2,192,0,128,21,36,128,20,0,128,5,102,212,148,66,113,193,0,128,21,36,128,20,2,192,255,241,128,
  18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,202,19,148,1,0,192,131,1,192,18,0,0,48,128,20,222,
  211,144,129,1,192,66,2,192,0,128,21,36,128,20,0,128,5,10,212,145,195,1,192,48,0,21,2,8,192,0,128,2,
  10,148,145,48,0,21,130,151,193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,47,0,0,66,2,192,0,128,
  21,36,128,20,2,8,192,0,128,2,102,148,145,66,113,193,0,128,21,36,128,20,194,63,192,0,128,2,102,148,145,132,
  253,193,194,1,192,0,128,5,47,0,0,66,0,192,0,128,21,36,128,20,0,128,5,70,213,148,66,111,193,0,128,21,
  36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,170,20,148,1,0,192,131,1,
  192,18,0,0,48,128,20,190,212,144,129,1,192,66,0,192,0,128,21,36,128,20,0,128,5,234,212,145,195,1,192,48,
  0,21,2,8,192,0,128,2,234,148,145,48,0,21,194,156,193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,
  47,0,0,66,0,192,0,128,21,36,128,20,2,8,192,0,128,2,70,149,145,66,111,193,0,128,21,36,128,20,194,63,
  192,0,128,2,70,149,145,132,253,193,66,1,192,0,128,5,47,0,0,194,255,255,0,128,21,36,128,20,0,128,5,38,
  214,148,194,110,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,
  138,21,148,1,0,192,131,1,192,18,0,0,48,128,20,158,213,144,129,1,192,194,255,255,0,128,21,36,128,20,0,128,
  5,202,213,145,195,1,192,48,0,21,2,8,192,0,128,2,202,149,145,48,0,21,194,156,193,16,128,21,37,128,20,98,
  0,0,4,253,193,0,128,5,47,0,0,194,255,255,0,128,21,36,128,20,2,8,192,0,128,2,38,150,145,194,110,193,
  0,128,21,36,128,20,194,63,192,0,128,2,38,150,145,132,253,193,66,1,192,0,128,5,47,0,0,194,253,255,0,128,
  21,36,128,20,0,128,5,6,215,148,194,108,193,0,128,21,36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,
  0,20,195,0,192,48,0,21,106,22,148,1,0,192,131,1,192,18,0,0,48,128,20,126,214,144,129,1,192,194,253,255,
  0,128,21,36,128,20,0,128,5,170,214,145,195,1,192,48,0,21,2,8,192,0,128,2,170,150,145,48,0,21,2,162,
  193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,47,0,0,194,253,255,0,128,21,36,128,20,2,8,192,0,
  128,2,6,151,145,194,108,193,0,128,21,36,128,20,194,63,192,0,128,2,6,151,145,132,253,193,194,0,192,0,128,5,
  47,0,0,130,253,255,0,128,21,36,128,20,0,128,5,230,215,148,130,108,193,0,128,21,36,128,20,2,192,255,241,128,
  18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,74,23,148,1,0,192,131,1,192,18,0,0,48,128,20,94,
  215,144,129,1,192,130,253,255,0,128,21,36,128,20,0,128,5,138,215,145,195,1,192,48,0,21,2,8,192,0,128,2,
  138,151,145,48,0,21,2,162,193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,47,0,0,130,253,255,0,128,
  21,36,128,20,2,8,192,0,128,2,230,151,145,130,108,193,0,128,21,36,128,20,194,63,192,0,128,2,230,151,145,132,
  253,193,194,0,192,0,128,5,47,0,0,66,253,255,0,128,21,36,128,20,0,128,5,198,216,148,66,108,193,0,128,21,
  36,128,20,2,192,255,241,128,18,32,0,19,0,128,15,32,0,20,195,0,192,48,0,21,42,24,148,1,0,192,131,1,
  192,18,0,0,48,128,20,62,216,144,129,1,192,66,253,255,0,128,21,36,128,20,0,128,5,106,216,145,195,1,192,48,
  0,21,2,8,192,0,128,2,106,152,145,48,0,21,2,162,193,16,128,21,37,128,20,98,0,0,4,253,193,0,128,5,
  47,0,0,66,253,255,0,128,21,36,128,20,2,8,192,0,128,2,198,152,145,66,108,193,0,128,21,36,128,20,194,63,
  192,0,128,2,198,152,145,132,253,193,194,0,192,0,128,5,47,0,0,4,253,193,241,0,0,16,0,21,16,0,21,16,
  0,21,26,0,0,132,253,193,241,0,0,18,0,0,3,4,192,48,128,20,250,216,144,1,4,192,2,0,192,16,128,21,
  37,128,20,109,0,0,1,0,192,0,0,37,68,39,192,31,0,0,196,252,193,241,0,0,16,0,21,16,0,21,16,0,
  21,26,0,0,68,253,193,241,0,0,18,0,0,3,4,192,48,128,20,78,217,144,1,4,192,2,0,192,16,128,21,37,
  128,20,109,0,0,68,39,192,241,0,0,0,0,36,68,39,192,31,0,0,0,0,64,132,37,192,15,0,192,196,37,192,
  15,0,192,10,0,192,4,37,192,241,0,0,16,0,18,74,90,145,65,72,192,194,32,192,3,0,192,20,0,9,63,128,
  8,166,153,145,65,5,192,20,0,0,2,16,192,0,128,2,242,217,145,2,0,224,30,128,17,38,0,0,130,7,192,0,
  128,2,0,128,11,67,167,193,48,128,21,37,0,0,104,0,0,0,0,128,0,0,9,130,27,192,16,128,20,182,153,145,
  4,37,192,241,0,0,66,72,192,16,128,21,36,128,20,193,63,192,0,0,2,54,90,145,132,37,192,31,0,0,210,0,
  0,0,128,9,42,0,0,130,0,192,208,128,20,74,154,145,132,37,192,207,255,255,0,0,64,197,104,192,193,32,192,84,
  1,0,242,0,0,0,128,15,47,0,8,86,26,145,0,0,64,48,0,21,66,72,192,16,128,21,36,128,20,143,0,0,
  20,0,0,242,0,0,32,128,18,162,218,145,2,15,192,0,128,4,246,218,145,1,0,64,48,0,21,66,72,192,16,128,
  21,36,128,20,2,0,224,0,128,1,47,0,0,20,0,0,242,0,0,32,128,18,162,218,145,2,15,192,0,128,4,18,
  155,145,210,0,0,0,128,9,42,0,0,132,37,192,15,0,0,196,37,192,63,0,0,48,0,21,66,72,192,16,128,21,
  36,128,20,2,0,224,0,128,1,47,0,0,1,0,64,194,69,192,16,128,21,36,128,20,143,0,0,242,25,160,131,253,
  255,110,26,168,242,25,160,2,67,192,16,128,21,36,128,20,143,0,0,130,67,192,16,128,21,36,128,20,143,0,0,242,
  25,160,130,69,192,16,128,21,36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,2,70,192,16,128,21,
  36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,2,75,192,16,128,21,36,128,20,143,0,0,242,25,
  160,130,69,192,16,128,21,36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,2,70,192,16,128,21,36,
  128,20,143,0,0,2,72,192,16,128,21,36,128,20,143,0,0,130,72,192,16,128,21,36,128,20,143,0,0,194,74,192,
  16,128,21,36,128,20,143,0,0,242,25,160,194,69,192,16,128,21,36,128,20,143,0,0,2,72,192,16,128,21,36,128,
  20,143,0,0,130,72,192,16,128,21,36,128,20,143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,67,253,255,110,
  26,168,195,253,255,110,26,168,67,2,192,110,26,168,195,2,192,110,26,168,242,25,160,130,69,192,16,128,21,36,128,20,
  143,0,0,2,70,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,2,75,192,16,128,
  21,36,128,20,143,0,0,131,253,255,110,26,168,195,255,255,110,26,168,67,0,192,110,26,168,131,2,192,110,26,168,242,
  25,160,130,69,192,16,128,21,36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,2,70,192,16,128,21,
  36,128,20,143,0,0,2,72,192,16,128,21,36,128,20,143,0,0,130,72,192,16,128,21,36,128,20,143,0,0,130,74,
  192,16,128,21,36,128,20,143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,2,75,192,16,128,21,36,128,20,143,
  0,0,242,25,160,132,37,192,15,0,192,196,37,192,15,0,192,10,0,192,196,36,192,241,0,0,16,0,18,50,94,145,
  65,72,192,194,32,192,3,0,192,20,0,9,63,128,8,142,157,145,65,5,192,20,0,0,2,8,192,0,128,2,218,221,
  145,2,0,224,30,128,17,38,0,0,130,7,192,0,128,2,0,128,11,3,171,193,48,128,21,37,0,0,104,0,0,0,
  0,128,0,0,9,130,27,192,16,128,20,158,157,145,196,36,192,241,0,0,66,72,192,16,128,21,36,128,20,193,63,192,
  0,0,2,30,94,145,132,37,192,31,0,0,210,0,0,0,128,9,42,0,0,130,0,192,208,128,20,50,158,145,132,37,
  192,207,255,255,0,0,64,48,0,21,66,72,192,16,128,21,36,128,20,143,0,0,20,0,0,242,0,0,32,128,18,106,
  222,145,2,23,192,0,128,4,190,222,145,1,0,64,48,0,21,66,72,192,16,128,21,36,128,20,2,0,224,0,128,1,
  47,0,0,20,0,0,242,0,0,32,128,18,106,222,145,2,23,192,0,128,4,218,158,145,210,0,0,0,128,9,42,0,
  0,132,37,192,15,0,0,196,37,192,63,0,0,48,0,21,66,72,192,16,128,21,36,128,20,2,0,224,0,128,1,47,
  0,0,1,0,64,194,74,192,16,128,21,36,128,20,143,0,0,218,29,160,131,2,192,54,30,168,218,29,160,130,77,192,
  16,128,21,36,128,20,143,0,0,2,77,192,16,128,21,36,128,20,143,0,0,218,29,160,2,75,192,16,128,21,36,128,
  20,143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,2,70,192,16,
  128,21,36,128,20,143,0,0,130,69,192,16,128,21,36,128,20,143,0,0,218,29,160,2,75,192,16,128,21,36,128,20,
  143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,130,72,192,16,128,
  21,36,128,20,143,0,0,2,72,192,16,128,21,36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,218,
  29,160,194,74,192,16,128,21,36,128,20,143,0,0,130,72,192,16,128,21,36,128,20,143,0,0,2,72,192,16,128,21,
  36,128,20,143,0,0,194,69,192,16,128,21,36,128,20,143,0,0,195,2,192,54,30,168,67,2,192,54,30,168,195,253,
  255,54,30,168,67,253,255,54,30,168,218,29,160,2,75,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,
  128,20,143,0,0,2,70,192,16,128,21,36,128,20,143,0,0,130,69,192,16,128,21,36,128,20,143,0,0,131,2,192,
  54,30,168,67,0,192,54,30,168,195,255,255,54,30,168,131,253,255,54,30,168,218,29,160,2,75,192,16,128,21,36,128,
  20,143,0,0,194,74,192,16,128,21,36,128,20,143,0,0,130,74,192,16,128,21,36,128,20,143,0,0,130,72,192,16,
  128,21,36,128,20,143,0,0,2,72,192,16,128,21,36,128,20,143,0,0,2,70,192,16,128,21,36,128,20,143,0,0,
  194,69,192,16,128,21,36,128,20,143,0,0,130,69,192,16,128,21,36,128,20,143,0,0,218,29,160,129,39,192,194,32,
  192,3,0,192,20,0,9,63,128,8,51,129,145,196,36,192,241,0,0,16,0,18,195,65,145,67,253,255,14,13,192,13,
  8,192,199,1,168,43,2,168,195,253,255,14,13,192,13,24,192,199,1,168,195,255,255,14,14,192,13,32,192,199,1,168,
  67,0,192,14,14,192,13,32,192,199,1,168,67,2,192,14,13,192,13,24,192,199,1,168,131,2,192,14,14,192,13,16,
  192,199,1,168,195,2,192,14,13,192,13,8,192,199,1,168,0,0,64,196,36,192,241,0,0,2,0,192,48,0,21,20,
  0,0,0,128,5,211,193,145,2,16,192,0,128,2,39,194,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,
  247,193,145,2,63,192,0,128,2,0,128,20,39,130,145,130,39,192,208,128,21,36,128,20,239,0,0,0,0,64,131,253,
  255,14,14,192,196,36,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,63,194,145,2,16,192,0,128,2,159,
  194,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,99,194,145,2,9,192,0,128,4,143,194,145,2,63,192,
  0,128,2,0,128,20,159,130,145,130,39,192,208,128,21,36,128,20,15,16,192,0,0,64,129,39,192,194,32,192,3,0,
  192,20,0,9,63,128,8,175,130,145,4,37,192,241,0,0,16,0,18,63,67,145,195,2,192,14,21,192,13,8,192,67,
  3,168,167,3,168,67,2,192,14,21,192,13,24,192,67,3,168,67,0,192,14,22,192,13,32,192,67,3,168,195,255,255,
  14,22,192,13,32,192,67,3,168,195,253,255,14,21,192,13,24,192,67,3,168,131,253,255,14,22,192,13,16,192,67,3,
  168,67,253,255,14,21,192,13,8,192,67,3,168,0,0,64,4,37,192,241,0,0,2,0,192,48,0,21,20,0,0,0,
  128,5,79,195,145,2,8,192,0,128,2,163,195,145,26,0,0,2,0,192,48,0,21,20,0,0,0,128,5,115,195,145,
  2,63,192,0,128,2,0,128,20,163,131,145,130,39,192,208,128,21,36,128,20,239,0,0,0,0,64,131,2,192,14,14,
  192,4,37,192,241,0,0,2,0,192,48,0,21,20,0,0,0,128,5,187,195,145,2,8,192,0,128,2,27,196,145,26,
  0,0,2,0,192,48,0,21,20,0,0,0,128,5,223,195,145,2,17,192,0,128,4,11,196,145,2,63,192,0,128,2,
  0,128,20,27,132,145,130,39,192,208,128,21,36,128,20,15,16,192,0,0,64,132,37,192,250,0,0,65,5,192,20,0,
  0,2,8,192,0,128,2,119,196,145,130,39,192,16,128,21,36,128,20,0,128,5,119,132,145,30,0,0,20,0,0,130,
  7,192,0,128,2,0,128,11,195,174,193,48,128,21,37,0,0,104,0,0,0,0,128,0,0,9,130,27,192,16,128,20,
  43,132,145,132,37,192,15,0,192,0,0,64,132,37,192,79,0,192,0,0,64,194,2,192,16,128,21,208,128,20,147,196,
  145,130,2,192,16,128,21,208,128,20,147,196,145,66,2,192,16,128,21,208,128,20,147,196,145,194,253,255,16,128,21,208,
  128,20,147,196,145,66,253,255,16,128,21,208,128,20,147,196,145,119,4,160,130,2,192,16,128,21,208,128,20,147,196,145,
  66,0,192,16,128,21,208,128,20,147,196,145,194,255,255,16,128,21,208,128,20,147,196,145,130,253,255,16,128,21,208,128,
  20,147,196,145,195,2,192,2,0,192,48,0,21,20,0,0,0,128,5,59,197,145,208,0,20,147,68,145,1,0,0,67,
  2,192,2,0,192,48,0,21,20,0,0,0,128,5,95,197,145,208,0,20,147,68,145,1,0,0,195,253,255,2,0,192,
  48,0,21,20,0,0,0,128,5,131,197,145,208,0,20,147,68,145,1,0,0,67,253,255,2,0,192,48,0,21,20,0,
  0,0,128,5,167,197,145,208,0,20,147,68,145,1,0,0,119,4,160,66,5,192,16,128,21,208,128,20,147,196,145,194,
  4,192,16,128,21,208,128,20,147,196,145,119,4,160,194,2,192,16,128,21,208,128,20,147,196,145,66,2,192,16,128,21,
  208,128,20,147,196,145,66,0,192,16,128,21,208,128,20,147,196,145,194,255,255,16,128,21,208,128,20,147,196,145,130,253,
  255,16,128,21,208,128,20,147,196,145,130,2,192,16,128,21,208,128,20,147,196,145,119,4,160,194,2,192,16,128,21,208,
  128,20,147,196,145,66,2,192,16,128,21,208,128,20,147,196,145,194,253,255,16,128,21,208,128,20,147,196,145,66,253,255,
  16,128,21,208,128,20,147,196,145,67,0,192,2,0,192,48,0,21,20,0,0,0,128,5,151,198,145,208,0,20,147,68,
  145,1,0,0,195,255,255,2,0,192,48,0,21,20,0,0,0,128,5,187,198,145,208,0,20,147,68,145,1,0,0,131,
  253,255,2,0,192,48,0,21,20,0,0,0,128,5,223,198,145,208,0,20,147,68,145,1,0,0,131,2,192,2,0,192,
  48,0,21,20,0,0,0,128,5,3,199,145,208,0,20,147,68,145,1,0,0,119,4,160,163,2,168,118,25,168,132,37,
  192,242,0,0,32,128,18,219,200,145,79,199,148,196,37,192,242,0,0,32,128,18,219,136,145,4,37,192,254,0,0,194,
  2,192,0,128,21,36,128,20,2,40,192,0,128,2,131,135,145,2,75,192,0,128,21,36,128,20,0,128,5,219,200,145,
  130,2,192,0,128,21,36,128,20,2,40,192,0,128,2,175,135,145,194,74,192,0,128,21,36,128,20,0,128,5,219,200,
  145,66,2,192,0,128,21,36,128,20,2,40,192,0,128,2,219,135,145,130,74,192,0,128,21,36,128,20,0,128,5,219,
  200,145,66,0,192,0,128,21,36,128,20,2,40,192,0,128,2,7,136,145,130,72,192,0,128,21,36,128,20,0,128,5,
  219,200,145,194,255,255,0,128,21,36,128,20,2,40,192,0,128,2,51,136,145,2,72,192,0,128,21,36,128,20,0,128,
  5,219,200,145,194,253,255,0,128,21,36,128,20,2,40,192,0,128,2,95,136,145,2,70,192,0,128,21,36,128,20,0,
  128,5,219,200,145,130,253,255,0,128,21,36,128,20,2,40,192,0,128,2,139,136,145,194,69,192,0,128,21,36,128,20,
  0,128,5,219,200,145,66,253,255,0,128,21,36,128,20,2,40,192,0,128,2,183,136,145,130,69,192,0,128,21,36,128,
  20,0,128,5,219,200,145,132,37,192,242,0,0,32,128,18,207,200,148,31,4,168,0,0,64,132,37,192,15,0,192,0,
  0,64,132,37,192,79,0,192,0,0,64,1,105,192,194,32,192,3,0,192,20,0,9,63,128,8,243,136,145,193,137,192,
  194,32,192,3,0,192,20,0,9,63,128,8,11,137,145,4,37,192,241,0,0,16,0,18,95,74,145,195,2,192,10,8,
  192,13,8,192,14,21,192,99,10,168,203,10,168,67,2,192,10,8,192,13,24,192,14,21,192,99,10,168,67,0,192,10,
  16,192,13,32,192,14,22,192,99,10,168,195,255,255,10,16,192,13,32,192,14,22,192,99,10,168,195,253,255,10,8,192,
  13,24,192,14,21,192,99,10,168,131,253,255,10,16,192,13,16,192,14,22,192,99,10,168,67,253,255,10,8,192,13,8,
  192,14,21,192,99,10,168,4,37,192,241,0,0,66,110,192,16,128,21,36,128,20,15,1,192,194,109,192,16,128,21,36,
  128,20,15,1,192,194,107,192,16,128,21,36,128,20,15,14,192,66,107,192,16,128,21,36,128,20,15,14,192,130,107,192,
  16,128,21,36,128,20,207,22,192,66,105,192,16,128,21,36,128,20,15,20,192,194,104,192,16,128,21,36,128,20,15,20,
  192,130,102,192,16,128,21,36,128,20,15,20,192,194,102,192,16,128,21,36,128,20,15,10,192,66,102,192,16,128,21,36,
  128,20,15,10,192,0,0,64,4,37,192,241,0,0,48,0,21,2,105,192,16,128,21,36,128,20,223,0,0,20,0,0,
  0,128,5,107,202,145,199,202,148,22,0,0,48,0,21,20,0,0,242,0,0,32,128,18,147,202,145,2,63,192,0,128,
  2,0,128,20,199,138,145,194,137,192,128,128,21,36,128,20,239,0,0,0,0,64,131,2,192,14,14,192,4,37,192,241,
  0,0,48,0,21,2,105,192,16,128,21,36,128,20,143,16,192,20,0,0,0,128,5,219,202,145,67,203,148,22,0,0,
  2,0,192,48,0,21,20,0,0,0,128,5,7,203,145,2,17,192,0,128,4,51,203,145,2,63,192,0,128,2,0,128,
  20,67,139,145,194,137,192,128,128,21,36,128,20,15,16,192,0,0,64,0,0,21,20,0,0,242,0,0,32,128,18,131,
  139,145,194,170,192,128,128,21,36,128,20,223,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,64,
  0,0,64,39,1,168,94,29,168,231,8,168,6,0,192,132,170,192,15,0,192,132,45,193,15,0,192,132,37,192,242,0,
  0,32,128,18,111,141,145,78,5,192,4,0,0,2,16,192,0,128,2,39,204,145,130,7,192,0,128,2,0,128,11,35,
  0,0,130,198,193,48,128,21,37,128,20,106,0,0,2,202,193,48,128,21,37,128,20,109,0,0,130,39,192,0,128,21,
  36,128,20,242,0,0,0,128,11,48,128,17,131,178,193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,
  9,30,0,0,130,27,192,16,128,20,187,139,145,4,37,192,254,0,0,4,33,192,242,0,0,32,128,18,99,204,145,74,
  0,192,129,2,192,71,11,168,68,33,192,242,0,0,32,128,18,135,204,145,138,0,192,65,5,192,71,11,168,193,4,192,
  71,11,168,132,33,192,242,0,0,32,128,18,195,204,145,202,0,192,193,2,192,71,11,168,129,2,192,71,11,168,65,2,
  192,71,11,168,193,253,255,71,11,168,65,253,255,71,11,168,196,33,192,242,0,0,32,128,18,7,205,145,10,1,192,193,
  2,192,71,11,168,129,2,192,71,11,168,65,2,192,71,11,168,65,0,192,71,11,168,193,255,255,71,11,168,129,253,255,
  71,11,168,4,34,192,242,0,0,32,128,18,59,205,145,74,1,192,193,2,192,71,11,168,65,2,192,71,11,168,193,253,
  255,71,11,168,65,253,255,71,11,168,68,34,192,242,0,0,32,128,18,111,205,145,138,1,192,129,2,192,71,11,168,65,
  0,192,71,11,168,193,255,255,71,11,168,129,253,255,71,11,168,132,37,192,143,0,0,0,0,64,194,170,192,128,128,21,
  36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,64,194,170,192,128,128,21,36,128,
  20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,64,2,105,192,16,
  128,21,36,128,20,242,0,0,208,128,82,2,105,192,16,128,21,36,128,20,242,0,0,224,128,82,2,105,192,16,128,21,
  36,128,20,242,0,0,208,128,18,123,141,145,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,251,205,145,0,0,
  64,0,0,21,20,0,0,2,48,192,0,128,2,107,142,145,231,13,168,251,205,145,130,12,192,16,128,20,99,142,144,130,
  12,192,0,128,20,251,205,144,163,13,168,251,13,160,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,155,142,145,
  231,13,168,155,206,145,130,12,192,16,128,20,163,141,144,251,13,160,0,0,64,0,0,21,20,0,0,2,48,192,0,128,
  2,199,142,145,231,13,168,251,205,145,130,12,192,16,128,20,163,141,144,0,0,64,1,0,0,215,14,160,251,13,168,48,
  0,21,20,0,0,242,0,0,32,128,18,211,206,145,2,48,192,0,128,2,251,205,145,0,0,64,1,0,0,35,15,160,
  130,12,192,16,128,20,31,207,144,231,13,168,35,207,145,163,13,168,35,15,160,251,13,168,48,0,21,20,0,0,242,0,
  0,32,128,18,3,207,145,2,48,192,0,128,2,87,143,145,130,12,192,16,128,20,251,205,144,231,13,168,163,141,145,0,
  0,64,1,0,0,130,12,192,0,128,20,175,207,144,123,15,160,231,13,168,123,207,145,163,13,168,48,0,21,20,0,0,
  242,0,0,32,128,18,111,207,145,2,48,192,0,128,2,207,143,145,231,13,168,163,141,145,0,0,64,211,13,168,123,141,
  145,48,0,21,20,0,0,242,0,0,32,128,18,167,207,145,2,48,192,0,128,2,251,205,145,0,0,64,129,253,255,111,
  14,168,39,12,160,131,253,255,1,0,0,3,16,160,130,12,192,16,128,20,3,208,144,231,13,168,3,208,145,163,13,168,
  48,0,21,20,0,0,242,0,0,32,128,18,235,207,145,2,48,192,0,128,2,63,144,145,130,12,192,16,128,20,59,208,
  144,231,13,168,59,208,145,163,13,168,251,13,168,39,12,160,193,250,255,159,14,168,65,251,255,159,14,168,39,12,160,65,
  253,255,47,14,168,193,2,192,47,14,168,129,253,255,47,14,168,193,253,255,47,14,168,65,2,192,47,14,168,39,12,160,
  65,253,255,23,14,168,129,2,192,23,14,168,129,253,255,23,14,168,193,253,255,23,14,168,193,255,255,23,14,168,65,0,
  192,23,14,168,39,12,160,67,253,255,251,14,168,195,2,192,91,15,168,195,253,255,251,14,168,67,2,192,91,15,168,39,
  12,160,129,253,255,23,14,168,193,255,255,23,14,168,65,0,192,23,14,168,129,2,192,23,14,168,67,253,255,203,14,168,
  195,2,192,203,14,168,195,253,255,203,14,168,67,2,192,203,14,168,39,12,160,131,253,255,251,14,168,131,2,192,91,15,
  168,195,255,255,91,15,168,67,0,192,91,15,168,39,12,160,65,253,255,23,14,168,193,253,255,23,14,168,65,2,192,23,
  14,168,193,2,192,23,14,168,131,253,255,203,14,168,131,2,192,203,14,168,195,255,255,203,14,168,67,0,192,203,14,168,
  39,12,160,65,253,255,47,14,168,193,2,192,47,14,168,39,12,160,129,253,255,47,14,168,39,12,160,65,253,255,23,14,
  168,39,12,160,129,253,255,23,14,168,129,2,192,23,14,168,39,12,160,193,253,255,23,14,168,39,12,160,67,253,255,251,
  14,168,195,2,192,91,15,168,39,12,160,67,253,255,203,14,168,195,2,192,203,14,168,39,12,160,129,253,255,23,14,168,
  129,2,192,23,14,168,39,12,160,193,255,255,23,14,168,65,0,192,23,14,168,39,12,160,131,253,255,251,14,168,131,2,
  192,91,15,168,39,12,160,65,253,255,23,14,168,193,2,192,23,14,168,39,12,160,131,253,255,203,14,168,131,2,192,203,
  14,168,39,12,160,193,253,255,23,14,168,65,2,192,23,14,168,39,12,160,0,0,21,20,0,0,242,0,0,32,128,18,
  175,146,145,194,170,192,128,128,21,36,128,20,223,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,
  64,0,0,64,1,0,0,227,18,160,194,170,192,128,128,21,36,128,20,223,0,0,194,45,193,128,128,21,36,128,20,130,
  0,0,31,128,9,38,0,0,48,0,21,20,0,0,242,0,0,32,128,18,187,210,145,0,0,64,96,11,168,39,1,168,
  94,29,168,231,8,168,6,0,192,132,170,192,15,0,192,132,45,193,15,0,192,132,37,192,242,0,0,32,128,18,115,149,
  145,78,5,192,4,0,0,2,16,192,0,128,2,187,211,145,194,137,192,0,128,21,36,128,20,242,0,0,68,244,193,47,
  0,0,4,0,0,130,7,192,0,128,2,0,128,11,35,0,0,130,198,193,48,128,21,37,128,20,106,0,0,2,202,193,
  48,128,21,37,128,20,109,0,0,130,39,192,0,128,21,36,128,20,242,0,0,0,128,11,48,128,17,131,205,193,48,128,
  21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,9,30,0,0,130,27,192,16,128,20,51,147,145,4,37,192,254,
  0,0,196,32,192,242,0,0,32,128,18,75,212,145,129,2,192,0,0,21,20,0,0,242,0,0,32,128,18,75,148,145,
  2,59,192,16,128,21,37,128,20,66,239,193,96,128,21,36,128,20,0,128,5,75,148,145,194,170,192,128,128,21,36,128,
  20,15,0,192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,4,33,192,242,0,0,32,128,18,103,
  212,145,74,0,192,131,2,192,179,18,168,68,33,192,242,0,0,32,128,18,139,212,145,138,0,192,65,5,192,115,18,168,
  193,4,192,115,18,168,132,33,192,242,0,0,32,128,18,199,212,145,202,0,192,193,2,192,115,18,168,129,2,192,115,18,
  168,65,2,192,115,18,168,193,253,255,115,18,168,65,253,255,115,18,168,196,33,192,242,0,0,32,128,18,11,213,145,10,
  1,192,193,2,192,115,18,168,129,2,192,115,18,168,65,2,192,115,18,168,65,0,192,115,18,168,193,255,255,115,18,168,
  129,253,255,115,18,168,4,34,192,242,0,0,32,128,18,63,213,145,74,1,192,195,2,192,179,18,168,67,2,192,179,18,
  168,195,253,255,179,18,168,67,253,255,179,18,168,68,34,192,242,0,0,32,128,18,115,213,145,138,1,192,131,2,192,179,
  18,168,67,0,192,179,18,168,195,255,255,179,18,168,131,253,255,179,18,168,132,37,192,143,0,0,0,0,64,194,170,192,
  128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,64,194,170,192,128,128,
  21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,64,2,
  105,192,16,128,21,36,128,20,242,0,0,208,128,82,2,105,192,16,128,21,36,128,20,242,0,0,224,128,82,2,105,192,
  16,128,21,36,128,20,242,0,0,208,128,18,127,149,145,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,79,150,
  145,215,21,168,127,149,145,68,244,193,242,0,0,32,128,18,79,214,145,48,128,20,127,149,145,0,0,64,0,0,21,20,
  0,0,2,48,192,0,128,2,199,150,145,68,244,193,242,0,0,32,128,18,127,214,145,48,128,20,167,150,145,235,21,168,
  255,213,145,130,12,192,16,128,20,159,150,144,130,12,192,0,128,20,255,213,144,167,21,168,255,21,160,130,12,192,16,128,
  20,191,150,144,130,12,192,0,128,20,127,213,144,167,21,168,127,21,160,0,0,64,0,0,21,20,0,0,2,48,192,0,
  128,2,47,151,145,68,244,193,242,0,0,32,128,18,247,214,145,48,128,20,19,151,145,235,21,168,47,215,145,130,12,192,
  16,128,20,255,213,144,167,21,168,255,21,160,130,12,192,16,128,20,127,213,144,167,21,168,130,7,192,16,128,20,127,213,
  144,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,139,151,145,68,244,193,242,0,0,32,128,18,111,151,145,235,
  21,168,255,213,145,130,12,192,16,128,20,167,149,144,0,0,64,130,12,192,16,128,20,127,213,144,167,21,168,2,10,192,
  16,128,20,127,213,144,0,0,64,1,0,0,68,244,193,242,0,0,32,128,18,211,151,145,171,23,160,255,21,168,48,0,
  21,20,0,0,242,0,0,32,128,18,167,215,145,2,48,192,0,128,2,255,213,145,0,0,64,127,21,168,48,0,21,20,
  0,0,242,0,0,32,128,18,207,215,145,2,48,192,0,128,2,127,213,145,0,0,64,1,0,0,68,244,193,242,0,0,
  32,128,18,123,152,145,43,24,160,130,12,192,16,128,20,39,216,144,235,21,168,43,216,145,167,21,168,255,21,168,48,0,
  21,20,0,0,242,0,0,32,128,18,15,216,145,2,48,192,0,128,2,175,152,145,130,12,192,16,128,20,255,213,144,235,
  21,168,175,216,145,167,21,168,255,21,160,130,12,192,16,128,20,119,216,144,167,21,168,127,21,168,48,0,21,20,0,0,
  242,0,0,32,128,18,103,216,145,2,48,192,0,128,2,175,152,145,130,12,192,16,128,20,127,213,144,167,21,168,127,21,
  160,0,0,64,1,0,0,130,12,192,16,128,20,75,217,144,68,244,193,242,0,0,32,128,18,39,153,145,231,24,160,235,
  21,168,231,216,145,255,21,168,167,21,168,48,0,21,20,0,0,242,0,0,32,128,18,215,216,145,2,48,192,0,128,2,
  175,153,145,235,21,168,175,217,145,215,21,168,167,213,145,167,21,168,127,21,160,167,21,168,127,21,168,48,0,21,20,0,
  0,242,0,0,32,128,18,31,217,145,2,48,192,0,128,2,23,217,145,0,0,64,68,244,193,242,0,0,32,128,18,143,
  153,145,103,25,160,215,21,168,127,149,145,48,0,21,20,0,0,242,0,0,32,128,18,95,217,145,2,48,192,0,128,2,
  255,213,145,0,0,64,127,21,168,48,0,21,20,0,0,242,0,0,32,128,18,139,217,145,2,48,192,0,128,2,127,213,
  145,0,0,64,1,0,0,68,244,193,242,0,0,32,128,18,239,217,145,2,16,192,0,128,4,75,154,145,0,0,64,130,
  12,192,16,128,20,239,217,144,235,21,168,239,217,145,167,21,168,48,0,21,20,0,0,242,0,0,32,128,18,215,217,145,
  2,48,192,0,128,2,135,154,145,130,12,192,16,128,20,255,213,144,235,21,168,255,213,145,167,21,168,255,21,160,130,12,
  192,16,128,20,71,218,144,167,21,168,130,7,192,16,128,20,135,154,144,127,21,168,48,0,21,20,0,0,242,0,0,32,
  128,18,43,218,145,2,48,192,0,128,2,135,154,145,130,12,192,16,128,20,127,213,144,167,21,168,130,7,192,16,128,20,
  127,213,144,0,0,64,1,0,0,48,0,21,20,0,0,2,48,192,0,128,2,187,154,145,66,72,192,16,128,21,36,128,
  20,0,128,5,187,154,145,127,21,168,1,0,0,48,0,20,20,0,0,2,48,192,0,128,2,235,154,145,66,72,192,16,
  128,21,36,128,20,0,128,5,235,154,145,127,21,168,0,0,64,129,253,255,3,16,192,203,22,168,187,19,160,131,253,255,
  179,25,168,187,19,160,193,250,255,51,23,168,65,251,255,51,23,168,187,19,160,65,253,255,3,8,192,83,22,168,193,2,
  192,3,8,192,83,22,168,129,253,255,3,16,192,83,22,168,193,253,255,3,24,192,83,22,168,65,2,192,3,24,192,83,
  22,168,187,19,160,65,253,255,3,8,192,27,22,168,129,2,192,3,16,192,27,22,168,129,253,255,3,16,192,27,22,168,
  193,253,255,3,24,192,27,22,168,193,255,255,3,32,192,27,22,168,65,0,192,3,32,192,27,22,168,187,19,160,67,253,
  255,247,23,168,195,2,192,179,24,168,195,253,255,247,23,168,67,2,192,179,24,168,187,19,160,129,253,255,3,16,192,27,
  22,168,193,255,255,3,32,192,27,22,168,65,0,192,3,32,192,27,22,168,129,2,192,3,16,192,27,22,168,67,253,255,
  143,23,168,195,2,192,143,23,168,195,253,255,143,23,168,67,2,192,143,23,168,187,19,160,131,253,255,247,23,168,131,2,
  192,179,24,168,195,255,255,179,24,168,67,0,192,179,24,168,187,19,160,65,253,255,3,8,192,27,22,168,193,253,255,3,
  24,192,27,22,168,65,2,192,3,24,192,27,22,168,193,2,192,3,8,192,27,22,168,131,253,255,143,23,168,131,2,192,
  143,23,168,195,255,255,143,23,168,67,0,192,143,23,168,187,19,160,68,244,193,242,0,0,32,128,18,187,211,145,68,244,
  193,2,8,192,0,128,4,195,220,145,195,2,192,139,26,168,68,244,193,2,16,192,0,128,4,219,220,145,131,2,192,139,
  26,168,68,244,193,2,24,192,0,128,4,243,220,145,67,2,192,139,26,168,68,244,193,2,32,192,0,128,4,11,221,145,
  67,0,192,139,26,168,187,19,160,65,253,255,3,8,192,83,22,168,193,2,192,3,8,192,83,22,168,187,19,160,129,253,
  255,3,16,192,83,22,168,187,19,160,65,253,255,3,8,192,27,22,168,187,19,160,129,253,255,3,16,192,27,22,168,129,
  2,192,3,16,192,27,22,168,187,19,160,193,253,255,3,24,192,27,22,168,187,19,160,67,253,255,247,23,168,195,2,192,
  179,24,168,187,19,160,67,253,255,143,23,168,195,2,192,143,23,168,187,19,160,129,253,255,3,16,192,27,22,168,129,2,
  192,3,16,192,27,22,168,187,19,160,193,255,255,3,32,192,27,22,168,65,0,192,3,32,192,27,22,168,187,19,160,131,
  253,255,247,23,168,131,2,192,179,24,168,187,19,160,65,253,255,3,8,192,27,22,168,193,2,192,3,8,192,27,22,168,
  187,19,160,131,253,255,143,23,168,131,2,192,143,23,168,187,19,160,193,253,255,3,24,192,27,22,168,65,2,192,3,24,
  192,27,22,168,187,19,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  129,170,192,194,32,192,3,30,222,20,0,9,63,128,8,12,128,145,65,203,192,194,32,192,3,30,222,20,0,9,63,128,
  8,36,128,145,1,111,193,194,32,192,3,0,192,20,0,9,63,128,8,60,128,145,68,209,193,254,0,0,130,39,192,0,
  128,21,36,128,20,0,128,5,152,128,145,194,143,193,0,128,21,36,128,20,250,0,0,4,0,0,130,7,192,0,128,2,
  0,128,11,3,61,193,48,128,21,37,0,0,104,0,0,0,0,128,66,209,193,0,128,21,36,128,20,254,128,21,80,128,
  145,68,34,192,2,0,192,0,128,5,24,193,145,138,21,192,78,5,192,4,0,0,1,0,192,0,0,5,0,1,145,129,
  21,192,194,12,193,0,128,21,36,128,20,2,192,255,0,128,2,0,128,15,32,0,20,0,1,144,1,0,0,36,58,168,
  1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,196,0,145,4,34,192,2,0,192,0,128,5,132,193,145,138,20,
  192,78,5,192,4,0,0,1,0,192,0,0,5,108,1,145,129,20,192,194,12,193,0,128,21,36,128,20,2,192,255,0,
  128,2,0,128,15,32,0,20,108,1,144,1,0,0,0,58,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,
  48,1,145,196,33,192,2,0,192,0,128,5,240,193,145,10,15,192,78,5,192,4,0,0,1,0,192,0,0,5,216,1,
  145,1,15,192,194,12,193,0,128,21,36,128,20,2,192,255,0,128,2,0,128,15,32,0,20,216,1,144,1,0,0,244,
  56,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,156,1,145,132,33,192,2,0,192,0,128,5,92,194,145,
  138,14,192,78,5,192,4,0,0,1,0,192,0,0,5,68,2,145,129,14,192,194,12,193,0,128,21,36,128,20,2,192,
  255,0,128,2,0,128,15,32,0,20,68,2,144,1,0,0,20,56,168,1,0,0,0,0,9,30,0,0,131,27,192,48,
  0,20,8,2,145,68,33,192,2,0,192,0,128,5,200,194,145,138,8,192,78,10,192,4,0,0,1,0,192,0,0,5,
  176,2,145,129,8,192,194,12,193,0,128,21,36,128,20,2,192,255,0,128,2,0,128,15,32,0,20,176,2,144,1,0,
  0,184,55,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,116,2,145,4,33,192,2,0,192,0,128,5,52,
  195,145,10,8,192,206,7,192,4,0,0,1,0,192,0,0,5,28,3,145,1,8,192,194,12,193,0,128,21,36,128,20,
  2,192,255,0,128,2,0,128,15,32,0,20,28,3,144,1,0,0,172,55,168,1,0,0,0,0,9,30,0,0,131,27,
  192,48,0,20,224,2,145,196,32,192,1,0,192,0,0,5,192,67,145,10,2,192,206,7,192,4,0,0,1,0,192,0,
  0,5,168,3,145,2,59,192,0,128,21,37,128,20,66,239,193,96,128,21,36,128,20,0,128,5,168,131,145,1,2,192,
  194,12,193,0,128,21,36,128,20,2,192,255,0,128,2,0,128,15,32,0,20,168,3,144,1,0,0,124,55,168,1,0,
  0,0,0,9,30,0,0,131,27,192,48,0,20,76,3,145,0,0,64,2,236,192,16,128,21,36,128,20,2,192,255,0,
  128,2,0,128,15,35,0,0,210,0,0,48,128,84,0,0,21,20,0,0,2,48,192,0,128,2,8,132,145,196,35,168,
  8,132,144,0,0,128,0,0,64,0,0,21,20,0,0,2,48,192,0,128,2,60,132,145,66,72,192,16,128,21,36,128,
  20,2,0,224,0,128,2,60,132,145,0,0,128,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,194,167,192,16,
  128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,130,108,193,16,128,21,36,128,20,79,0,192,2,168,192,
  16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,194,108,193,16,128,21,36,128,20,79,0,192,66,168,
  192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,194,110,193,16,128,21,36,128,20,79,0,192,66,
  170,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,66,111,193,16,128,21,36,128,20,79,0,192,
  194,170,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,66,113,193,16,128,21,36,128,20,79,0,
  192,194,172,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,130,113,193,16,128,21,36,128,20,79,
  0,192,2,173,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,194,113,193,16,128,21,36,128,20,
  79,0,192,66,173,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,194,105,193,16,128,21,36,128,
  20,79,0,192,66,165,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,66,106,193,16,128,21,36,
  128,20,79,0,192,194,165,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,29,0,0,128,0,21,
  2,111,193,16,128,21,36,128,20,79,0,192,130,170,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,
  0,194,12,193,16,128,21,36,128,20,2,192,255,0,128,2,0,128,15,35,0,0,210,0,0,48,128,20,100,134,144,20,
  0,0,2,56,192,0,128,2,252,197,145,225,0,64,29,0,0,128,0,21,2,111,193,16,128,21,36,128,20,79,0,192,
  66,203,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,12,193,16,128,21,36,128,20,2,192,
  255,0,128,2,0,128,15,35,0,0,210,0,0,48,128,20,212,134,144,20,0,0,2,56,192,0,128,2,108,198,145,225,
  0,64,129,253,255,136,1,201,232,35,168,152,32,160,1,0,0,131,253,255,48,0,21,20,0,0,2,56,192,0,128,2,
  236,198,145,2,8,192,0,128,2,28,199,145,196,35,168,28,135,144,32,48,168,152,32,160,193,250,255,200,2,201,232,35,
  168,65,251,255,200,2,201,232,35,168,152,32,160,65,253,255,136,3,201,232,35,168,129,253,255,136,3,201,232,35,168,193,
  253,255,136,3,201,232,35,168,65,2,192,136,3,201,232,35,168,193,2,192,136,3,201,232,35,168,152,32,160,65,253,255,
  8,5,201,232,35,168,129,253,255,72,6,201,232,35,168,193,253,255,72,7,201,232,35,168,193,255,255,136,8,201,232,35,
  168,65,0,192,136,9,201,232,35,168,129,2,192,136,10,201,232,35,168,152,32,160,1,0,0,220,39,160,196,35,168,220,
  135,144,192,48,168,67,253,255,48,0,21,20,0,0,2,56,192,0,128,2,208,199,145,2,8,192,0,128,2,12,200,145,
  196,35,168,12,136,144,184,48,168,1,0,0,32,40,160,196,35,168,32,136,144,224,48,168,195,253,255,48,0,21,20,0,
  0,2,56,192,0,128,2,20,200,145,2,8,192,0,128,2,80,200,145,196,35,168,80,136,144,216,48,168,1,0,0,100,
  40,160,196,35,168,100,136,144,0,49,168,67,2,192,48,0,21,20,0,0,2,56,192,0,128,2,88,200,145,2,8,192,
  0,128,2,148,200,145,196,35,168,148,136,144,248,48,168,1,0,0,168,40,160,196,35,168,168,136,144,32,49,168,195,2,
  192,48,0,21,20,0,0,2,56,192,0,128,2,156,200,145,2,8,192,0,128,2,216,200,145,196,35,168,216,136,144,24,
  49,168,152,32,160,193,243,193,66,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,108,193,0,128,21,
  36,128,20,243,0,0,20,0,0,63,0,9,194,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,110,
  193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,111,193,0,128,21,36,128,20,243,0,0,20,0,0,63,
  0,9,66,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,113,193,0,128,21,36,128,20,243,0,0,
  20,0,0,63,0,9,194,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,1,0,0,180,41,160,196,35,
  168,180,137,144,64,49,168,67,253,255,48,0,21,20,0,0,2,56,192,0,128,2,168,201,145,2,8,192,0,128,2,228,
  201,145,196,35,168,228,137,144,56,49,168,1,0,0,248,41,160,196,35,168,248,137,144,112,49,168,195,253,255,48,0,21,
  20,0,0,2,56,192,0,128,2,236,201,145,2,8,192,0,128,2,40,202,145,196,35,168,40,138,144,104,49,168,1,0,
  0,60,42,160,196,35,168,60,138,144,160,49,168,67,2,192,48,0,21,20,0,0,2,56,192,0,128,2,48,202,145,2,
  8,192,0,128,2,108,202,145,196,35,168,108,138,144,152,49,168,1,0,0,128,42,160,196,35,168,128,138,144,208,49,168,
  195,2,192,48,0,21,20,0,0,2,56,192,0,128,2,116,202,145,2,8,192,0,128,2,176,202,145,196,35,168,176,138,
  144,200,49,168,129,253,255,136,31,201,232,35,168,193,255,255,136,31,201,232,35,168,65,0,192,136,31,201,232,35,168,129,
  2,192,136,31,201,232,35,168,193,243,193,20,0,0,243,0,9,66,108,193,0,128,21,36,128,20,63,0,0,20,0,0,
  243,0,9,130,108,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,108,193,0,128,21,36,128,20,63,0,
  0,20,0,0,243,0,9,194,110,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,66,111,193,0,128,21,36,
  128,20,63,0,0,20,0,0,243,0,9,66,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,113,193,
  0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,113,193,0,128,21,36,128,20,63,0,0,152,32,160,1,0,
  0,188,43,160,196,35,168,188,139,144,52,50,168,131,253,255,48,0,21,20,0,0,2,56,192,0,128,2,176,203,145,2,
  8,192,0,128,2,236,203,145,196,35,168,236,139,144,44,50,168,1,0,0,0,44,160,196,35,168,0,140,144,84,50,168,
  195,255,255,48,0,21,20,0,0,2,56,192,0,128,2,244,203,145,2,8,192,0,128,2,48,204,145,196,35,168,48,140,
  144,76,50,168,1,0,0,68,44,160,196,35,168,68,140,144,116,50,168,67,0,192,48,0,21,20,0,0,2,56,192,0,
  128,2,56,204,145,2,8,192,0,128,2,116,204,145,196,35,168,116,140,144,108,50,168,1,0,0,136,44,160,196,35,168,
  136,140,144,148,50,168,131,2,192,48,0,21,20,0,0,2,56,192,0,128,2,124,204,145,2,8,192,0,128,2,184,204,
  145,196,35,168,184,140,144,140,50,168,152,32,160,193,243,193,66,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,
  0,9,130,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,108,193,0,128,21,36,128,20,243,0,0,
  20,0,0,63,0,9,194,110,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,111,193,0,128,21,36,128,
  20,243,0,0,20,0,0,63,0,9,66,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,113,193,0,
  128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,
  1,0,0,148,45,160,196,35,168,148,141,144,180,50,168,131,253,255,48,0,21,20,0,0,2,56,192,0,128,2,136,205,
  145,2,8,192,0,128,2,196,205,145,196,35,168,196,141,144,172,50,168,1,0,0,216,45,160,196,35,168,216,141,144,228,
  50,168,195,255,255,48,0,21,20,0,0,2,56,192,0,128,2,204,205,145,2,8,192,0,128,2,8,206,145,196,35,168,
  8,142,144,220,50,168,1,0,0,28,46,160,196,35,168,28,142,144,20,51,168,67,0,192,48,0,21,20,0,0,2,56,
  192,0,128,2,16,206,145,2,8,192,0,128,2,76,206,145,196,35,168,76,142,144,12,51,168,1,0,0,96,46,160,196,
  35,168,96,142,144,68,51,168,131,2,192,48,0,21,20,0,0,2,56,192,0,128,2,84,206,145,2,8,192,0,128,2,
  144,206,145,196,35,168,144,142,144,60,51,168,65,253,255,200,54,201,232,35,168,193,253,255,136,60,201,232,35,168,65,2,
  192,72,66,201,232,35,168,193,2,192,8,72,201,232,35,168,193,243,193,20,0,0,243,0,9,66,108,193,0,128,21,36,
  128,20,63,0,0,20,0,0,243,0,9,130,108,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,108,193,
  0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,110,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,
  9,66,111,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,66,113,193,0,128,21,36,128,20,63,0,0,20,
  0,0,243,0,9,130,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,113,193,0,128,21,36,128,20,
  63,0,0,152,32,160,65,253,255,200,77,201,12,36,168,129,253,255,8,84,201,12,36,168,193,253,255,72,88,201,12,36,
  168,193,255,255,136,94,201,12,36,168,65,0,192,200,98,201,12,36,168,65,2,192,8,103,201,12,36,168,129,2,192,72,
  109,201,12,36,168,193,2,192,136,113,201,12,36,168,152,32,160,2,111,193,0,128,21,36,128,20,79,0,192,130,170,192,
  0,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,64,108,36,168,0,0,64,134,253,255,248,37,168,0,0,
  64,160,37,168,204,37,168,0,0,64,64,36,168,108,36,168,152,36,168,28,37,168,116,37,168,0,0,64,64,36,168,108,
  36,168,152,36,168,196,36,168,0,0,64,64,36,168,108,36,168,72,37,168,0,0,64,64,36,168,108,36,168,152,36,168,
  240,36,168,0,0,64,64,36,168,196,36,168,72,37,168,0,0,64,152,36,168,240,36,168,72,37,168,0,0,64,196,36,
  168,240,36,168,72,37,168,0,0,64,70,253,255,248,37,168,236,47,168,198,253,255,248,37,168,70,2,192,248,37,168,0,
  0,64,198,253,255,248,37,168,236,47,168,70,253,255,248,37,168,198,2,192,248,37,168,0,0,64,70,2,192,248,37,168,
  236,47,168,70,253,255,248,37,168,198,2,192,248,37,168,0,0,64,198,2,192,248,37,168,236,47,168,198,253,255,248,37,
  168,70,2,192,248,37,168,0,0,64,70,253,255,248,37,168,236,47,168,108,36,168,196,36,168,240,36,168,72,37,168,198,
  253,255,248,37,168,70,2,192,248,37,168,0,0,64,198,253,255,248,37,168,236,47,168,108,36,168,196,36,168,240,36,168,
  72,37,168,70,253,255,248,37,168,198,2,192,248,37,168,0,0,64,70,2,192,248,37,168,236,47,168,108,36,168,196,36,
  168,240,36,168,72,37,168,70,253,255,248,37,168,198,2,192,248,37,168,0,0,64,198,2,192,248,37,168,236,47,168,108,
  36,168,196,36,168,240,36,168,72,37,168,198,253,255,248,37,168,70,2,192,248,37,168,0,0,64,108,36,168,196,36,168,
  240,36,168,72,37,168,70,253,255,248,37,168,198,253,255,248,37,168,70,2,192,248,37,168,198,2,192,248,37,168,0,0,
  64,134,253,255,248,37,168,236,47,168,198,255,255,248,37,168,70,0,192,248,37,168,0,0,64,198,255,255,248,37,168,236,
  47,168,134,253,255,248,37,168,134,2,192,248,37,168,0,0,64,70,0,192,248,37,168,236,47,168,134,253,255,248,37,168,
  134,2,192,248,37,168,0,0,64,134,2,192,248,37,168,236,47,168,198,255,255,248,37,168,70,0,192,248,37,168,0,0,
  64,134,253,255,248,37,168,236,47,168,64,36,168,152,36,168,28,37,168,116,37,168,198,255,255,248,37,168,70,0,192,248,
  37,168,0,0,64,198,255,255,248,37,168,236,47,168,64,36,168,152,36,168,28,37,168,116,37,168,134,253,255,248,37,168,
  134,2,192,248,37,168,0,0,64,70,0,192,248,37,168,236,47,168,64,36,168,152,36,168,28,37,168,116,37,168,134,253,
  255,248,37,168,134,2,192,248,37,168,0,0,64,134,2,192,248,37,168,236,47,168,64,36,168,152,36,168,28,37,168,116,
  37,168,198,255,255,248,37,168,70,0,192,248,37,168,0,0,64,64,36,168,116,37,168,130,253,255,0,128,21,36,128,20,
  0,128,5,140,211,145,152,36,168,194,255,255,0,128,21,36,128,20,0,128,5,164,211,145,28,37,168,134,253,255,248,37,
  168,198,255,255,248,37,168,70,0,192,248,37,168,134,2,192,248,37,168,0,0,64,152,36,168,28,37,168,130,253,255,0,
  128,21,36,128,20,0,128,5,232,211,145,64,36,168,66,0,192,0,128,21,36,128,20,0,128,5,0,212,145,116,37,168,
  134,253,255,248,37,168,198,255,255,248,37,168,70,0,192,248,37,168,134,2,192,248,37,168,0,0,64,152,36,168,28,37,
  168,130,2,192,0,128,21,36,128,20,0,128,5,68,212,145,116,37,168,194,255,255,0,128,21,36,128,20,0,128,5,92,
  212,145,64,36,168,134,253,255,248,37,168,198,255,255,248,37,168,70,0,192,248,37,168,134,2,192,248,37,168,0,0,64,
  64,36,168,116,37,168,130,2,192,0,128,21,36,128,20,0,128,5,160,212,145,28,37,168,66,0,192,0,128,21,36,128,
  20,0,128,5,184,212,145,152,36,168,134,253,255,248,37,168,198,255,255,248,37,168,70,0,192,248,37,168,134,2,192,248,
  37,168,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,130,108,193,16,128,21,36,128,20,79,0,192,194,108,193,
  16,128,21,36,128,20,79,0,192,194,110,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,0,
  192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,130,108,193,16,
  128,21,36,128,20,79,0,192,194,108,193,16,128,21,36,128,20,79,0,192,130,113,193,16,128,21,36,128,20,79,0,192,
  0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,130,108,193,16,128,21,36,128,20,79,0,192,194,108,193,16,128,
  21,36,128,20,79,0,192,194,110,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,0,192,194,
  113,193,16,128,21,36,128,20,79,0,192,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,194,110,193,16,128,21,
  36,128,20,79,0,192,66,111,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,0,192,0,0,
  64,194,108,193,16,128,21,36,128,20,79,0,192,194,110,193,16,128,21,36,128,20,79,0,192,66,111,193,16,128,21,36,
  128,20,79,0,192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,
  194,108,193,16,128,21,36,128,20,79,0,192,194,110,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,
  20,79,0,192,130,113,193,16,128,21,36,128,20,79,0,192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,130,
  108,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,0,192,130,113,193,16,128,21,36,128,20,
  79,0,192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,194,108,
  193,16,128,21,36,128,20,79,0,192,66,111,193,16,128,21,36,128,20,79,0,192,66,113,193,16,128,21,36,128,20,79,
  0,192,130,113,193,16,128,21,36,128,20,79,0,192,194,113,193,16,128,21,36,128,20,79,0,192,0,0,64,130,108,193,
  16,128,21,36,128,20,79,0,192,194,200,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,0,0,
  64,134,253,255,104,38,168,0,0,64,194,105,193,16,128,21,36,128,20,79,0,192,2,198,192,16,128,21,36,128,20,2,
  192,255,0,128,2,208,128,17,47,0,0,66,106,193,16,128,21,36,128,20,79,0,192,130,198,192,16,128,21,36,128,20,
  2,192,255,0,128,2,208,128,17,47,0,0,0,0,64,66,108,193,16,128,21,36,128,20,79,0,192,130,200,192,16,128,
  21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,130,108,193,16,128,21,36,128,20,79,0,192,194,200,192,16,
  128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,108,193,16,128,21,36,128,20,79,0,192,2,201,192,
  16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,66,113,193,16,128,21,36,128,20,79,0,192,130,205,
  192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,113,193,16,128,21,36,128,20,79,0,192,2,
  206,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,0,0,64,66,108,193,16,128,21,36,128,20,
  79,0,192,130,200,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,130,108,193,16,128,21,36,128,
  20,79,0,192,194,200,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,108,193,16,128,21,36,
  128,20,79,0,192,2,201,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,194,110,193,16,128,21,
  36,128,20,79,0,192,2,203,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,66,111,193,16,128,
  21,36,128,20,79,0,192,130,203,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,130,113,193,16,
  128,21,36,128,20,79,0,192,194,205,192,16,128,21,36,128,20,2,192,255,0,128,2,208,128,17,47,0,0,0,0,64,
  70,253,255,104,38,168,198,253,255,104,38,168,70,2,192,104,38,168,198,2,192,104,38,168,0,0,64,134,253,255,104,38,
  168,198,255,255,104,38,168,70,0,192,104,38,168,134,2,192,104,38,168,0,0,64,132,209,193,254,0,0,130,39,192,0,
  128,21,36,128,20,0,128,5,152,154,145,194,143,193,0,128,21,36,128,20,250,0,0,4,0,0,130,7,192,0,128,2,
  0,128,11,3,65,193,48,128,21,37,0,0,104,0,0,0,0,128,66,209,193,0,128,21,36,128,20,254,128,21,80,154,
  145,68,36,192,2,0,192,0,128,5,20,219,145,138,21,192,78,5,192,4,0,0,1,0,192,0,0,5,252,26,145,129,
  21,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,252,26,144,1,0,0,237,54,168,1,0,0,
  0,0,9,30,0,0,131,27,192,48,0,20,196,26,145,4,36,192,2,0,192,0,128,5,124,219,145,138,20,192,78,5,
  192,4,0,0,1,0,192,0,0,5,100,27,145,129,20,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,
  0,20,100,27,144,1,0,0,201,54,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,44,27,145,196,35,192,
  2,0,192,0,128,5,228,219,145,10,15,192,78,5,192,4,0,0,1,0,192,0,0,5,204,27,145,1,15,192,194,12,
  193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,204,27,144,1,0,0,93,53,168,1,0,0,0,0,9,30,
  0,0,131,27,192,48,0,20,148,27,145,132,35,192,2,0,192,0,128,5,76,220,145,138,14,192,78,5,192,4,0,0,
  1,0,192,0,0,5,52,28,145,129,14,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,52,28,
  144,1,0,0,45,52,168,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,252,27,145,68,35,192,2,0,192,0,
  128,5,180,220,145,138,8,192,78,5,192,4,0,0,1,0,192,0,0,5,156,28,145,129,8,192,194,12,193,0,128,21,
  36,128,20,194,63,192,0,128,2,32,0,20,156,28,144,1,0,0,177,51,168,1,0,0,0,0,9,30,0,0,131,22,
  192,48,0,20,100,28,145,4,35,192,2,0,192,0,128,5,28,221,145,10,8,192,78,5,192,4,0,0,1,0,192,0,
  0,5,4,29,145,1,8,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,4,29,144,1,0,0,
  165,51,168,1,0,0,0,0,9,30,0,0,3,25,192,48,0,20,204,28,145,196,34,192,1,0,192,0,0,5,164,93,
  145,10,2,192,78,5,192,4,0,0,1,0,192,0,0,5,140,29,145,2,59,192,0,128,21,37,128,20,130,241,193,96,
  128,21,36,128,20,0,128,5,140,157,145,1,2,192,194,12,193,0,128,21,36,128,20,194,63,192,0,128,2,32,0,20,
  140,29,144,1,0,0,101,51,168,1,0,0,0,0,9,30,0,0,3,25,192,48,0,20,52,29,145,0,0,64,2,236,
  192,16,128,21,36,128,20,194,63,192,0,128,2,35,0,0,210,0,0,48,128,84,0,0,21,20,0,0,2,40,192,0,
  128,2,232,157,145,168,61,168,232,157,144,0,0,128,0,0,64,0,0,21,20,0,0,2,40,192,0,128,2,28,158,145,
  66,72,192,16,128,21,36,128,20,2,32,192,0,128,2,28,158,145,0,0,128,0,0,64,194,113,193,16,128,21,36,128,
  20,2,64,192,0,128,1,47,0,0,66,173,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,
  128,15,47,0,64,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,173,192,16,128,21,36,128,20,
  194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,66,113,193,16,128,21,36,128,20,2,64,192,0,128,
  1,47,0,0,194,172,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,66,
  111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,170,192,16,128,21,36,128,20,194,63,192,0,128,2,
  0,128,15,208,128,17,0,128,15,47,0,64,194,110,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,170,
  192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,194,108,193,16,128,21,36,
  128,20,2,64,192,0,128,1,47,0,0,66,168,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,
  0,128,15,47,0,64,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,168,192,16,128,21,36,128,
  20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,66,108,193,16,128,21,36,128,20,2,64,192,0,
  128,1,47,0,0,194,167,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,
  66,116,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,175,192,16,128,21,36,128,20,194,63,192,0,128,
  2,0,128,15,208,128,17,0,128,15,47,0,64,194,115,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,
  175,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,29,0,0,128,0,21,
  2,111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,170,192,16,128,21,36,128,20,194,63,192,0,128,
  2,0,128,15,208,128,17,0,128,15,47,0,0,194,12,193,16,128,21,36,128,20,194,63,192,0,128,2,35,0,0,210,
  0,0,48,128,20,241,128,144,20,0,0,2,56,192,0,128,2,125,192,145,225,0,64,29,0,0,128,0,21,2,111,193,
  16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,203,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,
  15,208,128,17,0,128,15,47,0,0,194,12,193,16,128,21,36,128,20,194,63,192,0,128,2,35,0,0,210,0,0,48,
  128,20,109,129,144,20,0,0,2,56,192,0,128,2,249,192,145,225,0,64,129,2,192,8,172,202,200,61,168,152,58,160,
  1,0,0,131,2,192,48,0,21,20,0,0,2,56,192,0,128,2,133,193,145,2,16,192,0,128,2,181,193,145,168,61,
  168,181,129,144,201,42,168,152,58,160,65,5,192,72,173,202,200,61,168,193,4,192,72,173,202,200,61,168,152,58,160,193,
  2,192,8,174,202,200,61,168,129,2,192,8,174,202,200,61,168,65,2,192,8,174,202,200,61,168,193,253,255,8,174,202,
  200,61,168,65,253,255,8,174,202,200,61,168,152,58,160,193,2,192,136,175,202,200,61,168,129,2,192,200,176,202,200,61,
  168,65,2,192,200,177,202,200,61,168,65,0,192,8,179,202,200,61,168,193,255,255,8,180,202,200,61,168,129,253,255,8,
  181,202,200,61,168,152,58,160,1,0,0,117,34,160,168,61,168,117,130,144,105,43,168,195,2,192,48,0,21,20,0,0,
  2,56,192,0,128,2,105,194,145,2,16,192,0,128,2,165,194,145,168,61,168,165,130,144,97,43,168,1,0,0,185,34,
  160,168,61,168,185,130,144,137,43,168,67,2,192,48,0,21,20,0,0,2,56,192,0,128,2,173,194,145,2,16,192,0,
  128,2,233,194,145,168,61,168,233,130,144,129,43,168,1,0,0,253,34,160,168,61,168,253,130,144,169,43,168,195,253,255,
  48,0,21,20,0,0,2,56,192,0,128,2,241,194,145,2,16,192,0,128,2,45,195,145,168,61,168,45,131,144,161,43,
  168,1,0,0,65,35,160,168,61,168,65,131,144,201,43,168,67,253,255,48,0,21,20,0,0,2,56,192,0,128,2,53,
  195,145,2,16,192,0,128,2,113,195,145,168,61,168,113,131,144,193,43,168,152,58,160,193,243,193,194,113,193,0,128,21,
  36,128,20,243,0,0,20,0,0,63,0,9,130,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,113,
  193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,111,193,0,128,21,36,128,20,243,0,0,20,0,0,63,
  0,9,194,110,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,108,193,0,128,21,36,128,20,243,0,0,
  20,0,0,63,0,9,130,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,108,193,0,128,21,36,128,
  20,243,0,0,20,0,0,63,0,9,1,0,0,77,36,160,168,61,168,77,132,144,233,43,168,195,2,192,48,0,21,20,
  0,0,2,56,192,0,128,2,65,196,145,2,16,192,0,128,2,125,196,145,168,61,168,125,132,144,225,43,168,1,0,0,
  145,36,160,168,61,168,145,132,144,25,44,168,67,2,192,48,0,21,20,0,0,2,56,192,0,128,2,133,196,145,2,16,
  192,0,128,2,193,196,145,168,61,168,193,132,144,17,44,168,1,0,0,213,36,160,168,61,168,213,132,144,73,44,168,195,
  253,255,48,0,21,20,0,0,2,56,192,0,128,2,201,196,145,2,16,192,0,128,2,5,197,145,168,61,168,5,133,144,
  65,44,168,1,0,0,25,37,160,168,61,168,25,133,144,121,44,168,67,253,255,48,0,21,20,0,0,2,56,192,0,128,
  2,13,197,145,2,16,192,0,128,2,73,197,145,168,61,168,73,133,144,113,44,168,129,2,192,8,202,202,200,61,168,65,
  0,192,8,202,202,200,61,168,193,255,255,8,202,202,200,61,168,129,253,255,8,202,202,200,61,168,193,243,193,20,0,0,
  243,0,9,194,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,113,193,0,128,21,36,128,20,63,0,
  0,20,0,0,243,0,9,66,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,66,111,193,0,128,21,36,
  128,20,63,0,0,20,0,0,243,0,9,194,110,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,108,193,
  0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,108,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,
  9,66,108,193,0,128,21,36,128,20,63,0,0,152,58,160,1,0,0,85,38,160,168,61,168,85,134,144,221,44,168,131,
  2,192,48,0,21,20,0,0,2,56,192,0,128,2,73,198,145,2,16,192,0,128,2,133,198,145,168,61,168,133,134,144,
  213,44,168,1,0,0,153,38,160,168,61,168,153,134,144,253,44,168,67,0,192,48,0,21,20,0,0,2,56,192,0,128,
  2,141,198,145,2,16,192,0,128,2,201,198,145,168,61,168,201,134,144,245,44,168,1,0,0,221,38,160,168,61,168,221,
  134,144,29,45,168,195,255,255,48,0,21,20,0,0,2,56,192,0,128,2,209,198,145,2,16,192,0,128,2,13,199,145,
  168,61,168,13,135,144,21,45,168,1,0,0,33,39,160,168,61,168,33,135,144,61,45,168,131,253,255,48,0,21,20,0,
  0,2,56,192,0,128,2,21,199,145,2,16,192,0,128,2,81,199,145,168,61,168,81,135,144,53,45,168,152,58,160,193,
  243,193,194,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,113,193,0,128,21,36,128,20,243,0,0,
  20,0,0,63,0,9,66,113,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,66,111,193,0,128,21,36,128,
  20,243,0,0,20,0,0,63,0,9,194,110,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,194,108,193,0,
  128,21,36,128,20,243,0,0,20,0,0,63,0,9,130,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,
  66,108,193,0,128,21,36,128,20,243,0,0,20,0,0,63,0,9,1,0,0,45,40,160,168,61,168,45,136,144,93,45,
  168,131,2,192,48,0,21,20,0,0,2,56,192,0,128,2,33,200,145,2,16,192,0,128,2,93,200,145,168,61,168,93,
  136,144,85,45,168,1,0,0,113,40,160,168,61,168,113,136,144,141,45,168,67,0,192,48,0,21,20,0,0,2,56,192,
  0,128,2,101,200,145,2,16,192,0,128,2,161,200,145,168,61,168,161,136,144,133,45,168,1,0,0,181,40,160,168,61,
  168,181,136,144,189,45,168,195,255,255,48,0,21,20,0,0,2,56,192,0,128,2,169,200,145,2,16,192,0,128,2,229,
  200,145,168,61,168,229,136,144,181,45,168,1,0,0,249,40,160,168,61,168,249,136,144,237,45,168,131,253,255,48,0,21,
  20,0,0,2,56,192,0,128,2,237,200,145,2,16,192,0,128,2,41,201,145,168,61,168,41,137,144,229,45,168,193,2,
  192,72,225,202,200,61,168,65,2,192,8,231,202,200,61,168,193,253,255,200,236,202,200,61,168,65,253,255,136,242,202,200,
  61,168,193,243,193,20,0,0,243,0,9,194,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,113,193,
  0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,66,113,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,
  9,66,111,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,194,110,193,0,128,21,36,128,20,63,0,0,20,
  0,0,243,0,9,194,108,193,0,128,21,36,128,20,63,0,0,20,0,0,243,0,9,130,108,193,0,128,21,36,128,20,
  63,0,0,20,0,0,243,0,9,66,108,193,0,128,21,36,128,20,63,0,0,152,58,160,193,2,192,72,248,202,236,61,
  168,129,2,192,136,1,203,236,61,168,65,2,192,200,7,203,236,61,168,65,0,192,8,17,203,236,61,168,193,255,255,72,
  23,203,236,61,168,193,253,255,136,29,203,236,61,168,129,253,255,200,38,203,236,61,168,65,253,255,8,45,203,236,61,168,
  152,58,160,2,111,193,0,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,170,192,0,128,21,36,128,20,194,63,
  192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,64,92,62,168,0,0,64,134,2,192,121,32,168,0,0,64,1,
  32,168,61,32,168,0,0,64,32,62,168,92,62,168,152,62,168,76,63,168,196,63,168,0,0,64,32,62,168,92,62,168,
  152,62,168,212,62,168,0,0,64,32,62,168,92,62,168,136,63,168,0,0,64,32,62,168,92,62,168,152,62,168,16,63,
  168,0,0,64,32,62,168,212,62,168,136,63,168,0,0,64,152,62,168,16,63,168,136,63,168,0,0,64,212,62,168,16,
  63,168,136,63,168,0,0,64,198,2,192,121,32,168,133,42,168,70,2,192,121,32,168,198,253,255,121,32,168,0,0,64,
  70,2,192,121,32,168,133,42,168,198,2,192,121,32,168,70,253,255,121,32,168,0,0,64,198,253,255,121,32,168,133,42,
  168,198,2,192,121,32,168,70,253,255,121,32,168,0,0,64,70,253,255,121,32,168,133,42,168,70,2,192,121,32,168,198,
  253,255,121,32,168,0,0,64,198,2,192,121,32,168,133,42,168,92,62,168,212,62,168,16,63,168,136,63,168,70,2,192,
  121,32,168,198,253,255,121,32,168,0,0,64,70,2,192,121,32,168,133,42,168,92,62,168,212,62,168,16,63,168,136,63,
  168,198,2,192,121,32,168,70,253,255,121,32,168,0,0,64,198,253,255,121,32,168,133,42,168,92,62,168,212,62,168,16,
  63,168,136,63,168,198,2,192,121,32,168,70,253,255,121,32,168,0,0,64,70,253,255,121,32,168,133,42,168,92,62,168,
  212,62,168,16,63,168,136,63,168,70,2,192,121,32,168,198,253,255,121,32,168,0,0,64,92,62,168,212,62,168,16,63,
  168,136,63,168,198,2,192,121,32,168,70,2,192,121,32,168,198,253,255,121,32,168,70,253,255,121,32,168,0,0,64,134,
  2,192,121,32,168,133,42,168,70,0,192,121,32,168,198,255,255,121,32,168,0,0,64,70,0,192,121,32,168,133,42,168,
  134,2,192,121,32,168,134,253,255,121,32,168,0,0,64,198,255,255,121,32,168,133,42,168,134,2,192,121,32,168,134,253,
  255,121,32,168,0,0,64,134,253,255,121,32,168,133,42,168,70,0,192,121,32,168,198,255,255,121,32,168,0,0,64,134,
  2,192,121,32,168,133,42,168,32,62,168,152,62,168,76,63,168,196,63,168,70,0,192,121,32,168,198,255,255,121,32,168,
  0,0,64,70,0,192,121,32,168,133,42,168,32,62,168,152,62,168,76,63,168,196,63,168,134,2,192,121,32,168,134,253,
  255,121,32,168,0,0,64,198,255,255,121,32,168,133,42,168,32,62,168,152,62,168,76,63,168,196,63,168,134,2,192,121,
  32,168,134,253,255,121,32,168,0,0,64,134,253,255,121,32,168,133,42,168,32,62,168,152,62,168,76,63,168,196,63,168,
  70,0,192,121,32,168,198,255,255,121,32,168,0,0,64,32,62,168,196,63,168,130,2,192,0,128,21,36,128,20,0,128,
  5,53,206,145,152,62,168,66,0,192,0,128,21,36,128,20,0,128,5,77,206,145,76,63,168,134,2,192,121,32,168,70,
  0,192,121,32,168,198,255,255,121,32,168,134,253,255,121,32,168,0,0,64,152,62,168,76,63,168,130,2,192,0,128,21,
  36,128,20,0,128,5,145,206,145,32,62,168,194,255,255,0,128,21,36,128,20,0,128,5,169,206,145,196,63,168,134,2,
  192,121,32,168,70,0,192,121,32,168,198,255,255,121,32,168,134,253,255,121,32,168,0,0,64,152,62,168,76,63,168,130,
  253,255,0,128,21,36,128,20,0,128,5,237,206,145,196,63,168,66,0,192,0,128,21,36,128,20,0,128,5,5,207,145,
  32,62,168,134,2,192,121,32,168,70,0,192,121,32,168,198,255,255,121,32,168,134,253,255,121,32,168,0,0,64,32,62,
  168,196,63,168,130,253,255,0,128,21,36,128,20,0,128,5,73,207,145,76,63,168,194,255,255,0,128,21,36,128,20,0,
  128,5,97,207,145,152,62,168,134,2,192,121,32,168,70,0,192,121,32,168,198,255,255,121,32,168,134,253,255,121,32,168,
  0,0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,113,193,16,128,21,36,128,20,2,64,
  192,0,128,1,47,0,0,66,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,111,193,16,128,21,36,
  128,20,2,64,192,0,128,1,47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,
  16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,
  1,47,0,0,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,113,193,16,128,21,36,128,20,2,
  64,192,0,128,1,47,0,0,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,194,113,193,
  16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,
  0,66,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,111,193,16,128,21,36,128,20,2,64,192,0,
  128,1,47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,16,128,21,36,128,20,
  2,64,192,0,128,1,47,0,0,0,0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,111,
  193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,110,193,16,128,21,36,128,20,2,64,192,0,128,1,47,
  0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,66,113,193,16,128,21,36,128,20,
  2,64,192,0,128,1,47,0,0,66,111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,110,193,16,128,
  21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,
  0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,113,193,16,128,21,36,128,20,2,64,192,
  0,128,1,47,0,0,66,111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,108,193,16,128,21,36,128,
  20,2,64,192,0,128,1,47,0,0,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,16,
  128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,
  47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,108,193,16,128,21,36,128,20,2,64,
  192,0,128,1,47,0,0,66,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,0,0,64,194,113,193,16,
  128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,
  194,110,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,
  1,47,0,0,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,66,108,193,16,128,21,36,128,20,2,
  64,192,0,128,1,47,0,0,0,0,64,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,205,192,
  16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,0,0,64,134,2,192,245,32,
  168,0,0,64,66,116,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,208,192,16,128,21,36,128,20,194,
  63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,194,115,193,16,128,21,36,128,20,2,64,192,0,128,1,
  47,0,0,2,208,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,0,0,
  64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,206,192,16,128,21,36,128,20,194,63,192,0,
  128,2,0,128,15,208,128,17,0,128,15,47,0,0,130,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,
  194,205,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,66,113,193,16,128,
  21,36,128,20,2,64,192,0,128,1,47,0,0,130,205,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,
  128,17,0,128,15,47,0,0,194,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,201,192,16,128,21,
  36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,66,108,193,16,128,21,36,128,20,2,64,
  192,0,128,1,47,0,0,130,200,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,
  0,0,0,0,64,194,113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,2,206,192,16,128,21,36,128,20,
  194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,130,113,193,16,128,21,36,128,20,2,64,192,0,128,
  1,47,0,0,194,205,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,66,
  113,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,205,192,16,128,21,36,128,20,194,63,192,0,128,2,
  0,128,15,208,128,17,0,128,15,47,0,0,66,111,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,130,203,
  192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,194,110,193,16,128,21,36,
  128,20,2,64,192,0,128,1,47,0,0,2,203,192,16,128,21,36,128,20,194,63,192,0,128,2,0,128,15,208,128,17,
  0,128,15,47,0,0,130,108,193,16,128,21,36,128,20,2,64,192,0,128,1,47,0,0,194,200,192,16,128,21,36,128,
  20,194,63,192,0,128,2,0,128,15,208,128,17,0,128,15,47,0,0,0,0,64,198,2,192,245,32,168,70,2,192,245,
  32,168,198,253,255,245,32,168,70,253,255,245,32,168,0,0,64,134,2,192,245,32,168,70,0,192,245,32,168,198,255,255,
  245,32,168,134,253,255,245,32,168,0,0,64,78,5,192,4,0,0,2,0,192,0,128,5,169,217,148,130,170,192,0,128,
  21,36,128,20,193,63,192,0,0,2,66,203,192,0,128,21,36,128,20,194,63,192,0,128,2,26,0,0,32,0,20,93,
  87,144,42,0,0,2,105,192,0,128,21,36,128,20,194,63,192,209,128,2,32,0,20,133,23,144,221,0,0,42,0,0,
  161,55,160,45,0,0,2,192,255,0,128,2,209,128,15,32,0,20,161,87,144,42,0,0,4,244,193,239,0,0,132,244,
  193,223,0,0,130,170,192,0,128,21,36,128,20,1,192,255,0,0,2,0,0,15,66,203,192,0,128,21,36,128,20,2,
  192,255,0,128,2,0,128,15,26,0,0,32,0,20,241,87,144,42,0,0,194,137,192,0,128,21,36,128,20,194,63,192,
  209,128,2,32,0,20,25,24,144,221,0,0,42,0,0,53,56,160,45,0,0,2,192,255,0,128,2,209,128,15,32,0,
  20,53,88,144,42,0,0,68,244,193,239,0,0,196,244,193,223,0,0,66,78,193,0,128,21,36,128,20,241,0,0,2,
  111,193,0,128,21,36,128,20,0,0,5,31,0,0,2,192,255,16,128,18,32,0,19,22,128,15,35,0,0,4,0,0,
  241,0,0,0,0,15,16,0,21,130,0,12,0,128,12,38,0,0,50,0,12,0,128,12,35,0,0,130,0,0,48,128,
  20,253,216,144,65,217,145,66,255,255,48,128,21,213,152,144,4,244,193,241,0,0,196,244,193,0,0,4,217,24,144,1,
  0,192,68,244,193,242,0,0,0,128,15,32,0,17,130,45,193,0,128,21,36,128,20,31,0,0,169,57,160,66,255,255,
  128,128,21,29,153,144,68,244,193,241,0,0,132,244,193,0,0,4,33,25,144,1,0,192,0,0,15,4,244,193,0,0,
  1,130,45,193,0,128,21,36,128,20,31,0,0,169,57,160,65,255,255,128,0,21,97,89,144,130,45,193,0,128,21,36,
  128,20,15,0,192,169,57,160,4,244,193,241,0,0,196,244,193,0,0,4,121,25,144,1,0,192,68,244,193,242,0,0,
  132,244,193,0,128,4,145,153,144,2,0,192,0,128,15,32,0,17,130,45,193,0,128,21,36,128,20,31,0,0,1,0,
  0,0,0,9,30,0,0,130,27,192,0,128,20,21,151,145,0,0,64,78,5,192,4,0,0,1,0,192,0,0,5,90,
  64,148,130,176,193,0,128,21,36,128,20,241,0,0,0,0,14,3,60,192,48,0,18,4,244,193,31,0,0,2,236,192,
  0,128,21,36,128,20,193,63,192,242,0,18,26,128,19,0,128,15,32,0,20,33,92,145,131,22,192,209,0,0,48,0,
  20,217,27,144,33,0,0,48,0,20,241,27,144,209,0,0,16,0,18,105,91,145,32,128,18,161,219,145,3,69,193,48,
  0,21,21,0,0,106,0,0,68,244,193,223,0,0,48,128,21,37,0,0,109,0,0,132,244,193,239,0,0,1,0,192,
  0,0,52,130,0,192,0,128,38,3,128,255,48,0,18,32,0,17,0,0,15,0,0,11,19,0,0,68,244,193,242,0,
  0,132,244,193,0,128,4,13,219,144,42,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,
  0,18,66,0,192,0,128,34,0,128,15,0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,
  109,0,0,0,0,37,13,60,160,0,128,10,0,128,9,42,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,
  11,194,255,223,32,0,18,66,0,192,0,128,34,0,128,15,0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,
  0,21,21,0,20,109,0,0,0,0,37,249,59,160,3,69,193,48,128,21,37,0,0,106,0,0,4,244,193,253,0,0,
  1,0,192,0,0,53,0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,249,59,160,2,69,193,208,128,21,37,0,
  0,106,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,13,
  60,160,33,0,0,48,0,20,33,28,144,4,244,193,241,0,0,13,60,160,4,244,193,241,0,0,16,0,21,4,38,192,
  0,0,5,31,0,0,33,60,160,16,0,21,4,38,192,242,0,0,16,128,20,47,0,0,194,12,193,0,128,21,36,128,
  20,193,63,192,242,0,18,26,128,19,0,128,15,32,0,20,61,94,145,131,22,192,209,0,0,48,0,20,253,29,144,33,
  0,0,48,0,20,21,30,144,209,0,0,16,0,18,141,93,145,32,128,18,197,221,145,3,69,193,48,0,21,21,0,0,
  106,0,0,68,244,193,223,0,0,48,128,21,37,0,0,109,0,0,132,244,193,239,0,0,1,0,192,0,0,52,130,0,
  192,0,128,38,3,128,255,48,0,18,32,0,17,0,0,15,0,0,11,19,0,0,68,244,193,242,0,0,132,244,193,0,
  128,4,49,221,144,42,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,0,18,66,0,192,
  0,128,34,0,128,15,0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,109,0,0,0,0,
  37,45,62,160,0,128,10,0,128,9,42,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,
  0,18,66,0,192,0,128,34,0,128,15,0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,
  109,0,0,0,0,37,29,62,160,3,69,193,48,128,21,37,0,0,106,0,0,4,244,193,253,0,0,1,0,192,0,0,
  53,0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,29,62,160,2,69,193,208,128,21,37,0,0,106,0,0,4,
  244,193,253,0,0,1,0,192,0,0,53,0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,45,62,160,33,0,0,
  48,0,20,61,30,144,4,244,193,241,0,0,45,62,160,4,244,193,241,0,0,4,38,192,0,0,5,31,0,0,61,62,
  160,4,38,192,242,0,0,16,128,20,47,0,0,130,45,193,0,128,21,36,128,20,193,63,192,242,0,18,26,128,19,0,
  128,15,32,0,20,90,64,145,131,22,192,209,0,0,48,0,20,26,0,144,33,0,0,48,0,20,50,0,144,209,0,0,
  16,0,18,169,95,145,32,128,18,225,223,145,3,69,193,48,0,21,21,0,0,106,0,0,68,244,193,223,0,0,48,128,
  21,37,0,0,109,0,0,132,244,193,239,0,0,1,0,192,0,0,52,130,0,192,0,128,38,3,128,255,48,0,18,32,
  0,17,0,0,15,0,0,11,19,0,0,68,244,193,242,0,0,132,244,193,0,128,4,77,223,144,42,0,0,4,244,193,
  253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,0,18,66,0,192,0,128,34,0,128,15,0,128,11,0,128,
  15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,109,0,0,0,0,37,74,32,160,0,128,10,0,128,9,42,
  0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,11,194,255,223,32,0,18,66,0,192,0,128,34,0,128,15,
  0,128,11,0,128,15,32,0,17,26,0,0,1,0,192,48,0,21,21,0,20,109,0,0,0,0,37,58,32,160,3,69,
  193,48,128,21,37,0,0,106,0,0,4,244,193,253,0,0,1,0,192,0,0,53,0,0,33,0,0,15,0,0,11,195,
  63,192,48,0,18,58,32,160,2,69,193,208,128,21,37,0,0,106,0,0,4,244,193,253,0,0,1,0,192,0,0,53,
  0,0,33,0,0,15,0,0,11,195,63,192,48,0,18,74,32,160,33,0,0,48,0,20,90,0,144,4,244,193,241,0,
  0,74,32,160,4,244,193,241,0,0,4,38,192,0,0,5,31,0,0,90,32,160,4,38,192,242,0,0,16,128,20,47,
  0,0,1,0,0,0,0,9,30,0,0,131,27,192,48,0,20,201,25,145,0,0,64,129,176,193,130,6,192,3,0,192,
  20,0,9,63,128,8,130,128,145,78,5,192,4,0,0,2,8,192,0,128,2,218,192,145,130,39,192,0,128,21,36,128,
  20,243,0,0,4,0,0,130,7,192,0,128,2,48,128,17,0,128,11,131,91,193,48,128,21,37,0,0,104,0,0,0,
  0,128,1,0,0,0,0,9,30,0,0,130,27,192,16,128,20,146,128,145,196,179,193,250,0,0,4,180,193,253,0,0,
  209,0,0,68,177,193,0,0,4,34,65,145,225,0,0,132,177,193,0,0,4,102,2,145,209,0,0,132,178,193,0,0,
  4,66,65,145,225,0,0,196,178,193,0,0,4,102,2,145,4,181,193,250,0,0,68,181,193,253,0,0,209,0,0,68,
  177,193,0,0,4,114,65,145,225,0,0,132,177,193,0,0,4,146,1,145,209,0,0,132,178,193,0,0,4,214,65,145,
  225,0,0,196,178,193,0,0,4,214,65,145,196,179,193,223,0,0,4,180,193,239,0,0,132,180,193,241,0,0,68,179,
  193,31,0,0,196,180,193,241,0,0,132,179,193,31,0,0,132,181,193,241,0,0,68,180,193,31,0,0,102,34,160,68,
  182,193,250,0,0,132,182,193,253,0,0,209,0,0,68,177,193,0,0,4,6,66,145,225,0,0,132,177,193,0,0,4,
  38,2,145,209,0,0,132,178,193,0,0,4,102,66,145,225,0,0,196,178,193,0,0,4,102,66,145,196,179,193,223,0,
  0,4,180,193,239,0,0,196,181,193,241,0,0,68,179,193,31,0,0,4,182,193,241,0,0,132,179,193,31,0,0,196,
  182,193,241,0,0,68,180,193,31,0,0,1,105,192,194,32,192,3,0,192,20,0,9,63,128,8,114,130,145,68,177,193,
  241,0,0,16,0,18,178,67,145,2,105,192,16,128,21,36,128,20,79,0,192,196,177,193,242,0,0,32,128,18,218,194,
  145,42,0,0,208,0,21,20,0,0,2,0,192,0,128,5,218,130,145,2,105,192,16,128,21,36,128,20,79,0,192,178,
  34,160,132,178,193,241,0,0,16,0,18,178,67,145,2,105,192,16,128,21,36,128,20,130,0,192,0,128,1,47,0,0,
  4,179,193,242,0,0,32,128,18,70,195,145,42,0,0,208,0,21,20,0,0,2,0,192,0,128,5,70,131,145,2,105,
  192,16,128,21,36,128,20,130,0,192,0,128,1,47,0,0,22,35,160,196,179,193,241,0,0,16,0,18,178,67,145,2,
  105,192,16,128,21,36,128,20,2,1,192,0,128,1,47,0,0,68,180,193,242,0,0,32,128,18,178,195,145,42,0,0,
  208,0,21,20,0,0,2,0,192,0,128,5,178,131,145,2,105,192,16,128,21,36,128,20,2,1,192,0,128,1,47,0,
  0,130,35,160,0,0,64,194,143,193,16,128,21,36,128,20,253,0,0,194,143,193,0,128,21,36,128,20,250,0,0,6,
  0,192,196,244,193,239,0,0,2,226,255,224,128,21,194,196,144,210,0,0,128,128,21,42,0,0,226,0,0,128,128,21,
  45,0,0,196,244,193,242,0,0,128,128,21,47,0,0,68,245,193,143,0,0,214,0,0,2,236,192,16,128,21,36,128,
  20,194,63,192,0,128,2,68,244,193,47,0,0,130,45,193,16,128,21,36,128,20,194,63,192,0,128,2,132,244,193,47,
  0,0,68,244,193,0,128,4,118,196,144,68,244,193,242,0,0,132,244,193,47,0,0,210,0,0,68,244,193,0,128,4,
  42,0,0,154,196,144,226,0,0,208,128,20,45,0,0,26,197,148,130,0,0,132,244,193,0,128,4,38,0,0,194,196,
  144,196,244,193,242,0,0,128,128,20,196,244,193,47,0,0,196,181,193,242,0,0,224,128,20,26,133,144,132,180,193,242,
  0,0,224,128,20,30,197,144,68,182,193,15,0,0,132,182,193,31,0,0,196,181,193,239,0,0,4,245,193,242,0,0,
  196,182,193,47,0,0,68,245,193,242,0,0,4,182,193,47,0,0,0,0,64,68,179,193,242,0,0,224,128,20,186,197,
  144,132,180,193,242,0,0,196,181,193,47,0,0,196,180,193,242,0,0,4,182,193,47,0,0,4,181,193,242,0,0,68,
  182,193,47,0,0,68,181,193,242,0,0,132,182,193,47,0,0,132,181,193,242,0,0,196,182,193,47,0,0,4,181,193,
  15,0,0,68,181,193,31,0,0,132,180,193,239,0,0,4,245,193,242,0,0,132,181,193,47,0,0,68,245,193,242,0,
  0,196,180,193,47,0,0,0,0,64,4,178,193,242,0,0,224,128,20,166,198,144,132,180,193,242,0,0,196,181,193,47,
  0,0,196,180,193,242,0,0,4,182,193,47,0,0,4,181,193,242,0,0,68,182,193,47,0,0,68,181,193,242,0,0,
  132,182,193,47,0,0,132,181,193,242,0,0,196,182,193,47,0,0,68,179,193,242,0,0,132,180,193,47,0,0,132,179,
  193,242,0,0,196,180,193,47,0,0,196,179,193,242,0,0,4,181,193,47,0,0,4,180,193,242,0,0,68,181,193,47,
  0,0,68,180,193,242,0,0,132,181,193,47,0,0,196,179,193,15,0,0,4,180,193,31,0,0,68,179,193,239,0,0,
  4,245,193,242,0,0,68,180,193,47,0,0,68,245,193,242,0,0,132,179,193,47,0,0,0,0,64,196,176,193,242,0,
  0,224,128,20,226,199,144,132,180,193,242,0,0,196,181,193,47,0,0,196,180,193,242,0,0,4,182,193,47,0,0,4,
  181,193,242,0,0,68,182,193,47,0,0,68,181,193,242,0,0,132,182,193,47,0,0,132,181,193,242,0,0,196,182,193,
  47,0,0,68,179,193,242,0,0,132,180,193,47,0,0,132,179,193,242,0,0,196,180,193,47,0,0,196,179,193,242,0,
  0,4,181,193,47,0,0,4,180,193,242,0,0,68,181,193,47,0,0,68,180,193,242,0,0,132,181,193,47,0,0,4,
  178,193,242,0,0,68,179,193,47,0,0,68,178,193,242,0,0,132,179,193,47,0,0,132,178,193,242,0,0,196,179,193,
  47,0,0,196,178,193,242,0,0,4,180,193,47,0,0,4,179,193,242,0,0,68,180,193,47,0,0,132,178,193,15,0,
  0,196,178,193,31,0,0,4,178,193,239,0,0,4,245,193,242,0,0,4,179,193,47,0,0,68,245,193,242,0,0,68,
  178,193,47,0,0,0,0,64,196,244,193,242,0,0,32,128,18,2,200,148,4,245,193,242,0,0,32,128,18,10,200,145,
  196,244,193,15,0,192,196,244,193,242,0,0,132,176,193,47,0,0,132,180,193,242,0,0,196,181,193,47,0,0,196,180,
  193,242,0,0,4,182,193,47,0,0,4,181,193,242,0,0,68,182,193,47,0,0,68,181,193,242,0,0,132,182,193,47,
  0,0,132,181,193,242,0,0,196,182,193,47,0,0,68,179,193,242,0,0,132,180,193,47,0,0,132,179,193,242,0,0,
  196,180,193,47,0,0,196,179,193,242,0,0,4,181,193,47,0,0,4,180,193,242,0,0,68,181,193,47,0,0,68,180,
  193,242,0,0,132,181,193,47,0,0,4,178,193,242,0,0,68,179,193,47,0,0,68,178,193,242,0,0,132,179,193,47,
  0,0,132,178,193,242,0,0,196,179,193,47,0,0,196,178,193,242,0,0,4,180,193,47,0,0,4,179,193,242,0,0,
  68,180,193,47,0,0,196,176,193,242,0,0,4,178,193,47,0,0,4,177,193,242,0,0,68,178,193,47,0,0,68,177,
  193,242,0,0,132,178,193,47,0,0,132,177,193,242,0,0,196,178,193,47,0,0,196,177,193,242,0,0,4,179,193,47,
  0,0,68,177,193,15,0,0,132,177,193,31,0,0,196,176,193,239,0,0,4,245,193,242,0,0,196,177,193,47,0,0,
  68,245,193,242,0,0,4,177,193,47,0,0,0,0,64,2,20,192,0,128,20,178,201,144,2,20,192,16,128,20,178,201,
  144,182,35,160,194,143,193,16,128,21,36,128,20,253,0,0,194,143,193,0,128,21,36,128,20,250,0,0,196,243,193,246,
  0,0,218,35,160,2,20,192,0,128,20,246,201,144,2,20,192,16,128,20,22,138,144,13,0,192,194,143,193,0,128,21,
  36,128,20,250,0,0,196,243,193,246,0,0,218,35,160,0,0,64,0,0,21,4,245,193,15,0,192,20,0,0,2,16,
  192,0,128,2,58,202,145,182,35,168,0,0,64,0,0,21,4,245,193,15,0,192,20,0,0,2,40,192,0,128,2,110,
  138,145,2,16,192,0,128,2,106,202,145,150,41,160,222,41,160,0,0,64,4,245,193,15,0,192,1,0,0,162,42,160,
  66,78,193,16,128,21,36,128,20,194,63,192,0,128,2,162,202,145,4,245,193,63,0,0,48,0,21,20,0,0,242,0,
  0,32,128,18,130,202,145,2,16,192,0,128,2,198,202,145,182,35,168,0,0,64,4,245,193,15,0,192,1,0,0,254,
  42,160,222,41,168,66,78,193,16,128,21,36,128,20,194,63,192,0,128,2,254,202,145,4,245,193,63,0,0,48,0,21,
  20,0,0,242,0,0,32,128,18,218,202,145,2,16,192,0,128,2,34,203,145,150,41,160,0,0,64,196,243,193,143,4,
  192,129,2,192,62,42,168,218,32,160,196,243,193,207,2,192,131,2,192,202,42,168,218,32,160,196,243,193,143,2,192,65,
  5,192,62,42,168,196,243,193,143,2,192,193,4,192,62,42,168,218,32,160,196,243,193,15,0,192,193,2,192,62,42,168,
  196,243,193,15,0,192,129,2,192,62,42,168,196,243,193,15,0,192,65,2,192,62,42,168,196,243,193,15,0,192,193,253,
  255,62,42,168,196,243,193,15,0,192,65,253,255,62,42,168,218,32,160,193,2,192,26,42,168,129,2,192,26,42,168,65,
  2,192,26,42,168,65,0,192,26,42,168,193,255,255,26,42,168,129,253,255,26,42,168,218,32,160,196,243,193,15,3,192,
  195,2,192,202,42,168,196,243,193,15,3,192,67,2,192,202,42,168,196,243,193,15,3,192,195,253,255,202,42,168,196,243,
  193,15,3,192,67,253,255,202,42,168,218,32,160,195,2,192,114,42,168,67,2,192,114,42,168,195,253,255,114,42,168,67,
  253,255,114,42,168,129,2,192,26,42,168,65,0,192,26,42,168,193,255,255,26,42,168,129,253,255,26,42,168,218,32,160,
  196,243,193,15,3,192,131,2,192,202,42,168,196,243,193,15,3,192,67,0,192,202,42,168,196,243,193,15,3,192,195,255,
  255,202,42,168,196,243,193,15,3,192,131,253,255,202,42,168,218,32,160,131,2,192,114,42,168,67,0,192,114,42,168,195,
  255,255,114,42,168,131,253,255,114,42,168,193,2,192,26,42,168,65,2,192,26,42,168,193,253,255,26,42,168,65,253,255,
  26,42,168,218,32,160,2,75,192,0,128,21,36,128,20,2,32,192,0,128,2,42,141,145,193,2,192,26,42,168,194,74,
  192,0,128,21,36,128,20,2,32,192,0,128,2,74,141,145,129,2,192,26,42,168,130,74,192,0,128,21,36,128,20,2,
  32,192,0,128,2,106,141,145,65,2,192,26,42,168,130,72,192,0,128,21,36,128,20,2,32,192,0,128,2,138,141,145,
  65,0,192,26,42,168,2,72,192,0,128,21,36,128,20,2,32,192,0,128,2,170,141,145,193,255,255,26,42,168,2,70,
  192,0,128,21,36,128,20,2,32,192,0,128,2,202,141,145,193,253,255,26,42,168,194,69,192,0,128,21,36,128,20,2,
  32,192,0,128,2,234,141,145,129,253,255,26,42,168,130,69,192,0,128,21,36,128,20,2,32,192,0,128,2,10,142,145,
  65,253,255,26,42,168,218,32,160,196,243,193,15,0,192,193,2,192,62,42,168,196,243,193,15,0,192,65,253,255,62,42,
  168,218,32,160,196,243,193,15,0,192,129,2,192,62,42,168,218,32,160,196,243,193,15,0,192,65,2,192,62,42,168,196,
  243,193,15,0,192,193,253,255,62,42,168,218,32,160,193,2,192,26,42,168,218,32,160,129,2,192,26,42,168,129,253,255,
  26,42,168,218,32,160,65,2,192,26,42,168,218,32,160,65,0,192,26,42,168,193,255,255,26,42,168,218,32,160,196,243,
  193,15,3,192,195,2,192,202,42,168,196,243,193,15,3,192,67,253,255,202,42,168,218,32,160,196,243,193,15,3,192,67,
  2,192,202,42,168,196,243,193,15,3,192,195,253,255,202,42,168,218,32,160,195,2,192,114,42,168,67,253,255,114,42,168,
  218,32,160,67,2,192,114,42,168,195,253,255,114,42,168,218,32,160,196,243,193,15,3,192,131,2,192,202,42,168,196,243,
  193,15,3,192,131,253,255,202,42,168,218,32,160,196,243,193,15,3,192,67,0,192,202,42,168,196,243,193,15,3,192,195,
  255,255,202,42,168,218,32,160,193,2,192,26,42,168,65,253,255,26,42,168,218,32,160,131,2,192,114,42,168,131,253,255,
  114,42,168,218,32,160,65,2,192,26,42,168,193,253,255,26,42,168,218,32,160,67,0,192,114,42,168,195,255,255,114,42,
  168,218,32,160,1,183,193,2,6,192,3,0,192,20,0,9,63,128,8,190,143,145,132,176,193,241,0,0,18,0,0,4,
  178,193,0,128,4,230,143,144,241,0,0,196,176,193,242,0,0,16,128,20,4,183,193,47,0,0,78,5,192,4,0,0,
  2,16,192,0,128,2,70,208,145,130,39,192,0,128,21,36,128,20,243,0,0,4,0,0,130,7,192,0,128,2,48,128,
  17,0,128,11,131,111,193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,9,30,0,0,130,27,192,16,
  128,20,254,143,145,0,0,64,10,0,192,194,143,193,16,128,21,36,128,20,253,0,0,2,236,192,16,128,21,36,128,20,
  2,192,255,0,128,2,0,128,15,35,0,0,194,143,193,0,128,21,36,128,20,242,0,0,48,128,20,174,208,144,42,0,
  0,226,0,0,208,128,20,45,0,0,2,105,192,16,128,21,36,128,20,66,0,192,0,128,2,234,144,145,196,176,193,243,
  0,0,132,177,193,242,0,0,0,128,20,130,145,145,2,105,192,16,128,21,36,128,20,130,0,192,0,128,2,26,145,145,
  4,178,193,243,0,0,196,178,193,242,0,0,0,128,20,78,145,145,2,105,192,16,128,21,36,128,20,2,1,192,0,128,
  2,74,145,145,68,179,193,243,0,0,4,180,193,242,0,0,0,128,20,78,145,145,3,0,192,132,177,193,242,0,0,0,
  128,20,130,145,145,68,177,193,242,0,0,16,128,20,130,209,145,50,0,0,4,177,193,0,128,4,130,145,144,243,0,0,
  196,176,193,242,0,0,48,128,20,4,244,193,47,0,0,50,0,0,208,128,20,166,209,144,211,0,0,50,0,0,4,244,
  193,0,128,5,224,128,21,35,0,0,186,212,148,186,212,145,132,185,193,0,128,4,186,212,144,230,145,145,226,0,0,4,
  186,193,0,128,4,186,212,144,186,212,145,50,0,0,68,184,193,0,128,4,14,210,144,122,146,145,226,0,0,196,184,193,
  0,128,4,14,210,144,122,146,145,196,183,193,242,0,0,0,128,20,186,212,145,4,184,193,242,0,0,16,128,20,186,212,
  145,4,185,193,242,0,0,0,128,20,186,212,145,68,185,193,242,0,0,16,128,20,186,212,145,132,185,193,63,0,0,196,
  185,193,223,0,0,4,186,193,239,0,0,68,186,193,15,0,0,132,186,193,31,0,0,186,52,160,50,0,0,4,183,193,
  0,128,4,162,210,144,94,147,145,226,0,0,132,183,193,0,128,4,162,210,144,94,147,145,196,183,193,242,0,0,0,128,
  20,186,212,145,4,184,193,242,0,0,16,128,20,186,212,145,4,185,193,242,0,0,0,128,20,50,211,145,68,185,193,242,
  0,0,16,128,20,50,211,145,68,184,193,242,0,0,132,185,193,47,0,0,132,184,193,242,0,0,196,185,193,47,0,0,
  196,184,193,242,0,0,4,186,193,47,0,0,4,185,193,242,0,0,68,186,193,47,0,0,68,185,193,242,0,0,132,186,
  193,47,0,0,68,184,193,63,0,0,132,184,193,223,0,0,196,184,193,239,0,0,4,185,193,15,0,0,68,185,193,31,
  0,0,186,52,160,196,183,193,242,0,0,0,128,20,146,212,145,4,184,193,242,0,0,16,128,20,146,212,145,4,185,193,
  242,0,0,0,128,20,66,212,145,68,185,193,242,0,0,16,128,20,66,212,145,68,184,193,242,0,0,132,185,193,47,0,
  0,132,184,193,242,0,0,196,185,193,47,0,0,196,184,193,242,0,0,4,186,193,47,0,0,4,185,193,242,0,0,68,
  186,193,47,0,0,68,185,193,242,0,0,132,186,193,47,0,0,4,183,193,242,0,0,68,184,193,47,0,0,68,183,193,
  242,0,0,132,184,193,47,0,0,132,183,193,242,0,0,196,184,193,47,0,0,196,183,193,242,0,0,4,185,193,47,0,
  0,4,184,193,242,0,0,68,185,193,47,0,0,146,52,160,4,183,193,242,0,0,68,184,193,47,0,0,68,183,193,242,
  0,0,132,184,193,47,0,0,132,183,193,242,0,0,196,184,193,47,0,0,196,183,193,242,0,0,4,185,193,47,0,0,
  4,184,193,242,0,0,68,185,193,47,0,0,4,183,193,63,0,0,68,183,193,223,0,0,132,183,193,239,0,0,196,183,
  193,15,0,0,4,184,193,31,0,0,226,0,0,32,128,18,122,213,148,35,0,0,68,188,193,0,128,4,122,213,144,122,
  213,145,50,0,0,132,187,193,0,128,4,202,213,144,202,213,145,50,0,0,196,186,193,0,128,4,126,213,144,126,213,145,
  132,187,193,242,0,0,68,188,193,47,0,0,196,187,193,242,0,0,132,188,193,47,0,0,4,188,193,242,0,0,196,188,
  193,47,0,0,196,186,193,242,0,0,132,187,193,47,0,0,4,187,193,242,0,0,196,187,193,47,0,0,68,187,193,242,
  0,0,4,188,193,47,0,0,196,186,193,63,0,0,4,187,193,15,0,0,68,187,193,31,0,0,0,0,64,132,187,193,
  242,0,0,68,188,193,47,0,0,196,187,193,242,0,0,132,188,193,47,0,0,4,188,193,242,0,0,196,188,193,47,0,
  0,132,187,193,63,0,0,196,187,193,15,0,0,4,188,193,31,0,0,0,0,64,68,188,193,63,0,0,132,188,193,15,
  0,0,196,188,193,31,0,0,0,0,64,130,12,192,0,128,20,2,150,144,130,12,192,16,128,20,2,150,144,98,48,160,
  194,143,193,16,128,21,36,128,20,242,0,0,196,243,193,0,128,5,45,0,0,2,236,192,16,128,21,36,128,20,2,192,
  255,0,128,2,0,128,15,35,0,0,194,143,193,0,128,21,36,128,20,242,0,0,196,243,193,0,128,5,48,128,20,94,
  150,144,2,0,192,42,0,0,174,48,160,0,0,21,20,0,0,2,48,192,0,128,2,126,150,145,230,53,160,0,0,64,
  1,0,0,4,245,193,242,0,0,32,0,21,20,0,0,242,0,0,32,128,18,190,214,148,174,150,145,98,48,168,134,54,
  160,2,8,192,0,128,2,190,214,145,98,48,168,0,0,64,1,0,0,4,245,193,242,0,0,32,0,21,20,0,0,242,
  0,0,32,128,18,254,214,148,238,150,145,230,53,168,198,54,160,2,8,192,0,128,2,254,214,145,230,53,160,0,0,64,
  196,243,193,143,4,192,129,253,255,102,54,168,70,48,160,196,243,193,207,2,192,4,245,193,143,253,255,194,54,168,70,48,
  160,196,243,193,143,2,192,193,250,255,102,54,168,196,243,193,143,2,192,65,251,255,102,54,168,70,48,160,196,243,193,15,
  0,192,65,253,255,102,54,168,196,243,193,15,0,192,129,253,255,102,54,168,196,243,193,15,0,192,193,253,255,102,54,168,
  196,243,193,15,0,192,65,2,192,102,54,168,196,243,193,15,0,192,193,2,192,102,54,168,70,48,160,65,253,255,0,0,
  21,20,0,0,2,48,192,0,128,2,194,151,145,98,48,168,129,253,255,0,0,21,20,0,0,2,48,192,0,128,2,222,
  151,145,98,48,168,193,253,255,0,0,21,20,0,0,2,48,192,0,128,2,250,151,145,98,48,168,193,255,255,0,0,21,
  20,0,0,2,48,192,0,128,2,22,152,145,98,48,168,65,0,192,0,0,21,20,0,0,2,48,192,0,128,2,50,152,
  145,98,48,168,129,2,192,0,0,21,20,0,0,2,48,192,0,128,2,78,152,145,98,48,168,70,48,160,196,243,193,15,
  3,192,4,245,193,79,253,255,194,54,168,196,243,193,15,3,192,4,245,193,207,253,255,194,54,168,196,243,193,15,3,192,
  4,245,193,79,2,192,194,54,168,196,243,193,15,3,192,4,245,193,207,2,192,194,54,168,70,48,160,4,245,193,79,253,
  255,130,54,168,4,245,193,207,253,255,130,54,168,4,245,193,79,2,192,130,54,168,4,245,193,207,2,192,130,54,168,129,
  253,255,0,0,21,20,0,0,2,48,192,0,128,2,242,152,145,98,48,168,193,255,255,0,0,21,20,0,0,2,48,192,
  0,128,2,14,153,145,98,48,168,65,0,192,0,0,21,20,0,0,2,48,192,0,128,2,42,153,145,98,48,168,129,2,
  192,0,0,21,20,0,0,2,48,192,0,128,2,70,153,145,98,48,168,70,48,160,196,243,193,15,3,192,4,245,193,143,
  253,255,194,54,168,196,243,193,15,3,192,4,245,193,207,255,255,194,54,168,196,243,193,15,3,192,4,245,193,79,0,192,
  194,54,168,196,243,193,15,3,192,4,245,193,143,2,192,194,54,168,70,48,160,4,245,193,143,253,255,130,54,168,4,245,
  193,207,255,255,130,54,168,4,245,193,79,0,192,130,54,168,4,245,193,143,2,192,130,54,168,65,253,255,0,0,21,20,
  0,0,2,48,192,0,128,2,234,153,145,98,48,168,193,253,255,0,0,21,20,0,0,2,48,192,0,128,2,6,154,145,
  98,48,168,65,2,192,0,0,21,20,0,0,2,48,192,0,128,2,34,154,145,98,48,168,193,2,192,0,0,21,20,0,
  0,2,48,192,0,128,2,62,154,145,98,48,168,70,48,160,130,69,192,0,128,21,36,128,20,2,0,224,0,128,2,118,
  154,145,65,253,255,0,0,21,20,0,0,2,48,192,0,128,2,118,154,145,98,48,168,194,69,192,0,128,21,36,128,20,
  2,0,224,0,128,2,170,154,145,129,253,255,0,0,21,20,0,0,2,48,192,0,128,2,170,154,145,98,48,168,2,70,
  192,0,128,21,36,128,20,2,0,224,0,128,2,222,154,145,193,253,255,0,0,21,20,0,0,2,48,192,0,128,2,222,
  154,145,98,48,168,2,72,192,0,128,21,36,128,20,2,0,224,0,128,2,18,155,145,193,255,255,0,0,21,20,0,0,
  2,48,192,0,128,2,18,155,145,98,48,168,130,72,192,0,128,21,36,128,20,2,0,224,0,128,2,70,155,145,65,0,
  192,0,0,21,20,0,0,2,48,192,0,128,2,70,155,145,98,48,168,130,74,192,0,128,21,36,128,20,2,0,224,0,
  128,2,122,155,145,65,2,192,0,0,21,20,0,0,2,48,192,0,128,2,122,155,145,98,48,168,194,74,192,0,128,21,
  36,128,20,2,0,224,0,128,2,174,155,145,129,2,192,0,0,21,20,0,0,2,48,192,0,128,2,174,155,145,98,48,
  168,2,75,192,0,128,21,36,128,20,2,0,224,0,128,2,226,155,145,193,2,192,0,0,21,20,0,0,2,48,192,0,
  128,2,226,155,145,98,48,168,70,48,160,196,243,193,15,0,192,65,253,255,102,54,168,196,243,193,15,0,192,193,2,192,
  102,54,168,70,48,160,196,243,193,15,0,192,129,253,255,102,54,168,70,48,160,196,243,193,15,0,192,193,253,255,102,54,
  168,196,243,193,15,0,192,65,2,192,102,54,168,70,48,160,65,253,255,0,0,21,20,0,0,2,48,192,0,128,2,94,
  156,145,98,48,168,70,48,160,129,253,255,0,0,21,20,0,0,2,48,192,0,128,2,126,156,145,98,48,168,129,2,192,
  0,0,21,20,0,0,2,48,192,0,128,2,154,156,145,98,48,168,70,48,160,193,253,255,0,0,21,20,0,0,2,48,
  192,0,128,2,186,156,145,98,48,168,70,48,160,193,255,255,0,0,21,20,0,0,2,48,192,0,128,2,218,156,145,98,
  48,168,65,0,192,0,0,21,20,0,0,2,48,192,0,128,2,246,156,145,98,48,168,70,48,160,196,243,193,15,3,192,
  4,245,193,79,253,255,194,54,168,196,243,193,15,3,192,4,245,193,207,2,192,194,54,168,70,48,160,196,243,193,15,3,
  192,4,245,193,207,253,255,194,54,168,196,243,193,15,3,192,4,245,193,79,2,192,194,54,168,70,48,160,4,245,193,79,
  253,255,130,54,168,4,245,193,207,2,192,130,54,168,70,48,160,4,245,193,207,253,255,130,54,168,4,245,193,79,2,192,
  130,54,168,70,48,160,196,243,193,15,3,192,4,245,193,143,253,255,194,54,168,196,243,193,15,3,192,4,245,193,143,2,
  192,194,54,168,70,48,160,196,243,193,15,3,192,4,245,193,207,255,255,194,54,168,196,243,193,15,3,192,4,245,193,79,
  0,192,194,54,168,70,48,160,65,253,255,0,0,21,20,0,0,2,48,192,0,128,2,254,157,145,98,48,168,193,2,192,
  0,0,21,20,0,0,2,48,192,0,128,2,26,158,145,98,48,168,70,48,160,4,245,193,143,253,255,130,54,168,4,245,
  193,143,2,192,130,54,168,70,48,160,193,253,255,0,0,21,20,0,0,2,48,192,0,128,2,86,158,145,98,48,168,65,
  2,192,0,0,21,20,0,0,2,48,192,0,128,2,114,158,145,98,48,168,70,48,160,4,245,193,207,255,255,130,54,168,
  4,245,193,79,0,192,130,54,168,70,48,160,1,183,193,14,6,192,2,6,192,239,35,168,129,176,193,142,18,192,130,6,
  192,239,35,168,15,36,168,65,38,192,142,211,193,2,1,192,239,35,168,68,184,193,242,0,0,32,128,18,118,223,148,118,
  223,145,1,189,193,14,250,255,2,6,192,239,35,168,1,195,193,142,237,255,130,6,192,239,35,168,65,184,193,206,254,255,
  66,1,192,239,35,168,15,36,168,65,38,192,142,212,193,2,1,192,239,35,168,132,185,193,242,0,0,32,128,18,118,223,
  148,118,223,145,1,189,193,14,250,255,2,6,192,239,35,168,1,195,193,142,237,255,130,6,192,239,35,168,129,185,193,142,
  253,255,66,1,192,239,35,168,15,36,168,65,38,192,142,213,193,2,1,192,239,35,168,1,189,193,14,250,255,2,6,192,
  239,35,168,1,195,193,142,237,255,130,6,192,239,35,168,196,249,193,242,0,0,4,250,193,0,128,4,68,250,193,0,128,
  5,4,244,193,47,0,0,196,250,193,242,0,0,4,251,193,0,128,4,68,251,193,0,128,5,132,244,193,47,0,0,196,
  251,193,242,0,0,4,252,193,0,128,4,68,252,193,0,128,5,4,245,193,47,0,0,68,184,193,242,0,0,32,128,18,
  87,192,148,87,192,145,132,186,193,241,0,0,4,244,193,242,0,0,132,244,193,0,128,4,163,192,148,132,185,193,242,0,
  0,32,128,18,87,192,148,87,192,145,132,186,193,241,0,0,4,244,193,242,0,0,4,245,193,0,128,4,27,193,148,196,
  249,193,242,0,0,68,38,192,47,0,0,4,250,193,242,0,0,132,38,192,47,0,0,68,250,193,242,0,0,196,38,192,
  47,0,0,132,250,193,242,0,0,4,39,192,47,0,0,4,184,193,241,0,0,27,33,160,132,185,193,242,0,0,32,128,
  18,211,192,148,211,192,145,132,186,193,241,0,0,132,244,193,242,0,0,4,245,193,0,128,4,27,193,148,196,250,193,242,
  0,0,68,38,192,47,0,0,4,251,193,242,0,0,132,38,192,47,0,0,68,251,193,242,0,0,196,38,192,47,0,0,
  132,251,193,242,0,0,4,39,192,47,0,0,68,185,193,241,0,0,16,0,18,111,193,145,20,0,0,2,8,192,0,128,
  2,111,193,145,130,39,192,16,128,21,36,128,20,243,0,0,20,0,0,130,7,192,0,128,2,48,128,17,0,128,11,131,
  131,193,48,128,21,37,0,0,104,0,0,10,64,192,0,0,128,0,0,64,16,128,21,36,0,0,242,0,0,208,128,20,
  47,0,64,29,0,0,48,0,21,2,111,193,115,33,168,20,0,0,242,0,0,32,128,18,139,193,145,219,193,148,130,15,
  192,0,128,2,0,128,11,0,128,21,37,0,0,98,0,0,0,128,8,219,193,148,139,129,145,48,0,21,2,111,193,115,
  33,168,225,0,0,0,0,64,130,113,193,115,33,168,0,0,64,131,2,192,142,137,192,135,33,168,0,0,64,66,116,193,
  115,33,168,194,115,193,115,33,168,0,0,64,194,113,193,115,33,168,66,108,193,115,33,168,130,113,193,115,33,168,66,113,
  193,115,33,168,194,108,193,115,33,168,0,0,64,194,113,193,115,33,168,130,113,193,115,33,168,130,108,193,115,33,168,66,
  113,193,115,33,168,66,111,193,115,33,168,194,110,193,115,33,168,0,0,64,130,113,193,115,33,168,130,108,193,115,33,168,
  66,111,193,115,33,168,194,110,193,115,33,168,195,2,192,142,149,192,135,33,168,67,253,255,142,145,192,135,33,168,67,2,
  192,142,149,192,135,33,168,195,253,255,142,145,192,135,33,168,0,0,64,194,113,193,115,33,168,66,108,193,115,33,168,66,
  113,193,115,33,168,194,108,193,115,33,168,131,2,192,142,137,192,135,33,168,131,253,255,142,133,192,135,33,168,67,0,192,
  142,157,192,135,33,168,195,255,255,142,157,192,135,33,168,0,0,64,194,113,193,115,33,168,66,108,193,115,33,168,0,0,
  64,130,113,193,115,33,168,0,0,64,194,113,193,115,33,168,0,0,64,130,113,193,115,33,168,130,108,193,115,33,168,0,
  0,64,66,113,193,115,33,168,0,0,64,195,2,192,142,149,192,135,33,168,67,253,255,142,145,192,135,33,168,0,0,64,
  130,113,193,115,33,168,130,108,193,115,33,168,0,0,64,66,111,193,115,33,168,194,110,193,115,33,168,0,0,64,131,2,
  192,142,137,192,135,33,168,131,253,255,142,133,192,135,33,168,0,0,64,194,113,193,115,33,168,66,108,193,115,33,168,0,
  0,64,66,113,193,115,33,168,194,108,193,115,33,168,0,0,64,20,0,0,243,0,0,0,0,21,20,0,9,0,0,20,
  63,128,8,239,131,145,0,0,64,68,38,192,15,0,192,132,38,192,15,0,192,196,38,192,15,0,192,4,39,192,15,0,
  192,196,183,193,250,0,0,4,184,193,253,0,0,210,0,0,132,188,193,0,128,4,95,196,145,226,0,0,196,188,193,0,
  128,4,119,132,145,68,188,193,15,0,192,132,188,193,15,0,192,196,188,193,15,0,192,210,0,0,4,187,193,0,128,4,
  3,197,145,226,0,0,68,187,193,0,128,4,3,197,145,210,0,0,196,187,193,0,128,4,183,196,145,226,0,0,4,188,
  193,0,128,4,255,133,145,68,188,193,242,0,0,132,187,193,47,0,0,68,188,193,15,0,192,132,188,193,242,0,0,196,
  187,193,47,0,0,132,188,193,15,0,192,196,188,193,242,0,0,4,188,193,47,0,0,196,188,193,15,0,192,255,37,160,
  210,0,0,196,187,193,0,128,4,159,197,145,226,0,0,4,188,193,0,128,4,159,197,145,132,187,193,242,0,0,196,186,
  193,47,0,0,196,187,193,242,0,0,4,187,193,47,0,0,4,188,193,242,0,0,68,187,193,47,0,0,68,188,193,242,
  0,0,132,187,193,47,0,0,132,188,193,242,0,0,196,187,193,47,0,0,196,188,193,242,0,0,4,188,193,47,0,0,
  68,188,193,15,0,192,132,188,193,15,0,192,196,188,193,15,0,192,255,37,160,68,188,193,242,0,0,196,186,193,47,0,
  0,132,187,193,15,0,192,68,188,193,15,0,192,132,188,193,242,0,0,4,187,193,47,0,0,196,187,193,15,0,192,132,
  188,193,15,0,192,196,188,193,242,0,0,68,187,193,47,0,0,4,188,193,15,0,192,196,188,193,15,0,192,210,0,0,
  32,128,18,15,135,145,226,0,0,32,128,18,15,135,145,196,177,193,241,0,0,16,0,18,139,70,145,68,177,193,250,0,
  0,210,0,0,132,178,193,0,128,4,167,134,145,18,0,0,4,179,193,0,128,4,167,134,145,210,0,0,196,179,193,0,
  128,4,219,134,145,18,0,0,68,180,193,0,128,4,219,134,145,196,176,193,15,0,192,68,177,193,15,0,192,132,177,193,
  15,0,192,139,40,160,132,176,193,242,0,0,196,176,193,47,0,0,4,178,193,0,128,4,139,136,144,4,178,193,242,0,
  0,196,176,193,47,0,0,132,178,193,242,0,0,68,177,193,47,0,0,196,178,193,242,0,0,132,177,193,47,0,0,139,
  40,160,68,179,193,242,0,0,196,176,193,47,0,0,196,179,193,242,0,0,68,177,193,47,0,0,4,180,193,242,0,0,
  132,177,193,47,0,0,139,40,160,2,105,192,224,128,21,36,128,20,66,0,192,0,128,2,91,135,145,210,0,0,132,177,
  193,0,128,4,139,136,145,4,177,193,242,0,0,196,176,193,47,0,0,68,177,193,15,0,192,132,177,193,15,0,192,115,
  39,160,196,176,193,15,0,192,68,177,193,15,0,192,132,177,193,15,0,192,2,105,192,224,128,21,36,128,20,130,0,192,
  0,128,2,255,135,145,210,0,0,196,178,193,0,128,4,187,135,145,68,178,193,242,0,0,4,178,193,47,0,0,132,178,
  193,15,0,192,196,178,193,15,0,192,196,176,193,242,0,0,4,178,193,0,128,4,255,135,144,4,178,193,242,0,0,196,
  176,193,47,0,0,132,178,193,242,0,0,68,177,193,47,0,0,196,178,193,242,0,0,132,177,193,47,0,0,2,105,192,
  224,128,21,36,128,20,2,1,192,0,128,2,139,136,145,210,0,0,4,180,193,0,128,4,71,136,145,132,179,193,242,0,
  0,68,179,193,47,0,0,196,179,193,15,0,192,4,180,193,15,0,192,196,176,193,242,0,0,68,179,193,0,128,4,139,
  136,144,68,179,193,242,0,0,196,176,193,47,0,0,196,179,193,242,0,0,68,177,193,47,0,0,4,180,193,242,0,0,
  132,177,193,47,0,0,4,183,193,242,0,0,4,245,193,47,0,0,68,183,193,242,0,0,132,244,193,47,0,0,132,183,
  193,0,128,5,68,38,192,47,0,0,68,177,193,250,0,0,132,177,193,253,0,0,196,186,193,241,0,0,4,244,193,31,
  0,0,226,0,0,4,187,193,0,128,4,251,200,145,210,0,0,68,187,193,0,128,4,79,137,145,132,187,193,241,0,0,
  226,0,0,196,187,193,0,128,4,35,201,145,210,0,0,4,188,193,0,128,4,79,137,145,68,188,193,241,0,0,226,0,
  0,132,188,193,0,128,4,75,201,145,210,0,0,196,188,193,0,128,4,79,137,145,1,0,192,4,244,193,242,0,0,16,
  128,20,47,0,0,196,176,193,242,0,0,132,245,193,47,0,0,4,244,193,0,128,5,132,244,193,0,128,4,191,137,144,
  4,245,193,242,0,0,132,245,193,0,128,4,4,39,192,47,0,0,132,244,193,242,0,0,196,176,193,47,0,0,68,177,
  193,15,0,192,132,177,193,15,0,192,127,42,160,4,245,193,242,0,0,132,244,193,0,128,4,4,39,192,47,0,0,68,
  177,193,250,0,0,132,177,193,253,0,0,226,0,0,4,187,193,0,128,4,7,202,145,210,0,0,68,187,193,0,128,4,
  127,138,145,196,176,193,242,0,0,132,38,192,47,0,0,226,0,0,196,187,193,0,128,4,75,202,145,210,0,0,4,188,
  193,0,128,4,75,202,145,132,187,193,242,0,0,196,38,192,47,0,0,0,0,64,226,0,0,132,188,193,0,128,4,123,
  202,145,210,0,0,196,188,193,0,128,4,123,202,145,68,188,193,242,0,0,196,38,192,47,0,0,0,0,64,68,187,193,
  253,0,0,196,176,193,242,0,0,4,244,193,47,0,0,196,186,193,242,0,0,132,244,193,47,0,0,132,187,193,241,0,
  0,226,0,0,4,188,193,0,128,4,219,138,145,68,188,193,241,0,0,226,0,0,196,188,193,0,128,4,219,138,145,1,
  0,192,4,245,193,31,0,0,132,244,193,242,0,0,16,128,20,255,202,144,4,244,193,0,128,4,35,139,144,4,244,193,
  242,0,0,132,38,192,47,0,0,132,244,193,242,0,0,196,38,192,47,0,0,0,0,64,132,38,192,15,0,192,4,245,
  193,242,0,0,196,38,192,47,0,0,0,0,64,112,12,168,163,2,168,118,25,168,132,37,192,242,0,0,32,128,18,95,
  203,145,207,50,160,6,0,192,132,170,192,15,0,192,132,45,193,15,0,192,78,5,192,4,0,0,2,8,192,0,128,2,
  191,203,145,130,39,192,0,128,21,36,128,20,243,0,0,4,0,0,130,7,192,0,128,2,48,128,17,0,128,11,131,225,
  193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,9,30,0,0,130,27,192,16,128,20,119,139,145,179,
  61,168,132,37,192,143,0,0,0,0,64,194,170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,
  130,0,0,31,128,9,38,0,64,194,170,192,128,128,21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,
  21,36,128,20,2,32,192,16,128,21,47,0,64,0,0,21,20,0,0,2,40,192,0,128,2,231,203,145,0,0,64,0,
  0,21,20,0,0,2,40,192,0,128,2,127,140,145,2,20,192,16,128,20,231,139,144,15,44,168,231,43,160,0,0,64,
  0,0,21,20,0,0,2,40,192,0,128,2,171,140,145,2,20,192,0,128,20,231,139,144,15,44,168,231,43,160,0,0,
  64,0,0,21,20,0,0,2,40,192,0,128,2,211,140,145,2,20,192,16,128,20,231,139,144,15,44,160,0,0,64,0,
  0,21,20,0,0,2,40,192,0,128,2,7,141,145,2,20,192,16,128,20,231,139,144,15,44,168,130,22,192,16,128,20,
  231,139,144,0,0,64,1,0,0,23,45,160,231,43,168,48,0,21,20,0,0,242,0,0,32,128,18,19,205,145,2,40,
  192,0,128,2,231,203,145,0,0,64,1,0,0,91,45,160,2,20,192,16,128,20,87,141,144,15,44,168,91,45,160,231,
  43,168,48,0,21,20,0,0,242,0,0,32,128,18,67,205,145,2,40,192,0,128,2,139,141,145,2,20,192,16,128,20,
  231,139,144,15,44,160,0,0,64,1,0,0,2,20,192,16,128,20,207,205,144,167,45,160,231,43,168,48,0,21,20,0,
  0,242,0,0,32,128,18,163,205,145,2,40,192,0,128,2,231,203,145,0,0,64,15,44,168,48,0,21,20,0,0,242,
  0,0,32,128,18,203,205,145,2,40,192,0,128,2,15,204,145,0,0,64,1,0,0,27,46,160,2,20,192,16,128,20,
  23,142,144,15,44,168,130,22,192,16,128,20,27,206,144,231,43,168,48,0,21,20,0,0,242,0,0,32,128,18,251,205,
  145,2,40,192,0,128,2,87,142,145,2,20,192,16,128,20,231,139,144,15,44,168,130,22,192,16,128,20,231,139,144,0,
  0,64,129,2,192,175,44,168,191,43,160,131,2,192,243,45,168,191,43,160,65,5,192,215,44,168,193,4,192,215,44,168,
  191,43,160,193,2,192,87,44,168,129,2,192,87,44,168,65,2,192,87,44,168,193,253,255,131,44,168,65,253,255,131,44,
  168,191,43,160,193,2,192,63,44,168,129,2,192,63,44,168,65,2,192,63,44,168,65,0,192,63,44,168,193,255,255,63,
  44,168,129,253,255,63,44,168,191,43,160,195,2,192,59,45,168,67,2,192,59,45,168,195,253,255,143,45,168,67,253,255,
  143,45,168,191,43,160,195,2,192,11,45,168,67,2,192,11,45,168,195,253,255,11,45,168,67,253,255,11,45,168,129,2,
  192,63,44,168,65,0,192,63,44,168,193,255,255,63,44,168,129,253,255,63,44,168,191,43,160,131,2,192,59,45,168,67,
  0,192,143,45,168,195,255,255,143,45,168,131,253,255,143,45,168,191,43,160,131,2,192,11,45,168,67,0,192,11,45,168,
  195,255,255,11,45,168,131,253,255,11,45,168,193,2,192,63,44,168,65,2,192,63,44,168,193,253,255,63,44,168,65,253,
  255,63,44,168,191,43,160,193,2,192,0,0,21,20,0,0,2,40,192,0,128,2,231,143,145,66,72,192,16,128,21,36,
  128,20,0,128,5,231,143,145,231,43,168,129,2,192,0,0,21,20,0,0,2,40,192,0,128,2,23,144,145,66,72,192,
  16,128,21,36,128,20,0,128,5,23,144,145,231,43,168,65,2,192,0,0,21,20,0,0,2,40,192,0,128,2,71,144,
  145,66,72,192,16,128,21,36,128,20,0,128,5,71,144,145,231,43,168,65,0,192,0,0,21,20,0,0,2,40,192,0,
  128,2,119,144,145,66,72,192,16,128,21,36,128,20,0,128,5,119,144,145,231,43,168,193,255,255,0,0,21,20,0,0,
  2,40,192,0,128,2,167,144,145,66,72,192,16,128,21,36,128,20,0,128,5,167,144,145,231,43,168,193,253,255,0,0,
  21,20,0,0,2,40,192,0,128,2,215,144,145,66,72,192,16,128,21,36,128,20,0,128,5,215,144,145,231,43,168,129,
  253,255,0,0,21,20,0,0,2,40,192,0,128,2,7,145,145,66,72,192,16,128,21,36,128,20,0,128,5,7,145,145,
  231,43,168,65,253,255,0,0,21,20,0,0,2,40,192,0,128,2,55,145,145,66,72,192,16,128,21,36,128,20,0,128,
  5,55,145,145,231,43,168,191,43,160,193,2,192,87,44,168,65,253,255,131,44,168,191,43,160,129,2,192,87,44,168,191,
  43,160,65,2,192,87,44,168,193,253,255,131,44,168,191,43,160,193,2,192,63,44,168,191,43,160,129,2,192,63,44,168,
  129,253,255,63,44,168,191,43,160,65,2,192,63,44,168,191,43,160,65,0,192,63,44,168,193,255,255,63,44,168,191,43,
  160,195,2,192,59,45,168,67,253,255,143,45,168,191,43,160,67,2,192,59,45,168,195,253,255,143,45,168,191,43,160,195,
  2,192,11,45,168,67,253,255,11,45,168,191,43,160,129,2,192,63,44,168,129,253,255,63,44,168,191,43,160,67,2,192,
  11,45,168,195,253,255,11,45,168,191,43,160,65,0,192,63,44,168,193,255,255,63,44,168,191,43,160,131,2,192,59,45,
  168,131,253,255,143,45,168,191,43,160,67,0,192,143,45,168,195,255,255,143,45,168,191,43,160,193,2,192,63,44,168,65,
  253,255,63,44,168,191,43,160,131,2,192,11,45,168,131,253,255,11,45,168,191,43,160,65,2,192,63,44,168,193,253,255,
  63,44,168,191,43,160,67,0,192,11,45,168,195,255,255,11,45,168,191,43,160,0,0,21,20,0,0,2,40,192,0,128,
  2,203,146,145,66,72,192,16,128,21,36,128,20,0,128,5,203,146,145,87,54,160,0,0,64,6,0,192,132,170,192,15,
  0,192,132,45,193,15,0,192,4,37,192,254,0,0,193,2,192,159,50,168,129,2,192,159,50,168,65,2,192,159,50,168,
  65,0,192,159,50,168,193,255,255,159,50,168,193,253,255,159,50,168,129,253,255,159,50,168,65,253,255,159,50,168,132,37,
  192,241,0,0,16,0,18,191,83,148,66,72,192,16,128,21,36,128,20,15,128,192,196,37,192,242,0,0,32,128,18,203,
  147,145,78,5,192,4,0,0,2,8,192,0,128,2,167,211,145,130,39,192,0,128,21,36,128,20,0,128,5,167,147,145,
  4,0,0,130,7,192,0,128,2,0,128,11,131,245,193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,
  9,30,0,0,130,27,192,16,128,20,95,147,145,132,37,192,143,0,0,0,0,64,4,37,192,241,0,0,196,37,192,243,
  0,0,48,0,20,66,72,192,16,128,21,36,128,20,15,128,192,20,0,0,242,0,0,32,128,18,219,211,145,78,5,192,
  4,0,0,2,8,192,0,128,2,75,212,145,130,39,192,0,128,21,36,128,20,0,128,5,75,148,145,4,0,0,130,7,
  192,0,128,2,0,128,11,67,249,193,48,128,21,37,0,0,104,0,0,0,0,128,1,0,0,0,0,9,30,0,0,130,
  27,192,16,128,20,3,148,145,4,37,192,241,0,0,196,37,192,243,0,0,55,54,160,2,25,192,16,128,20,87,213,144,
  130,22,192,16,128,20,199,212,144,68,35,192,242,0,0,32,128,18,199,212,145,194,170,192,128,128,21,36,128,20,143,0,
  192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,196,34,192,242,0,0,32,128,18,31,213,145,2,
  59,192,16,128,21,37,128,20,130,241,193,96,128,21,36,128,20,0,128,5,31,149,145,194,170,192,128,128,21,36,128,20,
  15,0,192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,4,35,192,242,0,0,32,128,18,87,213,
  145,194,170,192,128,128,21,36,128,20,79,0,192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,132,
  35,192,242,0,0,32,128,18,143,213,145,194,170,192,128,128,21,36,128,20,207,0,192,194,45,193,128,128,21,36,128,20,
  130,0,0,31,128,9,38,0,0,196,35,192,242,0,0,32,128,18,199,213,145,194,170,192,128,128,21,36,128,20,15,1,
  192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,4,36,192,242,0,0,32,128,18,255,213,145,194,
  170,192,128,128,21,36,128,20,79,1,192,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,68,36,192,
  242,0,0,32,128,18,55,214,145,194,170,192,128,128,21,36,128,20,143,1,192,194,45,193,128,128,21,36,128,20,130,0,
  0,31,128,9,38,0,0,48,0,20,20,0,0,242,0,0,32,128,18,119,212,145,132,37,192,143,0,0,0,0,64,194,
  170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,64,194,170,192,
  128,128,21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,
  64,0,0,21,66,72,192,16,128,21,36,128,20,2,128,192,0,128,66,2,20,192,16,128,20,3,151,144,194,170,192,128,
  128,21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,0,
  194,170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,167,51,
  160,2,20,192,0,128,20,107,151,144,194,170,192,128,128,21,36,128,20,130,0,0,15,128,9,38,0,0,130,45,193,128,
  128,21,36,128,20,2,32,192,16,128,21,47,0,0,194,170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,
  36,128,20,130,0,0,31,128,9,38,0,0,167,51,160,2,20,192,16,128,20,223,151,144,194,170,192,128,128,21,36,128,
  20,130,0,0,15,128,9,38,0,0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,0,2,25,192,16,
  128,20,167,211,144,194,170,192,128,128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,
  38,0,0,167,51,160,2,20,192,16,128,20,83,152,144,194,170,192,128,128,21,36,128,20,130,0,0,15,128,9,38,0,
  0,130,45,193,128,128,21,36,128,20,2,32,192,16,128,21,47,0,0,130,22,192,16,128,20,167,211,144,194,170,192,128,
  128,21,36,128,20,15,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,9,38,0,0,167,51,160,1,0,0,
  48,0,21,20,0,0,242,0,0,32,128,18,131,216,145,66,72,192,16,128,21,36,128,20,2,128,192,0,128,66,175,54,
  168,183,216,145,87,54,160,0,0,64,175,54,168,215,216,145,2,20,192,16,128,20,87,150,144,127,54,168,87,54,160,0,
  0,64,175,54,168,247,216,145,2,20,192,0,128,20,87,150,144,127,54,168,87,54,160,0,0,64,175,54,168,31,217,145,
  2,20,192,16,128,20,87,150,144,127,54,168,2,25,192,16,128,20,87,150,144,0,0,64,175,54,168,71,217,145,2,20,
  192,16,128,20,87,150,144,127,54,168,130,22,192,16,128,20,87,150,144,0,0,64,1,0,0,48,0,21,66,72,192,16,
  128,21,36,128,20,2,128,192,0,128,2,87,150,145,20,0,0,242,0,0,32,128,18,79,217,145,0,0,64,1,0,0,
  48,0,21,66,72,192,16,128,21,36,128,20,2,128,192,0,128,2,179,153,145,20,0,0,242,0,0,32,128,18,131,217,
  145,0,0,64,2,20,192,16,128,20,87,150,144,127,54,168,87,54,160,1,0,0,48,0,21,66,72,192,16,128,21,36,
  128,20,2,128,192,0,128,2,251,153,145,20,0,0,242,0,0,32,128,18,203,217,145,0,0,64,2,20,192,0,128,20,
  87,150,144,127,54,168,87,54,160,129,2,192,175,54,168,151,151,145,167,51,160,131,2,192,127,56,168,151,151,145,167,51,
  160,65,5,192,175,54,168,11,152,145,193,4,192,175,54,168,11,152,145,167,51,160,193,2,192,175,54,168,199,150,145,129,
  2,192,175,54,168,199,150,145,65,2,192,175,54,168,199,150,145,193,253,255,175,54,168,47,151,145,65,253,255,175,54,168,
  47,151,145,167,51,160,193,2,192,175,54,168,3,151,145,129,2,192,175,54,168,3,151,145,65,2,192,175,54,168,3,151,
  145,65,0,192,175,54,168,3,151,145,193,255,255,175,54,168,3,151,145,129,253,255,175,54,168,3,151,145,167,51,160,195,
  2,192,127,56,168,199,150,145,67,2,192,127,56,168,199,150,145,195,253,255,127,56,168,47,151,145,67,253,255,127,56,168,
  47,151,145,167,51,160,195,2,192,127,56,168,3,151,145,67,2,192,127,56,168,3,151,145,195,253,255,127,56,168,3,151,
  145,67,253,255,127,56,168,3,151,145,129,2,192,175,54,168,3,151,145,65,0,192,175,54,168,3,151,145,193,255,255,175,
  54,168,3,151,145,129,253,255,175,54,168,3,151,145,167,51,160,131,2,192,127,56,168,199,150,145,67,0,192,127,56,168,
  47,151,145,195,255,255,127,56,168,47,151,145,131,253,255,127,56,168,47,151,145,167,51,160,131,2,192,127,56,168,3,151,
  145,67,0,192,127,56,168,3,151,145,195,255,255,127,56,168,3,151,145,131,253,255,127,56,168,3,151,145,193,2,192,175,
  54,168,3,151,145,65,2,192,175,54,168,3,151,145,193,253,255,175,54,168,3,151,145,65,253,255,175,54,168,3,151,145,
  167,51,160,129,2,192,251,56,168,75,52,160,1,0,0,131,2,192,48,0,21,66,72,192,16,128,21,36,128,20,2,128,
  192,0,128,2,75,156,145,20,0,0,242,0,0,32,128,18,27,220,145,107,60,160,2,20,192,16,128,20,103,156,144,127,
  54,168,2,25,192,16,128,20,107,220,144,87,54,168,75,52,160,65,5,192,35,57,168,193,4,192,35,57,168,75,52,160,
  193,2,192,187,56,168,129,2,192,187,56,168,65,2,192,187,56,168,193,253,255,219,56,168,65,253,255,219,56,168,75,52,
  160,193,2,192,171,56,168,129,2,192,171,56,168,65,2,192,171,56,168,65,0,192,171,56,168,193,255,255,171,56,168,129,
  253,255,171,56,168,75,52,160,195,2,192,127,57,168,67,2,192,127,57,168,195,253,255,199,57,168,67,253,255,199,57,168,
  75,52,160,195,2,192,75,57,168,67,2,192,75,57,168,195,253,255,75,57,168,67,253,255,75,57,168,129,2,192,171,56,
  168,65,0,192,171,56,168,193,255,255,171,56,168,129,253,255,171,56,168,75,52,160,131,2,192,127,57,168,67,0,192,199,
  57,168,195,255,255,199,57,168,131,253,255,199,57,168,75,52,160,131,2,192,75,57,168,67,0,192,75,57,168,195,255,255,
  75,57,168,131,253,255,75,57,168,193,2,192,171,56,168,65,2,192,171,56,168,193,253,255,171,56,168,65,253,255,171,56,
  168,75,52,160,196,34,192,242,0,0,32,128,18,31,222,145,65,5,192,131,2,192,14,20,192,66,236,193,16,128,21,36,
  128,20,0,128,5,15,158,145,20,0,0,242,0,0,32,128,18,251,157,145,10,0,192,139,63,168,48,0,21,2,25,192,
  16,128,20,227,157,144,0,0,20,0,0,9,130,7,192,16,128,20,207,157,144,4,35,192,242,0,0,32,128,18,91,222,
  145,65,5,192,20,0,0,242,0,0,32,128,18,75,158,145,74,0,192,139,63,168,0,0,9,2,25,192,16,128,20,51,
  158,144,68,35,192,242,0,0,32,128,18,151,222,145,65,5,192,20,0,0,242,0,0,32,128,18,135,158,145,138,0,192,
  139,63,168,0,0,9,130,22,192,16,128,20,111,158,144,132,35,192,242,0,0,32,128,18,211,222,145,65,5,192,20,0,
  0,242,0,0,32,128,18,195,158,145,202,0,192,139,63,168,0,0,9,130,27,192,16,128,20,171,158,144,196,35,192,242,
  0,0,32,128,18,15,223,145,65,5,192,20,0,0,242,0,0,32,128,18,255,158,145,10,1,192,139,63,168,0,0,9,
  130,27,192,16,128,20,231,158,144,4,36,192,242,0,0,32,128,18,75,223,145,65,5,192,20,0,0,242,0,0,32,128,
  18,59,159,145,74,1,192,139,63,168,0,0,9,130,27,192,16,128,20,35,159,144,68,36,192,242,0,0,32,128,18,135,
  223,145,65,5,192,20,0,0,242,0,0,32,128,18,119,159,145,138,1,192,139,63,168,0,0,9,130,27,192,16,128,20,
  95,159,144,0,0,64,194,170,192,128,128,21,36,128,20,223,0,0,194,45,193,128,128,21,36,128,20,130,0,0,31,128,
  9,38,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,255,127,0,64,170,42,0,32,153,25,85,21,73,18,0,16,56,14,204,12,162,11,170,10,216,9,36,9,136,8,
  0,8,135,7,28,7,188,6,102,6,24,6,209,5,144,5,85,5,30,5,236,4,189,4,146,4,105,4,68,4,33,4,
  0,4,224,3,195,3,168,3,142,3,117,3,94,3,72,3,51,3,31,3,12,3,250,2,232,2,216,2,200,2,185,2,
  170,2,156,2,143,2,130,2,118,2,106,2,94,2,83,2,73,2,62,2,52,2,43,2,34,2,25,2,16,2,8,2,
  0,2,248,1,240,1,233,1,225,1,218,1,212,1,205,1,199,1,192,1,186,1,180,1,175,1,169,1,164,1,158,1,
  153,1,148,1,143,1,138,1,134,1,129,1,125,1,120,1,116,1,112,1,108,1,104,1,100,1,96,1,92,1,88,1,
  85,1,81,1,78,1,74,1,71,1,68,1,65,1,62,1,59,1,56,1,53,1,50,1,47,1,44,1,41,1,39,1,
  36,1,33,1,31,1,28,1,26,1,24,1,21,1,19,1,17,1,14,1,12,1,10,1,8,1,6,1,4,1,2,1,
  0,1,254,0,252,0,250,0,248,0,246,0,244,0,242,0,240,0,239,0,237,0,235,0,234,0,232,0,230,0,229,0,
  227,0,225,0,224,0,222,0,221,0,219,0,218,0,217,0,215,0,214,0,212,0,211,0,210,0,208,0,207,0,206,0,
  204,0,203,0,202,0,201,0,199,0,198,0,197,0,196,0,195,0,193,0,192,0,191,0,190,0,189,0,188,0,187,0,
  186,0,185,0,184,0,183,0,182,0,181,0,180,0,179,0,178,0,177,0,176,0,175,0,174,0,173,0,172,0,171,0,
  170,0,169,0,168,0,168,0,167,0,166,0,165,0,164,0,163,0,163,0,162,0,161,0,160,0,159,0,159,0,158,0,
  157,0,156,0,156,0,155,0,154,0,153,0,153,0,152,0,151,0,151,0,150,0,149,0,148,0,148,0,147,0,146,0,
  146,0,145,0,144,0,144,0,143,0,143,0,142,0,141,0,141,0,140,0,140,0,139,0,138,0,138,0,137,0,137,0,
  136,0,135,0,135,0,134,0,134,0,133,0,133,0,132,0,132,0,131,0,131,0,130,0,130,0,129,0,129,0,128,0,
  0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,
  5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,
  1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,
  7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,
  3,0,4,0,5,0,6,0,7,0,8,0,0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,
  0,0,0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,27,0,28,0,30,0,32,0,60,0,63,0,
  66,0,68,0,70,0,71,0,73,0,74,0,76,0,78,0,79,0,81,0,0,0,0,0,7,0,8,0,8,0,9,0,
  10,0,11,0,12,0,12,0,12,0,12,0,12,0,0,0,0,0,7,0,7,0,8,0,8,0,9,0,10,0,11,0,
  12,0,12,0,12,0,12,0,0,0,0,0,6,0,7,0,7,0,8,0,8,0,9,0,10,0,11,0,12,0,12,0,
  12,0,166,4,12,5,179,4,12,5,182,4,12,5,207,4,12,5,12,5,0,0,133,5,85,5,190,5,142,5,199,5,
  0,0,40,6,142,6,53,6,142,6,56,6,142,6,81,6,142,6,142,6,0,0,7,7,215,6,64,7,16,7,73,7,
  0,0,0,0,1,0,2,0,4,0,8,0,7,0,30,0,26,0,40,0,28,0,41,0,51,0,52,0,53,0,0,0,
  78,0,93,0,82,0,98,0,120,0,0,0,43,9,84,9,45,9,84,9,49,9,84,9,78,9,84,9,84,9,0,0,
  95,9,91,9,112,9,108,9,125,9,0,0,174,9,201,9,176,9,201,9,27,8,201,9,178,9,201,9,201,9,0,0,
  229,9,252,9,40,10,63,10,27,8,0,0,43,9,208,9,45,9,208,9,27,8,208,9,184,9,208,9,208,9,0,0,
  238,9,9,10,45,10,72,10,27,8,0,0,174,9,215,9,176,9,215,9,27,8,215,9,190,9,215,9,215,9,0,0,
  243,9,18,10,40,10,85,10,27,8,0,0,174,9,222,9,176,9,222,9,27,8,222,9,196,9,222,9,222,9,0,0,
  238,9,31,10,54,10,94,10,27,8,0,0,1,0,1,0,2,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,1,0,1,0,2,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,
  2,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
  2,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,
  2,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,
  0,0,1,0,2,0,2,0,0,0,0,0,0,0,1,0,2,0,4,0,8,0,159,11,200,11,161,11,200,11,165,11,
  200,11,194,11,200,11,200,11,0,0,211,11,207,11,228,11,224,11,241,11,0,0,34,12,61,12,36,12,61,12,143,10,
  61,12,38,12,61,12,61,12,0,0,89,12,112,12,156,12,179,12,143,10,0,0,159,11,68,12,161,11,68,12,143,10,
  68,12,44,12,68,12,68,12,0,0,98,12,125,12,161,12,188,12,143,10,0,0,34,12,75,12,36,12,75,12,143,10,
  75,12,50,12,75,12,75,12,0,0,103,12,134,12,156,12,201,12,143,10,0,0,34,12,82,12,36,12,82,12,143,10,
  82,12,56,12,82,12,82,12,0,0,98,12,147,12,170,12,210,12,143,10,0,0,0,0,1,0,2,0,4,0,8,0,
  224,13,246,13,227,13,246,13,230,13,246,13,235,13,246,13,246,13,0,0,11,14,3,14,28,14,20,14,37,14,0,0,
  38,14,93,14,41,14,93,14,44,14,93,14,49,14,93,14,93,14,0,0,153,14,145,14,221,14,213,14,37,14,0,0,
  224,13,106,14,227,13,106,14,44,14,106,14,60,14,106,14,106,14,0,0,170,14,162,14,238,14,230,14,37,14,0,0,
  38,14,119,14,41,14,119,14,44,14,119,14,71,14,119,14,119,14,0,0,187,14,179,14,255,14,247,14,37,14,0,0,
  38,14,132,14,41,14,132,14,44,14,132,14,82,14,132,14,132,14,0,0,204,14,196,14,16,15,8,15,37,14,0,0,
  177,15,199,15,180,15,199,15,183,15,199,15,188,15,199,15,199,15,0,0,220,15,212,15,237,15,229,15,246,15,0,0,
  247,15,46,16,250,15,46,16,253,15,46,16,2,16,46,16,46,16,0,0,106,16,98,16,174,16,166,16,246,15,0,0,
  177,15,59,16,180,15,59,16,253,15,59,16,13,16,59,16,59,16,0,0,123,16,115,16,191,16,183,16,246,15,0,0,
  247,15,72,16,250,15,72,16,253,15,72,16,24,16,72,16,72,16,0,0,140,16,132,16,208,16,200,16,246,15,0,0,
  247,15,85,16,250,15,85,16,253,15,85,16,35,16,85,16,85,16,0,0,157,16,149,16,225,16,217,16,246,15,0,0,
  0,0,1,0,2,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,12,0,13,0,14,0,15,0,
  15,0,16,0,17,0,18,0,19,0,20,0,21,0,22,0,22,0,23,0,24,0,25,0,25,0,26,0,27,0,28,0,
  28,0,29,0,30,0,30,0,31,0,31,0,32,0,33,0,33,0,34,0,34,0,35,0,35,0,36,0,36,0,37,0,
  37,0,38,0,38,0,38,0,39,0,39,0,40,0,40,0,40,0,41,0,41,0,41,0,42,0,42,0,42,0,43,0,
  43,0,43,0,43,0,44,0,44,0,44,0,44,0,44,0,45,0,45,0,45,0,45,0,45,0,46,0,46,0,46,0,
  46,0,46,0,46,0,47,0,47,0,47,0,47,0,47,0,47,0,47,0,47,0,47,0,48,0,48,0,48,0,48,0,
  48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,
  49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,49,0,
  49,0,49,0,49,0,49,0,49,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,50,0,
  9,0,72,0,54,0,66,0,60,0,66,0,60,0,63,0,63,0,0,0,198,0,20,1,210,0,38,1,0,0,0,0,
  0,0,2,0,1,0,2,0,1,0,2,0,2,0,2,0,2,0,0,0,4,0,6,0,4,0,6,0,120,0,120,0,
  1,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,5,0,10,0,15,0,19,0,23,0,27,0,30,0,33,0,36,0,39,0,42,0,45,0,48,0,51,0,54,0,
  57,0,60,0,63,0,66,0,0,0,16,0,31,0,46,0,61,0,76,0,0,0,17,0,33,0,49,0,65,0,81,0,
  0,0,29,0,57,0,85,0,113,0,141,0,0,0,30,0,59,0,88,0,117,0,146,0,0,0,41,0,81,0,121,0,
  0,0,43,0,85,0,127,0,182,33,223,33,186,33,223,33,200,33,223,33,207,33,223,33,223,33,0,0,242,33,55,34,
  234,34,47,35,226,35,226,35,92,40,133,40,96,40,133,40,110,40,133,40,117,40,133,40,133,40,0,0,152,40,221,40,
  144,41,213,41,136,42,136,42,0,0,2,0,5,0,8,0,11,0,14,0,17,0,19,0,22,0,25,0,28,0,31,0,
  34,0,36,0,39,0,42,0,45,0,48,0,51,0,54,0,56,0,59,0,62,0,65,0,68,0,71,0,73,0,76,0,
  79,0,82,0,85,0,88,0,91,0,93,0,96,0,99,0,102,0,105,0,108,0,110,0,113,0,116,0,119,0,122,0,
  125,0,128,0,130,0,133,0,136,0,139,0,142,0,145,0,147,0,150,0,153,0,156,0,159,0,162,0,164,0,167,0,
  170,0,173,0,176,0,179,0,182,0,184,0,187,0,190,0,193,0,196,0,199,0,201,0,204,0,207,0,210,0,213,0,
  216,0,219,0,221,0,224,0,227,0,230,0,233,0,236,0,238,0,241,0,244,0,247,0,250,0,253,0,201,50,241,50,
  206,50,241,50,211,50,241,50,220,50,241,50,241,50,0,0,254,50,15,51,32,51,49,51,66,51,0,0,54,48,154,51,
  54,48,154,51,54,48,154,51,131,51,154,51,154,51,0,0,170,51,188,51,54,48,216,51,54,48,0,0,201,50,157,51,
  206,50,157,51,54,48,157,51,140,51,157,51,157,51,0,0,54,48,157,51,198,51,221,51,54,48,0,0,54,48,162,51,
  54,48,162,51,54,48,162,51,145,51,162,51,162,51,0,0,179,51,193,51,54,48,226,51,54,48,0,0,54,48,165,51,
  54,48,165,51,54,48,165,51,54,48,165,51,165,51,0,0,54,48,165,51,207,51,231,51,54,48,0,0,192,53,233,53,
  197,53,233,53,203,53,233,53,212,53,233,53,233,53,0,0,20,54,41,54,82,54,103,54,144,54,0,0,17,52,16,55,
  17,52,16,55,17,52,16,55,249,54,16,55,16,55,0,0,62,55,84,55,17,52,120,55,17,52,0,0,192,53,24,55,
  197,53,24,55,17,52,24,55,2,55,24,55,24,55,0,0,17,52,24,55,98,55,135,55,17,52,0,0,17,52,39,55,
  17,52,39,55,17,52,39,55,7,55,39,55,39,55,0,0,73,55,91,55,17,52,142,55,17,52,0,0,17,52,47,55,
  17,52,47,55,17,52,47,55,17,52,47,55,47,55,0,0,17,52,47,55,109,55,157,55,17,52,0,0,120,56,143,56,
  123,56,143,56,127,56,143,56,132,56,143,56,143,56,0,0,164,56,156,56,185,56,177,56,91,56,0,0,91,56,206,56,
  91,56,206,56,91,56,206,56,198,56,206,56,206,56,0,0,217,56,217,56,91,56,241,56,91,56,0,0,120,56,209,56,
  123,56,209,56,91,56,209,56,203,56,209,56,209,56,0,0,91,56,224,56,234,56,234,56,91,56,0,0,91,56,214,56,
  91,56,214,56,91,56,214,56,138,56,214,56,214,56,0,0,170,56,170,56,91,56,246,56,91,56,0,0,91,56,151,56,
  91,56,151,56,91,56,151,56,91,56,151,56,151,56,0,0,91,56,229,56,191,56,191,56,91,56,0,0,0,0,4,0,
  20,0,48,0,80,0,80,0,80,0,0,0,0,0,8,0,32,0,64,0,80,0,80,0,0,0,12,0,40,0,72,0,
  80,0,80,0,80,0,0,0,0,0,10,0,28,0,50,0,50,0,50,0,0,0,0,0,3,0,18,0,40,0,50,0,
  50,0,0,0,5,0,25,0,45,0,50,0,50,0,50,0,0,0,0,0,0,0,12,0,30,0,30,0,30,0,0,0,
  0,0,0,0,6,0,24,0,30,0,30,0,0,0,0,0,9,0,15,0,30,0,30,0,30,0,197,22,235,22,202,22,
  235,22,205,22,235,22,214,22,235,22,235,22,0,0,20,23,4,23,45,23,29,23,54,23,183,23,221,23,188,23,221,23,
  191,23,221,23,200,23,221,23,221,23,0,0,6,24,246,23,31,24,15,24,40,24,142,25,122,25,190,25,122,25,113,25,
  122,25,39,25,122,25,122,25,0,0,76,25,60,25,163,25,147,25,29,25,244,27,32,28,247,27,32,28,16,28,32,28,
  21,28,32,28,32,28,0,0,45,28,54,28,71,28,80,28,9,27,0,0,9,27,105,28,9,27,105,28,9,27,105,28,
  97,28,105,28,105,28,0,0,116,28,121,28,9,27,141,28,9,27,0,0,244,27,108,28,247,27,108,28,9,27,108,28,
  102,28,108,28,108,28,0,0,9,27,126,28,136,28,146,28,9,27,0,0,9,27,113,28,9,27,113,28,9,27,113,28,
  27,28,113,28,113,28,0,0,49,28,66,28,9,27,151,28,9,27,0,0,9,27,40,28,9,27,40,28,9,27,40,28,
  9,27,40,28,40,28,0,0,9,27,131,28,75,28,92,28,9,27,0,0,1,0,16,0,2,0,16,0,4,0,16,0,
  8,0,16,0,16,0,0,0,32,0,48,0,64,0,72,0,16,0,0,0,16,0,0,0,16,0,0,0,16,0,0,0,
  0,0,0,0,48,0,0,0,72,0,0,0,187,30,215,30,191,30,215,30,194,30,215,30,199,30,215,30,215,30,0,0,
  234,30,243,30,8,31,17,31,38,31,0,0,238,28,78,31,238,28,78,31,238,28,78,31,67,31,78,31,78,31,0,0,
  93,31,98,31,238,28,122,31,238,28,0,0,187,30,82,31,191,30,82,31,238,28,82,31,74,31,82,31,82,31,0,0,
  238,28,103,31,117,31,129,31,238,28,0,0,238,28,89,31,238,28,89,31,238,28,89,31,208,30,89,31,89,31,0,0,
  238,30,3,31,238,28,134,31,238,28,0,0,238,28,227,30,238,28,227,30,238,28,227,30,238,28,227,30,227,30,0,0,
  238,28,110,31,12,31,33,31,238,28,0,0,150,59,172,59,153,59,172,59,156,59,172,59,161,59,172,59,172,59,0,0,
  185,59,194,59,211,59,220,59,237,59,0,0,239,58,91,60,239,58,91,60,239,58,91,60,78,60,91,60,91,60,0,0,
  107,60,117,60,239,58,147,60,239,58,0,0,150,59,94,60,153,59,94,60,239,58,94,60,83,60,94,60,94,60,0,0,
  239,58,122,60,137,60,152,60,239,58,0,0,239,58,99,60,239,58,99,60,239,58,99,60,86,60,99,60,99,60,0,0,
  112,60,127,60,239,58,157,60,239,58,0,0,239,58,102,60,239,58,102,60,239,58,102,60,239,58,102,60,102,60,0,0,
  239,58,132,60,142,60,162,60,239,58,0,0,131,62,162,62,135,62,162,62,139,62,162,62,146,62,162,62,162,62,0,0,
  181,62,194,62,219,62,232,62,233,60,1,63,43,63,4,63,43,63,27,63,43,63,32,63,43,63,43,63,0,0,56,63,
  65,63,82,63,91,63,18,61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
const unsigned char ST018[163840] = {
  42,0,0,234,13,0,0,234,16,0,0,234,19,0,0,234,22,0,0,234,25,0,0,234,28,0,0,234,31,0,0,234,
  76,0,0,234,60,0,0,234,4,5,82,72,31,113,13,19,224,142,242,236,64,244,1,0,165,35,138,189,0,81,0,0,
  1,64,45,233,52,0,0,235,56,248,159,21,1,64,189,232,1,64,45,233,48,0,0,235,44,248,159,21,1,64,189,232,
  1,64,45,233,44,0,0,235,32,248,159,21,1,64,189,232,1,64,45,233,40,0,0,235,20,248,159,21,1,64,189,232,
  1,64,45,233,36,0,0,235,8,248,159,21,1,64,189,232,1,64,45,233,32,0,0,235,252,247,159,21,1,64,189,232,
  1,64,45,233,28,0,0,235,240,247,159,21,1,64,189,232,177,161,160,227,2,32,160,227,0,32,10,229,211,16,160,227,
  1,240,41,225,216,215,159,229,12,0,0,235,18,0,0,235,208,247,159,21,28,0,0,235,253,255,255,234,0,67,45,233,
  163,128,160,227,129,145,160,227,0,128,9,229,189,128,160,227,4,128,137,229,107,128,160,227,8,128,137,229,0,131,189,232,
  0,67,45,233,0,128,160,227,129,145,160,227,0,128,9,229,4,128,137,229,8,128,137,229,0,131,189,232,136,7,159,229,
  0,0,16,229,32,0,16,227,14,240,160,225,32,67,111,112,121,114,105,103,104,116,32,40,99,41,32,49,57,57,52,32,
  82,65,72,68,79,77,72,79,85,83,69,32,6,88,45,233,224,192,160,227,16,0,0,234,0,64,45,233,238,255,255,235,
  0,64,189,232,68,247,159,21,68,7,159,229,2,0,208,229,1,0,16,226,3,0,0,26,1,1,160,227,32,0,208,229,
  8,0,16,227,2,0,0,26,40,7,159,229,0,0,80,229,14,240,160,225,6,88,45,233,228,192,160,227,1,177,160,227,
  32,0,219,229,8,0,16,227,16,0,0,10,63,0,0,235,32,0,219,229,8,0,16,227,12,0,0,10,59,0,0,235,
  16,0,219,229,57,0,0,235,236,22,159,229,1,16,143,224,0,32,81,229,0,0,82,225,9,0,0,10,255,0,82,227,
  4,16,129,18,249,255,255,26,238,0,160,227,67,0,0,235,228,0,92,227,193,255,255,27,184,6,159,229,0,0,80,229,
  6,152,189,232,0,16,17,229,255,12,17,227,8,0,0,10,2,9,17,227,4,0,0,26,228,0,160,227,0,0,92,225,
  1,0,0,26,53,0,0,235,240,255,255,234,224,0,160,227,47,0,0,235,33,24,160,225,1,240,143,224,241,0,164,3,
  242,0,24,4,243,0,136,4,244,0,168,4,245,0,180,4,246,0,232,4,160,128,116,1,161,128,120,1,162,128,128,1,
  163,128,144,1,164,128,176,1,165,128,204,1,168,82,232,1,169,65,244,1,170,78,64,2,171,196,80,2,172,207,92,2,
  173,77,104,2,174,72,120,2,175,79,128,2,176,85,164,2,177,83,236,2,178,69,4,3,179,107,28,3,180,46,36,3,
  181,107,88,3,182,46,96,3,183,32,156,3,255,0,82,72,64,16,160,227,1,16,81,226,253,255,255,26,14,240,160,225,
  9,64,45,233,1,48,160,225,32,0,219,229,3,0,0,224,2,0,80,225,251,255,255,26,244,255,255,235,32,0,219,229,
  3,0,0,224,2,0,80,225,246,255,255,26,239,255,255,235,9,128,189,232,0,64,45,233,119,255,255,235,0,64,189,232,
  6,64,45,233,1,16,160,227,0,32,160,227,235,255,255,235,0,0,203,229,229,255,255,235,6,128,189,232,6,64,45,233,
  8,16,160,227,8,32,160,227,228,255,255,235,16,0,219,229,222,255,255,235,6,128,189,232,3,64,45,233,246,255,255,235,
  1,0,80,225,1,0,189,232,238,0,160,19,235,255,255,235,238,0,80,227,2,128,189,232,0,64,45,233,238,255,255,235,
  1,0,45,233,1,0,160,225,228,255,255,235,1,128,189,232,0,64,45,233,0,16,81,226,0,128,189,8,1,16,65,226,
  244,255,255,235,0,0,66,229,1,32,130,226,248,255,255,234,0,64,45,233,0,16,81,226,0,128,189,8,0,0,82,229,
  1,32,130,226,227,255,255,235,0,128,189,8,1,16,65,226,247,255,255,234,61,255,255,234,4,0,160,227,0,0,0,234,
  5,0,160,227,1,16,160,227,218,255,255,235,135,255,255,234,232,36,159,229,4,16,160,227,228,255,255,235,4,32,66,226,
  0,32,18,229,128,16,160,227,232,255,255,235,127,255,255,234,5,16,160,227,93,0,0,235,1,0,160,225,4,16,210,229,
  0,32,160,225,225,255,255,235,120,255,255,234,5,16,160,227,86,0,0,235,1,0,160,225,4,16,210,229,0,32,160,225,
  210,255,255,235,113,255,255,234,0,0,160,227,1,16,160,227,1,0,0,234,1,0,160,227,1,16,160,227,4,0,45,233,
  108,36,159,229,0,224,160,227,0,224,130,229,4,224,130,229,0,224,160,227,2,224,130,229,4,0,189,232,231,2,0,235,
  76,36,159,229,0,0,130,229,8,16,130,229,1,177,160,227,16,0,203,229,141,255,255,235,224,192,160,227,91,255,255,234,
  60,36,159,229,97,16,160,227,184,255,255,235,87,255,255,234,32,36,159,229,1,16,160,227,250,255,255,234,12,0,160,225,
  150,255,255,235,81,255,255,234,4,36,159,229,2,16,160,227,182,255,255,235,77,255,255,234,2,0,160,227,222,255,255,234,
  236,35,159,229,0,0,146,229,1,0,128,226,0,0,128,224,232,35,159,229,0,0,130,229,2,16,160,227,171,255,255,235,
  66,255,255,234,200,35,159,229,0,16,146,229,8,32,146,229,1,16,129,226,1,16,129,224,255,16,17,226,59,255,255,10,
  0,0,82,229,1,32,130,226,138,255,255,235,55,255,255,10,1,16,81,226,0,0,82,229,3,32,130,226,133,255,255,235,
  50,255,255,10,1,16,81,226,243,255,255,234,14,0,0,235,1,32,210,229,255,32,2,226,255,16,1,226,0,0,160,227,
  189,255,255,234,8,0,0,235,1,32,210,229,255,32,2,226,255,16,1,226,1,0,160,227,183,255,255,234,4,0,160,227,
  15,0,0,234,5,0,160,227,13,0,0,234,2,16,160,227,2,64,45,233,68,35,159,229,0,0,160,227,0,0,2,229,
  4,32,130,226,121,255,255,235,2,0,189,232,1,32,66,224,0,16,18,229,0,128,189,232,6,0,160,227,0,0,0,234,
  7,0,160,227,8,35,159,229,0,224,160,227,4,224,130,229,1,224,160,227,2,224,194,229,144,2,0,235,1,177,160,227,
  248,34,159,229,0,0,130,229,1,16,160,227,111,255,255,235,54,255,255,235,224,192,160,227,4,255,255,234,3,0,160,227,
  149,255,255,234,0,192,160,227,216,50,159,229,3,48,143,224,212,82,159,229,5,80,143,224,4,32,147,229,204,146,159,229,
  99,0,0,235,0,32,147,229,2,0,80,225,1,192,140,19,10,82,160,227,12,32,147,229,180,146,159,229,92,0,0,235,
  8,32,147,229,2,0,80,225,2,192,140,19,66,0,0,235,160,146,159,229,91,0,0,235,156,146,159,229,89,0,0,235,
  5,96,160,225,4,192,140,19,144,146,159,229,88,0,0,235,4,32,160,227,13,0,0,234,0,192,160,227,54,0,0,235,
  124,146,159,229,82,0,0,235,1,192,140,19,5,96,160,17,5,0,0,26,108,146,159,229,81,0,0,235,104,146,159,229,
  79,0,0,235,2,192,140,19,5,96,160,17,3,32,160,227,12,0,160,225,48,0,0,235,2,0,28,224,3,0,0,10,
  6,0,160,225,44,0,0,235,32,4,160,225,42,0,0,235,0,128,160,227,129,145,160,227,0,128,9,229,4,128,137,229,
  8,128,137,229,121,254,255,234,2,40,160,227,0,80,160,227,0,0,85,229,32,0,0,235,1,80,133,226,1,32,82,226,
  250,255,255,26,241,255,255,234,2,41,160,227,10,82,160,227,246,255,255,234,244,81,159,229,5,80,143,224,240,33,159,229,
  200,145,159,229,34,0,0,235,19,0,0,235,32,4,160,225,17,0,0,235,32,4,160,225,15,0,0,235,32,4,160,225,
  13,0,0,235,225,255,255,234,10,82,160,227,196,33,159,229,156,145,159,229,22,0,0,235,242,255,255,234,163,128,160,227,
  129,145,160,227,0,128,9,229,189,128,160,227,4,128,137,229,107,128,160,227,8,128,137,229,14,240,160,225,14,176,160,225,
  129,65,160,227,0,16,20,229,1,0,17,227,251,255,255,26,206,254,255,235,0,16,20,229,1,0,17,227,247,255,255,26,
  202,254,255,235,1,17,160,227,0,0,65,229,199,254,255,235,11,240,160,225,3,32,194,227,0,0,160,227,4,112,160,227,
  4,160,160,227,11,0,0,234,76,49,159,229,76,1,159,229,4,0,0,234,3,42,160,227,0,48,160,227,1,112,160,227,
  2,0,0,234,0,48,224,227,1,42,160,227,4,112,160,227,14,82,160,227,1,160,160,227,36,177,159,229,11,176,143,224,
  9,176,139,224,15,128,160,225,11,240,160,225,7,80,133,224,10,32,82,224,250,255,255,26,14,240,160,225,0,48,5,229,
  8,240,160,225,0,64,21,229,4,0,83,225,8,240,160,1,14,240,160,225,0,48,69,229,1,48,131,226,8,240,160,225,
  0,64,85,229,4,0,83,225,14,240,160,17,1,48,131,226,255,48,3,226,8,240,160,225,0,48,5,229,0,48,131,224,
  8,240,160,225,0,64,21,229,4,0,83,225,14,240,160,17,0,48,131,224,8,240,160,225,0,64,21,229,4,0,128,224,
  8,240,160,225,0,64,213,229,1,144,213,229,9,68,132,225,2,144,213,229,9,72,132,225,3,144,213,229,9,76,132,225,
  4,0,128,224,8,240,160,225,4,0,0,96,8,0,0,96,12,0,0,96,16,0,0,96,20,0,0,96,24,0,0,96,
  28,0,0,96,0,64,0,224,0,0,0,96,32,0,0,64,32,0,0,96,100,4,0,224,104,4,0,224,104,0,0,0,
  112,4,0,224,0,4,0,224,60,250,255,255,4,250,255,255,88,8,0,0,100,8,0,0,56,8,0,0,68,8,0,0,
  20,8,0,0,32,8,0,0,252,7,0,0,4,8,0,0,0,249,255,255,0,0,2,0,0,128,0,0,120,86,52,18,
  31,31,31,0,28,248,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,234,21,0,0,234,4,224,45,229,84,193,159,229,84,177,159,229,208,15,12,229,212,31,12,229,200,47,12,229,
  255,251,255,235,11,0,0,27,0,0,0,234,4,224,45,229,0,0,160,227,232,15,12,229,228,15,12,229,220,15,12,229,
  204,223,12,229,80,0,0,235,204,223,28,229,0,144,160,227,232,159,12,229,4,240,157,228,4,240,31,229,128,0,0,96,
  8,209,159,229,8,193,159,229,8,177,159,229,8,81,159,229,8,97,159,229,97,144,160,227,1,0,213,228,1,0,198,228,
  1,144,89,226,251,255,255,26,1,0,160,227,5,16,160,227,0,32,160,227,208,15,12,229,212,31,12,229,200,47,12,229,
  225,255,255,235,254,255,255,234,208,15,28,229,4,0,80,227,14,240,160,33,4,224,45,229,5,0,0,235,1,0,80,227,
  4,240,157,20,0,0,160,227,180,16,159,229,0,0,1,229,220,255,255,234,4,224,45,229,0,0,160,227,207,251,255,235,
  4,240,157,228,156,0,159,229,200,31,28,229,1,0,208,231,1,16,129,226,1,25,193,227,200,31,12,229,1,0,0,226,
  14,240,160,225,0,0,0,0,66,0,0,0,0,0,0,0,0,74,66,80,60,0,0,0,0,0,80,0,0,44,0,0,
  0,0,0,80,64,64,0,48,64,0,0,0,76,76,0,0,0,0,0,0,0,0,0,0,90,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,68,0,84,0,92,0,0,0,0,12,3,3,0,0,0,0,0,1,0,0,
  1,0,0,0,0,0,0,0,232,20,0,224,144,216,1,0,0,64,0,224,232,20,0,224,144,216,1,0,4,17,0,0,
  0,4,0,224,216,38,0,224,0,0,0,160,4,224,45,229,99,0,0,235,208,15,28,229,1,0,16,227,160,0,0,27,
  109,2,0,235,208,15,28,229,254,0,0,226,0,0,80,227,7,0,0,10,2,0,80,227,33,0,0,10,4,0,80,227,
  47,0,0,10,6,0,80,227,55,0,0,10,0,0,160,227,4,240,157,228,165,4,0,235,40,1,159,229,176,15,12,229,
  176,111,28,229,110,84,0,235,172,111,12,229,176,95,28,229,0,0,160,227,16,17,159,229,6,0,85,225,14,0,0,10,
  4,0,149,228,4,17,159,229,6,0,85,225,10,0,0,10,1,0,160,227,232,15,12,229,7,0,160,227,180,15,12,229,
  224,11,0,235,232,16,159,229,0,0,80,227,2,0,0,26,2,0,160,227,232,15,12,229,65,7,0,235,34,0,0,235,
  4,240,157,228,137,4,0,235,200,0,159,229,176,15,12,229,1,0,160,227,232,15,12,229,248,11,0,235,184,16,159,229,
  3,0,45,233,0,0,17,229,0,0,80,227,2,0,0,10,21,0,0,235,4,0,129,228,249,255,255,234,3,0,189,232,
  4,240,157,228,148,0,159,229,176,15,12,229,176,111,28,229,67,84,0,235,172,111,12,229,176,95,28,229,6,0,85,225,
  0,0,160,227,1,0,160,19,4,240,157,228,168,127,28,229,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,
  0,0,160,227,1,0,160,19,4,240,157,228,0,0,80,227,11,0,0,10,127,48,160,227,0,32,3,224,32,52,3,224,
  128,0,0,226,208,79,28,229,1,0,20,227,2,0,0,10,8,0,82,227,130,32,98,34,130,48,99,226,0,4,130,225,
  3,4,128,225,14,240,160,225,216,38,0,224,224,177,255,255,48,117,0,0,34,78,0,0,216,38,0,224,216,38,0,224,
  216,38,0,224,4,224,45,229,0,0,160,227,248,10,12,229,168,15,12,229,164,15,12,229,244,10,12,229,64,20,159,229,
  160,31,12,229,8,0,1,229,4,0,1,229,128,11,12,229,124,11,12,229,120,11,12,229,116,11,12,229,112,11,12,229,
  108,11,12,229,28,84,159,229,12,96,160,225,131,144,160,227,36,6,6,229,24,4,6,229,12,2,6,229,4,16,149,228,
  4,16,134,228,1,144,89,226,248,255,255,26,84,80,160,227,244,99,159,229,9,144,160,227,9,128,160,227,1,0,214,228,
  5,0,204,231,0,0,80,227,2,0,0,10,64,0,45,233,163,2,0,235,64,0,189,232,4,80,133,226,1,128,88,226,
  245,255,255,26,4,80,133,226,1,144,89,226,241,255,255,26,184,83,159,229,16,144,160,227,1,0,214,228,1,0,197,228,
  1,144,89,226,251,255,255,26,84,80,160,227,9,144,160,227,9,128,160,227,5,0,220,231,92,0,80,227,168,95,12,5,
  60,0,80,227,164,95,12,5,4,80,133,226,1,128,88,226,247,255,255,26,4,80,133,226,1,144,89,226,243,255,255,26,
  4,240,157,228,84,80,160,227,109,111,160,227,9,144,160,227,5,48,140,224,6,64,140,224,0,0,83,229,0,16,84,229,
  96,0,16,227,96,0,32,18,96,0,17,227,96,16,33,18,0,0,68,229,0,16,67,229,36,6,19,229,36,22,20,229,
  96,8,160,225,97,24,160,225,36,22,3,229,36,6,4,229,24,4,19,229,24,20,20,229,96,8,160,225,97,24,160,225,
  24,20,3,229,24,4,4,229,6,0,85,225,6,0,0,10,4,80,133,226,4,96,70,226,1,144,89,226,227,255,255,26,
  4,80,133,226,4,96,70,226,223,255,255,234,196,15,28,229,188,31,28,229,196,31,12,229,188,15,12,229,192,15,28,229,
  184,31,28,229,192,31,12,229,184,15,12,229,168,15,28,229,164,31,28,229,130,15,96,226,130,31,97,226,168,31,12,229,
  164,15,12,229,127,11,92,229,107,27,92,229,127,27,76,229,107,11,76,229,126,11,92,229,108,27,92,229,126,27,76,229,
  108,11,76,229,125,11,92,229,109,27,92,229,125,27,76,229,109,11,76,229,124,11,92,229,110,27,92,229,124,27,76,229,
  110,11,76,229,123,11,92,229,111,27,92,229,123,27,76,229,111,11,76,229,122,11,92,229,112,27,92,229,122,27,76,229,
  112,11,76,229,121,11,92,229,113,27,92,229,121,27,76,229,113,11,76,229,120,11,92,229,114,27,92,229,120,27,76,229,
  114,11,76,229,119,11,92,229,115,27,92,229,119,27,76,229,115,11,76,229,14,240,160,225,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,128,0,0,0,
  128,0,0,0,80,37,0,224,120,21,0,0,0,4,0,224,36,5,0,224,4,224,45,229,32,0,45,233,180,15,28,229,
  1,0,64,226,180,15,12,229,160,15,28,229,4,48,128,228,160,15,12,229,127,15,160,227,35,99,0,224,3,81,16,224,
  0,0,160,227,1,0,160,3,156,15,76,229,32,0,85,227,33,0,0,58,72,0,45,233,153,1,0,235,12,1,0,235,
  72,0,189,232,5,64,220,231,0,0,160,227,5,0,204,231,128,48,3,226,35,51,132,225,6,80,160,225,5,0,220,231,
  0,0,80,227,9,0,0,10,24,0,45,233,140,1,0,235,255,0,0,235,24,0,189,232,5,0,220,231,28,0,0,226,
  32,161,140,224,196,15,90,229,1,0,128,226,196,15,74,229,5,0,220,231,5,48,204,231,92,0,84,227,168,95,12,5,
  0,68,132,225,16,0,45,233,125,1,0,235,222,0,0,235,16,0,189,232,32,0,189,232,4,240,157,228,37,161,140,224,
  196,15,90,229,1,0,64,226,196,15,74,229,64,80,133,227,6,80,204,231,6,80,160,225,113,1,0,235,210,0,0,235,
  32,0,189,232,4,240,157,228,4,224,45,229,32,0,45,233,180,15,28,229,1,0,64,226,180,15,12,229,160,15,28,229,
  4,48,128,228,160,15,12,229,127,15,160,227,35,99,0,224,3,81,16,224,0,0,160,227,1,0,160,3,156,15,76,229,
  32,0,85,227,33,0,0,58,72,0,45,233,92,1,0,235,207,0,0,235,72,0,189,232,5,64,220,231,0,0,160,227,
  5,0,204,231,128,48,3,226,35,51,132,225,6,80,160,225,5,0,220,231,0,0,80,227,9,0,0,10,24,0,45,233,
  79,1,0,235,194,0,0,235,24,0,189,232,5,0,220,231,28,0,0,226,32,161,140,224,188,15,90,229,1,0,128,226,
  188,15,74,229,5,0,220,231,5,48,204,231,60,0,84,227,164,95,12,5,0,68,132,225,16,0,45,233,64,1,0,235,
  170,0,0,235,16,0,189,232,32,0,189,232,4,240,157,228,37,161,140,224,188,15,90,229,1,0,64,226,188,15,74,229,
  32,80,133,227,6,80,204,231,6,80,160,225,52,1,0,235,158,0,0,235,32,0,189,232,4,240,157,228,4,224,45,229,
  32,0,45,233,180,15,28,229,1,0,128,226,180,15,12,229,160,15,28,229,4,0,64,226,160,15,12,229,127,15,160,227,
  35,99,0,224,3,81,16,224,32,0,85,227,27,0,0,58,32,0,45,233,6,80,160,225,24,0,45,233,32,1,0,235,
  147,0,0,235,24,0,189,232,36,4,176,225,5,0,204,231,9,0,0,10,24,0,45,233,25,1,0,235,131,0,0,235,
  24,0,189,232,36,4,160,225,28,0,0,226,32,161,140,224,196,15,90,229,1,0,64,226,196,15,74,229,32,0,189,232,
  255,0,4,226,5,0,204,231,92,0,80,227,168,95,12,5,11,1,0,235,108,0,0,235,32,0,189,232,4,240,157,228,
  37,161,140,224,196,15,90,229,1,0,128,226,196,15,74,229,6,80,160,225,2,1,0,235,117,0,0,235,0,0,160,227,
  5,0,204,231,32,0,189,232,4,240,157,228,4,224,45,229,32,0,45,233,180,15,28,229,1,0,128,226,180,15,12,229,
  160,15,28,229,4,0,64,226,160,15,12,229,127,15,160,227,35,99,0,224,3,81,16,224,32,0,85,227,27,0,0,58,
  32,0,45,233,6,80,160,225,24,0,45,233,236,0,0,235,95,0,0,235,24,0,189,232,36,4,176,225,5,0,204,231,
  9,0,0,10,24,0,45,233,229,0,0,235,70,0,0,235,24,0,189,232,36,4,160,225,28,0,0,226,32,161,140,224,
  188,15,90,229,1,0,64,226,188,15,74,229,32,0,189,232,255,0,4,226,5,0,204,231,60,0,80,227,164,95,12,5,
  215,0,0,235,65,0,0,235,32,0,189,232,4,240,157,228,37,161,140,224,188,15,90,229,1,0,128,226,188,15,74,229,
  6,80,160,225,206,0,0,235,65,0,0,235,0,0,160,227,5,0,204,231,32,0,189,232,4,240,157,228,0,48,160,227,
  156,63,76,229,180,15,28,229,1,0,64,226,180,15,12,229,160,15,28,229,4,48,128,228,160,15,12,229,14,240,160,225,
  180,15,28,229,1,0,128,226,180,15,12,229,160,15,28,229,4,0,64,226,160,15,12,229,14,240,160,225,4,224,45,229,
  0,0,160,227,104,11,12,229,100,11,12,229,204,82,159,229,131,144,160,227,12,2,133,229,4,0,133,228,1,144,89,226,
  251,255,255,26,4,0,160,227,148,15,12,229,136,13,12,229,84,80,160,227,9,144,160,227,9,128,160,227,5,0,220,231,
  0,0,80,227,6,0,0,27,4,80,133,226,1,128,88,226,249,255,255,26,4,80,133,226,1,144,89,226,245,255,255,26,
  4,240,157,228,64,0,16,227,8,0,0,10,152,31,28,229,152,95,12,229,1,160,140,224,140,93,10,229,5,160,140,224,
  152,31,10,229,0,0,160,227,140,13,10,229,16,0,0,234,148,31,28,229,148,95,12,229,1,160,140,224,140,93,10,229,
  5,160,140,224,152,31,10,229,4,0,160,227,140,13,10,229,7,0,0,234,5,160,140,224,152,31,26,229,140,45,26,229,
  2,160,140,224,152,31,10,229,1,160,140,224,140,45,10,229,255,255,255,234,14,240,160,225,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,
  5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,0,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,
  12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,18,0,0,0,
  19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,
  0,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,
  34,0,0,0,35,0,0,0,0,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,
  41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,0,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,
  48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,0,0,0,0,54,0,0,0,
  55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,
  0,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,
  70,0,0,0,71,0,0,0,0,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,
  77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  80,5,0,224,5,96,140,224,24,20,22,229,0,32,86,229,62,32,2,226,130,0,143,224,116,5,144,229,0,16,49,224,
  103,0,0,10,228,53,159,229,1,48,19,224,9,0,0,10,5,96,140,224,44,96,70,226,24,4,22,229,3,0,32,224,
  24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,90,0,0,10,180,53,159,229,1,48,19,224,
  9,0,0,10,5,96,140,224,44,96,134,226,24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,
  248,255,255,10,3,16,49,224,77,0,0,10,132,53,159,229,1,48,19,224,9,0,0,10,5,96,140,224,36,96,70,226,
  24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,64,0,0,10,
  84,53,159,229,1,48,19,224,9,0,0,10,5,96,140,224,36,96,134,226,24,4,22,229,3,0,32,224,24,4,6,229,
  0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,51,0,0,10,36,53,159,229,1,48,19,224,9,0,0,10,
  5,96,140,224,40,96,70,226,24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,
  3,16,49,224,38,0,0,10,244,52,159,229,1,48,19,224,9,0,0,10,5,96,140,224,40,96,134,226,24,4,22,229,
  3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,25,0,0,10,196,52,159,229,
  1,48,19,224,9,0,0,10,5,96,140,224,4,96,70,226,24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,
  0,0,80,227,248,255,255,10,3,16,49,224,12,0,0,10,148,52,159,229,1,48,19,224,9,0,0,10,5,96,140,224,
  4,96,134,226,24,4,22,229,3,0,32,224,24,4,6,229,0,0,86,229,0,0,80,227,248,255,255,10,3,16,49,224,
  255,255,255,10,5,96,140,224,130,0,143,224,64,243,144,229,76,6,22,229,2,0,32,226,76,6,6,229,5,96,139,224,
  36,107,22,229,6,160,140,224,128,11,90,229,1,0,32,226,128,11,74,229,14,240,160,225,14,240,160,225,120,6,22,229,
  1,12,32,226,120,6,6,229,112,6,22,229,2,12,32,226,112,6,6,229,14,240,160,225,80,6,22,229,1,0,32,226,
  80,6,6,229,76,6,22,229,2,0,32,226,76,6,6,229,72,6,22,229,4,0,32,226,72,6,6,229,0,6,22,229,
  32,0,32,226,0,6,6,229,248,5,22,229,128,0,32,226,248,5,6,229,14,240,160,225,80,6,22,229,1,0,32,226,
  80,6,6,229,76,6,22,229,2,0,32,226,76,6,6,229,72,6,22,229,4,0,32,226,72,6,6,229,40,6,22,229,
  8,0,32,226,40,6,6,229,32,6,22,229,16,0,32,226,32,6,6,229,252,5,22,229,64,0,32,226,252,5,6,229,
  14,240,160,225,76,6,22,229,2,0,32,226,76,6,6,229,40,6,22,229,8,0,32,226,40,6,6,229,32,6,22,229,
  16,0,32,226,32,6,6,229,252,5,22,229,64,0,32,226,252,5,6,229,14,240,160,225,80,6,22,229,1,0,32,226,
  80,6,6,229,72,6,22,229,4,0,32,226,72,6,6,229,0,6,22,229,32,0,32,226,0,6,6,229,248,5,22,229,
  128,0,32,226,248,5,6,229,14,240,160,225,80,6,22,229,1,0,32,226,80,6,6,229,76,6,22,229,2,0,32,226,
  76,6,6,229,72,6,22,229,4,0,32,226,72,6,6,229,40,6,22,229,8,0,32,226,40,6,6,229,32,6,22,229,
  16,0,32,226,32,6,6,229,0,6,22,229,32,0,32,226,0,6,6,229,252,5,22,229,64,0,32,226,252,5,6,229,
  248,5,22,229,128,0,32,226,248,5,6,229,14,240,160,225,252,5,22,229,2,8,32,226,252,5,6,229,5,96,139,224,
  36,107,22,229,6,160,140,224,116,11,90,229,1,0,32,226,116,11,74,229,14,240,160,225,14,240,160,225,208,5,22,229,
  1,4,32,226,208,5,6,229,216,5,22,229,2,4,32,226,216,5,6,229,14,240,160,225,248,5,22,229,1,8,32,226,
  248,5,6,229,252,5,22,229,2,8,32,226,252,5,6,229,0,6,22,229,1,7,32,226,0,6,6,229,72,6,22,229,
  2,6,32,226,72,6,6,229,80,6,22,229,2,5,32,226,80,6,6,229,14,240,160,225,248,5,22,229,1,8,32,226,
  248,5,6,229,252,5,22,229,2,8,32,226,252,5,6,229,0,6,22,229,1,7,32,226,0,6,6,229,32,6,22,229,
  2,7,32,226,32,6,6,229,40,6,22,229,1,6,32,226,40,6,6,229,76,6,22,229,1,5,32,226,76,6,6,229,
  14,240,160,225,252,5,22,229,2,8,32,226,252,5,6,229,32,6,22,229,2,7,32,226,32,6,6,229,40,6,22,229,
  1,6,32,226,40,6,6,229,76,6,22,229,1,5,32,226,76,6,6,229,14,240,160,225,248,5,22,229,1,8,32,226,
  248,5,6,229,0,6,22,229,1,7,32,226,0,6,6,229,72,6,22,229,2,6,32,226,72,6,6,229,80,6,22,229,
  2,5,32,226,80,6,6,229,14,240,160,225,248,5,22,229,1,8,32,226,248,5,6,229,252,5,22,229,2,8,32,226,
  252,5,6,229,0,6,22,229,1,7,32,226,0,6,6,229,32,6,22,229,2,7,32,226,32,6,6,229,40,6,22,229,
  1,6,32,226,40,6,6,229,72,6,22,229,2,6,32,226,72,6,6,229,76,6,22,229,1,5,32,226,76,6,6,229,
  80,6,22,229,2,5,32,226,80,6,6,229,14,240,160,225,16,32,0,0,152,32,0,0,56,32,0,0,152,32,0,0,
  60,32,0,0,152,32,0,0,88,32,0,0,152,32,0,0,152,32,0,0,0,0,0,0,20,33,0,0,228,32,0,0,
  72,33,0,0,24,33,0,0,76,33,0,0,0,0,0,0,176,33,0,0,56,34,0,0,216,33,0,0,56,34,0,0,
  220,33,0,0,56,34,0,0,248,33,0,0,56,34,0,0,56,34,0,0,0,0,0,0,180,34,0,0,132,34,0,0,
  232,34,0,0,184,34,0,0,236,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,0,0,0,165,0,0,0,
  90,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,0,0,0,165,0,
  0,0,90,0,0,0,90,0,0,0,0,0,0,0,0,0,1,0,128,0,128,0,1,0,4,0,32,0,32,0,4,0,
  2,0,64,0,64,0,2,0,8,0,16,0,16,0,8,0,14,240,160,225,14,240,160,225,0,144,160,227,14,240,160,225,
  0,144,160,227,14,240,160,225,0,144,160,227,14,240,160,225,0,0,160,227,80,11,12,229,76,11,12,229,168,95,28,229,
  5,160,140,224,36,6,26,229,22,20,90,229,32,24,145,225,18,0,0,10,1,16,139,224,0,20,209,229,128,0,17,227,
  1,28,65,18,0,16,113,226,10,0,0,10,1,96,69,224,6,0,220,231,0,0,80,227,4,0,0,26,76,27,12,229,
  1,96,70,224,6,0,220,231,0,0,80,227,251,255,255,10,80,107,12,229,14,240,160,225,0,0,224,227,80,11,12,229,
  14,240,160,225,0,0,160,227,80,11,12,229,76,11,12,229,164,95,28,229,5,160,140,224,34,6,26,229,24,20,90,229,
  32,24,145,225,18,0,0,10,1,16,139,224,0,20,209,229,128,0,17,227,1,28,65,18,0,0,81,227,10,0,0,10,
  1,96,69,224,6,0,220,231,0,0,80,227,4,0,0,26,76,27,12,229,1,96,70,224,6,0,220,231,0,0,80,227,
  251,255,255,10,80,107,12,229,14,240,160,225,0,0,224,227,80,11,12,229,14,240,160,225,164,95,28,229,0,0,85,227,
  120,0,0,10,5,96,140,224,6,128,160,225,32,16,160,227,44,0,248,229,14,18,200,229,0,0,80,227,251,255,255,10,
  128,0,16,227,4,0,0,26,24,4,24,229,1,0,16,227,1,0,0,10,32,0,160,227,15,2,200,229,6,128,160,225,
  66,16,160,227,40,0,248,229,14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,
  2,0,16,227,1,0,0,10,64,0,160,227,15,2,200,229,6,128,160,225,32,16,160,227,36,0,248,229,14,18,200,229,
  0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,4,0,16,227,1,0,0,10,96,0,160,227,
  15,2,200,229,6,128,160,225,64,16,160,227,4,0,248,229,14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,
  4,0,0,26,24,4,24,229,8,0,16,227,1,0,0,10,128,0,160,227,15,2,200,229,6,128,160,225,64,16,160,227,
  4,0,120,229,14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,16,0,16,227,
  1,0,0,10,128,0,160,227,15,2,200,229,6,128,160,225,32,16,160,227,36,0,120,229,14,18,200,229,0,0,80,227,
  251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,32,0,16,227,1,0,0,10,96,0,160,227,15,2,200,229,
  6,128,160,225,64,16,160,227,40,0,120,229,14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,
  24,4,24,229,64,0,16,227,1,0,0,10,64,0,160,227,15,2,200,229,6,128,160,225,32,16,160,227,44,0,120,229,
  14,18,200,229,0,0,80,227,251,255,255,10,128,0,16,227,4,0,0,26,24,4,24,229,128,0,16,227,1,0,0,10,
  32,0,160,227,15,2,200,229,4,16,160,227,98,18,198,229,90,18,198,229,91,16,160,227,54,18,198,229,56,16,160,227,
  58,18,198,229,50,18,198,229,80,16,160,227,18,18,198,229,10,18,198,229,40,16,160,227,234,17,198,229,226,17,198,229,
  80,16,160,227,230,17,198,229,14,240,160,225,30,0,0,226,128,0,143,224,0,240,144,229,12,42,0,0,12,42,0,0,
  12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,12,42,0,0,
  64,42,0,0,16,42,0,0,228,42,0,0,180,42,0,0,12,42,0,0,12,42,0,0,4,224,45,229,12,80,160,225,
  0,0,160,227,131,144,160,227,12,2,133,229,24,4,133,229,4,80,133,226,1,144,89,226,250,255,255,26,168,95,28,229,
  0,0,85,227,135,0,0,10,1,64,160,227,5,96,140,224,44,0,118,229,0,0,80,227,252,255,255,10,128,0,16,227,
  9,0,0,26,22,4,86,229,1,0,16,227,6,0,0,10,32,0,160,227,13,2,198,229,25,68,198,229,44,0,118,229,
  0,0,80,227,252,255,255,10,207,255,255,235,2,64,160,227,5,96,140,224,40,0,118,229,0,0,80,227,252,255,255,10,
  128,0,16,227,9,0,0,26,22,4,86,229,2,0,16,227,6,0,0,10,64,0,160,227,13,2,198,229,25,68,198,229,
  40,0,118,229,0,0,80,227,252,255,255,10,190,255,255,235,4,64,160,227,5,96,140,224,36,0,118,229,0,0,80,227,
  252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,4,0,16,227,6,0,0,10,96,0,160,227,13,2,198,229,
  25,68,198,229,36,0,118,229,0,0,80,227,252,255,255,10,173,255,255,235,8,64,160,227,5,96,140,224,4,0,118,229,
  0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,8,0,16,227,6,0,0,10,128,0,160,227,
  13,2,198,229,25,68,198,229,4,0,118,229,0,0,80,227,252,255,255,10,156,255,255,235,16,64,160,227,5,96,140,224,
  4,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,16,0,16,227,6,0,0,10,
  128,0,160,227,13,2,198,229,25,68,198,229,4,0,246,229,0,0,80,227,252,255,255,10,139,255,255,235,32,64,160,227,
  5,96,140,224,36,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,32,0,16,227,
  6,0,0,10,96,0,160,227,13,2,198,229,25,68,198,229,36,0,246,229,0,0,80,227,252,255,255,10,122,255,255,235,
  64,64,160,227,5,96,140,224,40,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,22,4,86,229,
  64,0,16,227,6,0,0,10,64,0,160,227,13,2,198,229,25,68,198,229,40,0,246,229,0,0,80,227,252,255,255,10,
  105,255,255,235,128,64,160,227,5,96,140,224,44,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,
  22,4,86,229,128,0,16,227,6,0,0,10,32,0,160,227,13,2,198,229,25,68,198,229,44,0,246,229,0,0,80,227,
  252,255,255,10,88,255,255,235,4,240,157,228,14,240,160,225,64,4,214,229,4,0,128,225,64,4,198,229,28,4,214,229,
  4,0,128,225,28,4,198,229,20,4,214,229,4,0,128,225,20,4,198,229,240,3,214,229,4,0,128,225,240,3,198,229,
  6,112,160,225,44,16,247,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,
  36,16,247,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,36,16,119,229,
  24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,44,16,119,229,24,4,215,229,
  4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,14,240,160,225,68,4,214,229,4,0,128,225,68,4,198,229,
  60,4,214,229,4,0,128,225,60,4,198,229,244,3,214,229,4,0,128,225,244,3,198,229,236,3,214,229,4,0,128,225,
  236,3,198,229,6,112,160,225,40,16,247,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,
  6,112,160,225,4,16,247,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,
  4,16,119,229,24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,40,16,119,229,
  24,4,215,229,4,0,128,225,24,4,199,229,0,0,81,227,249,255,255,10,14,240,160,225,30,0,0,226,128,0,143,224,
  0,240,144,229,248,45,0,0,248,45,0,0,248,45,0,0,248,45,0,0,248,45,0,0,248,45,0,0,248,45,0,0,
  248,45,0,0,248,45,0,0,248,45,0,0,44,46,0,0,252,45,0,0,208,46,0,0,160,46,0,0,248,45,0,0,
  248,45,0,0,4,224,45,229,12,80,160,225,0,0,160,227,131,144,160,227,12,2,133,229,24,4,133,229,4,80,133,226,
  1,144,89,226,250,255,255,26,164,95,28,229,0,0,85,227,135,0,0,10,1,64,160,227,5,96,140,224,44,0,246,229,
  0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,1,0,16,227,6,0,0,10,32,0,160,227,
  15,2,198,229,27,68,198,229,44,0,246,229,0,0,80,227,252,255,255,10,207,255,255,235,2,64,160,227,5,96,140,224,
  40,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,2,0,16,227,6,0,0,10,
  64,0,160,227,15,2,198,229,27,68,198,229,40,0,246,229,0,0,80,227,252,255,255,10,190,255,255,235,4,64,160,227,
  5,96,140,224,36,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,4,0,16,227,
  6,0,0,10,96,0,160,227,15,2,198,229,27,68,198,229,36,0,246,229,0,0,80,227,252,255,255,10,173,255,255,235,
  8,64,160,227,5,96,140,224,4,0,246,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,
  8,0,16,227,6,0,0,10,128,0,160,227,15,2,198,229,27,68,198,229,4,0,246,229,0,0,80,227,252,255,255,10,
  156,255,255,235,16,64,160,227,5,96,140,224,4,0,118,229,0,0,80,227,252,255,255,10,128,0,16,227,9,0,0,26,
  24,4,86,229,16,0,16,227,6,0,0,10,128,0,160,227,15,2,198,229,27,68,198,229,4,0,118,229,0,0,80,227,
  252,255,255,10,139,255,255,235,32,64,160,227,5,96,140,224,36,0,118,229,0,0,80,227,252,255,255,10,128,0,16,227,
  9,0,0,26,24,4,86,229,32,0,16,227,6,0,0,10,96,0,160,227,15,2,198,229,27,68,198,229,36,0,118,229,
  0,0,80,227,252,255,255,10,122,255,255,235,64,64,160,227,5,96,140,224,40,0,118,229,0,0,80,227,252,255,255,10,
  128,0,16,227,9,0,0,26,24,4,86,229,64,0,16,227,6,0,0,10,64,0,160,227,15,2,198,229,27,68,198,229,
  40,0,118,229,0,0,80,227,252,255,255,10,105,255,255,235,128,64,160,227,5,96,140,224,44,0,118,229,0,0,80,227,
  252,255,255,10,128,0,16,227,9,0,0,26,24,4,86,229,128,0,16,227,6,0,0,10,32,0,160,227,15,2,198,229,
  27,68,198,229,44,0,118,229,0,0,80,227,252,255,255,10,88,255,255,235,4,240,157,228,14,240,160,225,66,4,214,229,
  4,0,128,225,66,4,198,229,30,4,214,229,4,0,128,225,30,4,198,229,22,4,214,229,4,0,128,225,22,4,198,229,
  242,3,214,229,4,0,128,225,242,3,198,229,6,112,160,225,44,16,247,229,26,4,215,229,4,0,128,225,26,4,199,229,
  0,0,81,227,249,255,255,10,6,112,160,225,36,16,247,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,
  249,255,255,10,6,112,160,225,36,16,119,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,249,255,255,10,
  6,112,160,225,44,16,119,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,249,255,255,10,14,240,160,225,
  70,4,214,229,4,0,128,225,70,4,198,229,62,4,214,229,4,0,128,225,62,4,198,229,246,3,214,229,4,0,128,225,
  246,3,198,229,238,3,214,229,4,0,128,225,238,3,198,229,6,112,160,225,40,16,247,229,26,4,215,229,4,0,128,225,
  26,4,199,229,0,0,81,227,249,255,255,10,6,112,160,225,4,16,247,229,26,4,215,229,4,0,128,225,26,4,199,229,
  0,0,81,227,249,255,255,10,6,112,160,225,4,16,119,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,
  249,255,255,10,6,112,160,225,40,16,119,229,26,4,215,229,4,0,128,225,26,4,199,229,0,0,81,227,249,255,255,10,
  14,240,160,225,4,224,45,229,40,219,12,229,230,18,0,235,0,0,160,227,228,15,12,229,212,31,28,229,1,0,139,224,
  92,9,80,229,128,0,16,227,1,12,64,18,56,11,12,229,180,15,12,229,1,0,139,224,81,9,80,229,0,1,160,225,
  52,11,12,229,1,0,139,224,70,9,80,229,0,1,160,225,48,11,12,229,1,0,139,224,59,9,80,229,0,1,160,225,
  44,11,12,229,176,111,28,229,253,76,0,235,172,111,12,229,180,2,0,235,176,95,28,229,172,111,28,229,6,0,85,225,
  5,0,0,10,238,1,0,235,176,95,28,229,0,0,21,229,228,15,12,229,180,0,159,229,224,15,12,229,176,111,28,229,
  239,76,0,235,172,111,12,229,229,1,0,235,176,95,28,229,0,0,21,229,228,15,12,229,144,0,159,229,224,15,12,229,
  21,2,0,235,176,95,28,229,172,111,28,229,6,0,85,225,25,0,0,10,0,0,21,229,228,15,12,229,104,0,159,229,
  224,15,12,229,4,80,133,226,6,0,85,225,18,0,0,10,56,11,28,229,1,0,80,227,1,0,160,195,180,15,12,229,
  104,25,27,229,108,41,27,229,72,27,12,229,68,43,12,229,23,0,0,235,60,91,28,229,0,0,85,227,6,0,0,10,
  211,3,0,235,180,15,28,229,1,0,128,226,180,15,12,229,56,27,28,229,1,0,80,225,240,255,255,218,40,219,28,229,
  228,15,28,229,224,31,28,229,4,240,157,228,48,117,0,0,49,117,0,0,228,15,28,229,0,0,80,227,14,240,160,1,
  4,224,45,229,10,248,255,235,2,0,80,227,242,255,255,10,4,240,157,228,4,224,45,229,72,27,28,229,68,43,28,229,
  176,63,28,229,172,79,28,229,30,0,45,233,176,79,12,229,180,15,28,229,0,0,139,224,45,9,80,229,240,3,0,235,
  30,0,189,232,72,27,12,229,68,43,12,229,176,63,12,229,172,79,12,229,0,0,80,227,3,0,0,10,228,15,12,229,
  100,0,159,229,224,15,12,229,219,255,255,234,0,0,160,227,60,11,12,229,176,95,28,229,172,15,28,229,0,0,85,225,
  15,0,0,10,0,48,21,229,220,63,12,229,119,0,0,235,72,27,28,229,1,0,80,225,7,0,0,218,72,11,12,229,
  224,15,12,229,60,91,12,229,0,48,21,229,228,63,12,229,68,27,28,229,1,0,80,225,1,0,0,170,4,80,133,226,
  236,255,255,234,72,11,28,229,4,240,157,228,34,78,0,0,4,224,45,229,180,15,28,229,0,0,80,227,5,0,0,186,
  3,16,160,227,195,3,0,235,0,0,80,227,1,0,0,10,108,9,27,229,4,240,157,228,72,27,28,229,68,43,28,229,
  6,0,45,233,8,128,160,227,178,252,255,235,0,0,89,227,28,0,0,10,255,0,9,226,8,0,64,226,180,31,28,229,
  1,0,80,225,23,0,0,186,73,72,160,225,255,12,9,226,1,12,80,227,4,0,0,26,6,0,189,232,72,27,12,229,
  68,43,12,229,4,0,160,225,4,240,157,228,2,12,80,227,6,0,0,26,72,11,28,229,0,0,84,225,245,255,255,218,
  68,11,28,229,0,0,84,225,68,75,12,181,5,0,0,234,68,11,28,229,0,0,84,225,238,255,255,170,72,11,28,229,
  0,0,84,225,72,75,12,197,7,0,0,235,6,0,189,232,72,27,12,229,68,43,12,229,1,0,45,233,8,128,160,227,
  100,3,0,235,1,0,189,232,4,240,157,228,180,15,28,229,0,0,80,227,78,0,0,218,4,224,45,229,176,111,28,229,
  79,76,0,235,172,111,12,229,176,95,28,229,5,0,86,225,16,0,0,10,120,1,0,235,176,95,28,229,172,15,28,229,
  0,0,85,225,9,0,0,10,15,0,0,235,72,27,28,229,1,0,80,225,3,0,0,218,72,11,12,229,68,27,28,229,
  1,0,80,225,1,0,0,170,4,80,133,226,242,255,255,234,72,11,28,229,4,240,157,228,156,15,92,229,0,0,80,227,
  192,14,159,229,0,0,96,18,4,240,157,228,4,224,45,229,175,2,0,235,1,0,213,229,127,0,0,226,64,27,28,229,
  0,1,81,225,1,0,0,10,8,0,0,235,4,240,157,228,180,31,28,229,1,16,129,226,180,31,12,229,3,0,0,235,
  180,31,28,229,1,16,65,226,180,31,12,229,4,240,157,228,4,224,45,229,0,48,21,229,29,249,255,235,72,27,28,229,
  68,43,28,229,176,111,28,229,172,127,28,229,246,0,45,233,176,127,12,229,58,248,255,235,7,250,255,235,72,27,28,229,
  68,43,28,229,0,16,97,226,0,32,98,226,72,43,12,229,68,27,12,229,133,255,255,235,1,0,45,233,48,248,255,235,
  253,249,255,235,1,0,189,232,0,0,96,226,246,0,189,232,72,27,12,229,68,43,12,229,176,111,12,229,172,127,12,229,
  1,0,45,233,0,48,21,229,123,249,255,235,1,0,189,232,4,240,157,228,4,224,45,229,110,3,0,235,49,0,0,26,
  1,0,160,227,62,3,0,235,0,0,80,227,76,0,0,26,180,15,28,229,1,0,112,227,15,0,0,218,3,0,160,227,
  66,3,0,235,0,0,80,227,38,0,0,26,176,111,28,229,243,75,0,235,172,111,12,229,176,95,28,229,5,0,86,225,
  65,0,0,10,167,1,0,235,229,0,0,235,52,27,28,229,94,1,0,235,65,0,0,235,4,240,157,228,180,15,28,229,
  1,0,112,227,15,0,0,218,1,0,160,227,47,3,0,235,0,0,80,227,36,0,0,26,176,111,28,229,224,75,0,235,
  172,111,12,229,176,95,28,229,5,0,86,225,46,0,0,10,148,1,0,235,210,0,0,235,48,27,28,229,75,1,0,235,
  46,0,0,235,4,240,157,228,176,111,28,229,212,75,0,235,172,111,12,229,176,95,28,229,5,0,86,225,34,0,0,10,
  110,0,0,235,4,240,157,228,180,15,28,229,1,0,112,227,13,0,0,218,176,111,28,229,201,75,0,235,172,111,12,229,
  176,95,28,229,5,0,86,225,23,0,0,10,3,0,160,227,36,11,12,229,108,1,0,235,185,0,0,235,52,27,28,229,
  50,1,0,235,76,0,0,235,4,240,157,228,176,111,28,229,187,75,0,235,172,111,12,229,176,95,28,229,5,0,86,225,
  9,0,0,10,1,0,160,227,36,11,12,229,94,1,0,235,171,0,0,235,48,27,28,229,36,1,0,235,62,0,0,235,
  4,240,157,228,160,12,159,229,4,240,157,228,156,15,92,229,0,0,80,227,148,12,159,229,0,0,96,18,4,240,157,228,
  4,224,45,229,176,95,28,229,172,15,28,229,0,0,85,225,9,0,0,10,108,255,255,235,72,27,28,229,1,0,80,225,
  3,0,0,218,72,11,12,229,68,27,28,229,1,0,80,225,39,0,0,170,4,80,133,226,242,255,255,234,118,249,255,235,
  72,27,28,229,68,43,28,229,176,63,28,229,172,79,28,229,30,0,45,233,176,79,12,229,32,16,65,226,32,32,66,226,
  72,27,12,229,68,43,12,229,173,247,255,235,122,249,255,235,72,27,28,229,68,43,28,229,0,16,97,226,0,32,98,226,
  72,43,12,229,68,27,12,229,129,255,255,235,1,0,45,233,163,247,255,235,112,249,255,235,1,0,189,232,0,0,96,226,
  30,0,189,232,72,27,12,229,68,43,12,229,176,63,12,229,172,79,12,229,1,0,45,233,96,249,255,235,1,0,189,232,
  32,0,128,226,72,27,28,229,1,0,80,225,0,0,0,218,72,11,12,229,72,11,28,229,4,240,157,228,4,224,45,229,
  176,95,28,229,172,15,28,229,0,0,85,225,9,0,0,10,53,255,255,235,72,27,28,229,1,0,80,225,3,0,0,218,
  72,11,12,229,68,27,28,229,1,0,80,225,1,0,0,170,4,80,133,226,242,255,255,234,72,11,28,229,4,240,157,228,
  4,224,45,229,0,0,160,227,104,6,12,229,108,6,12,229,236,10,12,229,180,15,28,229,3,0,112,227,129,2,0,203,
  42,1,0,235,176,95,28,229,172,111,28,229,6,0,85,225,1,0,0,26,116,2,0,235,4,240,157,228,108,6,28,229,
  8,0,80,227,3,0,0,58,104,118,28,229,7,0,220,231,0,0,80,227,104,6,12,5,32,17,0,235,72,27,28,229,
  1,0,80,225,3,0,0,218,72,11,12,229,68,27,28,229,1,0,80,225,16,0,0,170,57,0,0,235,44,27,28,229,
  178,0,0,235,176,95,28,229,172,15,28,229,0,0,85,225,9,0,0,10,4,255,255,235,72,27,28,229,1,0,80,225,
  3,0,0,218,72,11,12,229,68,27,28,229,1,0,80,225,1,0,0,170,4,80,133,226,242,255,255,234,72,11,28,229,
  4,240,157,228,4,224,45,229,154,2,0,235,1,0,0,26,77,2,0,235,4,240,157,228,176,111,28,229,40,75,0,235,
  172,111,12,229,176,95,28,229,5,0,86,225,23,0,0,10,176,95,28,229,172,15,28,229,0,0,85,225,17,0,0,10,
  0,48,21,229,26,248,255,235,48,0,45,233,79,2,0,235,48,0,189,232,1,0,45,233,0,48,21,229,142,248,255,235,
  1,0,189,232,72,27,28,229,1,0,80,225,3,0,0,218,72,11,12,229,68,27,28,229,1,0,80,225,1,0,0,170,
  4,80,133,226,234,255,255,234,72,11,28,229,4,240,157,228,156,15,92,229,0,0,80,227,20,10,159,229,0,0,96,18,
  4,240,157,228,176,95,28,229,172,111,28,229,6,0,85,225,14,240,160,1,180,15,28,229,3,0,112,227,14,240,160,209,
  4,224,45,229,73,1,0,235,32,0,45,233,0,48,21,229,247,247,255,235,72,27,28,229,68,43,28,229,176,111,28,229,
  172,127,28,229,246,0,45,233,176,127,12,229,20,247,255,235,225,248,255,235,188,25,159,229,188,41,159,229,72,27,12,229,
  68,43,12,229,190,255,255,235,1,0,45,233,12,247,255,235,217,248,255,235,1,0,189,232,0,0,96,226,246,0,189,232,
  72,27,12,229,68,43,12,229,176,111,12,229,172,127,12,229,1,0,45,233,0,48,21,229,87,248,255,235,1,0,189,232,
  1,0,45,233,46,246,255,235,2,0,189,232,1,0,128,224,4,0,133,229,8,80,149,229,0,0,85,227,218,255,255,26,
  0,1,189,232,176,15,28,229,0,64,72,224,36,65,160,225,83,4,0,235,42,1,0,235,4,240,157,228,176,95,28,229,
  172,111,28,229,6,0,85,225,14,240,160,1,4,224,45,229,56,2,0,235,14,0,0,26,72,27,28,229,68,43,28,229,
  176,63,28,229,172,79,28,229,30,0,45,233,176,79,12,229,1,16,160,227,10,2,0,235,30,0,189,232,72,27,12,229,
  68,43,12,229,176,63,12,229,172,79,12,229,0,0,80,227,0,0,0,10,95,0,0,235,176,95,28,229,172,111,28,229,
  6,0,85,225,4,240,157,4,173,255,255,235,180,15,28,229,0,0,80,227,2,0,0,202,48,16,160,227,35,0,0,235,
  4,240,157,228,50,30,160,227,32,0,0,235,180,15,28,229,1,0,80,227,8,0,0,202,2,0,224,227,40,48,160,227,
  150,79,160,227,41,0,0,235,0,0,224,227,12,48,160,227,150,79,160,227,37,0,0,235,4,240,157,228,180,15,28,229,
  2,0,80,227,8,0,0,202,2,0,224,227,64,48,160,227,150,79,160,227,29,0,0,235,0,0,224,227,16,48,160,227,
  150,79,160,227,25,0,0,235,4,240,157,228,0,0,224,227,32,48,160,227,50,78,160,227,20,0,0,235,1,0,160,227,
  12,48,160,227,150,79,160,227,16,0,0,235,4,240,157,228,180,15,28,229,3,0,112,227,14,240,160,209,176,15,28,229,
  0,16,129,224,172,15,28,229,1,0,80,225,14,240,160,209,4,224,45,229,176,15,28,229,1,0,45,233,176,31,12,229,
  156,0,0,235,1,0,189,232,176,15,12,229,4,240,157,228,4,224,45,229,176,95,28,229,172,111,28,229,6,0,85,225,
  27,0,0,10,72,27,28,229,68,43,28,229,180,111,28,229,94,0,45,233,180,15,12,229,188,0,0,235,32,0,45,233,
  184,23,159,229,184,39,159,229,72,27,12,229,68,43,12,229,53,254,255,235,4,0,133,229,8,80,149,229,0,0,85,227,
  246,255,255,26,0,1,189,232,176,15,28,229,0,64,72,224,36,65,160,225,226,3,0,235,94,0,189,232,72,27,12,229,
  68,43,12,229,180,111,12,229,4,0,149,229,4,64,64,224,187,0,0,235,4,240,157,228,4,224,45,229,1,16,160,227,
  170,1,0,235,36,11,12,229,4,224,157,228,4,224,45,229,176,95,28,229,5,96,160,225,172,15,28,229,0,0,85,225,
  6,0,0,10,64,0,45,233,53,1,0,235,64,0,189,232,0,0,80,227,4,0,149,228,4,0,134,4,245,255,255,234,
  172,111,12,229,4,240,157,228,176,95,28,229,172,111,28,229,6,0,85,225,14,240,160,1,4,224,45,229,85,16,0,235,
  187,0,0,235,176,95,28,229,5,96,160,225,169,0,0,235,6,0,0,26,189,0,0,235,4,0,0,26,96,0,45,233,
  198,0,0,235,96,0,189,232,2,0,80,227,1,0,0,58,0,0,21,229,4,0,134,228,4,80,133,226,172,15,28,229,
  0,0,85,225,240,255,255,26,172,111,12,229,4,240,157,228,180,15,28,229,3,0,112,227,70,0,0,218,176,95,28,229,
  172,111,28,229,6,0,85,225,14,240,160,1,4,224,45,229,159,0,0,235,5,96,160,225,142,0,0,235,53,0,0,26,
  1,0,213,229,127,0,0,226,104,22,28,229,0,1,81,225,5,0,0,26,108,22,28,229,8,0,81,227,45,0,0,42,
  0,0,85,229,1,0,80,225,42,0,0,10,108,22,28,229,8,0,81,227,3,0,0,58,0,0,85,229,127,0,0,226,
  0,1,81,225,35,0,0,10,64,0,45,233,58,0,0,235,64,0,189,232,31,0,0,26,0,0,85,229,8,0,80,227,
  23,0,0,58,0,0,85,229,127,0,0,226,0,1,220,231,64,0,80,227,18,0,0,10,84,0,80,227,16,0,0,10,
  86,0,80,227,14,0,0,10,88,0,80,227,12,0,0,10,90,0,80,227,10,0,0,10,64,0,45,233,0,48,21,229,
  243,246,255,235,105,1,0,235,1,0,45,233,0,48,21,229,105,247,255,235,1,0,189,232,64,0,189,232,0,0,80,227,
  6,0,0,10,96,0,45,233,124,0,0,235,96,0,189,232,3,0,80,227,1,0,0,58,0,0,21,229,4,0,134,228,
  4,80,133,226,172,15,28,229,0,0,85,225,193,255,255,26,172,111,12,229,4,240,157,228,176,95,28,229,172,111,28,229,
  6,0,85,225,14,240,160,1,4,224,45,229,88,0,0,235,5,96,160,225,71,0,0,235,1,0,0,10,0,0,21,229,
  4,0,134,228,4,80,133,226,172,15,28,229,0,0,85,225,247,255,255,26,172,111,12,229,4,240,157,228,4,224,45,229,
  236,10,28,229,0,0,80,227,22,0,0,10,0,48,21,229,199,246,255,235,236,122,28,229,7,128,140,224,36,6,24,229,
  24,20,24,229,1,0,128,225,32,24,160,225,1,8,32,224,0,0,139,224,0,0,208,229,1,16,139,224,0,16,209,229,
  1,0,64,224,1,0,45,233,0,48,21,229,50,247,255,235,1,0,189,232,232,26,28,229,1,0,80,225,1,0,0,218,
  1,0,176,227,4,240,157,228,0,0,176,227,4,240,157,228,176,95,28,229,172,111,28,229,6,112,160,225,7,0,85,225,
  3,0,0,10,4,48,149,228,12,48,134,228,4,96,6,229,249,255,255,234,0,0,160,227,4,0,6,229,172,111,12,229,
  14,240,160,225,176,111,28,229,0,48,21,229,4,48,134,228,8,80,149,229,0,0,85,227,250,255,255,26,172,111,12,229,
  14,240,160,225,176,111,28,229,4,0,149,229,4,0,80,225,6,0,0,186,0,0,21,229,4,0,134,228,8,80,149,229,
  0,0,85,227,1,0,0,10,1,48,83,226,245,255,255,26,172,111,12,229,14,240,160,225,1,0,213,229,127,0,0,226,
  64,27,28,229,0,1,81,225,7,0,0,10,10,0,64,226,0,1,81,225,2,0,0,26,0,0,85,229,0,0,80,227,
  1,0,0,10,0,0,176,227,14,240,160,225,1,0,176,227,14,240,160,225,160,15,28,229,3,0,80,229,127,0,0,226,
  0,1,160,225,130,15,96,226,64,11,12,229,14,240,160,225,0,0,21,229,0,1,160,225,32,20,160,225,127,15,0,226,
  127,31,1,226,0,0,140,224,10,2,16,229,1,16,140,224,10,18,17,229,1,0,16,224,1,0,176,19,14,240,160,225,
  4,224,45,229,0,112,85,229,8,0,87,227,13,0,0,58,32,0,45,233,127,80,7,226,5,81,160,225,234,7,0,235,
  32,0,189,232,1,112,213,229,127,112,7,226,7,1,220,231,32,0,16,227,3,0,0,10,7,129,140,224,37,6,216,229,
  2,0,64,226,37,6,200,229,0,48,21,229,88,246,255,235,181,0,0,235,176,0,45,233,0,96,21,229,6,97,160,225,
  38,84,160,225,127,95,5,226,127,111,6,226,212,4,0,235,176,0,189,232,184,0,0,235,1,0,45,233,0,48,21,229,
  197,246,255,235,0,112,85,229,8,0,87,227,13,0,0,58,32,0,45,233,127,80,7,226,5,81,160,225,178,7,0,235,
  32,0,189,232,1,112,213,229,127,112,7,226,7,1,220,231,32,0,16,227,3,0,0,10,7,129,140,224,37,6,216,229,
  2,0,128,226,37,6,200,229,1,0,189,232,0,112,85,229,8,0,87,227,27,0,0,58,127,112,7,226,7,129,140,224,
  24,68,88,229,0,0,84,227,12,0,0,10,4,64,139,224,0,68,212,229,0,0,84,227,7,0,0,10,128,0,20,227,
  1,76,68,18,4,128,136,224,0,16,88,229,0,0,81,227,251,255,255,10,32,0,17,227,0,0,0,10,1,0,128,226,
  0,112,85,229,127,112,7,226,7,113,160,225,204,0,87,227,4,0,0,42,7,128,140,224,40,16,216,229,64,0,81,227,
  0,0,0,26,1,0,128,226,1,112,213,229,127,112,7,226,7,17,220,231,0,0,81,227,0,0,0,10,1,0,128,226,
  4,240,157,228,4,224,45,229,0,48,21,229,16,246,255,235,48,0,45,233,133,0,0,235,0,0,160,227,14,0,0,26,
  72,27,28,229,68,43,28,229,176,63,28,229,172,79,28,229,30,0,45,233,176,79,12,229,36,11,28,229,83,0,0,235,
  30,0,189,232,72,27,12,229,68,43,12,229,176,63,12,229,172,79,12,229,0,0,80,227,1,0,160,19,48,0,189,232,
  1,0,45,233,0,48,21,229,115,246,255,235,1,0,189,232,4,240,157,228,0,16,21,229,176,111,28,229,6,0,85,225,
  2,0,0,10,4,0,21,229,4,0,5,228,250,255,255,234,0,16,5,229,14,240,160,225,4,224,45,229,180,63,28,229,
  3,0,115,227,2,48,224,179,8,48,131,226,0,152,131,224,72,27,28,229,1,0,80,225,5,0,0,218,68,43,28,229,
  2,0,80,225,5,0,0,170,1,156,137,226,24,249,255,235,4,240,157,228,2,156,137,226,21,249,255,235,4,240,157,228,
  3,156,137,226,18,249,255,235,4,240,157,228,4,224,45,229,10,128,160,227,15,249,255,235,0,0,89,227,2,0,0,10,
  73,8,160,225,4,240,157,228,4,224,45,229,16,252,255,235,165,14,0,235,1,0,45,233,0,152,160,225,1,144,137,226,
  10,128,160,227,2,249,255,235,1,0,189,232,4,240,157,228,4,224,45,229,234,244,255,235,183,246,255,235,234,255,255,235,
  1,0,45,233,230,244,255,235,179,246,255,235,1,0,189,232,0,0,96,226,4,240,157,228,4,224,45,229,19,0,0,235,
  0,0,0,234,4,224,45,229,180,31,28,229,2,0,45,233,180,15,12,229,81,0,0,235,2,0,189,232,180,31,12,229,
  4,240,157,228,4,224,45,229,8,0,0,235,0,0,0,234,4,224,45,229,180,31,28,229,2,0,45,233,180,15,12,229,
  77,0,0,235,2,0,189,232,180,31,12,229,4,240,157,228,180,15,28,229,0,0,128,224,0,0,160,67,1,0,128,224,
  9,0,80,227,9,0,160,195,14,240,160,225,0,16,85,229,8,0,81,227,5,0,0,58,127,16,1,226,1,161,140,224,
  2,112,218,229,0,16,160,227,2,16,202,229,14,240,160,225,1,112,139,224,100,121,87,229,14,240,160,225,0,16,85,229,
  8,0,81,227,2,0,0,58,127,16,1,226,1,161,140,224,2,112,202,229,14,240,160,225,168,31,28,229,1,16,140,224,
  36,6,17,229,22,20,81,229,32,8,145,225,14,240,160,225,164,31,28,229,1,16,140,224,34,6,17,229,24,20,81,229,
  32,8,145,225,14,240,160,225,224,177,255,255,32,78,0,0,224,177,255,255,224,177,255,255,224,177,255,255,32,78,0,0,
  224,177,255,255,32,78,0,0,4,224,45,229,180,159,28,229,1,0,160,227,180,15,12,229,30,0,160,227,181,15,76,229,
  0,2,45,233,69,0,0,235,0,2,189,232,0,0,80,227,7,0,0,26,180,15,28,229,2,0,128,226,180,15,12,229,
  9,0,80,225,245,255,255,218,180,159,12,229,0,0,160,227,4,240,157,228,180,159,12,229,4,0,160,225,4,240,157,228,
  4,224,45,229,30,0,160,227,181,15,76,229,51,0,0,235,0,0,80,227,4,0,160,17,4,240,157,228,4,224,45,229,
  127,244,255,235,76,246,255,235,244,255,255,235,1,0,45,233,123,244,255,235,72,246,255,235,1,0,189,232,4,240,157,228,
  4,224,45,229,1,0,160,227,180,15,12,229,30,0,160,227,181,15,76,229,33,0,0,235,0,0,80,227,8,0,0,26,
  180,15,28,229,2,0,128,226,180,15,12,229,15,0,80,227,247,255,255,218,0,0,160,227,32,87,159,229,0,0,5,229,
  4,240,157,228,180,15,28,229,1,0,45,233,0,0,0,234,18,0,0,235,176,95,28,229,4,64,133,228,176,95,12,229,
  0,0,84,227,10,0,0,10,4,48,160,225,56,245,255,235,87,0,0,235,176,95,28,229,4,64,133,228,176,95,12,229,
  0,0,84,227,2,0,0,10,4,48,160,225,109,245,255,235,238,255,255,234,1,0,189,232,180,15,12,229,4,240,157,228,
  180,15,28,229,1,0,80,227,154,0,0,218,4,224,45,229,103,251,255,235,0,0,160,227,32,11,12,229,176,111,28,229,
  197,75,0,235,172,111,12,229,176,95,28,229,6,0,85,225,61,0,0,10,159,1,0,235,172,15,28,229,0,0,85,225,
  52,0,0,42,0,48,21,229,25,245,255,235,176,31,28,229,172,47,28,229,32,59,28,229,62,0,45,233,176,47,12,229,
  51,0,0,235,62,0,189,232,176,31,12,229,172,47,12,229,32,27,28,229,1,48,131,225,32,59,12,229,3,0,45,233,
  0,48,21,229,132,245,255,235,3,0,189,232,0,0,80,227,17,0,0,26,0,0,81,227,13,0,0,26,4,0,149,229,
  128,0,128,227,0,16,21,229,1,0,80,225,8,0,0,26,127,0,0,226,0,1,220,231,64,0,80,227,3,0,0,10,
  84,0,80,227,1,0,0,10,88,0,80,227,0,0,0,26,4,80,133,226,4,80,133,226,214,255,255,234,1,0,45,233,
  172,95,12,229,116,1,0,235,172,95,28,229,1,0,189,232,1,0,45,233,0,144,21,229,180,31,28,229,0,20,129,225,
  9,152,129,225,6,128,160,227,33,248,255,235,1,0,189,232,0,64,21,229,4,240,157,228,32,155,28,229,180,15,92,229,
  9,152,128,225,6,128,160,227,25,248,255,235,0,0,160,227,4,240,157,228,180,15,28,229,0,0,80,227,142,0,0,218,
  4,224,45,229,0,0,160,227,32,11,12,229,176,111,28,229,89,92,0,235,172,111,12,229,176,95,28,229,6,0,85,225,
  9,0,0,26,156,15,92,229,0,0,80,227,2,0,0,26,3,0,160,227,0,64,160,227,4,240,157,228,1,0,160,227,
  32,11,12,229,0,0,160,227,4,240,157,228,0,16,160,227,4,48,160,227,0,64,160,227,3,0,0,234,172,15,28,229,
  0,0,85,225,49,0,0,42,4,16,21,229,24,0,45,233,0,48,21,229,127,0,3,226,8,0,80,227,10,0,0,42,
  127,0,1,226,8,0,80,227,2,0,0,42,33,4,160,225,35,4,80,225,12,0,0,10,183,0,0,235,10,0,0,10,
  45,1,0,235,24,0,189,232,235,255,255,234,0,48,21,229,142,0,0,235,4,0,0,10,152,0,0,235,2,0,0,10,
  4,80,133,226,24,0,189,232,227,255,255,234,0,48,21,229,228,244,255,235,176,31,28,229,172,47,28,229,54,0,45,233,
  176,47,12,229,117,255,255,235,54,0,189,232,176,31,12,229,172,47,12,229,1,0,45,233,0,48,21,229,74,245,255,235,
  1,0,189,232,24,0,189,232,0,0,80,227,5,0,0,10,3,0,80,225,1,0,0,42,0,48,160,225,0,64,21,229,
  4,80,133,226,204,255,255,234,0,0,160,227,4,240,157,228,3,0,160,225,4,240,157,228,4,224,45,229,0,0,160,227,
  32,11,12,229,176,111,28,229,59,75,0,235,172,111,12,229,176,95,28,229,6,0,85,225,53,0,0,10,172,15,28,229,
  0,0,85,225,45,0,0,42,0,48,21,229,128,244,255,235,176,31,28,229,172,47,28,229,32,59,28,229,62,0,45,233,
  176,47,12,229,44,0,0,235,62,0,189,232,176,31,12,229,172,47,12,229,32,27,28,229,1,48,131,225,32,59,12,229,
  3,0,45,233,0,48,21,229,235,244,255,235,3,0,189,232,0,0,80,227,15,0,0,26,4,0,149,229,128,0,128,227,
  0,16,21,229,1,0,80,225,8,0,0,26,127,0,0,226,0,1,220,231,64,0,80,227,3,0,0,10,84,0,80,227,
  1,0,0,10,88,0,80,227,0,0,0,26,4,80,133,226,4,80,133,226,216,255,255,234,1,0,45,233,0,144,21,229,
  180,31,28,229,0,20,129,225,9,152,129,225,6,128,160,227,143,247,255,235,1,0,189,232,0,64,21,229,4,240,157,228,
  32,155,28,229,180,15,28,229,9,152,128,225,6,128,160,227,135,247,255,235,0,0,160,227,4,240,157,228,4,224,45,229,
  0,0,160,227,32,11,12,229,11,1,0,235,36,0,0,10,76,11,28,229,0,0,80,227,14,0,0,26,156,15,92,229,
  0,0,80,227,6,0,0,26,196,15,28,229,192,31,28,229,1,0,144,225,1,0,160,227,2,0,160,19,0,64,160,227,
  4,240,157,228,1,0,160,227,32,11,12,229,0,0,160,227,0,64,160,227,4,240,157,228,176,111,28,229,203,91,0,235,
  172,111,12,229,176,95,28,229,172,15,28,229,0,0,85,225,236,255,255,42,0,0,85,229,127,0,0,226,8,0,80,227,
  3,0,0,42,44,0,0,235,5,0,0,10,162,0,0,235,244,255,255,234,17,0,0,235,1,0,0,10,4,80,133,226,
  240,255,255,234,0,0,160,227,0,64,160,227,4,240,157,228,127,12,3,226,32,3,220,231,0,0,80,227,3,0,0,26,
  127,0,3,226,7,1,220,231,60,0,80,227,1,0,0,26,0,0,176,227,14,240,160,225,1,0,176,227,14,240,160,225,
  4,224,45,229,0,48,21,229,78,244,255,235,176,31,28,229,172,47,28,229,54,0,45,233,176,47,12,229,180,31,28,229,
  2,16,129,226,180,31,12,229,43,0,0,235,180,31,28,229,2,16,65,226,180,31,12,229,54,0,189,232,176,31,12,229,
  172,47,12,229,1,0,45,233,0,48,21,229,174,244,255,235,1,0,189,232,0,0,160,227,4,240,157,228,4,224,45,229,
  181,15,92,229,0,0,80,227,25,0,0,218,0,48,21,229,255,48,195,227,7,48,131,227,50,244,255,235,176,31,28,229,
  172,47,28,229,54,0,45,233,176,47,12,229,180,31,28,229,2,16,129,226,180,31,12,229,15,0,0,235,180,31,28,229,
  2,16,65,226,180,31,12,229,54,0,189,232,176,31,12,229,172,47,12,229,1,0,45,233,0,48,21,229,255,48,195,227,
  7,48,131,227,144,244,255,235,1,0,189,232,0,0,176,227,4,240,157,228,1,0,176,227,4,240,157,228,4,224,45,229,
  0,0,160,227,32,11,12,229,0,64,21,229,16,0,45,233,176,111,28,229,120,74,0,235,172,111,12,229,16,0,189,232,
  36,68,160,225,176,95,28,229,5,96,160,225,172,15,28,229,0,0,85,225,3,0,0,10,4,48,149,228,35,4,84,225,
  4,48,134,4,248,255,255,234,172,111,12,229,4,1,220,231,32,1,160,225,7,0,0,226,24,11,12,229,176,95,28,229,
  172,15,28,229,0,0,85,225,57,0,0,42,0,48,21,229,191,243,255,235,24,27,28,229,1,160,140,224,196,15,90,229,
  1,0,64,226,196,15,74,229,189,15,92,229,1,0,128,226,189,15,76,229,24,11,28,229,176,31,28,229,172,47,28,229,
  32,59,28,229,63,0,45,233,176,47,12,229,208,254,255,235,63,0,189,232,24,11,12,229,176,31,12,229,172,47,12,229,
  32,27,28,229,1,48,131,225,32,59,12,229,24,27,28,229,1,160,140,224,196,15,90,229,1,0,128,226,196,15,74,229,
  189,15,92,229,1,0,64,226,189,15,76,229,3,0,45,233,0,48,21,229,24,244,255,235,3,0,189,232,0,0,80,227,
  17,0,0,26,0,0,81,227,13,0,0,26,4,0,149,229,128,0,128,227,0,16,21,229,1,0,80,225,8,0,0,26,
  127,112,0,226,7,1,220,231,64,0,80,227,3,0,0,10,84,0,80,227,1,0,0,10,88,0,80,227,0,0,0,26,
  4,80,133,226,4,80,133,226,196,255,255,234,1,0,176,227,4,240,157,228,0,0,176,227,4,240,157,228,0,64,21,229,
  7,64,196,227,4,0,181,229,7,0,192,227,4,0,80,225,251,255,255,10,14,240,160,225,14,240,160,225,14,240,160,225,
  216,38,0,224,17,0,84,227,38,0,0,218,4,224,45,229,164,0,160,225,0,64,68,224,1,0,45,233,248,255,255,235,
  16,0,189,232,32,0,45,233,245,255,255,235,64,0,189,232,188,112,159,229,4,0,149,229,4,16,150,229,1,0,80,225,
  8,0,0,186,8,80,135,229,4,16,150,229,5,112,160,225,8,80,149,229,0,0,85,227,12,0,0,10,4,0,149,229,
  1,0,80,225,248,255,255,170,8,96,135,229,4,16,149,229,6,112,160,225,8,96,150,229,0,0,86,227,6,0,0,10,
  4,0,150,229,1,0,80,225,248,255,255,170,236,255,255,234,8,96,135,229,12,91,28,229,4,240,157,228,8,80,135,229,
  12,91,28,229,4,240,157,228,0,0,160,227,12,11,12,229,4,16,152,229,60,96,159,229,6,112,160,225,8,96,150,229,
  0,0,86,227,2,0,0,10,4,0,150,229,1,0,80,225,248,255,255,202,8,16,160,225,8,128,152,229,8,16,135,229,
  8,96,129,229,1,64,84,226,240,255,255,26,12,91,28,229,14,240,160,225,212,9,0,224,212,9,0,224,4,224,45,229,
  164,95,28,229,0,0,85,227,95,0,0,10,5,112,140,224,34,6,23,229,24,68,87,229,32,8,148,225,90,0,0,10,
  128,0,20,227,6,0,0,26,44,0,215,229,160,0,16,227,3,0,0,26,246,5,23,229,236,19,87,229,32,8,145,225,
  81,0,0,10,64,0,20,227,6,0,0,26,40,0,215,229,160,0,16,227,3,0,0,26,250,5,23,229,240,19,87,229,
  32,8,145,225,72,0,0,10,32,0,20,227,6,0,0,26,36,0,215,229,160,0,16,227,3,0,0,26,254,5,23,229,
  244,19,87,229,32,8,145,225,63,0,0,10,16,0,20,227,6,0,0,26,4,0,215,229,160,0,16,227,3,0,0,26,
  30,6,23,229,20,20,87,229,32,8,145,225,54,0,0,10,8,0,20,227,6,0,0,26,4,0,87,229,160,0,16,227,
  3,0,0,26,38,6,23,229,28,20,87,229,32,8,145,225,45,0,0,10,4,0,20,227,6,0,0,26,36,0,87,229,
  160,0,16,227,3,0,0,26,70,6,23,229,60,20,87,229,32,8,145,225,36,0,0,10,2,0,20,227,6,0,0,26,
  40,0,87,229,160,0,16,227,3,0,0,26,74,6,23,229,64,20,87,229,32,8,145,225,27,0,0,10,1,0,20,227,
  6,0,0,26,44,0,87,229,160,0,16,227,3,0,0,26,78,6,23,229,68,20,87,229,32,8,145,225,18,0,0,10,
  71,246,255,235,80,107,28,229,1,0,118,227,12,0,0,10,6,160,140,224,36,6,26,229,22,20,90,229,32,8,129,225,
  5,160,140,224,34,22,26,229,24,36,90,229,33,24,130,225,1,0,208,225,2,0,0,10,225,247,255,235,4,0,0,235,
  1,0,0,26,1,0,176,227,4,240,157,228,0,0,176,227,4,240,157,228,80,107,28,229,6,160,140,224,36,6,26,229,
  22,20,90,229,32,72,129,225,164,95,28,229,5,160,140,224,34,6,26,229,24,20,90,229,32,8,129,225,0,64,212,225,
  99,0,0,10,1,12,20,227,3,0,0,10,6,0,140,224,187,1,208,229,0,0,80,227,95,0,0,10,2,12,20,227,
  3,0,0,10,6,0,140,224,195,1,208,229,0,0,80,227,89,0,0,10,1,0,20,227,8,0,0,10,6,112,160,225,
  44,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,78,0,0,10,
  2,0,20,227,8,0,0,10,6,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,
  15,2,208,229,0,0,80,227,67,0,0,10,4,0,20,227,8,0,0,10,6,112,160,225,36,112,71,226,7,0,220,231,
  0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,56,0,0,10,8,0,20,227,8,0,0,10,
  6,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,
  45,0,0,10,16,0,20,227,8,0,0,10,6,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,
  7,0,140,224,15,2,208,229,0,0,80,227,34,0,0,10,32,0,20,227,8,0,0,10,6,112,160,225,36,112,135,226,
  7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,23,0,0,10,64,0,20,227,
  8,0,0,10,6,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,7,0,140,224,15,2,208,229,
  0,0,80,227,12,0,0,10,128,0,20,227,8,0,0,10,6,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,
  251,255,255,10,7,0,140,224,15,2,208,229,0,0,80,227,1,0,0,10,0,0,176,227,14,240,160,225,1,0,176,227,
  14,240,160,225,164,95,28,229,5,112,140,224,24,68,87,229,0,48,160,227,128,0,20,227,9,0,0,26,44,0,215,229,
  160,0,16,227,6,0,0,26,246,5,23,229,236,19,87,229,32,8,145,225,2,0,0,26,5,0,143,224,136,1,144,229,
  0,48,131,224,64,0,20,227,9,0,0,26,40,0,215,229,160,0,16,227,6,0,0,26,250,5,23,229,240,19,87,229,
  32,8,145,225,2,0,0,26,5,0,143,224,84,1,144,229,0,48,131,224,32,0,20,227,9,0,0,26,36,0,215,229,
  160,0,16,227,6,0,0,26,254,5,23,229,244,19,87,229,32,8,145,225,2,0,0,26,5,0,143,224,32,1,144,229,
  0,48,131,224,16,0,20,227,9,0,0,26,4,0,215,229,160,0,16,227,6,0,0,26,30,6,23,229,20,20,87,229,
  32,8,145,225,2,0,0,26,5,0,143,224,208,0,144,229,0,48,131,224,8,0,20,227,9,0,0,26,4,0,87,229,
  160,0,16,227,6,0,0,26,38,6,23,229,28,20,87,229,32,8,145,225,2,0,0,26,5,0,143,224,152,0,144,229,
  0,48,131,224,4,0,20,227,9,0,0,26,36,0,87,229,160,0,16,227,6,0,0,26,70,6,23,229,60,20,87,229,
  32,8,145,225,2,0,0,26,5,0,143,224,72,0,144,229,0,48,131,224,2,0,20,227,9,0,0,26,40,0,87,229,
  160,0,16,227,6,0,0,26,74,6,23,229,64,20,87,229,32,8,145,225,2,0,0,26,5,0,143,224,20,0,144,229,
  0,48,131,224,1,0,20,227,9,0,0,26,44,0,87,229,160,0,16,227,6,0,0,26,78,6,23,229,68,20,87,229,
  32,8,145,225,2,0,0,26,5,0,143,224,32,0,16,229,0,48,131,224,1,11,99,226,14,240,160,225,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,
  30,0,0,0,30,0,0,0,24,0,0,0,18,0,0,0,14,0,0,0,0,0,0,0,18,0,0,0,24,0,0,0,
  30,0,0,0,40,0,0,0,40,0,0,0,40,0,0,0,30,0,0,0,24,0,0,0,18,0,0,0,0,0,0,0,
  24,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,52,0,0,0,52,0,0,0,40,0,0,0,30,0,0,0,
  24,0,0,0,0,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,80,0,0,0,80,0,0,0,80,0,0,0,
  52,0,0,0,40,0,0,0,30,0,0,0,0,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,80,0,0,0,
  80,0,0,0,80,0,0,0,52,0,0,0,40,0,0,0,30,0,0,0,0,0,0,0,30,0,0,0,40,0,0,0,
  52,0,0,0,80,0,0,0,80,0,0,0,80,0,0,0,52,0,0,0,40,0,0,0,30,0,0,0,0,0,0,0,
  24,0,0,0,30,0,0,0,40,0,0,0,52,0,0,0,52,0,0,0,52,0,0,0,40,0,0,0,30,0,0,0,
  24,0,0,0,0,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,40,0,0,0,40,0,0,0,40,0,0,0,
  30,0,0,0,24,0,0,0,18,0,0,0,0,0,0,0,14,0,0,0,18,0,0,0,24,0,0,0,30,0,0,0,
  30,0,0,0,30,0,0,0,24,0,0,0,18,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,4,224,45,229,252,106,12,229,0,123,12,229,0,0,160,227,8,11,12,229,4,11,12,229,226,2,0,235,
  5,112,160,225,157,19,0,235,236,10,28,229,0,0,80,227,26,0,0,10,153,8,92,229,128,24,28,229,1,0,128,224,
  0,27,28,229,0,0,81,225,20,0,0,42,236,122,28,229,7,128,140,224,36,6,216,229,37,22,216,229,1,0,64,224,
  228,26,28,229,1,0,80,225,33,0,0,202,36,22,24,229,24,4,24,229,0,16,129,225,33,40,160,225,2,24,33,224,
  1,16,139,224,0,16,209,229,2,32,139,224,0,32,210,229,2,16,65,224,232,10,28,229,0,0,81,225,20,0,0,202,
  5,96,140,224,0,16,86,229,64,0,81,227,6,0,0,10,66,0,81,227,4,0,0,10,153,8,92,229,4,0,128,226,
  0,43,28,229,0,0,82,225,11,0,0,42,30,16,1,226,13,2,214,229,0,16,129,225,129,0,143,224,48,240,144,229,
  8,11,28,229,128,0,160,225,4,27,28,229,1,0,128,224,2,0,0,234,4,0,160,227,0,0,0,234,0,0,160,227,
  1,0,45,233,192,2,0,235,1,0,189,232,4,240,157,228,20,85,0,0,236,85,0,0,44,85,0,0,236,85,0,0,
  88,85,0,0,236,85,0,0,132,85,0,0,236,85,0,0,236,85,0,0,0,0,0,0,104,86,0,0,12,87,0,0,
  0,88,0,0,164,88,0,0,152,89,0,0,0,0,0,0,40,85,0,0,72,91,0,0,40,85,0,0,72,91,0,0,
  40,85,0,0,72,91,0,0,28,91,0,0,72,91,0,0,72,91,0,0,0,0,0,0,164,91,0,0,248,91,0,0,
  40,85,0,0,160,92,0,0,40,85,0,0,0,0,0,0,20,85,0,0,96,91,0,0,44,85,0,0,96,91,0,0,
  40,85,0,0,96,91,0,0,20,85,0,0,96,91,0,0,96,91,0,0,0,0,0,0,40,85,0,0,96,91,0,0,
  76,92,0,0,204,92,0,0,40,85,0,0,0,0,0,0,40,85,0,0,140,91,0,0,40,85,0,0,140,91,0,0,
  40,85,0,0,140,91,0,0,192,85,0,0,140,91,0,0,140,91,0,0,0,0,0,0,184,86,0,0,172,87,0,0,
  40,85,0,0,32,93,0,0,40,85,0,0,0,0,0,0,40,85,0,0,60,86,0,0,40,85,0,0,60,86,0,0,
  40,85,0,0,60,86,0,0,40,85,0,0,60,86,0,0,60,86,0,0,0,0,0,0,40,85,0,0,60,86,0,0,
  80,88,0,0,68,89,0,0,40,85,0,0,0,0,0,0,0,144,86,229,30,144,9,226,2,144,137,227,137,144,139,224,
  180,145,25,229,7,144,137,224,84,144,73,226,0,48,25,229,0,144,86,229,30,144,9,226,137,144,139,224,180,145,25,229,
  5,144,137,224,84,144,73,226,0,0,25,229,0,48,83,224,0,48,160,51,163,50,160,225,0,0,0,234,0,48,160,227,
  4,224,45,229,32,0,45,233,252,90,28,229,143,18,0,235,32,0,189,232,2,16,216,229,3,0,145,224,37,0,0,10,
  155,72,92,229,4,16,129,224,0,11,28,229,0,0,81,225,32,0,0,218,0,0,86,229,64,0,80,227,2,0,0,10,
  0,0,88,229,0,0,80,227,24,0,0,10,8,11,28,229,1,0,128,226,8,11,12,229,0,0,88,229,60,0,80,227,
  14,0,0,10,9,2,88,229,0,0,80,227,4,0,0,26,0,0,83,227,15,0,0,10,0,11,28,229,0,0,84,225,
  12,0,0,218,2,16,216,229,0,11,28,229,0,0,81,225,2,0,0,202,60,10,216,229,0,0,80,227,5,0,0,26,
  8,11,28,229,1,0,128,226,8,11,12,229,4,240,157,228,1,0,160,227,4,11,12,229,4,240,157,228,204,0,87,227,
  205,255,255,42,185,255,255,234,204,0,85,227,202,255,255,42,182,255,255,234,40,112,69,226,7,128,140,224,0,0,88,229,
  192,0,16,227,244,255,255,11,84,255,255,234,5,112,160,225,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,236,255,255,235,248,255,255,234,32,0,16,227,233,255,255,27,73,255,255,234,84,112,69,226,7,128,140,224,
  0,0,88,229,192,0,16,227,227,255,255,11,76,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,222,255,255,11,
  62,255,255,234,44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,216,255,255,11,44,112,133,226,7,128,140,224,
  0,0,88,229,192,0,16,227,214,255,255,11,40,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,206,255,255,11,
  36,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,201,255,255,11,36,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,199,255,255,11,36,255,255,234,44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,142,255,255,11,
  40,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,137,255,255,11,40,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,132,255,255,11,36,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,127,255,255,11,4,112,69,226,
  7,128,140,224,0,0,88,229,192,0,16,227,122,255,255,11,4,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,
  117,255,255,11,5,255,255,234,5,112,160,225,44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,
  157,255,255,235,248,255,255,234,32,0,16,227,154,255,255,27,5,112,160,225,44,112,135,226,7,128,140,224,0,0,88,229,
  0,0,80,227,1,0,0,26,150,255,255,235,248,255,255,234,32,0,16,227,147,255,255,27,5,112,160,225,36,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,137,255,255,235,248,255,255,234,32,0,16,227,134,255,255,27,
  5,112,160,225,36,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,130,255,255,235,248,255,255,234,
  32,0,16,227,127,255,255,27,220,254,255,234,40,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,70,255,255,11,
  4,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,65,255,255,11,4,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,60,255,255,11,40,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,55,255,255,11,5,112,160,225,
  44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,48,255,255,235,248,255,255,234,32,0,16,227,
  45,255,255,27,5,112,160,225,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,38,255,255,235,
  248,255,255,234,32,0,16,227,35,255,255,27,5,112,160,225,36,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,28,255,255,235,248,255,255,234,32,0,16,227,25,255,255,27,5,112,160,225,36,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,1,0,0,26,18,255,255,235,248,255,255,234,32,0,16,227,15,255,255,27,159,254,255,234,
  5,112,160,225,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,55,255,255,235,248,255,255,234,
  32,0,16,227,52,255,255,27,5,112,160,225,40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,
  48,255,255,235,248,255,255,234,32,0,16,227,45,255,255,27,5,112,160,225,4,112,71,226,7,128,140,224,0,0,88,229,
  0,0,80,227,1,0,0,26,35,255,255,235,248,255,255,234,32,0,16,227,32,255,255,27,5,112,160,225,4,112,135,226,
  7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,28,255,255,235,248,255,255,234,32,0,16,227,25,255,255,27,
  118,254,255,234,44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,224,254,255,11,36,112,69,226,7,128,140,224,
  0,0,88,229,192,0,16,227,219,254,255,11,36,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,214,254,255,11,
  44,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,209,254,255,11,5,112,160,225,40,112,71,226,7,128,140,224,
  0,0,88,229,0,0,80,227,1,0,0,26,202,254,255,235,248,255,255,234,32,0,16,227,199,254,255,27,5,112,160,225,
  40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,192,254,255,235,248,255,255,234,32,0,16,227,
  189,254,255,27,5,112,160,225,4,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,182,254,255,235,
  248,255,255,234,32,0,16,227,179,254,255,27,5,112,160,225,4,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,172,254,255,235,248,255,255,234,32,0,16,227,169,254,255,27,57,254,255,234,22,4,86,229,128,0,16,227,
  8,0,0,26,44,112,69,226,7,128,140,224,0,16,88,229,192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,
  32,24,145,225,156,254,255,11,22,4,86,229,64,0,16,227,8,0,0,26,40,112,69,226,7,128,140,224,0,16,88,229,
  192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,32,24,145,225,144,254,255,11,22,4,86,229,32,0,16,227,
  8,0,0,26,36,112,69,226,7,128,140,224,0,16,88,229,192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,
  32,24,145,225,132,254,255,11,22,4,86,229,16,0,16,227,8,0,0,26,4,112,69,226,7,128,140,224,0,16,88,229,
  192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,32,24,145,225,120,254,255,11,22,4,86,229,8,0,16,227,
  8,0,0,26,4,112,133,226,7,128,140,224,0,16,88,229,192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,
  32,24,145,225,108,254,255,11,22,4,86,229,4,0,16,227,8,0,0,26,36,112,133,226,7,128,140,224,0,16,88,229,
  192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,32,24,145,225,96,254,255,11,22,4,86,229,2,0,16,227,
  8,0,0,26,40,112,133,226,7,128,140,224,0,16,88,229,192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,
  32,24,145,225,84,254,255,11,22,4,86,229,1,0,16,227,8,0,0,26,44,112,133,226,7,128,140,224,0,16,88,229,
  192,16,1,226,22,4,88,229,0,16,129,225,36,6,88,229,32,24,145,225,72,254,255,11,216,253,255,234,44,112,69,226,
  7,128,140,224,0,0,88,229,192,0,16,227,114,254,255,11,44,112,133,226,7,128,140,224,0,0,88,229,192,0,16,227,
  112,254,255,11,205,253,255,234,44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,55,254,255,11,199,253,255,234,
  40,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,49,254,255,11,40,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,44,254,255,11,188,253,255,234,36,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,38,254,255,11,
  182,253,255,234,5,112,160,225,44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,78,254,255,235,
  248,255,255,234,32,0,16,227,75,254,255,27,5,112,160,225,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,71,254,255,235,248,255,255,234,32,0,16,227,68,254,255,27,161,253,255,234,5,112,160,225,44,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,9,254,255,235,248,255,255,234,32,0,16,227,6,254,255,27,
  5,112,160,225,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,1,0,0,26,255,253,255,235,248,255,255,234,
  32,0,16,227,252,253,255,27,140,253,255,234,5,112,160,225,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,36,254,255,235,248,255,255,234,32,0,16,227,33,254,255,27,5,112,160,225,40,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,1,0,0,26,29,254,255,235,248,255,255,234,32,0,16,227,26,254,255,27,119,253,255,234,
  44,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,225,253,255,11,44,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,220,253,255,11,108,253,255,234,5,112,160,225,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  1,0,0,26,212,253,255,235,248,255,255,234,32,0,16,227,209,253,255,27,5,112,160,225,40,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,1,0,0,26,202,253,255,235,248,255,255,234,32,0,16,227,199,253,255,27,87,253,255,234,
  36,112,69,226,7,128,140,224,0,0,88,229,192,0,16,227,193,253,255,11,36,112,133,226,7,128,140,224,0,0,88,229,
  192,0,16,227,188,253,255,11,76,253,255,234,5,96,140,224,0,0,86,229,0,0,80,227,18,0,0,10,32,0,16,227,
  8,0,0,26,30,0,0,226,13,18,214,229,1,0,128,225,128,0,143,224,148,240,144,229,36,6,214,229,2,0,128,226,
  36,6,198,229,14,240,160,225,30,0,0,226,15,18,214,229,1,0,128,225,128,0,143,224,176,241,144,229,37,6,214,229,
  2,0,128,226,37,6,198,229,14,240,160,225,5,96,140,224,0,0,86,229,0,0,80,227,18,0,0,10,32,0,16,227,
  8,0,0,26,30,0,0,226,13,18,214,229,1,0,128,225,128,0,143,224,180,242,144,229,36,6,214,229,2,0,64,226,
  36,6,198,229,14,240,160,225,30,0,0,226,15,18,214,229,1,0,128,225,128,0,143,224,208,243,144,229,37,6,214,229,
  2,0,64,226,37,6,198,229,14,240,160,225,12,99,0,0,204,99,0,0,28,99,0,0,204,99,0,0,112,99,0,0,
  204,99,0,0,140,99,0,0,204,99,0,0,204,99,0,0,0,0,0,0,72,100,0,0,24,100,0,0,188,101,0,0,
  140,101,0,0,160,104,0,0,0,0,0,0,24,99,0,0,28,103,0,0,24,99,0,0,28,103,0,0,24,99,0,0,
  28,103,0,0,0,103,0,0,28,103,0,0,28,103,0,0,0,0,0,0,88,103,0,0,88,103,0,0,24,99,0,0,
  0,103,0,0,24,99,0,0,0,0,0,0,12,99,0,0,44,103,0,0,28,99,0,0,44,103,0,0,24,99,0,0,
  44,103,0,0,12,99,0,0,44,103,0,0,44,103,0,0,0,0,0,0,24,99,0,0,44,103,0,0,252,103,0,0,
  252,103,0,0,24,99,0,0,0,0,0,0,24,99,0,0,72,103,0,0,24,99,0,0,72,103,0,0,24,99,0,0,
  72,103,0,0,176,99,0,0,72,103,0,0,72,103,0,0,0,0,0,0,232,100,0,0,232,100,0,0,24,99,0,0,
  176,99,0,0,24,99,0,0,0,0,0,0,24,99,0,0,252,99,0,0,24,99,0,0,252,99,0,0,24,99,0,0,
  252,99,0,0,24,99,0,0,252,99,0,0,252,99,0,0,0,0,0,0,24,99,0,0,252,99,0,0,92,102,0,0,
  92,102,0,0,24,99,0,0,0,0,0,0,4,105,0,0,196,105,0,0,20,105,0,0,196,105,0,0,104,105,0,0,
  196,105,0,0,132,105,0,0,196,105,0,0,196,105,0,0,0,0,0,0,64,106,0,0,16,106,0,0,180,107,0,0,
  132,107,0,0,152,110,0,0,0,0,0,0,16,105,0,0,20,109,0,0,16,105,0,0,20,109,0,0,16,105,0,0,
  20,109,0,0,248,108,0,0,20,109,0,0,20,109,0,0,0,0,0,0,80,109,0,0,80,109,0,0,16,105,0,0,
  248,108,0,0,16,105,0,0,0,0,0,0,4,105,0,0,36,109,0,0,20,105,0,0,36,109,0,0,16,105,0,0,
  36,109,0,0,4,105,0,0,36,109,0,0,36,109,0,0,0,0,0,0,16,105,0,0,36,109,0,0,244,109,0,0,
  244,109,0,0,16,105,0,0,0,0,0,0,16,105,0,0,64,109,0,0,16,105,0,0,64,109,0,0,16,105,0,0,
  64,109,0,0,168,105,0,0,64,109,0,0,64,109,0,0,0,0,0,0,224,106,0,0,224,106,0,0,16,105,0,0,
  168,105,0,0,16,105,0,0,0,0,0,0,16,105,0,0,244,105,0,0,16,105,0,0,244,105,0,0,16,105,0,0,
  244,105,0,0,16,105,0,0,244,105,0,0,244,105,0,0,0,0,0,0,16,105,0,0,244,105,0,0,84,108,0,0,
  84,108,0,0,16,105,0,0,0,0,0,0,252,110,0,0,188,111,0,0,12,111,0,0,188,111,0,0,96,111,0,0,
  188,111,0,0,124,111,0,0,188,111,0,0,188,111,0,0,0,0,0,0,56,112,0,0,8,112,0,0,172,113,0,0,
  124,113,0,0,144,116,0,0,0,0,0,0,8,111,0,0,12,115,0,0,8,111,0,0,12,115,0,0,8,111,0,0,
  12,115,0,0,240,114,0,0,12,115,0,0,12,115,0,0,0,0,0,0,72,115,0,0,72,115,0,0,8,111,0,0,
  240,114,0,0,8,111,0,0,0,0,0,0,252,110,0,0,28,115,0,0,12,111,0,0,28,115,0,0,8,111,0,0,
  28,115,0,0,252,110,0,0,28,115,0,0,28,115,0,0,0,0,0,0,8,111,0,0,28,115,0,0,236,115,0,0,
  236,115,0,0,8,111,0,0,0,0,0,0,8,111,0,0,56,115,0,0,8,111,0,0,56,115,0,0,8,111,0,0,
  56,115,0,0,160,111,0,0,56,115,0,0,56,115,0,0,0,0,0,0,216,112,0,0,216,112,0,0,8,111,0,0,
  160,111,0,0,8,111,0,0,0,0,0,0,8,111,0,0,236,111,0,0,8,111,0,0,236,111,0,0,8,111,0,0,
  236,111,0,0,8,111,0,0,236,111,0,0,236,111,0,0,0,0,0,0,8,111,0,0,236,111,0,0,76,114,0,0,
  76,114,0,0,8,111,0,0,0,0,0,0,244,116,0,0,180,117,0,0,4,117,0,0,180,117,0,0,88,117,0,0,
  180,117,0,0,116,117,0,0,180,117,0,0,180,117,0,0,0,0,0,0,48,118,0,0,0,118,0,0,164,119,0,0,
  116,119,0,0,136,122,0,0,0,0,0,0,0,117,0,0,4,121,0,0,0,117,0,0,4,121,0,0,0,117,0,0,
  4,121,0,0,232,120,0,0,4,121,0,0,4,121,0,0,0,0,0,0,64,121,0,0,64,121,0,0,0,117,0,0,
  232,120,0,0,0,117,0,0,0,0,0,0,244,116,0,0,20,121,0,0,4,117,0,0,20,121,0,0,0,117,0,0,
  20,121,0,0,244,116,0,0,20,121,0,0,20,121,0,0,0,0,0,0,0,117,0,0,20,121,0,0,228,121,0,0,
  228,121,0,0,0,117,0,0,0,0,0,0,0,117,0,0,48,121,0,0,0,117,0,0,48,121,0,0,0,117,0,0,
  48,121,0,0,152,117,0,0,48,121,0,0,48,121,0,0,0,0,0,0,208,118,0,0,208,118,0,0,0,117,0,0,
  152,117,0,0,0,117,0,0,0,0,0,0,0,117,0,0,228,117,0,0,0,117,0,0,228,117,0,0,0,117,0,0,
  228,117,0,0,0,117,0,0,228,117,0,0,228,117,0,0,0,0,0,0,0,117,0,0,228,117,0,0,68,120,0,0,
  68,120,0,0,0,117,0,0,0,0,0,0,252,5,214,229,3,0,128,226,252,5,198,229,150,254,255,234,5,112,160,225,
  40,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  252,5,216,229,3,0,128,226,252,5,200,229,129,254,255,234,208,5,214,229,3,0,128,226,208,5,198,229,216,5,214,229,
  3,0,128,226,216,5,198,229,122,254,255,234,248,5,214,229,3,0,128,226,248,5,198,229,80,6,214,229,3,0,128,226,
  80,6,198,229,252,5,214,229,3,0,128,226,252,5,198,229,0,6,214,229,3,0,128,226,0,6,198,229,72,6,214,229,
  3,0,128,226,72,6,198,229,106,254,255,234,248,5,214,229,3,0,128,226,248,5,198,229,252,5,214,229,3,0,128,226,
  252,5,198,229,76,6,214,229,3,0,128,226,76,6,198,229,0,6,214,229,3,0,128,226,0,6,198,229,32,6,214,229,
  3,0,128,226,32,6,198,229,40,6,214,229,3,0,128,226,40,6,198,229,87,254,255,234,252,5,214,229,3,0,128,226,
  252,5,198,229,76,6,214,229,3,0,128,226,76,6,198,229,32,6,214,229,3,0,128,226,32,6,198,229,40,6,214,229,
  3,0,128,226,40,6,198,229,5,112,160,225,44,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,248,5,216,229,3,0,128,226,248,5,200,229,5,112,160,225,44,112,135,226,
  7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,80,6,216,229,
  3,0,128,226,80,6,200,229,5,112,160,225,36,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,0,6,216,229,3,0,128,226,0,6,200,229,5,112,160,225,36,112,135,226,
  7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,72,6,216,229,
  3,0,128,226,72,6,200,229,250,253,255,234,248,5,214,229,3,0,128,226,248,5,198,229,80,6,214,229,3,0,128,226,
  80,6,198,229,0,6,214,229,3,0,128,226,0,6,198,229,72,6,214,229,3,0,128,226,72,6,198,229,5,112,160,225,
  40,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  252,5,216,229,3,0,128,226,252,5,200,229,5,112,160,225,40,112,135,226,7,128,140,224,36,6,216,229,3,0,128,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,76,6,216,229,3,0,128,226,76,6,200,229,5,112,160,225,
  4,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  32,6,216,229,3,0,128,226,32,6,200,229,5,112,160,225,4,112,135,226,7,128,140,224,36,6,216,229,3,0,128,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,40,6,216,229,3,0,128,226,40,6,200,229,157,253,255,234,
  248,5,214,229,3,0,128,226,248,5,198,229,80,6,214,229,3,0,128,226,80,6,198,229,150,253,255,234,248,5,214,229,
  3,0,128,226,248,5,198,229,146,253,255,234,252,5,214,229,3,0,128,226,252,5,198,229,76,6,214,229,3,0,128,226,
  76,6,198,229,139,253,255,234,0,6,214,229,3,0,128,226,0,6,198,229,135,253,255,234,5,112,160,225,44,112,71,226,
  7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,248,5,216,229,
  3,0,128,226,248,5,200,229,5,112,160,225,44,112,135,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,80,6,216,229,3,0,128,226,80,6,200,229,94,253,255,234,5,112,160,225,
  40,112,71,226,7,128,140,224,36,6,216,229,3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  252,5,216,229,3,0,128,226,252,5,200,229,5,112,160,225,40,112,135,226,7,128,140,224,36,6,216,229,3,0,128,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,76,6,216,229,3,0,128,226,76,6,200,229,53,253,255,234,
  248,5,214,229,3,0,128,226,248,5,198,229,252,5,214,229,3,0,128,226,252,5,198,229,0,6,214,229,3,0,128,226,
  0,6,198,229,32,6,214,229,3,0,128,226,32,6,198,229,40,6,214,229,3,0,128,226,40,6,198,229,72,6,214,229,
  3,0,128,226,72,6,198,229,76,6,214,229,3,0,128,226,76,6,198,229,80,6,214,229,3,0,128,226,80,6,198,229,
  28,253,255,234,77,6,214,229,3,0,128,226,77,6,198,229,33,253,255,234,5,112,160,225,40,112,135,226,7,128,140,224,
  37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,77,6,216,229,3,0,128,226,
  77,6,200,229,12,253,255,234,121,6,214,229,3,0,128,226,121,6,198,229,113,6,214,229,3,0,128,226,113,6,198,229,
  5,253,255,234,81,6,214,229,3,0,128,226,81,6,198,229,249,5,214,229,3,0,128,226,249,5,198,229,77,6,214,229,
  3,0,128,226,77,6,198,229,73,6,214,229,3,0,128,226,73,6,198,229,1,6,214,229,3,0,128,226,1,6,198,229,
  245,252,255,234,81,6,214,229,3,0,128,226,81,6,198,229,77,6,214,229,3,0,128,226,77,6,198,229,253,5,214,229,
  3,0,128,226,253,5,198,229,73,6,214,229,3,0,128,226,73,6,198,229,41,6,214,229,3,0,128,226,41,6,198,229,
  33,6,214,229,3,0,128,226,33,6,198,229,226,252,255,234,77,6,214,229,3,0,128,226,77,6,198,229,253,5,214,229,
  3,0,128,226,253,5,198,229,41,6,214,229,3,0,128,226,41,6,198,229,33,6,214,229,3,0,128,226,33,6,198,229,
  5,112,160,225,44,112,135,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,81,6,216,229,3,0,128,226,81,6,200,229,5,112,160,225,44,112,71,226,7,128,140,224,37,6,216,229,
  3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,249,5,216,229,3,0,128,226,249,5,200,229,
  5,112,160,225,36,112,135,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,73,6,216,229,3,0,128,226,73,6,200,229,5,112,160,225,36,112,71,226,7,128,140,224,37,6,216,229,
  3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,1,6,216,229,3,0,128,226,1,6,200,229,
  133,252,255,234,81,6,214,229,3,0,128,226,81,6,198,229,249,5,214,229,3,0,128,226,249,5,198,229,73,6,214,229,
  3,0,128,226,73,6,198,229,1,6,214,229,3,0,128,226,1,6,198,229,5,112,160,225,40,112,135,226,7,128,140,224,
  37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,77,6,216,229,3,0,128,226,
  77,6,200,229,5,112,160,225,40,112,71,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,253,5,216,229,3,0,128,226,253,5,200,229,5,112,160,225,4,112,135,226,7,128,140,224,
  37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,41,6,216,229,3,0,128,226,
  41,6,200,229,5,112,160,225,4,112,71,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,33,6,216,229,3,0,128,226,33,6,200,229,40,252,255,234,81,6,214,229,3,0,128,226,
  81,6,198,229,249,5,214,229,3,0,128,226,249,5,198,229,33,252,255,234,81,6,214,229,3,0,128,226,81,6,198,229,
  29,252,255,234,77,6,214,229,3,0,128,226,77,6,198,229,253,5,214,229,3,0,128,226,253,5,198,229,22,252,255,234,
  73,6,214,229,3,0,128,226,73,6,198,229,18,252,255,234,5,112,160,225,44,112,135,226,7,128,140,224,37,6,216,229,
  3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,81,6,216,229,3,0,128,226,81,6,200,229,
  5,112,160,225,44,112,71,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,249,5,216,229,3,0,128,226,249,5,200,229,233,251,255,234,5,112,160,225,40,112,135,226,7,128,140,224,
  37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,77,6,216,229,3,0,128,226,
  77,6,200,229,5,112,160,225,40,112,71,226,7,128,140,224,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,253,5,216,229,3,0,128,226,253,5,200,229,192,251,255,234,81,6,214,229,3,0,128,226,
  81,6,198,229,77,6,214,229,3,0,128,226,77,6,198,229,73,6,214,229,3,0,128,226,73,6,198,229,41,6,214,229,
  3,0,128,226,41,6,198,229,33,6,214,229,3,0,128,226,33,6,198,229,1,6,214,229,3,0,128,226,1,6,198,229,
  253,5,214,229,3,0,128,226,253,5,198,229,249,5,214,229,3,0,128,226,249,5,198,229,167,251,255,234,252,5,214,229,
  3,0,64,226,252,5,198,229,178,251,255,234,5,112,160,225,40,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,252,5,216,229,3,0,64,226,252,5,200,229,157,251,255,234,
  208,5,214,229,3,0,64,226,208,5,198,229,216,5,214,229,3,0,64,226,216,5,198,229,150,251,255,234,248,5,214,229,
  3,0,64,226,248,5,198,229,80,6,214,229,3,0,64,226,80,6,198,229,252,5,214,229,3,0,64,226,252,5,198,229,
  0,6,214,229,3,0,64,226,0,6,198,229,72,6,214,229,3,0,64,226,72,6,198,229,134,251,255,234,248,5,214,229,
  3,0,64,226,248,5,198,229,252,5,214,229,3,0,64,226,252,5,198,229,76,6,214,229,3,0,64,226,76,6,198,229,
  0,6,214,229,3,0,64,226,0,6,198,229,32,6,214,229,3,0,64,226,32,6,198,229,40,6,214,229,3,0,64,226,
  40,6,198,229,115,251,255,234,252,5,214,229,3,0,64,226,252,5,198,229,76,6,214,229,3,0,64,226,76,6,198,229,
  32,6,214,229,3,0,64,226,32,6,198,229,40,6,214,229,3,0,64,226,40,6,198,229,5,112,160,225,44,112,71,226,
  7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,248,5,216,229,
  3,0,64,226,248,5,200,229,5,112,160,225,44,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,80,6,216,229,3,0,64,226,80,6,200,229,5,112,160,225,36,112,71,226,
  7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,0,6,216,229,
  3,0,64,226,0,6,200,229,5,112,160,225,36,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,72,6,216,229,3,0,64,226,72,6,200,229,22,251,255,234,248,5,214,229,
  3,0,64,226,248,5,198,229,80,6,214,229,3,0,64,226,80,6,198,229,0,6,214,229,3,0,64,226,0,6,198,229,
  72,6,214,229,3,0,64,226,72,6,198,229,5,112,160,225,40,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,252,5,216,229,3,0,64,226,252,5,200,229,5,112,160,225,
  40,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  76,6,216,229,3,0,64,226,76,6,200,229,5,112,160,225,4,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,32,6,216,229,3,0,64,226,32,6,200,229,5,112,160,225,
  4,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  40,6,216,229,3,0,64,226,40,6,200,229,185,250,255,234,248,5,214,229,3,0,64,226,248,5,198,229,80,6,214,229,
  3,0,64,226,80,6,198,229,178,250,255,234,248,5,214,229,3,0,64,226,248,5,198,229,174,250,255,234,252,5,214,229,
  3,0,64,226,252,5,198,229,76,6,214,229,3,0,64,226,76,6,198,229,167,250,255,234,0,6,214,229,3,0,64,226,
  0,6,198,229,163,250,255,234,5,112,160,225,44,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,
  0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,
  1,0,80,227,3,0,0,186,239,255,255,26,248,5,216,229,3,0,64,226,248,5,200,229,5,112,160,225,44,112,135,226,
  7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,
  8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,80,6,216,229,
  3,0,64,226,80,6,200,229,122,250,255,234,5,112,160,225,40,112,71,226,7,128,140,224,36,6,216,229,3,0,64,226,
  36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,
  52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,252,5,216,229,3,0,64,226,252,5,200,229,5,112,160,225,
  40,112,135,226,7,128,140,224,36,6,216,229,3,0,64,226,36,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,
  128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,
  76,6,216,229,3,0,64,226,76,6,200,229,81,250,255,234,248,5,214,229,3,0,64,226,248,5,198,229,252,5,214,229,
  3,0,64,226,252,5,198,229,0,6,214,229,3,0,64,226,0,6,198,229,32,6,214,229,3,0,64,226,32,6,198,229,
  40,6,214,229,3,0,64,226,40,6,198,229,72,6,214,229,3,0,64,226,72,6,198,229,76,6,214,229,3,0,64,226,
  76,6,198,229,80,6,214,229,3,0,64,226,80,6,198,229,56,250,255,234,77,6,214,229,3,0,64,226,77,6,198,229,
  61,250,255,234,5,112,160,225,40,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,77,6,216,229,3,0,64,226,77,6,200,229,40,250,255,234,121,6,214,229,3,0,64,226,
  121,6,198,229,113,6,214,229,3,0,64,226,113,6,198,229,33,250,255,234,81,6,214,229,3,0,64,226,81,6,198,229,
  249,5,214,229,3,0,64,226,249,5,198,229,77,6,214,229,3,0,64,226,77,6,198,229,73,6,214,229,3,0,64,226,
  73,6,198,229,1,6,214,229,3,0,64,226,1,6,198,229,17,250,255,234,81,6,214,229,3,0,64,226,81,6,198,229,
  77,6,214,229,3,0,64,226,77,6,198,229,253,5,214,229,3,0,64,226,253,5,198,229,73,6,214,229,3,0,64,226,
  73,6,198,229,41,6,214,229,3,0,64,226,41,6,198,229,33,6,214,229,3,0,64,226,33,6,198,229,254,249,255,234,
  77,6,214,229,3,0,64,226,77,6,198,229,253,5,214,229,3,0,64,226,253,5,198,229,41,6,214,229,3,0,64,226,
  41,6,198,229,33,6,214,229,3,0,64,226,33,6,198,229,5,112,160,225,44,112,135,226,7,128,140,224,37,6,216,229,
  3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,81,6,216,229,3,0,64,226,81,6,200,229,
  5,112,160,225,44,112,71,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,249,5,216,229,3,0,64,226,249,5,200,229,5,112,160,225,36,112,135,226,7,128,140,224,37,6,216,229,
  3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,239,255,255,26,73,6,216,229,3,0,64,226,73,6,200,229,
  5,112,160,225,36,112,71,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,1,6,216,229,3,0,64,226,1,6,200,229,161,249,255,234,81,6,214,229,3,0,64,226,81,6,198,229,
  249,5,214,229,3,0,64,226,249,5,198,229,73,6,214,229,3,0,64,226,73,6,198,229,1,6,214,229,3,0,64,226,
  1,6,198,229,5,112,160,225,40,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,77,6,216,229,3,0,64,226,77,6,200,229,5,112,160,225,40,112,71,226,7,128,140,224,
  37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,253,5,216,229,3,0,64,226,
  253,5,200,229,5,112,160,225,4,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,41,6,216,229,3,0,64,226,41,6,200,229,5,112,160,225,4,112,71,226,7,128,140,224,
  37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,33,6,216,229,3,0,64,226,
  33,6,200,229,68,249,255,234,81,6,214,229,3,0,64,226,81,6,198,229,249,5,214,229,3,0,64,226,249,5,198,229,
  61,249,255,234,81,6,214,229,3,0,64,226,81,6,198,229,57,249,255,234,77,6,214,229,3,0,64,226,77,6,198,229,
  253,5,214,229,3,0,64,226,253,5,198,229,50,249,255,234,73,6,214,229,3,0,64,226,73,6,198,229,46,249,255,234,
  5,112,160,225,44,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,
  247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,180,3,16,229,1,0,80,227,3,0,0,186,
  239,255,255,26,81,6,216,229,3,0,64,226,81,6,200,229,5,112,160,225,44,112,71,226,7,128,140,224,37,6,216,229,
  3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,
  129,0,139,224,180,4,16,229,1,0,80,227,3,0,0,186,239,255,255,26,249,5,216,229,3,0,64,226,249,5,200,229,
  5,249,255,234,5,112,160,225,40,112,135,226,7,128,140,224,37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,
  0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,62,16,1,226,129,0,139,224,52,3,16,229,1,0,80,227,
  3,0,0,186,239,255,255,26,77,6,216,229,3,0,64,226,77,6,200,229,5,112,160,225,40,112,71,226,7,128,140,224,
  37,6,216,229,3,0,64,226,37,6,200,229,0,16,88,229,0,0,81,227,247,255,255,10,128,0,17,227,8,0,0,26,
  62,16,1,226,129,0,139,224,52,5,16,229,1,0,80,227,3,0,0,186,239,255,255,26,253,5,216,229,3,0,64,226,
  253,5,200,229,220,248,255,234,81,6,214,229,3,0,64,226,81,6,198,229,77,6,214,229,3,0,64,226,77,6,198,229,
  73,6,214,229,3,0,64,226,73,6,198,229,41,6,214,229,3,0,64,226,41,6,198,229,33,6,214,229,3,0,64,226,
  33,6,198,229,1,6,214,229,3,0,64,226,1,6,198,229,253,5,214,229,3,0,64,226,253,5,198,229,249,5,214,229,
  3,0,64,226,249,5,198,229,195,248,255,234,0,0,160,227,108,6,12,229,104,6,12,229,64,11,12,229,236,10,12,229,
  4,224,45,229,0,0,160,227,240,10,12,229,248,10,28,229,1,0,128,226,248,10,12,229,0,0,160,227,224,10,12,229,
  220,10,12,229,216,10,12,229,212,10,12,229,208,10,12,229,204,10,12,229,200,10,12,229,196,10,12,229,192,10,12,229,
  188,10,12,229,184,10,12,229,91,0,0,235,25,235,255,235,19,236,255,235,77,234,255,235,241,28,0,235,233,1,0,235,
  119,5,0,235,132,33,0,235,230,1,0,235,162,7,0,235,86,9,0,235,104,9,0,235,30,16,0,235,200,29,0,235,
  147,41,0,235,137,48,0,235,139,55,0,235,6,30,0,235,164,32,0,235,47,0,0,235,1,0,0,235,180,10,28,229,
  4,240,157,228,8,81,159,229,8,97,159,229,0,0,160,227,10,144,160,227,4,16,149,228,4,32,150,228,145,2,3,224,
  3,0,128,224,1,144,89,226,249,255,255,26,64,50,160,225,16,48,131,226,180,58,12,229,4,16,149,228,4,32,150,228,
  145,2,3,224,3,0,128,224,64,50,160,225,16,48,131,226,176,58,12,229,14,240,160,225,4,224,45,229,0,0,160,227,
  108,6,12,229,104,6,12,229,64,11,12,229,236,10,12,229,1,0,160,227,240,10,12,229,39,0,0,235,229,234,255,235,
  223,235,255,235,190,28,0,235,182,1,0,235,68,5,0,235,81,33,0,235,179,1,0,235,111,7,0,235,35,9,0,235,
  53,9,0,235,235,15,0,235,97,41,0,235,87,48,0,235,0,0,0,235,4,240,157,228,0,0,160,227,232,10,12,229,
  228,10,12,229,236,90,28,229,0,0,85,227,14,240,160,1,5,160,140,224,36,22,218,229,37,38,218,229,2,16,65,224,
  228,26,12,229,36,22,26,229,24,36,26,229,2,16,129,225,33,40,160,225,2,24,33,224,1,16,139,224,0,16,209,229,
  2,32,139,224,0,32,210,229,2,16,65,224,232,26,12,229,14,240,160,225,8,10,0,224,108,207,1,0,56,86,159,229,
  0,0,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,36,86,159,229,36,102,159,229,131,144,160,227,
  4,0,213,228,4,0,198,228,1,144,89,226,251,255,255,26,168,95,28,229,5,80,139,224,236,86,21,229,5,96,140,224,
  0,0,214,229,128,0,16,227,5,0,0,26,1,0,214,229,28,0,80,227,2,0,0,170,84,0,128,226,32,1,160,225,
  1,0,198,229,44,0,86,229,128,0,16,227,5,0,0,26,43,0,86,229,28,0,80,227,2,0,0,170,84,0,128,226,
  32,1,160,225,43,0,70,229,40,0,86,229,128,0,16,227,5,0,0,26,39,0,86,229,28,0,80,227,2,0,0,170,
  84,0,128,226,32,1,160,225,39,0,70,229,36,0,86,229,128,0,16,227,5,0,0,26,35,0,86,229,28,0,80,227,
  2,0,0,170,84,0,128,226,32,1,160,225,35,0,70,229,4,0,86,229,128,0,16,227,5,0,0,26,3,0,86,229,
  24,0,80,227,2,0,0,170,72,0,128,226,32,1,160,225,3,0,70,229,4,0,214,229,128,0,16,227,5,0,0,26,
  5,0,214,229,24,0,80,227,2,0,0,170,72,0,128,226,32,1,160,225,5,0,198,229,36,0,214,229,128,0,16,227,
  5,0,0,26,37,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,37,0,198,229,40,0,214,229,
  128,0,16,227,5,0,0,26,41,0,214,229,21,0,80,227,2,0,0,170,63,0,128,226,32,1,160,225,41,0,198,229,
  44,0,214,229,128,0,16,227,5,0,0,26,45,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,
  45,0,198,229,84,0,86,229,128,0,16,227,8,0,0,26,44,0,86,229,128,0,16,227,5,0,0,26,83,0,86,229,
  23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,83,0,70,229,80,0,86,229,128,0,16,227,8,0,0,26,
  40,0,86,229,128,0,16,227,5,0,0,26,79,0,86,229,23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,
  79,0,70,229,76,0,86,229,128,0,16,227,8,0,0,26,36,0,86,229,128,0,16,227,5,0,0,26,75,0,86,229,
  23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,75,0,70,229,48,0,86,229,128,0,16,227,8,0,0,26,
  44,0,86,229,128,0,16,227,5,0,0,26,47,0,86,229,22,0,80,227,2,0,0,170,66,0,128,226,32,1,160,225,
  47,0,70,229,32,0,86,229,128,0,16,227,8,0,0,26,36,0,86,229,128,0,16,227,5,0,0,26,31,0,86,229,
  22,0,80,227,2,0,0,170,66,0,128,226,32,1,160,225,31,0,70,229,88,0,86,229,128,0,16,227,8,0,0,26,
  44,0,86,229,128,0,16,227,5,0,0,26,87,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,
  87,0,70,229,72,0,86,229,128,0,16,227,8,0,0,26,36,0,86,229,128,0,16,227,5,0,0,26,71,0,86,229,
  20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,71,0,70,229,8,0,86,229,128,0,16,227,8,0,0,26,
  4,0,86,229,128,0,16,227,5,0,0,26,7,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,
  7,0,70,229,8,0,214,229,128,0,16,227,8,0,0,26,4,0,214,229,128,0,16,227,5,0,0,26,9,0,214,229,
  20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,9,0,198,229,164,95,28,229,5,80,139,224,236,86,21,229,
  5,96,140,224,0,0,214,229,128,0,16,227,5,0,0,26,1,0,214,229,28,0,80,227,2,0,0,170,84,0,128,226,
  32,1,160,225,1,0,198,229,44,0,214,229,128,0,16,227,5,0,0,26,45,0,214,229,28,0,80,227,2,0,0,170,
  84,0,128,226,32,1,160,225,45,0,198,229,40,0,214,229,128,0,16,227,5,0,0,26,41,0,214,229,28,0,80,227,
  2,0,0,170,84,0,128,226,32,1,160,225,41,0,198,229,36,0,214,229,128,0,16,227,5,0,0,26,37,0,214,229,
  28,0,80,227,2,0,0,170,84,0,128,226,32,1,160,225,37,0,198,229,4,0,214,229,128,0,16,227,5,0,0,26,
  5,0,214,229,24,0,80,227,2,0,0,170,72,0,128,226,32,1,160,225,5,0,198,229,4,0,86,229,128,0,16,227,
  5,0,0,26,3,0,86,229,24,0,80,227,2,0,0,170,72,0,128,226,32,1,160,225,3,0,70,229,36,0,86,229,
  128,0,16,227,5,0,0,26,35,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,35,0,70,229,
  40,0,86,229,128,0,16,227,5,0,0,26,39,0,86,229,21,0,80,227,2,0,0,170,63,0,128,226,32,1,160,225,
  39,0,70,229,44,0,86,229,128,0,16,227,5,0,0,26,43,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,
  32,1,160,225,43,0,70,229,84,0,214,229,128,0,16,227,8,0,0,26,44,0,214,229,128,0,16,227,5,0,0,26,
  85,0,214,229,23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,85,0,198,229,80,0,214,229,128,0,16,227,
  8,0,0,26,40,0,214,229,128,0,16,227,5,0,0,26,81,0,214,229,23,0,80,227,2,0,0,170,69,0,128,226,
  32,1,160,225,81,0,198,229,76,0,214,229,128,0,16,227,8,0,0,26,36,0,214,229,128,0,16,227,5,0,0,26,
  77,0,214,229,23,0,80,227,2,0,0,170,69,0,128,226,32,1,160,225,77,0,198,229,48,0,214,229,128,0,16,227,
  8,0,0,26,44,0,214,229,128,0,16,227,5,0,0,26,49,0,214,229,22,0,80,227,2,0,0,170,66,0,128,226,
  32,1,160,225,49,0,198,229,32,0,214,229,128,0,16,227,8,0,0,26,36,0,214,229,128,0,16,227,5,0,0,26,
  33,0,214,229,22,0,80,227,2,0,0,170,66,0,128,226,32,1,160,225,33,0,198,229,88,0,214,229,128,0,16,227,
  8,0,0,26,44,0,214,229,128,0,16,227,5,0,0,26,89,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,
  32,1,160,225,89,0,198,229,72,0,214,229,128,0,16,227,8,0,0,26,36,0,214,229,128,0,16,227,5,0,0,26,
  73,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,73,0,198,229,8,0,214,229,128,0,16,227,
  8,0,0,26,4,0,214,229,128,0,16,227,5,0,0,26,9,0,214,229,20,0,80,227,2,0,0,170,60,0,128,226,
  32,1,160,225,9,0,198,229,8,0,86,229,128,0,16,227,8,0,0,26,4,0,86,229,128,0,16,227,5,0,0,26,
  7,0,86,229,20,0,80,227,2,0,0,170,60,0,128,226,32,1,160,225,7,0,70,229,14,240,160,225,220,18,0,224,
  152,207,1,0,233,20,0,224,0,0,160,227,172,10,12,229,168,10,12,229,152,95,28,229,5,0,140,224,2,0,208,229,
  0,96,160,227,6,112,160,225,6,96,140,224,172,106,22,229,6,16,140,224,2,16,209,229,1,0,80,225,248,255,255,58,
  7,160,140,224,172,90,10,229,5,160,140,224,172,106,10,229,5,80,140,224,152,95,21,229,84,0,85,227,237,255,255,42,
  148,95,28,229,5,0,140,224,2,0,208,229,4,96,160,227,6,112,160,225,6,96,140,224,172,106,22,229,6,16,140,224,
  2,16,209,229,1,0,80,225,248,255,255,58,7,160,140,224,172,90,10,229,5,160,140,224,172,106,10,229,5,80,140,224,
  152,95,21,229,84,0,85,227,237,255,255,42,14,240,160,225,36,6,216,229,3,0,128,226,36,6,200,229,72,12,152,229,
  255,0,16,227,32,8,160,1,0,8,132,224,72,12,136,229,14,240,160,225,24,4,216,229,3,0,16,225,2,0,0,10,
  36,6,216,229,3,0,128,226,36,6,200,229,14,240,160,225,74,76,200,229,36,4,160,225,75,12,200,229,36,6,216,229,
  3,0,128,226,36,6,200,229,14,240,160,225,6,128,160,225,9,128,136,224,36,6,216,229,3,0,128,226,36,6,200,229,
  72,12,152,229,255,0,16,227,32,8,160,1,0,8,132,224,72,12,136,229,0,16,88,229,0,0,81,227,243,255,255,10,
  128,0,17,227,32,0,0,26,11,0,0,234,9,128,136,224,74,76,200,229,36,4,160,225,75,12,200,229,36,6,216,229,
  3,0,128,226,36,6,200,229,0,16,88,229,0,0,81,227,245,255,255,10,128,0,17,227,19,0,0,26,62,16,1,226,
  129,0,151,231,1,0,80,227,15,0,0,186,2,0,0,10,32,0,17,227,236,255,255,10,220,255,255,234,9,128,136,224,
  74,76,200,229,36,4,160,225,75,12,200,229,36,6,216,229,3,0,128,226,36,6,200,229,32,0,17,227,2,0,0,10,
  72,12,152,229,0,8,132,224,72,12,136,229,14,240,160,225,6,128,160,225,9,128,136,224,24,4,216,229,3,0,16,225,
  2,0,0,10,36,6,216,229,3,0,128,226,36,6,200,229,0,0,88,229,0,0,80,227,245,255,255,10,14,240,160,225,
  37,6,216,229,3,0,128,226,37,6,200,229,84,14,152,229,255,0,16,227,32,8,160,1,0,8,132,224,84,14,136,229,
  14,240,160,225,26,4,216,229,3,0,16,225,2,0,0,10,37,6,216,229,3,0,128,226,37,6,200,229,14,240,160,225,
  6,128,160,225,9,128,136,224,37,6,216,229,3,0,128,226,37,6,200,229,84,14,152,229,255,0,16,227,32,8,160,1,
  0,8,132,224,84,14,136,229,0,16,88,229,0,0,81,227,243,255,255,10,128,0,17,227,32,0,0,26,11,0,0,234,
  9,128,136,224,86,78,200,229,36,4,160,225,87,14,200,229,37,6,216,229,3,0,128,226,37,6,200,229,0,16,88,229,
  0,0,81,227,245,255,255,10,128,0,17,227,19,0,0,26,62,16,1,226,129,0,151,231,1,0,80,227,15,0,0,186,
  2,0,0,10,32,0,17,227,236,255,255,26,220,255,255,234,9,128,136,224,86,78,200,229,36,4,160,225,87,14,200,229,
  37,6,216,229,3,0,128,226,37,6,200,229,32,0,17,227,2,0,0,26,84,14,152,229,0,8,132,224,84,14,136,229,
  14,240,160,225,6,128,160,225,9,128,136,224,26,4,216,229,3,0,16,225,2,0,0,10,37,6,216,229,3,0,128,226,
  37,6,200,229,0,0,88,229,0,0,80,227,245,255,255,10,14,240,160,225,40,128,70,226,92,255,255,235,218,2,0,234,
  39,144,224,227,68,126,159,229,111,255,255,235,214,2,0,234,84,128,70,226,85,255,255,235,76,128,70,226,83,255,255,235,
  209,2,0,234,44,128,70,226,80,255,255,235,44,128,134,226,78,255,255,235,40,128,70,226,76,255,255,235,36,128,70,226,
  74,255,255,235,36,128,134,226,72,255,255,235,198,2,0,234,44,128,70,226,69,255,255,235,40,128,70,226,67,255,255,235,
  40,128,134,226,65,255,255,235,36,128,70,226,63,255,255,235,4,128,70,226,61,255,255,235,4,128,134,226,59,255,255,235,
  185,2,0,234,40,128,70,226,56,255,255,235,40,128,134,226,54,255,255,235,4,128,70,226,52,255,255,235,4,128,134,226,
  50,255,255,235,43,144,224,227,164,125,159,229,70,255,255,235,44,144,160,227,156,125,159,229,67,255,255,235,35,144,224,227,
  148,125,159,229,64,255,255,235,36,144,160,227,140,125,159,229,61,255,255,235,164,2,0,234,44,128,70,226,35,255,255,235,
  44,128,134,226,33,255,255,235,36,128,70,226,31,255,255,235,36,128,134,226,29,255,255,235,39,144,224,227,96,125,159,229,
  49,255,255,235,40,144,160,227,88,125,159,229,46,255,255,235,3,144,224,227,80,125,159,229,43,255,255,235,4,144,160,227,
  72,125,159,229,40,255,255,235,143,2,0,234,248,5,214,229,3,0,128,226,248,5,198,229,252,5,214,229,3,0,128,226,
  252,5,198,229,0,6,214,229,3,0,128,226,0,6,198,229,32,6,214,229,3,0,128,226,32,6,198,229,40,6,214,229,
  3,0,128,226,40,6,198,229,72,6,214,229,3,0,128,226,72,6,198,229,76,6,214,229,3,0,128,226,76,6,198,229,
  80,6,214,229,3,0,128,226,80,6,198,229,118,2,0,234,40,128,70,226,254,254,255,235,115,2,0,234,39,144,224,227,
  58,255,255,235,112,2,0,234,84,128,70,226,248,254,255,235,76,128,70,226,246,254,255,235,107,2,0,234,44,128,70,226,
  234,254,255,235,44,128,134,226,232,254,255,235,40,128,70,226,239,254,255,235,36,128,70,226,237,254,255,235,36,128,134,226,
  235,254,255,235,96,2,0,234,44,128,70,226,223,254,255,235,40,128,70,226,230,254,255,235,40,128,134,226,228,254,255,235,
  36,128,70,226,226,254,255,235,4,128,70,226,224,254,255,235,4,128,134,226,222,254,255,235,83,2,0,234,40,128,70,226,
  219,254,255,235,40,128,134,226,217,254,255,235,4,128,70,226,215,254,255,235,4,128,134,226,213,254,255,235,43,144,224,227,
  44,124,159,229,224,254,255,235,44,144,160,227,36,124,159,229,221,254,255,235,35,144,224,227,12,255,255,235,36,144,160,227,
  10,255,255,235,64,2,0,234,44,128,70,226,191,254,255,235,44,128,134,226,189,254,255,235,36,128,70,226,196,254,255,235,
  36,128,134,226,194,254,255,235,39,144,224,227,255,254,255,235,40,144,160,227,253,254,255,235,3,144,224,227,251,254,255,235,
  4,144,160,227,249,254,255,235,47,2,0,234,44,128,70,226,183,254,255,235,44,128,134,226,181,254,255,235,40,128,70,226,
  170,254,255,235,36,128,70,226,177,254,255,235,36,128,134,226,175,254,255,235,36,2,0,234,44,128,70,226,172,254,255,235,
  40,128,70,226,161,254,255,235,40,128,134,226,159,254,255,235,36,128,70,226,166,254,255,235,4,128,70,226,164,254,255,235,
  4,128,134,226,162,254,255,235,23,2,0,234,40,128,70,226,150,254,255,235,40,128,134,226,148,254,255,235,4,128,70,226,
  155,254,255,235,4,128,134,226,153,254,255,235,43,144,224,227,214,254,255,235,44,144,160,227,212,254,255,235,35,144,224,227,
  210,254,255,235,36,144,160,227,208,254,255,235,6,2,0,234,44,128,70,226,142,254,255,235,44,128,134,226,140,254,255,235,
  36,128,70,226,138,254,255,235,36,128,134,226,136,254,255,235,39,144,224,227,0,123,159,229,147,254,255,235,40,144,160,227,
  248,122,159,229,144,254,255,235,3,144,224,227,191,254,255,235,4,144,160,227,189,254,255,235,243,1,0,234,44,128,70,226,
  123,254,255,235,44,128,134,226,121,254,255,235,40,128,70,226,119,254,255,235,36,128,70,226,108,254,255,235,36,128,134,226,
  106,254,255,235,232,1,0,234,44,128,70,226,112,254,255,235,40,128,70,226,110,254,255,235,40,128,134,226,108,254,255,235,
  36,128,70,226,97,254,255,235,4,128,70,226,104,254,255,235,4,128,134,226,102,254,255,235,219,1,0,234,40,128,70,226,
  99,254,255,235,40,128,134,226,97,254,255,235,4,128,70,226,95,254,255,235,4,128,134,226,93,254,255,235,43,144,224,227,
  154,254,255,235,44,144,160,227,152,254,255,235,35,144,224,227,76,122,159,229,100,254,255,235,36,144,160,227,68,122,159,229,
  97,254,255,235,200,1,0,234,44,128,70,226,80,254,255,235,44,128,134,226,78,254,255,235,36,128,70,226,67,254,255,235,
  36,128,134,226,65,254,255,235,39,144,224,227,135,254,255,235,40,144,160,227,133,254,255,235,3,144,224,227,131,254,255,235,
  4,144,160,227,129,254,255,235,183,1,0,234,44,128,70,226,63,254,255,235,44,128,134,226,61,254,255,235,40,128,70,226,
  59,254,255,235,36,128,70,226,57,254,255,235,36,128,134,226,55,254,255,235,172,1,0,234,44,128,70,226,52,254,255,235,
  40,128,70,226,50,254,255,235,40,128,134,226,48,254,255,235,36,128,70,226,46,254,255,235,4,128,70,226,35,254,255,235,
  4,128,134,226,33,254,255,235,159,1,0,234,40,128,70,226,39,254,255,235,40,128,134,226,37,254,255,235,4,128,70,226,
  26,254,255,235,4,128,134,226,24,254,255,235,43,144,224,227,94,254,255,235,44,144,160,227,92,254,255,235,35,144,224,227,
  90,254,255,235,36,144,160,227,88,254,255,235,142,1,0,234,44,128,70,226,22,254,255,235,44,128,134,226,20,254,255,235,
  36,128,70,226,18,254,255,235,36,128,134,226,16,254,255,235,39,144,224,227,77,254,255,235,40,144,160,227,75,254,255,235,
  3,144,224,227,32,121,159,229,23,254,255,235,4,144,160,227,24,121,159,229,20,254,255,235,123,1,0,234,40,128,134,226,
  78,254,255,235,138,1,0,234,40,144,160,227,0,121,159,229,90,254,255,235,134,1,0,234,84,128,134,226,71,254,255,235,
  76,128,134,226,69,254,255,235,129,1,0,234,44,128,134,226,66,254,255,235,44,128,70,226,64,254,255,235,40,128,134,226,
  62,254,255,235,36,128,134,226,60,254,255,235,36,128,70,226,58,254,255,235,118,1,0,234,44,128,134,226,55,254,255,235,
  40,128,134,226,53,254,255,235,40,128,70,226,51,254,255,235,36,128,134,226,49,254,255,235,4,128,134,226,47,254,255,235,
  4,128,70,226,45,254,255,235,105,1,0,234,40,128,134,226,42,254,255,235,40,128,70,226,40,254,255,235,4,128,134,226,
  38,254,255,235,4,128,70,226,36,254,255,235,44,144,160,227,96,120,159,229,49,254,255,235,43,144,224,227,88,120,159,229,
  46,254,255,235,36,144,160,227,80,120,159,229,43,254,255,235,35,144,224,227,72,120,159,229,40,254,255,235,84,1,0,234,
  44,128,134,226,21,254,255,235,44,128,70,226,19,254,255,235,36,128,134,226,17,254,255,235,36,128,70,226,15,254,255,235,
  40,144,160,227,28,120,159,229,28,254,255,235,39,144,224,227,20,120,159,229,25,254,255,235,4,144,160,227,12,120,159,229,
  22,254,255,235,3,144,224,227,4,120,159,229,19,254,255,235,63,1,0,234,81,6,214,229,3,0,128,226,81,6,198,229,
  77,6,214,229,3,0,128,226,77,6,198,229,73,6,214,229,3,0,128,226,73,6,198,229,41,6,214,229,3,0,128,226,
  41,6,198,229,33,6,214,229,3,0,128,226,33,6,198,229,1,6,214,229,3,0,128,226,1,6,198,229,253,5,214,229,
  3,0,128,226,253,5,198,229,249,5,214,229,3,0,128,226,249,5,198,229,38,1,0,234,40,128,134,226,240,253,255,235,
  35,1,0,234,40,144,160,227,37,254,255,235,32,1,0,234,84,128,134,226,234,253,255,235,76,128,134,226,232,253,255,235,
  27,1,0,234,44,128,134,226,220,253,255,235,44,128,70,226,218,253,255,235,40,128,134,226,225,253,255,235,36,128,134,226,
  223,253,255,235,36,128,70,226,221,253,255,235,16,1,0,234,44,128,134,226,209,253,255,235,40,128,134,226,216,253,255,235,
  40,128,70,226,214,253,255,235,36,128,134,226,212,253,255,235,4,128,134,226,210,253,255,235,4,128,70,226,208,253,255,235,
  3,1,0,234,40,128,134,226,205,253,255,235,40,128,70,226,203,253,255,235,4,128,134,226,201,253,255,235,4,128,70,226,
  199,253,255,235,44,144,160,227,232,118,159,229,203,253,255,235,43,144,224,227,224,118,159,229,200,253,255,235,36,144,160,227,
  247,253,255,235,35,144,224,227,245,253,255,235,240,0,0,234,44,128,134,226,177,253,255,235,44,128,70,226,175,253,255,235,
  36,128,134,226,182,253,255,235,36,128,70,226,180,253,255,235,40,144,160,227,234,253,255,235,39,144,224,227,232,253,255,235,
  4,144,160,227,230,253,255,235,3,144,224,227,228,253,255,235,223,0,0,234,44,128,134,226,169,253,255,235,44,128,70,226,
  167,253,255,235,40,128,134,226,156,253,255,235,36,128,134,226,163,253,255,235,36,128,70,226,161,253,255,235,212,0,0,234,
  44,128,134,226,158,253,255,235,40,128,134,226,147,253,255,235,40,128,70,226,145,253,255,235,36,128,134,226,152,253,255,235,
  4,128,134,226,150,253,255,235,4,128,70,226,148,253,255,235,199,0,0,234,40,128,134,226,136,253,255,235,40,128,70,226,
  134,253,255,235,4,128,134,226,141,253,255,235,4,128,70,226,139,253,255,235,44,144,160,227,193,253,255,235,43,144,224,227,
  191,253,255,235,36,144,160,227,189,253,255,235,35,144,224,227,187,253,255,235,182,0,0,234,44,128,134,226,128,253,255,235,
  44,128,70,226,126,253,255,235,36,128,134,226,124,253,255,235,36,128,70,226,122,253,255,235,40,144,160,227,188,117,159,229,
  126,253,255,235,39,144,224,227,180,117,159,229,123,253,255,235,4,144,160,227,170,253,255,235,3,144,224,227,168,253,255,235,
  163,0,0,234,44,128,134,226,109,253,255,235,44,128,70,226,107,253,255,235,40,128,134,226,105,253,255,235,36,128,134,226,
  94,253,255,235,36,128,70,226,92,253,255,235,152,0,0,234,44,128,134,226,98,253,255,235,40,128,134,226,96,253,255,235,
  40,128,70,226,94,253,255,235,36,128,134,226,83,253,255,235,4,128,134,226,90,253,255,235,4,128,70,226,88,253,255,235,
  139,0,0,234,40,128,134,226,85,253,255,235,40,128,70,226,83,253,255,235,4,128,134,226,81,253,255,235,4,128,70,226,
  79,253,255,235,44,144,160,227,133,253,255,235,43,144,224,227,131,253,255,235,36,144,160,227,8,117,159,229,79,253,255,235,
  35,144,224,227,0,117,159,229,76,253,255,235,120,0,0,234,44,128,134,226,66,253,255,235,44,128,70,226,64,253,255,235,
  36,128,134,226,53,253,255,235,36,128,70,226,51,253,255,235,40,144,160,227,114,253,255,235,39,144,224,227,112,253,255,235,
  4,144,160,227,110,253,255,235,3,144,224,227,108,253,255,235,103,0,0,234,44,128,134,226,49,253,255,235,44,128,70,226,
  47,253,255,235,40,128,134,226,45,253,255,235,36,128,134,226,43,253,255,235,36,128,70,226,41,253,255,235,92,0,0,234,
  44,128,134,226,38,253,255,235,40,128,134,226,36,253,255,235,40,128,70,226,34,253,255,235,36,128,134,226,32,253,255,235,
  4,128,134,226,21,253,255,235,4,128,70,226,19,253,255,235,79,0,0,234,40,128,134,226,25,253,255,235,40,128,70,226,
  23,253,255,235,4,128,134,226,12,253,255,235,4,128,70,226,10,253,255,235,44,144,160,227,73,253,255,235,43,144,224,227,
  71,253,255,235,36,144,160,227,69,253,255,235,35,144,224,227,67,253,255,235,62,0,0,234,44,128,134,226,8,253,255,235,
  44,128,70,226,6,253,255,235,36,128,134,226,4,253,255,235,36,128,70,226,2,253,255,235,40,144,160,227,56,253,255,235,
  39,144,224,227,54,253,255,235,4,144,160,227,220,115,159,229,2,253,255,235,3,144,224,227,212,115,159,229,255,252,255,235,
  43,0,0,234,4,224,45,229,200,83,159,229,0,0,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,
  180,83,159,229,180,3,159,229,131,144,160,227,12,2,133,229,4,0,133,228,1,144,89,226,251,255,255,26,172,90,28,229,
  5,96,140,224,37,65,160,225,2,0,214,229,0,68,132,225,25,52,214,229,0,0,86,229,30,0,0,226,13,18,214,229,
  1,0,128,225,128,0,143,224,100,240,144,229,36,6,214,229,2,0,128,226,36,6,198,229,172,90,22,229,0,0,85,227,
  238,255,255,26,168,90,28,229,5,96,140,224,37,65,160,225,2,0,214,229,0,68,132,225,27,52,214,229,0,0,86,229,
  30,0,0,226,15,18,214,229,1,0,128,225,128,0,143,224,92,241,144,229,37,6,214,229,2,0,128,226,37,6,198,229,
  172,90,22,229,0,0,85,227,238,255,255,26,4,240,157,228,52,134,0,0,144,134,0,0,64,134,0,0,144,134,0,0,
  80,134,0,0,144,134,0,0,100,134,0,0,144,134,0,0,144,134,0,0,0,0,0,0,228,134,0,0,196,134,0,0,
  56,135,0,0,24,135,0,0,108,135,0,0,0,0,0,0,208,135,0,0,40,136,0,0,220,135,0,0,40,136,0,0,
  232,135,0,0,40,136,0,0,252,135,0,0,40,136,0,0,40,136,0,0,0,0,0,0,124,136,0,0,92,136,0,0,
  200,136,0,0,168,136,0,0,60,134,0,0,0,0,0,0,52,134,0,0,24,137,0,0,64,134,0,0,24,137,0,0,
  232,135,0,0,24,137,0,0,236,136,0,0,24,137,0,0,24,137,0,0,0,0,0,0,108,137,0,0,76,137,0,0,
  176,137,0,0,144,137,0,0,60,134,0,0,0,0,0,0,208,135,0,0,8,138,0,0,220,135,0,0,8,138,0,0,
  232,135,0,0,8,138,0,0,220,137,0,0,8,138,0,0,8,138,0,0,0,0,0,0,92,138,0,0,60,138,0,0,
  168,138,0,0,136,138,0,0,60,134,0,0,0,0,0,0,208,135,0,0,248,138,0,0,220,135,0,0,248,138,0,0,
  232,135,0,0,248,138,0,0,204,138,0,0,248,138,0,0,248,138,0,0,0,0,0,0,76,139,0,0,44,139,0,0,
  144,139,0,0,112,139,0,0,60,134,0,0,0,0,0,0,188,139,0,0,24,140,0,0,200,139,0,0,24,140,0,0,
  216,139,0,0,24,140,0,0,236,139,0,0,24,140,0,0,24,140,0,0,0,0,0,0,108,140,0,0,76,140,0,0,
  192,140,0,0,160,140,0,0,244,140,0,0,0,0,0,0,88,141,0,0,176,141,0,0,100,141,0,0,176,141,0,0,
  112,141,0,0,176,141,0,0,132,141,0,0,176,141,0,0,176,141,0,0,0,0,0,0,4,142,0,0,228,141,0,0,
  80,142,0,0,48,142,0,0,196,139,0,0,0,0,0,0,188,139,0,0,160,142,0,0,200,139,0,0,160,142,0,0,
  112,141,0,0,160,142,0,0,116,142,0,0,160,142,0,0,160,142,0,0,0,0,0,0,244,142,0,0,212,142,0,0,
  56,143,0,0,24,143,0,0,196,139,0,0,0,0,0,0,88,141,0,0,144,143,0,0,100,141,0,0,144,143,0,0,
  112,141,0,0,144,143,0,0,100,143,0,0,144,143,0,0,144,143,0,0,0,0,0,0,228,143,0,0,196,143,0,0,
  48,144,0,0,16,144,0,0,196,139,0,0,0,0,0,0,88,141,0,0,128,144,0,0,100,141,0,0,128,144,0,0,
  112,141,0,0,128,144,0,0,84,144,0,0,128,144,0,0,128,144,0,0,0,0,0,0,212,144,0,0,180,144,0,0,
  24,145,0,0,248,144,0,0,196,139,0,0,0,0,0,0,92,211,1,0,220,211,1,0,220,212,1,0,220,211,1,0,
  220,212,1,0,92,211,1,0,92,213,1,0,92,212,1,0,92,212,1,0,220,211,1,0,220,212,1,0,92,211,1,0,
  92,213,1,0,220,211,1,0,220,212,1,0,92,212,1,0,92,212,1,0,92,213,1,0,220,212,1,0,220,211,1,0,
  220,212,1,0,220,211,1,0,92,213,1,0,92,211,1,0,92,212,1,0,92,212,1,0,220,212,1,0,220,211,1,0,
  92,213,1,0,92,211,1,0,220,212,1,0,220,211,1,0,92,212,1,0,92,212,1,0,12,27,0,224,48,33,0,224,
  0,120,0,120,72,12,152,229,255,0,16,227,32,8,160,1,0,8,132,224,72,12,136,229,14,240,160,225,6,128,160,225,
  9,128,136,224,72,12,152,229,255,0,16,227,32,8,160,1,0,8,132,224,72,12,136,229,0,16,88,229,0,0,81,227,
  246,255,255,10,128,0,17,227,26,0,0,26,8,0,0,234,9,128,136,224,74,76,200,229,36,4,160,225,75,12,200,229,
  0,16,88,229,0,0,81,227,248,255,255,10,128,0,17,227,16,0,0,26,62,16,1,226,129,0,151,231,1,0,80,227,
  12,0,0,186,2,0,0,10,32,0,17,227,239,255,255,10,226,255,255,234,9,128,136,224,74,76,200,229,36,4,160,225,
  75,12,200,229,32,0,17,227,2,0,0,10,72,12,152,229,0,8,132,224,72,12,136,229,14,240,160,225,84,14,152,229,
  255,0,16,227,32,8,160,1,0,8,132,224,84,14,136,229,14,240,160,225,6,128,160,225,9,128,136,224,84,14,152,229,
  255,0,16,227,32,8,160,1,0,8,132,224,84,14,136,229,0,16,88,229,0,0,81,227,246,255,255,10,128,0,17,227,
  26,0,0,26,8,0,0,234,9,128,136,224,86,78,200,229,36,4,160,225,87,14,200,229,0,16,88,229,0,0,81,227,
  248,255,255,10,128,0,17,227,16,0,0,26,62,16,1,226,129,0,151,231,1,0,80,227,12,0,0,186,2,0,0,10,
  32,0,17,227,239,255,255,26,226,255,255,234,9,128,136,224,86,78,200,229,36,4,160,225,87,14,200,229,32,0,17,227,
  2,0,0,26,84,14,152,229,0,8,132,224,84,14,136,229,14,240,160,225,40,128,70,226,161,255,255,235,233,0,0,234,
  39,144,224,227,100,118,159,229,163,255,255,235,229,0,0,234,84,128,70,226,154,255,255,235,76,128,70,226,152,255,255,235,
  224,0,0,234,44,128,70,226,149,255,255,235,44,128,134,226,147,255,255,235,40,128,70,226,145,255,255,235,36,128,70,226,
  143,255,255,235,36,128,134,226,141,255,255,235,213,0,0,234,44,128,70,226,138,255,255,235,40,128,70,226,136,255,255,235,
  40,128,134,226,134,255,255,235,36,128,70,226,132,255,255,235,4,128,70,226,130,255,255,235,4,128,134,226,128,255,255,235,
  200,0,0,234,40,128,70,226,125,255,255,235,40,128,134,226,123,255,255,235,4,128,70,226,121,255,255,235,4,128,134,226,
  119,255,255,235,43,144,224,227,196,117,159,229,122,255,255,235,44,144,160,227,188,117,159,229,119,255,255,235,35,144,224,227,
  180,117,159,229,116,255,255,235,36,144,160,227,172,117,159,229,113,255,255,235,179,0,0,234,44,128,70,226,104,255,255,235,
  44,128,134,226,102,255,255,235,36,128,70,226,100,255,255,235,36,128,134,226,98,255,255,235,39,144,224,227,128,117,159,229,
  101,255,255,235,40,144,160,227,120,117,159,229,98,255,255,235,3,144,224,227,112,117,159,229,95,255,255,235,4,144,160,227,
  104,117,159,229,92,255,255,235,158,0,0,234,44,128,70,226,83,255,255,235,44,128,134,226,81,255,255,235,153,0,0,234,
  44,128,70,226,78,255,255,235,150,0,0,234,40,128,70,226,75,255,255,235,40,128,134,226,73,255,255,235,145,0,0,234,
  36,128,70,226,70,255,255,235,142,0,0,234,43,144,224,227,28,117,159,229,72,255,255,235,44,144,160,227,20,117,159,229,
  69,255,255,235,135,0,0,234,39,144,224,227,8,117,159,229,65,255,255,235,40,144,160,227,0,117,159,229,62,255,255,235,
  128,0,0,234,127,0,0,234,40,128,134,226,98,255,255,235,138,0,0,234,40,144,160,227,228,116,159,229,100,255,255,235,
  134,0,0,234,84,128,134,226,91,255,255,235,76,128,134,226,89,255,255,235,129,0,0,234,44,128,134,226,86,255,255,235,
  44,128,70,226,84,255,255,235,40,128,134,226,82,255,255,235,36,128,134,226,80,255,255,235,36,128,70,226,78,255,255,235,
  118,0,0,234,44,128,134,226,75,255,255,235,40,128,134,226,73,255,255,235,40,128,70,226,71,255,255,235,36,128,134,226,
  69,255,255,235,4,128,134,226,67,255,255,235,4,128,70,226,65,255,255,235,105,0,0,234,40,128,134,226,62,255,255,235,
  40,128,70,226,60,255,255,235,4,128,134,226,58,255,255,235,4,128,70,226,56,255,255,235,44,144,160,227,68,116,159,229,
  59,255,255,235,43,144,224,227,60,116,159,229,56,255,255,235,36,144,160,227,52,116,159,229,53,255,255,235,35,144,224,227,
  44,116,159,229,50,255,255,235,84,0,0,234,44,128,134,226,41,255,255,235,44,128,70,226,39,255,255,235,36,128,134,226,
  37,255,255,235,36,128,70,226,35,255,255,235,40,144,160,227,0,116,159,229,38,255,255,235,39,144,224,227,248,115,159,229,
  35,255,255,235,4,144,160,227,240,115,159,229,32,255,255,235,3,144,224,227,232,115,159,229,29,255,255,235,63,0,0,234,
  44,128,134,226,20,255,255,235,44,128,70,226,18,255,255,235,58,0,0,234,44,128,134,226,15,255,255,235,55,0,0,234,
  40,128,134,226,12,255,255,235,40,128,70,226,10,255,255,235,50,0,0,234,36,128,134,226,7,255,255,235,47,0,0,234,
  44,144,160,227,156,115,159,229,9,255,255,235,43,144,224,227,148,115,159,229,6,255,255,235,40,0,0,234,40,144,160,227,
  136,115,159,229,2,255,255,235,39,144,224,227,128,115,159,229,255,254,255,235,33,0,0,234,32,0,0,234,4,224,45,229,
  112,83,159,229,112,3,159,229,131,144,160,227,12,2,133,229,4,0,133,228,1,144,89,226,251,255,255,26,172,90,28,229,
  5,96,140,224,37,65,160,225,2,0,214,229,0,68,132,225,0,0,86,229,30,0,0,226,13,18,214,229,1,0,128,225,
  128,0,143,224,72,240,144,229,172,90,22,229,0,0,85,227,242,255,255,26,168,90,28,229,5,96,140,224,37,65,160,225,
  2,0,214,229,0,68,132,225,0,0,86,229,30,0,0,226,15,18,214,229,1,0,128,225,128,0,143,224,80,241,144,229,
  172,90,22,229,0,0,85,227,242,255,255,26,4,240,157,228,148,150,0,0,240,150,0,0,160,150,0,0,240,150,0,0,
  176,150,0,0,240,150,0,0,196,150,0,0,240,150,0,0,240,150,0,0,0,0,0,0,68,151,0,0,36,151,0,0,
  152,151,0,0,120,151,0,0,68,152,0,0,0,0,0,0,156,150,0,0,224,151,0,0,156,150,0,0,224,151,0,0,
  156,150,0,0,224,151,0,0,204,151,0,0,224,151,0,0,224,151,0,0,0,0,0,0,12,152,0,0,12,152,0,0,
  156,150,0,0,204,151,0,0,156,150,0,0,0,0,0,0,148,150,0,0,236,151,0,0,160,150,0,0,236,151,0,0,
  156,150,0,0,236,151,0,0,148,150,0,0,236,151,0,0,236,151,0,0,0,0,0,0,156,150,0,0,236,151,0,0,
  40,152,0,0,40,152,0,0,156,150,0,0,0,0,0,0,156,150,0,0,0,152,0,0,156,150,0,0,0,152,0,0,
  156,150,0,0,0,152,0,0,220,150,0,0,0,152,0,0,0,152,0,0,0,0,0,0,92,151,0,0,92,151,0,0,
  156,150,0,0,220,150,0,0,156,150,0,0,0,0,0,0,156,150,0,0,16,151,0,0,156,150,0,0,16,151,0,0,
  156,150,0,0,16,151,0,0,156,150,0,0,16,151,0,0,16,151,0,0,0,0,0,0,156,150,0,0,16,151,0,0,
  176,151,0,0,176,151,0,0,156,150,0,0,0,0,0,0,72,152,0,0,164,152,0,0,84,152,0,0,164,152,0,0,
  100,152,0,0,164,152,0,0,120,152,0,0,164,152,0,0,164,152,0,0,0,0,0,0,248,152,0,0,216,152,0,0,
  76,153,0,0,44,153,0,0,248,153,0,0,0,0,0,0,80,152,0,0,148,153,0,0,80,152,0,0,148,153,0,0,
  80,152,0,0,148,153,0,0,128,153,0,0,148,153,0,0,148,153,0,0,0,0,0,0,192,153,0,0,192,153,0,0,
  80,152,0,0,128,153,0,0,80,152,0,0,0,0,0,0,72,152,0,0,160,153,0,0,84,152,0,0,160,153,0,0,
  80,152,0,0,160,153,0,0,72,152,0,0,160,153,0,0,160,153,0,0,0,0,0,0,80,152,0,0,160,153,0,0,
  220,153,0,0,220,153,0,0,80,152,0,0,0,0,0,0,80,152,0,0,180,153,0,0,80,152,0,0,180,153,0,0,
  80,152,0,0,180,153,0,0,144,152,0,0,180,153,0,0,180,153,0,0,0,0,0,0,16,153,0,0,16,153,0,0,
  80,152,0,0,144,152,0,0,80,152,0,0,0,0,0,0,80,152,0,0,196,152,0,0,80,152,0,0,196,152,0,0,
  80,152,0,0,196,152,0,0,80,152,0,0,196,152,0,0,196,152,0,0,0,0,0,0,80,152,0,0,196,152,0,0,
  100,153,0,0,100,153,0,0,80,152,0,0,0,0,0,0,92,211,1,0,220,211,1,0,220,212,1,0,220,211,1,0,
  220,212,1,0,92,211,1,0,92,213,1,0,92,212,1,0,92,212,1,0,220,211,1,0,220,212,1,0,92,211,1,0,
  92,213,1,0,92,213,1,0,220,212,1,0,220,211,1,0,220,212,1,0,220,211,1,0,92,213,1,0,92,211,1,0,
  92,212,1,0,92,212,1,0,220,212,1,0,220,211,1,0,92,213,1,0,92,211,1,0,48,33,0,224,0,120,0,120,
  222,67,45,233,7,160,140,224,73,28,218,229,75,44,218,229,85,62,218,229,87,78,218,229,36,102,218,229,37,118,218,229,
  84,142,218,229,86,158,218,229,26,0,0,235,156,8,76,229,222,67,189,232,14,240,160,225,222,67,45,233,7,160,140,224,
  73,28,218,229,75,44,218,229,85,62,218,229,87,78,218,229,49,8,218,229,0,0,81,225,2,0,0,58,1,32,160,225,
  0,16,160,225,1,0,0,234,0,0,82,225,0,32,160,33,36,102,218,229,37,118,218,229,48,8,218,229,0,96,134,224,
  84,142,218,229,86,158,218,229,2,0,0,235,156,8,76,229,222,67,189,232,14,240,160,225,3,0,86,227,1,0,0,42,
  120,0,160,227,14,240,160,225,3,0,87,227,1,0,0,138,0,0,160,227,14,240,160,225,8,1,85,225,2,0,0,26,
  4,48,160,225,120,64,160,227,2,0,0,234,9,1,85,225,0,0,0,26,120,64,160,227,7,0,86,225,6,0,0,58,
  4,0,82,224,0,0,160,51,0,0,83,224,0,0,160,51,0,0,81,224,0,0,160,51,14,240,160,225,2,0,83,224,
  0,0,160,51,0,0,81,224,0,0,160,51,14,240,160,225,222,67,45,233,7,160,140,224,73,28,218,229,75,44,218,229,
  85,62,218,229,87,78,218,229,36,102,218,229,37,118,218,229,72,140,218,229,74,156,218,229,30,0,0,235,155,8,76,229,
  222,67,189,232,14,240,160,225,7,160,140,224,84,14,218,229,0,1,160,225,81,15,80,227,1,0,0,42,81,15,87,227,
  234,255,255,58,0,0,220,231,30,0,0,226,128,0,139,224,180,2,16,229,0,0,80,227,228,255,255,10,0,48,131,224,
  222,67,45,233,73,28,218,229,75,44,218,229,85,62,218,229,87,78,218,229,0,48,131,224,36,102,218,229,37,118,218,229,
  72,140,218,229,74,156,218,229,2,0,0,235,155,8,76,229,222,67,189,232,14,240,160,225,3,0,87,227,1,0,0,42,
  120,0,160,227,14,240,160,225,3,0,86,227,1,0,0,138,0,0,160,227,14,240,160,225,8,1,85,225,2,0,0,26,
  2,16,160,225,120,32,160,227,2,0,0,234,9,1,85,225,0,0,0,26,120,32,160,227,6,0,87,225,6,0,0,58,
  2,0,84,224,0,0,160,51,0,0,81,224,0,0,160,51,0,0,83,224,0,0,160,51,14,240,160,225,4,0,81,224,
  0,0,160,51,0,0,83,224,0,0,160,51,14,240,160,225,222,67,45,233,7,160,140,224,73,28,218,229,75,44,218,229,
  85,62,218,229,87,78,218,229,36,102,218,229,37,118,218,229,2,0,0,235,154,8,76,229,222,67,189,232,14,240,160,225,
  3,0,86,227,3,0,0,42,7,0,86,225,1,0,0,138,120,0,160,227,14,240,160,225,3,0,87,227,1,0,0,42,
  0,0,160,227,14,240,160,225,7,0,86,225,6,0,0,154,4,0,82,224,0,0,160,51,0,0,83,224,0,0,160,51,
  0,0,81,224,0,0,160,51,14,240,160,225,2,0,83,224,0,0,160,51,0,0,81,224,0,0,160,51,14,240,160,225,
  222,67,45,233,7,160,140,224,73,28,218,229,75,44,218,229,85,62,218,229,87,78,218,229,36,102,218,229,37,118,218,229,
  2,0,0,235,153,8,76,229,222,67,189,232,14,240,160,225,3,0,87,227,3,0,0,42,6,0,87,225,1,0,0,138,
  120,0,160,227,14,240,160,225,3,0,86,227,1,0,0,42,0,0,160,227,14,240,160,225,6,0,87,225,6,0,0,154,
  2,0,84,224,0,0,160,51,0,0,81,224,0,0,160,51,0,0,83,224,0,0,160,51,14,240,160,225,4,0,81,224,
  0,0,160,51,0,0,83,224,0,0,160,51,14,240,160,225,4,224,45,229,84,112,160,227,9,144,160,227,9,128,160,227,
  178,255,255,235,154,8,92,229,7,160,140,224,38,6,202,229,210,255,255,235,153,8,92,229,7,160,140,224,39,6,202,229,
  4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,4,240,157,228,4,224,45,229,
  204,82,159,229,30,11,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,172,90,28,229,5,160,140,224,
  13,2,218,229,0,0,80,227,6,0,0,26,2,64,218,229,4,68,160,225,3,64,132,226,0,0,90,229,30,0,0,226,
  128,0,143,224,148,242,144,229,5,80,140,224,172,90,21,229,0,0,85,227,240,255,255,26,190,15,92,229,0,0,80,227,
  18,0,0,10,84,112,160,227,9,144,160,227,5,74,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,
  4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,1,0,80,225,137,6,0,139,4,112,135,226,1,128,88,226,
  244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,191,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,
  9,144,160,227,70,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,
  39,6,208,229,36,20,160,225,1,0,80,225,109,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,
  1,144,89,226,240,255,255,26,192,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,13,75,160,227,
  3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,
  1,0,80,225,79,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,
  193,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,50,76,160,227,3,64,132,226,9,128,160,227,
  7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,1,0,80,225,50,6,0,139,
  4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,194,15,92,229,0,0,80,227,
  18,0,0,10,164,112,160,227,7,144,160,227,2,74,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,
  4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,1,0,80,225,24,6,0,139,4,112,135,226,1,128,88,226,
  244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,195,15,92,229,0,0,80,227,18,0,0,10,124,112,160,227,
  8,144,160,227,30,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,
  39,6,208,229,36,20,160,225,1,0,80,225,255,5,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,
  1,144,89,226,240,255,255,26,196,15,92,229,0,0,80,227,22,0,0,10,124,112,160,227,8,144,160,227,2,75,160,227,
  3,64,132,226,9,128,160,227,72,80,159,229,1,0,213,228,0,0,80,227,7,0,0,26,7,0,220,231,0,0,80,227,
  4,0,0,26,7,0,140,224,39,6,208,229,36,20,160,225,1,0,80,225,226,5,0,139,4,112,135,226,1,128,88,226,
  241,255,255,26,4,112,135,226,1,144,89,226,236,255,255,26,4,240,157,228,24,29,0,224,105,9,0,224,60,164,0,0,
  80,166,0,0,120,164,0,0,80,166,0,0,192,164,0,0,80,166,0,0,52,165,0,0,80,166,0,0,80,166,0,0,
  0,0,0,0,164,167,0,0,104,169,0,0,148,172,0,0,88,174,0,0,132,177,0,0,132,177,0,0,40,112,69,226,
  7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,139,254,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,140,3,0,235,59,255,255,234,5,112,160,225,40,112,71,226,
  7,0,220,231,0,0,80,227,251,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,121,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,125,3,0,235,41,255,255,234,
  84,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,
  106,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,113,3,0,235,76,112,69,226,7,0,220,231,
  192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,92,254,255,235,36,4,160,225,
  155,24,92,229,1,0,80,225,0,0,0,42,99,3,0,235,12,255,255,234,44,112,69,226,7,0,220,231,192,0,16,227,
  9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,77,254,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,88,3,0,235,40,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,63,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  74,3,0,235,36,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,49,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,60,3,0,235,36,112,133,226,
  7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,35,254,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,46,3,0,235,44,112,133,226,7,0,220,231,192,0,16,227,
  9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,21,254,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,32,3,0,235,197,254,255,234,44,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,
  7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,6,254,255,235,36,4,160,225,155,24,92,229,1,0,80,225,
  0,0,0,42,24,3,0,235,40,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,
  3,0,80,227,4,0,0,58,248,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,16,3,0,235,
  36,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,
  234,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,7,3,0,235,4,112,69,226,7,0,220,231,
  192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,220,253,255,235,36,4,160,225,
  155,24,92,229,1,0,80,225,0,0,0,42,255,2,0,235,4,112,133,226,7,0,220,231,192,0,16,227,9,0,0,26,
  7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,206,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,
  0,0,0,42,246,2,0,235,40,112,133,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,
  3,0,80,227,4,0,0,58,192,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,237,2,0,235,
  112,254,255,234,44,112,69,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,179,253,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,232,2,0,235,44,112,71,226,7,0,220,231,0,0,80,227,
  241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,163,253,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,213,2,0,235,36,112,69,226,10,0,0,234,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,151,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  213,2,0,235,36,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,135,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  194,2,0,235,36,112,133,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,123,253,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,194,2,0,235,36,112,135,226,7,0,220,231,0,0,80,227,
  241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,107,253,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,175,2,0,235,44,112,133,226,10,0,0,234,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,95,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  175,2,0,235,44,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,79,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  156,2,0,235,255,253,255,234,5,160,140,224,4,8,154,229,1,0,45,233,8,8,154,229,1,0,45,233,12,8,154,229,
  1,0,45,233,44,8,154,229,1,0,45,233,52,8,154,229,1,0,45,233,84,8,154,229,1,0,45,233,88,8,154,229,
  1,0,45,233,92,8,154,229,1,0,45,233,44,112,69,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,49,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,138,2,0,235,44,112,71,226,
  7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,33,253,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,119,2,0,235,36,112,69,226,
  10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,21,253,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,124,2,0,235,36,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,
  9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,5,253,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,105,2,0,235,36,112,133,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,249,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,110,2,0,235,36,112,135,226,
  7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,233,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,91,2,0,235,44,112,133,226,
  10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,221,252,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,96,2,0,235,44,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,
  9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,205,252,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,77,2,0,235,40,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,191,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  77,2,0,235,4,112,69,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,177,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,63,2,0,235,4,112,133,226,
  7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,163,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,49,2,0,235,40,112,133,226,7,0,220,231,192,0,16,227,
  9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,149,252,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,35,2,0,235,5,160,140,224,1,0,189,232,92,8,138,229,1,0,189,232,88,8,138,229,
  1,0,189,232,84,8,138,229,1,0,189,232,52,8,138,229,1,0,189,232,44,8,138,229,1,0,189,232,12,8,138,229,
  1,0,189,232,8,8,138,229,1,0,189,232,4,8,138,229,52,253,255,234,40,112,69,226,10,0,0,234,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,119,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  19,2,0,235,40,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,103,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  0,2,0,235,4,112,69,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,91,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,0,2,0,235,4,112,71,226,7,0,220,231,0,0,80,227,
  241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,75,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,237,1,0,235,4,112,133,226,10,0,0,234,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,63,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  237,1,0,235,4,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,47,252,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  218,1,0,235,40,112,133,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,35,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,218,1,0,235,40,112,135,226,7,0,220,231,0,0,80,227,
  241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,19,252,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,199,1,0,235,195,252,255,234,5,160,140,224,4,8,154,229,
  1,0,45,233,8,8,154,229,1,0,45,233,12,8,154,229,1,0,45,233,44,8,154,229,1,0,45,233,52,8,154,229,
  1,0,45,233,84,8,154,229,1,0,45,233,88,8,154,229,1,0,45,233,92,8,154,229,1,0,45,233,40,112,69,226,
  10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,245,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,181,1,0,235,40,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,
  9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,229,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,162,1,0,235,4,112,69,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,217,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,167,1,0,235,4,112,71,226,
  7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,201,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,148,1,0,235,4,112,133,226,
  10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,189,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,153,1,0,235,4,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,
  9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,173,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,134,1,0,235,40,112,133,226,10,0,0,234,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,161,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,139,1,0,235,40,112,135,226,
  7,0,220,231,0,0,80,227,241,255,255,10,32,0,16,227,9,0,0,10,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,145,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,120,1,0,235,44,112,69,226,
  7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,131,251,255,235,
  36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,120,1,0,235,36,112,69,226,7,0,220,231,192,0,16,227,
  9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,4,0,0,58,117,251,255,235,36,4,160,225,155,24,92,229,
  1,0,80,225,0,0,0,42,126,1,0,235,36,112,133,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,
  37,6,208,229,3,0,80,227,4,0,0,58,103,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,
  133,1,0,235,44,112,133,226,7,0,220,231,192,0,16,227,9,0,0,26,7,0,140,224,37,6,208,229,3,0,80,227,
  4,0,0,58,89,251,255,235,36,4,160,225,155,24,92,229,1,0,80,225,0,0,0,42,140,1,0,235,5,160,140,224,
  1,0,189,232,92,8,138,229,1,0,189,232,88,8,138,229,1,0,189,232,84,8,138,229,1,0,189,232,52,8,138,229,
  1,0,189,232,44,8,138,229,1,0,189,232,12,8,138,229,1,0,189,232,8,8,138,229,1,0,189,232,4,8,138,229,
  248,251,255,234,44,112,69,226,7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,
  32,8,145,225,134,1,0,11,40,112,69,226,7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,
  22,20,90,229,32,8,145,225,133,1,0,11,36,112,69,226,7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,
  36,6,26,229,22,20,90,229,32,8,145,225,130,1,0,11,4,112,69,226,7,0,220,231,192,0,16,227,4,0,0,26,
  7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,129,1,0,11,4,112,133,226,7,0,220,231,192,0,16,227,
  4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,126,1,0,11,36,112,133,226,7,0,220,231,
  192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,123,1,0,11,40,112,133,226,
  7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,122,1,0,11,
  44,112,133,226,7,0,220,231,192,0,16,227,4,0,0,26,7,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,
  119,1,0,11,175,251,255,234,7,160,140,224,8,72,138,229,14,240,160,225,4,224,45,229,143,1,0,235,4,240,157,228,
  7,160,140,224,220,71,138,229,228,71,138,229,14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,
  84,72,138,229,92,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,44,72,138,229,
  14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,88,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,
  8,72,138,229,12,72,138,229,52,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,44,72,138,229,88,72,138,229,
  14,240,160,225,7,160,140,224,12,72,138,229,52,72,138,229,88,72,138,229,14,240,160,225,7,160,140,224,44,72,138,229,
  52,72,138,229,88,72,138,229,14,240,160,225,4,224,45,229,75,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  48,72,138,229,114,1,0,235,179,1,0,235,4,240,157,228,4,224,45,229,110,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,48,72,138,229,61,1,0,235,214,1,0,235,4,240,157,228,4,224,45,229,167,1,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,48,72,138,229,52,1,0,235,205,1,0,235,4,240,157,228,4,224,45,229,202,1,0,235,
  4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,87,1,0,235,152,1,0,235,4,240,157,228,4,224,45,229,
  39,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,8,72,138,229,44,72,138,229,
  52,72,138,229,88,72,138,229,73,1,0,235,138,1,0,235,4,240,157,228,4,224,45,229,69,1,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,8,72,138,229,44,72,138,229,52,72,138,229,88,72,138,229,
  15,1,0,235,168,1,0,235,4,240,157,228,4,224,45,229,121,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  48,72,138,229,7,160,140,224,8,72,138,229,44,72,138,229,52,72,138,229,88,72,138,229,1,1,0,235,154,1,0,235,
  4,240,157,228,4,224,45,229,151,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,
  8,72,138,229,44,72,138,229,52,72,138,229,88,72,138,229,31,1,0,235,96,1,0,235,4,240,157,228,4,224,45,229,
  7,160,140,224,8,72,138,229,44,72,138,229,52,72,138,229,88,72,138,229,234,0,0,235,21,1,0,235,86,1,0,235,
  129,1,0,235,4,240,157,228,4,224,45,229,250,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,
  33,1,0,235,54,1,0,235,4,240,157,228,4,224,45,229,29,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  48,72,138,229,236,0,0,235,89,1,0,235,4,240,157,228,4,224,45,229,42,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,48,72,138,229,227,0,0,235,80,1,0,235,4,240,157,228,4,224,45,229,77,1,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,48,72,138,229,6,1,0,235,27,1,0,235,4,240,157,228,4,224,45,229,214,0,0,235,
  4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,4,72,138,229,12,72,138,229,84,72,138,229,
  92,72,138,229,248,0,0,235,13,1,0,235,4,240,157,228,4,224,45,229,244,0,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,48,72,138,229,7,160,140,224,4,72,138,229,12,72,138,229,84,72,138,229,92,72,138,229,190,0,0,235,
  43,1,0,235,4,240,157,228,4,224,45,229,252,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,
  7,160,140,224,4,72,138,229,12,72,138,229,84,72,138,229,92,72,138,229,176,0,0,235,29,1,0,235,4,240,157,228,
  4,224,45,229,26,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,48,72,138,229,7,160,140,224,4,72,138,229,
  12,72,138,229,84,72,138,229,92,72,138,229,206,0,0,235,227,0,0,235,4,240,157,228,7,160,140,224,4,72,138,229,
  92,72,138,229,5,0,140,224,40,0,80,229,0,0,80,227,0,0,0,10,12,72,138,229,5,0,140,224,4,0,80,229,
  0,0,80,227,1,0,0,10,7,160,140,224,84,72,138,229,4,224,45,229,144,0,0,235,187,0,0,235,208,0,0,235,
  251,0,0,235,4,240,157,228,7,160,140,224,12,72,138,229,84,72,138,229,5,0,140,224,40,0,80,229,0,0,80,227,
  1,0,0,10,7,160,140,224,4,72,138,229,5,0,140,224,4,0,208,229,0,0,80,227,1,0,0,10,7,160,140,224,
  92,72,138,229,4,224,45,229,123,0,0,235,166,0,0,235,187,0,0,235,230,0,0,235,4,240,157,228,7,160,140,224,
  12,72,138,229,84,72,138,229,5,0,140,224,40,0,208,229,0,0,80,227,1,0,0,10,7,160,140,224,92,72,138,229,
  5,0,140,224,4,0,80,229,0,0,80,227,1,0,0,10,7,160,140,224,4,72,138,229,4,224,45,229,102,0,0,235,
  145,0,0,235,166,0,0,235,209,0,0,235,4,240,157,228,7,160,140,224,4,72,138,229,92,72,138,229,5,0,140,224,
  40,0,208,229,0,0,80,227,1,0,0,10,7,160,140,224,84,72,138,229,5,0,140,224,4,0,208,229,0,0,80,227,
  1,0,0,10,7,160,140,224,12,72,138,229,4,224,45,229,81,0,0,235,124,0,0,235,145,0,0,235,188,0,0,235,
  4,240,157,228,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,44,72,138,229,84,72,138,229,92,72,138,229,
  14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,88,72,138,229,14,240,160,225,7,160,140,224,
  4,72,138,229,8,72,138,229,12,72,138,229,44,72,138,229,84,72,138,229,92,72,138,229,14,240,160,225,7,160,140,224,
  4,72,138,229,44,72,138,229,52,72,138,229,84,72,138,229,14,240,160,225,7,160,140,224,12,72,138,229,44,72,138,229,
  52,72,138,229,92,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,12,72,138,229,44,72,138,229,84,72,138,229,
  88,72,138,229,92,72,138,229,14,240,160,225,7,160,140,224,8,72,138,229,84,72,138,229,88,72,138,229,92,72,138,229,
  14,240,160,225,7,160,140,224,4,72,138,229,12,72,138,229,52,72,138,229,84,72,138,229,88,72,138,229,92,72,138,229,
  14,240,160,225,7,96,160,225,44,96,70,226,6,160,140,224,48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,
  12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,
  180,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,4,72,138,229,14,240,160,225,7,96,160,225,
  40,96,70,226,6,160,140,224,48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,
  0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,52,5,16,229,1,0,80,227,
  2,0,0,186,237,255,255,26,6,160,140,224,8,72,138,229,14,240,160,225,7,96,160,225,36,96,70,226,6,160,140,224,
  48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,
  128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,180,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,
  6,160,140,224,12,72,138,229,14,240,160,225,7,96,160,225,4,96,70,226,6,160,140,224,48,72,138,229,36,4,160,225,
  39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,
  62,0,0,226,128,0,139,224,52,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,44,72,138,229,
  14,240,160,225,7,96,160,225,4,96,134,226,6,160,140,224,48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,
  12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,
  52,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,52,72,138,229,14,240,160,225,7,96,160,225,
  36,96,134,226,6,160,140,224,48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,
  0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,180,3,16,229,1,0,80,227,
  2,0,0,186,237,255,255,26,6,160,140,224,84,72,138,229,14,240,160,225,7,96,160,225,40,96,134,226,6,160,140,224,
  48,72,138,229,36,4,160,225,39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,
  128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,52,3,16,229,1,0,80,227,2,0,0,186,237,255,255,26,
  6,160,140,224,88,72,138,229,14,240,160,225,7,96,160,225,44,96,134,226,6,160,140,224,48,72,138,229,36,4,160,225,
  39,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,
  62,0,0,226,128,0,139,224,180,3,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,92,72,138,229,
  14,240,160,225,7,160,140,224,8,72,138,229,14,240,160,225,4,224,45,229,96,255,255,235,4,240,157,228,7,160,140,224,
  220,71,138,229,228,71,138,229,14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,84,72,138,229,
  92,72,138,229,14,240,160,225,7,160,140,224,4,72,138,229,8,72,138,229,12,72,138,229,44,72,138,229,52,72,138,229,
  88,72,138,229,14,240,160,225,4,224,45,229,52,255,255,235,95,255,255,235,160,255,255,235,203,255,255,235,4,240,157,228,
  4,224,45,229,112,255,255,235,133,255,255,235,176,255,255,235,65,255,255,235,4,240,157,228,4,224,45,229,204,82,159,229,
  30,11,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,168,90,28,229,5,160,140,224,15,2,218,229,
  0,0,80,227,6,0,0,26,2,64,218,229,4,68,160,225,3,64,132,226,0,0,90,229,30,0,0,226,128,0,143,224,
  148,242,144,229,5,80,140,224,172,90,21,229,0,0,85,227,240,255,255,26,182,15,92,229,0,0,80,227,18,0,0,10,
  84,112,160,227,9,144,160,227,5,74,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,
  7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,137,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,
  4,112,135,226,1,144,89,226,240,255,255,26,183,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,
  70,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,38,6,208,229,
  36,20,160,225,1,0,80,225,109,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,
  240,255,255,26,184,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,13,75,160,227,3,64,132,226,
  9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,
  79,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,185,15,92,229,
  0,0,80,227,18,0,0,10,84,112,160,227,9,144,160,227,50,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,
  0,0,80,227,4,0,0,26,7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,50,6,0,139,4,112,135,226,
  1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,240,255,255,26,186,15,92,229,0,0,80,227,18,0,0,10,
  84,112,160,227,7,144,160,227,2,74,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,
  7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,24,6,0,139,4,112,135,226,1,128,88,226,244,255,255,26,
  4,112,135,226,1,144,89,226,240,255,255,26,187,15,92,229,0,0,80,227,18,0,0,10,84,112,160,227,8,144,160,227,
  30,76,160,227,3,64,132,226,9,128,160,227,7,0,220,231,0,0,80,227,4,0,0,26,7,0,140,224,38,6,208,229,
  36,20,160,225,1,0,80,225,255,5,0,139,4,112,135,226,1,128,88,226,244,255,255,26,4,112,135,226,1,144,89,226,
  240,255,255,26,188,15,92,229,0,0,80,227,22,0,0,10,84,112,160,227,8,144,160,227,2,75,160,227,3,64,132,226,
  9,128,160,227,72,80,159,229,1,0,213,228,0,0,80,227,7,0,0,26,7,0,220,231,0,0,80,227,4,0,0,26,
  7,0,140,224,38,6,208,229,36,20,160,225,1,0,80,225,226,5,0,139,4,112,135,226,1,128,88,226,241,255,255,26,
  4,112,135,226,1,144,89,226,236,255,255,26,4,240,157,228,36,31,0,224,117,9,0,224,24,191,0,0,44,193,0,0,
  84,191,0,0,44,193,0,0,156,191,0,0,44,193,0,0,16,192,0,0,44,193,0,0,44,193,0,0,0,0,0,0,
  128,194,0,0,68,196,0,0,112,199,0,0,52,201,0,0,96,204,0,0,96,204,0,0,40,112,133,226,7,0,220,231,
  160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,144,247,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,140,3,0,235,59,255,255,234,5,112,160,225,40,112,135,226,7,0,220,231,
  0,0,80,227,251,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  126,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,125,3,0,235,41,255,255,234,84,112,133,226,
  7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,111,247,255,235,
  36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,113,3,0,235,76,112,133,226,7,0,220,231,160,0,16,227,
  9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,97,247,255,235,36,4,160,225,156,24,92,229,
  1,0,80,225,0,0,0,42,99,3,0,235,12,255,255,234,44,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,82,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,88,3,0,235,40,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,68,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,74,3,0,235,
  36,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  54,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,60,3,0,235,36,112,69,226,7,0,220,231,
  160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,40,247,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,46,3,0,235,44,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,26,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,32,3,0,235,197,254,255,234,44,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,
  36,6,208,229,3,0,80,227,4,0,0,58,11,247,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,
  24,3,0,235,40,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,
  4,0,0,58,253,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,16,3,0,235,36,112,133,226,
  7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,239,246,255,235,
  36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,7,3,0,235,4,112,133,226,7,0,220,231,160,0,16,227,
  9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,225,246,255,235,36,4,160,225,156,24,92,229,
  1,0,80,225,0,0,0,42,255,2,0,235,4,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,
  36,6,208,229,3,0,80,227,4,0,0,58,211,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,
  246,2,0,235,40,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,
  4,0,0,58,197,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,237,2,0,235,112,254,255,234,
  44,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,184,246,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,232,2,0,235,44,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,
  64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,168,246,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,213,2,0,235,36,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,156,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,213,2,0,235,
  36,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,140,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,194,2,0,235,
  36,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,128,246,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,194,2,0,235,36,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,
  64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,112,246,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,175,2,0,235,44,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,100,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,175,2,0,235,
  44,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,84,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,156,2,0,235,
  255,253,255,234,5,160,140,224,104,10,154,229,1,0,45,233,100,10,154,229,1,0,45,233,96,10,154,229,1,0,45,233,
  64,10,154,229,1,0,45,233,56,10,154,229,1,0,45,233,24,10,154,229,1,0,45,233,20,10,154,229,1,0,45,233,
  16,10,154,229,1,0,45,233,44,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  54,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,138,2,0,235,44,112,135,226,7,0,220,231,
  0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  38,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,119,2,0,235,36,112,133,226,10,0,0,234,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,26,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,124,2,0,235,36,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,10,246,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,105,2,0,235,36,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  254,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,110,2,0,235,36,112,71,226,7,0,220,231,
  0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  238,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,91,2,0,235,44,112,69,226,10,0,0,234,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,226,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,96,2,0,235,44,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,210,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,77,2,0,235,40,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,196,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,77,2,0,235,
  4,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  182,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,63,2,0,235,4,112,69,226,7,0,220,231,
  160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,168,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,49,2,0,235,40,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,154,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,35,2,0,235,5,160,140,224,1,0,189,232,16,10,138,229,1,0,189,232,20,10,138,229,1,0,189,232,
  24,10,138,229,1,0,189,232,56,10,138,229,1,0,189,232,64,10,138,229,1,0,189,232,96,10,138,229,1,0,189,232,
  100,10,138,229,1,0,189,232,104,10,138,229,52,253,255,234,40,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,124,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,19,2,0,235,
  40,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,108,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,0,2,0,235,
  4,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,96,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,0,2,0,235,4,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,
  64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,80,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,237,1,0,235,4,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,68,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,237,1,0,235,
  4,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,52,245,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,218,1,0,235,
  40,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,40,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,218,1,0,235,40,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,
  64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,24,245,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,199,1,0,235,195,252,255,234,5,160,140,224,104,10,154,229,1,0,45,233,
  100,10,154,229,1,0,45,233,96,10,154,229,1,0,45,233,64,10,154,229,1,0,45,233,56,10,154,229,1,0,45,233,
  24,10,154,229,1,0,45,233,20,10,154,229,1,0,45,233,16,10,154,229,1,0,45,233,40,112,133,226,10,0,0,234,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,250,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,181,1,0,235,40,112,135,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,234,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,162,1,0,235,4,112,133,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  222,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,167,1,0,235,4,112,135,226,7,0,220,231,
  0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  206,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,148,1,0,235,4,112,69,226,10,0,0,234,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,194,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,153,1,0,235,4,112,71,226,7,0,220,231,0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,178,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,134,1,0,235,40,112,69,226,10,0,0,234,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  166,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,139,1,0,235,40,112,71,226,7,0,220,231,
  0,0,80,227,241,255,255,10,64,0,16,227,9,0,0,10,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  150,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,120,1,0,235,44,112,133,226,7,0,220,231,
  160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,136,244,255,235,36,4,160,225,
  156,24,92,229,1,0,80,225,0,0,0,42,120,1,0,235,36,112,133,226,7,0,220,231,160,0,16,227,9,0,0,26,
  7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,122,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,
  0,0,0,42,126,1,0,235,36,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,
  3,0,80,227,4,0,0,58,108,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,133,1,0,235,
  44,112,69,226,7,0,220,231,160,0,16,227,9,0,0,26,7,0,140,224,36,6,208,229,3,0,80,227,4,0,0,58,
  94,244,255,235,36,4,160,225,156,24,92,229,1,0,80,225,0,0,0,42,140,1,0,235,5,160,140,224,1,0,189,232,
  16,10,138,229,1,0,189,232,20,10,138,229,1,0,189,232,24,10,138,229,1,0,189,232,56,10,138,229,1,0,189,232,
  64,10,138,229,1,0,189,232,96,10,138,229,1,0,189,232,100,10,138,229,1,0,189,232,104,10,138,229,248,251,255,234,
  44,112,133,226,7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,
  134,1,0,11,40,112,133,226,7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,
  32,8,145,225,133,1,0,11,36,112,133,226,7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,
  24,20,90,229,32,8,145,225,130,1,0,11,4,112,133,226,7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,
  34,6,26,229,24,20,90,229,32,8,145,225,129,1,0,11,4,112,69,226,7,0,220,231,160,0,16,227,4,0,0,26,
  7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,126,1,0,11,36,112,69,226,7,0,220,231,160,0,16,227,
  4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,123,1,0,11,40,112,69,226,7,0,220,231,
  160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,122,1,0,11,44,112,69,226,
  7,0,220,231,160,0,16,227,4,0,0,26,7,160,140,224,34,6,26,229,24,20,90,229,32,8,145,225,119,1,0,11,
  175,251,255,234,7,160,140,224,100,74,138,229,14,240,160,225,4,224,45,229,143,1,0,235,4,240,157,228,7,160,140,224,
  144,74,138,229,136,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,24,74,138,229,
  16,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,64,74,138,229,14,240,160,225,
  7,160,140,224,104,74,138,229,100,74,138,229,20,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,
  96,74,138,229,56,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,64,74,138,229,20,74,138,229,14,240,160,225,
  7,160,140,224,96,74,138,229,56,74,138,229,20,74,138,229,14,240,160,225,7,160,140,224,64,74,138,229,56,74,138,229,
  20,74,138,229,14,240,160,225,4,224,45,229,75,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,
  114,1,0,235,179,1,0,235,4,240,157,228,4,224,45,229,110,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  60,74,138,229,61,1,0,235,214,1,0,235,4,240,157,228,4,224,45,229,167,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,60,74,138,229,52,1,0,235,205,1,0,235,4,240,157,228,4,224,45,229,202,1,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,60,74,138,229,87,1,0,235,152,1,0,235,4,240,157,228,4,224,45,229,39,1,0,235,
  4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,100,74,138,229,64,74,138,229,56,74,138,229,
  20,74,138,229,73,1,0,235,138,1,0,235,4,240,157,228,4,224,45,229,69,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,60,74,138,229,7,160,140,224,100,74,138,229,64,74,138,229,56,74,138,229,20,74,138,229,15,1,0,235,
  168,1,0,235,4,240,157,228,4,224,45,229,121,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,
  7,160,140,224,100,74,138,229,64,74,138,229,56,74,138,229,20,74,138,229,1,1,0,235,154,1,0,235,4,240,157,228,
  4,224,45,229,151,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,100,74,138,229,
  64,74,138,229,56,74,138,229,20,74,138,229,31,1,0,235,96,1,0,235,4,240,157,228,7,160,140,224,100,74,138,229,
  64,74,138,229,56,74,138,229,20,74,138,229,4,224,45,229,234,0,0,235,21,1,0,235,86,1,0,235,129,1,0,235,
  4,240,157,228,4,224,45,229,250,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,33,1,0,235,
  54,1,0,235,4,240,157,228,4,224,45,229,29,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,
  236,0,0,235,89,1,0,235,4,240,157,228,4,224,45,229,42,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  60,74,138,229,227,0,0,235,80,1,0,235,4,240,157,228,4,224,45,229,77,1,0,235,4,224,157,228,4,224,45,229,
  5,160,140,224,60,74,138,229,6,1,0,235,27,1,0,235,4,240,157,228,4,224,45,229,214,0,0,235,4,224,157,228,
  4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,104,74,138,229,96,74,138,229,24,74,138,229,16,74,138,229,
  248,0,0,235,13,1,0,235,4,240,157,228,4,224,45,229,244,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,
  60,74,138,229,7,160,140,224,104,74,138,229,96,74,138,229,24,74,138,229,16,74,138,229,190,0,0,235,43,1,0,235,
  4,240,157,228,4,224,45,229,252,0,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,
  104,74,138,229,96,74,138,229,24,74,138,229,16,74,138,229,176,0,0,235,29,1,0,235,4,240,157,228,4,224,45,229,
  26,1,0,235,4,224,157,228,4,224,45,229,5,160,140,224,60,74,138,229,7,160,140,224,104,74,138,229,96,74,138,229,
  24,74,138,229,16,74,138,229,206,0,0,235,227,0,0,235,4,240,157,228,7,160,140,224,104,74,138,229,16,74,138,229,
  5,0,140,224,40,0,208,229,0,0,80,227,0,0,0,10,96,74,138,229,5,0,140,224,4,0,208,229,0,0,80,227,
  1,0,0,10,7,160,140,224,24,74,138,229,4,224,45,229,144,0,0,235,187,0,0,235,208,0,0,235,251,0,0,235,
  4,240,157,228,7,160,140,224,96,74,138,229,24,74,138,229,5,0,140,224,40,0,208,229,0,0,80,227,1,0,0,10,
  7,160,140,224,104,74,138,229,5,0,140,224,4,0,80,229,0,0,80,227,1,0,0,10,7,160,140,224,16,74,138,229,
  4,224,45,229,123,0,0,235,166,0,0,235,187,0,0,235,230,0,0,235,4,240,157,228,7,160,140,224,96,74,138,229,
  24,74,138,229,5,0,140,224,40,0,80,229,0,0,80,227,1,0,0,10,7,160,140,224,16,74,138,229,5,0,140,224,
  4,0,208,229,0,0,80,227,1,0,0,10,7,160,140,224,104,74,138,229,4,224,45,229,102,0,0,235,145,0,0,235,
  166,0,0,235,209,0,0,235,4,240,157,228,7,160,140,224,104,74,138,229,16,74,138,229,5,0,140,224,40,0,80,229,
  0,0,80,227,1,0,0,10,7,160,140,224,24,74,138,229,5,0,140,224,4,0,80,229,0,0,80,227,1,0,0,10,
  7,160,140,224,96,74,138,229,4,224,45,229,81,0,0,235,124,0,0,235,145,0,0,235,188,0,0,235,4,240,157,228,
  7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,64,74,138,229,24,74,138,229,16,74,138,229,14,240,160,225,
  7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,20,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,
  100,74,138,229,96,74,138,229,64,74,138,229,24,74,138,229,16,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,
  64,74,138,229,56,74,138,229,24,74,138,229,14,240,160,225,7,160,140,224,96,74,138,229,64,74,138,229,56,74,138,229,
  16,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,96,74,138,229,64,74,138,229,24,74,138,229,20,74,138,229,
  16,74,138,229,14,240,160,225,7,160,140,224,100,74,138,229,24,74,138,229,20,74,138,229,16,74,138,229,14,240,160,225,
  7,160,140,224,104,74,138,229,96,74,138,229,56,74,138,229,24,74,138,229,20,74,138,229,16,74,138,229,14,240,160,225,
  7,96,160,225,44,96,134,226,6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,
  0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,180,3,16,229,
  1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,104,74,138,229,14,240,160,225,7,96,160,225,40,96,134,226,
  6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,
  245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,52,3,16,229,1,0,80,227,2,0,0,186,
  237,255,255,26,6,160,140,224,100,74,138,229,14,240,160,225,7,96,160,225,36,96,134,226,6,160,140,224,60,74,138,229,
  36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,
  7,0,0,26,62,0,0,226,128,0,139,224,180,3,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,
  96,74,138,229,14,240,160,225,7,96,160,225,4,96,134,226,6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,
  1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,
  128,0,139,224,52,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,64,74,138,229,14,240,160,225,
  7,96,160,225,4,96,70,226,6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,
  0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,52,4,16,229,
  1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,56,74,138,229,14,240,160,225,7,96,160,225,36,96,70,226,
  6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,
  245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,128,0,139,224,180,4,16,229,1,0,80,227,2,0,0,186,
  237,255,255,26,6,160,140,224,24,74,138,229,14,240,160,225,7,96,160,225,40,96,70,226,6,160,140,224,60,74,138,229,
  36,4,160,225,38,22,218,229,1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,
  7,0,0,26,62,0,0,226,128,0,139,224,52,5,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,
  20,74,138,229,14,240,160,225,7,96,160,225,44,96,70,226,6,160,140,224,60,74,138,229,36,4,160,225,38,22,218,229,
  1,0,80,225,12,0,0,42,0,0,90,229,0,0,80,227,245,255,255,10,128,0,16,227,7,0,0,26,62,0,0,226,
  128,0,139,224,180,4,16,229,1,0,80,227,2,0,0,186,237,255,255,26,6,160,140,224,16,74,138,229,14,240,160,225,
  7,160,140,224,100,74,138,229,14,240,160,225,4,224,45,229,96,255,255,235,4,240,157,228,7,160,140,224,144,74,138,229,
  136,74,138,229,14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,24,74,138,229,16,74,138,229,
  14,240,160,225,7,160,140,224,104,74,138,229,100,74,138,229,96,74,138,229,64,74,138,229,56,74,138,229,20,74,138,229,
  14,240,160,225,4,224,45,229,52,255,255,235,95,255,255,235,160,255,255,235,203,255,255,235,4,240,157,228,4,224,45,229,
  112,255,255,235,133,255,255,235,176,255,255,235,65,255,255,235,4,240,157,228,40,0,86,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,120,48,131,226,39,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,27,6,0,234,
  0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,
  40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,
  64,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,4,6,0,234,84,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,75,48,131,226,83,16,86,229,15,0,160,227,144,1,10,224,
  10,64,132,224,76,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,75,48,131,226,75,16,86,229,
  15,0,160,227,144,1,10,224,10,64,132,224,239,5,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,105,48,131,226,43,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,44,0,214,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,
  40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,21,0,160,227,
  144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,
  35,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,105,48,131,226,37,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,188,5,0,234,36,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,35,16,86,229,16,0,160,227,144,1,10,224,
  10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,37,16,214,229,
  16,0,160,227,144,1,10,224,10,64,132,224,167,5,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,120,48,131,226,43,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,39,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,
  40,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,41,16,214,229,24,0,160,227,
  144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,
  35,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,120,48,131,226,3,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,4,0,214,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,5,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,
  106,5,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,
  21,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,
  105,48,131,226,39,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,36,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,35,16,86,229,21,0,160,227,144,1,10,224,
  10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,3,16,86,229,
  21,0,160,227,144,1,10,224,10,64,132,224,4,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,
  105,48,131,226,5,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,45,5,0,234,4,0,86,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,3,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,
  4,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,5,16,214,229,16,0,160,227,
  144,1,10,224,10,64,132,224,24,5,0,234,40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,
  80,48,131,226,39,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,80,48,131,226,41,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,4,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,3,16,86,229,16,0,160,227,144,1,10,224,
  10,64,132,224,4,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,5,16,214,229,
  16,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,
  1,0,215,229,0,16,129,224,50,48,131,226,44,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,
  4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,
  10,64,132,224,0,16,160,227,44,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,
  35,48,131,226,44,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,
  10,16,129,224,64,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,
  36,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,36,112,71,226,
  0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,
  0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,36,112,134,226,0,0,87,229,
  0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,36,112,135,226,0,0,87,229,0,0,80,227,
  248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,35,48,131,226,
  7,0,160,227,144,1,10,224,10,64,132,224,151,4,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,80,48,131,226,43,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,44,0,214,229,128,0,16,227,
  6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,45,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,
  36,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,35,16,86,229,16,0,160,227,
  144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,
  37,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,
  6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,
  128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,
  144,1,10,224,10,64,132,224,0,16,160,227,40,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,40,48,131,226,40,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,40,48,131,226,8,0,160,227,144,1,10,224,10,64,132,224,
  0,16,160,227,4,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,
  4,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,
  64,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,4,112,134,226,
  0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,4,112,135,226,0,0,87,229,
  0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,
  35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,22,4,0,234,44,0,86,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,44,0,214,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,1,4,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,
  43,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,44,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,80,48,131,226,45,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,236,3,0,234,40,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,21,0,160,227,144,1,10,224,
  10,64,132,224,225,3,0,234,44,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,
  43,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,214,3,0,234,44,0,86,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,203,3,0,234,
  40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,39,16,86,229,24,0,160,227,
  144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,
  41,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,182,3,0,234,40,0,86,229,128,0,16,227,6,0,0,26,
  64,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,161,3,0,234,40,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,80,48,131,226,
  39,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,64,0,16,227,
  0,0,0,26,80,48,131,226,41,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,140,3,0,234,36,0,86,229,
  128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,120,48,131,226,35,16,86,229,24,0,160,227,144,1,10,224,
  10,64,132,224,129,3,0,234,36,0,86,229,128,0,16,227,6,0,0,26,64,0,16,227,0,0,0,26,105,48,131,226,
  35,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,118,3,0,234,0,16,160,227,44,112,70,226,0,0,87,229,
  0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,44,112,71,226,0,0,87,229,0,0,80,227,
  248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,50,48,131,226,
  10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,
  1,0,215,229,0,16,129,224,35,48,131,226,44,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,
  4,0,0,26,1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,
  10,64,132,224,73,3,0,234,0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,50,48,131,226,40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,64,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,
  0,16,160,227,40,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,40,48,131,226,
  40,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,
  64,0,16,227,0,0,0,26,40,48,131,226,8,0,160,227,144,1,10,224,10,64,132,224,28,3,0,234,40,0,214,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,41,16,214,229,24,0,160,227,144,1,10,224,
  10,64,132,224,45,3,0,234,0,16,160,227,40,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,50,48,131,226,40,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,
  22,3,0,234,84,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,75,48,131,226,85,16,214,229,
  15,0,160,227,144,1,10,224,10,64,132,224,76,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  75,48,131,226,77,16,214,229,15,0,160,227,144,1,10,224,10,64,132,224,1,3,0,234,44,0,214,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,
  44,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,21,0,160,227,
  144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,
  41,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,105,48,131,226,37,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,35,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,
  206,2,0,234,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,37,16,214,229,
  16,0,160,227,144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  80,48,131,226,35,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,185,2,0,234,44,0,214,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,45,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,
  40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,41,16,214,229,24,0,160,227,
  144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,
  39,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,120,48,131,226,37,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,4,0,214,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,5,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,
  4,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,3,16,86,229,24,0,160,227,
  144,1,10,224,10,64,132,224,124,2,0,234,44,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,40,0,214,229,128,0,16,227,6,0,0,26,
  32,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,21,0,160,227,144,1,10,224,
  10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,37,16,214,229,
  21,0,160,227,144,1,10,224,10,64,132,224,4,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  105,48,131,226,5,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,
  32,0,16,227,0,0,0,26,105,48,131,226,3,16,86,229,21,0,160,227,144,1,10,224,10,64,132,224,63,2,0,234,
  4,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,5,16,214,229,16,0,160,227,
  144,1,10,224,10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,
  3,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,42,2,0,234,40,0,214,229,128,0,16,227,6,0,0,26,
  32,0,16,227,0,0,0,26,80,48,131,226,41,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,39,16,86,229,16,0,160,227,144,1,10,224,
  10,64,132,224,4,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,5,16,214,229,
  16,0,160,227,144,1,10,224,10,64,132,224,4,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,
  80,48,131,226,3,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,134,226,0,0,87,229,
  0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,44,112,135,226,0,0,87,229,0,0,80,227,
  248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,50,48,131,226,
  10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,
  1,0,215,229,0,16,129,224,35,48,131,226,44,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,
  4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,
  10,64,132,224,0,16,160,227,36,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,
  50,48,131,226,36,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,
  10,16,129,224,32,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,
  36,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,36,112,71,226,
  0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,
  0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,169,1,0,234,44,0,214,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,45,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,
  44,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,43,16,86,229,16,0,160,227,
  144,1,10,224,10,64,132,224,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,
  37,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,36,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,80,48,131,226,35,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,40,112,134,226,
  0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,40,112,135,226,0,0,87,229,
  0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,
  50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,
  6,0,0,26,1,0,215,229,0,16,129,224,40,48,131,226,40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,
  128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,40,48,131,226,8,0,160,227,
  144,1,10,224,10,64,132,224,0,16,160,227,4,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,35,48,131,226,4,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,
  0,16,160,227,4,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,
  4,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,
  32,0,16,227,0,0,0,26,35,48,131,226,7,0,160,227,144,1,10,224,10,64,132,224,40,1,0,234,44,0,214,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,44,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,43,16,86,229,
  21,0,160,227,144,1,10,224,10,64,132,224,19,1,0,234,44,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,80,48,131,226,45,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,44,0,86,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,43,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,
  254,0,0,234,40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,
  21,0,160,227,144,1,10,224,10,64,132,224,243,0,0,234,44,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,120,48,131,226,45,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,232,0,0,234,44,0,214,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,45,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,221,0,0,234,40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,
  41,16,214,229,24,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,120,48,131,226,39,16,86,229,24,0,160,227,144,1,10,224,10,64,132,224,200,0,0,234,40,0,214,229,
  128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,41,16,214,229,21,0,160,227,144,1,10,224,
  10,64,132,224,40,0,86,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,105,48,131,226,39,16,86,229,
  21,0,160,227,144,1,10,224,10,64,132,224,179,0,0,234,40,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,80,48,131,226,41,16,214,229,16,0,160,227,144,1,10,224,10,64,132,224,40,0,86,229,128,0,16,227,
  6,0,0,26,32,0,16,227,0,0,0,26,80,48,131,226,39,16,86,229,16,0,160,227,144,1,10,224,10,64,132,224,
  158,0,0,234,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,0,0,0,26,120,48,131,226,37,16,214,229,
  24,0,160,227,144,1,10,224,10,64,132,224,147,0,0,234,36,0,214,229,128,0,16,227,6,0,0,26,32,0,16,227,
  0,0,0,26,105,48,131,226,37,16,214,229,21,0,160,227,144,1,10,224,10,64,132,224,136,0,0,234,0,16,160,227,
  44,112,134,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,44,112,135,226,
  0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,
  0,0,0,26,50,48,131,226,10,0,160,227,144,1,10,224,10,64,132,224,0,16,160,227,44,112,70,226,0,0,87,229,
  0,0,80,227,6,0,0,26,1,0,215,229,0,16,129,224,35,48,131,226,44,112,71,226,0,0,87,229,0,0,80,227,
  248,255,255,10,128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,35,48,131,226,
  7,0,160,227,144,1,10,224,10,64,132,224,91,0,0,234,0,16,160,227,40,112,134,226,0,0,87,229,0,0,80,227,
  6,0,0,26,1,0,215,229,0,16,129,224,50,48,131,226,40,112,135,226,0,0,87,229,0,0,80,227,248,255,255,10,
  128,0,16,227,4,0,0,26,1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,50,48,131,226,10,0,160,227,
  144,1,10,224,10,64,132,224,0,16,160,227,40,112,70,226,0,0,87,229,0,0,80,227,6,0,0,26,1,0,215,229,
  0,16,129,224,40,48,131,226,40,112,71,226,0,0,87,229,0,0,80,227,248,255,255,10,128,0,16,227,4,0,0,26,
  1,160,215,229,10,16,129,224,32,0,16,227,0,0,0,26,40,48,131,226,8,0,160,227,144,1,10,224,10,64,132,224,
  46,0,0,234,116,83,159,229,0,0,160,227,131,144,160,227,4,0,197,228,1,144,89,226,252,255,255,26,152,95,28,229,
  5,96,140,224,0,16,86,229,30,16,1,226,129,32,139,224,0,48,160,227,1,0,214,229,52,162,18,229,144,10,4,224,
  13,2,214,229,0,16,129,225,129,0,143,224,176,240,144,229,164,48,131,224,163,49,160,225,180,113,18,229,84,0,69,226,
  0,0,151,231,0,48,131,224,244,1,18,229,0,0,83,225,0,48,160,33,116,2,18,229,163,50,128,224,2,48,198,229,
  152,95,22,229,84,0,85,227,228,255,255,42,148,95,28,229,5,96,140,224,0,16,86,229,30,16,1,226,129,32,139,224,
  0,48,160,227,1,0,214,229,52,162,18,229,144,10,4,224,15,2,214,229,0,16,129,225,129,0,143,224,128,241,144,229,
  164,48,131,224,163,49,160,225,180,113,18,229,109,15,101,226,0,0,151,231,0,48,131,224,244,1,18,229,0,0,83,225,
  0,48,160,33,116,2,18,229,163,50,128,224,2,48,198,229,152,95,22,229,84,0,85,227,228,255,255,42,14,240,160,225,
  212,214,0,0,208,216,0,0,0,215,0,0,196,217,0,0,92,215,0,0,196,217,0,0,176,215,0,0,196,217,0,0,
  196,217,0,0,0,0,0,0,172,219,0,0,12,219,0,0,176,221,0,0,16,221,0,0,252,214,0,0,0,0,0,0,
  252,214,0,0,232,223,0,0,252,214,0,0,20,224,0,0,252,214,0,0,20,224,0,0,20,223,0,0,20,224,0,0,
  20,224,0,0,0,0,0,0,148,225,0,0,148,225,0,0,252,214,0,0,104,223,0,0,252,214,0,0,0,0,0,0,
  212,214,0,0,64,224,0,0,0,215,0,0,148,224,0,0,252,214,0,0,148,224,0,0,188,223,0,0,148,224,0,0,
  148,224,0,0,0,0,0,0,252,214,0,0,232,224,0,0,72,226,0,0,72,226,0,0,252,214,0,0,0,0,0,0,
  252,214,0,0,60,225,0,0,252,214,0,0,104,225,0,0,252,214,0,0,104,225,0,0,40,216,0,0,104,225,0,0,
  104,225,0,0,0,0,0,0,92,220,0,0,92,220,0,0,252,214,0,0,124,216,0,0,252,214,0,0,0,0,0,0,
  252,214,0,0,112,217,0,0,252,214,0,0,100,218,0,0,252,214,0,0,100,218,0,0,252,214,0,0,100,218,0,0,
  100,218,0,0,0,0,0,0,252,214,0,0,184,218,0,0,96,222,0,0,96,222,0,0,252,214,0,0,0,0,0,0,
  252,226,0,0,248,228,0,0,40,227,0,0,236,229,0,0,132,227,0,0,236,229,0,0,216,227,0,0,236,229,0,0,
  236,229,0,0,0,0,0,0,212,231,0,0,52,231,0,0,216,233,0,0,56,233,0,0,36,227,0,0,0,0,0,0,
  36,227,0,0,16,236,0,0,36,227,0,0,60,236,0,0,36,227,0,0,60,236,0,0,60,235,0,0,60,236,0,0,
  60,236,0,0,0,0,0,0,188,237,0,0,188,237,0,0,36,227,0,0,144,235,0,0,36,227,0,0,0,0,0,0,
  252,226,0,0,104,236,0,0,40,227,0,0,188,236,0,0,36,227,0,0,188,236,0,0,228,235,0,0,188,236,0,0,
  188,236,0,0,0,0,0,0,36,227,0,0,16,237,0,0,112,238,0,0,112,238,0,0,36,227,0,0,0,0,0,0,
  36,227,0,0,100,237,0,0,36,227,0,0,144,237,0,0,36,227,0,0,144,237,0,0,80,228,0,0,144,237,0,0,
  144,237,0,0,0,0,0,0,132,232,0,0,132,232,0,0,36,227,0,0,164,228,0,0,36,227,0,0,0,0,0,0,
  36,227,0,0,152,229,0,0,36,227,0,0,140,230,0,0,36,227,0,0,140,230,0,0,36,227,0,0,140,230,0,0,
  140,230,0,0,0,0,0,0,36,227,0,0,224,230,0,0,136,234,0,0,136,234,0,0,36,227,0,0,0,0,0,0,
  234,20,0,224,4,224,45,229,220,122,28,229,84,80,160,227,9,144,160,227,9,128,160,227,0,3,45,233,5,160,140,224,
  38,54,218,229,39,70,218,229,104,0,83,227,104,48,160,35,104,0,84,227,104,64,160,35,36,6,218,229,37,22,218,229,
  1,0,80,225,1,0,0,10,10,64,132,34,10,48,131,50,1,16,218,229,145,4,0,224,32,114,135,224,145,3,0,224,
  32,114,71,224,128,4,45,233,36,102,218,229,37,118,218,229,60,26,218,229,1,112,135,224,73,28,218,229,75,44,218,229,
  85,62,218,229,87,78,218,229,80,235,255,235,128,4,189,232,104,0,80,227,104,0,160,35,1,16,218,229,144,1,2,224,
  162,114,135,224,128,4,45,233,36,102,218,229,37,118,218,229,48,24,218,229,1,96,134,224,73,28,218,229,75,44,218,229,
  85,62,218,229,87,78,218,229,28,235,255,235,128,4,189,232,104,0,80,227,104,0,160,35,1,16,218,229,144,1,2,224,
  162,114,71,224,0,3,189,232,4,80,133,226,1,128,88,226,200,255,255,26,4,80,133,226,1,144,89,226,196,255,255,26,
  71,114,160,225,220,122,12,229,4,240,157,228,4,224,45,229,168,95,28,229,124,218,255,235,0,0,160,227,5,0,204,231,
  168,111,28,229,6,80,160,225,64,0,0,235,152,8,12,229,16,144,160,227,44,80,70,226,60,0,0,235,40,80,70,226,
  58,0,0,235,36,80,70,226,56,0,0,235,4,80,70,226,54,0,0,235,4,80,134,226,52,0,0,235,36,80,134,226,
  50,0,0,235,40,80,134,226,48,0,0,235,44,80,134,226,46,0,0,235,168,95,28,229,92,0,160,227,5,0,204,231,
  73,218,255,235,3,24,160,227,152,40,28,229,130,32,137,224,96,2,0,235,0,0,96,226,216,10,12,229,164,95,28,229,
  89,218,255,235,0,0,160,227,5,0,204,231,164,111,28,229,6,80,160,225,58,1,0,235,152,8,12,229,16,144,160,227,
  44,80,70,226,54,1,0,235,40,80,70,226,52,1,0,235,36,80,70,226,50,1,0,235,4,80,70,226,48,1,0,235,
  4,80,134,226,46,1,0,235,36,80,134,226,44,1,0,235,40,80,134,226,42,1,0,235,44,80,134,226,40,1,0,235,
  164,95,28,229,60,0,160,227,5,0,204,231,38,218,255,235,3,24,160,227,152,40,28,229,130,32,137,224,61,2,0,235,
  216,26,28,229,0,16,129,224,216,26,12,229,4,240,157,228,4,224,45,229,5,160,140,224,0,0,90,229,192,0,16,227,
  21,1,0,26,36,6,26,229,22,20,90,229,32,8,145,225,17,1,0,26,0,112,160,227,8,128,160,227,60,10,218,229,
  0,0,80,227,4,128,136,2,44,64,90,229,128,0,20,227,28,0,0,26,248,21,218,229,249,37,218,229,68,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  176,8,208,229,0,112,135,224,16,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,136,8,208,229,0,112,135,224,64,0,20,227,3,0,0,26,80,6,26,229,66,20,90,229,
  32,8,145,225,6,128,136,2,40,64,90,229,128,0,20,227,28,0,0,26,252,21,218,229,253,37,218,229,64,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  48,8,208,229,0,112,135,224,20,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,8,8,208,229,0,112,135,224,64,0,20,227,3,0,0,26,76,6,26,229,62,20,90,229,
  32,8,145,225,6,128,136,2,36,64,90,229,128,0,20,227,28,0,0,26,0,22,218,229,1,38,218,229,60,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  176,7,208,229,0,112,135,224,24,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,136,7,208,229,0,112,135,224,64,0,20,227,3,0,0,26,72,6,26,229,58,20,90,229,
  32,8,145,225,6,128,136,2,4,64,90,229,128,0,20,227,28,0,0,26,32,22,218,229,33,38,218,229,28,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  61,7,208,229,0,112,135,224,56,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,21,7,208,229,0,112,135,224,64,0,20,227,3,0,0,26,40,6,26,229,26,20,90,229,
  32,8,145,225,5,128,136,2,4,64,218,229,128,0,20,227,28,0,0,26,40,22,218,229,41,38,218,229,20,4,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  189,6,208,229,0,112,135,224,64,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,149,6,208,229,0,112,135,224,64,0,20,227,3,0,0,26,32,6,26,229,18,20,90,229,
  32,8,145,225,5,128,136,2,36,64,218,229,128,0,20,227,28,0,0,26,72,22,218,229,73,38,218,229,244,3,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  74,6,208,229,0,112,135,224,96,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,34,6,208,229,0,112,135,224,64,0,20,227,3,0,0,26,0,6,26,229,242,19,90,229,
  32,8,145,225,3,128,136,2,40,64,218,229,128,0,20,227,28,0,0,26,76,22,218,229,77,38,218,229,240,3,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  202,5,208,229,0,112,135,224,100,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,162,5,208,229,0,112,135,224,64,0,20,227,3,0,0,26,252,5,26,229,238,19,90,229,
  32,8,145,225,3,128,136,2,44,64,218,229,128,0,20,227,28,0,0,26,80,22,218,229,81,38,218,229,236,3,90,229,
  253,0,16,227,3,16,65,18,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,
  74,5,208,229,0,112,135,224,104,10,218,229,0,32,130,224,1,0,66,224,3,0,144,226,0,0,160,67,12,0,80,227,
  12,0,160,35,0,0,143,224,34,5,208,229,0,112,135,224,64,0,20,227,3,0,0,26,248,5,26,229,234,19,90,229,
  32,8,145,225,3,128,136,2,167,112,160,225,20,0,88,227,20,128,160,35,20,0,160,227,144,7,1,224,8,32,160,225,
  36,1,0,235,128,32,128,226,1,24,160,227,33,1,0,235,0,0,89,225,0,144,160,49,4,240,157,228,16,0,160,227,
  4,240,157,228,4,224,45,229,5,160,140,224,0,0,90,229,160,0,16,227,21,1,0,26,34,6,26,229,24,20,90,229,
  32,8,145,225,17,1,0,26,0,112,160,227,8,128,160,227,48,8,218,229,0,0,80,227,4,128,136,2,44,64,218,229,
  128,0,20,227,28,0,0,26,80,22,218,229,81,38,218,229,234,3,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,60,4,208,229,0,112,135,224,92,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,20,4,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,246,5,26,229,236,19,90,229,32,8,145,225,6,128,136,2,40,64,218,229,
  128,0,20,227,28,0,0,26,76,22,218,229,77,38,218,229,238,3,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,188,3,208,229,0,112,135,224,88,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,148,3,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,250,5,26,229,240,19,90,229,32,8,145,225,6,128,136,2,36,64,218,229,
  128,0,20,227,28,0,0,26,72,22,218,229,73,38,218,229,242,3,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,60,3,208,229,0,112,135,224,84,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,20,3,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,254,5,26,229,244,19,90,229,32,8,145,225,6,128,136,2,4,64,218,229,
  128,0,20,227,28,0,0,26,40,22,218,229,41,38,218,229,18,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,201,2,208,229,0,112,135,224,52,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,161,2,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,30,6,26,229,20,20,90,229,32,8,145,225,5,128,136,2,4,64,90,229,
  128,0,20,227,28,0,0,26,32,22,218,229,33,38,218,229,26,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,73,2,208,229,0,112,135,224,44,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,33,2,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,38,6,26,229,28,20,90,229,32,8,145,225,5,128,136,2,36,64,90,229,
  128,0,20,227,28,0,0,26,0,22,218,229,1,38,218,229,58,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,214,1,208,229,0,112,135,224,12,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,174,1,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,70,6,26,229,60,20,90,229,32,8,145,225,3,128,136,2,40,64,90,229,
  128,0,20,227,28,0,0,26,252,21,218,229,253,37,218,229,62,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,86,1,208,229,0,112,135,224,8,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,46,1,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,74,6,26,229,64,20,90,229,32,8,145,225,3,128,136,2,44,64,90,229,
  128,0,20,227,28,0,0,26,248,21,218,229,249,37,218,229,66,4,90,229,253,0,16,227,3,32,66,18,2,0,65,224,
  3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,214,0,208,229,0,112,135,224,4,8,218,229,
  0,16,129,224,2,0,65,224,3,0,144,226,0,0,160,67,12,0,80,227,12,0,160,35,0,0,143,224,174,0,208,229,
  0,112,135,224,32,0,20,227,3,0,0,26,78,6,26,229,68,20,90,229,32,8,145,225,3,128,136,2,167,112,160,225,
  20,0,88,227,20,128,160,35,20,0,160,227,144,7,1,224,8,32,160,225,7,0,0,235,128,32,128,226,1,24,160,227,
  4,0,0,235,0,0,89,225,0,144,160,49,4,240,157,228,16,0,160,227,4,240,157,228,1,48,160,227,2,0,81,225,
  2,0,0,58,130,32,160,225,131,48,160,225,250,255,255,234,0,0,160,227,2,0,81,225,1,0,0,58,2,16,65,224,
  3,0,128,224,162,32,160,225,163,48,176,225,248,255,255,26,14,240,160,225,0,0,0,60,60,75,180,180,225,225,225,225,
  225,0,0,0,40,40,50,120,120,150,150,150,150,150,0,0,0,20,20,25,60,60,75,75,75,75,75,0,0,0,0,0,
  0,30,30,37,90,90,112,112,4,224,45,229,168,111,28,229,6,80,160,225,45,0,0,235,128,144,160,225,0,128,160,227,
  44,80,70,226,38,0,0,235,40,80,70,226,36,0,0,235,36,80,70,226,34,0,0,235,4,80,70,226,32,0,0,235,
  4,80,134,226,30,0,0,235,36,80,134,226,28,0,0,235,40,80,134,226,26,0,0,235,44,80,134,226,24,0,0,235,
  8,144,137,224,164,111,28,229,6,80,160,225,40,0,0,235,128,144,73,224,0,128,160,227,44,80,70,226,33,0,0,235,
  40,80,70,226,31,0,0,235,36,80,70,226,29,0,0,235,4,80,70,226,27,0,0,235,4,80,134,226,25,0,0,235,
  36,80,134,226,23,0,0,235,40,80,134,226,21,0,0,235,44,80,134,226,19,0,0,235,8,144,73,224,208,154,12,229,
  4,240,157,228,5,0,220,231,192,0,16,227,11,0,0,26,5,160,140,224,36,6,26,229,22,20,90,229,32,8,129,225,
  60,26,218,229,1,0,144,225,4,0,0,26,5,0,143,224,92,0,144,229,0,0,88,225,0,128,160,49,14,240,160,225,
  0,0,160,227,14,240,160,225,5,0,220,231,160,0,16,227,12,0,0,26,5,160,140,224,34,6,26,229,24,20,90,229,
  32,8,129,225,48,24,218,229,1,0,144,225,5,0,0,26,130,15,101,226,0,0,143,224,20,0,144,229,0,0,88,225,
  0,128,160,49,14,240,160,225,0,0,160,227,14,240,160,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,
  244,1,0,0,244,1,0,0,0,0,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,
  244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,0,0,0,0,244,1,0,0,244,1,0,0,244,1,0,0,
  244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,244,1,0,0,0,0,0,0,44,1,0,0,
  44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,44,1,0,0,
  0,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,200,0,0,0,
  200,0,0,0,200,0,0,0,0,0,0,0,22,0,0,0,22,0,0,0,22,0,0,0,4,0,0,0,4,0,0,0,
  4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,22,0,0,0,14,0,0,0,
  4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,
  28,0,0,0,14,0,0,0,10,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,
  0,0,0,0,4,0,0,0,4,0,0,0,16,0,0,0,12,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,
  4,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,224,45,229,
  152,81,159,229,0,0,160,227,131,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,0,16,160,227,196,15,92,229,
  0,1,139,224,116,1,16,229,0,16,129,224,188,15,92,229,0,1,139,224,116,1,16,229,0,16,65,224,195,15,92,229,
  0,1,139,224,40,1,16,229,0,16,129,224,187,15,92,229,0,1,139,224,40,1,16,229,0,16,65,224,194,15,92,229,
  0,1,139,224,20,1,16,229,0,16,129,224,186,15,92,229,0,1,139,224,20,1,16,229,0,16,65,224,193,15,92,229,
  0,1,139,224,0,1,16,229,0,16,129,224,185,15,92,229,0,1,139,224,0,1,16,229,0,16,65,224,192,15,92,229,
  0,1,139,224,236,0,16,229,0,16,129,224,184,15,92,229,0,1,139,224,236,0,16,229,0,16,65,224,191,15,92,229,
  0,1,139,224,216,0,16,229,0,16,129,224,183,15,92,229,0,1,139,224,216,0,16,229,0,16,65,224,190,15,92,229,
  0,1,139,224,204,0,16,229,0,16,129,224,182,15,92,229,0,1,139,224,204,0,16,229,0,16,65,224,129,2,160,225,
  224,10,12,229,152,95,28,229,37,0,0,235,140,8,28,229,0,49,131,224,136,8,28,229,0,0,80,227,1,0,0,26,
  1,0,160,227,9,2,70,229,224,10,28,229,3,0,128,224,224,10,12,229,24,52,134,229,192,0,20,229,163,50,128,224,
  2,48,198,229,152,95,22,229,84,0,85,227,237,255,255,42,148,95,28,229,56,0,0,235,140,8,28,229,0,49,131,224,
  136,8,28,229,0,0,80,227,1,0,0,26,1,0,160,227,9,2,70,229,224,10,28,229,3,0,64,224,224,10,12,229,
  24,52,134,229,192,0,20,229,163,50,128,224,2,48,198,229,152,95,22,229,84,0,85,227,237,255,255,42,4,240,157,228,
  0,25,0,224,4,224,45,229,0,0,160,227,148,8,12,229,144,8,12,229,140,8,12,229,136,8,12,229,5,96,140,224,
  0,16,86,229,30,16,1,226,129,64,139,224,1,48,214,229,128,0,20,229,144,3,3,224,13,2,214,229,0,16,129,225,
  129,0,143,224,236,240,144,229,180,17,20,229,84,0,69,226,0,0,145,231,35,50,128,224,0,0,86,229,92,0,80,227,
  12,0,0,10,136,8,28,229,0,0,80,227,2,0,0,26,64,16,20,229,0,0,81,227,51,49,67,16,148,8,28,229,
  0,48,131,224,244,1,20,229,0,0,83,225,0,48,160,193,0,0,83,227,0,48,160,179,4,240,157,228,4,224,45,229,
  0,0,160,227,148,8,12,229,144,8,12,229,140,8,12,229,136,8,12,229,5,96,140,224,0,16,86,229,30,16,1,226,
  129,64,139,224,1,48,214,229,128,0,20,229,144,3,3,224,15,2,214,229,0,16,129,225,129,0,143,224,148,241,144,229,
  180,17,20,229,109,15,101,226,0,0,145,231,35,50,128,224,0,0,86,229,60,0,80,227,12,0,0,10,136,8,28,229,
  0,0,80,227,2,0,0,26,64,16,20,229,0,0,81,227,51,49,67,16,148,8,28,229,0,48,131,224,244,1,20,229,
  0,0,83,225,0,48,160,193,0,0,83,227,0,48,160,179,4,240,157,228,36,9,1,0,60,11,1,0,84,9,1,0,
  72,12,1,0,164,9,1,0,72,12,1,0,0,10,1,0,72,12,1,0,72,12,1,0,0,0,0,0,96,14,1,0,
  176,13,1,0,68,16,1,0,148,15,1,0,120,17,1,0,0,0,0,0,80,9,1,0,112,18,1,0,80,9,1,0,
  160,18,1,0,80,9,1,0,160,18,1,0,136,17,1,0,160,18,1,0,160,18,1,0,0,0,0,0,68,20,1,0,
  68,20,1,0,80,9,1,0,228,17,1,0,80,9,1,0,0,0,0,0,36,9,1,0,208,18,1,0,84,9,1,0,
  44,19,1,0,80,9,1,0,44,19,1,0,64,18,1,0,44,19,1,0,44,19,1,0,0,0,0,0,80,9,1,0,
  136,19,1,0,224,20,1,0,224,20,1,0,80,9,1,0,0,0,0,0,80,9,1,0,228,19,1,0,80,9,1,0,
  20,20,1,0,80,9,1,0,20,20,1,0,132,10,1,0,20,20,1,0,20,20,1,0,0,0,0,0,248,14,1,0,
  248,14,1,0,80,9,1,0,224,10,1,0,80,9,1,0,0,0,0,0,80,9,1,0,236,11,1,0,80,9,1,0,
  248,12,1,0,80,9,1,0,248,12,1,0,80,9,1,0,248,12,1,0,248,12,1,0,0,0,0,0,80,9,1,0,
  84,13,1,0,220,16,1,0,220,16,1,0,80,9,1,0,0,0,0,0,124,21,1,0,148,23,1,0,172,21,1,0,
  160,24,1,0,252,21,1,0,160,24,1,0,88,22,1,0,160,24,1,0,160,24,1,0,0,0,0,0,184,26,1,0,
  8,26,1,0,156,28,1,0,236,27,1,0,208,29,1,0,0,0,0,0,168,21,1,0,200,30,1,0,168,21,1,0,
  248,30,1,0,168,21,1,0,248,30,1,0,224,29,1,0,248,30,1,0,248,30,1,0,0,0,0,0,156,32,1,0,
  156,32,1,0,168,21,1,0,60,30,1,0,168,21,1,0,0,0,0,0,124,21,1,0,40,31,1,0,172,21,1,0,
  132,31,1,0,168,21,1,0,132,31,1,0,152,30,1,0,132,31,1,0,132,31,1,0,0,0,0,0,168,21,1,0,
  224,31,1,0,56,33,1,0,56,33,1,0,168,21,1,0,0,0,0,0,168,21,1,0,60,32,1,0,168,21,1,0,
  108,32,1,0,168,21,1,0,108,32,1,0,220,22,1,0,108,32,1,0,108,32,1,0,0,0,0,0,80,27,1,0,
  80,27,1,0,168,21,1,0,56,23,1,0,168,21,1,0,0,0,0,0,168,21,1,0,68,24,1,0,168,21,1,0,
  80,25,1,0,168,21,1,0,80,25,1,0,168,21,1,0,80,25,1,0,80,25,1,0,0,0,0,0,168,21,1,0,
  172,25,1,0,52,29,1,0,52,29,1,0,168,21,1,0,0,0,0,0,0,0,88,229,32,0,16,227,26,0,0,10,
  28,0,0,226,128,16,139,224,192,16,17,229,192,32,20,229,1,0,82,225,1,32,160,177,129,16,114,224,2,0,0,74,
  148,8,28,229,1,0,128,224,148,8,12,229,2,16,216,229,2,32,214,229,153,8,92,229,0,32,82,224,0,32,160,51,
  2,16,81,224,8,0,0,218,144,8,28,229,1,0,80,225,2,0,0,170,144,24,12,229,140,8,12,229,14,240,160,225,
  140,8,28,229,1,0,80,225,140,24,12,181,14,240,160,225,0,0,88,229,64,0,16,227,26,0,0,10,28,0,0,226,
  128,16,139,224,192,16,17,229,192,32,20,229,1,0,82,225,1,32,160,177,129,16,114,224,2,0,0,74,148,8,28,229,
  1,0,128,224,148,8,12,229,2,16,216,229,2,32,214,229,154,8,92,229,0,32,82,224,0,32,160,51,2,16,81,224,
  8,0,0,218,144,8,28,229,1,0,80,225,2,0,0,170,144,24,12,229,140,8,12,229,14,240,160,225,140,8,28,229,
  1,0,80,225,140,24,12,181,14,240,160,225,4,224,45,229,174,229,255,235,25,230,255,235,0,32,160,227,2,16,214,229,
  4,16,65,226,155,8,92,229,1,0,80,225,13,0,0,58,0,0,88,229,64,0,16,227,10,0,0,26,40,32,130,226,
  136,8,28,229,1,0,128,226,136,8,12,229,153,24,92,229,155,8,92,229,0,16,65,224,5,0,81,227,6,0,0,186,
  24,32,130,226,4,0,0,234,153,24,92,229,155,8,92,229,0,16,65,224,5,0,81,227,48,32,130,162,153,8,92,229,
  0,0,80,227,1,0,0,10,128,32,130,226,5,0,0,234,72,12,216,229,0,1,85,225,2,0,0,26,120,32,130,226,
  2,0,214,229,0,32,66,224,1,16,216,229,145,2,0,224,160,147,137,224,4,240,157,228,4,224,45,229,63,229,255,235,
  202,229,255,235,0,32,160,227,2,16,214,229,4,16,65,226,156,8,92,229,1,0,80,225,13,0,0,58,0,0,88,229,
  32,0,16,227,10,0,0,26,40,32,130,226,136,8,28,229,1,0,128,226,136,8,12,229,154,24,92,229,156,8,92,229,
  0,16,65,224,5,0,81,227,6,0,0,186,24,32,130,226,4,0,0,234,154,24,92,229,156,8,92,229,0,16,65,224,
  5,0,81,227,48,32,130,162,154,8,92,229,0,0,80,227,1,0,0,10,128,32,130,226,5,0,0,234,84,14,216,229,
  0,1,85,225,2,0,0,26,120,32,130,226,2,0,214,229,0,32,66,224,1,16,216,229,145,2,0,224,160,147,137,224,
  4,240,157,228,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,162,255,255,235,
  99,255,255,235,24,0,160,227,153,0,1,224,1,48,131,224,132,254,255,234,0,144,160,227,40,112,69,226,7,128,140,224,
  0,0,88,229,0,0,80,227,5,0,0,26,150,255,255,235,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,
  249,255,255,10,128,0,16,227,1,0,0,26,142,255,255,235,79,255,255,235,10,0,160,227,153,0,1,224,1,48,131,224,
  112,254,255,234,84,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,84,112,69,226,7,128,140,224,130,255,255,235,
  67,255,255,235,15,0,160,227,153,0,1,224,1,48,131,224,76,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  76,112,69,226,7,128,140,224,119,255,255,235,56,255,255,235,15,0,160,227,153,0,1,224,1,48,131,224,89,254,255,234,
  44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,107,255,255,235,44,255,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,
  7,128,140,224,96,255,255,235,33,255,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,85,255,255,235,22,255,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,74,255,255,235,
  11,255,255,235,21,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,
  36,112,133,226,7,128,140,224,63,255,255,235,0,255,255,235,21,0,160,227,153,0,1,224,1,48,131,224,33,254,255,234,
  36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,51,255,255,235,244,254,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,
  7,128,140,224,40,255,255,235,233,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,10,254,255,234,44,0,86,229,
  128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,28,255,255,235,221,254,255,235,24,0,160,227,
  153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,
  17,255,255,235,210,254,255,235,24,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,133,226,7,128,140,224,6,255,255,235,199,254,255,235,24,0,160,227,153,0,1,224,1,48,131,224,
  36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,251,254,255,235,188,254,255,235,
  24,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,69,226,
  7,128,140,224,240,254,255,235,177,254,255,235,24,0,160,227,153,0,1,224,1,48,131,224,4,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,229,254,255,235,166,254,255,235,24,0,160,227,153,0,1,224,
  1,48,131,224,199,253,255,234,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,
  217,254,255,235,154,254,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,69,226,7,128,140,224,206,254,255,235,143,254,255,235,21,0,160,227,153,0,1,224,1,48,131,224,
  40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,195,254,255,235,132,254,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,
  7,128,140,224,184,254,255,235,121,254,255,235,21,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,4,112,69,226,7,128,140,224,173,254,255,235,110,254,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,162,254,255,235,
  99,254,255,235,21,0,160,227,153,0,1,224,1,48,131,224,132,253,255,234,4,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,4,112,69,226,7,128,140,224,150,254,255,235,87,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,139,254,255,235,76,254,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,109,253,255,234,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  40,112,69,226,7,128,140,224,127,254,255,235,64,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,116,254,255,235,53,254,255,235,16,0,160,227,
  153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,69,226,7,128,140,224,
  105,254,255,235,42,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,4,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,4,112,133,226,7,128,140,224,94,254,255,235,31,254,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  0,144,160,227,44,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,83,254,255,235,44,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,75,254,255,235,12,254,255,235,
  10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,44,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,
  5,0,0,26,64,254,255,235,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,
  1,0,0,26,56,254,255,235,249,253,255,235,7,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,36,112,69,226,
  7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,45,254,255,235,36,112,71,226,7,128,140,224,0,0,88,229,
  0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,37,254,255,235,230,253,255,235,10,0,160,227,153,0,1,224,
  1,48,131,224,0,144,160,227,36,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,26,254,255,235,
  36,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,18,254,255,235,
  211,253,255,235,7,0,160,227,153,0,1,224,1,48,131,224,244,252,255,234,44,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,44,112,69,226,7,128,140,224,6,254,255,235,199,253,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,251,253,255,235,188,253,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,
  7,128,140,224,240,253,255,235,177,253,255,235,16,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,229,253,255,235,166,253,255,235,16,0,160,227,153,0,1,224,
  1,48,131,224,0,144,160,227,40,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,218,253,255,235,
  40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,210,253,255,235,
  147,253,255,235,10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,40,112,133,226,7,128,140,224,0,0,88,229,
  0,0,80,227,5,0,0,26,199,253,255,235,40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,
  128,0,16,227,1,0,0,26,191,253,255,235,128,253,255,235,8,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,
  4,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,180,253,255,235,4,112,71,226,7,128,140,224,
  0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,172,253,255,235,109,253,255,235,7,0,160,227,
  153,0,1,224,1,48,131,224,0,144,160,227,4,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,
  161,253,255,235,4,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,
  153,253,255,235,90,253,255,235,7,0,160,227,153,0,1,224,1,48,131,224,123,252,255,234,136,8,28,229,1,0,128,226,
  136,8,12,229,119,252,255,234,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,
  137,253,255,235,74,253,255,235,21,0,160,227,153,0,1,224,1,48,131,224,44,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,44,112,133,226,7,128,140,224,126,253,255,235,63,253,255,235,21,0,160,227,153,0,1,224,1,48,131,224,
  96,252,255,234,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,114,253,255,235,
  51,253,255,235,16,0,160,227,153,0,1,224,1,48,131,224,44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,
  44,112,133,226,7,128,140,224,103,253,255,235,40,253,255,235,16,0,160,227,153,0,1,224,1,48,131,224,73,252,255,234,
  40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,91,253,255,235,28,253,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,61,252,255,234,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  44,112,69,226,7,128,140,224,79,253,255,235,16,253,255,235,24,0,160,227,153,0,1,224,1,48,131,224,49,252,255,234,
  44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,67,253,255,235,4,253,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,37,252,255,234,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  40,112,69,226,7,128,140,224,55,253,255,235,248,252,255,235,24,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,44,253,255,235,237,252,255,235,24,0,160,227,
  153,0,1,224,1,48,131,224,14,252,255,234,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,
  7,128,140,224,32,253,255,235,225,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,21,253,255,235,214,252,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,247,251,255,234,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,
  9,253,255,235,202,252,255,235,16,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,133,226,7,128,140,224,254,252,255,235,191,252,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  224,251,255,234,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,242,252,255,235,
  179,252,255,235,24,0,160,227,153,0,1,224,1,48,131,224,212,251,255,234,36,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,36,112,69,226,7,128,140,224,230,252,255,235,167,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,
  200,251,255,234,0,144,160,227,44,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,218,252,255,235,
  44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,210,252,255,235,
  147,252,255,235,10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,44,112,133,226,7,128,140,224,0,0,88,229,
  0,0,80,227,5,0,0,26,199,252,255,235,44,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,
  128,0,16,227,1,0,0,26,191,252,255,235,128,252,255,235,7,0,160,227,153,0,1,224,1,48,131,224,161,251,255,234,
  0,144,160,227,40,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,179,252,255,235,40,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,171,252,255,235,108,252,255,235,
  10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,40,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,
  5,0,0,26,160,252,255,235,40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,
  1,0,0,26,152,252,255,235,89,252,255,235,8,0,160,227,153,0,1,224,1,48,131,224,122,251,255,234,40,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,183,252,255,235,108,252,255,235,24,0,160,227,
  153,0,1,224,1,48,131,224,148,251,255,234,0,144,160,227,40,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,
  5,0,0,26,171,252,255,235,40,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,
  1,0,0,26,163,252,255,235,88,252,255,235,10,0,160,227,153,0,1,224,1,48,131,224,128,251,255,234,84,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,84,112,133,226,7,128,140,224,151,252,255,235,76,252,255,235,15,0,160,227,
  153,0,1,224,1,48,131,224,76,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,76,112,133,226,7,128,140,224,
  140,252,255,235,65,252,255,235,15,0,160,227,153,0,1,224,1,48,131,224,105,251,255,234,44,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,128,252,255,235,53,252,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,117,252,255,235,
  42,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,
  40,112,133,226,7,128,140,224,106,252,255,235,31,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,95,252,255,235,20,252,255,235,21,0,160,227,
  153,0,1,224,1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,
  84,252,255,235,9,252,255,235,21,0,160,227,153,0,1,224,1,48,131,224,49,251,255,234,36,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,72,252,255,235,253,251,255,235,16,0,160,227,153,0,1,224,
  1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,69,226,7,128,140,224,61,252,255,235,
  242,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,26,251,255,234,44,0,214,229,128,0,16,227,7,0,0,26,
  0,144,160,227,44,112,133,226,7,128,140,224,49,252,255,235,230,251,255,235,24,0,160,227,153,0,1,224,1,48,131,224,
  40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,38,252,255,235,219,251,255,235,
  24,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,
  7,128,140,224,27,252,255,235,208,251,255,235,24,0,160,227,153,0,1,224,1,48,131,224,36,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,16,252,255,235,197,251,255,235,24,0,160,227,153,0,1,224,
  1,48,131,224,4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,5,252,255,235,
  186,251,255,235,24,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  4,112,69,226,7,128,140,224,250,251,255,235,175,251,255,235,24,0,160,227,153,0,1,224,1,48,131,224,215,250,255,234,
  44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,238,251,255,235,163,251,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,
  7,128,140,224,227,251,255,235,152,251,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,40,112,69,226,7,128,140,224,216,251,255,235,141,251,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,205,251,255,235,
  130,251,255,235,21,0,160,227,153,0,1,224,1,48,131,224,4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,
  4,112,133,226,7,128,140,224,194,251,255,235,119,251,255,235,21,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,
  128,0,16,227,7,0,0,26,0,144,160,227,4,112,69,226,7,128,140,224,183,251,255,235,108,251,255,235,21,0,160,227,
  153,0,1,224,1,48,131,224,148,250,255,234,4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,
  7,128,140,224,171,251,255,235,96,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,4,112,69,226,7,128,140,224,160,251,255,235,85,251,255,235,16,0,160,227,153,0,1,224,
  1,48,131,224,125,250,255,234,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,
  148,251,255,235,73,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,69,226,7,128,140,224,137,251,255,235,62,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,
  4,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,133,226,7,128,140,224,126,251,255,235,51,251,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,4,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,4,112,69,226,
  7,128,140,224,115,251,255,235,40,251,255,235,16,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,44,112,133,226,
  7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,104,251,255,235,44,112,135,226,7,128,140,224,0,0,88,229,
  0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,96,251,255,235,21,251,255,235,10,0,160,227,153,0,1,224,
  1,48,131,224,0,144,160,227,44,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,85,251,255,235,
  44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,77,251,255,235,
  2,251,255,235,7,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,36,112,133,226,7,128,140,224,0,0,88,229,
  0,0,80,227,5,0,0,26,66,251,255,235,36,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,
  128,0,16,227,1,0,0,26,58,251,255,235,239,250,255,235,10,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,
  36,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,47,251,255,235,36,112,71,226,7,128,140,224,
  0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,39,251,255,235,220,250,255,235,7,0,160,227,
  153,0,1,224,1,48,131,224,4,250,255,234,44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,
  7,128,140,224,27,251,255,235,208,250,255,235,16,0,160,227,153,0,1,224,1,48,131,224,44,0,86,229,128,0,16,227,
  7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,16,251,255,235,197,250,255,235,16,0,160,227,153,0,1,224,
  1,48,131,224,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,5,251,255,235,
  186,250,255,235,16,0,160,227,153,0,1,224,1,48,131,224,36,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  36,112,69,226,7,128,140,224,250,250,255,235,175,250,255,235,16,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,
  40,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,239,250,255,235,40,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,231,250,255,235,156,250,255,235,10,0,160,227,
  153,0,1,224,1,48,131,224,0,144,160,227,40,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,
  220,250,255,235,40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,
  212,250,255,235,137,250,255,235,8,0,160,227,153,0,1,224,1,48,131,224,0,144,160,227,4,112,133,226,7,128,140,224,
  0,0,88,229,0,0,80,227,5,0,0,26,201,250,255,235,4,112,135,226,7,128,140,224,0,0,88,229,0,0,80,227,
  249,255,255,10,128,0,16,227,1,0,0,26,193,250,255,235,118,250,255,235,7,0,160,227,153,0,1,224,1,48,131,224,
  0,144,160,227,4,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,182,250,255,235,4,112,71,226,
  7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,174,250,255,235,99,250,255,235,
  7,0,160,227,153,0,1,224,1,48,131,224,139,249,255,234,136,8,28,229,1,0,128,226,136,8,12,229,135,249,255,234,
  44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,158,250,255,235,83,250,255,235,
  21,0,160,227,153,0,1,224,1,48,131,224,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,
  7,128,140,224,147,250,255,235,72,250,255,235,21,0,160,227,153,0,1,224,1,48,131,224,112,249,255,234,44,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,135,250,255,235,60,250,255,235,16,0,160,227,
  153,0,1,224,1,48,131,224,44,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,69,226,7,128,140,224,
  124,250,255,235,49,250,255,235,16,0,160,227,153,0,1,224,1,48,131,224,89,249,255,234,40,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,112,250,255,235,37,250,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,77,249,255,234,44,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,
  100,250,255,235,25,250,255,235,24,0,160,227,153,0,1,224,1,48,131,224,65,249,255,234,44,0,214,229,128,0,16,227,
  7,0,0,26,0,144,160,227,44,112,133,226,7,128,140,224,88,250,255,235,13,250,255,235,21,0,160,227,153,0,1,224,
  1,48,131,224,53,249,255,234,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,
  76,250,255,235,1,250,255,235,24,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,
  0,144,160,227,40,112,69,226,7,128,140,224,65,250,255,235,246,249,255,235,24,0,160,227,153,0,1,224,1,48,131,224,
  30,249,255,234,40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,53,250,255,235,
  234,249,255,235,21,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,
  40,112,69,226,7,128,140,224,42,250,255,235,223,249,255,235,21,0,160,227,153,0,1,224,1,48,131,224,7,249,255,234,
  40,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,133,226,7,128,140,224,30,250,255,235,211,249,255,235,
  16,0,160,227,153,0,1,224,1,48,131,224,40,0,86,229,128,0,16,227,7,0,0,26,0,144,160,227,40,112,69,226,
  7,128,140,224,19,250,255,235,200,249,255,235,16,0,160,227,153,0,1,224,1,48,131,224,240,248,255,234,36,0,214,229,
  128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,7,128,140,224,7,250,255,235,188,249,255,235,24,0,160,227,
  153,0,1,224,1,48,131,224,228,248,255,234,36,0,214,229,128,0,16,227,7,0,0,26,0,144,160,227,36,112,133,226,
  7,128,140,224,251,249,255,235,176,249,255,235,21,0,160,227,153,0,1,224,1,48,131,224,216,248,255,234,0,144,160,227,
  44,112,133,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,239,249,255,235,44,112,135,226,7,128,140,224,
  0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,231,249,255,235,156,249,255,235,10,0,160,227,
  153,0,1,224,1,48,131,224,0,144,160,227,44,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,
  220,249,255,235,44,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,
  212,249,255,235,137,249,255,235,7,0,160,227,153,0,1,224,1,48,131,224,177,248,255,234,0,144,160,227,40,112,133,226,
  7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,200,249,255,235,40,112,135,226,7,128,140,224,0,0,88,229,
  0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,192,249,255,235,117,249,255,235,10,0,160,227,153,0,1,224,
  1,48,131,224,0,144,160,227,40,112,69,226,7,128,140,224,0,0,88,229,0,0,80,227,5,0,0,26,181,249,255,235,
  40,112,71,226,7,128,140,224,0,0,88,229,0,0,80,227,249,255,255,10,128,0,16,227,1,0,0,26,173,249,255,235,
  98,249,255,235,8,0,160,227,153,0,1,224,1,48,131,224,138,248,255,234,4,224,45,229,0,82,159,229,0,0,160,227,
  60,144,160,227,4,0,133,228,1,144,89,226,252,255,255,26,0,0,160,227,156,6,12,229,148,95,28,229,84,0,85,227,
  8,0,0,58,5,96,140,224,0,0,86,229,30,0,0,226,15,18,214,229,1,0,128,225,113,0,0,235,152,95,22,229,
  84,0,85,227,246,255,255,42,192,0,0,235,124,24,28,229,120,40,28,229,104,56,28,229,100,72,28,229,84,88,28,229,
  80,104,28,229,1,0,85,225,1,0,0,10,2,0,86,225,40,0,0,26,3,0,85,225,1,0,0,10,4,0,86,225,
  36,0,0,26,64,88,28,229,60,104,28,229,1,0,85,225,1,0,0,10,2,0,86,225,3,0,0,26,3,0,85,225,
  10,0,0,10,4,0,86,225,8,0,0,10,68,8,28,229,88,8,12,229,56,8,28,229,76,8,12,229,52,8,28,229,
  72,8,12,229,84,88,12,229,80,104,12,229,17,0,0,234,44,88,28,229,40,104,28,229,1,0,85,225,1,0,0,10,
  2,0,86,225,3,0,0,26,3,0,85,225,9,0,0,10,4,0,86,225,7,0,0,10,48,8,28,229,88,8,12,229,
  36,8,28,229,76,8,12,229,32,8,28,229,72,8,12,229,84,88,12,229,80,104,12,229,124,88,28,229,0,0,85,227,
  53,0,0,10,8,0,85,227,11,0,0,58,1,16,160,227,5,96,140,224,12,18,70,229,112,72,28,229,0,0,84,227,
  5,0,0,10,4,96,134,224,0,0,86,229,0,0,80,227,1,0,0,26,12,18,70,229,249,255,255,234,104,88,28,229,
  0,0,85,227,36,0,0,10,8,0,85,227,14,0,0,58,5,96,140,224,12,2,86,229,2,0,128,227,12,2,70,229,
  92,72,28,229,0,0,84,227,7,0,0,10,4,96,134,224,0,0,86,229,0,0,80,227,3,0,0,26,12,2,86,229,
  2,0,128,227,12,2,70,229,247,255,255,234,84,88,28,229,0,0,85,227,16,0,0,10,8,0,85,227,14,0,0,58,
  5,96,140,224,12,2,86,229,4,0,128,227,12,2,70,229,72,72,28,229,0,0,84,227,7,0,0,10,4,96,134,224,
  0,0,86,229,0,0,80,227,3,0,0,26,12,2,86,229,4,0,128,227,12,2,70,229,247,255,255,234,4,240,157,228,
  100,12,0,224,4,224,45,229,128,0,143,224,0,240,144,229,112,49,1,0,192,50,1,0,148,49,1,0,192,50,1,0,
  216,49,1,0,192,50,1,0,28,50,1,0,192,50,1,0,192,50,1,0,0,0,0,0,132,51,1,0,136,52,1,0,
  252,53,1,0,0,55,1,0,116,56,1,0,0,0,0,0,144,49,1,0,156,58,1,0,144,49,1,0,156,58,1,0,
  144,49,1,0,156,58,1,0,88,58,1,0,156,58,1,0,156,58,1,0,0,0,0,0,40,59,1,0,172,59,1,0,
  144,49,1,0,172,60,1,0,144,49,1,0,0,0,0,0,112,49,1,0,192,58,1,0,148,49,1,0,192,58,1,0,
  144,49,1,0,192,58,1,0,112,49,1,0,192,58,1,0,192,58,1,0,0,0,0,0,144,49,1,0,192,58,1,0,
  40,60,1,0,240,60,1,0,144,49,1,0,0,0,0,0,144,49,1,0,4,59,1,0,144,49,1,0,4,59,1,0,
  144,49,1,0,4,59,1,0,124,50,1,0,4,59,1,0,4,59,1,0,0,0,0,0,4,52,1,0,128,53,1,0,
  144,49,1,0,108,61,1,0,144,49,1,0,0,0,0,0,144,49,1,0,64,51,1,0,144,49,1,0,64,51,1,0,
  144,49,1,0,64,51,1,0,144,49,1,0,64,51,1,0,64,51,1,0,0,0,0,0,144,49,1,0,64,51,1,0,
  124,54,1,0,248,55,1,0,144,49,1,0,0,0,0,0,4,224,45,229,0,0,160,227,152,6,12,229,148,6,12,229,
  144,6,12,229,168,95,28,229,5,96,140,224,0,0,70,229,2,16,214,229,24,36,150,229,6,0,45,233,2,0,198,229,
  24,4,134,229,186,15,92,229,0,0,80,227,43,0,0,10,2,0,160,227,156,6,12,229,168,95,28,229,5,96,140,224,
  84,0,86,229,0,0,80,227,15,0,0,26,210,5,214,229,120,0,80,227,12,0,0,58,84,80,69,226,5,96,140,224,
  40,0,160,227,0,0,70,229,32,0,160,227,2,0,198,229,2,12,160,227,24,4,134,229,205,1,0,235,0,0,160,227,
  0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,76,0,86,229,0,0,80,227,15,0,0,26,
  218,5,214,229,120,0,80,227,12,0,0,58,76,80,69,226,5,96,140,224,40,0,160,227,0,0,70,229,32,0,160,227,
  2,0,198,229,2,12,160,227,24,4,134,229,184,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  185,15,92,229,0,0,80,227,106,0,0,10,3,0,160,227,156,6,12,229,168,95,28,229,5,96,140,224,40,0,86,229,
  0,0,80,227,15,0,0,26,254,5,214,229,120,0,80,227,12,0,0,58,40,80,69,226,5,96,140,224,44,0,160,227,
  0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,160,1,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,44,0,86,229,0,0,80,227,15,0,0,26,250,5,214,229,
  120,0,80,227,12,0,0,58,44,80,69,226,5,96,140,224,44,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,
  50,14,160,227,24,4,134,229,139,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,
  5,96,140,224,36,0,86,229,0,0,80,227,15,0,0,26,2,6,214,229,120,0,80,227,12,0,0,58,36,80,69,226,
  5,96,140,224,44,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,118,1,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,36,0,214,229,0,0,80,227,
  15,0,0,26,74,6,214,229,120,0,80,227,12,0,0,58,36,80,133,226,5,96,140,224,44,0,160,227,0,0,70,229,
  50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,97,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,168,95,28,229,5,96,140,224,44,0,214,229,0,0,80,227,15,0,0,26,82,6,214,229,120,0,80,227,
  12,0,0,58,44,80,133,226,5,96,140,224,44,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,
  24,4,134,229,76,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,184,15,92,229,0,0,80,227,
  127,0,0,10,4,0,160,227,156,6,12,229,168,95,28,229,5,96,140,224,40,0,86,229,0,0,80,227,15,0,0,26,
  254,5,214,229,120,0,80,227,12,0,0,58,40,80,69,226,5,96,140,224,48,0,160,227,0,0,70,229,52,0,160,227,
  2,0,198,229,13,13,160,227,24,4,134,229,52,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  168,95,28,229,5,96,140,224,44,0,86,229,0,0,80,227,15,0,0,26,250,5,214,229,120,0,80,227,12,0,0,58,
  44,80,69,226,5,96,140,224,48,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,
  31,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,36,0,86,229,
  0,0,80,227,15,0,0,26,2,6,214,229,120,0,80,227,12,0,0,58,36,80,69,226,5,96,140,224,48,0,160,227,
  0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,10,1,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,4,0,86,229,0,0,80,227,15,0,0,26,34,6,214,229,
  120,0,80,227,12,0,0,58,4,80,69,226,5,96,140,224,48,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,
  13,13,160,227,24,4,134,229,245,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,
  5,96,140,224,4,0,214,229,0,0,80,227,15,0,0,26,42,6,214,229,120,0,80,227,12,0,0,58,4,80,133,226,
  5,96,140,224,48,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,224,0,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,168,95,28,229,5,96,140,224,40,0,214,229,0,0,80,227,
  15,0,0,26,78,6,214,229,120,0,80,227,12,0,0,58,40,80,133,226,5,96,140,224,48,0,160,227,0,0,70,229,
  52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,203,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,183,15,92,229,0,0,80,227,85,0,0,10,5,0,160,227,156,6,12,229,168,95,28,229,14,0,0,234,
  5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,52,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,
  70,14,160,227,24,4,134,229,183,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,44,80,69,226,
  5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,14,0,0,234,5,96,140,224,38,6,214,229,120,0,80,227,
  10,0,0,58,52,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,162,0,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,36,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,
  168,95,28,229,14,0,0,234,5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,52,0,160,227,0,0,70,229,
  70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,141,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,36,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,14,0,0,234,5,96,140,224,
  38,6,214,229,120,0,80,227,10,0,0,58,52,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,70,14,160,227,
  24,4,134,229,120,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,44,80,133,226,5,0,220,231,
  0,0,80,227,236,255,255,10,182,15,92,229,0,0,80,227,85,0,0,10,6,0,160,227,156,6,12,229,168,95,28,229,
  14,0,0,234,5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,56,0,160,227,0,0,70,229,80,0,160,227,
  2,0,198,229,5,12,160,227,24,4,134,229,96,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  40,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,14,0,0,234,5,96,140,224,38,6,214,229,
  120,0,80,227,10,0,0,58,56,0,160,227,0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,
  75,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,4,80,69,226,5,0,220,231,0,0,80,227,
  236,255,255,10,168,95,28,229,14,0,0,234,5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,56,0,160,227,
  0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,54,0,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,4,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,14,0,0,234,
  5,96,140,224,38,6,214,229,120,0,80,227,10,0,0,58,56,0,160,227,0,0,70,229,80,0,160,227,2,0,198,229,
  5,12,160,227,24,4,134,229,33,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,40,80,133,226,
  5,0,220,231,0,0,80,227,236,255,255,10,168,95,28,229,5,96,140,224,92,0,160,227,0,0,70,229,6,0,189,232,
  2,16,198,229,24,36,134,229,152,38,28,229,0,0,82,227,6,0,0,10,148,86,28,229,144,118,28,229,0,0,160,227,
  160,6,12,229,164,6,12,229,0,64,160,227,97,0,0,235,4,240,157,228,4,224,45,229,54,1,0,234,4,224,45,229,
  69,1,0,234,4,224,45,229,108,1,0,234,4,224,45,229,155,1,0,234,4,224,45,229,55,2,0,234,4,224,45,229,
  224,1,45,233,7,80,160,225,31,204,255,235,224,1,189,232,0,16,86,229,0,32,88,229,6,0,45,233,2,16,129,227,
  10,0,0,234,4,224,45,229,0,0,88,229,0,0,80,227,85,0,0,10,224,1,45,233,7,80,160,225,18,204,255,235,
  224,1,189,232,0,16,86,229,0,32,88,229,6,0,45,233,0,16,72,229,0,0,160,227,0,0,70,229,2,16,216,229,
  2,0,214,229,2,0,200,229,226,1,45,233,7,80,160,225,137,245,255,235,140,8,28,229,128,49,131,224,226,1,189,232,
  2,16,200,229,6,0,189,232,0,16,70,229,0,32,72,229,24,4,150,229,0,48,67,224,195,50,160,225,232,1,45,233,
  7,80,160,225,224,203,255,235,232,1,189,232,2,16,214,229,2,32,216,229,2,64,160,225,0,0,160,227,164,6,12,229,
  120,0,82,227,24,0,0,42,3,16,129,224,3,32,130,224,0,0,82,227,44,0,0,218,0,0,83,227,0,48,160,179,
  164,54,12,229,221,219,255,235,1,48,160,225,156,8,92,229,0,16,81,224,0,16,160,51,48,8,216,229,0,0,80,227,
  4,0,0,10,227,219,255,235,156,8,92,229,0,48,83,224,0,48,160,51,0,0,0,234,1,48,160,225,2,64,160,225,
  1,32,82,224,24,0,0,74,3,64,68,224,156,6,28,229,0,0,80,227,7,0,0,10,152,6,28,229,2,0,80,225,
  3,0,0,42,152,38,12,229,156,22,28,229,148,22,12,229,144,86,12,229,4,240,157,228,48,8,28,229,2,0,80,225,
  9,0,0,42,68,8,28,229,2,0,80,225,7,0,0,58,48,40,12,229,44,88,12,229,40,120,12,229,164,6,28,229,
  36,8,12,229,160,6,28,229,32,8,12,229,4,240,157,228,88,8,28,229,2,0,80,225,17,0,0,58,68,8,28,229,
  48,8,12,229,68,40,12,229,64,8,28,229,44,8,12,229,64,88,12,229,60,8,28,229,40,8,12,229,60,120,12,229,
  56,8,28,229,36,8,12,229,164,6,28,229,56,8,12,229,52,8,28,229,32,8,12,229,160,6,28,229,52,8,12,229,
  4,240,157,228,108,8,28,229,2,0,80,225,27,0,0,58,68,8,28,229,48,8,12,229,88,8,28,229,68,8,12,229,
  88,40,12,229,64,8,28,229,44,8,12,229,84,8,28,229,64,8,12,229,84,88,12,229,60,8,28,229,40,8,12,229,
  80,8,28,229,60,8,12,229,80,120,12,229,56,8,28,229,36,8,12,229,76,8,28,229,56,8,12,229,164,6,28,229,
  76,8,12,229,52,8,28,229,32,8,12,229,72,8,28,229,52,8,12,229,160,6,28,229,72,8,12,229,4,240,157,228,
  128,8,28,229,2,0,80,225,37,0,0,58,68,8,28,229,48,8,12,229,88,8,28,229,68,8,12,229,108,8,28,229,
  88,8,12,229,108,40,12,229,64,8,28,229,44,8,12,229,84,8,28,229,64,8,12,229,104,8,28,229,84,8,12,229,
  104,88,12,229,60,8,28,229,40,8,12,229,80,8,28,229,60,8,12,229,100,8,28,229,80,8,12,229,100,120,12,229,
  56,8,28,229,36,8,12,229,76,8,28,229,56,8,12,229,96,8,28,229,76,8,12,229,164,6,28,229,96,8,12,229,
  52,8,28,229,32,8,12,229,72,8,28,229,52,8,12,229,92,8,28,229,72,8,12,229,160,6,28,229,92,8,12,229,
  4,240,157,228,0,0,84,227,2,0,0,186,160,6,28,229,0,0,80,227,0,0,0,10,0,64,160,227,132,72,12,229,
  68,8,28,229,48,8,12,229,88,8,28,229,68,8,12,229,108,8,28,229,88,8,12,229,128,8,28,229,108,8,12,229,
  128,40,12,229,64,8,28,229,44,8,12,229,84,8,28,229,64,8,12,229,104,8,28,229,84,8,12,229,124,8,28,229,
  104,8,12,229,124,88,12,229,60,8,28,229,40,8,12,229,80,8,28,229,60,8,12,229,100,8,28,229,80,8,12,229,
  120,8,28,229,100,8,12,229,120,120,12,229,56,8,28,229,36,8,12,229,76,8,28,229,56,8,12,229,96,8,28,229,
  76,8,12,229,116,8,28,229,96,8,12,229,164,6,28,229,116,8,12,229,52,8,28,229,32,8,12,229,72,8,28,229,
  52,8,12,229,92,8,28,229,72,8,12,229,112,8,28,229,92,8,12,229,160,6,28,229,112,8,12,229,4,240,157,228,
  81,15,87,227,14,255,255,58,3,255,255,234,81,15,85,227,11,255,255,58,0,255,255,234,160,6,28,229,0,0,80,227,
  17,0,0,26,36,6,216,229,3,0,80,227,14,0,0,186,12,0,0,202,196,31,28,229,192,47,28,229,255,0,193,227,
  1,0,144,225,7,0,0,26,255,0,17,227,6,0,0,10,7,0,139,224,36,11,16,229,0,0,140,224,128,11,80,229,
  0,0,80,227,0,0,0,26,160,70,12,229,14,240,160,225,40,0,214,229,160,0,16,227,4,0,0,26,0,0,160,227,
  160,6,12,229,40,112,133,226,7,128,140,224,219,255,255,235,4,240,157,228,0,0,160,227,160,6,12,229,40,112,133,226,
  4,0,0,234,7,128,140,224,212,255,255,235,40,64,160,227,216,255,255,235,40,112,135,226,7,0,220,231,0,0,80,227,
  247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,202,255,255,235,4,240,157,228,84,0,214,229,160,0,16,227,
  4,0,0,26,0,0,160,227,160,6,12,229,84,112,133,226,7,128,140,224,193,255,255,235,76,0,214,229,160,0,16,227,
  4,0,0,26,0,0,160,227,160,6,12,229,76,112,133,226,7,128,140,224,185,255,255,235,4,240,157,228,44,0,214,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,176,255,255,235,44,0,86,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,44,112,69,226,7,128,140,224,171,255,255,235,40,0,214,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,40,112,133,226,7,128,140,224,160,255,255,235,36,0,214,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,36,112,133,226,7,128,140,224,152,255,255,235,36,0,86,229,
  160,0,16,227,4,0,0,26,0,0,160,227,160,6,12,229,36,112,69,226,7,128,140,224,147,255,255,235,4,240,157,228,
  44,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,152,254,255,235,
  40,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,133,226,7,128,140,224,144,254,255,235,
  40,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,69,226,7,128,140,224,136,254,255,235,
  36,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,36,112,133,226,7,128,140,224,128,254,255,235,
  4,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,4,112,133,226,7,128,140,224,120,254,255,235,
  4,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,4,112,69,226,7,128,140,224,112,254,255,235,
  4,240,157,228,0,0,160,227,160,6,12,229,44,112,133,226,4,0,0,234,7,128,140,224,88,255,255,235,44,64,160,227,
  92,255,255,235,44,112,135,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  78,255,255,235,0,0,160,227,160,6,12,229,44,112,69,226,4,0,0,234,7,128,140,224,75,255,255,235,43,64,224,227,
  76,255,255,235,44,112,71,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  65,255,255,235,0,0,160,227,160,6,12,229,36,112,133,226,4,0,0,234,7,128,140,224,56,255,255,235,36,64,160,227,
  60,255,255,235,36,112,135,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  46,255,255,235,0,0,160,227,160,6,12,229,36,112,69,226,4,0,0,234,7,128,140,224,43,255,255,235,35,64,224,227,
  44,255,255,235,36,112,71,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  33,255,255,235,4,240,157,228,40,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,133,226,
  7,128,140,224,38,254,255,235,4,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,4,112,133,226,
  7,128,140,224,30,254,255,235,4,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,4,112,69,226,
  7,128,140,224,22,254,255,235,40,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,69,226,
  7,128,140,224,14,254,255,235,0,0,160,227,160,6,12,229,44,112,133,226,3,0,0,234,7,128,140,224,44,64,160,227,
  252,254,255,235,44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  255,253,255,235,0,0,160,227,160,6,12,229,44,112,69,226,3,0,0,234,7,128,140,224,43,64,224,227,237,254,255,235,
  44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,240,253,255,235,
  0,0,160,227,160,6,12,229,36,112,133,226,3,0,0,234,7,128,140,224,36,64,160,227,222,254,255,235,36,112,135,226,
  7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,225,253,255,235,0,0,160,227,
  160,6,12,229,36,112,69,226,3,0,0,234,7,128,140,224,35,64,224,227,207,254,255,235,36,112,71,226,7,0,220,231,
  0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,210,253,255,235,4,240,157,228,0,0,160,227,
  160,6,12,229,40,112,133,226,4,0,0,234,7,128,140,224,186,254,255,235,40,64,160,227,190,254,255,235,40,112,135,226,
  7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,176,254,255,235,0,0,160,227,
  160,6,12,229,40,112,69,226,4,0,0,234,7,128,140,224,173,254,255,235,39,64,224,227,174,254,255,235,40,112,71,226,
  7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,163,254,255,235,0,0,160,227,
  160,6,12,229,4,112,133,226,4,0,0,234,7,128,140,224,154,254,255,235,4,64,160,227,158,254,255,235,4,112,135,226,
  7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,144,254,255,235,0,0,160,227,
  160,6,12,229,4,112,69,226,4,0,0,234,7,128,140,224,141,254,255,235,3,64,224,227,142,254,255,235,4,112,71,226,
  7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,131,254,255,235,4,240,157,228,
  44,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,136,253,255,235,
  36,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,36,112,133,226,7,128,140,224,128,253,255,235,
  36,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,36,112,69,226,7,128,140,224,120,253,255,235,
  44,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,44,112,69,226,7,128,140,224,112,253,255,235,
  0,0,160,227,160,6,12,229,40,112,133,226,3,0,0,234,7,128,140,224,40,64,160,227,94,254,255,235,40,112,135,226,
  7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,97,253,255,235,0,0,160,227,
  160,6,12,229,40,112,69,226,3,0,0,234,7,128,140,224,39,64,224,227,79,254,255,235,40,112,71,226,7,0,220,231,
  0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,82,253,255,235,0,0,160,227,160,6,12,229,
  4,112,133,226,3,0,0,234,7,128,140,224,4,64,160,227,64,254,255,235,4,112,135,226,7,0,220,231,0,0,80,227,
  248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,67,253,255,235,0,0,160,227,160,6,12,229,4,112,69,226,
  3,0,0,234,7,128,140,224,3,64,224,227,49,254,255,235,4,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  64,0,16,227,1,0,0,10,7,128,140,224,52,253,255,235,4,240,157,228,24,4,86,229,128,0,16,227,11,0,0,26,
  44,0,214,229,64,0,16,227,8,0,0,10,246,5,22,229,236,19,86,229,32,8,145,225,4,0,0,26,0,0,160,227,
  160,6,12,229,44,112,133,226,7,128,140,224,36,253,255,235,24,4,86,229,64,0,16,227,11,0,0,26,40,0,214,229,
  64,0,16,227,8,0,0,10,250,5,22,229,240,19,86,229,32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,
  40,112,133,226,7,128,140,224,21,253,255,235,24,4,86,229,32,0,16,227,11,0,0,26,36,0,214,229,64,0,16,227,
  8,0,0,10,254,5,22,229,244,19,86,229,32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,36,112,133,226,
  7,128,140,224,6,253,255,235,24,4,86,229,16,0,16,227,11,0,0,26,4,0,214,229,64,0,16,227,8,0,0,10,
  30,6,22,229,20,20,86,229,32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,4,112,133,226,7,128,140,224,
  247,252,255,235,24,4,86,229,8,0,16,227,11,0,0,26,4,0,86,229,64,0,16,227,8,0,0,10,38,6,22,229,
  28,20,86,229,32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,4,112,69,226,7,128,140,224,232,252,255,235,
  24,4,86,229,4,0,16,227,11,0,0,26,36,0,86,229,64,0,16,227,8,0,0,10,70,6,22,229,60,20,86,229,
  32,8,145,225,4,0,0,26,0,0,160,227,160,6,12,229,36,112,69,226,7,128,140,224,217,252,255,235,24,4,86,229,
  2,0,16,227,11,0,0,26,40,0,86,229,64,0,16,227,8,0,0,10,74,6,22,229,64,20,86,229,32,8,145,225,
  4,0,0,26,0,0,160,227,160,6,12,229,40,112,69,226,7,128,140,224,202,252,255,235,24,4,86,229,1,0,16,227,
  11,0,0,26,44,0,86,229,64,0,16,227,8,0,0,10,78,6,22,229,68,20,86,229,32,8,145,225,4,0,0,26,
  0,0,160,227,160,6,12,229,44,112,69,226,7,128,140,224,187,252,255,235,4,240,157,228,44,0,214,229,160,0,16,227,
  4,0,0,26,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,161,253,255,235,44,0,86,229,160,0,16,227,
  4,0,0,26,0,0,160,227,160,6,12,229,44,112,69,226,7,128,140,224,156,253,255,235,4,240,157,228,44,0,214,229,
  64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,44,112,133,226,7,128,140,224,161,252,255,235,4,240,157,228,
  40,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,133,226,7,128,140,224,152,252,255,235,
  40,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,40,112,69,226,7,128,140,224,144,252,255,235,
  4,240,157,228,36,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,36,112,133,226,7,128,140,224,
  135,252,255,235,4,240,157,228,0,0,160,227,160,6,12,229,44,112,133,226,4,0,0,234,7,128,140,224,111,253,255,235,
  44,64,160,227,115,253,255,235,44,112,135,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,101,253,255,235,0,0,160,227,160,6,12,229,44,112,69,226,4,0,0,234,7,128,140,224,98,253,255,235,
  43,64,224,227,99,253,255,235,44,112,71,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,88,253,255,235,4,240,157,228,0,0,160,227,160,6,12,229,44,112,133,226,3,0,0,234,7,128,140,224,
  44,64,160,227,83,253,255,235,44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,86,252,255,235,0,0,160,227,160,6,12,229,44,112,69,226,3,0,0,234,7,128,140,224,43,64,224,227,
  68,253,255,235,44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,7,128,140,224,
  71,252,255,235,4,240,157,228,0,0,160,227,160,6,12,229,40,112,133,226,4,0,0,234,7,128,140,224,47,253,255,235,
  40,64,160,227,51,253,255,235,40,112,135,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,37,253,255,235,0,0,160,227,160,6,12,229,40,112,69,226,4,0,0,234,7,128,140,224,34,253,255,235,
  39,64,224,227,35,253,255,235,40,112,71,226,7,0,220,231,0,0,80,227,247,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,24,253,255,235,4,240,157,228,44,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,
  44,112,133,226,7,128,140,224,29,252,255,235,44,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,
  44,112,69,226,7,128,140,224,21,252,255,235,4,240,157,228,0,0,160,227,160,6,12,229,40,112,133,226,3,0,0,234,
  7,128,140,224,40,64,160,227,2,253,255,235,40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,
  1,0,0,10,7,128,140,224,5,252,255,235,0,0,160,227,160,6,12,229,40,112,69,226,3,0,0,234,7,128,140,224,
  39,64,224,227,243,252,255,235,40,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,64,0,16,227,1,0,0,10,
  7,128,140,224,246,251,255,235,4,240,157,228,36,0,214,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,
  36,112,133,226,7,128,140,224,237,251,255,235,36,0,86,229,64,0,16,227,4,0,0,10,0,0,160,227,160,6,12,229,
  36,112,69,226,7,128,140,224,229,251,255,235,4,240,157,228,4,224,45,229,240,10,28,229,0,0,80,227,4,0,0,10,
  128,8,28,229,132,8,12,229,120,8,28,229,236,10,12,229,69,0,0,234,120,8,28,229,236,26,28,229,0,0,81,225,
  65,0,0,10,236,10,12,229,112,72,28,229,0,0,84,227,32,0,0,10,124,88,28,229,104,8,28,229,5,0,80,225,
  10,0,0,26,92,8,28,229,4,0,80,225,7,0,0,26,84,8,28,229,5,0,80,225,15,0,0,26,72,8,28,229,
  4,0,80,225,12,0,0,26,0,16,160,227,42,0,0,234,120,120,28,229,108,24,28,229,100,8,28,229,7,0,80,225,
  37,0,0,26,88,24,28,229,80,8,28,229,7,0,80,225,33,0,0,26,0,16,160,227,31,0,0,234,120,120,28,229,
  88,24,28,229,80,8,28,229,7,0,80,225,26,0,0,26,0,16,160,227,24,0,0,234,124,8,28,229,8,0,80,227,
  9,0,0,42,108,24,28,229,104,8,28,229,8,0,80,227,17,0,0,42,88,24,28,229,84,8,28,229,8,0,80,227,
  13,0,0,42,0,16,160,227,11,0,0,234,132,24,28,229,120,120,28,229,108,40,28,229,100,8,28,229,7,0,80,225,
  3,0,0,26,88,40,28,229,80,8,28,229,7,0,80,225,1,0,0,10,2,0,81,225,2,16,160,49,128,72,28,229,
  1,64,68,224,1,64,84,226,28,72,12,85,0,0,160,227,140,6,12,229,1,0,160,227,0,4,128,224,0,8,128,224,
  112,6,12,229,152,95,28,229,84,0,85,227,11,0,0,58,112,6,28,229,224,0,160,225,112,6,12,229,5,96,140,224,
  0,0,86,229,30,0,0,226,13,18,214,229,1,0,128,225,28,0,0,235,152,95,22,229,84,0,85,227,243,255,255,42,
  107,0,0,235,28,8,28,229,0,0,80,227,4,0,0,10,12,24,28,229,8,40,28,229,2,16,145,225,1,0,128,2,
  28,8,12,5,4,8,28,229,0,0,80,227,4,0,0,10,244,23,28,229,240,39,28,229,2,16,145,225,1,0,128,2,
  4,8,12,5,236,7,28,229,0,0,80,227,4,0,0,10,220,23,28,229,216,39,28,229,2,16,145,225,1,0,128,2,
  236,7,12,5,4,240,157,228,4,224,45,229,128,0,143,224,0,240,144,229,24,79,1,0,60,80,1,0,56,79,1,0,
  60,80,1,0,112,79,1,0,60,80,1,0,172,79,1,0,60,80,1,0,60,80,1,0,0,0,0,0,232,80,1,0,
  188,81,1,0,0,83,1,0,212,83,1,0,24,85,1,0,0,0,0,0,52,79,1,0,24,87,1,0,52,79,1,0,
  24,87,1,0,52,79,1,0,24,87,1,0,220,86,1,0,24,87,1,0,24,87,1,0,0,0,0,0,148,87,1,0,
  0,88,1,0,52,79,1,0,216,88,1,0,52,79,1,0,0,0,0,0,24,79,1,0,56,87,1,0,56,79,1,0,
  56,87,1,0,52,79,1,0,56,87,1,0,24,79,1,0,56,87,1,0,56,87,1,0,0,0,0,0,52,79,1,0,
  56,87,1,0,108,88,1,0,20,89,1,0,52,79,1,0,0,0,0,0,52,79,1,0,116,87,1,0,52,79,1,0,
  116,87,1,0,52,79,1,0,116,87,1,0,0,80,1,0,116,87,1,0,116,87,1,0,0,0,0,0,80,81,1,0,
  148,82,1,0,52,79,1,0,128,89,1,0,52,79,1,0,0,0,0,0,52,79,1,0,172,80,1,0,52,79,1,0,
  172,80,1,0,52,79,1,0,172,80,1,0,52,79,1,0,172,80,1,0,172,80,1,0,0,0,0,0,52,79,1,0,
  172,80,1,0,104,83,1,0,172,84,1,0,52,79,1,0,0,0,0,0,0,0,160,227,136,6,12,229,132,6,12,229,
  128,6,12,229,124,6,12,229,120,6,12,229,116,6,12,229,164,95,28,229,5,96,140,224,0,0,70,229,2,16,214,229,
  24,36,150,229,6,0,45,233,2,0,198,229,24,4,134,229,194,15,92,229,0,0,80,227,43,0,0,10,2,0,160,227,
  140,6,12,229,164,95,28,229,5,96,140,224,84,0,214,229,0,0,80,227,15,0,0,26,123,6,214,229,120,0,80,227,
  12,0,0,58,84,80,133,226,5,96,140,224,72,0,160,227,0,0,70,229,32,0,160,227,2,0,198,229,2,12,160,227,
  24,4,134,229,205,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,
  76,0,214,229,0,0,80,227,15,0,0,26,115,6,214,229,120,0,80,227,12,0,0,58,76,80,133,226,5,96,140,224,
  72,0,160,227,0,0,70,229,32,0,160,227,2,0,198,229,2,12,160,227,24,4,134,229,184,1,0,235,0,0,160,227,
  0,0,70,229,2,0,198,229,24,4,134,229,193,15,92,229,0,0,80,227,106,0,0,10,3,0,160,227,140,6,12,229,
  164,95,28,229,5,96,140,224,40,0,214,229,0,0,80,227,15,0,0,26,79,6,214,229,120,0,80,227,12,0,0,58,
  40,80,133,226,5,96,140,224,76,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,
  160,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,44,0,214,229,
  0,0,80,227,15,0,0,26,83,6,214,229,120,0,80,227,12,0,0,58,44,80,133,226,5,96,140,224,76,0,160,227,
  0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,139,1,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,36,0,214,229,0,0,80,227,15,0,0,26,75,6,214,229,
  120,0,80,227,12,0,0,58,36,80,133,226,5,96,140,224,76,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,
  50,14,160,227,24,4,134,229,118,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,
  5,96,140,224,36,0,86,229,0,0,80,227,15,0,0,26,3,6,214,229,120,0,80,227,12,0,0,58,36,80,69,226,
  5,96,140,224,76,0,160,227,0,0,70,229,50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,97,1,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,44,0,86,229,0,0,80,227,
  15,0,0,26,251,5,214,229,120,0,80,227,12,0,0,58,44,80,69,226,5,96,140,224,76,0,160,227,0,0,70,229,
  50,0,160,227,2,0,198,229,50,14,160,227,24,4,134,229,76,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,192,15,92,229,0,0,80,227,127,0,0,10,4,0,160,227,140,6,12,229,164,95,28,229,5,96,140,224,
  40,0,214,229,0,0,80,227,15,0,0,26,79,6,214,229,120,0,80,227,12,0,0,58,40,80,133,226,5,96,140,224,
  80,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,52,1,0,235,0,0,160,227,
  0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,44,0,214,229,0,0,80,227,15,0,0,26,
  83,6,214,229,120,0,80,227,12,0,0,58,44,80,133,226,5,96,140,224,80,0,160,227,0,0,70,229,52,0,160,227,
  2,0,198,229,13,13,160,227,24,4,134,229,31,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  164,95,28,229,5,96,140,224,36,0,214,229,0,0,80,227,15,0,0,26,75,6,214,229,120,0,80,227,12,0,0,58,
  36,80,133,226,5,96,140,224,80,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,
  10,1,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,4,0,214,229,
  0,0,80,227,15,0,0,26,43,6,214,229,120,0,80,227,12,0,0,58,4,80,133,226,5,96,140,224,80,0,160,227,
  0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,245,0,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,164,95,28,229,5,96,140,224,4,0,86,229,0,0,80,227,15,0,0,26,35,6,214,229,
  120,0,80,227,12,0,0,58,4,80,69,226,5,96,140,224,80,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,
  13,13,160,227,24,4,134,229,224,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,164,95,28,229,
  5,96,140,224,40,0,86,229,0,0,80,227,15,0,0,26,255,5,214,229,120,0,80,227,12,0,0,58,40,80,69,226,
  5,96,140,224,80,0,160,227,0,0,70,229,52,0,160,227,2,0,198,229,13,13,160,227,24,4,134,229,203,0,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,191,15,92,229,0,0,80,227,85,0,0,10,5,0,160,227,
  140,6,12,229,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,84,0,160,227,
  0,0,70,229,70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,183,0,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,44,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,14,0,0,234,
  5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,84,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,
  70,14,160,227,24,4,134,229,162,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,36,80,133,226,
  5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,
  10,0,0,58,84,0,160,227,0,0,70,229,70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,141,0,0,235,
  0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,36,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,
  164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,84,0,160,227,0,0,70,229,
  70,0,160,227,2,0,198,229,70,14,160,227,24,4,134,229,120,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,
  24,4,134,229,44,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,190,15,92,229,0,0,80,227,85,0,0,10,
  6,0,160,227,140,6,12,229,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,
  88,0,160,227,0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,96,0,0,235,0,0,160,227,
  0,0,70,229,2,0,198,229,24,4,134,229,40,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,
  14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,88,0,160,227,0,0,70,229,80,0,160,227,
  2,0,198,229,5,12,160,227,24,4,134,229,75,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,
  4,80,133,226,5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,
  120,0,80,227,10,0,0,58,88,0,160,227,0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,
  54,0,0,235,0,0,160,227,0,0,70,229,2,0,198,229,24,4,134,229,4,80,69,226,5,0,220,231,0,0,80,227,
  236,255,255,10,164,95,28,229,14,0,0,234,5,96,140,224,39,6,214,229,120,0,80,227,10,0,0,58,88,0,160,227,
  0,0,70,229,80,0,160,227,2,0,198,229,5,12,160,227,24,4,134,229,33,0,0,235,0,0,160,227,0,0,70,229,
  2,0,198,229,24,4,134,229,40,80,69,226,5,0,220,231,0,0,80,227,236,255,255,10,164,95,28,229,5,96,140,224,
  60,0,160,227,0,0,70,229,6,0,189,232,2,16,198,229,24,36,134,229,136,38,28,229,0,0,82,227,6,0,0,10,
  136,22,28,229,132,150,28,229,128,38,28,229,124,70,28,229,120,86,28,229,116,118,28,229,158,0,0,235,14,240,160,225,
  4,224,45,229,169,1,0,234,4,224,45,229,182,1,0,234,4,224,45,229,216,1,0,234,4,224,45,229,1,2,0,234,
  4,224,45,229,133,2,0,234,4,224,45,229,224,1,45,233,128,0,45,233,44,197,255,235,32,0,189,232,42,197,255,235,
  224,1,189,232,0,16,86,229,0,32,88,229,6,0,45,233,2,16,129,227,15,0,0,234,4,224,45,229,0,0,160,227,
  144,8,12,229,2,48,214,229,2,64,216,229,0,0,84,227,42,0,0,10,224,1,45,233,128,0,45,233,26,197,255,235,
  32,0,189,232,24,197,255,235,224,1,189,232,0,16,86,229,0,32,88,229,6,0,45,233,0,16,72,229,0,0,160,227,
  0,0,70,229,2,16,216,229,2,0,214,229,2,0,200,229,226,3,45,233,7,80,160,225,243,196,255,235,104,238,255,235,
  8,0,45,233,8,197,255,235,8,0,189,232,140,8,28,229,128,49,131,224,226,3,189,232,2,16,200,229,6,0,189,232,
  0,16,70,229,0,32,72,229,24,4,150,229,0,48,67,224,195,50,160,225,232,1,45,233,32,0,45,233,7,80,160,225,
  225,196,255,235,32,0,189,232,223,196,255,235,232,1,189,232,2,64,216,229,3,64,132,224,2,0,214,229,0,48,131,224,
  0,0,84,227,2,0,0,218,240,10,28,229,0,0,80,227,68,65,132,16,51,213,255,235,155,8,92,229,0,48,83,224,
  0,48,160,51,144,8,28,229,0,64,132,224,0,48,131,224,3,32,160,225,2,64,68,224,128,56,28,229,3,16,160,225,
  12,2,88,229,1,0,16,227,5,0,0,26,120,8,28,229,0,0,85,225,2,0,0,10,0,0,84,227,24,0,0,202,
  4,240,157,228,108,56,28,229,12,2,88,229,2,0,16,227,2,0,0,26,100,8,28,229,0,0,85,225,7,0,0,26,
  88,56,28,229,12,2,88,229,4,0,16,227,2,0,0,26,80,8,28,229,0,0,85,225,0,0,0,26,0,48,160,227,
  120,8,28,229,0,0,85,225,5,0,0,26,124,8,28,229,0,0,87,225,2,0,0,10,116,8,28,229,0,0,83,225,
  0,48,160,49,3,16,65,224,2,0,83,225,2,48,160,33,240,10,28,229,0,0,80,227,12,0,0,10,140,6,28,229,
  0,0,80,227,4,240,157,20,3,16,129,224,4,16,129,224,3,0,81,227,4,240,157,212,112,6,92,229,10,2,70,229,
  10,18,88,229,0,16,129,225,10,18,72,229,4,240,157,228,140,6,28,229,0,0,80,227,14,0,0,10,3,16,129,224,
  4,16,129,224,0,0,81,227,4,240,157,212,136,6,28,229,0,0,81,225,4,240,157,212,136,22,12,229,132,150,12,229,
  128,38,12,229,124,70,12,229,140,6,28,229,120,6,12,229,116,86,12,229,4,240,157,228,104,6,28,229,0,0,80,227,
  3,0,0,26,108,6,28,229,0,0,85,225,4,240,157,4,8,0,0,234,108,6,28,229,8,0,80,227,2,0,0,42,
  108,6,28,229,0,0,85,225,2,0,0,26,104,6,28,229,0,0,87,225,4,240,157,4,64,11,28,229,0,0,87,225,
  4,240,157,4,80,11,28,229,0,0,80,227,10,0,0,10,0,0,87,225,8,0,0,10,168,15,28,229,0,0,85,225,
  5,0,0,10,76,11,28,229,0,0,80,227,116,0,0,10,12,2,88,229,1,0,16,227,113,0,0,10,3,16,129,224,
  4,16,129,224,0,0,81,227,109,0,0,218,236,7,28,229,0,0,81,225,106,0,0,58,2,0,0,26,224,7,28,229,
  0,0,84,225,102,0,0,218,4,8,28,229,0,0,81,225,3,0,0,58,9,0,0,26,248,7,28,229,0,0,84,225,
  6,0,0,202,236,23,12,229,232,151,12,229,228,39,12,229,224,71,12,229,220,87,12,229,216,119,12,229,88,0,0,234,
  28,8,28,229,0,0,81,225,3,0,0,58,28,0,0,26,16,8,28,229,0,0,84,225,25,0,0,202,4,8,28,229,
  236,7,12,229,4,24,12,229,0,8,28,229,232,7,12,229,0,152,12,229,252,7,28,229,228,7,12,229,252,39,12,229,
  248,7,28,229,224,7,12,229,248,71,12,229,244,7,28,229,220,7,12,229,244,87,12,229,240,7,28,229,216,7,12,229,
  240,119,12,229,62,0,0,234,4,24,12,229,0,152,12,229,252,39,12,229,248,71,12,229,244,87,12,229,240,119,12,229,
  55,0,0,234,4,8,28,229,236,7,12,229,28,8,28,229,4,8,12,229,28,24,12,229,0,8,28,229,232,7,12,229,
  24,8,28,229,0,8,12,229,24,152,12,229,252,7,28,229,228,7,12,229,20,8,28,229,252,7,12,229,20,40,12,229,
  248,7,28,229,224,7,12,229,16,8,28,229,248,7,12,229,16,72,12,229,244,7,28,229,220,7,12,229,12,8,28,229,
  244,7,12,229,12,88,12,229,240,7,28,229,216,7,12,229,8,8,28,229,240,7,12,229,8,120,12,229,24,0,0,234,
  28,24,12,229,24,152,12,229,20,40,12,229,16,72,12,229,12,88,12,229,8,120,12,229,17,0,0,234,28,8,28,229,
  4,8,12,229,28,24,12,229,24,8,28,229,0,8,12,229,24,152,12,229,20,8,28,229,252,7,12,229,20,40,12,229,
  16,8,28,229,248,7,12,229,16,72,12,229,12,8,28,229,244,7,12,229,12,88,12,229,8,8,28,229,240,7,12,229,
  8,120,12,229,164,7,28,229,0,0,84,225,4,240,157,212,176,7,28,229,0,0,84,225,84,0,0,218,188,7,28,229,
  0,0,84,225,71,0,0,218,200,7,28,229,0,0,84,225,52,0,0,218,212,7,28,229,0,0,84,225,27,0,0,218,
  176,7,28,229,164,7,12,229,188,7,28,229,176,7,12,229,200,7,28,229,188,7,12,229,212,7,28,229,200,7,12,229,
  212,71,12,229,172,7,28,229,160,7,12,229,184,7,28,229,172,7,12,229,196,7,28,229,184,7,12,229,208,7,28,229,
  196,7,12,229,208,87,12,229,168,7,28,229,156,7,12,229,180,7,28,229,168,7,12,229,192,7,28,229,180,7,12,229,
  204,7,28,229,192,7,12,229,204,119,12,229,4,240,157,228,176,7,28,229,164,7,12,229,188,7,28,229,176,7,12,229,
  200,7,28,229,188,7,12,229,200,71,12,229,172,7,28,229,160,7,12,229,184,7,28,229,172,7,12,229,196,7,28,229,
  184,7,12,229,196,87,12,229,168,7,28,229,156,7,12,229,180,7,28,229,168,7,12,229,192,7,28,229,180,7,12,229,
  192,119,12,229,4,240,157,228,176,7,28,229,164,7,12,229,188,7,28,229,176,7,12,229,188,71,12,229,172,7,28,229,
  160,7,12,229,184,7,28,229,172,7,12,229,184,87,12,229,168,7,28,229,156,7,12,229,180,7,28,229,168,7,12,229,
  180,119,12,229,4,240,157,228,176,7,28,229,164,7,12,229,176,71,12,229,172,7,28,229,160,7,12,229,172,87,12,229,
  168,7,28,229,156,7,12,229,168,119,12,229,4,240,157,228,164,71,12,229,160,87,12,229,156,119,12,229,4,240,157,228,
  204,0,87,227,131,254,255,42,118,254,255,234,204,0,85,227,128,254,255,42,115,254,255,234,0,144,160,227,40,0,86,229,
  192,0,16,227,2,0,0,26,40,112,69,226,7,128,140,224,242,255,255,235,4,240,157,228,0,144,160,227,5,112,160,225,
  40,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,233,255,255,235,248,255,255,234,32,0,16,227,
  1,0,0,10,7,128,140,224,228,255,255,235,4,240,157,228,0,144,160,227,84,0,86,229,192,0,16,227,2,0,0,26,
  84,112,69,226,7,128,140,224,220,255,255,235,0,144,160,227,76,0,86,229,192,0,16,227,2,0,0,26,76,112,69,226,
  7,128,140,224,213,255,255,235,4,240,157,228,1,144,160,227,44,0,86,229,192,0,16,227,2,0,0,26,44,112,69,226,
  7,128,140,224,205,255,255,235,1,144,160,227,44,0,214,229,192,0,16,227,2,0,0,26,44,112,133,226,7,128,140,224,
  201,255,255,235,0,144,160,227,40,0,86,229,192,0,16,227,2,0,0,26,40,112,69,226,7,128,140,224,191,255,255,235,
  1,144,160,227,36,0,86,229,192,0,16,227,2,0,0,26,36,112,69,226,7,128,140,224,184,255,255,235,1,144,160,227,
  36,0,214,229,192,0,16,227,2,0,0,26,36,112,133,226,7,128,140,224,180,255,255,235,4,240,157,228,0,144,160,227,
  44,0,86,229,192,0,16,227,2,0,0,26,44,112,69,226,7,128,140,224,47,254,255,235,1,144,160,227,40,0,214,229,
  192,0,16,227,2,0,0,26,40,112,133,226,7,128,140,224,40,254,255,235,1,144,160,227,40,0,86,229,192,0,16,227,
  2,0,0,26,40,112,69,226,7,128,140,224,33,254,255,235,0,144,160,227,36,0,86,229,192,0,16,227,2,0,0,26,
  36,112,69,226,7,128,140,224,26,254,255,235,1,144,160,227,4,0,86,229,192,0,16,227,2,0,0,26,4,112,69,226,
  7,128,140,224,19,254,255,235,1,144,160,227,4,0,214,229,192,0,16,227,2,0,0,26,4,112,133,226,7,128,140,224,
  12,254,255,235,4,240,157,228,1,144,160,227,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,125,255,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,120,255,255,235,1,144,160,227,
  5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,115,255,255,235,248,255,255,234,
  32,0,16,227,1,0,0,10,7,128,140,224,110,255,255,235,1,144,160,227,5,112,160,225,36,112,71,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,128,140,224,99,255,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,
  94,255,255,235,1,144,160,227,5,112,160,225,36,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,
  89,255,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,84,255,255,235,4,240,157,228,1,144,160,227,
  40,0,86,229,192,0,16,227,2,0,0,26,40,112,69,226,7,128,140,224,207,253,255,235,1,144,160,227,4,0,86,229,
  192,0,16,227,2,0,0,26,4,112,69,226,7,128,140,224,200,253,255,235,1,144,160,227,4,0,214,229,192,0,16,227,
  2,0,0,26,4,112,133,226,7,128,140,224,193,253,255,235,1,144,160,227,40,0,214,229,192,0,16,227,2,0,0,26,
  40,112,133,226,7,128,140,224,186,253,255,235,1,144,160,227,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,128,140,224,178,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,173,253,255,235,
  1,144,160,227,5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,165,253,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,160,253,255,235,1,144,160,227,5,112,160,225,36,112,71,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,152,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,147,253,255,235,1,144,160,227,5,112,160,225,36,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,139,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,134,253,255,235,4,240,157,228,
  1,144,160,227,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,247,254,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,242,254,255,235,1,144,160,227,5,112,160,225,40,112,135,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,237,254,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,232,254,255,235,1,144,160,227,5,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,221,254,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,216,254,255,235,1,144,160,227,
  5,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,211,254,255,235,248,255,255,234,
  32,0,16,227,1,0,0,10,7,128,140,224,206,254,255,235,4,240,157,228,1,144,160,227,44,0,86,229,192,0,16,227,
  2,0,0,26,44,112,69,226,7,128,140,224,73,253,255,235,1,144,160,227,36,0,86,229,192,0,16,227,2,0,0,26,
  36,112,69,226,7,128,140,224,66,253,255,235,1,144,160,227,36,0,214,229,192,0,16,227,2,0,0,26,36,112,133,226,
  7,128,140,224,59,253,255,235,1,144,160,227,44,0,214,229,192,0,16,227,2,0,0,26,44,112,133,226,7,128,140,224,
  52,253,255,235,1,144,160,227,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,
  44,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,39,253,255,235,1,144,160,227,5,112,160,225,
  40,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,31,253,255,235,248,255,255,234,32,0,16,227,
  1,0,0,10,7,128,140,224,26,253,255,235,1,144,160,227,5,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,128,140,224,18,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,13,253,255,235,
  1,144,160,227,5,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,5,253,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,0,253,255,235,4,240,157,228,1,144,160,227,22,4,86,229,
  128,0,16,227,9,0,0,26,44,0,86,229,192,0,16,227,6,0,0,26,80,6,22,229,66,20,86,229,32,8,145,225,
  2,0,0,26,44,112,69,226,7,128,140,224,241,252,255,235,1,144,160,227,22,4,86,229,64,0,16,227,9,0,0,26,
  40,0,86,229,192,0,16,227,6,0,0,26,76,6,22,229,62,20,86,229,32,8,145,225,2,0,0,26,40,112,69,226,
  7,128,140,224,227,252,255,235,1,144,160,227,22,4,86,229,32,0,16,227,9,0,0,26,36,0,86,229,192,0,16,227,
  6,0,0,26,72,6,22,229,58,20,86,229,32,8,145,225,2,0,0,26,36,112,69,226,7,128,140,224,213,252,255,235,
  1,144,160,227,22,4,86,229,16,0,16,227,9,0,0,26,4,0,86,229,192,0,16,227,6,0,0,26,40,6,22,229,
  26,20,86,229,32,8,145,225,2,0,0,26,4,112,69,226,7,128,140,224,199,252,255,235,1,144,160,227,22,4,86,229,
  8,0,16,227,9,0,0,26,4,0,214,229,192,0,16,227,6,0,0,26,32,6,22,229,18,20,86,229,32,8,145,225,
  2,0,0,26,4,112,133,226,7,128,140,224,185,252,255,235,1,144,160,227,22,4,86,229,4,0,16,227,9,0,0,26,
  36,0,214,229,192,0,16,227,6,0,0,26,0,6,22,229,242,19,86,229,32,8,145,225,2,0,0,26,36,112,133,226,
  7,128,140,224,171,252,255,235,1,144,160,227,22,4,86,229,2,0,16,227,9,0,0,26,40,0,214,229,192,0,16,227,
  6,0,0,26,252,5,22,229,238,19,86,229,32,8,145,225,2,0,0,26,40,112,133,226,7,128,140,224,157,252,255,235,
  1,144,160,227,22,4,86,229,1,0,16,227,9,0,0,26,44,0,214,229,192,0,16,227,6,0,0,26,248,5,22,229,
  234,19,86,229,32,8,145,225,2,0,0,26,44,112,133,226,7,128,140,224,143,252,255,235,4,240,157,228,1,144,160,227,
  44,0,86,229,192,0,16,227,2,0,0,26,44,112,69,226,7,128,140,224,1,254,255,235,1,144,160,227,44,0,214,229,
  192,0,16,227,2,0,0,26,44,112,133,226,7,128,140,224,253,253,255,235,4,240,157,228,0,144,160,227,44,0,86,229,
  192,0,16,227,2,0,0,26,44,112,69,226,7,128,140,224,120,252,255,235,4,240,157,228,1,144,160,227,40,0,86,229,
  192,0,16,227,2,0,0,26,40,112,69,226,7,128,140,224,112,252,255,235,1,144,160,227,40,0,214,229,192,0,16,227,
  2,0,0,26,40,112,133,226,7,128,140,224,105,252,255,235,4,240,157,228,0,144,160,227,36,0,86,229,192,0,16,227,
  2,0,0,26,36,112,69,226,7,128,140,224,97,252,255,235,4,240,157,228,1,144,160,227,5,112,160,225,44,112,71,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,210,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,205,253,255,235,1,144,160,227,5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,200,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,195,253,255,235,4,240,157,228,
  1,144,160,227,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,61,252,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,56,252,255,235,1,144,160,227,5,112,160,225,44,112,135,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,48,252,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,43,252,255,235,4,240,157,228,1,144,160,227,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,128,140,224,156,253,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,151,253,255,235,
  1,144,160,227,5,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,146,253,255,235,
  248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,141,253,255,235,4,240,157,228,1,144,160,227,44,0,86,229,
  192,0,16,227,2,0,0,26,44,112,69,226,7,128,140,224,8,252,255,235,1,144,160,227,44,0,214,229,192,0,16,227,
  2,0,0,26,44,112,133,226,7,128,140,224,1,252,255,235,4,240,157,228,1,144,160,227,5,112,160,225,40,112,71,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,128,140,224,248,251,255,235,248,255,255,234,32,0,16,227,1,0,0,10,
  7,128,140,224,243,251,255,235,1,144,160,227,5,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,128,140,224,235,251,255,235,248,255,255,234,32,0,16,227,1,0,0,10,7,128,140,224,230,251,255,235,4,240,157,228,
  1,144,160,227,36,0,86,229,192,0,16,227,2,0,0,26,36,112,69,226,7,128,140,224,222,251,255,235,1,144,160,227,
  36,0,214,229,192,0,16,227,2,0,0,26,36,112,133,226,7,128,140,224,215,251,255,235,4,240,157,228,4,224,45,229,
  0,0,160,227,108,6,12,229,104,6,12,229,140,82,159,229,140,98,159,229,60,144,160,227,4,0,149,228,4,0,134,228,
  1,144,89,226,251,255,255,26,164,0,0,235,204,26,28,229,200,42,28,229,196,58,28,229,192,74,28,229,184,90,28,229,
  100,22,12,229,96,38,12,229,92,54,12,229,88,70,12,229,84,86,12,229,4,8,28,229,0,0,80,227,62,0,0,218,
  64,82,159,229,64,98,159,229,60,144,160,227,4,0,149,228,4,0,134,228,1,144,89,226,251,255,255,26,4,24,28,229,
  0,40,28,229,252,55,28,229,248,71,28,229,244,87,28,229,240,103,28,229,28,24,12,229,24,40,12,229,20,56,12,229,
  16,72,12,229,12,88,12,229,8,104,12,229,131,0,0,235,204,26,28,229,200,42,28,229,196,58,28,229,192,74,28,229,
  184,90,28,229,80,22,12,229,76,38,12,229,72,54,12,229,68,70,12,229,64,86,12,229,236,7,28,229,0,0,80,227,
  29,0,0,218,196,81,159,229,196,97,159,229,60,144,160,227,4,0,149,228,4,0,134,228,1,144,89,226,251,255,255,26,
  236,23,28,229,232,39,28,229,228,55,28,229,224,71,28,229,220,87,28,229,216,103,28,229,28,24,12,229,24,40,12,229,
  20,56,12,229,16,72,12,229,12,88,12,229,8,104,12,229,98,0,0,235,204,26,28,229,200,42,28,229,196,58,28,229,
  192,74,28,229,184,90,28,229,60,22,12,229,56,38,12,229,52,54,12,229,48,70,12,229,44,86,12,229,84,81,159,229,
  84,97,159,229,60,144,160,227,4,0,149,228,4,0,134,228,1,144,89,226,251,255,255,26,100,22,28,229,96,6,28,229,
  0,16,65,224,92,6,28,229,0,16,129,224,88,6,28,229,0,16,65,224,80,38,28,229,76,6,28,229,0,32,66,224,
  72,6,28,229,0,32,130,224,68,6,28,229,0,32,66,224,60,54,28,229,56,6,28,229,0,48,67,224,52,6,28,229,
  0,48,131,224,48,6,28,229,0,48,67,224,4,8,28,229,0,0,80,227,6,0,0,218,2,0,81,225,22,0,0,186,
  236,7,28,229,0,0,80,227,1,0,0,218,3,0,81,225,37,0,0,186,100,22,28,229,96,38,28,229,92,54,28,229,
  88,70,28,229,84,86,28,229,204,26,12,229,200,42,12,229,196,58,12,229,192,74,12,229,184,90,12,229,28,8,28,229,
  2,0,80,227,4,240,157,212,12,8,28,229,108,6,12,229,8,8,28,229,104,6,12,229,4,240,157,228,236,7,28,229,
  0,0,80,227,1,0,0,218,3,0,82,225,14,0,0,186,80,22,28,229,76,38,28,229,72,54,28,229,68,70,28,229,
  64,86,28,229,204,26,12,229,200,42,12,229,196,58,12,229,192,74,12,229,184,90,12,229,244,7,28,229,108,6,12,229,
  240,7,28,229,104,6,12,229,4,240,157,228,220,7,28,229,108,6,12,229,216,7,28,229,104,6,12,229,4,240,157,228,
  100,12,0,224,84,13,0,224,84,13,0,224,100,12,0,224,84,13,0,224,100,12,0,224,84,13,0,224,100,12,0,224,
  0,112,160,227,204,122,12,229,200,122,12,229,196,122,12,229,192,122,12,229,184,122,12,229,12,88,28,229,8,104,28,229,
  208,7,28,229,5,0,80,225,2,0,0,10,204,7,28,229,6,0,80,225,2,0,0,26,212,119,12,229,208,119,12,229,
  204,119,12,229,196,7,28,229,5,0,80,225,2,0,0,10,192,7,28,229,6,0,80,225,2,0,0,26,200,119,12,229,
  196,119,12,229,192,119,12,229,184,7,28,229,5,0,80,225,2,0,0,10,180,7,28,229,6,0,80,225,2,0,0,26,
  188,119,12,229,184,119,12,229,180,119,12,229,172,7,28,229,5,0,80,225,2,0,0,10,168,7,28,229,6,0,80,225,
  2,0,0,26,176,119,12,229,172,119,12,229,168,119,12,229,160,7,28,229,5,0,80,225,2,0,0,10,156,7,28,229,
  6,0,80,225,2,0,0,26,164,119,12,229,160,119,12,229,156,119,12,229,68,86,159,229,5,96,160,225,5,144,160,227,
  3,128,160,227,0,0,21,229,0,0,80,227,7,0,0,10,0,0,21,229,4,0,134,228,4,0,149,229,4,0,134,228,
  8,0,149,229,4,0,134,228,1,128,88,226,2,0,0,10,12,80,133,226,1,144,89,226,241,255,255,26,12,88,28,229,
  8,104,28,229,6,0,149,225,45,0,0,26,28,8,28,229,0,0,80,227,42,0,0,10,112,8,28,229,0,0,80,227,
  15,0,0,26,132,8,28,229,128,8,12,229,120,40,28,229,100,8,28,229,2,0,80,225,2,0,0,26,108,120,12,229,
  104,120,12,229,100,120,12,229,80,8,28,229,2,0,80,225,80,0,0,26,88,120,12,229,84,120,12,229,80,120,12,229,
  76,0,0,234,128,120,12,229,124,120,12,229,120,120,12,229,124,56,28,229,112,72,28,229,104,8,28,229,3,0,80,225,
  5,0,0,26,92,8,28,229,4,0,80,225,2,0,0,26,108,120,12,229,104,120,12,229,100,120,12,229,84,8,28,229,
  3,0,80,225,59,0,0,26,72,8,28,229,4,0,80,225,56,0,0,26,88,120,12,229,84,120,12,229,80,120,12,229,
  52,0,0,234,5,160,140,224,36,54,218,229,37,70,218,229,24,8,28,229,0,0,80,227,1,48,131,18,6,32,140,224,
  12,34,82,229,1,0,18,227,9,0,0,26,120,8,28,229,5,0,80,225,9,0,0,26,4,0,83,225,0,0,160,227,
  116,8,28,53,128,8,12,229,124,120,12,229,120,120,12,229,2,0,0,234,128,120,12,229,124,120,12,229,120,120,12,229,
  2,0,18,227,9,0,0,26,100,8,28,229,5,0,80,225,9,0,0,26,4,0,83,225,0,0,160,227,96,8,28,53,
  108,8,12,229,104,120,12,229,100,120,12,229,2,0,0,234,108,120,12,229,104,120,12,229,100,120,12,229,4,0,18,227,
  9,0,0,26,80,8,28,229,5,0,80,225,9,0,0,26,4,0,83,225,0,0,160,227,76,8,28,53,88,8,12,229,
  84,120,12,229,80,120,12,229,2,0,0,234,88,120,12,229,84,120,12,229,80,120,12,229,128,8,28,229,108,40,28,229,
  2,0,80,225,9,0,0,170,128,40,12,229,108,8,12,229,124,8,28,229,104,40,28,229,124,40,12,229,104,8,12,229,
  120,8,28,229,100,40,28,229,120,40,12,229,100,8,12,229,108,8,28,229,88,40,28,229,2,0,80,225,9,0,0,170,
  108,40,12,229,88,8,12,229,104,8,28,229,84,40,28,229,104,40,12,229,84,8,12,229,100,8,28,229,80,40,28,229,
  100,40,12,229,80,8,12,229,128,8,28,229,108,40,28,229,2,0,80,225,9,0,0,170,128,40,12,229,108,8,12,229,
  124,8,28,229,104,40,28,229,124,40,12,229,104,8,12,229,120,8,28,229,100,40,28,229,120,40,12,229,100,8,12,229,
  16,8,28,229,20,40,28,229,28,56,28,229,2,0,128,224,1,0,80,227,1,0,0,42,1,0,83,227,1,0,160,51,
  204,10,12,229,124,88,28,229,120,104,28,229,212,71,28,229,208,7,28,229,6,0,80,225,2,0,0,10,204,7,28,229,
  5,0,80,225,14,0,0,26,200,71,28,229,196,7,28,229,6,0,80,225,2,0,0,10,192,7,28,229,5,0,80,225,
  7,0,0,26,188,71,28,229,184,7,28,229,6,0,80,225,2,0,0,10,180,7,28,229,5,0,80,225,0,0,0,26,
  0,64,160,227,212,7,28,229,4,0,64,224,128,72,28,229,4,0,128,224,2,0,80,225,17,0,0,170,4,48,67,224,
  184,58,12,229,108,8,28,229,104,88,28,229,100,104,28,229,88,8,12,229,84,88,12,229,80,104,12,229,128,8,28,229,
  124,88,28,229,120,104,28,229,108,8,12,229,104,88,12,229,100,104,12,229,128,40,12,229,124,120,12,229,120,120,12,229,
  85,0,0,234,2,48,67,224,184,58,12,229,124,88,28,229,120,104,28,229,104,8,28,229,5,0,80,225,2,0,0,10,
  100,8,28,229,6,0,80,225,2,0,0,26,108,120,12,229,104,120,12,229,100,120,12,229,84,8,28,229,5,0,80,225,
  2,0,0,10,80,8,28,229,6,0,80,225,2,0,0,26,88,120,12,229,84,120,12,229,80,120,12,229,108,8,28,229,
  0,0,80,227,8,0,0,26,88,8,28,229,108,8,12,229,84,8,28,229,104,8,12,229,80,8,28,229,100,8,12,229,
  88,120,12,229,84,120,12,229,80,120,12,229,108,8,28,229,2,0,80,225,8,0,0,42,108,8,28,229,88,8,12,229,
  104,8,28,229,84,8,12,229,100,8,28,229,80,8,12,229,108,40,12,229,104,120,12,229,100,120,12,229,208,7,28,229,
  6,0,80,225,2,0,0,10,204,7,28,229,5,0,80,225,33,0,0,26,128,8,28,229,1,0,80,227,1,0,160,51,
  200,10,12,229,196,7,28,229,6,0,80,225,9,0,0,10,192,7,28,229,5,0,80,225,6,0,0,10,200,7,28,229,
  196,87,28,229,192,103,28,229,212,7,12,229,208,87,12,229,204,103,12,229,67,0,0,234,184,7,28,229,6,0,80,225,
  9,0,0,10,180,7,28,229,5,0,80,225,6,0,0,10,188,7,28,229,184,87,28,229,180,103,28,229,212,7,12,229,
  208,87,12,229,204,103,12,229,54,0,0,234,212,119,12,229,208,119,12,229,204,119,12,229,50,0,0,234,128,8,28,229,
  1,0,80,227,1,0,160,227,128,8,12,181,204,103,28,229,6,160,140,224,60,10,218,229,0,0,80,227,5,0,0,26,
  9,2,90,229,0,0,80,227,2,0,0,10,128,8,28,229,200,10,12,229,35,0,0,234,200,39,28,229,196,87,28,229,
  192,103,28,229,204,7,28,229,6,0,80,225,8,0,0,26,188,39,28,229,184,87,28,229,180,103,28,229,204,7,28,229,
  6,0,80,225,2,0,0,26,0,32,160,227,0,80,160,227,0,96,160,227,212,71,28,229,2,64,68,224,128,8,28,229,
  0,0,84,225,232,255,255,218,200,122,12,229,212,39,12,229,208,87,12,229,204,103,12,229,108,40,28,229,104,88,28,229,
  100,104,28,229,88,40,12,229,84,88,12,229,80,104,12,229,128,40,28,229,124,88,28,229,120,104,28,229,108,40,12,229,
  104,88,12,229,100,104,12,229,212,23,28,229,108,40,28,229,88,56,28,229,208,87,28,229,204,103,28,229,1,0,81,227,
  1,16,160,211,1,0,82,227,1,32,160,211,1,0,83,227,1,48,160,211,104,8,28,229,6,0,80,225,2,0,0,10,
  100,8,28,229,5,0,80,225,10,0,0,26,196,26,12,229,1,0,160,227,192,10,12,229,84,8,28,229,6,0,80,225,
  14,240,160,1,80,8,28,229,5,0,80,225,14,240,160,1,192,58,12,229,14,240,160,225,3,64,160,225,84,8,28,229,
  6,0,80,225,2,0,0,10,80,8,28,229,5,0,80,225,0,0,0,26,1,64,160,227,2,64,68,224,0,64,100,226,
  1,0,84,225,2,0,0,202,196,26,12,229,192,42,12,229,14,240,160,225,196,122,12,229,192,58,12,229,14,240,160,225,
  20,13,0,224,4,224,45,229,64,0,45,233,61,171,255,235,0,177,255,235,53,176,255,235,64,0,189,232,80,11,28,229,
  0,0,80,227,1,0,0,10,4,224,157,228,102,16,0,234,152,95,28,229,84,0,85,227,9,0,0,58,5,128,140,224,
  0,0,88,229,30,0,0,226,13,18,216,229,1,0,128,225,128,0,143,224,228,252,144,229,152,95,24,229,84,0,85,227,
  245,255,255,42,78,25,0,235,4,240,157,228,40,0,88,229,192,0,16,227,5,0,0,26,40,112,69,226,204,0,87,227,
  7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,240,255,255,234,40,112,69,226,11,0,0,234,204,0,87,227,
  5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,7,3,160,225,
  37,1,128,224,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,240,255,255,10,32,0,16,227,10,0,0,10,
  204,0,87,227,5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,
  7,3,160,225,37,1,128,224,4,0,134,228,209,255,255,234,84,0,88,229,192,0,16,227,11,0,0,26,84,112,69,226,
  204,0,87,227,5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,
  7,3,160,225,37,1,128,224,4,0,134,228,76,0,88,229,192,0,16,227,11,0,0,26,76,112,69,226,204,0,87,227,
  5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,7,3,160,225,
  37,1,128,224,4,0,134,228,178,255,255,234,44,0,88,229,192,0,16,227,9,0,0,26,44,112,69,226,204,0,87,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  44,0,216,229,192,0,16,227,9,0,0,26,44,112,133,226,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,40,0,88,229,192,0,16,227,9,0,0,26,
  40,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,
  37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,9,0,0,26,36,112,69,226,204,0,87,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,
  192,0,16,227,9,0,0,26,36,112,133,226,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,112,255,255,234,44,0,88,229,192,0,16,227,3,0,0,26,
  44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,88,229,192,0,16,227,3,0,0,26,40,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,
  4,0,134,228,4,0,88,229,192,0,16,227,3,0,0,26,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  4,0,216,229,192,0,16,227,3,0,0,26,4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,69,255,255,234,
  44,112,69,226,5,0,0,234,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,44,112,71,226,
  7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,
  128,0,128,50,4,0,134,228,44,112,133,226,5,0,0,234,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,
  4,0,134,228,44,112,135,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,
  7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,36,112,69,226,5,0,0,234,204,0,87,227,7,3,160,225,
  37,1,128,224,128,0,128,50,4,0,134,228,36,112,71,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,
  4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,36,112,133,226,5,0,0,234,
  204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,36,112,135,226,7,0,220,231,0,0,80,227,
  246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,
  252,254,255,234,40,0,88,229,192,0,16,227,3,0,0,26,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  40,0,216,229,192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,88,229,
  192,0,16,227,3,0,0,26,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,216,229,192,0,16,227,
  3,0,0,26,4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,44,112,69,226,3,0,0,234,7,3,160,225,
  37,1,128,224,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,44,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,36,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,36,112,71,226,7,0,220,231,
  0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,36,112,133,226,
  3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,36,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,
  32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,167,254,255,234,40,112,69,226,5,0,0,234,
  204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,
  246,255,255,10,32,0,16,227,4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,
  40,112,133,226,5,0,0,234,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,40,112,135,226,
  7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,7,3,160,225,37,1,128,224,
  128,0,128,50,4,0,134,228,4,112,69,226,5,0,0,234,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,
  4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,87,227,
  7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,4,112,133,226,5,0,0,234,204,0,85,227,7,3,160,225,
  37,1,128,224,128,0,128,50,4,0,134,228,4,112,135,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,
  4,0,0,10,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,94,254,255,234,44,0,88,229,
  192,0,16,227,3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,
  3,0,0,26,44,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,3,0,0,26,
  36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,3,0,0,26,36,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,40,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  40,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,40,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,135,226,7,0,220,231,
  0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,4,112,69,226,
  3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,4,112,133,226,3,0,0,234,7,3,160,225,
  37,1,128,224,4,0,134,228,4,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,9,254,255,234,44,0,88,229,192,0,16,227,7,0,0,26,80,6,24,229,
  66,20,88,229,32,8,145,225,3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,88,229,
  192,0,16,227,7,0,0,26,76,6,24,229,62,20,88,229,32,8,145,225,3,0,0,26,40,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,7,0,0,26,72,6,24,229,58,20,88,229,32,8,145,225,
  3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,88,229,192,0,16,227,7,0,0,26,
  40,6,24,229,26,20,88,229,32,8,145,225,3,0,0,26,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  4,0,216,229,192,0,16,227,7,0,0,26,32,6,24,229,18,20,88,229,32,8,145,225,3,0,0,26,4,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,7,0,0,26,0,6,24,229,242,19,88,229,
  32,8,145,225,3,0,0,26,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,
  7,0,0,26,252,5,24,229,238,19,88,229,32,8,145,225,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,
  4,0,134,228,44,0,216,229,192,0,16,227,7,0,0,26,248,5,24,229,234,19,88,229,32,8,145,225,3,0,0,26,
  44,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,176,253,255,234,44,0,88,229,192,0,16,227,9,0,0,26,
  44,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,
  37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,9,0,0,26,44,112,133,226,204,0,85,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,149,253,255,234,
  40,0,88,229,192,0,16,227,9,0,0,26,40,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,135,253,255,234,44,0,88,229,192,0,16,227,
  3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,127,253,255,234,40,0,88,229,192,0,16,227,
  3,0,0,26,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,3,0,0,26,
  40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,112,253,255,234,36,0,88,229,192,0,16,227,3,0,0,26,
  36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,104,253,255,234,44,112,69,226,5,0,0,234,204,0,87,227,
  7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,246,255,255,10,
  32,0,16,227,4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,44,112,133,226,
  5,0,0,234,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,44,112,135,226,7,0,220,231,
  0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,
  4,0,134,228,67,253,255,234,44,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,44,112,71,226,
  7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  44,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,44,112,135,226,7,0,220,231,0,0,80,227,
  248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,38,253,255,234,40,112,69,226,
  5,0,0,234,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,40,112,71,226,7,0,220,231,
  0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,87,227,7,3,160,225,37,1,128,224,128,0,128,50,
  4,0,134,228,40,112,133,226,5,0,0,234,204,0,85,227,7,3,160,225,37,1,128,224,128,0,128,50,4,0,134,228,
  40,112,135,226,7,0,220,231,0,0,80,227,246,255,255,10,32,0,16,227,4,0,0,10,204,0,85,227,7,3,160,225,
  37,1,128,224,128,0,128,50,4,0,134,228,1,253,255,234,44,0,88,229,192,0,16,227,3,0,0,26,44,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,3,0,0,26,44,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,242,252,255,234,40,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  40,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,40,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,135,226,7,0,220,231,
  0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,213,252,255,234,
  36,0,88,229,192,0,16,227,3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,
  192,0,16,227,3,0,0,26,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,198,252,255,234,12,100,1,0,
  52,102,1,0,52,100,1,0,52,102,1,0,176,100,1,0,52,102,1,0,44,101,1,0,52,102,1,0,52,102,1,0,
  0,0,0,0,224,102,1,0,4,104,1,0,88,105,1,0,124,106,1,0,208,107,1,0,0,0,0,0,248,99,1,0,
  216,109,1,0,248,99,1,0,216,109,1,0,248,99,1,0,216,109,1,0,52,109,1,0,216,109,1,0,216,109,1,0,
  0,0,0,0,84,110,1,0,232,110,1,0,248,99,1,0,240,111,1,0,248,99,1,0,0,0,0,0,12,100,1,0,
  248,109,1,0,52,100,1,0,248,109,1,0,248,99,1,0,248,109,1,0,160,109,1,0,248,109,1,0,248,109,1,0,
  0,0,0,0,248,99,1,0,248,109,1,0,92,111,1,0,44,112,1,0,248,99,1,0,0,0,0,0,248,99,1,0,
  52,110,1,0,248,99,1,0,52,110,1,0,248,99,1,0,52,110,1,0,200,101,1,0,52,110,1,0,52,110,1,0,
  0,0,0,0,112,103,1,0,228,104,1,0,248,99,1,0,160,112,1,0,248,99,1,0,0,0,0,0,248,99,1,0,
  164,102,1,0,248,99,1,0,164,102,1,0,248,99,1,0,164,102,1,0,248,99,1,0,164,102,1,0,164,102,1,0,
  0,0,0,0,248,99,1,0,164,102,1,0,232,105,1,0,92,107,1,0,248,99,1,0,0,0,0,0,4,224,45,229,
  64,0,45,233,159,167,255,235,98,173,255,235,209,172,255,235,150,172,255,235,64,0,189,232,80,11,28,229,0,0,80,227,
  1,0,0,10,4,224,157,228,172,12,0,234,164,95,28,229,16,0,0,235,157,1,0,235,4,240,157,228,4,224,45,229,
  64,0,45,233,83,173,255,235,194,172,255,235,135,172,255,235,64,0,189,232,80,11,28,229,0,0,80,227,1,0,0,10,
  4,224,157,228,157,12,0,234,164,95,28,229,208,0,0,235,142,1,0,235,4,240,157,228,194,15,92,229,0,0,80,227,
  13,0,0,10,84,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,2,0,128,227,4,0,134,228,
  76,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,2,0,128,227,4,0,134,228,196,15,92,229,
  0,0,80,227,12,0,0,10,5,0,139,224,36,11,16,229,0,0,140,224,128,11,80,229,0,0,80,227,6,0,0,26,
  40,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,0,0,128,227,4,0,134,228,193,15,92,229,
  0,0,80,227,34,0,0,10,40,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,
  4,0,134,228,44,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,
  36,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,36,112,69,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,44,112,69,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,192,15,92,229,0,0,80,227,41,0,0,10,
  40,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,44,112,133,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,36,112,133,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,4,112,133,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,4,112,69,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,3,160,225,4,0,128,227,4,0,134,228,40,112,69,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,
  4,0,128,227,4,0,134,228,190,15,92,229,0,0,80,227,35,0,0,10,40,112,133,226,3,0,0,234,7,3,160,225,
  6,0,128,227,4,0,134,228,40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,4,112,133,226,3,0,0,234,
  7,3,160,225,6,0,128,227,4,0,134,228,4,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,4,112,69,226,
  3,0,0,234,7,3,160,225,6,0,128,227,4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  40,112,69,226,3,0,0,234,7,3,160,225,6,0,128,227,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,
  248,255,255,10,191,15,92,229,0,0,80,227,35,0,0,10,44,112,133,226,3,0,0,234,7,3,160,225,5,0,128,227,
  4,0,134,228,44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,36,112,133,226,3,0,0,234,7,3,160,225,
  5,0,128,227,4,0,134,228,36,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,36,112,69,226,3,0,0,234,
  7,3,160,225,5,0,128,227,4,0,134,228,36,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,44,112,69,226,
  3,0,0,234,7,3,160,225,5,0,128,227,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  195,15,92,229,0,0,80,227,8,0,0,10,40,112,133,226,3,0,0,234,7,3,160,225,1,0,128,227,4,0,134,228,
  40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,14,240,160,225,194,15,92,229,0,0,80,227,13,0,0,10,
  84,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,2,0,128,227,4,0,134,228,76,112,133,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,2,0,128,227,4,0,134,228,193,15,92,229,0,0,80,227,
  34,0,0,10,40,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,
  44,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,36,112,133,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,36,112,69,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,44,112,69,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,3,160,225,3,0,128,227,4,0,134,228,192,15,92,229,0,0,80,227,41,0,0,10,40,112,133,226,
  7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,44,112,133,226,7,0,220,231,
  0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,36,112,133,226,7,0,220,231,0,0,80,227,
  2,0,0,26,7,3,160,225,4,0,128,227,4,0,134,228,4,112,133,226,7,0,220,231,0,0,80,227,2,0,0,26,
  7,3,160,225,4,0,128,227,4,0,134,228,4,112,69,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,
  4,0,128,227,4,0,134,228,40,112,69,226,7,0,220,231,0,0,80,227,2,0,0,26,7,3,160,225,4,0,128,227,
  4,0,134,228,190,15,92,229,0,0,80,227,35,0,0,10,40,112,133,226,3,0,0,234,7,3,160,225,6,0,128,227,
  4,0,134,228,40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,4,112,133,226,3,0,0,234,7,3,160,225,
  6,0,128,227,4,0,134,228,4,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,4,112,69,226,3,0,0,234,
  7,3,160,225,6,0,128,227,4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,40,112,69,226,
  3,0,0,234,7,3,160,225,6,0,128,227,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,
  191,15,92,229,0,0,80,227,35,0,0,10,44,112,133,226,3,0,0,234,7,3,160,225,5,0,128,227,4,0,134,228,
  44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,36,112,133,226,3,0,0,234,7,3,160,225,5,0,128,227,
  4,0,134,228,36,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,36,112,69,226,3,0,0,234,7,3,160,225,
  5,0,128,227,4,0,134,228,36,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,44,112,69,226,3,0,0,234,
  7,3,160,225,5,0,128,227,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,248,255,255,10,195,15,92,229,
  0,0,80,227,8,0,0,10,40,112,133,226,3,0,0,234,7,3,160,225,1,0,128,227,4,0,134,228,40,112,135,226,
  7,0,220,231,0,0,80,227,248,255,255,10,14,240,160,225,152,95,28,229,84,0,85,227,16,0,0,58,5,128,140,224,
  15,2,216,229,160,2,143,224,184,66,208,229,0,0,88,229,30,0,0,226,13,18,216,229,1,0,128,225,0,0,84,227,
  1,0,0,26,128,0,143,224,24,240,144,229,128,0,143,224,80,241,144,229,152,95,24,229,84,0,85,227,238,255,255,42,
  14,240,160,225,172,123,1,0,128,126,1,0,248,123,1,0,128,126,1,0,128,124,1,0,128,126,1,0,20,125,1,0,
  128,126,1,0,128,126,1,0,0,0,0,0,116,127,1,0,120,130,1,0,124,132,1,0,128,135,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,100,138,1,0,20,121,1,0,100,138,1,0,20,121,1,0,100,138,1,0,132,137,1,0,
  100,138,1,0,100,138,1,0,0,0,0,0,16,139,1,0,148,140,1,0,20,121,1,0,116,143,1,0,20,121,1,0,
  0,0,0,0,172,123,1,0,144,138,1,0,248,123,1,0,144,138,1,0,20,121,1,0,144,138,1,0,24,138,1,0,
  144,138,1,0,144,138,1,0,0,0,0,0,20,121,1,0,72,141,1,0,240,141,1,0,200,143,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,228,138,1,0,20,121,1,0,228,138,1,0,20,121,1,0,228,138,1,0,236,125,1,0,
  228,138,1,0,228,138,1,0,0,0,0,0,244,128,1,0,200,131,1,0,20,121,1,0,124,144,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,32,127,1,0,20,121,1,0,32,127,1,0,20,121,1,0,32,127,1,0,20,121,1,0,
  32,127,1,0,32,127,1,0,0,0,0,0,20,121,1,0,156,141,1,0,252,133,1,0,208,136,1,0,20,121,1,0,
  0,0,0,0,208,144,1,0,104,148,1,0,72,145,1,0,104,148,1,0,204,145,1,0,104,148,1,0,72,146,1,0,
  104,148,1,0,104,148,1,0,0,0,0,0,140,149,1,0,136,151,1,0,44,153,1,0,40,155,1,0,204,156,1,0,
  0,0,0,0,20,121,1,0,188,159,1,0,20,121,1,0,188,159,1,0,20,121,1,0,188,159,1,0,112,158,1,0,
  188,159,1,0,188,159,1,0,0,0,0,0,136,160,1,0,136,161,1,0,20,121,1,0,196,163,1,0,20,121,1,0,
  0,0,0,0,208,144,1,0,240,159,1,0,72,145,1,0,240,159,1,0,20,121,1,0,240,159,1,0,76,159,1,0,
  240,159,1,0,240,159,1,0,0,0,0,0,20,121,1,0,252,161,1,0,196,162,1,0,40,164,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,84,160,1,0,20,121,1,0,84,160,1,0,20,121,1,0,84,160,1,0,140,147,1,0,
  84,160,1,0,84,160,1,0,0,0,0,0,136,150,1,0,184,152,1,0,20,121,1,0,156,164,1,0,20,121,1,0,
  0,0,0,0,20,121,1,0,40,149,1,0,20,121,1,0,40,149,1,0,20,121,1,0,40,149,1,0,20,121,1,0,
  40,149,1,0,40,149,1,0,0,0,0,0,20,121,1,0,96,162,1,0,40,154,1,0,88,156,1,0,20,121,1,0,
  0,0,0,0,0,14,13,11,7,0,0,0,40,0,88,229,192,0,16,227,14,0,0,26,230,17,216,229,16,0,17,227,
  11,0,0,10,40,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  1,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,70,255,255,234,5,112,160,225,40,112,71,226,
  7,0,220,231,0,0,80,227,10,0,0,26,7,16,140,224,14,18,209,229,16,0,17,227,247,255,255,10,204,0,87,227,
  245,255,255,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,240,255,255,234,32,0,16,227,14,0,0,10,
  7,16,140,224,14,18,209,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,2,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,36,255,255,234,
  84,0,88,229,192,0,16,227,14,0,0,26,84,112,69,226,186,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,4,0,17,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,76,0,88,229,192,0,16,227,14,0,0,26,76,112,69,226,194,17,216,229,16,0,17,227,
  5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,4,0,17,227,
  2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,255,254,255,234,44,0,88,229,192,0,16,227,14,0,0,26,
  44,112,69,226,226,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,
  192,0,16,227,14,0,0,26,44,112,133,226,58,18,216,229,16,0,17,227,5,0,0,10,204,0,85,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,40,0,88,229,192,0,16,227,14,0,0,26,40,112,69,226,230,17,216,229,16,0,17,227,5,0,0,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,14,0,0,26,36,112,69,226,234,17,216,229,
  16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,14,0,0,26,
  36,112,133,226,50,18,216,229,16,0,17,227,5,0,0,10,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,164,254,255,234,
  226,1,216,229,16,0,16,227,6,0,0,10,44,0,88,229,192,0,16,227,3,0,0,26,44,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,230,1,216,229,16,0,16,227,6,0,0,10,40,0,88,229,192,0,16,227,3,0,0,26,
  40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,54,2,216,229,16,0,16,227,6,0,0,10,40,0,216,229,
  192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,234,1,216,229,16,0,16,227,
  6,0,0,10,36,0,88,229,192,0,16,227,3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  10,2,216,229,16,0,16,227,6,0,0,10,4,0,88,229,192,0,16,227,3,0,0,26,4,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,18,2,216,229,16,0,16,227,6,0,0,10,4,0,216,229,192,0,16,227,3,0,0,26,
  4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,103,254,255,234,5,112,160,225,44,112,71,226,7,0,220,231,
  0,0,80,227,15,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,204,0,87,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,239,255,255,10,7,3,160,225,37,1,128,224,
  4,0,134,228,235,255,255,234,32,0,16,227,14,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,10,0,0,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,204,0,85,227,33,0,0,42,44,112,135,226,7,0,220,231,
  0,0,80,227,13,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,32,0,17,227,241,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,237,255,255,234,
  32,0,16,227,34,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,30,0,0,10,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,32,0,17,227,24,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,20,0,0,234,
  44,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,32,0,17,227,247,255,255,10,
  7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,
  32,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,36,112,71,226,7,0,220,231,
  0,0,80,227,15,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,204,0,87,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,239,255,255,10,7,3,160,225,37,1,128,224,
  4,0,134,228,235,255,255,234,32,0,16,227,14,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,10,0,0,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,204,0,85,227,33,0,0,42,36,112,135,226,7,0,220,231,
  0,0,80,227,13,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,32,0,17,227,241,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,237,255,255,234,
  32,0,16,227,34,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,30,0,0,10,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,32,0,17,227,24,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,20,0,0,234,
  36,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,32,0,17,227,247,255,255,10,
  7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,
  32,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,166,253,255,234,230,1,216,229,48,0,16,227,
  6,0,0,10,40,0,88,229,192,0,16,227,3,0,0,26,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  54,2,216,229,48,0,16,227,6,0,0,10,40,0,216,229,192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,10,2,216,229,48,0,16,227,6,0,0,10,4,0,88,229,192,0,16,227,3,0,0,26,
  4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,18,2,216,229,48,0,16,227,6,0,0,10,4,0,216,229,
  192,0,16,227,3,0,0,26,4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,44,112,71,226,
  7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,48,0,17,227,247,255,255,10,7,3,160,225,
  37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,48,0,17,227,
  2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,
  7,0,0,26,7,16,140,224,14,18,209,229,48,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,
  243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,48,0,17,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,5,112,160,225,36,112,71,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,
  14,18,209,229,48,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,
  6,0,0,10,7,16,140,224,14,18,209,229,48,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  5,112,160,225,36,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,48,0,17,227,
  247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,
  14,18,209,229,48,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,37,253,255,234,5,112,160,225,
  40,112,71,226,7,0,220,231,0,0,80,227,15,0,0,26,7,16,140,224,14,18,209,229,88,0,17,227,247,255,255,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,64,0,17,227,239,255,255,10,
  7,3,160,225,37,1,128,224,4,0,134,228,235,255,255,234,32,0,16,227,14,0,0,10,7,16,140,224,14,18,209,229,
  88,0,17,227,10,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  64,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,204,0,85,227,33,0,0,42,
  40,112,135,226,7,0,220,231,0,0,80,227,13,0,0,26,7,16,140,224,14,18,209,229,88,0,17,227,247,255,255,10,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,64,0,17,227,241,255,255,10,7,3,160,225,37,1,128,224,
  4,0,134,228,237,255,255,234,32,0,16,227,34,0,0,10,7,16,140,224,14,18,209,229,88,0,17,227,30,0,0,10,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,64,0,17,227,24,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,20,0,0,234,40,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,
  64,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,
  7,16,140,224,14,18,209,229,64,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,
  4,112,71,226,7,0,220,231,0,0,80,227,15,0,0,26,7,16,140,224,14,18,209,229,88,0,17,227,247,255,255,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,64,0,17,227,239,255,255,10,
  7,3,160,225,37,1,128,224,4,0,134,228,235,255,255,234,32,0,16,227,14,0,0,10,7,16,140,224,14,18,209,229,
  88,0,17,227,10,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  64,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,204,0,85,227,33,0,0,42,
  4,112,135,226,7,0,220,231,0,0,80,227,13,0,0,26,7,16,140,224,14,18,209,229,88,0,17,227,247,255,255,10,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,64,0,17,227,241,255,255,10,7,3,160,225,37,1,128,224,
  4,0,134,228,237,255,255,234,32,0,16,227,34,0,0,10,7,16,140,224,14,18,209,229,88,0,17,227,30,0,0,10,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,64,0,17,227,24,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,20,0,0,234,4,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,
  64,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,
  7,16,140,224,14,18,209,229,64,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,100,252,255,234,
  226,1,216,229,72,0,16,227,6,0,0,10,44,0,88,229,192,0,16,227,3,0,0,26,44,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,58,2,216,229,72,0,16,227,6,0,0,10,44,0,216,229,192,0,16,227,3,0,0,26,
  44,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,234,1,216,229,72,0,16,227,6,0,0,10,36,0,88,229,
  192,0,16,227,3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,50,2,216,229,72,0,16,227,
  6,0,0,10,36,0,216,229,192,0,16,227,3,0,0,26,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,
  5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,72,0,17,227,
  247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,
  14,18,209,229,72,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,40,112,135,226,
  7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,72,0,17,227,247,255,255,10,7,3,160,225,
  37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,72,0,17,227,
  2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,
  7,0,0,26,7,16,140,224,14,18,209,229,72,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,
  243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,72,0,17,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,5,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,
  14,18,209,229,72,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,
  6,0,0,10,7,16,140,224,14,18,209,229,72,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  227,251,255,234,44,0,88,229,192,0,16,227,14,0,0,26,44,112,69,226,226,17,216,229,16,0,17,227,5,0,0,10,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,14,0,0,26,44,112,133,226,58,18,216,229,
  16,0,17,227,5,0,0,10,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,190,251,255,234,40,0,88,229,192,0,16,227,
  14,0,0,26,40,112,69,226,230,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  171,251,255,234,226,1,216,229,16,0,16,227,6,0,0,10,44,0,88,229,192,0,16,227,3,0,0,26,44,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,160,251,255,234,230,1,216,229,16,0,16,227,6,0,0,10,40,0,88,229,
  192,0,16,227,3,0,0,26,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,54,2,216,229,16,0,16,227,
  6,0,0,10,40,0,216,229,192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,
  139,251,255,234,234,1,216,229,16,0,16,227,6,0,0,10,36,0,88,229,192,0,16,227,3,0,0,26,36,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,128,251,255,234,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,
  15,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,239,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,
  235,255,255,234,32,0,16,227,14,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,10,0,0,10,204,0,87,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,32,0,17,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,5,112,160,225,204,0,85,227,33,0,0,42,44,112,135,226,7,0,220,231,0,0,80,227,
  13,0,0,26,7,16,140,224,14,18,209,229,56,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,32,0,17,227,241,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,237,255,255,234,32,0,16,227,
  34,0,0,10,7,16,140,224,14,18,209,229,56,0,17,227,30,0,0,10,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,32,0,17,227,24,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,20,0,0,234,44,112,135,226,
  7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,32,0,17,227,247,255,255,10,7,3,160,225,
  37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,32,0,17,227,
  2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,31,251,255,234,5,112,160,225,44,112,71,226,7,0,220,231,
  0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,48,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,
  4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,48,0,17,227,2,0,0,10,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,
  7,16,140,224,14,18,209,229,48,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,
  32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,48,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,242,250,255,234,230,1,216,229,48,0,16,227,6,0,0,10,40,0,88,229,192,0,16,227,3,0,0,26,
  40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,54,2,216,229,48,0,16,227,6,0,0,10,40,0,216,229,
  192,0,16,227,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,221,250,255,234,10,2,216,229,
  48,0,16,227,6,0,0,10,4,0,88,229,192,0,16,227,3,0,0,26,4,112,69,226,7,3,160,225,37,1,128,224,
  4,0,134,228,18,2,216,229,48,0,16,227,6,0,0,10,4,0,216,229,192,0,16,227,3,0,0,26,4,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,200,250,255,234,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,
  15,0,0,26,7,16,140,224,14,18,209,229,88,0,17,227,247,255,255,10,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,64,0,17,227,239,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,
  235,255,255,234,32,0,16,227,14,0,0,10,7,16,140,224,14,18,209,229,88,0,17,227,10,0,0,10,204,0,87,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,64,0,17,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,5,112,160,225,204,0,85,227,33,0,0,42,40,112,135,226,7,0,220,231,0,0,80,227,
  13,0,0,26,7,16,140,224,14,18,209,229,88,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,64,0,17,227,241,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,237,255,255,234,32,0,16,227,
  34,0,0,10,7,16,140,224,14,18,209,229,88,0,17,227,30,0,0,10,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,64,0,17,227,24,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,20,0,0,234,40,112,135,226,
  7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,64,0,17,227,247,255,255,10,7,3,160,225,
  37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,14,18,209,229,64,0,17,227,
  2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,103,250,255,234,226,1,216,229,72,0,16,227,6,0,0,10,
  44,0,88,229,192,0,16,227,3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,58,2,216,229,
  72,0,16,227,6,0,0,10,44,0,216,229,192,0,16,227,3,0,0,26,44,112,133,226,7,3,160,225,37,1,128,224,
  4,0,134,228,82,250,255,234,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,
  14,18,209,229,72,0,17,227,247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,
  6,0,0,10,7,16,140,224,14,18,209,229,72,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  5,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,7,0,0,26,7,16,140,224,14,18,209,229,72,0,17,227,
  247,255,255,10,7,3,160,225,37,1,128,224,4,0,134,228,243,255,255,234,32,0,16,227,6,0,0,10,7,16,140,224,
  14,18,209,229,72,0,17,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,37,250,255,234,234,1,216,229,
  72,0,16,227,6,0,0,10,36,0,88,229,192,0,16,227,3,0,0,26,36,112,69,226,7,3,160,225,37,1,128,224,
  4,0,134,228,50,2,216,229,72,0,16,227,6,0,0,10,36,0,216,229,192,0,16,227,3,0,0,26,36,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,16,250,255,234,40,0,88,229,192,0,16,227,25,0,0,26,40,112,69,226,
  2,0,20,227,11,0,0,26,230,17,216,229,16,0,17,227,19,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,1,0,17,227,11,0,0,10,7,0,0,234,204,0,87,227,5,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,124,0,87,227,2,0,0,58,7,3,160,225,37,1,128,224,
  4,0,134,228,242,249,255,234,2,0,20,227,29,0,0,10,40,112,69,226,11,0,0,234,204,0,87,227,5,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,124,0,87,227,2,0,0,58,7,3,160,225,37,1,128,224,
  4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,240,255,255,10,32,0,16,227,10,0,0,10,204,0,87,227,
  5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,124,0,87,227,2,0,0,58,7,3,160,225,
  37,1,128,224,4,0,134,228,209,249,255,234,84,0,88,229,192,0,16,227,11,0,0,26,84,112,69,226,204,0,87,227,
  5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,7,3,160,225,
  37,1,128,224,4,0,134,228,76,0,88,229,192,0,16,227,11,0,0,26,76,112,69,226,204,0,87,227,5,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,7,3,160,225,37,1,128,224,
  4,0,134,228,178,249,255,234,44,0,88,229,192,0,16,227,23,0,0,26,44,112,69,226,1,0,20,227,11,0,0,26,
  226,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,8,0,17,227,9,0,0,10,5,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,23,0,0,26,
  44,112,133,226,1,0,20,227,11,0,0,26,58,18,216,229,16,0,17,227,5,0,0,10,204,0,85,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,9,0,0,10,5,0,0,234,204,0,85,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  40,0,88,229,192,0,16,227,23,0,0,26,40,112,69,226,2,0,20,227,11,0,0,26,230,17,216,229,16,0,17,227,
  5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,
  9,0,0,10,5,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  7,3,160,225,37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,23,0,0,26,36,112,69,226,4,0,20,227,
  11,0,0,26,234,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,8,0,17,227,9,0,0,10,5,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,
  23,0,0,26,36,112,133,226,4,0,20,227,11,0,0,26,50,18,216,229,16,0,17,227,5,0,0,10,204,0,85,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,9,0,0,10,5,0,0,234,
  204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,
  4,0,134,228,42,249,255,234,44,0,88,229,192,0,16,227,8,0,0,26,226,17,216,229,16,0,17,227,1,0,0,26,
  1,0,20,227,3,0,0,10,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,88,229,192,0,16,227,
  8,0,0,26,230,17,216,229,16,0,17,227,1,0,0,26,2,0,20,227,3,0,0,10,40,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,8,0,0,26,54,18,216,229,16,0,17,227,1,0,0,26,
  2,0,20,227,3,0,0,10,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,
  8,0,0,26,234,17,216,229,16,0,17,227,1,0,0,26,4,0,20,227,3,0,0,10,36,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,4,0,88,229,192,0,16,227,8,0,0,26,10,18,216,229,16,0,17,227,1,0,0,26,
  8,0,20,227,3,0,0,10,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,216,229,192,0,16,227,
  8,0,0,26,18,18,216,229,16,0,17,227,1,0,0,26,8,0,20,227,3,0,0,10,4,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,225,248,255,234,44,112,69,226,9,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,44,112,71,226,7,0,220,231,
  0,0,80,227,242,255,255,10,32,0,16,227,8,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,204,0,85,227,20,0,0,42,44,112,133,226,
  6,0,0,234,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,128,0,64,226,4,0,134,228,44,112,135,226,
  7,0,220,231,0,0,80,227,245,255,255,10,32,0,16,227,20,0,0,10,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,128,0,64,226,4,0,134,228,13,0,0,234,44,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,
  4,0,134,228,44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,36,112,69,226,9,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,36,112,71,226,7,0,220,231,0,0,80,227,
  242,255,255,10,32,0,16,227,8,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,204,0,85,227,20,0,0,42,36,112,133,226,6,0,0,234,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,128,0,64,226,4,0,134,228,36,112,135,226,7,0,220,231,
  0,0,80,227,245,255,255,10,32,0,16,227,20,0,0,10,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  128,0,64,226,4,0,134,228,13,0,0,234,36,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  36,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,98,248,255,234,40,0,88,229,192,0,16,227,8,0,0,26,230,17,216,229,48,0,17,227,1,0,0,26,
  2,0,20,227,3,0,0,10,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,
  8,0,0,26,54,18,216,229,48,0,17,227,1,0,0,26,2,0,20,227,3,0,0,10,40,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,4,0,88,229,192,0,16,227,8,0,0,26,10,18,216,229,48,0,17,227,1,0,0,26,
  8,0,20,227,3,0,0,10,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,216,229,192,0,16,227,
  8,0,0,26,18,18,216,229,48,0,17,227,1,0,0,26,8,0,20,227,3,0,0,10,4,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,44,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,44,112,71,226,
  7,0,220,231,224,0,16,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  44,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,44,112,135,226,7,0,220,231,224,0,16,227,
  248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,36,112,69,226,3,0,0,234,
  7,3,160,225,37,1,128,224,4,0,134,228,36,112,71,226,7,0,220,231,224,0,16,227,248,255,255,10,32,0,16,227,
  2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,36,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,
  4,0,134,228,36,112,135,226,7,0,220,231,224,0,16,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,249,247,255,234,40,112,69,226,9,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,40,112,71,226,7,0,220,231,
  0,0,80,227,242,255,255,10,32,0,16,227,8,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,204,0,85,227,20,0,0,42,40,112,133,226,
  6,0,0,234,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,128,0,64,226,4,0,134,228,40,112,135,226,
  7,0,220,231,0,0,80,227,245,255,255,10,32,0,16,227,20,0,0,10,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,128,0,64,226,4,0,134,228,13,0,0,234,40,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,
  4,0,134,228,40,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,4,112,69,226,9,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,4,112,71,226,7,0,220,231,0,0,80,227,
  242,255,255,10,32,0,16,227,8,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,204,0,85,227,20,0,0,42,4,112,133,226,6,0,0,234,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,128,0,64,226,4,0,134,228,4,112,135,226,7,0,220,231,
  0,0,80,227,245,255,255,10,32,0,16,227,20,0,0,10,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  128,0,64,226,4,0,134,228,13,0,0,234,4,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  4,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,122,247,255,234,44,0,88,229,192,0,16,227,8,0,0,26,226,17,216,229,72,0,17,227,1,0,0,26,
  1,0,20,227,3,0,0,10,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,
  8,0,0,26,58,18,216,229,72,0,17,227,1,0,0,26,1,0,20,227,3,0,0,10,44,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,36,0,88,229,192,0,16,227,8,0,0,26,234,17,216,229,72,0,17,227,1,0,0,26,
  4,0,20,227,3,0,0,10,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,
  8,0,0,26,50,18,216,229,72,0,17,227,1,0,0,26,4,0,20,227,3,0,0,10,36,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,40,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,71,226,
  7,0,220,231,224,0,16,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  40,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,135,226,7,0,220,231,224,0,16,227,
  248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,4,112,69,226,3,0,0,234,
  7,3,160,225,37,1,128,224,4,0,134,228,4,112,71,226,7,0,220,231,224,0,16,227,248,255,255,10,32,0,16,227,
  2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,4,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,
  4,0,134,228,4,112,135,226,7,0,220,231,224,0,16,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,
  37,1,128,224,4,0,134,228,17,247,255,234,1,0,20,227,10,0,0,10,44,0,88,229,192,0,16,227,7,0,0,26,
  80,6,24,229,66,20,88,229,32,8,145,225,3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  2,0,20,227,10,0,0,10,40,0,88,229,192,0,16,227,7,0,0,26,76,6,24,229,62,20,88,229,32,8,145,225,
  3,0,0,26,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,20,227,10,0,0,10,36,0,88,229,
  192,0,16,227,7,0,0,26,72,6,24,229,58,20,88,229,32,8,145,225,3,0,0,26,36,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,8,0,20,227,10,0,0,10,4,0,88,229,192,0,16,227,7,0,0,26,40,6,24,229,
  26,20,88,229,32,8,145,225,3,0,0,26,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,8,0,20,227,
  10,0,0,10,4,0,216,229,192,0,16,227,7,0,0,26,32,6,24,229,18,20,88,229,32,8,145,225,3,0,0,26,
  4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,20,227,10,0,0,10,36,0,216,229,192,0,16,227,
  7,0,0,26,0,6,24,229,242,19,88,229,32,8,145,225,3,0,0,26,36,112,133,226,7,3,160,225,37,1,128,224,
  4,0,134,228,2,0,20,227,10,0,0,10,40,0,216,229,192,0,16,227,7,0,0,26,252,5,24,229,238,19,88,229,
  32,8,145,225,3,0,0,26,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,1,0,20,227,10,0,0,10,
  44,0,216,229,192,0,16,227,7,0,0,26,248,5,24,229,234,19,88,229,32,8,145,225,3,0,0,26,44,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,168,246,255,234,44,0,88,229,192,0,16,227,23,0,0,26,44,112,69,226,
  1,0,20,227,11,0,0,26,226,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,9,0,0,10,5,0,0,234,204,0,87,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,
  192,0,16,227,23,0,0,26,44,112,133,226,1,0,20,227,11,0,0,26,58,18,216,229,16,0,17,227,5,0,0,10,
  204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,8,0,17,227,9,0,0,10,
  5,0,0,234,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,
  37,1,128,224,4,0,134,228,113,246,255,234,40,0,88,229,192,0,16,227,23,0,0,26,40,112,69,226,2,0,20,227,
  11,0,0,26,230,17,216,229,16,0,17,227,5,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,8,0,17,227,9,0,0,10,5,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,85,246,255,234,44,0,88,229,
  192,0,16,227,8,0,0,26,226,17,216,229,16,0,17,227,1,0,0,26,1,0,20,227,3,0,0,10,44,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,72,246,255,234,40,0,88,229,192,0,16,227,8,0,0,26,230,17,216,229,
  16,0,17,227,1,0,0,26,2,0,20,227,3,0,0,10,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  40,0,216,229,192,0,16,227,8,0,0,26,54,18,216,229,16,0,17,227,1,0,0,26,2,0,20,227,3,0,0,10,
  40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,47,246,255,234,36,0,88,229,192,0,16,227,8,0,0,26,
  234,17,216,229,16,0,17,227,1,0,0,26,4,0,20,227,3,0,0,10,36,112,69,226,7,3,160,225,37,1,128,224,
  4,0,134,228,34,246,255,234,44,112,69,226,9,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,44,112,71,226,7,0,220,231,0,0,80,227,
  242,255,255,10,32,0,16,227,8,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,204,0,85,227,20,0,0,42,44,112,133,226,6,0,0,234,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,128,0,64,226,4,0,134,228,44,112,135,226,7,0,220,231,
  0,0,80,227,245,255,255,10,32,0,16,227,20,0,0,10,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  128,0,64,226,4,0,134,228,13,0,0,234,44,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  44,112,135,226,7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,
  4,0,134,228,226,245,255,234,44,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,44,112,71,226,
  7,0,220,231,224,0,16,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  44,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,44,112,135,226,7,0,220,231,224,0,16,227,
  248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,197,245,255,234,40,0,88,229,
  192,0,16,227,8,0,0,26,230,17,216,229,48,0,17,227,1,0,0,26,2,0,20,227,3,0,0,10,40,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,40,0,216,229,192,0,16,227,8,0,0,26,54,18,216,229,48,0,17,227,
  1,0,0,26,2,0,20,227,3,0,0,10,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,172,245,255,234,
  4,0,88,229,192,0,16,227,8,0,0,26,10,18,216,229,48,0,17,227,1,0,0,26,8,0,20,227,3,0,0,10,
  4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,4,0,216,229,192,0,16,227,8,0,0,26,18,18,216,229,
  48,0,17,227,1,0,0,26,8,0,20,227,3,0,0,10,4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,
  147,245,255,234,40,112,69,226,9,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,40,112,71,226,7,0,220,231,0,0,80,227,242,255,255,10,
  32,0,16,227,8,0,0,10,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  7,3,160,225,37,1,128,224,4,0,134,228,204,0,85,227,20,0,0,42,40,112,133,226,6,0,0,234,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,128,0,64,226,4,0,134,228,40,112,135,226,7,0,220,231,0,0,80,227,
  245,255,255,10,32,0,16,227,20,0,0,10,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,128,0,64,226,
  4,0,134,228,13,0,0,234,40,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,135,226,
  7,0,220,231,0,0,80,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  83,245,255,234,44,0,88,229,192,0,16,227,8,0,0,26,226,17,216,229,72,0,17,227,1,0,0,26,1,0,20,227,
  3,0,0,10,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,44,0,216,229,192,0,16,227,8,0,0,26,
  58,18,216,229,72,0,17,227,1,0,0,26,1,0,20,227,3,0,0,10,44,112,133,226,7,3,160,225,37,1,128,224,
  4,0,134,228,58,245,255,234,40,112,69,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,71,226,
  7,0,220,231,224,0,16,227,248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,
  40,112,133,226,3,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,40,112,135,226,7,0,220,231,224,0,16,227,
  248,255,255,10,32,0,16,227,2,0,0,10,7,3,160,225,37,1,128,224,4,0,134,228,29,245,255,234,36,0,88,229,
  192,0,16,227,8,0,0,26,234,17,216,229,72,0,17,227,1,0,0,26,4,0,20,227,3,0,0,10,36,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,36,0,216,229,192,0,16,227,8,0,0,26,50,18,216,229,72,0,17,227,
  1,0,0,26,4,0,20,227,3,0,0,10,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,4,245,255,234,
  4,224,45,229,64,0,45,233,23,0,0,235,6,112,160,225,64,0,189,232,6,80,160,225,7,0,85,225,17,0,0,10,
  192,0,45,233,0,48,21,229,153,156,255,235,192,0,189,232,164,175,28,229,10,160,140,224,34,6,26,229,24,20,90,229,
  32,24,145,225,1,0,0,10,0,0,21,229,4,0,134,228,192,0,45,233,0,48,21,229,7,157,255,235,192,0,189,232,
  4,80,133,226,235,255,255,234,4,240,157,228,4,224,45,229,80,75,28,229,1,0,116,227,3,0,0,10,76,11,28,229,
  0,0,80,227,2,0,0,26,6,0,0,235,27,0,0,235,4,240,157,228,3,0,0,235,24,0,0,235,168,0,0,235,
  137,0,0,235,4,240,157,228,152,95,28,229,84,0,85,227,17,0,0,58,5,128,140,224,13,2,216,229,0,0,80,227,
  10,0,0,26,5,0,220,231,30,0,0,226,128,0,143,224,76,255,144,229,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,152,95,24,229,84,0,85,227,237,255,255,42,14,240,160,225,
  168,95,28,229,5,128,140,224,22,4,88,229,128,0,16,227,10,0,0,26,44,0,88,229,192,0,16,227,7,0,0,26,
  80,6,24,229,66,20,88,229,32,8,145,225,3,0,0,26,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  22,4,88,229,64,0,16,227,10,0,0,26,40,0,88,229,192,0,16,227,7,0,0,26,76,6,24,229,62,20,88,229,
  32,8,145,225,3,0,0,26,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,22,4,88,229,32,0,16,227,
  10,0,0,26,36,0,88,229,192,0,16,227,7,0,0,26,72,6,24,229,58,20,88,229,32,8,145,225,3,0,0,26,
  36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,22,4,88,229,16,0,16,227,10,0,0,26,4,0,88,229,
  192,0,16,227,7,0,0,26,40,6,24,229,26,20,88,229,32,8,145,225,3,0,0,26,4,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,22,4,88,229,8,0,16,227,10,0,0,26,4,0,216,229,192,0,16,227,7,0,0,26,
  32,6,24,229,18,20,88,229,32,8,145,225,3,0,0,26,4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,
  22,4,88,229,4,0,16,227,10,0,0,26,36,0,216,229,192,0,16,227,7,0,0,26,0,6,24,229,242,19,88,229,
  32,8,145,225,3,0,0,26,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,22,4,88,229,2,0,16,227,
  10,0,0,26,40,0,216,229,192,0,16,227,7,0,0,26,252,5,24,229,238,19,88,229,32,8,145,225,3,0,0,26,
  40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,22,4,88,229,1,0,16,227,10,0,0,26,44,0,216,229,
  192,0,16,227,7,0,0,26,248,5,24,229,234,19,88,229,32,8,145,225,3,0,0,26,44,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,14,240,160,225,196,93,159,229,131,144,160,227,0,0,160,227,4,0,133,228,1,144,89,226,
  252,255,255,26,76,59,28,229,168,95,28,229,5,80,140,224,3,80,69,224,1,16,160,227,12,18,5,229,3,0,117,231,
  0,0,80,227,251,255,255,10,152,95,28,229,84,0,85,227,10,0,0,58,5,128,140,224,13,2,216,229,0,0,80,227,
  3,0,0,26,5,0,220,231,30,0,0,226,128,0,143,224,40,253,144,229,152,95,24,229,84,0,85,227,244,255,255,42,
  14,240,160,225,76,59,28,229,168,95,28,229,51,0,0,234,124,0,85,227,25,0,0,58,5,0,139,224,36,11,16,229,
  0,0,140,224,128,11,80,229,0,0,80,227,5,0,0,26,196,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,
  0,0,128,227,4,0,134,228,195,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,1,0,128,227,4,0,134,228,
  164,0,85,227,5,0,0,58,194,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,2,0,128,227,4,0,134,228,
  193,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,3,0,128,227,4,0,134,228,192,15,92,229,0,0,80,227,
  2,0,0,10,5,3,160,225,4,0,128,227,4,0,134,228,191,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,
  5,0,128,227,4,0,134,228,190,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,6,0,128,227,4,0,134,228,
  3,80,69,224,5,0,220,231,0,0,80,227,199,255,255,10,14,240,160,225,40,112,69,226,4,0,87,225,8,0,0,26,
  204,0,87,227,38,255,255,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,124,0,87,227,35,255,255,58,
  31,255,255,234,33,255,255,234,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,
  8,0,0,26,204,0,87,227,21,255,255,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,124,0,87,227,
  18,255,255,58,14,255,255,234,16,255,255,234,84,112,69,226,4,0,87,225,8,0,0,26,204,0,87,227,8,255,255,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,164,0,87,227,5,255,255,58,1,255,255,234,76,112,69,226,
  4,0,87,225,8,0,0,26,204,0,87,227,252,254,255,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  164,0,87,227,249,254,255,58,245,254,255,234,247,254,255,234,44,112,69,226,4,0,87,225,2,0,0,26,204,0,87,227,
  235,254,255,58,238,254,255,234,40,112,69,226,4,0,87,225,2,0,0,26,204,0,87,227,229,254,255,58,232,254,255,234,
  36,112,69,226,4,0,87,225,2,0,0,26,204,0,87,227,223,254,255,58,226,254,255,234,36,112,133,226,4,0,87,225,
  2,0,0,26,204,0,85,227,217,254,255,58,220,254,255,234,44,112,133,226,4,0,87,225,2,0,0,26,204,0,85,227,
  211,254,255,58,214,254,255,234,216,254,255,234,44,112,69,226,4,0,87,225,210,254,255,10,40,112,69,226,4,0,87,225,
  207,254,255,10,36,112,69,226,4,0,87,225,204,254,255,10,4,112,69,226,4,0,87,225,201,254,255,10,4,112,133,226,
  4,0,87,225,198,254,255,10,40,112,133,226,4,0,87,225,195,254,255,10,197,254,255,234,5,112,160,225,44,112,71,226,
  7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,2,0,0,26,204,0,87,227,181,254,255,58,184,254,255,234,
  5,112,160,225,36,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,2,0,0,26,204,0,87,227,
  171,254,255,58,174,254,255,234,5,112,160,225,36,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,
  2,0,0,26,204,0,85,227,161,254,255,58,164,254,255,234,5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,
  251,255,255,10,4,0,87,225,2,0,0,26,204,0,85,227,151,254,255,58,154,254,255,234,156,254,255,234,5,112,160,225,
  44,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,146,254,255,10,5,112,160,225,36,112,71,226,
  7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,139,254,255,10,5,112,160,225,36,112,135,226,7,0,220,231,
  0,0,80,227,251,255,255,10,4,0,87,225,132,254,255,10,5,112,160,225,44,112,135,226,7,0,220,231,0,0,80,227,
  251,255,255,10,4,0,87,225,125,254,255,10,40,112,69,226,4,0,87,225,122,254,255,10,4,112,69,226,4,0,87,225,
  119,254,255,10,4,112,133,226,4,0,87,225,116,254,255,10,40,112,133,226,4,0,87,225,113,254,255,10,115,254,255,234,
  5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,2,0,0,26,204,0,87,227,
  99,254,255,58,102,254,255,234,5,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,
  2,0,0,26,204,0,87,227,89,254,255,58,92,254,255,234,5,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,
  251,255,255,10,4,0,87,225,2,0,0,26,204,0,85,227,79,254,255,58,82,254,255,234,5,112,160,225,40,112,135,226,
  7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,2,0,0,26,204,0,85,227,69,254,255,58,72,254,255,234,
  74,254,255,234,5,112,160,225,40,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,64,254,255,10,
  5,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,57,254,255,10,5,112,160,225,
  4,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,50,254,255,10,5,112,160,225,40,112,135,226,
  7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,43,254,255,10,44,112,69,226,4,0,87,225,40,254,255,10,
  36,112,69,226,4,0,87,225,37,254,255,10,36,112,133,226,4,0,87,225,34,254,255,10,44,112,133,226,4,0,87,225,
  31,254,255,10,33,254,255,234,52,2,24,229,0,0,80,227,11,0,0,10,40,112,69,226,204,0,87,227,5,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,124,0,87,227,2,0,0,58,7,3,160,225,37,1,128,224,
  4,0,134,228,162,254,255,234,5,112,160,225,40,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,
  7,0,220,231,0,0,80,227,247,255,255,10,10,0,0,234,204,0,87,227,5,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,124,0,87,227,2,0,0,58,7,3,160,225,37,1,128,224,4,0,134,228,140,254,255,234,
  96,2,24,229,0,0,80,227,11,0,0,10,84,112,69,226,204,0,87,227,5,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,164,0,87,227,2,0,0,58,7,3,160,225,37,1,128,224,4,0,134,228,88,2,24,229,
  0,0,80,227,11,0,0,10,76,112,69,226,204,0,87,227,5,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,164,0,87,227,2,0,0,58,7,3,160,225,37,1,128,224,4,0,134,228,109,254,255,234,56,2,24,229,
  0,0,80,227,9,0,0,10,44,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,52,2,24,229,0,0,80,227,9,0,0,10,40,112,69,226,
  204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,
  4,0,134,228,48,2,24,229,0,0,80,227,9,0,0,10,36,112,69,226,204,0,87,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,232,1,24,229,0,0,80,227,
  9,0,0,10,36,112,133,226,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  7,3,160,225,37,1,128,224,4,0,134,228,224,1,24,229,0,0,80,227,9,0,0,10,44,112,133,226,204,0,85,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  43,254,255,234,56,2,24,229,0,0,80,227,3,0,0,10,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  52,2,24,229,0,0,80,227,3,0,0,10,40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,48,2,24,229,
  0,0,80,227,3,0,0,10,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,16,2,24,229,0,0,80,227,
  3,0,0,10,4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,8,2,24,229,0,0,80,227,3,0,0,10,
  4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,228,1,24,229,0,0,80,227,3,0,0,10,40,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,0,254,255,234,5,112,160,225,44,112,71,226,7,0,140,224,12,2,16,229,
  0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,204,0,87,227,3,0,0,42,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,
  36,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,
  8,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,
  37,1,128,224,4,0,134,228,5,112,160,225,36,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,
  7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,44,112,135,226,7,0,140,224,
  12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,204,0,85,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  179,253,255,234,5,112,160,225,44,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,
  0,0,80,227,247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,36,112,71,226,
  7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,2,0,0,234,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,36,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,
  3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  5,112,160,225,44,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,
  247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,52,2,24,229,0,0,80,227,3,0,0,10,
  40,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,16,2,24,229,0,0,80,227,3,0,0,10,4,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,8,2,24,229,0,0,80,227,3,0,0,10,4,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,228,1,24,229,0,0,80,227,3,0,0,10,40,112,133,226,7,3,160,225,37,1,128,224,
  4,0,134,228,98,253,255,234,5,112,160,225,40,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,
  7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,204,0,87,227,3,0,0,42,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,4,112,71,226,7,0,140,224,
  12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,204,0,87,227,
  3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  5,112,160,225,4,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,
  247,255,255,10,8,0,0,234,204,0,85,227,3,0,0,42,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,40,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,
  3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,204,0,85,227,3,0,0,42,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,21,253,255,234,5,112,160,225,
  40,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,
  2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,4,112,71,226,7,0,140,224,12,2,16,229,
  0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,
  4,0,134,228,5,112,160,225,4,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,
  0,0,80,227,247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,40,112,135,226,
  7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,2,0,0,234,
  7,3,160,225,37,1,128,224,4,0,134,228,56,2,24,229,0,0,80,227,3,0,0,10,44,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,48,2,24,229,0,0,80,227,3,0,0,10,36,112,69,226,7,3,160,225,37,1,128,224,
  4,0,134,228,232,1,24,229,0,0,80,227,3,0,0,10,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,
  224,1,24,229,0,0,80,227,3,0,0,10,44,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,196,252,255,234,
  52,169,1,0,140,170,1,0,104,169,1,0,140,170,1,0,172,169,1,0,140,170,1,0,16,170,1,0,140,170,1,0,
  140,170,1,0,240,165,1,0,216,170,1,0,124,171,1,0,32,172,1,0,196,172,1,0,240,165,1,0,104,173,1,0,
  132,175,1,0,168,173,1,0,132,175,1,0,0,174,1,0,132,175,1,0,124,174,1,0,132,175,1,0,132,175,1,0,
  52,168,1,0,48,176,1,0,100,177,1,0,168,178,1,0,220,179,1,0,52,168,1,0,220,18,0,224,4,224,45,229,
  64,0,45,233,191,150,255,235,125,157,255,235,212,155,255,235,64,0,189,232,80,75,28,229,1,0,116,227,3,0,0,10,
  76,11,28,229,0,0,80,227,2,0,0,26,12,0,0,235,59,0,0,235,4,240,157,228,9,0,0,235,80,1,0,235,
  55,0,0,235,148,1,0,235,32,1,0,235,4,240,157,228,4,224,45,229,74,1,0,235,143,1,0,235,27,1,0,235,
  4,240,157,228,4,160,140,224,36,6,26,229,22,20,90,229,32,8,129,225,164,95,28,229,5,160,140,224,34,22,26,229,
  24,36,90,229,33,24,130,225,1,0,208,225,20,0,0,10,148,95,28,229,84,0,85,227,17,0,0,58,5,128,140,224,
  15,2,216,229,0,0,80,227,10,0,0,26,5,0,220,231,30,0,0,226,128,0,143,224,44,240,144,229,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,152,95,24,229,84,0,85,227,
  237,255,255,42,14,240,160,225,84,189,1,0,172,190,1,0,136,189,1,0,172,190,1,0,204,189,1,0,172,190,1,0,
  48,190,1,0,172,190,1,0,172,190,1,0,120,182,1,0,248,190,1,0,156,191,1,0,64,192,1,0,228,192,1,0,
  120,182,1,0,164,95,28,229,5,128,140,224,44,112,133,226,4,0,87,225,9,0,0,26,24,4,88,229,128,0,16,227,
  6,0,0,26,246,5,24,229,236,19,88,229,32,8,145,225,2,0,0,26,7,3,160,225,37,1,128,224,4,0,134,228,
  36,112,133,226,4,0,87,225,9,0,0,26,24,4,88,229,32,0,16,227,6,0,0,26,254,5,24,229,244,19,88,229,
  32,8,145,225,2,0,0,26,7,3,160,225,37,1,128,224,4,0,134,228,40,112,133,226,4,0,87,225,9,0,0,26,
  24,4,88,229,64,0,16,227,6,0,0,26,250,5,24,229,240,19,88,229,32,8,145,225,2,0,0,26,7,3,160,225,
  37,1,128,224,4,0,134,228,4,112,133,226,4,0,87,225,9,0,0,26,24,4,88,229,16,0,16,227,6,0,0,26,
  30,6,24,229,20,20,88,229,32,8,145,225,2,0,0,26,7,3,160,225,37,1,128,224,4,0,134,228,4,112,69,226,
  4,0,87,225,9,0,0,26,24,4,88,229,8,0,16,227,6,0,0,26,38,6,24,229,28,20,88,229,32,8,145,225,
  2,0,0,26,7,3,160,225,37,1,128,224,4,0,134,228,36,112,69,226,4,0,87,225,9,0,0,26,24,4,88,229,
  4,0,16,227,6,0,0,26,70,6,24,229,60,20,88,229,32,8,145,225,2,0,0,26,7,3,160,225,37,1,128,224,
  4,0,134,228,44,112,69,226,4,0,87,225,9,0,0,26,24,4,88,229,1,0,16,227,6,0,0,26,78,6,24,229,
  68,20,88,229,32,8,145,225,2,0,0,26,7,3,160,225,37,1,128,224,4,0,134,228,40,112,69,226,4,0,87,225,
  9,0,0,26,24,4,88,229,2,0,16,227,6,0,0,26,74,6,24,229,64,20,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,44,112,133,226,4,0,87,225,12,0,0,10,7,0,220,231,160,0,16,227,
  9,0,0,26,24,4,88,229,128,0,16,227,6,0,0,26,246,5,24,229,236,19,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,36,112,133,226,4,0,87,225,12,0,0,10,7,0,220,231,160,0,16,227,
  9,0,0,26,24,4,88,229,32,0,16,227,6,0,0,26,254,5,24,229,244,19,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,40,112,133,226,4,0,87,225,12,0,0,10,7,0,220,231,160,0,16,227,
  9,0,0,26,24,4,88,229,64,0,16,227,6,0,0,26,250,5,24,229,240,19,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,4,112,133,226,4,0,87,225,12,0,0,10,7,0,220,231,160,0,16,227,
  9,0,0,26,24,4,88,229,16,0,16,227,6,0,0,26,30,6,24,229,20,20,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,4,112,69,226,4,0,87,225,12,0,0,10,7,0,220,231,160,0,16,227,
  9,0,0,26,24,4,88,229,8,0,16,227,6,0,0,26,38,6,24,229,28,20,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,36,112,69,226,4,0,87,225,12,0,0,10,7,0,220,231,160,0,16,227,
  9,0,0,26,24,4,88,229,4,0,16,227,6,0,0,26,70,6,24,229,60,20,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,44,112,69,226,4,0,87,225,12,0,0,10,7,0,220,231,160,0,16,227,
  9,0,0,26,24,4,88,229,1,0,16,227,6,0,0,26,78,6,24,229,68,20,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,40,112,69,226,4,0,87,225,12,0,0,10,7,0,220,231,160,0,16,227,
  9,0,0,26,24,4,88,229,2,0,16,227,6,0,0,26,74,6,24,229,64,20,88,229,32,8,145,225,2,0,0,26,
  7,3,160,225,37,1,128,224,4,0,134,228,14,240,160,225,200,94,159,229,131,144,160,227,0,0,160,227,4,0,133,228,
  1,144,89,226,252,255,255,26,76,59,28,229,164,95,28,229,5,80,140,224,3,80,69,224,1,16,160,227,12,18,5,229,
  3,0,117,231,0,0,80,227,251,255,255,10,148,95,28,229,84,0,85,227,10,0,0,58,5,128,140,224,15,2,216,229,
  0,0,80,227,3,0,0,26,5,0,220,231,30,0,0,226,128,0,143,224,16,240,144,229,152,95,24,229,84,0,85,227,
  244,255,255,42,14,240,160,225,136,193,1,0,164,195,1,0,200,193,1,0,164,195,1,0,32,194,1,0,164,195,1,0,
  156,194,1,0,164,195,1,0,164,195,1,0,216,186,1,0,80,196,1,0,132,197,1,0,200,198,1,0,252,199,1,0,
  216,186,1,0,76,59,28,229,164,95,28,229,5,160,140,224,34,6,26,229,24,20,90,229,32,40,145,225,57,0,0,234,
  5,160,140,224,36,6,26,229,22,20,90,229,32,8,145,225,2,0,208,225,51,0,0,10,101,15,85,227,25,0,0,42,
  5,0,139,224,36,11,16,229,0,0,140,224,116,11,80,229,0,0,80,227,5,0,0,26,188,15,92,229,0,0,80,227,
  2,0,0,10,5,3,160,225,0,0,128,227,4,0,134,228,187,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,
  1,0,128,227,4,0,134,228,91,15,85,227,5,0,0,42,186,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,
  2,0,128,227,4,0,134,228,185,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,3,0,128,227,4,0,134,228,
  184,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,4,0,128,227,4,0,134,228,183,15,92,229,0,0,80,227,
  2,0,0,10,5,3,160,225,5,0,128,227,4,0,134,228,182,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,
  6,0,128,227,4,0,134,228,3,80,69,224,5,0,220,231,0,0,80,227,193,255,255,10,14,240,160,225,76,59,28,229,
  164,95,28,229,5,160,140,224,34,6,26,229,24,20,90,229,32,40,145,225,57,0,0,234,5,160,140,224,36,6,26,229,
  22,20,90,229,32,8,145,225,2,0,208,225,51,0,0,26,101,15,85,227,25,0,0,42,5,0,139,224,36,11,16,229,
  0,0,140,224,116,11,80,229,0,0,80,227,5,0,0,26,188,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,
  0,0,128,227,4,0,134,228,187,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,1,0,128,227,4,0,134,228,
  91,15,85,227,5,0,0,42,186,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,2,0,128,227,4,0,134,228,
  185,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,3,0,128,227,4,0,134,228,184,15,92,229,0,0,80,227,
  2,0,0,10,5,3,160,225,4,0,128,227,4,0,134,228,183,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,
  5,0,128,227,4,0,134,228,182,15,92,229,0,0,80,227,2,0,0,10,5,3,160,225,6,0,128,227,4,0,134,228,
  3,80,69,224,5,0,220,231,0,0,80,227,193,255,255,10,14,240,160,225,40,112,133,226,4,0,87,225,8,0,0,26,
  81,15,87,227,64,254,255,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,101,15,87,227,61,254,255,42,
  57,254,255,234,59,254,255,234,5,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,
  8,0,0,26,81,15,87,227,47,254,255,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,101,15,87,227,
  44,254,255,42,40,254,255,234,42,254,255,234,84,112,133,226,4,0,87,225,8,0,0,26,81,15,87,227,34,254,255,58,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,91,15,87,227,31,254,255,42,27,254,255,234,76,112,133,226,
  4,0,87,225,8,0,0,26,81,15,87,227,22,254,255,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  91,15,87,227,19,254,255,42,15,254,255,234,17,254,255,234,44,112,133,226,4,0,87,225,2,0,0,26,81,15,87,227,
  5,254,255,42,8,254,255,234,40,112,133,226,4,0,87,225,2,0,0,26,81,15,87,227,255,253,255,42,2,254,255,234,
  36,112,133,226,4,0,87,225,2,0,0,26,81,15,87,227,249,253,255,42,252,253,255,234,36,112,69,226,4,0,87,225,
  2,0,0,26,81,15,85,227,243,253,255,42,246,253,255,234,44,112,69,226,4,0,87,225,2,0,0,26,81,15,85,227,
  237,253,255,42,240,253,255,234,242,253,255,234,44,112,133,226,4,0,87,225,236,253,255,10,40,112,133,226,4,0,87,225,
  233,253,255,10,36,112,133,226,4,0,87,225,230,253,255,10,4,112,133,226,4,0,87,225,227,253,255,10,4,112,69,226,
  4,0,87,225,224,253,255,10,40,112,69,226,4,0,87,225,221,253,255,10,223,253,255,234,5,112,160,225,44,112,135,226,
  7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,2,0,0,26,81,15,87,227,207,253,255,42,210,253,255,234,
  5,112,160,225,36,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,2,0,0,26,81,15,87,227,
  197,253,255,42,200,253,255,234,5,112,160,225,36,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,
  2,0,0,26,81,15,85,227,187,253,255,42,190,253,255,234,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,
  251,255,255,10,4,0,87,225,2,0,0,26,81,15,85,227,177,253,255,42,180,253,255,234,182,253,255,234,5,112,160,225,
  44,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,172,253,255,10,5,112,160,225,36,112,135,226,
  7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,165,253,255,10,5,112,160,225,36,112,71,226,7,0,220,231,
  0,0,80,227,251,255,255,10,4,0,87,225,158,253,255,10,5,112,160,225,44,112,71,226,7,0,220,231,0,0,80,227,
  251,255,255,10,4,0,87,225,151,253,255,10,40,112,133,226,4,0,87,225,148,253,255,10,4,112,133,226,4,0,87,225,
  145,253,255,10,4,112,69,226,4,0,87,225,142,253,255,10,40,112,69,226,4,0,87,225,139,253,255,10,141,253,255,234,
  5,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,2,0,0,26,81,15,87,227,
  125,253,255,42,128,253,255,234,5,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,
  2,0,0,26,81,15,87,227,115,253,255,42,118,253,255,234,5,112,160,225,4,112,71,226,7,0,220,231,0,0,80,227,
  251,255,255,10,4,0,87,225,2,0,0,26,81,15,85,227,105,253,255,42,108,253,255,234,5,112,160,225,40,112,71,226,
  7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,2,0,0,26,81,15,85,227,95,253,255,42,98,253,255,234,
  100,253,255,234,5,112,160,225,40,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,90,253,255,10,
  5,112,160,225,4,112,135,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,83,253,255,10,5,112,160,225,
  4,112,71,226,7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,76,253,255,10,5,112,160,225,40,112,71,226,
  7,0,220,231,0,0,80,227,251,255,255,10,4,0,87,225,69,253,255,10,44,112,133,226,4,0,87,225,66,253,255,10,
  36,112,133,226,4,0,87,225,63,253,255,10,36,112,69,226,4,0,87,225,60,253,255,10,44,112,69,226,4,0,87,225,
  57,253,255,10,59,253,255,234,228,1,24,229,0,0,80,227,11,0,0,10,40,112,133,226,81,15,87,227,5,0,0,58,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,101,15,87,227,2,0,0,42,7,3,160,225,37,1,128,224,
  4,0,134,228,67,254,255,234,5,112,160,225,40,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,
  7,0,220,231,0,0,80,227,247,255,255,10,10,0,0,234,81,15,87,227,5,0,0,58,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,101,15,87,227,2,0,0,42,7,3,160,225,37,1,128,224,4,0,134,228,45,254,255,234,
  184,1,24,229,0,0,80,227,11,0,0,10,84,112,133,226,81,15,87,227,5,0,0,58,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,91,15,87,227,2,0,0,42,7,3,160,225,37,1,128,224,4,0,134,228,192,1,24,229,
  0,0,80,227,11,0,0,10,76,112,133,226,81,15,87,227,5,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,91,15,87,227,2,0,0,42,7,3,160,225,37,1,128,224,4,0,134,228,14,254,255,234,224,1,24,229,
  0,0,80,227,9,0,0,10,44,112,133,226,81,15,87,227,3,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,
  4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,228,1,24,229,0,0,80,227,9,0,0,10,40,112,133,226,
  81,15,87,227,3,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,
  4,0,134,228,232,1,24,229,0,0,80,227,9,0,0,10,36,112,133,226,81,15,87,227,3,0,0,58,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,48,2,24,229,0,0,80,227,
  9,0,0,10,36,112,69,226,81,15,85,227,3,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  7,3,160,225,37,1,128,224,4,0,134,228,56,2,24,229,0,0,80,227,9,0,0,10,44,112,69,226,81,15,85,227,
  3,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  204,253,255,234,224,1,24,229,0,0,80,227,3,0,0,10,44,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,
  228,1,24,229,0,0,80,227,3,0,0,10,40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,232,1,24,229,
  0,0,80,227,3,0,0,10,36,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,8,2,24,229,0,0,80,227,
  3,0,0,10,4,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,16,2,24,229,0,0,80,227,3,0,0,10,
  4,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,52,2,24,229,0,0,80,227,3,0,0,10,40,112,69,226,
  7,3,160,225,37,1,128,224,4,0,134,228,161,253,255,234,5,112,160,225,44,112,135,226,7,0,140,224,12,2,16,229,
  0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,81,15,87,227,3,0,0,58,
  7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,
  36,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,
  8,0,0,234,81,15,87,227,3,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,
  37,1,128,224,4,0,134,228,5,112,160,225,36,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,
  7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,81,15,85,227,3,0,0,58,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,44,112,71,226,7,0,140,224,
  12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,81,15,85,227,
  3,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  84,253,255,234,5,112,160,225,44,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,
  0,0,80,227,247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,36,112,135,226,
  7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,2,0,0,234,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,36,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,
  3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,
  5,112,160,225,44,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,
  247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,228,1,24,229,0,0,80,227,3,0,0,10,
  40,112,133,226,7,3,160,225,37,1,128,224,4,0,134,228,8,2,24,229,0,0,80,227,3,0,0,10,4,112,133,226,
  7,3,160,225,37,1,128,224,4,0,134,228,16,2,24,229,0,0,80,227,3,0,0,10,4,112,69,226,7,3,160,225,
  37,1,128,224,4,0,134,228,52,2,24,229,0,0,80,227,3,0,0,10,40,112,69,226,7,3,160,225,37,1,128,224,
  4,0,134,228,3,253,255,234,5,112,160,225,40,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,
  7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,81,15,87,227,3,0,0,58,7,3,160,225,37,1,128,224,
  128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,4,112,135,226,7,0,140,224,
  12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,81,15,87,227,
  3,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,
  5,112,160,225,4,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,
  247,255,255,10,8,0,0,234,81,15,85,227,3,0,0,58,7,3,160,225,37,1,128,224,128,0,128,226,4,0,134,228,
  7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,40,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,
  3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,8,0,0,234,81,15,85,227,3,0,0,58,7,3,160,225,
  37,1,128,224,128,0,128,226,4,0,134,228,7,3,160,225,37,1,128,224,4,0,134,228,182,252,255,234,5,112,160,225,
  40,112,135,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,
  2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,4,112,135,226,7,0,140,224,12,2,16,229,
  0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,
  4,0,134,228,5,112,160,225,4,112,71,226,7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,
  0,0,80,227,247,255,255,10,2,0,0,234,7,3,160,225,37,1,128,224,4,0,134,228,5,112,160,225,40,112,71,226,
  7,0,140,224,12,2,16,229,0,0,80,227,3,0,0,26,7,0,220,231,0,0,80,227,247,255,255,10,2,0,0,234,
  7,3,160,225,37,1,128,224,4,0,134,228,224,1,24,229,0,0,80,227,3,0,0,10,44,112,133,226,7,3,160,225,
  37,1,128,224,4,0,134,228,232,1,24,229,0,0,80,227,3,0,0,10,36,112,133,226,7,3,160,225,37,1,128,224,
  4,0,134,228,48,2,24,229,0,0,80,227,3,0,0,10,36,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,
  56,2,24,229,0,0,80,227,3,0,0,10,44,112,69,226,7,3,160,225,37,1,128,224,4,0,134,228,101,252,255,234,
  220,18,0,224,196,15,92,229,0,0,80,227,19,0,0,10,124,80,160,227,248,65,159,229,8,144,160,227,9,128,160,227,
  1,0,212,228,0,0,80,227,5,0,0,26,5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,0,0,128,226,
  4,0,134,228,4,80,133,226,1,128,88,226,243,255,255,26,4,80,133,226,9,64,68,226,1,144,89,226,238,255,255,26,
  195,15,92,229,0,0,80,227,14,0,0,10,124,80,160,227,8,144,160,227,9,128,160,227,5,0,220,231,0,0,80,227,
  2,0,0,26,5,3,160,225,1,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,246,255,255,26,4,80,133,226,
  1,144,89,226,242,255,255,26,194,15,92,229,0,0,80,227,14,0,0,10,164,80,160,227,7,144,160,227,9,128,160,227,
  5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,2,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,
  246,255,255,26,4,80,133,226,1,144,89,226,242,255,255,26,193,15,92,229,0,0,80,227,14,0,0,10,84,80,160,227,
  9,144,160,227,9,128,160,227,5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,3,0,128,226,4,0,134,228,
  4,80,133,226,1,128,88,226,246,255,255,26,4,80,133,226,1,144,89,226,242,255,255,26,192,15,92,229,0,0,80,227,
  14,0,0,10,84,80,160,227,9,144,160,227,9,128,160,227,5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,
  4,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,246,255,255,26,4,80,133,226,1,144,89,226,242,255,255,26,
  191,15,92,229,0,0,80,227,14,0,0,10,84,80,160,227,9,144,160,227,9,128,160,227,5,0,220,231,0,0,80,227,
  2,0,0,26,5,3,160,225,5,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,246,255,255,26,4,80,133,226,
  1,144,89,226,242,255,255,26,190,15,92,229,0,0,80,227,14,0,0,10,84,80,160,227,9,144,160,227,9,128,160,227,
  5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,6,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,
  246,255,255,26,4,80,133,226,1,144,89,226,242,255,255,26,14,240,160,225,105,9,0,224,188,15,92,229,0,0,80,227,
  19,0,0,10,84,80,160,227,248,65,159,229,8,144,160,227,9,128,160,227,1,0,212,228,0,0,80,227,5,0,0,26,
  5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,0,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,
  243,255,255,26,4,80,133,226,9,64,68,226,1,144,89,226,238,255,255,26,187,15,92,229,0,0,80,227,14,0,0,10,
  8,144,160,227,84,80,160,227,9,128,160,227,5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,1,0,128,226,
  4,0,134,228,4,80,133,226,1,128,88,226,246,255,255,26,4,80,133,226,1,144,89,226,242,255,255,26,186,15,92,229,
  0,0,80,227,14,0,0,10,7,144,160,227,84,80,160,227,9,128,160,227,5,0,220,231,0,0,80,227,2,0,0,26,
  5,3,160,225,2,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,246,255,255,26,4,80,133,226,1,144,89,226,
  242,255,255,26,185,15,92,229,0,0,80,227,14,0,0,10,9,144,160,227,84,80,160,227,9,128,160,227,5,0,220,231,
  0,0,80,227,2,0,0,26,5,3,160,225,3,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,246,255,255,26,
  4,80,133,226,1,144,89,226,242,255,255,26,184,15,92,229,0,0,80,227,14,0,0,10,9,144,160,227,84,80,160,227,
  9,128,160,227,5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,4,0,128,226,4,0,134,228,4,80,133,226,
  1,128,88,226,246,255,255,26,4,80,133,226,1,144,89,226,242,255,255,26,183,15,92,229,0,0,80,227,14,0,0,10,
  9,144,160,227,84,80,160,227,9,128,160,227,5,0,220,231,0,0,80,227,2,0,0,26,5,3,160,225,5,0,128,226,
  4,0,134,228,4,80,133,226,1,128,88,226,246,255,255,26,4,80,133,226,1,144,89,226,242,255,255,26,182,15,92,229,
  0,0,80,227,14,0,0,10,9,144,160,227,84,80,160,227,9,128,160,227,5,0,220,231,0,0,80,227,2,0,0,26,
  5,3,160,225,6,0,128,226,4,0,134,228,4,80,133,226,1,128,88,226,246,255,255,26,4,80,133,226,1,144,89,226,
  242,255,255,26,14,240,160,225,117,9,0,224,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,
  5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,
  3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,
  1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,
  9,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,
  7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,
  5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,
  3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,
  1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,
  9,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,
  7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,
  5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,
  3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,
  1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,
  9,0,0,0,32,78,0,0,224,177,255,255,8,30,32,50,52,70,80,0,0,254,255,0,1,2,2,3,3,3,2,0,
  6,6,6,6,6,8,6,8,8,6,0,3,3,3,3,3,4,3,4,6,3,0,2,2,2,2,2,3,2,3,4,2,
  3,5,7,9,11,13,15,17,19,0,0,0,8,0,0,0,8,0,0,0,6,0,0,0,0,0,0,0,6,0,0,0,
  0,1,0,0,0,255,255,255,0,1,0,0,0,255,255,255,0,0,0,0,240,255,255,255,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,11,0,0,0,13,0,0,0,15,0,0,0,15,0,0,0,
  15,0,0,0,13,0,0,0,11,0,0,0,7,0,0,0,0,0,0,0,8,0,0,0,14,0,0,0,17,0,0,0,
  19,0,0,0,19,0,0,0,19,0,0,0,17,0,0,0,14,0,0,0,8,0,0,0,0,0,0,0,8,0,0,0,
  14,0,0,0,17,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,17,0,0,0,14,0,0,0,8,0,0,0,
  0,0,0,0,8,0,0,0,14,0,0,0,18,0,0,0,20,0,0,0,20,0,0,0,20,0,0,0,18,0,0,0,
  14,0,0,0,8,0,0,0,0,0,0,0,8,0,0,0,14,0,0,0,18,0,0,0,20,0,0,0,20,0,0,0,
  20,0,0,0,18,0,0,0,14,0,0,0,8,0,0,0,0,0,0,0,8,0,0,0,14,0,0,0,18,0,0,0,
  20,0,0,0,20,0,0,0,20,0,0,0,18,0,0,0,14,0,0,0,8,0,0,0,0,0,0,0,8,0,0,0,
  14,0,0,0,17,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,17,0,0,0,14,0,0,0,8,0,0,0,
  0,0,0,0,8,0,0,0,14,0,0,0,17,0,0,0,19,0,0,0,19,0,0,0,19,0,0,0,17,0,0,0,
  14,0,0,0,8,0,0,0,0,0,0,0,7,0,0,0,11,0,0,0,13,0,0,0,15,0,0,0,15,0,0,0,
  15,0,0,0,13,0,0,0,11,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,0,0,0,132,0,0,0,
  132,0,0,0,136,0,0,0,140,0,0,0,144,0,0,0,148,0,0,0,148,0,0,0,148,0,0,0,0,0,0,0,
  132,0,0,0,132,0,0,0,132,0,0,0,136,0,0,0,140,0,0,0,144,0,0,0,148,0,0,0,148,0,0,0,
  148,0,0,0,0,0,0,0,172,0,0,0,172,0,0,0,172,0,0,0,176,0,0,0,180,0,0,0,184,0,0,0,
  188,0,0,0,188,0,0,0,188,0,0,0,0,0,0,0,212,0,0,0,212,0,0,0,212,0,0,0,216,0,0,0,
  220,0,0,0,224,0,0,0,228,0,0,0,228,0,0,0,228,0,0,0,0,0,0,0,252,0,0,0,252,0,0,0,
  252,0,0,0,0,1,0,0,4,1,0,0,8,1,0,0,12,1,0,0,12,1,0,0,12,1,0,0,0,0,0,0,
  36,1,0,0,36,1,0,0,36,1,0,0,40,1,0,0,44,1,0,0,48,1,0,0,52,1,0,0,52,1,0,0,
  52,1,0,0,0,0,0,0,76,1,0,0,76,1,0,0,76,1,0,0,80,1,0,0,84,1,0,0,88,1,0,0,
  92,1,0,0,92,1,0,0,92,1,0,0,0,0,0,0,116,1,0,0,116,1,0,0,116,1,0,0,120,1,0,0,
  124,1,0,0,128,1,0,0,132,1,0,0,132,1,0,0,132,1,0,0,0,0,0,0,116,1,0,0,116,1,0,0,
  116,1,0,0,120,1,0,0,124,1,0,0,128,1,0,0,132,1,0,0,132,1,0,0,132,1,0,0,1,0,0,0,
  1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,
  0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,
  0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
  1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,
  0,0,0,0,13,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,20,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,
  4,0,0,0,15,0,0,0,15,0,0,0,16,0,0,0,16,0,0,0,25,0,0,0,25,0,0,0,26,0,0,0,
  0,0,0,0,35,0,0,0,35,0,0,0,40,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,
  22,0,0,0,8,0,0,0,20,0,0,0,12,0,0,0,20,0,0,0,16,0,0,0,16,0,0,0,16,0,0,0,
  0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,64,1,0,0,
  192,4,0,0,32,2,0,0,64,4,0,0,64,2,0,0,32,4,0,0,64,3,0,0,128,3,0,0,96,3,0,0,
  0,0,0,0,160,4,0,0,0,6,0,0,64,5,0,0,224,6,0,0,0,15,0,0,0,0,0,0,144,224,1,0,
  248,225,1,0,96,227,1,0,200,228,1,0,48,230,1,0,152,231,1,0,0,233,1,0,104,234,1,0,208,235,1,0,
  208,235,1,0,56,237,1,0,160,238,1,0,8,240,1,0,112,241,1,0,216,242,1,0,216,242,1,0,0,0,0,0,
  4,0,0,0,8,0,0,0,11,0,0,0,14,0,0,0,17,0,0,0,20,0,0,0,22,0,0,0,24,0,0,0,
  26,0,0,0,28,0,0,0,30,0,0,0,32,0,0,0,34,0,0,0,36,0,0,0,38,0,0,0,40,0,0,0,
  42,0,0,0,44,0,0,0,0,0,0,0,16,0,0,0,31,0,0,0,46,0,0,0,60,0,0,0,0,0,0,0,
  17,0,0,0,33,0,0,0,49,0,0,0,64,0,0,0,0,0,0,0,26,0,0,0,51,0,0,0,76,0,0,0,
  100,0,0,0,0,0,0,0,27,0,0,0,53,0,0,0,79,0,0,0,104,0,0,0,0,0,0,0,35,0,0,0,
  69,0,0,0,0,0,0,0,40,0,0,0,79,0,0,0,4,0,0,0,4,0,0,0,15,0,0,0,15,0,0,0,
  16,0,0,0,16,0,0,0,25,0,0,0,25,0,0,0,26,0,0,0,0,0,0,0,35,0,0,0,35,0,0,0,
  40,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,22,0,0,0,8,0,0,0,20,0,0,0,
  12,0,0,0,20,0,0,0,16,0,0,0,16,0,0,0,16,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,
  7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,
  2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,
  1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
  2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
  2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
  2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
  2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,
  5,6,6,7,6,7,7,8,6,7,7,8,7,8,8,9,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
  2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,
  5,6,6,7,6,7,7,8,6,7,7,8,7,8,8,9,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
  3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,
  5,6,6,7,6,7,7,8,6,7,7,8,7,8,8,9,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
  4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,
  5,6,6,7,6,7,7,8,6,7,7,8,7,8,8,9,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,
  5,6,6,7,6,7,7,8,6,7,7,8,7,8,8,9,5,6,6,7,6,7,7,8,6,7,7,8,7,8,8,9,
  6,7,7,8,7,8,8,9,7,8,8,9,8,9,9,10,0,212,216,0,220,0,0,0,252,0,0,0,0,0,0,0,
  4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,0,0,0,79,0,0,0,
  85,0,0,0,92,0,0,0,95,0,0,0,92,0,0,0,85,0,0,0,79,0,0,0,72,0,0,0,0,0,0,0,
  85,0,0,0,92,0,0,0,99,0,0,0,105,0,0,0,108,0,0,0,105,0,0,0,99,0,0,0,92,0,0,0,
  85,0,0,0,0,0,0,0,95,0,0,0,102,0,0,0,108,0,0,0,115,0,0,0,118,0,0,0,115,0,0,0,
  108,0,0,0,102,0,0,0,95,0,0,0,0,0,0,0,49,0,0,0,56,0,0,0,62,0,0,0,69,0,0,0,
  72,0,0,0,69,0,0,0,62,0,0,0,56,0,0,0,49,0,0,0,0,0,0,0,49,0,0,0,56,0,0,0,
  62,0,0,0,69,0,0,0,72,0,0,0,69,0,0,0,62,0,0,0,56,0,0,0,49,0,0,0,0,0,0,0,
  46,0,0,0,52,0,0,0,59,0,0,0,66,0,0,0,69,0,0,0,66,0,0,0,59,0,0,0,52,0,0,0,
  46,0,0,0,0,0,0,0,33,0,0,0,36,0,0,0,42,0,0,0,49,0,0,0,52,0,0,0,49,0,0,0,
  42,0,0,0,36,0,0,0,33,0,0,0,0,0,0,0,26,0,0,0,29,0,0,0,33,0,0,0,36,0,0,0,
  42,0,0,0,36,0,0,0,33,0,0,0,29,0,0,0,26,0,0,0,0,0,0,0,17,1,0,0,56,1,0,0,
  95,1,0,0,134,1,0,0,134,1,0,0,134,1,0,0,95,1,0,0,56,1,0,0,17,1,0,0,0,0,0,0,
  95,1,0,0,134,1,0,0,173,1,0,0,212,1,0,0,212,1,0,0,212,1,0,0,173,1,0,0,134,1,0,0,
  95,1,0,0,0,0,0,0,173,1,0,0,212,1,0,0,251,1,0,0,34,2,0,0,34,2,0,0,34,2,0,0,
  251,1,0,0,212,1,0,0,173,1,0,0,0,0,0,0,212,1,0,0,251,1,0,0,34,2,0,0,73,2,0,0,
  73,2,0,0,73,2,0,0,34,2,0,0,251,1,0,0,212,1,0,0,0,0,0,0,223,1,0,0,2,2,0,0,
  37,2,0,0,73,2,0,0,73,2,0,0,73,2,0,0,37,2,0,0,2,2,0,0,223,1,0,0,0,0,0,0,
  223,1,0,0,2,2,0,0,37,2,0,0,73,2,0,0,73,2,0,0,73,2,0,0,37,2,0,0,2,2,0,0,
  223,1,0,0,0,0,0,0,14,2,0,0,53,2,0,0,92,2,0,0,166,2,0,0,131,2,0,0,131,2,0,0,
  92,2,0,0,53,2,0,0,14,2,0,0,0,0,0,0,53,2,0,0,92,2,0,0,174,2,0,0,166,2,0,0,
  174,2,0,0,166,2,0,0,131,2,0,0,92,2,0,0,53,2,0,0,0,0,0,0,14,2,0,0,53,2,0,0,
  92,2,0,0,131,2,0,0,131,2,0,0,131,2,0,0,92,2,0,0,53,2,0,0,14,2,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,85,0,0,0,93,0,0,0,101,0,0,0,109,0,0,0,109,0,0,0,109,0,0,0,
  101,0,0,0,93,0,0,0,85,0,0,0,0,0,0,0,117,0,0,0,124,0,0,0,132,0,0,0,140,0,0,0,
  140,0,0,0,140,0,0,0,132,0,0,0,124,0,0,0,117,0,0,0,0,0,0,0,148,0,0,0,156,0,0,0,
  163,0,0,0,171,0,0,0,171,0,0,0,171,0,0,0,163,0,0,0,156,0,0,0,148,0,0,0,0,0,0,0,
  179,0,0,0,187,0,0,0,195,0,0,0,202,0,0,0,202,0,0,0,202,0,0,0,195,0,0,0,187,0,0,0,
  179,0,0,0,0,0,0,0,210,0,0,0,218,0,0,0,226,0,0,0,234,0,0,0,234,0,0,0,234,0,0,0,
  226,0,0,0,218,0,0,0,210,0,0,0,0,0,0,0,241,0,0,0,249,0,0,0,1,1,0,0,9,1,0,0,
  9,1,0,0,9,1,0,0,1,1,0,0,249,0,0,0,241,0,0,0,0,0,0,0,17,1,0,0,24,1,0,0,
  32,1,0,0,40,1,0,0,40,1,0,0,40,1,0,0,32,1,0,0,24,1,0,0,17,1,0,0,0,0,0,0,
  48,1,0,0,56,1,0,0,63,1,0,0,71,1,0,0,71,1,0,0,71,1,0,0,63,1,0,0,56,1,0,0,
  48,1,0,0,0,0,0,0,235,0,0,0,12,1,0,0,46,1,0,0,80,1,0,0,80,1,0,0,80,1,0,0,
  46,1,0,0,12,1,0,0,235,0,0,0,0,0,0,0,46,1,0,0,80,1,0,0,113,1,0,0,147,1,0,0,
  147,1,0,0,147,1,0,0,113,1,0,0,80,1,0,0,46,1,0,0,0,0,0,0,113,1,0,0,147,1,0,0,
  180,1,0,0,214,1,0,0,214,1,0,0,214,1,0,0,180,1,0,0,147,1,0,0,113,1,0,0,0,0,0,0,
  147,1,0,0,180,1,0,0,214,1,0,0,248,1,0,0,248,1,0,0,248,1,0,0,214,1,0,0,180,1,0,0,
  147,1,0,0,0,0,0,0,157,1,0,0,187,1,0,0,217,1,0,0,248,1,0,0,248,1,0,0,248,1,0,0,
  217,1,0,0,187,1,0,0,157,1,0,0,0,0,0,0,157,1,0,0,187,1,0,0,217,1,0,0,248,1,0,0,
  248,1,0,0,248,1,0,0,217,1,0,0,187,1,0,0,157,1,0,0,0,0,0,0,197,1,0,0,231,1,0,0,
  8,2,0,0,72,2,0,0,42,2,0,0,42,2,0,0,8,2,0,0,231,1,0,0,197,1,0,0,0,0,0,0,
  231,1,0,0,8,2,0,0,79,2,0,0,72,2,0,0,79,2,0,0,72,2,0,0,42,2,0,0,8,2,0,0,
  231,1,0,0,0,0,0,0,197,1,0,0,231,1,0,0,8,2,0,0,42,2,0,0,42,2,0,0,42,2,0,0,
  8,2,0,0,231,1,0,0,197,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  189,0,0,0,252,0,0,0,27,1,0,0,43,1,0,0,43,1,0,0,43,1,0,0,27,1,0,0,252,0,0,0,
  189,0,0,0,0,0,0,0,189,0,0,0,252,0,0,0,27,1,0,0,43,1,0,0,43,1,0,0,43,1,0,0,
  27,1,0,0,252,0,0,0,189,0,0,0,0,0,0,0,189,0,0,0,252,0,0,0,27,1,0,0,43,1,0,0,
  43,1,0,0,43,1,0,0,27,1,0,0,252,0,0,0,189,0,0,0,0,0,0,0,189,0,0,0,252,0,0,0,
  27,1,0,0,43,1,0,0,43,1,0,0,43,1,0,0,27,1,0,0,252,0,0,0,189,0,0,0,0,0,0,0,
  195,0,0,0,2,1,0,0,33,1,0,0,49,1,0,0,49,1,0,0,49,1,0,0,33,1,0,0,2,1,0,0,
  195,0,0,0,0,0,0,0,220,0,0,0,27,1,0,0,59,1,0,0,74,1,0,0,74,1,0,0,74,1,0,0,
  59,1,0,0,27,1,0,0,220,0,0,0,0,0,0,0,252,0,0,0,59,1,0,0,90,1,0,0,106,1,0,0,
  106,1,0,0,106,1,0,0,90,1,0,0,59,1,0,0,252,0,0,0,0,0,0,0,231,0,0,0,8,1,0,0,
  41,1,0,0,74,1,0,0,74,1,0,0,74,1,0,0,41,1,0,0,8,1,0,0,231,0,0,0,0,0,0,0,
  41,1,0,0,74,1,0,0,107,1,0,0,140,1,0,0,140,1,0,0,140,1,0,0,107,1,0,0,74,1,0,0,
  41,1,0,0,0,0,0,0,107,1,0,0,140,1,0,0,173,1,0,0,206,1,0,0,206,1,0,0,206,1,0,0,
  173,1,0,0,140,1,0,0,107,1,0,0,0,0,0,0,140,1,0,0,173,1,0,0,206,1,0,0,239,1,0,0,
  239,1,0,0,239,1,0,0,206,1,0,0,173,1,0,0,140,1,0,0,0,0,0,0,149,1,0,0,179,1,0,0,
  209,1,0,0,239,1,0,0,239,1,0,0,239,1,0,0,209,1,0,0,179,1,0,0,149,1,0,0,0,0,0,0,
  149,1,0,0,179,1,0,0,209,1,0,0,239,1,0,0,239,1,0,0,239,1,0,0,209,1,0,0,179,1,0,0,
  149,1,0,0,0,0,0,0,189,1,0,0,222,1,0,0,255,1,0,0,62,2,0,0,32,2,0,0,32,2,0,0,
  255,1,0,0,222,1,0,0,189,1,0,0,0,0,0,0,222,1,0,0,255,1,0,0,68,2,0,0,62,2,0,0,
  68,2,0,0,62,2,0,0,32,2,0,0,255,1,0,0,222,1,0,0,0,0,0,0,189,1,0,0,222,1,0,0,
  255,1,0,0,32,2,0,0,32,2,0,0,32,2,0,0,255,1,0,0,222,1,0,0,189,1,0,0,0,0,0,0,
  43,1,0,0,74,1,0,0,106,1,0,0,112,1,0,0,112,1,0,0,112,1,0,0,106,1,0,0,74,1,0,0,
  43,1,0,0,0,0,0,0,106,1,0,0,137,1,0,0,169,1,0,0,175,1,0,0,175,1,0,0,175,1,0,0,
  169,1,0,0,137,1,0,0,106,1,0,0,0,0,0,0,137,1,0,0,169,1,0,0,200,1,0,0,207,1,0,0,
  207,1,0,0,207,1,0,0,200,1,0,0,169,1,0,0,137,1,0,0,0,0,0,0,122,1,0,0,153,1,0,0,
  185,1,0,0,191,1,0,0,191,1,0,0,191,1,0,0,185,1,0,0,153,1,0,0,122,1,0,0,0,0,0,0,
  122,1,0,0,153,1,0,0,185,1,0,0,191,1,0,0,191,1,0,0,191,1,0,0,185,1,0,0,153,1,0,0,
  122,1,0,0,0,0,0,0,122,1,0,0,153,1,0,0,185,1,0,0,191,1,0,0,191,1,0,0,191,1,0,0,
  185,1,0,0,153,1,0,0,122,1,0,0,0,0,0,0,159,1,0,0,200,1,0,0,232,1,0,0,232,1,0,0,
  232,1,0,0,232,1,0,0,222,1,0,0,200,1,0,0,159,1,0,0,0,0,0,0,159,1,0,0,200,1,0,0,
  216,1,0,0,222,1,0,0,222,1,0,0,222,1,0,0,216,1,0,0,200,1,0,0,159,1,0,0,0,0,0,0,
  144,1,0,0,175,1,0,0,200,1,0,0,207,1,0,0,207,1,0,0,207,1,0,0,200,1,0,0,175,1,0,0,
  144,1,0,0,0,0,0,0,220,0,0,0,252,0,0,0,27,1,0,0,59,1,0,0,59,1,0,0,59,1,0,0,
  27,1,0,0,252,0,0,0,220,0,0,0,0,0,0,0,27,1,0,0,59,1,0,0,90,1,0,0,122,1,0,0,
  122,1,0,0,122,1,0,0,90,1,0,0,59,1,0,0,27,1,0,0,0,0,0,0,90,1,0,0,122,1,0,0,
  153,1,0,0,185,1,0,0,185,1,0,0,185,1,0,0,153,1,0,0,122,1,0,0,90,1,0,0,0,0,0,0,
  122,1,0,0,153,1,0,0,185,1,0,0,216,1,0,0,216,1,0,0,216,1,0,0,185,1,0,0,153,1,0,0,
  122,1,0,0,0,0,0,0,131,1,0,0,159,1,0,0,188,1,0,0,216,1,0,0,216,1,0,0,216,1,0,0,
  188,1,0,0,159,1,0,0,131,1,0,0,0,0,0,0,131,1,0,0,159,1,0,0,188,1,0,0,216,1,0,0,
  216,1,0,0,216,1,0,0,188,1,0,0,159,1,0,0,131,1,0,0,0,0,0,0,169,1,0,0,200,1,0,0,
  232,1,0,0,36,2,0,0,7,2,0,0,7,2,0,0,232,1,0,0,200,1,0,0,169,1,0,0,0,0,0,0,
  200,1,0,0,232,1,0,0,42,2,0,0,36,2,0,0,42,2,0,0,36,2,0,0,7,2,0,0,232,1,0,0,
  200,1,0,0,0,0,0,0,169,1,0,0,200,1,0,0,232,1,0,0,7,2,0,0,7,2,0,0,7,2,0,0,
  232,1,0,0,200,1,0,0,169,1,0,0,0,0,0,0,210,0,0,0,240,0,0,0,14,1,0,0,44,1,0,0,
  44,1,0,0,44,1,0,0,14,1,0,0,240,0,0,0,210,0,0,0,0,0,0,0,14,1,0,0,44,1,0,0,
  74,1,0,0,104,1,0,0,104,1,0,0,104,1,0,0,74,1,0,0,44,1,0,0,14,1,0,0,0,0,0,0,
  74,1,0,0,104,1,0,0,134,1,0,0,164,1,0,0,164,1,0,0,164,1,0,0,134,1,0,0,104,1,0,0,
  74,1,0,0,0,0,0,0,104,1,0,0,134,1,0,0,164,1,0,0,194,1,0,0,194,1,0,0,194,1,0,0,
  164,1,0,0,134,1,0,0,104,1,0,0,0,0,0,0,113,1,0,0,140,1,0,0,167,1,0,0,194,1,0,0,
  194,1,0,0,194,1,0,0,167,1,0,0,140,1,0,0,113,1,0,0,0,0,0,0,113,1,0,0,140,1,0,0,
  167,1,0,0,194,1,0,0,194,1,0,0,194,1,0,0,167,1,0,0,140,1,0,0,113,1,0,0,0,0,0,0,
  149,1,0,0,179,1,0,0,209,1,0,0,13,2,0,0,239,1,0,0,254,1,0,0,209,1,0,0,179,1,0,0,
  149,1,0,0,0,0,0,0,179,1,0,0,209,1,0,0,28,2,0,0,239,1,0,0,13,2,0,0,239,1,0,0,
  239,1,0,0,209,1,0,0,179,1,0,0,0,0,0,0,149,1,0,0,179,1,0,0,209,1,0,0,239,1,0,0,
  224,1,0,0,239,1,0,0,209,1,0,0,179,1,0,0,149,1,0,0,0,0,0,0,163,2,0,0,163,2,0,0,
  163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,0,0,0,0,
  163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,
  163,2,0,0,0,0,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,
  163,2,0,0,163,2,0,0,163,2,0,0,0,0,0,0,149,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,
  163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,149,2,0,0,0,0,0,0,149,2,0,0,163,2,0,0,
  163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,149,2,0,0,0,0,0,0,
  149,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,163,2,0,0,
  149,2,0,0,0,0,0,0,149,2,0,0,171,2,0,0,171,2,0,0,171,2,0,0,171,2,0,0,171,2,0,0,
  171,2,0,0,171,2,0,0,149,2,0,0,0,0,0,0,149,2,0,0,179,2,0,0,179,2,0,0,179,2,0,0,
  179,2,0,0,179,2,0,0,179,2,0,0,179,2,0,0,149,2,0,0,0,0,0,0,163,2,0,0,190,2,0,0,
  190,2,0,0,190,2,0,0,190,2,0,0,190,2,0,0,190,2,0,0,190,2,0,0,163,2,0,0,0,0,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,0,0,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,0,0,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,0,0,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,0,0,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,0,0,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,0,0,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,0,0,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,0,0,0,0,
  176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,176,4,0,0,
  176,4,0,0,0,0,0,0,82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,
  82,3,0,0,82,3,0,0,82,3,0,0,0,0,0,0,82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,
  82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,0,0,0,0,82,3,0,0,82,3,0,0,
  82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,82,3,0,0,0,0,0,0,
  3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,
  3,3,0,0,0,0,0,0,244,2,0,0,244,2,0,0,244,2,0,0,244,2,0,0,244,2,0,0,244,2,0,0,
  244,2,0,0,244,2,0,0,244,2,0,0,0,0,0,0,19,3,0,0,19,3,0,0,19,3,0,0,19,3,0,0,
  19,3,0,0,19,3,0,0,19,3,0,0,19,3,0,0,19,3,0,0,0,0,0,0,35,3,0,0,35,3,0,0,
  35,3,0,0,35,3,0,0,35,3,0,0,35,3,0,0,35,3,0,0,35,3,0,0,35,3,0,0,0,0,0,0,
  51,3,0,0,51,3,0,0,51,3,0,0,51,3,0,0,51,3,0,0,51,3,0,0,51,3,0,0,51,3,0,0,
  51,3,0,0,0,0,0,0,51,3,0,0,51,3,0,0,51,3,0,0,51,3,0,0,51,3,0,0,51,3,0,0,
  51,3,0,0,51,3,0,0,51,3,0,0,0,0,0,0,137,5,0,0,137,5,0,0,137,5,0,0,137,5,0,0,
  137,5,0,0,137,5,0,0,137,5,0,0,137,5,0,0,137,5,0,0,0,0,0,0,137,5,0,0,137,5,0,0,
  137,5,0,0,137,5,0,0,137,5,0,0,137,5,0,0,137,5,0,0,137,5,0,0,137,5,0,0,0,0,0,0,
  236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,
  236,4,0,0,0,0,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,
  236,4,0,0,236,4,0,0,236,4,0,0,0,0,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,
  236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,0,0,0,0,236,4,0,0,236,4,0,0,
  236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,0,0,0,0,
  236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,
  236,4,0,0,0,0,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,
  236,4,0,0,236,4,0,0,236,4,0,0,0,0,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,
  236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,236,4,0,0,0,0,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,0,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,0,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,0,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,0,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,0,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,0,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,0,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,0,0,0,0,15,0,0,0,15,0,0,
  0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  238,25,232,61,40,94,105,91,239,40,105,182,239,174,88,199,247,161,217,132,108,66,151,62,228,159,82,35,6,126,31,77,
  179,58,39,3,235,29,3,207,86,73,181,165,58,206,90,123,242,126,248,215,245,106,64,216,75,10,122,157,0,147,159,152,
  68,203,248,196,118,203,84,4,100,58,242,252,25,17,6,137,59,185,184,18,194,30,0,229,254,67,74,213,193,253,192,57,
  0,183,80,208,209,140,46,235,176,164,91,191,111,185,25,22,129,142,110,62,110,41,145,143,162,137,160,192,4,185,177,58,
  52,107,81,76,188,165,45,30,7,160,204,202,3,4,13,178,129,117,228,248,83,233,185,104,100,76,164,1,146,29,243,68,
  164,193,20,225,146,208,72,216,190,32,111,152,240,151,225,50,223,152,96,215,78,50,150,169,168,248,144,216,83,193,242,251,
  141,70,200,43,1,246,196,155,212,153,88,218,187,74,74,138,41,100,234,196,156,166,21,220,204,252,43,191,178,247,195,22,
  253,87,238,59,45,92,14,91,139,145,41,187,251,160,219,95,198,109,0,199,111,43,10,42,151,36,255,126,143,40,176,184,
  148,128,132,216,186,249,170,104,255,148,172,27,244,75,210,57,3,170,55,248,244,166,236,71,80,166,155,14,38,85,102,247,
  95,244,162,215,89,16,43,253,83,81,152,150,92,149,114,65,39,143,99,81,124,63,208,228,45,93,117,95,179,52,109,131,
  152,177,157,201,180,221,210,203,240,251,106,177,210,109,138,117,71,54,43,66,77,184,123,77,116,178,34,160,166,194,140,106,
  28,148,104,108,239,60,106,179,185,19,36,134,86,21,115,131,96,220,116,119,209,184,81,229,51,230,46,209,127,233,106,241,
  66,98,197,5,137,216,246,89,136,165,11,216,27,95,166,35,177,232,245,46,187,124,246,239,174,211,233,37,227,112,133,48,
  173,25,177,244,212,90,35,185,248,81,88,238,53,14,123,228,252,24,188,38,90,79,175,224,65,167,3,216,187,193,37,124,
  136,103,170,93,126,181,165,169,210,34,176,58,21,248,3,147,197,99,193,213,28,104,65,28,19,243,140,39,82,64,218,78,
  188,209,61,113,49,43,142,24,81,70,217,243,134,175,207,226,35,244,197,12,41,74,39,98,48,146,121,30,142,188,25,148,
  162,227,136,153,71,93,3,251,139,56,172,121,145,44,133,28,5,68,44,5,209,90,107,193,94,60,48,97,88,46,139,206,
  246,10,153,121,64,227,108,131,20,174,5,191,191,128,207,150,103,184,184,120,252,167,29,224,5,192,136,116,33,173,220,50,
  194,11,212,62,165,243,101,112,4,245,232,115,62,117,45,203,85,3,13,229,35,4,176,17,191,74,226,89,255,174,158,254,
  84,236,65,207,165,52,190,144,37,185,212,19,246,68,219,61,30,124,171,72,137,30,232,20,96,10,204,140,222,208,193,94,
  92,171,248,218,227,202,228,114,248,54,158,193,250,145,221,87,164,177,211,91,228,27,100,241,7,66,214,232,163,155,65,47,
  249,233,18,70,149,86,195,120,215,173,120,3,219,196,79,85,236,22,40,43,136,252,91,218,18,110,171,164,135,51,115,51,
  46,124,162,221,116,100,36,45,199,254,87,105,108,42,13,38,182,105,121,147,97,142,208,128,235,246,172,97,199,99,124,89,
  57,26,73,93,97,63,144,81,112,2,166,15,101,157,168,19,206,241,15,123,113,41,151,162,44,58,153,26,236,48,75,125,
  214,80,186,84,128,41,79,203,118,83,54,123,125,226,175,77,46,208,243,199,96,12,213,232,211,156,54,117,240,149,140,176,
  120,124,230,45,121,20,203,113,165,136,57,91,103,75,179,236,154,193,236,18,176,61,22,109,202,103,113,188,119,210,190,21,
  156,253,89,217,160,169,91,162,223,51,199,251,2,110,28,98,156,215,182,129,10,81,236,34,230,191,182,125,197,254,89,242,
  249,99,177,254,63,146,75,162,169,108,126,220,17,109,85,61,181,122,177,100,152,12,6,226,162,106,183,247,205,66,148,22,
  65,208,174,197,170,176,121,31,199,36,201,1,113,124,163,52,178,198,198,132,24,42,146,82,116,80,102,87,145,115,94,179,
  150,126,21,183,243,239,127,50,33,164,120,154,169,68,37,203,76,152,164,149,214,255,253,102,215,100,90,215,55,21,186,245,
  143,55,168,60,135,132,167,63,227,95,89,227,59,52,179,122,114,0,137,209,8,196,222,128,120,91,38,196,252,96,97,112,
  191,86,220,213,149,61,234,84,11,114,252,236,128,103,125,113,230,250,77,236,39,223,242,189,82,142,144,136,113,45,83,244,
  235,99,110,146,113,210,69,21,11,239,70,170,13,214,1,5,79,125,92,77,72,72,25,141,110,92,59,110,163,223,252,212,
  21,93,112,245,55,115,219,154,78,218,120,26,41,117,107,80,24,120,139,137,128,120,120,235,237,63,64,35,178,119,239,106,
  162,243,247,148,118,185,103,215,117,202,3,196,179,147,192,184,99,137,105,198,248,71,219,12,213,219,75,83,196,53,60,55,
  106,127,124,139,136,169,223,141,148,122,245,246,190,183,181,238,121,171,131,29,141,0,124,78,221,175,164,3,151,8,171,21,
  57,39,169,157,63,42,83,176,68,215,59,221,202,205,91,101,227,187,96,211,147,98,89,135,251,250,235,98,149,157,133,250,
  113,200,39,187,45,131,59,4,217,208,176,119,1,197,36,114,220,5,144,85,177,84,181,178,21,91,22,254,251,85,251,178,
  44,202,241,38,249,58,73,172,90,38,156,16,37,32,148,44,12,123,35,121,6,5,237,213,117,31,178,136,197,203,210,188,
  124,7,113,231,108,85,102,131,48,2,89,102,95,30,241,65,88,114,176,21,47,54,63,93,221,226,77,102,186,118,39,139,
  29,186,128,5,116,10,250,157,116,202,136,126,197,197,52,28,209,138,92,93,91,220,89,220,252,206,172,27,241,238,101,102,
  114,134,136,169,42,45,163,102,92,168,139,67,111,169,158,202,141,188,107,68,144,118,254,204,15,133,64,1,1,230,198,142,
  6,58,18,228,253,89,65,169,85,142,252,207,34,76,225,53,126,245,253,139,85,212,61,197,229,135,63,133,112,189,13,174,
  144,73,235,165,212,219,46,161,10,22,94,253,153,57,30,139,159,211,18,60,147,203,72,206,243,205,73,241,210,66,169,206,
  125,162,181,165,141,80,58,195,220,105,112,149,182,219,189,142,91,237,190,245,115,202,200,223,230,177,125,152,241,229,132,216,
  60,80,8,164,129,226,131,133,95,139,119,242,23,61,211,229,4,117,209,253,77,33,47,84,90,214,157,5,81,66,94,181,
  216,202,123,103,103,148,72,91,102,13,113,201,20,205,16,148,68,139,216,14,17,167,106,192,204,154,100,2,183,36,65,246,
  212,178,179,126,52,225,206,158,142,216,238,235,91,125,64,145,95,6,232,83,8,184,137,131,130,81,96,133,211,248,0,253,
  79,79,146,18,123,74,157,13,79,206,66,37,46,51,191,1,184,185,19,66,179,57,36,15,165,67,242,172,44,130,118,200,
  26,94,50,194,5,193,93,86,236,199,242,186,51,130,174,209,18,159,39,112,103,87,206,9,10,3,44,173,217,19,52,151,
  11,178,62,6,166,180,233,215,26,147,25,20,214,20,37,85,44,123,127,7,84,42,203,171,107,208,53,229,226,14,48,104,
  51,194,154,38,56,216,226,162,250,159,192,200,202,159,109,161,78,202,38,132,91,19,80,240,19,53,125,135,43,119,144,33,
  23,144,254,125,20,24,38,128,137,158,216,214,121,220,75,105,223,151,125,229,91,216,153,22,112,111,104,210,207,164,2,111,
  22,237,67,244,35,37,111,83,8,158,203,251,117,197,4,157,234,30,178,32,123,87,13,0,171,228,120,176,125,92,52,162,
  126,208,166,69,163,43,246,123,159,34,5,8,92,105,203,71,160,125,29,219,139,232,75,10,176,231,130,76,38,169,22,239,
  149,106,5,236,131,227,42,23,74,180,106,232,202,228,195,235,183,35,10,214,128,143,225,247,238,98,11,38,12,24,71,49,
  141,162,199,96,42,58,9,233,42,214,95,244,43,105,6,127,78,105,225,8,158,168,233,89,110,229,79,123,190,129,116,97,
  89,241,124,202,136,132,160,23,208,203,205,205,125,12,137,68,38,20,133,150,182,135,118,229,246,201,164,91,228,246,240,132,
  132,151,154,166,54,70,71,56,209,36,87,134,233,155,236,225,4,252,20,21,19,158,146,128,200,164,161,223,2,134,181,68,
  116,143,241,63,164,156,226,14,9,91,46,46,90,182,213,241,33,118,108,56,86,57,104,33,88,16,36,127,18,0,103,36,
  243,104,98,139,137,105,4,64,245,129,195,29,219,180,77,215,159,50,152,68,68,85,5,144,218,159,160,117,171,122,91,117,
  172,220,114,157,30,234,49,37,61,108,58,129,206,55,18,163,221,172,213,2,218,33,133,148,29,202,103,137,228,24,138,239,
  177,156,169,246,243,217,122,20,97,242,134,97,139,180,149,205,117,243,6,135,138,212,247,218,55,28,181,184,221,138,243,140,
  185,213,20,98,31,126,238,100,55,162,23,153,61,36,3,117,45,60,188,35,119,96,242,199,193,84,79,80,99,16,65,96,
  192,56,40,220,150,208,139,215,125,182,25,156,5,158,239,90,89,135,136,111,233,192,154,252,248,116,201,167,97,19,37,130,
  123,220,176,222,76,97,188,167,3,142,43,222,252,165,23,212,218,235,251,21,183,58,76,46,105,18,233,15,219,76,17,27,
  236,16,213,214,146,178,195,135,29,4,150,81,204,45,54,72,229,115,107,1,170,213,152,140,189,54,99,223,254,205,213,167,
  89,246,92,226,137,194,99,36,200,117,55,194,49,10,60,27,135,117,149,165,107,2,41,3,73,94,75,150,202,240,184,250,
  117,38,57,39,153,52,94,253,94,100,114,182,36,81,41,131,90,97,242,228,36,145,134,38,186,193,244,187,135,160,110,231,
  66,128,179,220,212,173,1,105,46,97,163,88,69,93,186,204,160,245,75,78,182,121,49,148,169,219,128,163,169,211,172,209,
  54,219,147,1,226,236,188,11,139,16,0,31,165,54,212,191,173,111,109,39,157,23,63,35,181,129,212,98,188,94,161,186,
  181,251,13,169,121,184,178,62,46,111,102,86,178,93,124,113,196,155,203,91,146,107,224,199,195,15,3,215,53,106,106,171,
  16,98,55,176,250,70,185,45,23,214,103,255,205,97,172,41,174,90,147,158,217,37,234,108,86,217,248,165,245,64,92,222,
  157,84,253,178,88,48,27,224,154,222,129,228,153,11,146,161,210,113,6,53,141,204,114,82,74,57,221,13,210,212,133,107,
  57,231,32,140,99,170,181,70,131,167,20,114,111,190,62,232,195,73,101,214,125,101,246,245,150,30,65,50,194,113,241,238,
  254,163,181,18,43,202,53,132,138,204,63,78,119,5,252,156,243,173,59,113,179,228,196,133,25,73,54,56,147,163,92,197,
  109,188,239,217,103,39,200,198,27,36,18,117,57,73,52,97,235,170,74,52,41,127,132,202,206,205,147,211,12,150,83,57,
  102,242,27,185,9,147,138,102,246,60,253,109,190,145,38,98,235,18,182,57,154,254,127,70,107,215,80,110,232,96,7,32,
  49,127,219,57,115,155,210,170,252,42,163,153,61,245,145,111,230,205,192,16,179,66,116,212,122,254,52,24,109,167,188,69,
  181,144,222,49,102,129,82,9,229,56,136,166,159,172,203,145,198,238,118,148,236,65,241,81,150,248,63,89,237,166,96,55,
  74,222,58,162,152,235,43,130,224,169,206,250,96,253,19,248,242,199,128,84,83,109,214,215,203,1,235,160,60,227,83,111,
  213,225,117,45,156,81,80,147,194,125,137,255,114,163,85,52,146,232,94,149,162,131,77,54,38,191,94,123,137,100,90,99,
  253,217,115,178,55,31,212,233,93,170,225,111,215,243,164,108,161,232,193,161,145,19,27,217,228,83,167,109,11,187,227,216,
  146,232,52,195,154,109,168,89,19,19,170,209,30,19,16,139,242,231,0,231,2,62,147,203,3,101,201,51,193,67,170,3,
  56,164,195,28,152,56,160,135,62,65,33,181,99,219,252,82,11,193,195,107,153,205,242,131,248,240,96,83,189,114,136,35,
  66,49,69,146,100,255,84,248,91,1,50,191,215,107,7,193,171,197,93,97,58,70,133,233,89,57,50,233,31,14,22,51,
  183,195,39,206,253,53,237,163,247,145,243,177,124,67,59,91,132,92,122,105,218,171,123,104,54,166,119,82,159,116,69,162,
  161,143,204,190,16,120,174,191,188,224,153,227,137,85,93,55,194,193,152,235,4,198,16,178,22,237,170,124,221,4,3,38,
  71,137,66,197,42,212,92,13,20,61,213,80,134,74,86,20,202,173,78,247,177,213,54,165,11,209,57,254,254,4,251,252,
  133,109,23,29,49,135,227,78,28,182,98,142,187,108,233,203,96,93,153,34,197,222,165,184,160,214,235,51,141,38,83,126,
  234,181,28,129,47,187,49,34,197,252,214,28,183,239,136,38,188,35,146,251,45,80,169,205,97,70,22,222,99,8,217,163,
  147,53,143,16,79,28,117,186,5,234,31,74,9,81,113,34,83,47,238,224,173,107,113,169,141,206,25,185,61,51,54,81,
  191,211,253,83,9,204,200,117,45,75,21,218,227,88,112,24,15,149,252,129,5,177,157,254,224,207,65,78,180,37,165,46,
  179,64,53,158,151,113,247,16,79,85,244,51,14,214,202,151,118,210,242,45,18,182,201,126,251,187,210,144,63,201,234,142,
  186,203,215,101,42,146,236,11,206,227,249,186,192,208,77,159,143,102,171,198,173,131,11,38,171,230,212,218,198,195,208,85,
  141,24,238,41,179,155,94,136,152,247,23,111,59,13,0,14,193,236,127,116,100,114,53,195,53,226,198,219,85,205,32,76,
  239,87,125,115,238,62,159,35,12,228,70,140,44,31,149,232,39,71,86,178,241,81,60,37,95,146,111,43,174,174,209,84,
  123,165,233,182,54,81,64,150,58,39,55,68,57,157,152,18,249,138,3,246,45,233,114,106,133,160,82,67,168,181,192,227,
  29,34,96,5,126,62,161,27,99,98,255,173,76,147,242,140,155,224,11,191,114,168,87,158,57,165,151,66,180,97,25,49,
  156,190,188,150,97,96,107,8,5,111,112,242,126,51,139,168,34,164,193,41,125,203,164,20,89,212,113,31,4,158,68,183,
  222,35,211,22,81,240,198,96,160,37,234,42,50,99,107,51,130,53,11,191,56,70,47,79,61,241,35,31,151,54,228,165,
  42,55,233,251,155,39,8,120,218,33,74,4,17,13,137,85,224,198,245,12,152,242,40,249,196,124,33,106,197,153,35,140,
  158,92,103,203,43,255,154,21,162,69,192,4,227,11,157,65,87,87,126,176,132,117,208,177,197,182,4,139,148,123,203,165,
  131,136,239,235,156,5,150,92,162,251,169,150,116,4,177,230,250,223,216,43,195,170,80,44,128,185,123,30,184,128,58,129,
  255,168,151,74,255,65,250,143,70,151,190,10,89,186,27,80,157,185,86,40,119,93,22,41,127,41,95,113,1,246,62,152,
  254,169,34,192,222,247,16,124,121,16,168,167,243,41,106,244,162,36,219,195,136,132,9,113,112,102,27,142,66,101,222,141,
  20,201,109,32,20,227,111,3,171,26,172,157,194,38,180,83,215,140,144,200,224,131,160,83,29,193,155,137,203,37,121,139,
  203,226,19,121,52,71,2,248,113,16,93,22,24,211,45,128,26,88,1,66,109,89,89,158,63,119,105,232,45,37,168,169,
  73,99,116,201,124,91,64,163,110,90,135,70,163,58,135,54,55,50,56,253,10,46,198,3,176,138,77,76,187,135,143,216,
  102,54,145,116,235,107,2,66,104,159,9,115,123,214,175,179,221,24,104,87,192,94,31,25,230,147,64,80,93,239,198,246,
  46,227,173,73,139,41,192,37,33,208,6,69,224,35,205,234,13,73,244,178,69,185,35,51,195,253,22,213,34,39,72,92,
  47,222,99,201,142,84,109,121,36,239,124,197,160,178,63,160,11,8,196,88,132,216,184,36,210,93,164,81,67,39,193,177,
  172,217,141,74,92,229,111,51,163,163,178,41,234,125,193,185,175,108,1,32,131,17,38,232,97,145,94,243,148,149,208,111,
  180,246,216,41,76,29,81,244,98,138,43,65,118,30,194,68,109,32,49,24,75,108,173,117,2,1,114,198,245,210,56,204,
  46,189,194,190,109,220,54,37,44,103,236,217,76,212,69,3,164,146,234,91,137,241,154,35,219,103,233,245,137,222,149,248,
  67,133,121,207,239,58,108,241,166,152,54,19,2,159,12,119,195,102,245,34,156,214,7,36,62,137,222,138,19,148,91,166,
  2,130,235,201,2,81,74,235,245,237,169,162,91,233,105,96,83,164,251,69,90,101,188,226,64,60,104,118,92,142,17,81,
  196,21,30,135,15,116,40,91,22,57,111,64,45,19,178,52,245,26,151,234,226,203,148,4,222,44,164,182,236,243,224,119,
  243,79,235,215,57,218,118,51,44,79,45,21,4,169,38,164,215,192,135,226,44,217,128,15,136,34,208,157,182,130,78,63,
  172,251,253,132,237,133,161,81,186,161,242,165,77,94,224,135,164,6,226,65,9,122,253,169,4,175,100,82,107,216,144,99,
  37,61,220,228,173,123,195,121,180,28,91,148,45,16,118,122,16,119,88,95,254,2,161,138,197,117,174,108,159,101,179,91,
  197,104,33,3,167,109,7,70,118,9,209,210,244,66,192,134,223,67,153,29,77,82,108,170,199,120,60,32,94,165,132,221,
  74,169,92,223,37,200,138,102,25,80,63,219,215,243,87,140,8,122,130,213,202,22,94,157,73,202,40,51,186,16,121,197,
  55,147,150,130,141,5,181,161,162,31,52,197,69,54,121,234,238,110,37,50,72,14,36,153,189,184,27,189,69,168,100,168,
  155,37,71,84,15,2,4,95,195,68,233,182,38,171,12,67,0,188,186,110,200,151,88,245,59,186,101,255,161,155,28,126,
  61,223,68,51,151,54,101,106,95,127,132,1,152,92,35,167,200,146,94,75,125,123,10,97,224,237,166,131,18,237,158,98,
  212,149,213,13,168,244,61,43,140,166,70,21,136,116,115,218,67,123,89,221,137,112,22,15,240,160,7,232,67,64,94,138,
  70,242,205,113,69,50,198,255,220,254,73,58,122,94,25,22,216,93,32,212,170,245,254,193,194,145,209,174,204,29,164,177,
  30,44,204,143,76,188,107,76,84,82,84,199,238,130,234,200,249,235,230,175,157,216,165,125,35,54,151,131,218,217,141,41,
  51,187,255,191,204,31,6,146,156,25,219,192,70,127,28,163,165,203,35,189,62,195,213,174,53,112,162,37,179,241,12,17,
  64,155,190,31,93,207,181,136,93,147,50,199,243,166,140,199,126,33,82,72,234,67,53,244,202,15,13,21,205,81,208,221,
  91,180,127,63,248,245,80,232,53,20,212,246,112,48,95,91,127,229,3,245,130,216,182,159,202,37,42,16,190,154,96,97,
  40,44,19,47,230,253,243,183,244,200,229,254,175,245,177,77,27,21,11,161,67,88,92,172,5,75,170,185,136,128,31,247,
  106,43,0,180,82,242,176,126,86,155,44,96,17,141,9,34,246,71,246,116,201,171,198,83,111,112,36,228,147,185,13,167,
  229,233,217,68,250,56,198,243,72,128,23,73,39,91,143,21,54,45,245,119,235,134,64,235,165,107,146,200,205,224,126,155,
  13,81,243,144,53,78,153,205,251,238,42,184,83,84,83,11,140,97,194,1,241,43,193,89,31,123,126,172,167,179,5,117,
  92,36,100,35,141,229,151,241,79,201,142,104,214,176,121,77,98,26,53,75,75,242,35,166,94,200,173,62,241,206,100,148,
  240,172,6,186,172,15,42,130,239,220,174,23,223,104,181,145,112,37,117,198,245,48,68,50,219,32,234,67,60,125,143,208,
  154,162,23,89,26,176,152,56,105,160,159,196,181,225,166,75,209,96,101,107,207,6,147,133,248,4,188,39,54,73,38,9,
  90,227,171,199,252,255,54,56,173,35,110,90,245,111,214,125,50,1,146,45,195,100,144,153,98,180,88,130,31,144,126,99,
  246,121,100,225,156,66,145,111,230,231,93,29,80,61,91,188,150,148,12,101,115,88,200,32,173,174,27,3,59,3,130,6,
  93,151,204,160,42,186,110,215,24,226,9,107,49,207,54,186,98,195,141,56,2,191,169,218,109,68,50,64,118,30,14,243,
  162,16,38,40,174,110,190,197,231,131,175,221,46,9,122,124,193,165,25,150,244,35,240,26,199,109,156,72,113,176,24,113,
  203,197,101,231,183,253,249,154,254,137,87,113,31,45,106,181,81,156,48,0,139,1,105,252,77,156,242,239,140,247,119,183,
  140,216,227,253,44,243,134,232,8,243,235,185,90,239,62,2,74,158,150,237,123,189,85,222,209,14,173,47,220,245,101,87,
  220,47,157,167,81,76,33,213,180,48,77,169,133,6,59,171,171,252,18,226,192,144,111,179,174,64,153,192,238,86,0,41,
  35,236,30,151,118,49,223,201,142,104,7,59,96,114,119,123,197,21,60,123,191,250,44,246,23,163,165,173,196,124,209,20,
  66,157,235,104,214,112,215,68,190,62,114,72,42,34,244,211,42,97,3,82,234,224,236,125,171,64,116,185,214,134,61,0,
  36,121,19,189,129,10,185,108,182,7,67,208,74,121,230,13,3,185,228,248,4,190,88,50,152,21,11,181,106,179,147,106,
  41,124,170,82,131,89,243,151,72,230,153,214,249,40,23,6,91,153,193,141,245,95,87,95,61,107,46,121,188,156,254,44,
  202,83,51,82,194,10,198,31,12,68,59,169,203,52,58,54,178,42,35,182,1,229,106,79,145,199,204,13,60,86,4,12,
  42,253,108,31,36,77,99,241,252,58,0,215,230,190,44,188,101,76,144,165,246,208,192,229,87,130,34,156,78,77,118,107,
  211,97,71,224,38,0,239,84,234,200,237,11,176,110,218,37,174,210,103,164,220,28,247,146,164,188,99,29,48,69,162,111,
  121,50,186,53,104,16,12,202,14,115,2,144,37,191,64,45,92,40,81,75,155,226,31,86,212,220,151,107,20,243,217,111,
  35,126,37,184,153,252,93,164,132,131,159,98,151,99,248,178,159,103,32,248,16,25,115,69,6,89,6,5,233,0,163,31,
  158,54,64,234,75,241,157,75,110,229,247,172,215,224,245,143,158,166,122,35,147,113,127,184,6,43,207,5,16,127,213,68,
  91,169,174,20,221,59,59,37,27,98,193,167,170,69,97,107,3,77,238,84,98,107,242,150,125,203,164,230,233,253,30,163,
  70,210,31,48,209,221,239,170,242,73,243,15,102,223,97,134,203,240,228,210,137,163,17,33,234,20,55,60,75,54,35,239,
  140,194,26,17,25,176,252,235,210,0,225,33,210,115,237,145,180,176,214,136,11,126,39,241,187,20,145,40,142,96,198,139,
  10,90,146,148,222,18,116,179,114,141,137,231,234,93,251,33,192,36,55,108,62,152,228,87,36,218,28,186,99,151,51,101,
  213,247,232,145,148,215,231,161,142,4,164,169,244,249,149,183,231,129,194,145,86,71,194,50,118,204,2,96,220,24,204,164,
  215,157,234,207,164,240,224,216,85,15,57,13,237,140,229,164,76,43,19,129,220,243,111,4,205,202,248,227,23,0,240,8,
  252,80,14,121,130,56,202,223,91,227,36,205,180,53,93,161,169,57,20,121,133,221,221,89,200,98,149,129,225,115,51,214,
  63,207,184,228,189,115,78,108,9,16,15,234,124,78,173,172,57,65,166,213,25,125,90,8,136,129,119,145,60,110,12,114,
  156,53,151,156,244,29,178,7,54,82,78,59,201,86,191,68,189,4,164,95,128,164,94,10,56,233,23,135,149,83,160,24,
  222,5,82,167,179,98,25,122,246,96,194,161,236,167,48,171,98,194,238,164,211,7,99,9,91,236,241,142,147,248,26,43,
  193,73,137,91,145,166,135,97,183,180,186,251,213,184,85,41,228,131,226,175,201,218,122,58,225,124,226,66,226,204,171,51,
  12,63,227,209,132,91,11,128,111,145,139,195,226,193,131,191,190,86,91,181,54,199,25,29,93,89,201,110,60,3,139,42,
  227,246,15,86,103,222,166,85,176,101,105,147,56,175,126,134,105,113,144,75,53,190,113,99,174,30,2,203,5,71,37,69,
  149,69,110,88,112,73,214,85,229,49,210,23,12,252,145,13,223,205,85,23,229,105,49,115,174,215,156,65,110,77,149,103,
  236,177,42,49,108,148,150,35,39,5,211,7,138,122,101,229,251,184,212,236,169,32,135,27,211,137,40,230,114,207,68,51,
  131,200,11,5,211,211,246,93,90,203,236,212,242,235,241,230,195,138,232,197,158,218,238,180,100,85,165,192,23,38,125,35,
  223,128,255,223,23,246,97,149,168,60,209,209,98,213,138,75,181,191,6,225,111,67,20,87,53,123,209,150,29,224,224,54,
  109,147,32,87,106,214,69,68,142,229,144,102,163,112,191,186,93,75,210,146,190,183,164,150,170,160,11,253,91,214,90,120,
  11,138,58,173,16,97,245,246,162,19,137,205,183,245,18,44,17,164,140,159,228,85,153,188,89,115,72,170,39,143,245,150,
  187,80,236,210,223,98,107,246,170,157,59,126,143,89,95,168,240,124,116,201,86,86,88,7,159,20,189,214,23,137,232,70,
  205,251,130,255,175,77,170,35,120,217,170,191,11,145,66,180,100,203,241,57,9,109,141,93,3,184,46,71,15,18,167,165,
  198,171,95,117,123,198,33,234,54,227,37,88,87,82,249,14,180,62,85,90,236,224,57,182,241,211,223,77,46,207,66,132,
  59,139,141,211,172,29,48,253,102,13,113,55,202,34,148,35,183,36,181,130,222,124,105,210,99,18,74,102,188,226,180,61,
  37,182,49,98,215,114,116,247,251,116,170,239,200,72,90,170,86,106,61,232,7,150,206,78,54,49,247,9,134,64,173,74,
  106,140,31,99,167,112,131,158,190,46,102,84,19,234,237,15,81,250,239,55,247,242,149,147,199,135,70,148,5,12,186,235,
  15,69,77,168,215,134,200,39,250,187,142,169,56,45,66,121,135,112,206,233,250,152,41,67,218,135,234,105,107,113,0,239,
  11,17,110,174,70,11,13,186,197,216,27,49,25,83,76,249,110,91,76,31,123,75,208,166,42,144,194,221,140,71,120,149,
  152,57,143,80,150,64,11,11,8,32,74,81,2,252,58,129,89,162,24,233,76,74,33,24,235,70,22,65,116,183,148,105,
  37,213,58,169,29,202,60,242,151,247,35,245,141,42,146,237,236,202,200,134,251,215,211,54,81,77,172,104,163,78,92,210,
  104,209,84,163,10,170,188,18,236,219,50,10,120,215,21,225,176,118,137,65,228,243,238,155,217,210,204,30,119,237,166,10,
  179,141,225,218,53,153,43,197,43,122,223,154,38,81,69,46,101,173,194,94,179,99,160,7,134,18,29,220,2,57,158,3,
  106,10,159,94,9,230,53,130,229,22,250,84,100,36,43,130,253,140,11,119,208,2,57,133,17,202,243,64,125,30,92,48,
  25,118,113,35,33,85,117,90,166,230,218,133,81,241,124,147,106,208,148,83,55,97,229,167,204,32,119,108,110,165,149,55,
  123,215,13,196,50,22,223,37,64,240,131,193,125,219,108,0,245,150,241,160,184,209,2,5,65,18,105,239,109,253,39,144,
  201,106,247,221,118,33,222,86,246,88,203,177,240,19,76,95,121,1,169,135,89,60,138,228,211,106,4,73,177,149,53,205,
  43,9,171,53,103,203,199,125,7,27,193,50,198,52,2,20,214,105,177,79,169,174,166,143,100,172,18,141,199,137,159,0,
  99,105,223,154,143,156,214,128,250,49,45,193,161,172,76,92,110,177,133,154,17,52,103,193,73,8,172,116,84,182,186,54,
  169,246,221,68,186,85,123,54,100,111,247,67,65,168,109,190,77,86,109,208,245,114,83,192,239,53,215,111,220,108,245,54,
  7,14,96,127,43,158,39,146,51,41,235,70,122,38,39,112,71,68,83,205,250,161,147,227,151,211,119,27,108,78,192,6,
  212,21,199,249,112,96,113,227,129,148,132,108,130,236,1,78,235,246,41,242,0,40,94,86,19,200,36,204,184,94,220,154,
  11,19,185,186,225,71,176,175,11,1,171,131,88,238,81,237,49,157,219,77,155,0,159,87,60,116,121,196,178,87,110,67,
  65,130,10,9,136,207,62,119,137,184,106,238,121,207,58,94,119,179,168,128,82,53,134,31,199,151,187,80,104,96,251,126,
  157,207,0,244,10,74,238,15,153,254,64,252,196,124,167,246,49,220,78,226,141,53,252,48,166,168,99,33,114,36,232,243,
  248,235,25,96,9,153,180,107,161,37,63,170,251,194,219,141,179,224,208,231,47,193,27,143,28,52,200,122,12,120,113,12,
  123,90,193,181,134,87,95,105,171,164,115,204,214,175,111,58,200,117,202,227,69,183,248,186,165,160,134,216,225,167,131,23,
  33,87,61,103,24,55,245,246,200,44,37,203,116,199,188,233,27,187,12,96,172,19,230,157,170,235,189,54,39,5,45,3,
  154,10,40,0,2,4,92,126,54,49,246,19,249,194,132,103,208,17,158,131,18,8,38,207,96,188,97,186,76,32,175,115,
  237,55,57,241,111,158,75,87,241,32,98,239,226,4,65,243,52,233,167,34,216,179,4,12,118,181,247,166,122,241,120,138,
  83,115,189,243,208,82,28,88,142,75,31,235,31,203,21,122,214,3,67,89,45,76,245,160,190,103,78,23,76,33,24,27,
  28,213,100,56,162,130,153,196,184,143,221,132,2,116,53,254,252,132,251,53,58,169,21,181,220,222,89,72,201,206,192,185,
  240,217,180,234,22,188,26,41,37,180,171,124,191,66,185,147,127,45,20,39,75,211,90,242,240,185,91,72,63,160,80,0,
  142,82,115,152,80,224,148,22,237,185,160,61,236,217,151,226,18,154,22,219,56,163,10,48,183,65,224,76,131,104,163,76,
  130,90,221,92,215,220,97,183,138,78,210,238,164,14,166,3,231,72,83,14,43,74,173,157,67,117,98,152,152,182,59,60,
  31,11,79,159,47,61,12,28,24,207,235,193,74,73,246,234,66,143,186,33,117,171,9,28,182,209,104,176,5,51,13,227,
  117,199,17,125,35,14,125,10,71,103,73,15,111,93,227,240,159,38,36,97,2,25,5,121,36,249,196,162,94,122,40,175,
  55,55,245,237,47,132,31,38,119,32,197,152,77,186,51,209,114,118,69,56,143,120,2,238,247,59,6,185,30,49,234,53,
  226,214,211,143,49,107,20,79,212,52,237,102,198,113,173,59,212,238,135,236,253,195,27,118,190,173,18,144,124,83,42,187,
  202,150,249,202,186,203,24,75,124,183,19,165,161,83,52,108,124,79,177,163,38,96,85,34,163,33,104,1,36,253,208,88,
  13,47,79,136,26,76,105,101,37,36,185,250,112,180,92,149,107,10,215,59,43,148,60,239,40,221,236,148,195,13,241,242,
  120,91,24,146,170,162,176,68,27,53,82,129,166,250,162,135,243,225,203,122,221,7,4,192,128,196,236,78,52,182,120,51,
  165,144,182,240,110,163,223,228,21,254,35,29,254,196,209,41,4,68,62,128,55,235,159,13,189,135,72,39,64,108,132,137,
  212,110,120,223,216,112,250,239,20,11,80,157,74,220,126,73,205,50,155,108,63,50,231,183,97,145,195,38,49,15,19,251,
  179,219,179,116,125,94,219,121,36,22,216,230,116,57,159,155,29,137,251,194,42,207,191,227,192,178,94,40,3,184,190,245,
  31,125,251,113,192,127,63,192,139,141,237,120,172,238,35,211,53,237,191,220,20,65,108,35,77,121,210,230,30,194,103,210,
  85,105,223,254,247,232,134,80,53,82,12,113,187,2,112,42,66,231,207,88,18,166,150,165,111,135,99,152,199,219,21,4,
  232,6,193,24,218,222,116,66,127,183,0,46,55,187,137,198,233,193,187,158,250,130,143,191,46,181,229,183,224,160,27,211,
  24,136,25,131,223,231,63,170,180,103,169,250,17,23,233,202,202,184,139,114,175,130,199,182,18,69,44,54,44,205,107,212,
  19,193,199,23,68,32,22,228,72,49,113,177,242,144,132,33,54,241,100,160,49,174,145,129,121,34,42,118,204,173,25,162,
  237,5,206,242,50,98,72,30,223,163,7,134,157,0,241,106,149,129,167,202,120,130,174,26,41,30,12,104,153,121,111,64,
  179,93,119,81,49,25,66,125,35,202,196,110,250,30,195,15,157,88,209,91,56,159,242,100,46,102,87,144,173,95,61,105,
  235,61,21,97,36,202,0,171,195,64,99,94,148,165,22,136,41,228,179,224,62,39,69,5,206,192,134,204,194,240,69,50,
  201,93,219,249,224,40,22,9,23,52,34,183,76,89,57,71,38,158,129,111,106,225,142,195,151,156,130,27,198,26,18,123,
  118,232,21,210,145,198,216,98,67,31,216,66,79,158,153,91,129,20,168,49,244,187,207,177,6,65,137,16,34,138,245,187,
  136,203,52,233,189,160,10,100,98,70,196,172,229,39,40,20,180,98,221,199,195,23,219,226,140,18,21,212,29,224,199,29,
  143,64,253,26,77,59,62,128,167,86,86,7,192,68,63,86,122,16,31,111,75,87,218,148,12,237,115,164,47,85,209,28,
  84,93,73,243,96,139,132,8,36,64,237,57,188,164,174,23,64,236,69,80,58,24,71,164,115,19,231,248,42,218,129,193,
  177,38,13,39,154,225,253,61,219,31,13,15,180,85,99,67,140,240,169,216,70,48,75,29,197,220,28,156,0,81,155,135,
  28,182,9,155,73,243,156,106,101,8,251,120,1,140,115,219,213,120,144,110,207,105,80,218,112,205,13,170,232,94,107,87,
  48,154,8,87,131,162,11,247,170,241,166,167,164,159,105,108,94,196,236,203,188,35,83,57,226,153,50,20,197,30,71,186,
  175,196,242,219,67,210,242,8,199,128,68,86,40,232,238,124,250,112,1,53,225,31,78,138,125,78,156,145,205,252,130,63,
  213,8,195,67,65,77,81,187,141,32,86,80,29,109,141,49,228,244,120,80,206,165,38,209,63,236,74,36,30,152,184,160,
  185,12,236,229,225,224,235,67,165,119,146,102,16,180,30,85,92,183,125,147,9,227,165,126,22,29,160,177,124,168,245,101,
  6,165,247,222,38,245,47,58,33,103,252,111,201,140,216,76,236,192,101,21,185,196,250,229,133,153,115,189,49,61,55,47,
  65,122,132,208,156,40,58,137,45,119,203,222,75,157,191,54,138,175,106,97,183,131,43,17,71,197,77,227,117,200,151,56,
  190,48,142,245,171,63,25,81,243,120,79,219,88,150,169,176,192,146,151,215,187,144,0,221,16,180,191,81,202,40,49,30,
  1,189,9,87,26,200,27,56,158,154,92,32,181,93,189,10,54,109,132,17,6,49,167,214,25,46,246,0,212,223,149,69,
  185,41,163,167,66,133,162,75,204,201,162,249,238,35,211,82,215,163,200,153,85,219,131,79,135,178,94,151,253,237,68,184,
  38,229,223,0,142,96,202,92,14,0,228,215,235,61,210,188,236,36,121,153,37,91,29,170,19,215,140,60,185,223,18,205,
  2,206,167,191,216,186,246,255,74,149,195,90,242,166,222,102,163,222,237,224,148,187,27,56,138,111,155,18,57,178,229,192,
  149,85,241,90,44,191,24,122,242,14,251,127,102,110,207,58,30,70,55,198,62,140,6,5,37,167,209,182,60,24,76,135,
  53,154,105,168,180,7,32,8,115,39,230,53,49,219,240,240,154,46,206,122,47,27,57,25,107,255,51,171,229,16,9,133,
  12,7,89,8,23,224,162,205,148,243,179,54,221,32,132,12,16,202,113,250,18,88,118,72,219,70,94,122,121,148,118,93,
  76,75,125,34,58,8,101,155,5,155,73,49,214,237,43,78,74,159,93,63,26,225,50,225,119,136,135,156,158,9,178,125,
  187,48,221,156,77,78,63,10,216,37,27,66,53,254,25,58,93,185,145,59,170,58,246,37,250,68,116,96,124,217,243,219,
  79,175,104,16,90,96,6,167,169,174,51,82,142,11,212,175,220,80,205,71,108,175,49,134,7,49,60,176,32,71,74,192,
  87,179,25,30,139,34,229,199,78,228,115,228,106,177,116,45,239,173,121,51,33,180,231,93,42,145,226,162,186,115,0,63,
  254,56,110,16,30,126,245,84,99,233,66,125,90,126,73,239,220,148,210,93,154,30,228,169,161,45,34,62,163,162,124,255,
  139,21,76,145,247,83,121,218,62,7,121,189,102,219,116,95,225,117,248,6,100,27,134,35,129,78,117,217,35,121,217,194,
  207,130,75,49,135,128,170,48,143,90,152,39,204,30,123,94,170,145,9,219,144,141,187,166,77,20,137,44,22,249,197,148,
  141,98,206,34,48,6,44,172,47,68,55,18,57,80,15,243,189,98,201,192,36,89,96,61,167,8,108,173,191,3,237,180,
  188,203,78,132,84,60,203,222,252,36,167,215,77,9,166,246,253,192,241,168,115,198,214,117,247,94,54,92,9,228,56,92,
  218,22,212,141,117,148,72,244,103,34,234,249,242,216,101,197,172,212,186,192,77,174,200,223,87,74,69,123,184,175,250,250,
  232,98,226,96,201,207,167,53,217,212,16,235,111,107,247,137,12,151,213,101,23,7,231,114,214,158,135,47,221,76,199,130,
  43,196,152,78,199,59,25,73,33,15,32,165,179,3,154,80,36,46,2,254,243,233,96,189,10,246,241,131,97,66,105,64,
  220,200,134,143,139,97,173,110,224,190,246,127,35,52,115,222,225,58,186,21,150,3,13,137,131,172,126,123,181,223,20,129,
  15,71,178,27,98,115,56,79,140,148,247,148,2,240,195,144,62,4,169,207,200,233,230,104,166,174,188,153,171,214,78,248,
  218,110,26,161,138,101,146,21,65,40,16,192,53,79,148,191,235,214,83,68,67,63,253,255,51,12,80,229,209,58,59,92,
  142,219,223,200,44,216,243,244,192,159,101,121,248,176,80,79,142,99,168,29,49,132,192,153,179,229,91,191,34,227,16,234,
  61,32,98,122,225,224,45,86,179,188,238,207,216,134,98,22,100,60,218,228,207,234,43,47,117,182,97,76,154,138,137,164,
  246,1,144,246,74,191,227,250,177,220,168,235,95,171,163,154,20,62,150,153,242,82,196,166,12,49,237,235,51,48,195,185,
  90,117,252,12,227,195,0,122,27,5,96,198,51,200,130,252,254,199,214,99,220,74,88,189,56,10,250,41,16,20,96,48,
  57,38,112,91,23,68,245,249,180,230,196,198,217,114,52,11,138,45,231,139,29,13,210,34,5,23,205,248,141,104,83,1,
  127,16,252,198,253,63,11,178,43,38,174,189,83,120,156,253,24,88,162,196,230,129,94,77,174,109,92,41,225,80,124,235,
  75,253,221,10,35,208,69,135,38,70,92,245,103,113,92,152,63,23,136,42,71,7,129,250,73,25,99,174,33,198,62,177,
  234,200,246,168,164,134,26,60,145,27,182,135,177,10,103,165,76,248,230,158,122,219,70,194,148,152,167,141,220,184,91,174,
  23,126,65,75,46,20,167,141,7,65,67,63,153,24,231,68,91,194,188,43,201,119,186,155,195,138,186,36,92,210,13,183,
  112,154,136,83,191,252,45,207,201,125,168,130,117,195,152,252,48,234,226,176,223,66,184,234,129,189,93,168,215,73,11,9,
  145,134,154,19,115,12,146,31,129,217,94,230,207,212,73,140,81,207,209,224,77,143,59,41,187,163,85,140,46,71,229,186,
  60,127,179,89,213,158,192,254,185,79,111,38,218,167,149,103,124,86,208,169,53,193,2,217,70,138,243,145,70,225,127,151,
  219,43,49,99,36,238,84,32,176,159,111,75,34,113,86,11,73,142,245,215,180,200,240,88,219,28,193,80,109,19,50,152,
  98,46,180,206,178,232,143,248,138,162,158,255,128,135,235,179,8,81,63,245,35,114,127,111,131,146,14,254,90,245,91,111,
  11,179,218,204,57,103,36,186,62,170,103,234,182,92,228,137,176,213,38,64,55,41,61,221,231,13,57,28,246,107,147,89,
  116,190,18,100,169,4,154,41,123,6,185,61,172,25,251,156,255,215,193,162,173,191,49,231,205,21,114,14,139,174,100,149,
  235,12,19,226,58,79,150,240,118,132,139,96,152,175,126,179,162,65,107,162,86,78,92,192,133,62,218,237,96,24,133,94,
  93,229,134,244,137,206,232,121,115,188,162,40,110,137,123,0,253,87,208,196,252,185,104,97,171,3,73,117,251,156,15,55,
  118,203,169,159,207,178,94,183,134,152,75,116,150,53,64,212,72,99,31,3,91,119,122,123,5,36,186,181,151,184,206,35,
  229,255,182,189,211,146,69,175,235,62,126,81,220,98,66,150,248,80,230,104,134,155,168,41,93,248,204,68,64,209,14,218,
  190,1,190,216,169,136,40,105,129,153,67,0,164,25,204,69,150,131,244,79,161,255,175,182,8,20,225,4,198,162,73,227,
  45,203,143,38,185,238,141,192,240,247,76,81,6,121,191,104,219,202,63,240,61,20,77,119,61,20,151,204,196,42,51,23,
  56,228,250,142,47,164,111,77,82,39,149,219,22,127,99,168,134,135,107,215,229,66,35,51,162,113,65,135,163,82,212,222,
  126,129,212,28,186,73,116,159,148,213,252,136,160,34,129,254,96,85,202,81,147,111,240,138,93,124,250,87,253,183,124,135,
  123,97,88,160,124,141,25,206,162,104,124,56,187,168,234,120,8,157,166,77,19,112,2,31,100,125,150,201,46,205,51,221,
  194,42,175,153,141,90,146,175,10,127,241,125,33,44,253,164,129,243,79,253,62,102,60,226,184,45,21,229,253,130,159,211,
  154,116,220,42,43,111,168,88,166,31,165,96,62,175,87,205,80,67,96,157,248,174,228,36,44,27,22,163,153,126,161,173,
  147,115,174,154,31,118,153,238,190,181,111,194,189,92,9,120,224,143,72,206,175,178,242,170,205,59,62,210,76,48,25,102,
  103,53,163,180,252,70,36,98,172,123,208,97,20,176,233,251,190,144,129,49,162,29,113,201,12,224,81,165,110,100,200,151,
  76,97,194,57,23,177,214,153,186,201,209,14,219,92,75,117,107,24,82,139,178,106,251,42,112,61,94,63,134,120,197,236,
  127,131,149,78,21,112,45,160,158,164,113,124,178,218,196,238,170,194,128,107,252,184,216,123,138,44,13,95,191,33,127,238,
  198,123,166,96,151,29,66,97,71,163,150,27,128,73,135,68,122,26,21,134,57,32,59,28,93,63,12,100,58,81,221,95,
  141,202,198,133,108,241,180,231,209,134,187,57,8,119,185,40,194,204,234,7,195,124,184,220,31,70,125,112,234,176,68,119,
  177,103,136,204,99,99,31,189,203,0,192,124,166,146,24,61,104,72,9,252,195,29,210,131,45,41,179,102,44,22,196,117,
  131,3,50,5,31,103,144,102,181,202,152,8,0,139,94,96,168,197,14,95,190,15,44,29,130,143,84,24,157,181,135,84,
  126,100,48,5,177,189,181,134,228,184,221,236,54,33,63,69,215,116,177,14,89,9,69,13,74,147,229,152,184,40,10,138,
  185,183,54,169,22,156,82,15,50,27,87,88,55,37,137,129,3,38,75,43,105,191,44,102,231,26,189,114,57,103,179,165,
  206,74,68,149,44,184,229,48,225,104,142,94,79,201,231,233,170,178,75,199,27,101,111,219,89,238,137,168,93,57,75,108,
  122,72,149,43,84,54,131,53,140,33,191,156,11,237,64,18,226,51,73,66,145,83,144,171,63,190,121,110,97,251,77,195,
  4,100,0,174,36,84,126,205,6,182,110,208,168,115,251,91,89,225,223,212,89,246,156,212,97,144,184,196,229,227,106,111,
  60,19,123,158,254,123,201,182,67,203,176,79,20,48,179,47,211,91,226,49,110,194,116,31,76,24,76,56,98,95,132,146,
  123,245,95,138,68,49,123,25,2,178,246,115,168,205,196,2,29,197,115,125,222,57,94,218,246,135,156,114,106,66,23,48,
  139,211,174,83,170,21,34,67,52,94,183,92,25,156,67,211,255,246,144,34,12,118,69,182,47,78,5,89,110,90,57,82,
  6,95,21,82,50,253,249,14,218,201,72,236,131,246,240,72,235,86,72,174,236,231,180,126,113,177,43,239,163,242,54,69,
  161,40,167,224,192,238,27,230,4,140,236,106,255,192,5,220,199,8,29,31,113,82,236,27,232,32,146,168,133,91,147,22,
  54,105,171,88,159,121,15,8,169,45,47,1,12,120,253,212,192,143,20,174,235,228,194,198,206,200,80,137,115,94,223,249,
  213,45,165,254,222,157,90,171,57,0,163,135,185,28,8,72,118,231,135,212,232,137,127,174,43,153,96,247,66,156,8,54,
  208,69,67,189,127,83,163,39,58,17,94,243,45,108,69,11,1,154,113,220,207,93,100,106,230,207,38,148,179,226,110,90,
  6,146,103,189,197,156,138,115,204,150,57,174,56,251,24,164,102,40,5,56,19,222,89,195,69,16,127,58,198,235,129,34,
  255,111,128,146,77,127,83,33,97,105,97,253,167,189,210,80,37,153,127,56,101,161,139,124,191,69,191,201,206,178,248,55,
  246,96,49,198,99,126,40,113,123,28,87,253,40,230,131,146,179,114,223,226,54,81,54,170,155,166,244,23,110,23,78,147,
  32,209,79,77,236,255,88,98,55,234,25,2,60,84,139,91,208,20,65,113,188,135,252,148,56,159,122,26,125,223,241,161,
  229,34,14,70,135,192,23,200,73,48,59,197,10,147,73,121,78,234,65,59,230,186,100,162,228,231,194,204,84,132,27,143,
  89,181,214,189,195,69,115,207,4,92,63,95,219,198,14,230,140,249,208,181,242,237,109,179,81,38,190,146,11,27,67,143,
  80,142,31,151,4,243,91,6,154,150,140,7,185,48,227,95,159,185,202,195,197,78,218,21,235,102,38,160,112,71,158,180,
  118,71,225,52,27,174,220,134,61,58,126,92,215,147,132,219,214,20,243,61,67,181,63,173,42,65,23,86,195,136,73,13,
  245,198,117,32,63,185,18,210,41,79,151,126,166,64,239,160,175,59,53,35,171,132,43,162,194,8,166,110,86,139,192,73,
  191,144,74,106,90,254,214,98,133,97,148,239,40,140,22,71,29,57,37,61,142,65,231,189,140,58,3,187,126,120,104,210,
  214,8,94,48,113,180,144,189,76,35,50,73,163,185,35,92,238,205,113,187,194,240,35,218,57,157,3,59,45,228,116,34,
  46,235,1,14,160,188,203,229,67,206,99,204,32,74,49,156,106,188,182,209,77,68,193,179,192,58,209,174,148,190,96,125,
  141,51,142,97,234,239,86,42,17,0,251,17,57,138,82,90,110,230,91,115,55,100,251,16,65,17,34,136,59,230,161,144,
  184,35,203,13,150,9,41,242,158,180,63,237,216,245,202,188,228,172,203,128,66,205,195,29,240,172,101,125,250,219,249,214,
  105,227,150,248,254,157,130,53,203,229,125,171,81,199,142,177,158,32,151,190,205,134,70,133,176,125,52,78,40,247,185,145,
  141,238,59,204,63,130,70,204,193,117,187,173,151,46,244,223,139,148,12,144,152,152,4,113,193,230,247,223,4,240,167,58,
  94,253,153,83,237,233,159,50,227,200,97,82,93,197,99,23,156,139,136,42,197,39,48,13,101,206,182,119,111,247,38,129,
  47,249,255,92,84,246,34,19,176,28,59,159,230,195,25,170,71,103,1,205,145,234,43,206,202,34,224,187,31,219,202,36,
  69,163,143,177,9,113,40,96,237,125,27,229,181,154,25,32,80,115,154,242,5,17,184,213,117,106,215,126,162,18,25,101,
  155,128,162,217,114,41,238,136,92,50,214,75,206,208,57,52,158,34,90,73,228,84,196,226,173,4,121,74,22,77,23,168,
  52,78,211,60,149,153,85,165,52,46,106,214,121,8,53,239,67,58,153,78,230,204,134,98,170,12,39,156,85,1,207,213,
  47,190,146,59,229,97,227,218,9,26,138,100,150,149,202,45,157,242,112,116,118,199,222,53,105,108,251,188,49,67,252,111,
  215,208,98,23,87,176,114,69,155,253,170,142,182,194,191,140,93,189,46,27,120,170,60,76,64,73,37,52,246,2,255,219,
  116,194,253,253,214,55,50,46,95,128,186,59,130,52,210,189,6,100,129,25,78,105,136,66,181,247,29,109,186,16,149,245,
  188,113,100,118,73,37,167,155,200,79,205,13,97,168,97,56,170,160,220,150,172,174,160,238,0,127,185,249,166,241,176,69,
  136,5,155,70,40,5,203,167,27,5,54,142,84,230,219,171,233,121,27,52,121,137,102,241,25,21,141,21,4,137,54,155,
  125,82,202,114,192,126,1,41,159,56,142,168,116,15,204,30,39,122,38,187,156,101,165,18,116,80,254,254,226,43,199,144,
  73,100,76,48,145,148,217,37,138,242,60,136,176,55,114,200,57,15,94,147,79,198,162,48,152,96,222,68,182,46,150,189,
  37,220,137,184,159,172,212,98,173,232,18,108,171,168,6,24,178,151,18,220,123,47,95,181,66,78,150,187,195,244,125,111,
  210,59,136,56,131,194,173,79,172,107,240,77,165,12,105,34,185,237,90,201,54,8,59,200,98,59,226,81,225,108,87,125,
  154,86,0,202,28,136,157,59,184,170,30,239,245,24,50,212,62,59,174,96,187,46,250,156,242,249,98,136,137,100,18,176,
  63,0,188,145,247,105,128,26,70,64,53,233,178,25,99,83,73,186,113,226,93,243,190,60,200,132,233,134,170,101,8,188,
  38,248,226,14,221,106,52,100,251,69,153,97,252,86,85,0,159,239,26,145,199,3,19,78,152,86,66,252,52,245,121,147,
  75,212,58,199,195,172,101,111,197,242,183,39,15,156,130,53,119,179,123,127,29,20,241,94,245,1,175,247,22,205,57,156,
  139,220,147,107,0,70,113,34,162,121,65,78,26,132,133,1,56,174,81,199,238,82,169,86,232,149,52,13,191,129,103,140,
  200,98,77,141,40,193,127,224,221,179,156,131,229,15,217,52,10,16,152,219,84,105,106,2,33,28,175,126,45,102,178,21,
  163,167,158,37,203,249,85,67,27,107,38,86,76,243,244,217,158,14,155,145,90,2,255,133,51,81,188,122,126,217,34,72,
  226,168,9,54,105,162,183,56,133,48,178,196,44,173,134,233,240,100,34,66,174,61,175,119,160,80,155,112,245,207,62,169,
  33,37,221,102,137,187,225,78,11,198,53,170,225,173,61,11,58,218,154,40,168,236,168,76,69,24,200,58,254,119,175,162,
  243,175,54,159,204,234,18,181,62,193,21,28,178,202,31,213,156,237,156,42,13,198,182,210,185,177,143,66,121,207,29,179,
  198,131,44,41,248,228,232,145,239,14,236,0,109,121,5,50,137,45,248,40,173,225,147,65,241,70,10,50,171,225,176,11,
  74,99,51,109,127,134,230,219,151,236,80,167,132,239,239,143,73,67,102,110,153,82,8,253,248,35,8,5,60,189,219,212,
  53,158,58,218,183,89,155,56,84,137,147,217,119,58,251,137,226,128,157,109,43,225,171,29,103,8,89,15,55,214,240,94,
  83,231,255,71,93,71,81,95,42,50,47,141,89,163,175,40,185,248,208,246,82,166,166,221,243,157,184,160,92,34,88,75,
  73,150,100,50,22,216,144,93,68,124,244,234,216,57,252,239,67,11,34,1,122,102,108,149,106,53,141,80,42,159,22,108,
  246,179,18,198,43,194,33,221,242,167,251,222,98,75,48,218,0,41,112,62,111,115,3,44,8,222,161,18,123,154,39,232,
  74,236,242,43,217,225,47,53,61,179,153,32,103,171,59,27,14,72,173,187,66,97,42,242,59,82,254,24,12,11,78,172,
  210,137,254,233,159,55,80,213,66,253,117,146,170,98,196,200,20,235,140,244,157,162,93,73,185,185,201,250,17,32,244,246,
  158,245,56,112,206,104,91,83,33,206,44,218,254,133,133,199,225,215,232,47,250,199,217,57,233,36,141,196,67,37,191,9,
  75,243,213,250,171,25,10,118,232,184,224,84,23,7,12,209,191,220,171,147,62,66,131,24,239,222,33,79,227,54,233,212,
  199,193,90,10,251,249,8,245,114,46,18,245,223,196,135,128,124,150,187,189,131,58,203,128,20,112,166,228,190,51,253,3,
  183,50,231,137,116,12,155,252,240,165,110,42,186,203,197,80,65,184,36,205,181,126,223,143,214,178,142,134,223,22,75,20,
  136,39,160,120,159,5,115,242,28,64,78,216,184,8,126,71,185,38,117,120,122,177,147,103,115,35,166,165,1,127,140,177,
  221,107,208,69,87,210,67,60,247,214,6,88,66,31,170,85,78,7,168,236,206,139,203,57,30,253,135,102,106,221,80,5,
  243,185,193,142,250,9,217,124,193,28,152,49,222,58,11,134,154,21,188,111,253,113,137,233,185,12,35,251,225,84,177,91,
  157,243,130,20,174,8,16,153,225,114,129,178,19,187,35,245,11,155,105,190,63,231,61,209,11,36,144,37,11,180,93,205,
  140,194,145,168,188,80,176,100,99,24,153,206,86,81,207,171,9,121,35,170,177,233,48,201,254,251,30,123,138,62,115,56,
  56,85,243,183,155,157,181,92,206,219,201,54,88,140,255,120,30,185,234,123,254,247,50,99,138,136,32,174,181,175,130,89,
  149,254,106,93,247,98,4,155,240,237,41,25,109,177,57,93,79,57,238,225,242,106,8,128,207,98,181,181,233,150,108,34,
  91,61,94,33,195,96,1,135,32,5,192,235,119,240,73,218,27,171,161,98,132,154,14,125,57,96,72,143,158,162,140,140,
  126,180,37,86,92,144,155,184,75,34,75,12,172,160,255,135,68,119,73,71,179,160,104,147,11,252,13,83,250,62,243,20,
  230,14,217,9,12,174,239,140,186,116,66,27,189,25,215,30,231,235,96,72,160,47,223,55,21,205,221,202,53,180,160,134,
  148,13,106,51,196,142,88,246,241,24,211,255,200,253,32,116,83,41,81,202,162,9,46,162,24,57,254,11,20,138,133,118,
  51,88,178,115,55,20,34,17,167,204,40,11,157,33,90,43,181,160,122,70,52,93,207,110,24,219,215,85,6,224,120,204,
  127,124,80,183,155,220,153,194,61,165,150,16,224,167,57,194,241,111,77,188,93,241,111,145,65,65,3,60,208,162,234,125,
  252,208,33,154,139,188,0,83,228,190,190,51,139,255,62,3,17,213,120,62,84,94,178,172,101,200,205,90,70,107,151,239,
  188,126,210,61,234,21,97,34,74,117,37,100,224,232,93,151,167,38,199,155,2,204,44,24,158,3,63,6,177,101,33,63,
  160,27,248,204,156,212,85,95,79,196,140,228,211,62,207,249,13,225,136,88,89,150,48,232,101,208,231,204,198,96,51,207,
  249,110,25,190,134,48,59,51,201,127,220,112,103,184,188,171,150,190,223,12,188,58,57,72,144,0,199,1,147,27,186,221,
  96,159,44,48,84,220,40,22,97,158,62,31,248,113,143,81,104,104,63,71,2,20,25,130,194,208,58,43,95,213,15,181,
  181,246,220,248,66,215,216,90,136,195,119,188,152,194,202,133,225,149,236,204,14,28,0,96,228,142,131,18,214,62,113,216,
  35,220,222,82,185,54,167,243,152,204,242,41,168,57,236,195,227,76,32,184,108,220,79,92,177,223,77,183,225,14,149,141,
  63,139,104,26,72,191,80,117,51,79,81,56,233,69,37,215,62,117,169,97,249,76,33,89,157,130,20,178,191,25,27,247,
  209,66,214,133,99,37,223,174,133,51,0,79,34,54,3,43,84,241,164,51,127,120,177,105,34,2,102,134,206,16,14,31,
  101,93,48,199,34,211,204,241,248,250,59,130,38,168,77,181,149,253,125,151,51,196,39,3,109,187,238,229,122,122,138,91,
  76,141,219,150,65,213,54,63,56,116,223,199,200,48,204,175,99,98,186,199,69,95,229,43,101,28,186,36,212,244,60,142,
  60,120,79,187,238,34,181,64,196,217,158,198,2,30,83,159,30,237,175,159,178,200,71,29,88,221,0,64,23,217,105,252,
  141,97,123,131,91,129,138,98,215,58,139,247,208,76,164,76,3,239,39,87,157,184,147,36,166,165,55,191,168,79,84,221,
  217,66,203,198,64,92,101,0,191,47,150,109,134,166,31,197,205,140,179,11,76,25,116,142,55,55,37,240,31,110,23,118,
  127,32,122,173,149,147,192,102,2,12,235,255,130,81,118,80,208,30,124,187,222,226,172,136,229,67,211,247,68,105,218,111,
  14,248,84,113,39,66,13,195,35,64,229,28,162,4,220,185,55,66,208,53,22,153,74,156,42,146,215,93,199,207,47,192,
  172,194,172,68,167,218,255,184,182,92,143,246,71,52,85,154,192,125,172,67,236,153,32,72,82,255,138,176,45,96,95,31,
  191,28,186,54,155,108,13,101,157,42,185,237,164,97,26,247,106,205,206,135,123,78,134,255,210,213,190,159,166,76,177,81,
  116,149,194,157,13,73,32,174,211,187,193,180,80,174,19,142,174,137,239,219,229,146,37,45,123,226,243,211,72,134,225,80,
  245,177,46,196,85,252,213,251,172,92,52,53,204,254,1,43,23,219,62,58,178,238,205,193,53,253,170,136,250,73,139,46,
  138,187,33,226,13,80,152,143,38,237,27,48,164,131,228,25,74,179,55,57,183,204,108,137,236,27,144,150,57,179,203,190,
  159,62,219,7,31,191,17,63,241,117,188,231,171,56,132,11,90,9,190,145,85,64,16,74,130,207,148,218,37,135,147,216,
  20,72,62,47,150,101,24,220,192,41,202,170,31,38,209,137,109,198,88,60,174,179,84,152,199,225,13,67,77,116,81,125,
  99,25,58,199,175,50,142,252,209,245,82,2,207,73,100,231,92,163,187,220,5,234,30,101,28,125,98,148,194,185,92,174,
  197,186,59,54,201,146,59,237,81,188,150,52,64,179,66,147,98,207,22,9,66,172,15,226,227,212,218,122,172,34,75,242,
  198,61,202,1,178,66,219,19,151,85,95,109,37,36,134,40,45,45,178,33,113,90,47,13,34,84,242,252,116,157,59,213,
  238,76,134,53,236,233,34,38,153,12,186,2,224,237,102,140,199,245,48,87,154,29,74,55,86,34,157,39,201,206,55,71,
  193,162,108,123,33,242,78,47,42,161,238,102,51,181,188,48,89,38,231,83,206,187,139,196,144,17,229,127,249,46,236,22,
  81,110,231,84,192,69,175,253,6,255,69,105,219,183,68,166,110,128,254,88,158,131,39,149,147,190,231,4,243,159,248,141,
  120,119,232,237,219,91,164,229,29,99,243,180,128,196,15,90,153,203,181,193,239,163,107,3,109,43,61,63,159,237,237,199,
  251,254,65,118,28,151,50,52,176,117,50,147,50,168,170,37,36,186,155,220,32,183,252,98,1,185,10,128,214,39,171,226,
  138,185,233,98,34,229,233,97,189,235,6,200,107,246,188,123,122,212,35,143,173,255,153,125,95,182,237,225,178,247,74,199,
  169,149,47,230,200,135,54,241,186,28,31,57,81,14,159,111,171,217,41,117,188,68,134,241,71,8,121,168,100,41,41,189,
  51,48,18,179,50,168,195,96,43,92,105,115,36,254,85,18,133,172,182,173,219,212,3,159,109,221,204,140,228,37,171,93,
  181,241,128,43,243,186,200,167,8,204,140,50,19,108,40,30,186,0,102,168,103,172,207,147,111,147,145,0,145,53,156,157,
  254,209,60,147,83,241,139,106,220,68,242,116,171,40,139,113,171,237,185,1,74,79,248,94,239,187,27,143,116,231,126,209,
  17,50,219,111,201,181,51,94,6,217,160,92,132,130,89,53,99,177,9,6,204,218,167,104,5,106,117,54,65,61,124,159,
  217,125,232,99,124,94,207,66,182,224,169,223,176,45,108,111,44,139,237,21,253,98,176,229,81,194,166,21,36,109,104,120,
  93,184,181,160,133,197,206,198,124,187,194,168,58,210,73,30,14,105,78,186,71,126,248,116,11,163,23,212,133,79,245,131,
  14,109,235,144,80,134,237,50,240,183,179,32,142,7,206,175,229,85,159,26,93,248,74,72,22,198,162,251,221,80,217,200,
  46,157,127,83,113,229,254,18,145,47,33,177,100,81,81,253,29,90,229,211,180,125,233,229,142,172,148,136,217,88,101,180,
  20,56,158,178,249,142,109,129,164,117,168,82,31,115,75,198,176,189,175,55,89,110,247,136,167,8,28,218,254,138,86,53,
  12,52,104,55,241,123,148,233,54,153,66,54,144,188,17,66,43,166,54,161,97,1,96,49,200,94,168,116,140,224,116,126,
  254,81,225,55,254,108,244,33,233,154,65,166,135,30,210,153,151,7,49,229,86,15,53,186,65,168,225,178,148,146,93,236,
  40,3,177,16,142,226,247,168,211,71,138,97,128,206,129,24,44,134,64,73,164,49,108,76,121,164,192,168,227,137,173,236,
  156,167,155,32,123,129,203,65,109,104,183,111,102,153,22,237,81,42,11,131,53,52,150,196,8,109,201,158,164,240,194,114,
  142,1,34,242,212,157,200,55,41,164,6,195,125,157,22,16,104,80,91,123,98,13,7,145,19,222,159,33,65,127,248,75,
  84,76,208,119,185,201,90,191,101,142,33,78,143,1,101,93,64,195,15,42,19,144,125,224,155,67,176,69,232,125,197,19,
  33,144,35,132,90,255,31,67,91,107,102,246,194,85,90,245,207,198,1,13,183,192,33,59,88,46,102,151,115,57,51,84,
  174,25,133,102,234,6,117,172,84,114,173,79,152,239,146,244,229,238,202,63,95,247,45,99,55,56,217,211,222,62,90,168,
  134,208,144,125,89,165,106,82,225,225,160,193,50,166,194,94,184,233,233,214,35,27,104,227,62,44,87,25,174,243,206,34,
  171,230,235,201,150,77,254,153,108,119,134,52,35,69,244,212,92,254,174,34,154,231,244,147,195,109,69,142,16,55,225,158,
  60,127,37,144,156,233,150,78,102,103,130,66,253,146,87,67,243,190,227,252,42,223,143,141,133,176,154,128,98,159,211,54,
  169,107,40,171,124,53,2,247,179,23,216,20,81,59,224,10,20,25,14,229,145,92,92,155,35,143,74,120,144,28,76,196,
  25,61,125,29,36,196,142,120,26,211,192,246,47,46,155,219,71,217,247,70,106,17,113,25,200,1,143,228,141,221,241,79,
  103,94,5,152,154,107,32,62,99,92,236,184,139,202,145,23,158,144,67,250,86,95,215,10,57,100,35,89,48,248,71,2,
  152,50,116,66,165,63,104,33,234,172,142,9,174,81,129,227,247,138,211,187,211,53,229,95,243,174,211,145,187,211,107,223,
  53,247,117,251,45,232,74,114,170,39,121,4,237,1,67,59,178,4,171,1,105,86,245,38,74,121,234,219,200,166,155,218,
  54,247,112,229,204,154,123,37,82,124,87,46,215,250,96,204,112,175,3,152,96,165,56,28,5,75,20,42,139,142,31,44,
  234,254,69,170,158,37,224,107,117,48,74,225,55,42,32,134,76,176,0,37,161,56,118,140,61,158,132,107,254,225,209,94,
  233,170,212,196,0,80,233,180,90,2,76,33,202,24,241,212,48,112,186,165,214,30,56,38,234,12,164,41,85,78,65,47,
  236,75,40,177,182,55,23,195,114,90,37,196,94,20,200,120,176,15,246,92,249,249,77,112,61,160,87,60,97,174,93,75,
  173,240,148,190,137,138,43,124,177,139,184,9,239,233,18,24,93,22,85,34,166,62,214,94,214,120,254,35,157,118,242,114,
  62,59,226,80,154,107,173,219,189,118,137,89,130,159,203,190,83,199,191,182,197,162,84,97,28,151,80,124,181,15,99,241,
  200,94,112,8,183,182,66,172,47,134,197,222,174,46,13,223,184,21,102,198,103,113,207,43,189,104,113,152,229,238,179,55,
  109,46,190,205,108,40,193,248,9,254,240,204,36,163,208,46,75,105,247,103,201,163,24,34,114,23,84,98,230,150,209,238,
  7,168,102,195,112,87,204,140,113,213,212,98,16,203,239,228,115,173,169,2,251,143,106,215,186,113,220,116,195,27,205,235,
  131,53,53,127,115,242,7,145,108,251,85,79,241,73,169,36,134,188,78,77,38,114,163,4,131,157,227,227,232,152,201,36,
  7,16,24,248,192,232,230,59,5,194,183,162,3,99,211,125,244,20,68,166,94,138,178,36,221,127,131,187,126,160,221,36,
  199,56,249,14,140,52,86,111,85,95,58,9,133,32,23,184,31,156,238,76,240,42,77,164,154,114,45,157,80,117,22,244,
  144,215,8,72,0,243,63,186,165,11,135,18,219,110,61,221,240,91,165,64,207,85,66,96,58,71,104,158,61,21,178,92,
  180,117,175,188,159,241,52,240,240,149,248,240,180,144,109,45,174,211,161,119,63,17,239,24,238,235,153,37,97,55,42,224,
  187,27,148,113,37,137,225,143,26,128,204,133,18,95,59,63,110,176,226,46,42,101,101,197,154,67,151,117,247,248,16,151,
  129,26,210,0,48,47,204,59,104,89,46,136,12,80,49,43,212,47,36,239,125,246,32,154,46,164,51,212,77,26,125,187,
  142,153,10,23,15,230,39,143,96,68,164,133,55,113,175,86,20,14,228,125,129,25,48,4,200,175,20,89,46,191,219,45,
  103,181,227,37,110,0,65,238,165,7,219,4,245,99,112,195,122,238,187,81,9,203,137,200,113,210,53,245,215,3,197,94,
  146,14,14,120,212,6,53,219,125,112,37,150,57,223,136,230,161,44,97,164,88,125,185,133,223,252,58,137,19,26,179,15,
  2,55,113,85,57,45,157,102,225,49,66,6,19,34,209,42,207,255,185,138,164,53,214,36,86,114,41,152,197,6,113,78,
  218,72,125,136,246,214,252,95,236,33,77,143,111,142,126,161,149,173,241,163,154,20,45,83,225,205,86,200,226,161,89,252,
  205,11,202,212,98,144,17,242,21,34,40,232,233,67,54,80,91,197,70,238,147,243,81,222,191,200,43,71,163,190,229,13,
  11,158,102,104,208,27,252,37,216,37,59,119,190,167,216,196,224,38,140,158,9,0,55,119,231,127,106,201,109,141,209,25,
  195,57,61,62,196,189,233,26,135,207,141,132,217,42,153,41,151,70,239,185,103,108,22,147,45,61,62,197,178,120,164,206,
  40,112,43,30,4,21,1,245,183,83,149,243,43,125,157,141,168,179,173,99,184,85,246,4,184,14,138,110,87,221,79,172,
  40,213,225,59,79,56,93,61,150,110,56,11,228,159,52,167,114,73,52,97,111,80,241,31,49,141,43,166,238,83,44,164,
  86,112,63,133,15,245,248,15,107,2,159,166,241,72,18,236,190,96,174,10,150,32,78,47,14,76,60,56,145,8,26,181,
  68,16,169,242,35,102,95,100,10,181,39,25,236,246,0,79,35,82,105,5,225,235,26,210,93,112,241,228,216,77,113,25,
  230,25,187,169,239,2,97,207,178,83,45,34,237,216,55,128,12,100,226,8,83,200,212,215,157,233,132,165,219,69,42,81,
  119,242,50,6,145,194,87,252,245,153,32,174,133,146,163,187,51,20,193,149,99,193,24,151,41,119,115,239,15,62,43,243,
  219,171,189,33,135,199,80,118,194,249,9,33,39,10,12,12,34,223,202,60,229,61,222,31,7,147,193,250,221,243,23,0,
  4,24,42,87,84,237,47,176,44,97,110,11,147,237,208,13,177,180,187,146,98,135,88,175,84,254,30,1,169,205,127,230,
  35,165,6,69,36,84,98,46,16,253,186,14,242,252,61,83,180,156,162,38,149,200,199,240,11,176,177,180,8,170,120,56,
  178,53,43,161,131,68,189,189,135,57,43,251,12,136,225,159,196,86,73,88,198,98,32,163,93,80,65,8,211,188,156,195,
  244,230,12,200,245,239,164,232,173,171,202,4,75,92,17,231,233,212,197,246,197,226,10,60,125,30,202,250,186,59,244,117,
  167,55,223,8,186,144,87,238,15,246,16,33,34,122,142,144,165,137,71,251,176,181,108,123,228,129,64,160,211,93,11,4,
  152,84,40,133,187,240,195,46,16,119,225,73,45,12,53,230,187,114,199,202,92,214,91,216,200,178,221,179,10,187,177,42,
  137,210,205,223,29,174,97,85,33,189,111,223,43,172,10,2,252,149,187,35,102,121,67,198,110,59,196,225,232,157,136,138,
  134,139,54,198,112,247,179,234,188,253,191,9,225,83,170,100,220,222,218,14,96,113,189,23,143,113,188,55,254,146,167,188,
  2,151,175,133,146,134,127,248,192,125,250,124,152,109,236,179,142,37,174,204,166,167,127,110,132,184,149,19,32,212,225,238,
  181,108,181,127,48,39,103,167,185,142,48,18,239,207,140,156,168,133,87,33,79,57,171,147,34,31,204,79,143,184,10,222,
  143,231,48,64,196,117,12,98,166,245,235,153,9,171,254,122,182,23,32,174,68,117,78,211,101,131,142,165,219,244,94,230,
  249,89,20,104,55,202,82,167,136,150,23,156,64,178,46,138,71,179,149,7,97,213,198,103,115,234,128,238,85,104,35,47,
  96,73,178,68,85,52,123,237,128,48,171,130,101,132,52,117,123,167,90,232,49,231,132,68,105,130,17,201,32,123,115,72,
  44,67,196,63,210,120,3,15,1,226,171,105,108,58,223,99,163,217,195,187,59,91,163,26,214,191,180,42,69,40,80,242,
  96,26,31,115,80,144,98,136,169,70,169,159,14,82,53,212,5,228,153,40,196,44,188,158,8,174,11,37,17,86,230,41,
  85,214,146,116,250,240,144,60,221,182,253,98,214,244,142,136,4,217,152,135,175,42,158,49,63,200,128,199,99,21,138,91,
  17,169,81,88,126,131,253,196,245,36,109,50,16,73,100,111,237,128,56,63,52,91,121,37,86,119,118,128,210,30,107,97,
  29,89,247,61,192,198,179,139,84,181,27,100,223,103,88,226,73,164,153,68,8,201,183,61,184,188,251,81,88,200,111,7,
  190,54,144,228,51,229,85,111,153,19,6,143,189,237,254,53,117,253,237,81,162,193,19,185,246,78,19,0,131,210,54,176,
  52,157,54,123,98,148,186,37,40,111,29,123,182,97,247,158,51,97,244,57,27,190,45,111,67,185,139,39,11,194,121,208,
  33,95,81,59,51,5,88,107,137,14,188,66,93,32,29,13,68,77,246,33,148,188,180,128,248,119,62,113,23,235,30,233,
  87,169,129,117,24,119,30,247,3,82,55,98,115,132,195,33,100,102,101,108,226,95,72,2,226,211,200,88,27,210,217,188,
  157,123,61,107,127,130,240,40,111,248,133,30,60,0,15,131,163,211,85,70,11,147,41,29,1,25,46,111,238,110,161,205,
  147,119,5,153,131,46,178,155,92,76,29,209,37,44,192,172,83,28,172,23,75,55,176,247,133,205,54,158,239,23,239,70,
  103,181,219,128,150,46,35,76,1,127,188,49,187,32,193,7,96,177,168,217,129,75,60,210,151,148,183,168,197,70,48,149,
  46,53,65,71,108,143,146,31,73,140,158,158,179,177,30,171,61,5,179,255,39,197,152,157,72,175,46,173,85,87,85,16,
  104,50,114,233,33,82,19,181,225,29,219,125,125,186,153,166,47,216,144,197,247,39,171,196,69,63,188,168,21,236,95,55,
  0,25,125,208,166,233,148,3,85,163,112,17,211,158,167,23,119,250,226,100,181,171,244,189,0,243,56,190,183,87,75,96,
  47,37,106,99,150,220,242,107,16,146,162,27,72,27,104,247,105,27,141,186,110,248,42,241,71,56,67,15,17,250,48,59,
  18,103,208,246,197,248,229,112,124,99,233,148,220,197,204,195,63,187,134,151,96,38,183,14,168,152,97,18,108,247,48,205,
  83,37,202,61,214,216,62,61,7,69,129,17,1,50,80,183,186,120,162,25,135,32,131,234,143,10,97,199,170,170,38,254,
  242,47,21,109,211,104,213,141,243,56,146,129,229,223,194,58,94,55,249,106,164,105,172,109,82,197,33,53,9,128,254,97,
  167,254,93,227,195,16,156,124,107,7,38,97,30,121,199,75,90,140,223,207,55,186,165,169,52,147,250,46,105,203,230,72,
  20,22,195,93,18,38,66,154,203,143,37,93,112,200,64,157,129,55,248,84,127,33,91,96,184,212,77,194,194,13,74,217,
  208,153,129,95,22,77,214,166,133,219,79,238,69,31,231,20,38,20,124,223,4,68,24,192,82,225,65,116,248,189,230,101,
  145,47,41,223,255,176,17,129,160,149,33,17,251,149,200,235,31,78,138,170,175,140,134,174,35,31,145,44,24,54,255,181,
  88,41,43,246,61,173,119,207,235,38,214,69,189,93,248,69,40,237,226,125,1,131,27,37,228,97,62,211,187,201,166,105,
  109,68,224,55,155,46,202,78,225,231,15,164,252,202,16,206,255,166,47,227,250,167,25,249,10,18,255,131,7,75,54,81,
  106,181,54,178,98,230,249,168,60,152,173,14,79,88,33,252,200,89,45,51,157,209,68,38,58,217,156,67,85,128,19,238,
  26,225,246,65,197,139,86,179,40,212,121,163,184,197,100,127,114,43,109,25,169,157,119,166,57,26,28,101,117,71,133,176,
  192,166,130,109,240,18,192,13,237,193,64,187,179,164,106,166,241,92,153,102,148,235,80,130,144,50,93,183,132,21,12,171,
  137,9,7,167,98,166,214,106,40,174,249,246,198,166,81,247,218,231,156,231,67,198,109,212,211,212,106,12,99,164,172,216,
  67,94,30,155,206,249,227,232,88,220,123,170,97,197,50,140,221,159,231,212,60,144,105,221,66,125,232,194,36,173,139,221,
  187,21,176,123,80,224,48,126,212,190,186,122,58,78,71,91,198,95,127,82,168,93,0,190,15,98,159,78,255,199,77,162,
  86,17,223,250,241,25,119,112,199,15,213,43,231,117,28,24,11,166,110,186,13,246,16,45,96,223,136,82,85,81,44,255,
  208,36,40,56,217,202,62,130,146,44,155,161,118,204,122,249,218,117,101,73,228,51,138,87,28,218,204,186,178,124,87,211,
  44,228,53,169,143,16,19,66,123,177,232,95,204,78,202,86,72,23,45,127,71,188,151,46,75,100,141,214,180,43,253,4,
  205,145,17,97,53,229,206,188,234,29,203,111,63,59,115,174,45,36,27,229,22,115,153,101,101,196,189,86,138,225,219,18,
  200,253,22,47,196,251,241,31,60,86,51,169,161,24,242,170,59,75,75,40,78,175,202,208,109,34,43,215,59,210,184,237,
  27,50,197,80,154,177,221,150,202,236,16,131,30,114,235,224,238,186,115,195,8,198,242,98,232,172,225,229,227,107,172,141,
  97,35,231,29,81,14,37,191,109,101,103,243,6,24,124,134,52,155,0,252,64,233,210,111,90,100,21,116,12,80,3,3,
  153,231,109,211,41,91,255,244,114,67,156,223,105,154,134,241,78,26,39,49,26,142,221,66,69,114,41,80,176,208,196,136,
  226,148,98,175,200,151,20,161,97,40,217,65,202,151,24,19,253,158,229,56,228,214,74,140,214,11,15,64,110,250,119,67,
  247,49,69,89,250,4,183,147,103,212,167,33,112,14,52,97,49,151,217,90,69,133,82,119,50,127,226,131,161,77,185,9,
  159,224,118,255,29,93,32,46,101,246,147,188,227,234,147,135,21,29,69,76,23,212,29,117,83,118,99,8,254,20,238,150,
  89,146,65,231,60,228,53,173,117,0,30,104,43,159,24,25,170,238,247,48,43,229,240,59,254,10,58,227,49,164,49,183,
  57,59,79,217,251,110,170,31,86,160,132,90,140,242,46,225,110,170,158,39,83,246,217,31,142,211,108,95,209,125,207,188,
  92,73,112,180,54,29,5,11,231,166,67,49,252,229,137,101,242,188,100,169,234,239,9,145,60,35,36,149,124,74,252,62,
  169,26,73,66,188,45,67,170,115,80,33,190,84,108,246,173,242,175,161,20,254,230,181,189,119,46,243,177,132,43,228,195,
  71,255,78,64,78,95,48,39,53,8,249,199,91,144,201,110,190,151,135,195,133,140,193,170,32,254,206,137,15,115,247,163,
  220,174,165,196,243,85,21,58,128,80,16,197,74,117,37,229,3,136,206,140,105,206,193,245,235,58,51,251,79,245,176,202,
  163,244,187,208,254,22,51,102,86,75,239,179,25,9,3,195,162,35,255,104,179,57,92,169,74,43,137,70,143,191,145,101,
  247,199,94,200,189,3,10,82,128,246,168,90,25,194,244,49,38,135,228,95,26,34,220,183,227,191,141,231,170,161,161,56,
  96,235,204,69,134,145,113,124,134,225,171,241,119,68,34,179,144,172,227,214,209,151,251,219,35,241,169,42,40,29,245,138,
  234,226,70,26,35,222,48,124,226,113,150,209,149,103,38,2,253,48,103,218,54,106,155,45,130,2,238,205,49,197,77,136,
  154,174,193,40,38,27,183,230,134,81,234,28,57,139,246,41,188,24,110,90,205,46,111,188,37,213,95,220,43,59,32,5,
  43,43,126,211,157,34,255,214,108,47,194,27,239,125,250,182,97,145,44,19,35,30,104,58,48,172,38,197,174,154,57,92,
  94,125,113,137,237,121,230,189,56,52,130,83,128,51,182,139,94,76,20,235,50,205,105,144,194,72,20,215,77,156,200,247,
  210,241,50,93,24,97,33,130,218,227,117,138,185,120,164,157,138,23,147,192,177,7,233,6,226,6,32,191,145,206,153,62,
  195,232,172,64,138,6,74,57,76,54,214,62,212,117,235,205,97,76,225,47,87,96,175,34,92,50,53,82,103,128,139,68,
  69,112,240,46,92,3,71,215,127,90,179,217,247,64,57,142,190,45,121,149,187,188,236,249,62,139,35,100,13,242,51,151,
  66,215,129,45,229,168,103,181,225,67,31,103,23,159,30,171,20,119,127,204,202,115,188,54,242,244,158,25,102,103,209,122,
  178,106,53,110,197,96,32,16,117,97,238,110,54,130,111,67,92,30,122,220,213,175,59,210,244,195,18,70,46,95,77,116,
  200,32,72,34,144,209,126,122,181,219,51,195,22,139,86,157,220,80,128,234,135,10,19,71,252,231,124,71,194,175,0,91,
  245,252,216,24,63,93,141,29,96,108,128,188,33,136,125,161,23,230,111,234,11,107,105,229,254,160,47,194,117,231,15,243,
  140,19,172,53,243,87,185,79,210,129,21,82,236,96,23,8,137,135,8,143,127,150,116,65,217,143,136,98,0,88,57,228,
  97,145,128,11,192,194,186,67,219,133,15,244,22,24,227,198,193,173,128,136,48,222,242,133,26,211,118,6,130,178,226,123,
  169,31,163,253,65,40,31,102,143,83,64,59,99,65,154,144,172,108,106,246,70,115,88,73,148,26,54,241,172,65,83,242,
  213,160,179,164,244,224,194,81,107,10,26,65,83,143,193,242,100,50,164,165,173,227,167,192,66,17,84,206,235,84,223,22,
  229,118,58,150,105,120,55,243,234,5,228,250,212,12,87,107,160,162,133,14,23,163,171,226,177,151,160,166,11,73,233,187,
  67,68,240,86,221,70,37,131,54,202,173,114,22,229,132,208,177,159,89,68,255,205,44,231,138,232,161,150,216,255,61,170,
  221,39,113,249,18,169,22,56,108,247,238,51,199,80,218,101,254,220,95,193,34,82,229,60,225,91,120,226,181,138,152,142,
  70,12,251,22,51,44,104,167,152,175,201,58,20,246,12,16,98,42,78,9,236,248,138,225,133,231,116,154,125,89,177,222,
  47,111,172,79,170,49,231,233,77,28,22,55,124,165,116,253,154,132,49,164,27,207,109,1,160,103,126,4,57,17,81,191,
  26,57,245,107,228,126,234,155,214,145,116,13,171,138,94,67,226,79,171,79,189,157,32,105,71,125,96,54,178,246,24,91,
  132,144,22,7,55,9,131,180,58,25,98,185,72,173,130,113,232,173,21,53,233,78,215,208,27,191,243,201,244,97,164,13,
  31,227,96,15,233,35,191,106,57,195,53,128,52,89,111,52,142,128,75,41,251,230,253,164,217,207,241,15,44,143,98,143,
  205,141,202,24,221,168,21,93,231,170,117,29,244,6,75,124,70,105,74,176,132,172,205,168,137,148,208,2,237,146,129,98,
  203,99,172,199,6,105,5,188,44,1,250,6,59,229,23,170,46,244,36,143,149,179,131,232,109,224,160,237,161,136,46,254,
  181,137,58,253,53,53,205,90,118,113,20,127,75,247,144,220,97,252,63,242,189,136,18,20,38,34,143,218,0,41,232,208,
  219,113,152,76,66,213,236,108,255,0,151,46,212,162,77,177,45,39,78,0,63,226,50,247,171,51,172,202,233,113,235,94,
  215,15,68,54,240,116,173,106,1,100,205,176,168,117,120,106,63,137,169,136,127,186,87,30,154,243,121,86,61,212,177,90,
  194,153,215,223,235,151,136,131,178,181,118,56,99,115,226,34,89,138,106,162,223,21,151,222,151,246,45,254,204,3,121,36,
  222,119,156,21,124,10,184,244,86,97,168,224,188,121,84,212,239,105,26,76,253,167,17,103,19,26,9,29,159,198,39,98,
  40,254,77,152,225,86,78,94,128,85,45,83,139,34,201,20,113,156,239,144,185,181,157,4,95,172,39,177,209,233,85,254,
  19,205,53,239,33,183,192,60,217,72,198,83,51,72,97,250,225,114,196,165,14,13,96,107,18,161,78,84,14,58,9,1,
  166,200,228,76,145,113,119,159,18,96,74,200,246,197,219,187,53,192,105,107,96,187,243,92,245,31,13,60,87,247,213,101,
  39,152,94,127,56,48,228,81,245,231,147,237,108,157,73,0,46,206,122,247,12,101,153,216,67,136,128,151,92,199,40,38,
  122,225,148,124,190,152,108,135,5,195,209,42,140,134,27,62,53,82,124,251,252,153,91,199,133,94,43,185,204,32,145,186,
  134,207,5,160,180,60,247,215,150,159,191,99,168,26,19,70,10,235,203,192,122,18,139,163,204,186,218,100,229,157,67,137,
  198,25,1,44,236,117,109,59,214,87,62,250,29,123,144,214,249,110,160,224,17,118,56,67,52,164,190,113,230,39,29,11,
  129,187,183,156,115,95,197,207,158,251,189,48,209,77,200,244,145,38,25,12,236,202,100,99,114,247,198,65,186,37,195,17,
  233,220,229,9,20,226,130,47,250,69,104,128,162,80,10,123,128,181,96,75,209,162,137,238,156,34,99,131,89,106,10,155,
  31,173,63,227,146,53,127,206,100,175,9,207,30,126,199,76,133,175,227,122,215,124,188,43,141,28,50,227,165,99,140,60,
  129,34,59,253,56,179,232,250,0,242,216,134,144,177,25,41,133,128,221,78,190,34,100,169,57,54,254,116,122,84,171,13,
  39,75,121,176,189,71,27,250,100,45,94,40,143,192,198,157,125,152,201,196,62,105,230,76,173,22,26,187,23,31,167,237,
  187,66,195,175,211,69,174,9,67,46,222,217,169,162,50,160,254,239,213,156,121,216,85,0,136,153,159,135,58,47,143,125,
  147,232,130,71,11,245,225,116,244,157,42,186,72,170,240,255,33,148,148,194,8,51,20,204,86,47,190,140,173,188,46,141,
  101,123,95,5,173,200,194,238,225,237,2,13,41,203,112,38,95,155,52,238,225,223,169,2,131,193,215,129,245,108,90,134,
  215,177,210,227,84,25,1,186,79,100,253,156,216,57,125,184,123,165,33,161,19,49,240,129,31,46,74,89,6,33,34,22,
  240,116,61,105,94,235,21,215,16,113,156,121,140,190,145,101,61,18,183,208,209,13,121,253,198,217,127,185,9,48,21,167,
  117,9,20,55,78,240,43,70,143,96,21,4,214,99,249,227,188,20,80,67,88,86,27,5,233,129,248,144,59,88,116,26,
  82,154,209,70,129,70,24,19,31,133,33,106,207,85,184,210,23,52,7,244,152,89,40,134,57,234,78,242,244,77,28,174,
  171,65,59,205,111,163,199,82,166,220,141,117,109,141,0,67,67,28,70,57,79,143,3,114,97,28,208,200,157,163,124,175,
  3,103,189,138,139,170,169,123,226,85,140,158,88,160,45,235,203,50,47,60,127,211,145,0,117,104,198,190,178,158,209,232,
  234,134,104,128,26,107,91,186,38,1,16,23,113,38,13,18,236,23,154,62,227,64,97,145,35,22,151,39,212,111,210,103,
  17,130,74,20,225,113,9,210,170,209,216,76,155,132,179,106,162,57,149,74,146,174,171,136,36,202,86,31,132,121,63,204,
  188,159,39,1,195,27,234,118,167,171,177,97,240,13,119,135,233,103,85,201,141,171,190,139,195,88,81,230,191,152,84,45,
  234,182,185,204,114,157,247,201,210,75,40,227,3,213,58,5,149,121,142,188,134,182,102,99,239,11,35,243,176,59,152,1,
  67,228,239,205,89,39,32,173,98,204,225,209,172,152,72,115,9,32,30,139,81,56,228,108,44,211,46,35,135,15,160,122,
  195,1,80,224,58,116,138,152,49,238,235,55,203,107,154,55,152,13,123,120,29,33,196,46,173,126,243,205,82,176,174,144,
  148,42,42,110,216,103,13,229,59,129,153,241,106,32,112,210,41,240,97,185,216,251,228,103,86,223,214,201,66,38,161,171,
  175,233,98,104,124,162,30,194,120,1,68,0,118,224,62,125,9,133,243,71,43,1,176,159,47,236,150,165,1,144,250,165,
  167,234,36,35,171,98,196,24,20,171,198,136,96,86,242,71,222,155,240,2,251,220,3,139,189,83,127,125,221,152,209,72,
  68,87,26,80,137,79,155,77,197,205,7,85,94,11,103,0,89,129,56,178,170,248,89,89,194,85,13,164,49,252,17,182,
  10,233,212,173,148,233,215,108,50,9,145,118,250,171,254,73,168,130,104,83,186,104,214,65,156,99,171,96,107,67,47,140,
  173,185,13,248,80,16,181,23,182,4,138,241,200,99,237,89,129,31,191,103,180,227,23,110,244,60,90,110,86,45,242,196,
  197,130,99,229,110,128,215,105,232,117,243,237,148,21,200,2,211,244,214,162,18,102,51,85,96,15,57,88,197,71,245,140,
  187,227,108,131,15,57,166,165,212,130,240,167,15,97,229,211,117,157,143,249,4,149,34,20,39,66,105,243,60,142,206,198,
  116,118,208,119,156,158,120,117,41,232,123,182,125,244,141,4,40,246,33,142,236,205,116,122,159,41,95,93,126,169,79,181,
  156,113,96,97,46,201,161,148,111,242,250,231,198,17,94,43,68,228,87,112,168,137,58,128,127,192,210,102,96,232,69,189,
  236,216,64,209,182,247,249,204,150,94,203,12,170,0,172,244,246,69,169,68,86,99,149,219,48,41,146,179,127,56,142,145,
  213,131,239,18,236,87,23,14,206,112,61,199,4,29,0,33,25,176,106,185,3,198,201,0,50,39,191,32,82,59,247,145,
  8,195,147,183,26,150,9,246,199,191,235,25,216,85,54,212,115,179,11,235,107,135,224,42,251,192,216,35,96,116,140,216,
  129,198,193,27,252,77,209,5,117,179,86,195,20,74,180,46,8,236,202,3,132,26,239,68,78,172,195,57,128,181,0,221,
  199,109,20,61,5,84,124,207,242,27,185,230,152,135,16,21,184,73,211,112,90,162,199,34,177,206,81,178,29,118,238,87,
  180,37,169,183,231,14,27,176,27,153,194,246,55,236,79,44,56,147,219,148,205,206,146,245,254,33,176,206,146,192,195,147,
  57,180,77,221,217,239,176,123,77,153,59,194,225,200,159,7,197,230,80,33,61,137,211,52,102,214,143,22,185,32,90,189,
  228,52,238,150,231,79,254,152,23,137,177,72,56,145,13,215,172,202,7,18,36,7,114,64,66,41,149,52,156,231,223,166,
  154,105,36,45,237,128,30,114,147,11,34,181,43,5,63,20,194,147,172,46,65,170,75,93,118,172,120,17,42,184,32,76,
  93,142,195,141,177,230,145,178,100,113,212,154,63,201,147,34,29,66,192,84,246,140,197,85,251,93,240,198,184,73,100,6,
  210,19,103,163,63,56,52,53,252,45,0,143,119,161,169,240,248,245,1,56,200,84,74,234,101,72,80,216,131,69,186,48,
  83,195,121,145,127,189,222,224,62,116,178,51,144,211,144,23,177,251,203,12,187,216,173,149,131,78,117,132,201,127,56,157,
  245,63,77,250,143,80,28,231,253,210,177,42,150,189,30,189,139,79,199,79,168,81,69,45,204,75,152,67,68,184,229,146,
  14,100,35,145,98,228,35,4,44,94,219,161,187,47,171,174,103,91,50,141,90,129,169,119,173,151,236,171,141,193,71,187,
  253,89,212,212,129,49,146,50,205,161,226,51,35,210,196,10,71,85,120,65,57,217,235,161,220,71,228,229,251,120,42,232,
  154,74,58,84,81,246,229,119,81,121,245,241,100,12,186,186,119,54,151,245,5,78,127,179,159,15,160,95,81,12,4,152,
  25,28,15,59,199,55,36,132,72,206,193,50,234,18,241,204,45,213,210,246,136,219,143,52,211,152,111,13,140,162,80,161,
  54,254,85,138,184,8,187,88,61,24,89,85,46,213,203,157,9,39,95,48,114,252,188,78,114,144,20,114,22,79,253,243,
  157,223,76,17,178,226,91,100,251,58,64,10,221,216,202,150,38,99,83,4,94,203,122,171,241,137,178,25,129,87,120,196,
  40,20,15,216,223,64,38,147,96,24,128,24,74,242,130,76,205,233,237,4,44,222,10,151,158,27,84,56,81,148,44,183,
  114,216,241,12,157,118,42,107,122,32,171,194,32,125,204,132,156,181,82,106,20,153,179,158,205,159,35,118,92,54,232,115,
  255,86,175,36,104,24,208,166,207,181,149,136,104,191,53,252,240,40,201,22,79,52,56,160,169,94,100,47,235,10,114,218,
  229,245,108,12,13,159,95,179,5,62,255,147,219,201,242,42,173,73,217,42,25,82,55,0,233,120,152,46,93,212,209,205,
  250,182,77,34,14,99,149,182,165,224,246,80,15,135,209,217,103,123,61,24,25,167,221,15,46,233,49,80,66,33,157,195,
  187,41,73,114,98,50,103,156,253,213,22,81,43,22,26,134,141,151,237,11,55,173,173,25,211,71,29,204,195,126,127,77,
  196,195,215,170,87,204,7,46,186,134,12,173,102,109,201,161,125,103,217,153,2,162,159,55,187,17,117,29,64,172,30,124,
  88,225,60,236,192,205,72,207,170,29,49,24,83,44,146,17,53,5,78,81,7,42,57,97,99,207,11,72,186,100,173,20,
  48,129,14,121,75,219,21,196,240,159,64,89,228,110,44,153,55,130,210,244,198,165,4,191,203,112,143,213,84,242,43,156,
  125,0,8,239,158,242,122,179,195,3,25,23,225,15,235,80,96,234,180,204,157,222,219,50,91,107,175,195,199,192,20,167,
  60,153,148,51,108,115,31,181,101,74,203,144,114,241,80,124,121,248,175,179,101,109,129,230,25,168,202,162,73,41,24,68,
  146,61,56,101,177,206,239,149,32,80,176,108,71,49,23,133,229,79,38,175,215,205,55,32,165,187,15,240,255,167,67,7,
  41,65,152,172,99,251,252,237,43,150,37,127,93,165,175,31,69,142,16,221,74,112,3,88,116,182,231,209,131,238,172,125,
  246,71,122,4,156,231,64,168,3,56,95,182,93,53,87,167,75,169,185,238,206,232,149,72,7,171,87,11,49,92,110,61,
  253,19,250,132,12,202,147,239,180,193,200,2,216,162,182,18,200,118,140,139,84,135,227,117,255,201,203,132,36,28,103,174,
  248,57,35,157,164,78,10,212,148,48,62,244,235,123,61,83,202,132,124,249,150,162,59,28,63,238,77,51,252,26,155,181,
  167,255,237,0,131,93,79,5,16,17,30,189,69,87,230,254,27,13,107,137,202,46,240,173,137,181,19,213,81,237,253,0,
  198,33,127,239,129,16,220,239,3,9,245,240,223,32,211,27,249,254,136,226,166,243,216,195,252,244,150,13,5,97,113,155,
  182,253,178,10,152,134,159,167,169,66,32,79,126,255,72,222,252,199,188,53,66,106,141,124,82,193,190,189,171,129,19,120,
  130,148,84,242,138,13,237,170,24,42,239,249,159,101,154,94,164,6,90,112,117,0,21,70,211,143,244,108,191,49,154,245,
  109,135,209,67,236,160,3,134,149,155,85,236,58,148,236,210,101,221,254,14,157,85,149,150,243,3,21,20,34,126,207,166,
  193,144,66,54,217,75,101,223,173,225,231,222,205,227,125,27,42,37,4,60,150,11,162,183,89,104,13,182,44,16,42,30,
  252,18,59,180,66,158,63,150,49,142,21,53,228,199,249,167,241,239,12,206,108,93,112,61,201,73,209,82,139,33,86,123,
  39,129,119,253,96,117,14,104,37,189,10,233,230,30,59,253,166,125,70,244,166,128,95,118,62,239,56,102,9,211,180,53,
  66,176,209,112,86,175,188,238,199,200,16,249,162,156,172,181,81,67,40,27,1,229,154,211,22,238,162,25,203,1,195,223,
  94,255,14,97,41,232,250,190,220,3,118,50,95,27,79,238,117,163,114,247,87,243,117,8,250,162,244,130,223,205,57,52,
  176,201,26,198,33,3,235,69,31,193,248,171,133,16,165,209,210,201,60,58,223,80,49,130,245,239,126,251,89,66,116,107,
  207,238,28,83,216,172,182,166,229,227,217,143,52,85,172,208,54,230,143,149,81,233,37,28,10,101,122,200,184,242,183,44,
  40,91,23,79,73,97,10,202,143,225,148,44,33,43,147,188,167,62,223,11,223,193,203,30,2,57,137,220,106,22,97,88,
  241,214,129,47,157,178,87,225,49,134,51,3,170,45,78,186,137,14,31,186,11,16,67,238,155,77,89,101,223,49,170,136,
  167,115,252,7,108,135,23,196,8,202,18,85,123,43,153,186,244,239,48,126,124,243,7,7,59,71,93,39,99,26,183,245,
  25,214,201,66,229,64,139,227,203,84,246,10,209,150,11,105,173,99,24,241,141,119,1,152,108,1,31,197,247,254,171,226,
  222,74,206,176,166,169,158,183,103,255,192,107,66,111,17,160,111,137,65,70,125,208,245,40,27,172,1,248,207,129,95,44,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,73,73,42,0,8,0,0,0,16,0,254,0,4,0,1,0,0,0,0,0,0,0,0,1,3,0,
  1,0,0,0,94,0,0,0,1,1,3,0,1,0,0,0,88,0,0,0,2,1,3,0,3,0,0,0,206,0,0,0,
  3,1,3,0,1,0,0,0,5,0,0,0,6,1,3,0,1,0,0,0,2,0,0,0,17,1,4,0,4,0,0,0,
  212,0,0,0,21,1,3,0,1,0,0,0,3,0,0,0,22,1,3,0,1,0,0,0,29,0,0,0,23,1,4,0,
  4,0,0,0,228,0,0,0,26,1,5,0,1,0,0,0,244,0,0,0,27,1,5,0,1,0,0,0,252,0,0,0,
  28,1,3,0,1,0,0,0,1,0,0,0,40,1,3,0,1,0,0,0,3,0,0,0,61,1,3,0,1,0,0,0,
  2,0,0,0,73,134,1,0,0,1,0,0,4,1,0,0,0,0,0,0,8,0,8,0,8,0,4,2,0,0,4,12,
  0,0,110,24,0,0,164,36,0,0,0,10,0,0,106,12,0,0,54,12,0,0,150,0,0,0,97,196,5,0,16,39,
  0,0,97,196,5,0,16,39,0,0,56,66,73,77,3,237,0,0,0,0,0,16,0,96,0,0,0,2,0,2,0,96,
  0,0,0,2,0,2,56,66,73,77,3,243,0,0,0,0,0,7,0,0,0,0,0,0,0,0,56,66,73,77,3,245,
  0,0,0,0,0,72,0,47,102,102,0,1,0,108,102,102,0,6,0,0,0,0,0,0,0,47,102,102,0,1,0,161,
  153,154,0,6,0,0,0,0,0,0,0,50,0,0,0,1,0,90,0,0,0,6,0,0,0,0,0,0,0,53,0,0,
  0,1,0,45,0,0,0,6,0,0,0,0,0,0,56,66,73,77,3,248,0,0,0,0,0,112,0,0,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,232,0,0,0,0,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,232,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,3,232,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,3,232,0,0,128,47,153,137,99,73,45,2,0,132,54,64,14,152,68,34,25,13,136,68,98,81,
  56,164,86,45,23,140,70,99,81,184,228,118,61,31,137,5,225,210,9,36,104,79,8,47,155,198,130,209,57,137,166,237,
  118,191,223,109,88,106,133,84,129,67,156,152,48,216,84,50,31,37,160,80,104,84,58,37,22,141,17,19,200,155,51,240,
  5,38,69,16,166,66,3,192,9,19,164,58,226,11,184,225,212,176,2,26,85,44,49,59,91,45,151,51,157,206,255,153,
  0,31,141,168,107,237,234,231,49,145,11,106,48,0,116,78,227,113,194,161,180,202,140,98,159,123,137,211,162,84,187,237,
  30,63,79,194,225,177,81,138,76,82,30,23,196,87,41,216,76,109,64,1,122,193,66,243,67,97,160,92,172,98,63,189,
  230,14,183,99,177,226,231,0,47,216,41,27,67,238,34,245,181,57,64,0,64,218,133,104,147,48,32,86,55,122,212,95,
  9,16,191,211,93,55,249,237,82,71,19,196,98,232,25,8,94,39,149,207,136,242,100,240,138,86,23,43,143,145,182,100,
  93,60,213,232,186,111,207,9,244,58,54,155,77,227,8,213,42,161,186,216,70,194,38,11,182,188,88,40,195,249,225,126,
  197,222,128,23,108,206,119,67,252,255,192,16,10,66,227,163,68,168,222,55,129,97,56,108,0,24,6,241,234,12,180,199,
  57,138,107,155,202,211,122,14,128,11,65,254,132,31,141,122,16,248,0,15,116,64,122,151,230,105,76,67,141,4,9,196,
  252,157,42,228,5,23,162,142,76,97,25,177,106,240,222,7,128,16,88,0,101,33,166,249,138,98,154,43,194,70,14,130,
  225,122,17,13,67,144,240,1,16,33,175,114,26,248,45,105,178,112,57,61,72,75,176,205,36,177,148,105,45,203,138,51,
  50,199,143,35,248,216,122,155,48,136,0,119,0,7,57,210,111,27,200,68,44,136,195,8,64,59,36,34,112,234,65,18,
  147,104,42,15,44,2,238,43,1,44,192,146,237,5,65,59,104,99,48,234,169,168,106,68,38,135,226,176,36,12,131,39,
  114,204,0,77,136,137,198,236,78,52,187,168,186,206,136,161,226,107,0,0,120,84,136,206,192,36,146,136,159,107,88,150,
  28,139,241,91,242,193,179,79,237,7,89,162,242,211,151,68,178,232,98,78,145,2,241,109,100,138,16,194,176,222,119,27,
  198,40,0,17,4,84,161,188,166,28,110,8,58,134,66,244,84,142,180,40,115,178,40,181,136,194,216,132,113,39,105,225,
  211,95,214,151,11,22,202,202,204,51,26,15,3,161,160,48,0,89,171,173,161,118,78,72,149,50,145,83,51,149,58,141,
  90,200,141,76,181,73,82,96,188,43,135,38,81,130,188,219,247,22,12,163,214,206,52,176,197,11,162,176,0,116,27,192,
  189,215,34,34,21,122,33,56,162,79,200,66,17,3,166,252,43,123,163,55,203,102,139,228,82,104,140,26,136,147,116,87,
  95,96,249,106,73,132,162,247,60,174,138,8,34,192,104,36,8,131,16,30,4,132,196,0,182,45,174,174,53,159,77,179,
  87,110,48,9,4,70,101,136,26,33,186,66,16,96,132,71,112,58,111,100,10,61,75,83,201,183,248,137,129,96,151,6,
  93,131,92,136,130,166,136,3,24,164,98,227,133,33,17,210,13,3,32,184,92,27,13,129,96,64,33,33,165,201,162,112,
  18,68,8,228,135,5,242,35,11,121,232,55,130,17,164,29,58,94,145,100,162,26,165,169,144,161,23,218,43,171,241,136,
  70,78,28,197,102,100,93,105,97,122,250,77,68,59,142,14,198,134,236,160,185,209,75,236,186,101,55,139,33,184,194,41,
  11,227,96,0,60,22,132,64,88,68,22,130,0,112,38,15,1,49,194,40,99,155,70,246,242,62,244,61,24,1,178,195,
  18,20,49,103,105,167,30,163,169,162,90,119,116,245,241,106,15,33,145,95,126,159,26,90,25,165,233,84,52,15,8,105,
  209,118,3,10,215,191,175,34,199,18,35,207,162,255,55,92,132,116,60,194,37,89,94,147,114,53,122,174,186,117,137,104,
  240,124,66,17,182,4,64,152,40,0,0,219,179,3,206,216,0,59,146,48,3,128,72,32,30,67,184,104,140,113,160,48,
  4,144,148,21,77,245,94,144,212,46,217,159,147,129,34,109,56,137,60,242,32,8,143,97,16,122,174,53,107,194,69,248,
  80,194,240,53,7,47,121,33,58,151,134,180,89,132,23,56,36,85,11,173,7,144,197,83,129,23,127,4,114,14,16,133,
  137,6,223,211,179,5,176,2,1,1,119,244,71,199,185,231,128,209,36,113,15,33,218,35,195,144,148,131,80,185,118,67,
  114,32,225,200,64,222,126,233,200,9,60,160,0,15,211,106,199,33,174,234,16,184,229,241,9,153,44,104,141,76,142,19,
  128,1,44,28,3,160,176,24,162,161,120,54,88,168,155,150,106,24,105,0,118,31,191,32,68,15,212,162,221,117,76,84,
  134,54,103,237,24,72,152,227,143,100,33,196,72,130,35,17,212,164,143,139,36,98,31,188,229,142,235,192,0,57,7,33,
  60,162,166,178,168,8,157,227,190,16,33,244,234,55,214,134,187,83,225,17,145,112,249,54,195,213,66,66,15,60,141,131,
  192,2,88,194,18,72,147,144,249,65,27,195,88,104,137,113,2,34,134,136,193,24,49,218,28,1,112,59,32,225,164,57,
  35,77,56,13,38,209,168,254,86,74,221,144,17,141,196,201,41,96,70,160,244,97,4,71,156,136,59,160,114,23,66,3,
  184,150,100,64,9,128,0,64,59,64,0,224,35,110,240,120,183,144,212,232,18,36,51,143,113,246,85,44,152,60,254,166,
  226,56,155,68,93,197,26,226,32,136,163,89,21,132,112,137,172,50,17,180,37,130,216,129,22,19,10,120,17,86,41,14,
  222,107,202,106,67,122,87,72,194,32,78,232,154,110,149,114,188,134,201,0,0,199,134,243,27,155,115,86,49,82,73,101,
  53,233,56,34,3,193,0,22,131,144,77,71,136,216,19,1,35,196,118,143,116,113,18,71,139,60,18,225,224,60,11,49,
  198,51,16,89,144,99,15,209,163,196,116,113,76,41,37,29,35,16,134,128,18,90,154,73,0,32,150,10,225,94,144,83,
  225,152,216,215,91,241,64,115,33,153,145,120,177,43,19,106,200,2,85,130,145,79,153,174,68,102,149,28,60,241,106,86,
  196,121,42,178,34,203,186,1,96,100,17,2,224,137,56,72,108,6,34,177,38,2,206,49,197,18,71,40,227,29,163,4,
  79,11,20,130,51,39,129,204,153,4,86,67,128,10,68,71,102,208,11,77,131,213,100,19,34,104,1,1,49,64,160,100,
  122,51,22,161,66,33,4,64,212,60,179,4,96,139,181,190,17,75,251,18,67,15,124,0,36,102,135,5,159,116,83,36,
  15,217,99,214,50,37,34,35,237,112,35,10,84,138,69,208,68,18,4,116,67,42,80,18,189,16,138,249,94,94,125,127,
  155,132,34,39,11,129,98,52,207,77,89,181,141,244,0,79,52,42,188,95,204,175,118,54,78,164,82,83,222,6,81,9,
  168,146,107,30,203,27,48,54,68,82,98,74,73,247,170,244,17,209,234,51,197,160,166,23,2,140,96,33,65,188,40,198,
  96,204,58,96,122,25,156,98,172,85,10,212,199,124,42,189,227,174,230,207,50,96,213,95,182,228,54,122,17,230,52,199,
  36,220,156,118,206,126,226,142,41,61,1,10,149,200,185,86,4,118,138,161,60,37,30,17,14,116,53,106,234,207,105,174,
  51,17,195,166,145,183,172,39,155,1,166,70,43,157,225,34,100,202,127,22,203,48,127,236,217,18,31,99,88,101,9,177,
  2,36,105,0,209,93,135,236,116,185,215,214,194,64,187,230,7,229,76,245,16,192,48,100,31,28,20,111,235,178,60,202,
  154,138,254,150,36,142,163,171,37,54,23,216,90,85,38,58,110,5,128,236,31,215,105,195,18,238,92,77,29,183,240,17,
  92,162,39,19,128,3,182,20,194,4,79,14,151,140,195,212,188,20,105,172,114,106,17,106,205,71,177,137,18,45,233,46,
  240,1,51,80,59,64,204,210,188,164,75,27,212,233,114,136,116,121,21,160,3,198,131,134,97,3,55,50,205,86,149,37,
  77,91,80,245,48,252,151,91,15,149,37,65,224,219,13,67,148,87,74,204,29,3,48,14,129,135,76,187,30,20,196,33,
  14,140,116,213,152,166,19,66,120,108,8,64,194,114,144,140,212,57,79,56,27,119,88,98,230,78,135,108,3,192,144,38,
  18,226,68,77,76,17,84,240,86,141,174,163,76,113,221,103,249,249,100,145,13,186,34,24,199,65,145,92,99,162,200,161,
  180,34,151,164,140,212,245,250,68,133,12,112,44,163,159,44,164,17,199,133,136,99,158,97,64,1,245,21,51,31,169,204,
  178,233,202,132,53,243,14,151,209,146,39,128,29,116,101,106,255,149,147,143,146,112,201,63,196,100,35,49,230,90,238,0,
  34,112,220,77,160,39,94,14,209,120,54,64,152,39,2,148,186,238,139,65,52,55,133,40,193,148,143,177,34,107,76,245,
  130,107,129,59,1,241,130,107,17,205,2,69,175,1,16,44,228,207,72,36,178,43,102,94,174,54,179,38,45,14,138,16,
  182,34,7,48,0,26,105,162,44,141,234,125,193,55,139,235,222,133,81,116,38,237,238,66,6,82,223,191,143,185,226,112,
  56,237,173,8,147,237,34,58,210,233,21,7,212,102,128,240,52,105,133,226,59,20,246,55,146,233,97,162,0,15,252,105,
  143,80,38,11,64,216,29,118,228,73,220,225,177,198,3,240,240,114,109,49,241,54,216,114,26,223,65,160,44,61,177,5,
  39,221,203,183,34,44,163,250,229,248,203,24,232,96,1,162,0,3,254,241,227,179,200,191,241,238,0,1,110,224,230,168,
  143,72,175,171,206,67,71,225,178,209,165,11,116,133,189,7,166,50,233,120,234,61,39,127,145,18,248,240,204,239,88,125,
  155,205,241,237,4,254,230,9,243,68,222,109,4,113,31,207,119,167,46,161,13,6,218,228,4,235,210,17,176,136,67,182,
  195,159,35,56,187,126,235,18,111,152,158,126,249,219,81,107,89,226,197,228,178,75,145,222,39,24,94,13,6,216,223,87,
  47,230,36,54,241,78,71,254,63,199,129,52,35,126,115,155,94,99,98,68,247,23,237,35,99,215,116,135,242,222,57,233,
  1,128,28,111,11,126,157,71,208,171,175,102,71,101,98,83,109,56,224,230,46,233,197,54,83,33,210,222,162,168,194,195,
  168,247,34,26,234,102,46,2,224,130,143,224,90,237,41,208,248,173,122,38,4,202,127,195,80,237,239,152,118,193,142,190,
  134,60,91,164,176,25,67,248,51,139,20,146,203,186,178,68,218,7,96,68,219,162,40,108,111,32,241,207,32,34,142,98,
  28,239,36,232,68,50,253,34,74,253,139,214,132,79,62,219,195,218,209,239,232,14,15,236,44,207,80,145,5,160,255,130,
  22,245,172,194,133,162,251,1,133,20,255,174,152,33,110,190,195,34,67,11,34,251,0,166,22,171,41,140,3,160,126,12,
  64,158,249,1,202,27,204,94,237,226,16,2,109,132,29,173,128,73,97,218,26,96,32,118,112,222,176,129,99,1,5,44,
  204,2,32,240,64,58,251,130,46,198,32,20,24,161,188,30,208,96,208,67,80,174,96,50,208,193,207,6,226,40,1,64,
  40,184,64,0,30,193,216,26,98,2,128,63,222,13,80,4,22,13,7,132,66,97,80,176,0,46,16,4,13,128,31,144,
  232,48,18,16,252,0,42,209,8,135,179,177,166,245,115,128,30,48,135,115,121,188,233,130,178,156,110,56,43,164,61,5,
  23,135,70,144,87,28,160,0,23,150,193,93,16,80,196,178,118,233,113,74,3,193,121,196,30,109,69,131,80,33,51,104,
  45,14,115,5,153,133,217,144,98,8,252,104,45,32,24,160,174,216,48,108,58,19,15,2,65,238,39,187,198,194,15,0,
  89,64,22,37,162,105,188,212,111,44,102,147,103,68,214,13,49,26,8,68,66,40,96,44,51,10,144,0,37,224,7,109,
  254,18,19,144,189,197,162,208,75,77,167,7,22,193,113,240,108,44,36,50,255,106,177,64,1,176,128,1,202,240,205,231,
  97,154,61,36,83,72,0,136,68,156,171,66,218,5,219,38,115,95,0,12,17,19,184,58,222,164,206,170,115,122,152,116,
  46,47,132,74,55,192,11,180,24,59,52,131,58,25,148,9,196,190,139,71,160,224,128,18,138,68,31,163,78,130,133,232,
  50,233,192,99,124,67,29,143,197,195,97,107,149,226,19,175,65,94,78,223,54,110,209,237,28,137,132,73,164,211,42,75,
  154,131,205,101,144,96,191,30,244,14,164,96,2,208,217,52,107,243,44,132,36,32,0,50,196,28,236,171,16,194,47,240,
  123,10,195,65,48,88,41,4,128,12,195,240,130,179,136,59,62,208,180,241,10,18,211,33,103,168,0,80,143,228,210,65,
  12,27,232,50,76,165,184,139,170,10,14,131,160,196,98,253,161,14,240,0,186,184,73,195,247,26,28,73,90,94,116,198,
  201,195,143,30,32,199,19,114,155,186,72,99,158,170,170,226,0,158,13,173,7,129,188,143,130,108,137,218,199,203,50,162,
  14,105,25,71,97,168,98,195,110,66,114,227,184,146,50,244,134,64,144,50,10,12,197,115,115,71,5,156,240,195,40,12,
  206,144,107,12,132,65,224,91,34,125,76,128,43,68,174,179,176,252,58,131,80,212,43,65,14,209,44,245,23,65,161,81,
  33,246,101,30,5,49,84,85,32,167,59,3,0,161,6,241,174,220,38,145,148,116,254,0,19,66,20,104,156,109,216,47,
  29,39,107,155,179,29,57,233,212,113,37,169,21,99,138,0,38,32,186,244,31,131,194,4,181,46,5,167,186,184,10,0,
  6,152,32,24,8,7,41,198,174,32,166,9,60,185,63,42,76,127,38,56,211,90,11,2,47,179,197,51,55,211,48,124,
  238,131,79,44,130,26,130,196,204,146,10,200,160,200,164,53,17,93,136,69,15,118,197,198,97,206,97,150,101,157,50,192,
  129,105,49,234,189,160,208,10,74,111,26,42,152,48,168,184,145,156,69,31,165,7,28,144,155,198,201,187,142,186,37,137,
  136,0,9,38,165,250,121,38,72,233,102,26,254,131,179,88,82,22,192,151,40,54,9,140,213,41,181,101,29,182,16,0,
  101,22,54,133,217,31,218,200,45,243,107,137,240,83,39,112,65,22,242,25,116,33,104,161,234,199,207,204,4,178,194,26,
  119,90,24,208,0,20,131,71,164,105,72,101,222,132,153,229,169,92,114,150,38,155,42,131,36,21,3,100,111,83,128,3,
  106,147,40,237,32,36,189,223,232,92,113,84,41,46,242,139,52,97,78,45,86,132,39,232,74,240,22,7,97,16,38,19,
  136,10,221,74,9,128,6,129,128,138,29,128,0,90,117,177,198,250,77,177,128,9,42,18,187,109,147,85,177,107,219,32,
  4,37,8,216,136,59,31,7,114,168,70,125,205,33,23,47,55,12,204,136,62,154,130,233,8,55,70,0,116,168,46,149,
  166,33,108,225,246,207,152,133,113,35,159,194,0,201,204,144,173,7,62,187,23,113,72,69,166,167,168,188,71,122,224,187,
  42,122,234,102,109,85,140,118,131,38,178,42,15,26,120,245,205,119,57,3,32,80,41,204,132,139,227,218,113,24,6,159,
  13,80,33,91,30,190,147,205,53,46,98,131,77,179,218,21,157,32,250,15,104,133,103,151,24,1,114,161,90,7,226,131,
  93,109,1,246,130,208,93,34,14,254,192,0,5,116,207,248,133,58,118,156,4,6,242,242,26,195,28,77,14,209,216,250,
  151,34,117,33,46,237,178,147,145,198,145,137,163,99,3,168,13,239,188,39,192,81,145,139,204,72,132,220,159,182,163,146,
  243,78,27,197,0,13,208,44,39,18,76,2,130,120,79,35,163,76,9,172,72,28,237,147,172,21,71,240,120,134,51,4,
  8,250,87,129,5,134,175,200,211,191,70,100,136,156,241,5,127,38,16,123,142,0,38,6,65,0,251,52,0,20,123,144,
  80,18,66,29,88,0,128,15,245,212,58,162,16,235,8,48,207,96,3,148,81,140,4,38,66,135,56,20,68,204,221,126,
  140,23,18,109,218,241,124,69,228,45,241,16,101,254,196,21,153,211,120,173,176,163,157,232,82,194,88,41,253,90,165,236,
  191,39,4,235,33,97,170,13,112,41,141,242,65,117,75,15,28,68,118,131,237,132,0,23,167,30,67,75,250,248,130,8,
  40,131,32,194,250,100,71,170,89,1,105,110,35,68,68,75,40,165,34,89,31,238,132,132,69,179,59,20,160,12,85,45,
  113,104,132,64,40,130,65,217,72,224,26,67,28,88,187,70,175,39,0,2,154,78,200,24,192,175,208,0,214,151,252,60,
  146,211,24,132,141,231,20,194,81,228,38,110,13,185,137,20,194,89,32,160,210,215,45,18,96,0,59,116,4,65,92,48,
  193,38,192,164,17,42,103,33,49,230,220,20,131,238,34,109,206,121,184,228,209,10,222,50,40,144,131,202,85,211,18,8,
  68,171,18,196,28,123,130,241,247,21,200,76,2,26,47,236,23,203,104,1,64,72,56,209,45,51,250,128,63,200,170,51,
  199,184,209,30,13,249,247,149,180,246,133,38,41,11,107,179,58,15,204,178,10,238,212,235,195,58,100,172,228,163,70,55,
  5,136,65,199,37,108,112,16,131,176,118,55,211,35,231,112,206,45,30,144,137,216,65,193,17,35,3,46,230,112,163,54,
  99,16,28,154,121,65,201,217,193,16,129,216,16,0,88,20,24,17,21,251,52,144,68,11,64,120,202,0,3,88,19,144,
  212,182,214,37,80,188,24,179,254,0,128,10,6,174,40,69,10,159,178,204,180,197,106,191,65,101,145,6,1,52,40,130,
  208,65,229,19,70,56,218,55,15,117,116,202,7,46,250,168,203,237,147,36,134,141,184,170,60,55,139,240,34,83,115,162,
  112,62,6,16,141,210,33,50,84,149,121,84,164,89,5,74,95,20,58,29,43,76,234,177,57,202,128,212,236,238,36,116,
  114,74,175,194,155,69,168,193,33,144,171,118,209,63,117,201,17,229,185,9,148,32,182,81,198,201,242,49,68,181,4,138,
  145,106,43,168,33,193,20,129,1,6,182,101,174,179,203,102,146,56,29,69,32,159,128,190,136,81,42,40,65,163,97,138,
  5,164,117,192,185,217,14,73,128,153,123,73,68,29,78,70,224,0,15,198,245,152,115,70,192,17,3,181,51,5,108,99,
  200,55,197,21,84,88,150,214,93,71,25,49,156,196,46,201,193,117,76,169,147,91,51,54,32,138,118,209,244,20,6,128,
  204,194,107,141,120,180,88,0,51,96,173,20,155,66,143,178,162,207,72,146,104,192,133,79,61,182,181,118,96,150,120,59,
  5,224,165,147,160,2,220,154,122,215,66,215,97,92,184,4,24,178,143,