/*
   Unix SMB/CIFS implementation.
   Copyright (C) Jelmer Vernooij			2004-2007.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "registry.h"
#include "param/param.h"

/**
 * @file
 * @brief Samba-specific registry functions
 */

static WERROR mount_samba_hive(struct registry_context *ctx,
			       struct tevent_context *event_ctx,
			       struct loadparm_context *lp_ctx,
			       struct auth_session_info *auth_info,
			       struct cli_credentials *creds,
			       const char *name,
			       uint32_t hive_id)
{
	WERROR error;
	struct hive_key *hive;
	const char *location;

	location = talloc_asprintf(ctx, "%s/%s.ldb",
				   lpcfg_private_dir(lp_ctx),
				   name);
	W_ERROR_HAVE_NO_MEMORY(location);

	error = reg_open_hive(ctx, location, auth_info, creds, event_ctx, lp_ctx, &hive);

	if (W_ERROR_EQUAL(error, WERR_BADFILE))
		error = reg_open_ldb_file(ctx, location, auth_info,
					  creds, event_ctx, lp_ctx, &hive);

	talloc_free(discard_const_p(char, location));

	if (!W_ERROR_IS_OK(error))
		return error;

	return reg_mount_hive(ctx, hive, hive_id, NULL);
}


_PUBLIC_ WERROR reg_open_samba(TALLOC_CTX *mem_ctx,
			       struct registry_context **ctx,
			       struct tevent_context *ev_ctx,
			       struct loadparm_context *lp_ctx,
			       struct auth_session_info *session_info,
			       struct cli_credentials *credentials)
{
	WERROR result;

	result = reg_open_local(mem_ctx, ctx);
	if (!W_ERROR_IS_OK(result)) {
		return result;
	}

	mount_samba_hive(*ctx, ev_ctx, lp_ctx, session_info, credentials,
			 "hklm", HKEY_LOCAL_MACHINE);

	mount_samba_hive(*ctx, ev_ctx, lp_ctx, session_info, credentials,
			 "hkcr", HKEY_CLASSES_ROOT);

	/* FIXME: Should be mounted from NTUSER.DAT in the home directory of the
	 * current user */
	mount_samba_hive(*ctx, ev_ctx, lp_ctx, session_info, credentials,
			 "hkcu", HKEY_CURRENT_USER);

	mount_samba_hive(*ctx, ev_ctx, lp_ctx, session_info, credentials,
			 "hku", HKEY_USERS);

	/* FIXME: Different hive backend for HKEY_CLASSES_ROOT: merged view of HKEY_LOCAL_MACHINE\Software\Classes
	 * and HKEY_CURRENT_USER\Software\Classes */

	/* FIXME: HKEY_CURRENT_CONFIG is an alias for HKEY_LOCAL_MACHINE\System\CurrentControlSet\Hardware Profiles\Current */

	/* FIXME: HKEY_PERFORMANCE_DATA is dynamically generated */

	/* FIXME: HKEY_LOCAL_MACHINE\Hardware is autogenerated */

	/* FIXME: HKEY_LOCAL_MACHINE\Security\SAM is an alias for HKEY_LOCAL_MACHINE\SAM */

	return WERR_OK;
}
