/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.template;

import java.util.Enumeration;
import java.util.Vector;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xslt.XsltContext;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.pattern.OrPattern;
import jd.xml.xslt.pattern.Pattern;
import jd.xml.xslt.pattern.PatternClassifier;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.template.ApplyTemplatesToChildren;
import jd.xml.xslt.template.TemplateRule;

public class TemplateRuleList {
    private String mode_;
    private Item[] typeRules_;
    private Item[] elementRules_;
    private int maxElementName_;
    private Vector rules_ = new Vector();
    private TemplateRule builtinElementRootRule_;
    private int namePoolSize_;

    public TemplateRuleList(String string) {
        this.mode_ = string;
        ApplyTemplatesToChildren applyTemplatesToChildren = new ApplyTemplatesToChildren(this, null);
        this.builtinElementRootRule_ = new TemplateRule(Integer.MIN_VALUE, 0.0, Integer.MIN_VALUE, applyTemplatesToChildren, null, false, "builtin: *|/");
    }

    public String getMode() {
        return this.mode_;
    }

    public void addTemplateRule(TemplateRule templateRule) {
        if (templateRule.getPattern() == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        this.rules_.addElement(templateRule);
    }

    public Enumeration getRules() {
        return this.rules_.elements();
    }

    public int getNamePoolSize() {
        return this.namePoolSize_;
    }

    public void setup(int n) {
        this.namePoolSize_ = n;
        TemplateRule[] templateRuleArray = TemplateRule.toSortedArray(this.rules_);
        int n2 = templateRuleArray.length;
        this.rules_.removeAllElements();
        for (int i = 0; i < n2; ++i) {
            this.rules_.addElement(templateRuleArray[i]);
        }
        this.typeRules_ = new Item[7];
        this.elementRules_ = new Item[n];
        this.maxElementName_ = n - 1;
        PatternClassifier patternClassifier = new PatternClassifier();
        for (int i = n2 - 1; i >= 0; --i) {
            this.setup(templateRuleArray[i], patternClassifier);
        }
    }

    private void setup(TemplateRule templateRule, PatternClassifier patternClassifier) {
        Pattern pattern = templateRule.getPattern();
        if (pattern instanceof OrPattern) {
            Pattern[] patternArray = ((OrPattern)pattern).getPatterns();
            for (int i = 0; i < patternArray.length; ++i) {
                this.setup(templateRule, patternClassifier, patternArray[i]);
            }
        } else {
            this.setup(templateRule, patternClassifier, pattern);
        }
    }

    private void setup(TemplateRule templateRule, PatternClassifier patternClassifier, Pattern pattern) {
        PatternClassifier.Match match = patternClassifier.classify(pattern);
        while (match != null) {
            if (match.nodeType == 0) {
                int n;
                if (match.nodeName != null && match.nodeName.nameId != -1) {
                    n = match.nodeName.nameId;
                    this.elementRules_[n] = new Item(templateRule, this.elementRules_[n]);
                    match = match.next;
                    continue;
                }
                for (n = this.elementRules_.length - 1; n >= 0; --n) {
                    this.elementRules_[n] = new Item(templateRule, this.elementRules_[n]);
                }
            }
            this.typeRules_[match.nodeType] = new Item(templateRule, this.typeRules_[match.nodeType]);
            match = match.next;
        }
    }

    public TemplateRule getMatchingRule(XsltContext xsltContext, int n, ResultBuilder resultBuilder) throws XsltException {
        int n2;
        XPathNode xPathNode = xsltContext.getNode();
        int n3 = xPathNode.getType();
        Item item = null;
        item = n3 == 0 ? ((n2 = xPathNode.getNodeName().nameId) <= this.maxElementName_ ? this.elementRules_[n2] : this.typeRules_[0]) : this.typeRules_[n3];
        while (item != null) {
            if (item.rule.match(xsltContext) && item.rule.getImportPrecedence() <= n) {
                return item.rule.getTemplate() == null ? null : item.rule;
            }
            item = item.next;
        }
        if (n3 == 0 || n3 == 3) {
            return this.builtinElementRootRule_;
        }
        if (n3 == 1 || n3 == 2) {
            String string = xsltContext.getNode().getValue();
            resultBuilder.addText(string);
        }
        return null;
    }

    private static class Item {
        public final TemplateRule rule;
        public final Item next;

        public Item(TemplateRule templateRule, Item item) {
            this.rule = templateRule;
            this.next = item;
        }
    }
}

