//  Copyright 2024 Google LLC

//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at

//     https://www.apache.org/licenses/LICENSE-2.0

//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v3.21.12
// source: agent_controlplane.proto

// The package contains messages between control plane and a guest agent over
// Agent Communication Service.

package acp

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AgentInfo_AgentCapability int32

const (
	AgentInfo_AGENT_CAPABILITY_UNSPECIFIED AgentInfo_AgentCapability = 0
	// The agent supports returning agent information.
	AgentInfo_GET_AGENT_INFO AgentInfo_AgentCapability = 1
	// The agent supports returning OS information.
	AgentInfo_GET_OS_INFO AgentInfo_AgentCapability = 2
	// The agent supports returning plugin states.
	AgentInfo_LIST_PLUGIN_STATES AgentInfo_AgentCapability = 3
	// The agent supports configuring different plugin states through
	// install/remove a plugin revision.
	AgentInfo_CONFIGURE_PLUGIN_STATES AgentInfo_AgentCapability = 4
	// The agent supports applying the config to the installed plugin.
	AgentInfo_APPLY_PLUGIN_CONFIG AgentInfo_AgentCapability = 5
)

// Enum value maps for AgentInfo_AgentCapability.
var (
	AgentInfo_AgentCapability_name = map[int32]string{
		0: "AGENT_CAPABILITY_UNSPECIFIED",
		1: "GET_AGENT_INFO",
		2: "GET_OS_INFO",
		3: "LIST_PLUGIN_STATES",
		4: "CONFIGURE_PLUGIN_STATES",
		5: "APPLY_PLUGIN_CONFIG",
	}
	AgentInfo_AgentCapability_value = map[string]int32{
		"AGENT_CAPABILITY_UNSPECIFIED": 0,
		"GET_AGENT_INFO":               1,
		"GET_OS_INFO":                  2,
		"LIST_PLUGIN_STATES":           3,
		"CONFIGURE_PLUGIN_STATES":      4,
		"APPLY_PLUGIN_CONFIG":          5,
	}
)

func (x AgentInfo_AgentCapability) Enum() *AgentInfo_AgentCapability {
	p := new(AgentInfo_AgentCapability)
	*p = x
	return p
}

func (x AgentInfo_AgentCapability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentInfo_AgentCapability) Descriptor() protoreflect.EnumDescriptor {
	return file_agent_controlplane_proto_enumTypes[0].Descriptor()
}

func (AgentInfo_AgentCapability) Type() protoreflect.EnumType {
	return &file_agent_controlplane_proto_enumTypes[0]
}

func (x AgentInfo_AgentCapability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentInfo_AgentCapability.Descriptor instead.
func (AgentInfo_AgentCapability) EnumDescriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{2, 0}
}

// Detailed plugin status on the resource.
//
// If there's another revision is running, it will be stopped before
// starting this plugin. If any step fails during the process, agent will
// retry until retry attempts exhausted.
//
// During restart of a plugin, it will go through
// STOPPING -> STOPPED -> STARTING -> RUNNING
// with start_time updated if it restarts successfully.
//
// When trying to stop the plugin, the agent will first try signal the
// plugin to stop itself. If the plugin does not stop after a certain
// timeout, it will force kill the process.
//
// CRASHED and INSTALL_FAILED statuses expect a non-zero response code
// indicating an error. Other statuses might have a non-zero response code
// indicating a non-fatal error.
type CurrentPluginStates_DaemonPluginState_StatusValue int32

const (
	CurrentPluginStates_DaemonPluginState_STATE_VALUE_UNSPECIFIED CurrentPluginStates_DaemonPluginState_StatusValue = 0
	// Life cycle of a plugin after installed.
	CurrentPluginStates_DaemonPluginState_STARTING CurrentPluginStates_DaemonPluginState_StatusValue = 1
	CurrentPluginStates_DaemonPluginState_RUNNING  CurrentPluginStates_DaemonPluginState_StatusValue = 2
	CurrentPluginStates_DaemonPluginState_STOPPING CurrentPluginStates_DaemonPluginState_StatusValue = 3
	CurrentPluginStates_DaemonPluginState_STOPPED  CurrentPluginStates_DaemonPluginState_StatusValue = 4
	CurrentPluginStates_DaemonPluginState_CRASHED  CurrentPluginStates_DaemonPluginState_StatusValue = 5
	// Installing or failed to install.
	CurrentPluginStates_DaemonPluginState_INSTALLING     CurrentPluginStates_DaemonPluginState_StatusValue = 6
	CurrentPluginStates_DaemonPluginState_INSTALL_FAILED CurrentPluginStates_DaemonPluginState_StatusValue = 7
)

// Enum value maps for CurrentPluginStates_DaemonPluginState_StatusValue.
var (
	CurrentPluginStates_DaemonPluginState_StatusValue_name = map[int32]string{
		0: "STATE_VALUE_UNSPECIFIED",
		1: "STARTING",
		2: "RUNNING",
		3: "STOPPING",
		4: "STOPPED",
		5: "CRASHED",
		6: "INSTALLING",
		7: "INSTALL_FAILED",
	}
	CurrentPluginStates_DaemonPluginState_StatusValue_value = map[string]int32{
		"STATE_VALUE_UNSPECIFIED": 0,
		"STARTING":                1,
		"RUNNING":                 2,
		"STOPPING":                3,
		"STOPPED":                 4,
		"CRASHED":                 5,
		"INSTALLING":              6,
		"INSTALL_FAILED":          7,
	}
)

func (x CurrentPluginStates_DaemonPluginState_StatusValue) Enum() *CurrentPluginStates_DaemonPluginState_StatusValue {
	p := new(CurrentPluginStates_DaemonPluginState_StatusValue)
	*p = x
	return p
}

func (x CurrentPluginStates_DaemonPluginState_StatusValue) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CurrentPluginStates_DaemonPluginState_StatusValue) Descriptor() protoreflect.EnumDescriptor {
	return file_agent_controlplane_proto_enumTypes[1].Descriptor()
}

func (CurrentPluginStates_DaemonPluginState_StatusValue) Type() protoreflect.EnumType {
	return &file_agent_controlplane_proto_enumTypes[1]
}

func (x CurrentPluginStates_DaemonPluginState_StatusValue) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CurrentPluginStates_DaemonPluginState_StatusValue.Descriptor instead.
func (CurrentPluginStates_DaemonPluginState_StatusValue) EnumDescriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{6, 0, 0}
}

type ConfigurePluginStates_Action int32

const (
	ConfigurePluginStates_ACTION_UNSPECIFIED ConfigurePluginStates_Action = 0
	// Instruct the Guest agent to stop the plugin if it finds one already
	// running. Then install AND run the given plugin_name@revision_id. It's
	// expected that every plugin should be long running until it's removed. So
	// we don't have a start/stop, or enable/disable here.
	ConfigurePluginStates_INSTALL ConfigurePluginStates_Action = 1
	// Instruct the Guest Agent to first stop the running plugin then remove the
	// plugin binary.
	// When using this action, only the name of the plugin will be specified,
	// other fields will be empty.
	ConfigurePluginStates_REMOVE ConfigurePluginStates_Action = 2
	// Instruct the Guest Agent to apply the config to the running plugin. If
	// the plugin does not support Apply RPC then the Guest Agent will restart
	// the plugin with the new config.
	ConfigurePluginStates_APPLY ConfigurePluginStates_Action = 3
)

// Enum value maps for ConfigurePluginStates_Action.
var (
	ConfigurePluginStates_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "INSTALL",
		2: "REMOVE",
		3: "APPLY",
	}
	ConfigurePluginStates_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"INSTALL":            1,
		"REMOVE":             2,
		"APPLY":              3,
	}
)

func (x ConfigurePluginStates_Action) Enum() *ConfigurePluginStates_Action {
	p := new(ConfigurePluginStates_Action)
	*p = x
	return p
}

func (x ConfigurePluginStates_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConfigurePluginStates_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_agent_controlplane_proto_enumTypes[2].Descriptor()
}

func (ConfigurePluginStates_Action) Type() protoreflect.EnumType {
	return &file_agent_controlplane_proto_enumTypes[2]
}

func (x ConfigurePluginStates_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConfigurePluginStates_Action.Descriptor instead.
func (ConfigurePluginStates_Action) EnumDescriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{7, 0}
}

// Enum for the types of events that can occur to a plugin or a CSE config.
type PluginEventMessage_PluginEventType int32

const (
	// Unspecified event type, used as a default value.
	PluginEventMessage_PLUGIN_EVENT_TYPE_UNSPECIFIED PluginEventMessage_PluginEventType = 0
	// Event indicating that CSE has sent a configuration to install a new
	// plugin revision. This event type captures the initiation of the
	// installation process for a plugin.
	PluginEventMessage_PLUGIN_CONFIG_INSTALL PluginEventMessage_PluginEventType = 1
	// Event indicating that CSE has sent a configuration to remove an existing
	// plugin revision. This event type is used when a plugin is being
	// uninstalled or removed from the agent.
	PluginEventMessage_PLUGIN_CONFIG_REMOVE PluginEventMessage_PluginEventType = 2
	// Event indicating that the plugin has been successfully installed.
	PluginEventMessage_PLUGIN_INSTALLED PluginEventMessage_PluginEventType = 3
	// Event indicating that the plugin has started successfully.
	PluginEventMessage_PLUGIN_STARTED PluginEventMessage_PluginEventType = 4
	// Event indicating that the plugin has been successfully removed.
	PluginEventMessage_PLUGIN_REMOVED PluginEventMessage_PluginEventType = 5
	// Event indicating that the plugin has been stopped, either as part of a
	// normal shutdown or due to an error.
	PluginEventMessage_PLUGIN_STOPPED PluginEventMessage_PluginEventType = 6
	// Event indicating that the plugin has crashed. This is typically followed
	// by a restart if auto-recovery is enabled.
	PluginEventMessage_PLUGIN_CRASHED PluginEventMessage_PluginEventType = 7
	// Event indicating that an attempt to install the plugin has failed.
	PluginEventMessage_PLUGIN_INSTALL_FAILED PluginEventMessage_PluginEventType = 8
	// Event indicating that an attempt to start the plugin has failed.
	PluginEventMessage_PLUGIN_START_FAILED PluginEventMessage_PluginEventType = 9
	// Event indicating that an attempt to remove or uninstall the plugin has
	// failed.
	PluginEventMessage_PLUGIN_REMOVE_FAILED PluginEventMessage_PluginEventType = 10
	// Event indicating that agent has received the plugin config to apply.
	PluginEventMessage_PLUGIN_CONFIG_APPLY PluginEventMessage_PluginEventType = 11
	// Event indicating that agent successfully applied the plugin config.
	PluginEventMessage_PLUGIN_CONFIG_APPLIED PluginEventMessage_PluginEventType = 12
	// Event indicating that agent failed to apply the plugin config. This event
	// will be triggered only when the plugin returns non-unimplemented rpc
	// error code to the Apply RPC. In case of unimplemented error code, the
	// agent will run restart workflow on the plugin with new config and
	// will not trigger this event.
	PluginEventMessage_PLUGIN_CONFIG_APPLY_FAILED PluginEventMessage_PluginEventType = 13
)

// Enum value maps for PluginEventMessage_PluginEventType.
var (
	PluginEventMessage_PluginEventType_name = map[int32]string{
		0:  "PLUGIN_EVENT_TYPE_UNSPECIFIED",
		1:  "PLUGIN_CONFIG_INSTALL",
		2:  "PLUGIN_CONFIG_REMOVE",
		3:  "PLUGIN_INSTALLED",
		4:  "PLUGIN_STARTED",
		5:  "PLUGIN_REMOVED",
		6:  "PLUGIN_STOPPED",
		7:  "PLUGIN_CRASHED",
		8:  "PLUGIN_INSTALL_FAILED",
		9:  "PLUGIN_START_FAILED",
		10: "PLUGIN_REMOVE_FAILED",
		11: "PLUGIN_CONFIG_APPLY",
		12: "PLUGIN_CONFIG_APPLIED",
		13: "PLUGIN_CONFIG_APPLY_FAILED",
	}
	PluginEventMessage_PluginEventType_value = map[string]int32{
		"PLUGIN_EVENT_TYPE_UNSPECIFIED": 0,
		"PLUGIN_CONFIG_INSTALL":         1,
		"PLUGIN_CONFIG_REMOVE":          2,
		"PLUGIN_INSTALLED":              3,
		"PLUGIN_STARTED":                4,
		"PLUGIN_REMOVED":                5,
		"PLUGIN_STOPPED":                6,
		"PLUGIN_CRASHED":                7,
		"PLUGIN_INSTALL_FAILED":         8,
		"PLUGIN_START_FAILED":           9,
		"PLUGIN_REMOVE_FAILED":          10,
		"PLUGIN_CONFIG_APPLY":           11,
		"PLUGIN_CONFIG_APPLIED":         12,
		"PLUGIN_CONFIG_APPLY_FAILED":    13,
	}
)

func (x PluginEventMessage_PluginEventType) Enum() *PluginEventMessage_PluginEventType {
	p := new(PluginEventMessage_PluginEventType)
	*p = x
	return p
}

func (x PluginEventMessage_PluginEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginEventMessage_PluginEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_agent_controlplane_proto_enumTypes[3].Descriptor()
}

func (PluginEventMessage_PluginEventType) Type() protoreflect.EnumType {
	return &file_agent_controlplane_proto_enumTypes[3]
}

func (x PluginEventMessage_PluginEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PluginEventMessage_PluginEventType.Descriptor instead.
func (PluginEventMessage_PluginEventType) EnumDescriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{8, 0}
}

type GuestAgentModuleMetric_Metric int32

const (
	GuestAgentModuleMetric_MODULE_UNSPECIFIED                   GuestAgentModuleMetric_Metric = 0
	GuestAgentModuleMetric_NETWORK_INITIALIZATION               GuestAgentModuleMetric_Metric = 1
	GuestAgentModuleMetric_IOSCHED_INITIALIZATION               GuestAgentModuleMetric_Metric = 2
	GuestAgentModuleMetric_AGENT_CRYPTO_INITIALIZATION          GuestAgentModuleMetric_Metric = 3
	GuestAgentModuleMetric_CLOCK_INITIALIZATION                 GuestAgentModuleMetric_Metric = 4
	GuestAgentModuleMetric_COMMAND_INITIALIZATION               GuestAgentModuleMetric_Metric = 5
	GuestAgentModuleMetric_DIAGNOSTICS_INITIALIZATION           GuestAgentModuleMetric_Metric = 6
	GuestAgentModuleMetric_FIRST_BOOT_INITIALIZATION            GuestAgentModuleMetric_Metric = 7
	GuestAgentModuleMetric_HOST_NAME_INITIALIZATION             GuestAgentModuleMetric_Metric = 8
	GuestAgentModuleMetric_METADATA_SSH_KEY_INITIALIZATION      GuestAgentModuleMetric_Metric = 9
	GuestAgentModuleMetric_OS_LOGIN_INITIALIZATION              GuestAgentModuleMetric_Metric = 10
	GuestAgentModuleMetric_PLAT_SCRIPT_INITIALIZATION           GuestAgentModuleMetric_Metric = 11
	GuestAgentModuleMetric_SNAPSHOT_INITIALIZATION              GuestAgentModuleMetric_Metric = 12
	GuestAgentModuleMetric_TELEMETRY_INITIALIZATION             GuestAgentModuleMetric_Metric = 13
	GuestAgentModuleMetric_WORKLOAD_CERT_REFRESH_INITIALIZATION GuestAgentModuleMetric_Metric = 14
	GuestAgentModuleMetric_WSFC_HEALTH_CHECK_INITIALIZATION     GuestAgentModuleMetric_Metric = 15
	GuestAgentModuleMetric_WINDOWS_PASSWORD_RESET               GuestAgentModuleMetric_Metric = 16
	GuestAgentModuleMetric_CORE_PLUGIN_INITIALIZATION           GuestAgentModuleMetric_Metric = 17
	GuestAgentModuleMetric_GUEST_COMPAT_MANAGER_INITIALIZATION  GuestAgentModuleMetric_Metric = 18
)

// Enum value maps for GuestAgentModuleMetric_Metric.
var (
	GuestAgentModuleMetric_Metric_name = map[int32]string{
		0:  "MODULE_UNSPECIFIED",
		1:  "NETWORK_INITIALIZATION",
		2:  "IOSCHED_INITIALIZATION",
		3:  "AGENT_CRYPTO_INITIALIZATION",
		4:  "CLOCK_INITIALIZATION",
		5:  "COMMAND_INITIALIZATION",
		6:  "DIAGNOSTICS_INITIALIZATION",
		7:  "FIRST_BOOT_INITIALIZATION",
		8:  "HOST_NAME_INITIALIZATION",
		9:  "METADATA_SSH_KEY_INITIALIZATION",
		10: "OS_LOGIN_INITIALIZATION",
		11: "PLAT_SCRIPT_INITIALIZATION",
		12: "SNAPSHOT_INITIALIZATION",
		13: "TELEMETRY_INITIALIZATION",
		14: "WORKLOAD_CERT_REFRESH_INITIALIZATION",
		15: "WSFC_HEALTH_CHECK_INITIALIZATION",
		16: "WINDOWS_PASSWORD_RESET",
		17: "CORE_PLUGIN_INITIALIZATION",
		18: "GUEST_COMPAT_MANAGER_INITIALIZATION",
	}
	GuestAgentModuleMetric_Metric_value = map[string]int32{
		"MODULE_UNSPECIFIED":                   0,
		"NETWORK_INITIALIZATION":               1,
		"IOSCHED_INITIALIZATION":               2,
		"AGENT_CRYPTO_INITIALIZATION":          3,
		"CLOCK_INITIALIZATION":                 4,
		"COMMAND_INITIALIZATION":               5,
		"DIAGNOSTICS_INITIALIZATION":           6,
		"FIRST_BOOT_INITIALIZATION":            7,
		"HOST_NAME_INITIALIZATION":             8,
		"METADATA_SSH_KEY_INITIALIZATION":      9,
		"OS_LOGIN_INITIALIZATION":              10,
		"PLAT_SCRIPT_INITIALIZATION":           11,
		"SNAPSHOT_INITIALIZATION":              12,
		"TELEMETRY_INITIALIZATION":             13,
		"WORKLOAD_CERT_REFRESH_INITIALIZATION": 14,
		"WSFC_HEALTH_CHECK_INITIALIZATION":     15,
		"WINDOWS_PASSWORD_RESET":               16,
		"CORE_PLUGIN_INITIALIZATION":           17,
		"GUEST_COMPAT_MANAGER_INITIALIZATION":  18,
	}
)

func (x GuestAgentModuleMetric_Metric) Enum() *GuestAgentModuleMetric_Metric {
	p := new(GuestAgentModuleMetric_Metric)
	*p = x
	return p
}

func (x GuestAgentModuleMetric_Metric) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GuestAgentModuleMetric_Metric) Descriptor() protoreflect.EnumDescriptor {
	return file_agent_controlplane_proto_enumTypes[4].Descriptor()
}

func (GuestAgentModuleMetric_Metric) Type() protoreflect.EnumType {
	return &file_agent_controlplane_proto_enumTypes[4]
}

func (x GuestAgentModuleMetric_Metric) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GuestAgentModuleMetric_Metric.Descriptor instead.
func (GuestAgentModuleMetric_Metric) EnumDescriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{10, 0}
}

type GuestAgentModuleMetric_ModuleStatus int32

const (
	GuestAgentModuleMetric_MODULE_STATUS_UNSPECIFIED GuestAgentModuleMetric_ModuleStatus = 0
	GuestAgentModuleMetric_STATUS_SKIPPED            GuestAgentModuleMetric_ModuleStatus = 1
	GuestAgentModuleMetric_STATUS_FAILED             GuestAgentModuleMetric_ModuleStatus = 2
	GuestAgentModuleMetric_STATUS_SUCCEEDED          GuestAgentModuleMetric_ModuleStatus = 3
)

// Enum value maps for GuestAgentModuleMetric_ModuleStatus.
var (
	GuestAgentModuleMetric_ModuleStatus_name = map[int32]string{
		0: "MODULE_STATUS_UNSPECIFIED",
		1: "STATUS_SKIPPED",
		2: "STATUS_FAILED",
		3: "STATUS_SUCCEEDED",
	}
	GuestAgentModuleMetric_ModuleStatus_value = map[string]int32{
		"MODULE_STATUS_UNSPECIFIED": 0,
		"STATUS_SKIPPED":            1,
		"STATUS_FAILED":             2,
		"STATUS_SUCCEEDED":          3,
	}
)

func (x GuestAgentModuleMetric_ModuleStatus) Enum() *GuestAgentModuleMetric_ModuleStatus {
	p := new(GuestAgentModuleMetric_ModuleStatus)
	*p = x
	return p
}

func (x GuestAgentModuleMetric_ModuleStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GuestAgentModuleMetric_ModuleStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_agent_controlplane_proto_enumTypes[5].Descriptor()
}

func (GuestAgentModuleMetric_ModuleStatus) Type() protoreflect.EnumType {
	return &file_agent_controlplane_proto_enumTypes[5]
}

func (x GuestAgentModuleMetric_ModuleStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GuestAgentModuleMetric_ModuleStatus.Descriptor instead.
func (GuestAgentModuleMetric_ModuleStatus) EnumDescriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{10, 1}
}

// PlatformInfo reports platform information based on a SMBIOS/DMI check.
type PlatformInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Whether the process is running on GCE, as determined by SMBIOS/DMI data
	// such as board_serial. For example, on Linux /sys/class/dmi/id/board_serial
	// or (Get-CimInstance -ClassName Win32_BaseBoard).SerialNumber is inspected.
	OnGce bool `protobuf:"varint,1,opt,name=on_gce,json=onGce,proto3" json:"on_gce,omitempty"`
	// Error message if SMBIOS/DMI data could not be read. Empty if successful.
	Error         string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlatformInfo) Reset() {
	*x = PlatformInfo{}
	mi := &file_agent_controlplane_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlatformInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformInfo) ProtoMessage() {}

func (x *PlatformInfo) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformInfo.ProtoReflect.Descriptor instead.
func (*PlatformInfo) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{0}
}

func (x *PlatformInfo) GetOnGce() bool {
	if x != nil {
		return x.OnGce
	}
	return false
}

func (x *PlatformInfo) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// Continuous State Enforcement system send the message to request agent
// information.
type GetAgentInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetAgentInfo) Reset() {
	*x = GetAgentInfo{}
	mi := &file_agent_controlplane_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAgentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAgentInfo) ProtoMessage() {}

func (x *GetAgentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAgentInfo.ProtoReflect.Descriptor instead.
func (*GetAgentInfo) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{1}
}

// Response from Guest Agent replying to GetAgentInfo
type AgentInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the agent.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the agent. e.g., "20230913.00"
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// The architecture of the agent. e.g., "amd64"
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// A list of agent capabilites.
	AgentCapabilities []AgentInfo_AgentCapability `protobuf:"varint,4,rep,packed,name=agent_capabilities,json=agentCapabilities,proto3,enum=agent_controlplane.AgentInfo_AgentCapability" json:"agent_capabilities,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *AgentInfo) Reset() {
	*x = AgentInfo{}
	mi := &file_agent_controlplane_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentInfo) ProtoMessage() {}

func (x *AgentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentInfo.ProtoReflect.Descriptor instead.
func (*AgentInfo) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{2}
}

func (x *AgentInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AgentInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AgentInfo) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *AgentInfo) GetAgentCapabilities() []AgentInfo_AgentCapability {
	if x != nil {
		return x.AgentCapabilities
	}
	return nil
}

// Continuous State Enforcement system send the message to request OS
// information
type GetOSInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOSInfo) Reset() {
	*x = GetOSInfo{}
	mi := &file_agent_controlplane_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOSInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOSInfo) ProtoMessage() {}

func (x *GetOSInfo) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOSInfo.ProtoReflect.Descriptor instead.
func (*GetOSInfo) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{3}
}

// Response from Guest Agent replying to GetOSInfo
type OSInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the operating system for the VM. e.g., "linux" and "windows".
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Short name of the operating system. e.g., "rhel" and "windows".
	ShortName string `protobuf:"bytes,3,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// Long name of the operating system for the VM. e.g., "Red Hat Enterprise
	// Linux 9.2 (Plow)", "Windows Server 2022 Datacenter".
	LongName string `protobuf:"bytes,4,opt,name=long_name,json=longName,proto3" json:"long_name,omitempty"`
	// The version of this operating system. e.g., "9.2" for RHEL, "10.0.20348"
	// for Windows Server.
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	// The architecture of the operating system. e.g., "amd64"
	Architecture string `protobuf:"bytes,6,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Kernel release of the operating system.
	// e.g.,
	// "5.14.0-284.30.1.el9_2.x86_64" for Linux
	// "10.0.20348.1970" for Windows.
	KernelRelease string `protobuf:"bytes,7,opt,name=kernel_release,json=kernelRelease,proto3" json:"kernel_release,omitempty"`
	// Kernel verion of the operating system.
	// e.g.,
	// "#1 SMP PREEMPT_DYNAMIC Fri Aug 25 09:13:12 EDT 2023" for Linux
	// "10.0.20348.1970 (WinBuild.160101.0800)" for Windows.
	KernelVersion string `protobuf:"bytes,8,opt,name=kernel_version,json=kernelVersion,proto3" json:"kernel_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OSInfo) Reset() {
	*x = OSInfo{}
	mi := &file_agent_controlplane_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OSInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSInfo) ProtoMessage() {}

func (x *OSInfo) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSInfo.ProtoReflect.Descriptor instead.
func (*OSInfo) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{4}
}

func (x *OSInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *OSInfo) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *OSInfo) GetLongName() string {
	if x != nil {
		return x.LongName
	}
	return ""
}

func (x *OSInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *OSInfo) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *OSInfo) GetKernelRelease() string {
	if x != nil {
		return x.KernelRelease
	}
	return ""
}

func (x *OSInfo) GetKernelVersion() string {
	if x != nil {
		return x.KernelVersion
	}
	return ""
}

// Continuous State Enforcement system send the message to request plugin
// states.
type ListPluginStates struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPluginStates) Reset() {
	*x = ListPluginStates{}
	mi := &file_agent_controlplane_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPluginStates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPluginStates) ProtoMessage() {}

func (x *ListPluginStates) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPluginStates.ProtoReflect.Descriptor instead.
func (*ListPluginStates) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{5}
}

// Response from Guest Agent replying to ListPluginStates.
type CurrentPluginStates struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The states of all daemon plugins on the resource.
	DaemonPluginStates []*CurrentPluginStates_DaemonPluginState `protobuf:"bytes,1,rep,name=daemon_plugin_states,json=daemonPluginStates,proto3" json:"daemon_plugin_states,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *CurrentPluginStates) Reset() {
	*x = CurrentPluginStates{}
	mi := &file_agent_controlplane_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CurrentPluginStates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CurrentPluginStates) ProtoMessage() {}

func (x *CurrentPluginStates) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CurrentPluginStates.ProtoReflect.Descriptor instead.
func (*CurrentPluginStates) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{6}
}

func (x *CurrentPluginStates) GetDaemonPluginStates() []*CurrentPluginStates_DaemonPluginState {
	if x != nil {
		return x.DaemonPluginStates
	}
	return nil
}

// Continuous State Enforcement system send the message to ask the Guest Agent
// to configure different plugins. No response from Guest Agent is expected for
// this message. The system only waits for an acknowledgement from Agent
// Communication Service.
type ConfigurePluginStates struct {
	state            protoimpl.MessageState                   `protogen:"open.v1"`
	ConfigurePlugins []*ConfigurePluginStates_ConfigurePlugin `protobuf:"bytes,1,rep,name=configure_plugins,json=configurePlugins,proto3" json:"configure_plugins,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ConfigurePluginStates) Reset() {
	*x = ConfigurePluginStates{}
	mi := &file_agent_controlplane_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigurePluginStates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurePluginStates) ProtoMessage() {}

func (x *ConfigurePluginStates) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurePluginStates.ProtoReflect.Descriptor instead.
func (*ConfigurePluginStates) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{7}
}

func (x *ConfigurePluginStates) GetConfigurePlugins() []*ConfigurePluginStates_ConfigurePlugin {
	if x != nil {
		return x.ConfigurePlugins
	}
	return nil
}

type PluginEventMessage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// RevisionID is the ID of the plugin revision related to this event.
	RevisionId string `protobuf:"bytes,1,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// PluginName is the name of the plugin associated with this event.
	PluginName string `protobuf:"bytes,2,opt,name=plugin_name,json=pluginName,proto3" json:"plugin_name,omitempty"`
	// EventType categorizes the event (e.g., CRASH, STOP, START, INSTALL_FAILED).
	EventType PluginEventMessage_PluginEventType `protobuf:"varint,3,opt,name=event_type,json=eventType,proto3,enum=agent_controlplane.PluginEventMessage_PluginEventType" json:"event_type,omitempty"`
	// EventTimestamp records the time at which the event was generated by the
	// plugin. This timestamp reflects when the event actually happened in the
	// guest agent or plugin, not when it was received by ACS. It is critical for
	// understanding the sequence of events as they occurred on the agent or
	// within the plugin. If not explicitly set, control plane defaults to January
	// 1, 1970.
	EventTimestamp *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=event_timestamp,json=eventTimestamp,proto3" json:"event_timestamp,omitempty"`
	// EventDetails contains additional information about the event.
	// This could be a serialized format like JSON or a protocol buffer.
	EventDetails  []byte `protobuf:"bytes,5,opt,name=event_details,json=eventDetails,proto3,oneof" json:"event_details,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PluginEventMessage) Reset() {
	*x = PluginEventMessage{}
	mi := &file_agent_controlplane_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginEventMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginEventMessage) ProtoMessage() {}

func (x *PluginEventMessage) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginEventMessage.ProtoReflect.Descriptor instead.
func (*PluginEventMessage) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{8}
}

func (x *PluginEventMessage) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *PluginEventMessage) GetPluginName() string {
	if x != nil {
		return x.PluginName
	}
	return ""
}

func (x *PluginEventMessage) GetEventType() PluginEventMessage_PluginEventType {
	if x != nil {
		return x.EventType
	}
	return PluginEventMessage_PLUGIN_EVENT_TYPE_UNSPECIFIED
}

func (x *PluginEventMessage) GetEventTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTimestamp
	}
	return nil
}

func (x *PluginEventMessage) GetEventDetails() []byte {
	if x != nil {
		return x.EventDetails
	}
	return nil
}

type GuestAgentModuleMetrics struct {
	state         protoimpl.MessageState    `protogen:"open.v1"`
	Metrics       []*GuestAgentModuleMetric `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GuestAgentModuleMetrics) Reset() {
	*x = GuestAgentModuleMetrics{}
	mi := &file_agent_controlplane_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GuestAgentModuleMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestAgentModuleMetrics) ProtoMessage() {}

func (x *GuestAgentModuleMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestAgentModuleMetrics.ProtoReflect.Descriptor instead.
func (*GuestAgentModuleMetrics) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{9}
}

func (x *GuestAgentModuleMetrics) GetMetrics() []*GuestAgentModuleMetric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

type GuestAgentModuleMetric struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the metric.
	MetricName GuestAgentModuleMetric_Metric `protobuf:"varint,1,opt,name=metric_name,json=metricName,proto3,enum=agent_controlplane.GuestAgentModuleMetric_Metric" json:"metric_name,omitempty"`
	// Start time is the time the module initialization started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time is the time the module initialization ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Status is the status of the module initialization.
	ModuleStatus GuestAgentModuleMetric_ModuleStatus `protobuf:"varint,4,opt,name=module_status,json=moduleStatus,proto3,enum=agent_controlplane.GuestAgentModuleMetric_ModuleStatus" json:"module_status,omitempty"`
	// Enabled indicates whether the module is enabled by customer in the VM or
	// not.
	Enabled bool `protobuf:"varint,5,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Error is the error of the module initialization if it failed.
	// Empty if module initialization succeeded.
	Error         string `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GuestAgentModuleMetric) Reset() {
	*x = GuestAgentModuleMetric{}
	mi := &file_agent_controlplane_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GuestAgentModuleMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestAgentModuleMetric) ProtoMessage() {}

func (x *GuestAgentModuleMetric) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestAgentModuleMetric.ProtoReflect.Descriptor instead.
func (*GuestAgentModuleMetric) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{10}
}

func (x *GuestAgentModuleMetric) GetMetricName() GuestAgentModuleMetric_Metric {
	if x != nil {
		return x.MetricName
	}
	return GuestAgentModuleMetric_MODULE_UNSPECIFIED
}

func (x *GuestAgentModuleMetric) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *GuestAgentModuleMetric) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *GuestAgentModuleMetric) GetModuleStatus() GuestAgentModuleMetric_ModuleStatus {
	if x != nil {
		return x.ModuleStatus
	}
	return GuestAgentModuleMetric_MODULE_STATUS_UNSPECIFIED
}

func (x *GuestAgentModuleMetric) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *GuestAgentModuleMetric) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type CurrentPluginStates_DaemonPluginState struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the plugin. e.g., "sap-hana-01"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A randomly generated 8 digit hexa string for current plugin. e.g.,
	// "67C5640D"
	CurrentRevisionId string `protobuf:"bytes,2,opt,name=current_revision_id,json=currentRevisionId,proto3" json:"current_revision_id,omitempty"`
	// Status of the current plugin.
	CurrentPluginStatus *CurrentPluginStates_DaemonPluginState_Status `protobuf:"bytes,3,opt,name=current_plugin_status,json=currentPluginStatus,proto3" json:"current_plugin_status,omitempty"`
	// The revision id for the pending plugin. If this pending revision is
	// installed and running, the field value should be empty and
	// current_revision_id should be updated and status set to RUNNING. If
	// there's an error during the process, this value should remain as is and
	// the pending_revision_status should update to an error status.
	PendingRevisionId string `protobuf:"bytes,4,opt,name=pending_revision_id,json=pendingRevisionId,proto3" json:"pending_revision_id,omitempty"`
	// Status of the pending plugin. Available only if pending_revision_id has a
	// value
	PendingPluginStatus *CurrentPluginStates_DaemonPluginState_Status `protobuf:"bytes,5,opt,name=pending_plugin_status,json=pendingPluginStatus,proto3" json:"pending_plugin_status,omitempty"`
	// The metrics of the current plugin.
	CurrentPluginMetrics []*CurrentPluginStates_DaemonPluginState_Metric `protobuf:"bytes,6,rep,name=current_plugin_metrics,json=currentPluginMetrics,proto3" json:"current_plugin_metrics,omitempty"`
	// The hash of the config applied to the plugin during the last start.
	ConfigHash    string `protobuf:"bytes,7,opt,name=config_hash,json=configHash,proto3" json:"config_hash,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CurrentPluginStates_DaemonPluginState) Reset() {
	*x = CurrentPluginStates_DaemonPluginState{}
	mi := &file_agent_controlplane_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CurrentPluginStates_DaemonPluginState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CurrentPluginStates_DaemonPluginState) ProtoMessage() {}

func (x *CurrentPluginStates_DaemonPluginState) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CurrentPluginStates_DaemonPluginState.ProtoReflect.Descriptor instead.
func (*CurrentPluginStates_DaemonPluginState) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{6, 0}
}

func (x *CurrentPluginStates_DaemonPluginState) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CurrentPluginStates_DaemonPluginState) GetCurrentRevisionId() string {
	if x != nil {
		return x.CurrentRevisionId
	}
	return ""
}

func (x *CurrentPluginStates_DaemonPluginState) GetCurrentPluginStatus() *CurrentPluginStates_DaemonPluginState_Status {
	if x != nil {
		return x.CurrentPluginStatus
	}
	return nil
}

func (x *CurrentPluginStates_DaemonPluginState) GetPendingRevisionId() string {
	if x != nil {
		return x.PendingRevisionId
	}
	return ""
}

func (x *CurrentPluginStates_DaemonPluginState) GetPendingPluginStatus() *CurrentPluginStates_DaemonPluginState_Status {
	if x != nil {
		return x.PendingPluginStatus
	}
	return nil
}

func (x *CurrentPluginStates_DaemonPluginState) GetCurrentPluginMetrics() []*CurrentPluginStates_DaemonPluginState_Metric {
	if x != nil {
		return x.CurrentPluginMetrics
	}
	return nil
}

func (x *CurrentPluginStates_DaemonPluginState) GetConfigHash() string {
	if x != nil {
		return x.ConfigHash
	}
	return ""
}

type CurrentPluginStates_DaemonPluginState_Status struct {
	state  protoimpl.MessageState                            `protogen:"open.v1"`
	Status CurrentPluginStates_DaemonPluginState_StatusValue `protobuf:"varint,1,opt,name=status,proto3,enum=agent_controlplane.CurrentPluginStates_DaemonPluginState_StatusValue" json:"status,omitempty"`
	// The response code returned when agent checks plugin health.
	// Zero indicates running normally. Non-zero code indicates an error.  If
	// it's a non-fatal error, the status value should be RUNNING.
	ResponseCode int32 `protobuf:"varint,2,opt,name=response_code,json=responseCode,proto3" json:"response_code,omitempty"`
	// A result message returned when agent checks plugin health explaining
	// potential error reasons.
	Results []string `protobuf:"bytes,3,rep,name=results,proto3" json:"results,omitempty"`
	// The time when the agent checks plugin health and gets the
	// response_code.
	UpdateTime    *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CurrentPluginStates_DaemonPluginState_Status) Reset() {
	*x = CurrentPluginStates_DaemonPluginState_Status{}
	mi := &file_agent_controlplane_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CurrentPluginStates_DaemonPluginState_Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CurrentPluginStates_DaemonPluginState_Status) ProtoMessage() {}

func (x *CurrentPluginStates_DaemonPluginState_Status) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CurrentPluginStates_DaemonPluginState_Status.ProtoReflect.Descriptor instead.
func (*CurrentPluginStates_DaemonPluginState_Status) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{6, 0, 0}
}

func (x *CurrentPluginStates_DaemonPluginState_Status) GetStatus() CurrentPluginStates_DaemonPluginState_StatusValue {
	if x != nil {
		return x.Status
	}
	return CurrentPluginStates_DaemonPluginState_STATE_VALUE_UNSPECIFIED
}

func (x *CurrentPluginStates_DaemonPluginState_Status) GetResponseCode() int32 {
	if x != nil {
		return x.ResponseCode
	}
	return 0
}

func (x *CurrentPluginStates_DaemonPluginState_Status) GetResults() []string {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *CurrentPluginStates_DaemonPluginState_Status) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The CPU and Memory usage of the plugin at a specific time.
type CurrentPluginStates_DaemonPluginState_Metric struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The time when the agent checks for metrics.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The value of the metric.
	// The recent CPU usage of the plugin.
	CpuUsage float32 `protobuf:"fixed32,6,opt,name=cpu_usage,json=cpuUsage,proto3" json:"cpu_usage,omitempty"`
	// The recent memory usage of the plugin.
	MemoryUsage   int64 `protobuf:"varint,7,opt,name=memory_usage,json=memoryUsage,proto3" json:"memory_usage,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CurrentPluginStates_DaemonPluginState_Metric) Reset() {
	*x = CurrentPluginStates_DaemonPluginState_Metric{}
	mi := &file_agent_controlplane_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CurrentPluginStates_DaemonPluginState_Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CurrentPluginStates_DaemonPluginState_Metric) ProtoMessage() {}

func (x *CurrentPluginStates_DaemonPluginState_Metric) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CurrentPluginStates_DaemonPluginState_Metric.ProtoReflect.Descriptor instead.
func (*CurrentPluginStates_DaemonPluginState_Metric) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{6, 0, 1}
}

func (x *CurrentPluginStates_DaemonPluginState_Metric) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *CurrentPluginStates_DaemonPluginState_Metric) GetCpuUsage() float32 {
	if x != nil {
		return x.CpuUsage
	}
	return 0
}

func (x *CurrentPluginStates_DaemonPluginState_Metric) GetMemoryUsage() int64 {
	if x != nil {
		return x.MemoryUsage
	}
	return 0
}

type ConfigurePluginStates_ConfigurePlugin struct {
	state         protoimpl.MessageState          `protogen:"open.v1"`
	Action        ConfigurePluginStates_Action    `protobuf:"varint,1,opt,name=action,proto3,enum=agent_controlplane.ConfigurePluginStates_Action" json:"action,omitempty"`
	Plugin        *ConfigurePluginStates_Plugin   `protobuf:"bytes,2,opt,name=plugin,proto3" json:"plugin,omitempty"`
	Manifest      *ConfigurePluginStates_Manifest `protobuf:"bytes,3,opt,name=manifest,proto3" json:"manifest,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigurePluginStates_ConfigurePlugin) Reset() {
	*x = ConfigurePluginStates_ConfigurePlugin{}
	mi := &file_agent_controlplane_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigurePluginStates_ConfigurePlugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurePluginStates_ConfigurePlugin) ProtoMessage() {}

func (x *ConfigurePluginStates_ConfigurePlugin) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurePluginStates_ConfigurePlugin.ProtoReflect.Descriptor instead.
func (*ConfigurePluginStates_ConfigurePlugin) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ConfigurePluginStates_ConfigurePlugin) GetAction() ConfigurePluginStates_Action {
	if x != nil {
		return x.Action
	}
	return ConfigurePluginStates_ACTION_UNSPECIFIED
}

func (x *ConfigurePluginStates_ConfigurePlugin) GetPlugin() *ConfigurePluginStates_Plugin {
	if x != nil {
		return x.Plugin
	}
	return nil
}

func (x *ConfigurePluginStates_ConfigurePlugin) GetManifest() *ConfigurePluginStates_Manifest {
	if x != nil {
		return x.Manifest
	}
	return nil
}

type ConfigurePluginStates_Plugin struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of the plugin. e.g., "sap-hana-01"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A system generated string.
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// The gcs signed url is passed to the Guest Agent to download the plugin
	// data. Continuous State Enforcement system gets the url from PDM.
	GcsSignedUrl string `protobuf:"bytes,3,opt,name=gcs_signed_url,json=gcsSignedUrl,proto3" json:"gcs_signed_url,omitempty"`
	// Path to the binary to execute in the plugin archive.
	EntryPoint string `protobuf:"bytes,4,opt,name=entry_point,json=entryPoint,proto3" json:"entry_point,omitempty"`
	// Arguments (subcommands or extra flags like "--foo=bar") to pass in when
	// launching the plugin process.
	//
	// For the payload sent to the plugin in the GuestAgentPlugin.Start()
	// request, see `config` below.
	Arguments []string `protobuf:"bytes,5,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// The SHA256 checksum of the plugin data.
	Checksum      string `protobuf:"bytes,6,opt,name=checksum,proto3" json:"checksum,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigurePluginStates_Plugin) Reset() {
	*x = ConfigurePluginStates_Plugin{}
	mi := &file_agent_controlplane_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigurePluginStates_Plugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurePluginStates_Plugin) ProtoMessage() {}

func (x *ConfigurePluginStates_Plugin) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurePluginStates_Plugin.ProtoReflect.Descriptor instead.
func (*ConfigurePluginStates_Plugin) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{7, 1}
}

func (x *ConfigurePluginStates_Plugin) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConfigurePluginStates_Plugin) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *ConfigurePluginStates_Plugin) GetGcsSignedUrl() string {
	if x != nil {
		return x.GcsSignedUrl
	}
	return ""
}

func (x *ConfigurePluginStates_Plugin) GetEntryPoint() string {
	if x != nil {
		return x.EntryPoint
	}
	return ""
}

func (x *ConfigurePluginStates_Plugin) GetArguments() []string {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *ConfigurePluginStates_Plugin) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

type ConfigurePluginStates_Manifest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The maximum allowed memory usage of the plugin in bytes.
	// If a plugin exceeds the memory usage, the guest agent would restart the
	// plugin.
	MaxMemoryUsageBytes int64 `protobuf:"varint,1,opt,name=max_memory_usage_bytes,json=maxMemoryUsageBytes,proto3" json:"max_memory_usage_bytes,omitempty"`
	// The maximum allowed percent CPU usage of the plugin.
	// This usage is the percentage of CPU cycles the plugin is allowed to use
	// per time period. If the plugin exceeds the quota, the plugin will be
	// throttled until the next time period.
	MaxCpuUsagePercentage int32 `protobuf:"varint,2,opt,name=max_cpu_usage_percentage,json=maxCpuUsagePercentage,proto3" json:"max_cpu_usage_percentage,omitempty"`
	// The interval with which to check the plugin's memory and CPU usage.
	MetricsInterval *durationpb.Duration `protobuf:"bytes,3,opt,name=metrics_interval,json=metricsInterval,proto3" json:"metrics_interval,omitempty"`
	// The timeout for downloading the plugin data.
	DownloadTimeout *durationpb.Duration `protobuf:"bytes,4,opt,name=download_timeout,json=downloadTimeout,proto3" json:"download_timeout,omitempty"`
	// The number of attempts for downloading the plugin data.
	DownloadAttemptCount int32 `protobuf:"varint,5,opt,name=download_attempt_count,json=downloadAttemptCount,proto3" json:"download_attempt_count,omitempty"`
	// The timeout to wait for a plugin to start running.
	StartTimeout *durationpb.Duration `protobuf:"bytes,6,opt,name=start_timeout,json=startTimeout,proto3" json:"start_timeout,omitempty"`
	// The number of attempts for starting a plugin.
	StartAttemptCount int32 `protobuf:"varint,7,opt,name=start_attempt_count,json=startAttemptCount,proto3" json:"start_attempt_count,omitempty"`
	// The timeout to wait for a plugin to stop running.
	// If the timeout is exceeded, the guest agent will force kill the process
	// so no stop attempts needed.
	StopTimeout *durationpb.Duration `protobuf:"bytes,8,opt,name=stop_timeout,json=stopTimeout,proto3" json:"stop_timeout,omitempty"`
	// Maximum number of datapoints to collect/return. If count reaches this
	// limit before metrics are flushed then oldest datapoints are purged.
	MaxMetricDatapoints uint64 `protobuf:"varint,9,opt,name=max_metric_datapoints,json=maxMetricDatapoints,proto3" json:"max_metric_datapoints,omitempty"`
	// This is any additional payload handed off to the plugin on every start
	// request. Payload is optional and defined by the service and plugin
	// itself.
	//
	// Types that are valid to be assigned to Config:
	//
	//	*ConfigurePluginStates_Manifest_StringConfig
	//	*ConfigurePluginStates_Manifest_StructConfig
	Config isConfigurePluginStates_Manifest_Config `protobuf_oneof:"config"`
	// The exponential backoff factor for retrying a failed action.
	// If the value is 2, then the first retry will be 1 second, the second
	// retry will be 2 seconds, the third retry will be 4 seconds, etc.
	StartExpBackoffFactor int32 `protobuf:"varint,12,opt,name=start_exp_backoff_factor,json=startExpBackoffFactor,proto3" json:"start_exp_backoff_factor,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ConfigurePluginStates_Manifest) Reset() {
	*x = ConfigurePluginStates_Manifest{}
	mi := &file_agent_controlplane_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigurePluginStates_Manifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigurePluginStates_Manifest) ProtoMessage() {}

func (x *ConfigurePluginStates_Manifest) ProtoReflect() protoreflect.Message {
	mi := &file_agent_controlplane_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigurePluginStates_Manifest.ProtoReflect.Descriptor instead.
func (*ConfigurePluginStates_Manifest) Descriptor() ([]byte, []int) {
	return file_agent_controlplane_proto_rawDescGZIP(), []int{7, 2}
}

func (x *ConfigurePluginStates_Manifest) GetMaxMemoryUsageBytes() int64 {
	if x != nil {
		return x.MaxMemoryUsageBytes
	}
	return 0
}

func (x *ConfigurePluginStates_Manifest) GetMaxCpuUsagePercentage() int32 {
	if x != nil {
		return x.MaxCpuUsagePercentage
	}
	return 0
}

func (x *ConfigurePluginStates_Manifest) GetMetricsInterval() *durationpb.Duration {
	if x != nil {
		return x.MetricsInterval
	}
	return nil
}

func (x *ConfigurePluginStates_Manifest) GetDownloadTimeout() *durationpb.Duration {
	if x != nil {
		return x.DownloadTimeout
	}
	return nil
}

func (x *ConfigurePluginStates_Manifest) GetDownloadAttemptCount() int32 {
	if x != nil {
		return x.DownloadAttemptCount
	}
	return 0
}

func (x *ConfigurePluginStates_Manifest) GetStartTimeout() *durationpb.Duration {
	if x != nil {
		return x.StartTimeout
	}
	return nil
}

func (x *ConfigurePluginStates_Manifest) GetStartAttemptCount() int32 {
	if x != nil {
		return x.StartAttemptCount
	}
	return 0
}

func (x *ConfigurePluginStates_Manifest) GetStopTimeout() *durationpb.Duration {
	if x != nil {
		return x.StopTimeout
	}
	return nil
}

func (x *ConfigurePluginStates_Manifest) GetMaxMetricDatapoints() uint64 {
	if x != nil {
		return x.MaxMetricDatapoints
	}
	return 0
}

func (x *ConfigurePluginStates_Manifest) GetConfig() isConfigurePluginStates_Manifest_Config {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ConfigurePluginStates_Manifest) GetStringConfig() string {
	if x != nil {
		if x, ok := x.Config.(*ConfigurePluginStates_Manifest_StringConfig); ok {
			return x.StringConfig
		}
	}
	return ""
}

func (x *ConfigurePluginStates_Manifest) GetStructConfig() *structpb.Struct {
	if x != nil {
		if x, ok := x.Config.(*ConfigurePluginStates_Manifest_StructConfig); ok {
			return x.StructConfig
		}
	}
	return nil
}

func (x *ConfigurePluginStates_Manifest) GetStartExpBackoffFactor() int32 {
	if x != nil {
		return x.StartExpBackoffFactor
	}
	return 0
}

type isConfigurePluginStates_Manifest_Config interface {
	isConfigurePluginStates_Manifest_Config()
}

type ConfigurePluginStates_Manifest_StringConfig struct {
	// String configuration. Any string payload that the plugin understands.
	StringConfig string `protobuf:"bytes,10,opt,name=string_config,json=stringConfig,proto3,oneof"`
}

type ConfigurePluginStates_Manifest_StructConfig struct {
	// Struct configuration. Usually used for reading file based configuration
	// like JSON or yaml.
	StructConfig *structpb.Struct `protobuf:"bytes,11,opt,name=struct_config,json=structConfig,proto3,oneof"`
}

func (*ConfigurePluginStates_Manifest_StringConfig) isConfigurePluginStates_Manifest_Config() {}

func (*ConfigurePluginStates_Manifest_StructConfig) isConfigurePluginStates_Manifest_Config() {}

var File_agent_controlplane_proto protoreflect.FileDescriptor

var file_agent_controlplane_proto_rawDesc = string([]byte{
	0x0a, 0x18, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70,
	0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3b, 0x0a,
	0x0c, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x15, 0x0a,
	0x06, 0x6f, 0x6e, 0x5f, 0x67, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6f,
	0x6e, 0x47, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x0e, 0x0a, 0x0c, 0x47, 0x65,
	0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xe4, 0x02, 0x0a, 0x09, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x5c, 0x0a, 0x12, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x11, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0xa6, 0x01, 0x0a, 0x0f, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x20, 0x0a, 0x1c,
	0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12,
	0x0a, 0x0e, 0x47, 0x45, 0x54, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x46, 0x4f,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x45, 0x54, 0x5f, 0x4f, 0x53, 0x5f, 0x49, 0x4e, 0x46,
	0x4f, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x50, 0x4c, 0x55, 0x47,
	0x49, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x53, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x53, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x50, 0x50, 0x4c,
	0x59, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10,
	0x05, 0x22, 0x0b, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x4f, 0x53, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xe4,
	0x01, 0x0a, 0x06, 0x4f, 0x53, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6c, 0x6f, 0x6e, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6b, 0x65, 0x72, 0x6e, 0x65,
	0x6c, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x12, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x22, 0x90, 0x09, 0x0a, 0x13, 0x43, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x73, 0x12, 0x6b, 0x0a, 0x14, 0x64, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x5f, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70,
	0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x12, 0x64, 0x61, 0x65, 0x6d,
	0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x1a, 0x8b,
	0x08, 0x0a, 0x11, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x74, 0x0a, 0x15, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x43, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73,
	0x2e, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x13, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2e,
	0x0a, 0x13, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x65, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x74,
	0x0a, 0x15, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61,
	0x6e, 0x65, 0x2e, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x13, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x76, 0x0a, 0x16, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x44, 0x61,
	0x65, 0x6d, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x14, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x61, 0x73, 0x68, 0x1a, 0xe3, 0x01,
	0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5d, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x43, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x73, 0x2e, 0x44, 0x61, 0x65, 0x6d, 0x6f, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0x82, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x38,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x52, 0x08, 0x63, 0x70, 0x75,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0b,
	0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x43,
	0x52, 0x41, 0x53, 0x48, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4c, 0x4c, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x22, 0xc7, 0x0a, 0x0a,
	0x15, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x66, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x10, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x1a, 0xf5,
	0x01, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x12, 0x48, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x06,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e,
	0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x06,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x4e, 0x0a, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65,
	0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x08, 0x6d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x1a, 0xbe, 0x01, 0x0a, 0x06, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x67, 0x63, 0x73, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x1f, 0x0a, 0x0b,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1c, 0x0a,
	0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x1a, 0xc6, 0x05, 0x0a, 0x08, 0x4d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x6d, 0x61, 0x78,
	0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x6d, 0x61, 0x78,
	0x43, 0x70, 0x75, 0x55, 0x73, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
	0x67, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x44, 0x0a, 0x10, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x34,
	0x0a, 0x16, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14,
	0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x61, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x70, 0x54, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x61, 0x74, 0x61,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a,
	0x0d, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52,
	0x0c, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x0a,
	0x18, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x6f,
	0x66, 0x66, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x15, 0x73, 0x74, 0x61, 0x72, 0x74, 0x45, 0x78, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66,
	0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x44, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x41,
	0x50, 0x50, 0x4c, 0x59, 0x10, 0x03, 0x22, 0xa2, 0x05, 0x0a, 0x12, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f,
	0x0a, 0x0b, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x55, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x28, 0x0a, 0x0d, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0c, 0x48, 0x00, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x88, 0x01, 0x01, 0x22, 0xf1, 0x02, 0x0a, 0x0f, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x4c, 0x55,
	0x47, 0x49, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15,
	0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x55, 0x47, 0x49,
	0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x10,
	0x02, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x4c, 0x55, 0x47, 0x49,
	0x4e, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x50,
	0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x12, 0x0a, 0x0e, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45,
	0x44, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x43, 0x52,
	0x41, 0x53, 0x48, 0x45, 0x44, 0x10, 0x07, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x4c, 0x55, 0x47, 0x49,
	0x4e, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x50,
	0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x10, 0x0b, 0x12, 0x19,
	0x0a, 0x15, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f,
	0x41, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x10, 0x0c, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55,
	0x47, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x59,
	0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x0d, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x5f, 0x0a, 0x17, 0x47,
	0x75, 0x65, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x44, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x47, 0x75, 0x65,
	0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xb9, 0x08, 0x0a,
	0x16, 0x47, 0x75, 0x65, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e,
	0x65, 0x2e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52,
	0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a,
	0x0d, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xde, 0x04, 0x0a, 0x06,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a,
	0x0a, 0x16, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41,
	0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x4f,
	0x53, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x4f, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x4c, 0x4f, 0x43, 0x4b,
	0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x04, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x5f, 0x49, 0x4e, 0x49,
	0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x1e, 0x0a,
	0x1a, 0x44, 0x49, 0x41, 0x47, 0x4e, 0x4f, 0x53, 0x54, 0x49, 0x43, 0x53, 0x5f, 0x49, 0x4e, 0x49,
	0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x1d, 0x0a,
	0x19, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x49, 0x54,
	0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x07, 0x12, 0x1c, 0x0a, 0x18,
	0x48, 0x4f, 0x53, 0x54, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41,
	0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x23, 0x0a, 0x1f, 0x4d, 0x45,
	0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x53, 0x48, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x49,
	0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x09, 0x12,
	0x1b, 0x0a, 0x17, 0x4f, 0x53, 0x5f, 0x4c, 0x4f, 0x47, 0x49, 0x4e, 0x5f, 0x49, 0x4e, 0x49, 0x54,
	0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x12, 0x1e, 0x0a, 0x1a,
	0x50, 0x4c, 0x41, 0x54, 0x5f, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x5f, 0x49, 0x4e, 0x49, 0x54,
	0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0b, 0x12, 0x1b, 0x0a, 0x17,
	0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c,
	0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0c, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x45, 0x4c,
	0x45, 0x4d, 0x45, 0x54, 0x52, 0x59, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0d, 0x12, 0x28, 0x0a, 0x24, 0x57, 0x4f, 0x52, 0x4b, 0x4c,
	0x4f, 0x41, 0x44, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x5f, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48,
	0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x0e, 0x12, 0x24, 0x0a, 0x20, 0x57, 0x53, 0x46, 0x43, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48,
	0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0f, 0x12, 0x1a, 0x0a, 0x16, 0x57, 0x49, 0x4e, 0x44, 0x4f,
	0x57, 0x53, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x45,
	0x54, 0x10, 0x10, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4f, 0x52, 0x45, 0x5f, 0x50, 0x4c, 0x55, 0x47,
	0x49, 0x4e, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x11, 0x12, 0x27, 0x0a, 0x23, 0x47, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x43, 0x4f, 0x4d,
	0x50, 0x41, 0x54, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x49, 0x54,
	0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x12, 0x22, 0x6a, 0x0a, 0x0c,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1d, 0x0a, 0x19,
	0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x42, 0x18, 0x5a, 0x16, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x67, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x61,
	0x63, 0x70, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_agent_controlplane_proto_rawDescOnce sync.Once
	file_agent_controlplane_proto_rawDescData []byte
)

func file_agent_controlplane_proto_rawDescGZIP() []byte {
	file_agent_controlplane_proto_rawDescOnce.Do(func() {
		file_agent_controlplane_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_agent_controlplane_proto_rawDesc), len(file_agent_controlplane_proto_rawDesc)))
	})
	return file_agent_controlplane_proto_rawDescData
}

var file_agent_controlplane_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_agent_controlplane_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_agent_controlplane_proto_goTypes = []any{
	(AgentInfo_AgentCapability)(0),                         // 0: agent_controlplane.AgentInfo.AgentCapability
	(CurrentPluginStates_DaemonPluginState_StatusValue)(0), // 1: agent_controlplane.CurrentPluginStates.DaemonPluginState.StatusValue
	(ConfigurePluginStates_Action)(0),                      // 2: agent_controlplane.ConfigurePluginStates.Action
	(PluginEventMessage_PluginEventType)(0),                // 3: agent_controlplane.PluginEventMessage.PluginEventType
	(GuestAgentModuleMetric_Metric)(0),                     // 4: agent_controlplane.GuestAgentModuleMetric.Metric
	(GuestAgentModuleMetric_ModuleStatus)(0),               // 5: agent_controlplane.GuestAgentModuleMetric.ModuleStatus
	(*PlatformInfo)(nil),                                   // 6: agent_controlplane.PlatformInfo
	(*GetAgentInfo)(nil),                                   // 7: agent_controlplane.GetAgentInfo
	(*AgentInfo)(nil),                                      // 8: agent_controlplane.AgentInfo
	(*GetOSInfo)(nil),                                      // 9: agent_controlplane.GetOSInfo
	(*OSInfo)(nil),                                         // 10: agent_controlplane.OSInfo
	(*ListPluginStates)(nil),                               // 11: agent_controlplane.ListPluginStates
	(*CurrentPluginStates)(nil),                            // 12: agent_controlplane.CurrentPluginStates
	(*ConfigurePluginStates)(nil),                          // 13: agent_controlplane.ConfigurePluginStates
	(*PluginEventMessage)(nil),                             // 14: agent_controlplane.PluginEventMessage
	(*GuestAgentModuleMetrics)(nil),                        // 15: agent_controlplane.GuestAgentModuleMetrics
	(*GuestAgentModuleMetric)(nil),                         // 16: agent_controlplane.GuestAgentModuleMetric
	(*CurrentPluginStates_DaemonPluginState)(nil),          // 17: agent_controlplane.CurrentPluginStates.DaemonPluginState
	(*CurrentPluginStates_DaemonPluginState_Status)(nil),   // 18: agent_controlplane.CurrentPluginStates.DaemonPluginState.Status
	(*CurrentPluginStates_DaemonPluginState_Metric)(nil),   // 19: agent_controlplane.CurrentPluginStates.DaemonPluginState.Metric
	(*ConfigurePluginStates_ConfigurePlugin)(nil),          // 20: agent_controlplane.ConfigurePluginStates.ConfigurePlugin
	(*ConfigurePluginStates_Plugin)(nil),                   // 21: agent_controlplane.ConfigurePluginStates.Plugin
	(*ConfigurePluginStates_Manifest)(nil),                 // 22: agent_controlplane.ConfigurePluginStates.Manifest
	(*timestamppb.Timestamp)(nil),                          // 23: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                            // 24: google.protobuf.Duration
	(*structpb.Struct)(nil),                                // 25: google.protobuf.Struct
}
var file_agent_controlplane_proto_depIdxs = []int32{
	0,  // 0: agent_controlplane.AgentInfo.agent_capabilities:type_name -> agent_controlplane.AgentInfo.AgentCapability
	17, // 1: agent_controlplane.CurrentPluginStates.daemon_plugin_states:type_name -> agent_controlplane.CurrentPluginStates.DaemonPluginState
	20, // 2: agent_controlplane.ConfigurePluginStates.configure_plugins:type_name -> agent_controlplane.ConfigurePluginStates.ConfigurePlugin
	3,  // 3: agent_controlplane.PluginEventMessage.event_type:type_name -> agent_controlplane.PluginEventMessage.PluginEventType
	23, // 4: agent_controlplane.PluginEventMessage.event_timestamp:type_name -> google.protobuf.Timestamp
	16, // 5: agent_controlplane.GuestAgentModuleMetrics.metrics:type_name -> agent_controlplane.GuestAgentModuleMetric
	4,  // 6: agent_controlplane.GuestAgentModuleMetric.metric_name:type_name -> agent_controlplane.GuestAgentModuleMetric.Metric
	23, // 7: agent_controlplane.GuestAgentModuleMetric.start_time:type_name -> google.protobuf.Timestamp
	23, // 8: agent_controlplane.GuestAgentModuleMetric.end_time:type_name -> google.protobuf.Timestamp
	5,  // 9: agent_controlplane.GuestAgentModuleMetric.module_status:type_name -> agent_controlplane.GuestAgentModuleMetric.ModuleStatus
	18, // 10: agent_controlplane.CurrentPluginStates.DaemonPluginState.current_plugin_status:type_name -> agent_controlplane.CurrentPluginStates.DaemonPluginState.Status
	18, // 11: agent_controlplane.CurrentPluginStates.DaemonPluginState.pending_plugin_status:type_name -> agent_controlplane.CurrentPluginStates.DaemonPluginState.Status
	19, // 12: agent_controlplane.CurrentPluginStates.DaemonPluginState.current_plugin_metrics:type_name -> agent_controlplane.CurrentPluginStates.DaemonPluginState.Metric
	1,  // 13: agent_controlplane.CurrentPluginStates.DaemonPluginState.Status.status:type_name -> agent_controlplane.CurrentPluginStates.DaemonPluginState.StatusValue
	23, // 14: agent_controlplane.CurrentPluginStates.DaemonPluginState.Status.update_time:type_name -> google.protobuf.Timestamp
	23, // 15: agent_controlplane.CurrentPluginStates.DaemonPluginState.Metric.timestamp:type_name -> google.protobuf.Timestamp
	2,  // 16: agent_controlplane.ConfigurePluginStates.ConfigurePlugin.action:type_name -> agent_controlplane.ConfigurePluginStates.Action
	21, // 17: agent_controlplane.ConfigurePluginStates.ConfigurePlugin.plugin:type_name -> agent_controlplane.ConfigurePluginStates.Plugin
	22, // 18: agent_controlplane.ConfigurePluginStates.ConfigurePlugin.manifest:type_name -> agent_controlplane.ConfigurePluginStates.Manifest
	24, // 19: agent_controlplane.ConfigurePluginStates.Manifest.metrics_interval:type_name -> google.protobuf.Duration
	24, // 20: agent_controlplane.ConfigurePluginStates.Manifest.download_timeout:type_name -> google.protobuf.Duration
	24, // 21: agent_controlplane.ConfigurePluginStates.Manifest.start_timeout:type_name -> google.protobuf.Duration
	24, // 22: agent_controlplane.ConfigurePluginStates.Manifest.stop_timeout:type_name -> google.protobuf.Duration
	25, // 23: agent_controlplane.ConfigurePluginStates.Manifest.struct_config:type_name -> google.protobuf.Struct
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_agent_controlplane_proto_init() }
func file_agent_controlplane_proto_init() {
	if File_agent_controlplane_proto != nil {
		return
	}
	file_agent_controlplane_proto_msgTypes[8].OneofWrappers = []any{}
	file_agent_controlplane_proto_msgTypes[16].OneofWrappers = []any{
		(*ConfigurePluginStates_Manifest_StringConfig)(nil),
		(*ConfigurePluginStates_Manifest_StructConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_agent_controlplane_proto_rawDesc), len(file_agent_controlplane_proto_rawDesc)),
			NumEnums:      6,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_agent_controlplane_proto_goTypes,
		DependencyIndexes: file_agent_controlplane_proto_depIdxs,
		EnumInfos:         file_agent_controlplane_proto_enumTypes,
		MessageInfos:      file_agent_controlplane_proto_msgTypes,
	}.Build()
	File_agent_controlplane_proto = out.File
	file_agent_controlplane_proto_goTypes = nil
	file_agent_controlplane_proto_depIdxs = nil
}
