#!/usr/bin/perl
# SPDX-License-Identifier: LGPL-3.0-or-later
#
# (c) 2020-2025 Hubert Figuière

use Image::ExifTool::Exif;
use Image::ExifTool::Apple;
use Image::ExifTool::Canon;
use Image::ExifTool::DJI;
use Image::ExifTool::FujiFilm;
use Image::ExifTool::Minolta;
use Image::ExifTool::Nikon;
use Image::ExifTool::Olympus;
use Image::ExifTool::Panasonic;
use Image::ExifTool::PanasonicRaw;
use Image::ExifTool::Pentax;
use Image::ExifTool::Ricoh;
use Image::ExifTool::Sigma;
use Image::ExifTool::Sony;

#
# Output the tag table
#
sub output_table($$) {
    my ($table, $table_name) = @_;
    my @keys = grep { /^[\d]*$/ } keys(%$table);

    print("lazy_static::lazy_static! {\n");
    print("/// Exif tag names\n");
    printf "pub static ref %s: TagMap = HashMap::from([\n", uc $table_name;

    foreach $tag (sort { $a <=> $b } @keys) {

        my $value = %$table{$tag};

        my $name;
        if (ref $value eq ref {}) {
            $name = %$value{'Name'};
        } elsif (ref $value eq ref []) {
            $item = @$value[0];
            $name = %$item{'Name'};
        } else {
            $name = $value;
        }
        printf "    ( 0x%x, \"%s\" ),\n", $tag, $name;
    }
    print "    ]);\n";
    print "}\n\n";
}

# Override Olympus to add missing tags.
my %item = (
    Name => 'EsponWB',
);
$Image::ExifTool::Olympus::Main{0xe80} = \%item;

# The MakerNote tag is an array for the various type of Maker Notes
# This throw off the algorithm. So, override.
my %item2 = (
    Name => 'MakerNote',
);
$Image::ExifTool::Exif::Main{0x927c} = \%item2;

# It has different name depending on context.
# But DNGPrivateData is the official one.
# It is meant to host the Maker Notes.
my %item3 = (
    Name => 'DNGPrivateData',
);
$Image::ExifTool::Exif::Main{0xc634} = \%item3;

printf "// AUTOGENERATED with ExifTool %s (%s)\n\n", $Image::ExifTool::VERSION, $Image::ExifTool::RELEASE;
print "//! This contain the tag names generated from ExifTool.\n\n";
print "use std::collections::HashMap;\n";
print "\n";
print "use crate::tiff::exif::TagMap;\n";

output_table(\%Image::ExifTool::Exif::Main, "exif_tag_names");
output_table(\%Image::ExifTool::GPS::Main, "gpsinfo_tag_names");
output_table(\%Image::ExifTool::Apple::Main, "mnote_apple_tag_names");
output_table(\%Image::ExifTool::Canon::Main, "mnote_canon_tag_names");
output_table(\%Image::ExifTool::FujiFilm::Main, "mnote_fujifilm_tag_names");
# This is not an IFD.
# output_table(\%Image::ExifTool::FujiFilm::RAF, "mnote_fujifilm_raf_tag_names");
output_table(\%Image::ExifTool::FujiFilm::IFD, "mnote_fujifilm_rawifd_tag_names");
output_table(\%Image::ExifTool::Minolta::Main, "mnote_minolta_tag_names");
output_table(\%Image::ExifTool::Nikon::Main, "mnote_nikon_tag_names");
output_table(\%Image::ExifTool::Nikon::Type2, "mnote_nikon2_tag_names");
output_table(\%Image::ExifTool::Olympus::Main, "mnote_olympus_tag_names");
output_table(\%Image::ExifTool::Olympus::Equipment, "mnote_olympus_eq_tag_names");
output_table(\%Image::ExifTool::Olympus::CameraSettings, "mnote_olympus_cs_tag_names");
output_table(\%Image::ExifTool::Olympus::RawDevelopment, "mnote_olympus_rd_tag_names");
output_table(\%Image::ExifTool::Olympus::RawDevelopment2, "mnote_olympus_rd2_tag_names");
output_table(\%Image::ExifTool::Olympus::ImageProcessing, "mnote_olympus_ip_tag_names");
output_table(\%Image::ExifTool::Olympus::FocusInfo, "mnote_olympus_fi_tag_names");
output_table(\%Image::ExifTool::Olympus::RawInfo, "mnote_olympus_ri_tag_names");
output_table(\%Image::ExifTool::Panasonic::Main, "mnote_panasonic_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica2, "mnote_leica2_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica3, "mnote_leica3_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica4, "mnote_leica4_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica5, "mnote_leica5_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica6, "mnote_leica6_tag_names");
output_table(\%Image::ExifTool::Panasonic::Leica9, "mnote_leica9_tag_names");
output_table(\%Image::ExifTool::Pentax::Main, "mnote_pentax_tag_names");
output_table(\%Image::ExifTool::Ricoh::Main, "mnote_ricoh_tag_names");
output_table(\%Image::ExifTool::Sigma::Main, "mnote_sigma_tag_names");
output_table(\%Image::ExifTool::Sony::Main, "mnote_sony_tag_names");
output_table(\%Image::ExifTool::DJI::Main, "mnote_dji_tag_names");

output_table(\%Image::ExifTool::PanasonicRaw::Main, "raw_panasonic_tag_names");
output_table(\%Image::ExifTool::PanasonicRaw::CameraIFD, "raw_panasonic_cameraifd_tag_names");
print "// END AUTOGENERATED\n";
