// Copyright 2016 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/xfa_basic_data.h"

#include "xfa/fxfa/fxfa_basic.h"

const XFA_ELEMENTHIERARCHY g_XFAElementPropertyIndex[] = {
    {0, 8},    {8, 0},   {8, 14},   {22, 0},   {22, 0},   {22, 6},   {28, 0},
    {28, 0},   {28, 1},  {29, 3},   {32, 0},   {32, 0},   {32, 0},   {32, 3},
    {35, 1},   {36, 0},  {36, 0},   {36, 2},   {38, 0},   {38, 0},   {38, 0},
    {38, 4},   {42, 0},  {42, 0},   {42, 1},   {43, 0},   {43, 8},   {51, 19},
    {70, 0},   {70, 0},  {70, 2},   {72, 1},   {73, 0},   {73, 2},   {75, 4},
    {79, 1},   {80, 1},  {81, 0},   {81, 0},   {81, 3},   {84, 0},   {84, 4},
    {88, 4},   {92, 1},  {93, 0},   {93, 4},   {97, 9},   {106, 14}, {120, 0},
    {120, 0},  {120, 5}, {125, 0},  {125, 1},  {126, 0},  {126, 0},  {126, 0},
    {126, 0},  {126, 0}, {126, 1},  {127, 0},  {127, 0},  {127, 0},  {127, 0},
    {127, 0},  {127, 0}, {127, 0},  {127, 6},  {133, 1},  {134, 0},  {134, 1},
    {135, 0},  {135, 0}, {135, 1},  {136, 2},  {138, 5},  {143, 2},  {145, 0},
    {145, 0},  {145, 0}, {145, 0},  {145, 0},  {145, 5},  {150, 0},  {150, 0},
    {150, 0},  {150, 0}, {150, 0},  {150, 0},  {150, 0},  {150, 2},  {152, 0},
    {152, 0},  {152, 0}, {152, 17}, {169, 0},  {169, 1},  {170, 0},  {170, 0},
    {170, 2},  {172, 0}, {172, 0},  {172, 1},  {173, 0},  {173, 0},  {173, 2},
    {175, 2},  {177, 0}, {177, 0},  {177, 0},  {177, 11}, {188, 0},  {188, 0},
    {188, 0},  {188, 0}, {188, 0},  {188, 4},  {192, 3},  {195, 0},  {195, 0},
    {195, 0},  {195, 0}, {195, 0},  {195, 0},  {195, 9},  {204, 0},  {204, 0},
    {204, 17}, {221, 0}, {221, 0},  {221, 0},  {221, 0},  {221, 0},  {221, 0},
    {221, 0},  {221, 0}, {221, 0},  {221, 4},  {225, 0},  {225, 0},  {225, 0},
    {225, 0},  {225, 2}, {227, 3},  {230, 0},  {230, 0},  {230, 2},  {232, 0},
    {232, 1},  {233, 2}, {235, 2},  {237, 0},  {237, 0},  {237, 2},  {239, 0},
    {239, 1},  {240, 1}, {241, 2},  {243, 0},  {243, 3},  {246, 4},  {250, 0},
    {250, 1},  {251, 2}, {253, 0},  {253, 0},  {253, 0},  {253, 0},  {253, 0},
    {253, 0},  {253, 0}, {253, 0},  {253, 0},  {253, 0},  {253, 2},  {255, 2},
    {257, 0},  {257, 6}, {263, 5},  {268, 0},  {268, 0},  {268, 0},  {268, 3},
    {271, 0},  {271, 0}, {271, 3},  {274, 4},  {278, 0},  {278, 0},  {278, 4},
    {282, 0},  {282, 0}, {282, 5},  {287, 0},  {287, 5},  {292, 0},  {292, 0},
    {292, 0},  {292, 1}, {293, 0},  {293, 0},  {293, 1},  {294, 0},  {294, 2},
    {296, 0},  {296, 0}, {296, 0},  {296, 0},  {296, 1},  {297, 0},  {297, 0},
    {297, 4},  {301, 0}, {301, 0},  {301, 0},  {301, 0},  {301, 0},  {301, 0},
    {301, 1},  {302, 0}, {302, 2},  {304, 0},  {304, 0},  {304, 0},  {304, 0},
    {304, 1},  {305, 4}, {309, 0},  {309, 3},  {312, 0},  {312, 0},  {312, 1},
    {313, 0},  {313, 8}, {321, 0},  {321, 10}, {331, 0},  {331, 10}, {341, 1},
    {342, 12}, {354, 3}, {357, 1},  {358, 0},  {358, 0},  {358, 0},  {358, 8},
    {366, 0},  {366, 0}, {366, 0},  {366, 0},  {366, 0},  {366, 0},  {366, 7},
    {373, 2},  {375, 0}, {375, 1},  {376, 0},  {376, 0},  {376, 0},  {376, 0},
    {376, 0},  {376, 0}, {376, 0},  {376, 0},  {376, 13}, {389, 0},  {389, 1},
    {390, 1},  {391, 0}, {391, 0},  {391, 3},  {394, 0},  {394, 0},  {394, 0},
    {394, 0},  {394, 0}, {394, 4},  {398, 9},  {407, 0},  {407, 1},  {408, 0},
    {408, 0},  {408, 0}, {408, 0},  {408, 0},  {408, 1},  {409, 0},  {409, 2},
    {411, 0},  {411, 0}, {411, 0},  {411, 0},  {411, 2},  {413, 0},  {413, 1},
    {414, 0},  {414, 0}, {414, 0},  {414, 7},  {421, 0},  {421, 1},  {422, 1},
    {423, 0},  {423, 1}, {424, 1},  {425, 0},  {425, 1},  {426, 0},  {426, 0},
    {426, 0},  {426, 0}, {426, 0},  {426, 0},
};

const XFA_PROPERTY g_XFAElementPropertyData[] = {
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Jog, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::OutputBin, 1, 0},
    {XFA_Element::Compress, 1, 0},
    {XFA_Element::Staple, 1, 0},
    {XFA_Element::MediumInfo, 1, 0},
    {XFA_Element::CheckButton, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::ChoiceList, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::DefaultUi, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Barcode, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Button, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::DateTimeEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::ImageEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::PasswordEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::NumericEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Signature, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::TextEdit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::ExObject, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Break, 1, 0},
    {XFA_Element::Overflow, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Bookend, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::SubsetBelow, 1, 0},
    {XFA_Element::Map, 1, 0},
    {XFA_Element::Embed, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::DatePattern, 4, 0},
    {XFA_Element::Edge, 1, 0},
    {XFA_Element::Fill, 1, 0},
    {XFA_Element::To, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Mode, 1, 0},
    {XFA_Element::Threshold, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Jog, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::PageOffset, 1, 0},
    {XFA_Element::OutputBin, 1, 0},
    {XFA_Element::Staple, 1, 0},
    {XFA_Element::MediumInfo, 1, 0},
    {XFA_Element::AdobeExtensionLevel, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::Pdfa, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::ViewerPreferences, 1, 0},
    {XFA_Element::ScriptModel, 1, 0},
    {XFA_Element::Version, 1, 0},
    {XFA_Element::SubmitFormat, 1, 0},
    {XFA_Element::SilentPrint, 1, 0},
    {XFA_Element::Producer, 1, 0},
    {XFA_Element::Compression, 1, 0},
    {XFA_Element::Interactive, 1, 0},
    {XFA_Element::Encryption, 1, 0},
    {XFA_Element::RenderPolicy, 1, 0},
    {XFA_Element::OpenAction, 1, 0},
    {XFA_Element::Creator, 1, 0},
    {XFA_Element::Linearized, 1, 0},
    {XFA_Element::Tagged, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Xsl, 1, 0},
    {XFA_Element::Packets, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Debug, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::FlipLabel, 1, 0},
    {XFA_Element::TemplateCache, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::BatchOutput, 1, 0},
    {XFA_Element::FlipLabel, 1, 0},
    {XFA_Element::EraNames, 1, 0},
    {XFA_Element::DayNames, 2, 0},
    {XFA_Element::MeridiemNames, 1, 0},
    {XFA_Element::MonthNames, 2, 0},
    {XFA_Element::Hyphenation, 1, 0},
    {XFA_Element::Amd, 1, 0},
    {XFA_Element::Part, 1, 0},
    {XFA_Element::IncludeXDPContent, 1, 0},
    {XFA_Element::Conformance, 1, 0},
    {XFA_Element::Mdp, 1, 0},
    {XFA_Element::Certificates, 1, 0},
    {XFA_Element::TimeStamp, 1, 0},
    {XFA_Element::Handler, 1, 0},
    {XFA_Element::DigestMethods, 1, 0},
    {XFA_Element::Encodings, 1, 0},
    {XFA_Element::Reasons, 1, 0},
    {XFA_Element::AppearanceFilter, 1, 0},
    {XFA_Element::LockDocument, 1, 0},
    {XFA_Element::Xdp, 1, 0},
    {XFA_Element::Cache, 1, 0},
    {XFA_Element::Pagination, 1, 0},
    {XFA_Element::Overprint, 1, 0},
    {XFA_Element::BehaviorOverride, 1, 0},
    {XFA_Element::Copies, 1, 0},
    {XFA_Element::Output, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::Layout, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Common, 1, 0},
    {XFA_Element::PaginationOverride, 1, 0},
    {XFA_Element::Destination, 1, 0},
    {XFA_Element::IncrementalMerge, 1, 0},
    {XFA_Element::Execute, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Script, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::SignData, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Submit, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::CurrencySymbol, 3, 0},
    {XFA_Element::Operation, 1, 0},
    {XFA_Element::WsdlAddress, 1, 0},
    {XFA_Element::SoapAddress, 1, 0},
    {XFA_Element::SoapAction, 1, 0},
    {XFA_Element::EffectiveOutputPolicy, 1, 0},
    {XFA_Element::EffectiveInputPolicy, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Era, 2, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Edge, 4, 0},
    {XFA_Element::Corner, 4, 0},
    {XFA_Element::Fill, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::KeyUsage, 1, 0},
    {XFA_Element::SubjectDNs, 1, 0},
    {XFA_Element::Issuers, 1, 0},
    {XFA_Element::Signing, 1, 0},
    {XFA_Element::Oids, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Ui, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Format, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Assist, 1, 0},
    {XFA_Element::Traversal, 1, 0},
    {XFA_Element::Keep, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::Caption, 1, 0},
    {XFA_Element::Bind, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Font, 1, 0},
    {XFA_Element::Value, 1, 0},
    {XFA_Element::Calculate, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Items, 2, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Assist, 1, 0},
    {XFA_Element::Traversal, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::Caption, 1, 0},
    {XFA_Element::Bind, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Calculate, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Comb, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Present, 1, 0},
    {XFA_Element::Acrobat, 1, 0},
    {XFA_Element::Trace, 1, 0},
    {XFA_Element::PrintScaling, 1, 0},
    {XFA_Element::Enforce, 1, 0},
    {XFA_Element::NumberOfCopies, 1, 0},
    {XFA_Element::PageRange, 1, 0},
    {XFA_Element::AddViewerPreferences, 1, 0},
    {XFA_Element::ADBE_JSConsole, 1, 0},
    {XFA_Element::DuplexOption, 1, 0},
    {XFA_Element::ADBE_JSDebugger, 1, 0},
    {XFA_Element::PickTrayByPDFSize, 1, 0},
    {XFA_Element::Break, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Assist, 1, 0},
    {XFA_Element::Traversal, 1, 0},
    {XFA_Element::Keep, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::PageSet, 1, 0},
    {XFA_Element::Overflow, 1, 0},
    {XFA_Element::Bind, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Bookend, 1, 0},
    {XFA_Element::Calculate, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Variables, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Query, 1, 0},
    {XFA_Element::Insert, 1, 0},
    {XFA_Element::Update, 1, 0},
    {XFA_Element::Delete, 1, 0},
    {XFA_Element::MsgId, 1, 0},
    {XFA_Element::Severity, 1, 0},
    {XFA_Element::To, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Type, 1, 0},
    {XFA_Element::ToolTip, 1, 0},
    {XFA_Element::Speak, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::AddSilentPrint, 1, 0},
    {XFA_Element::PrinterName, 1, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::RecordSet, 1, 0},
    {XFA_Element::Select, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Message, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::NumberPattern, 4, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::RootElement, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Xsl, 1, 0},
    {XFA_Element::StartPage, 1, 0},
    {XFA_Element::Relevant, 1, 0},
    {XFA_Element::Base, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::AutoSave, 1, 0},
    {XFA_Element::Validate, 1, 0},
    {XFA_Element::ValidateApprovalSignatures, 1, 0},
    {XFA_Element::Acrobat7, 1, 0},
    {XFA_Element::Common, 1, 0},
    {XFA_Element::Exclude, 1, 0},
    {XFA_Element::CurrentPage, 1, 0},
    {XFA_Element::RunScripts, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Comb, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Medium, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Filter, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Manifest, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Font, 1, 0},
    {XFA_Element::Value, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Day, 7, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Occur, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Comb, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Filter, 1, 0},
    {XFA_Element::Manifest, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::Level, 1, 0},
    {XFA_Element::Type, 1, 0},
    {XFA_Element::CompressObjectStream, 1, 0},
    {XFA_Element::CompressLogicalStructure, 1, 0},
    {XFA_Element::Edge, 4, 0},
    {XFA_Element::Corner, 4, 0},
    {XFA_Element::Fill, 1, 0},
    {XFA_Element::DynamicRender, 1, 0},
    {XFA_Element::DatePatterns, 1, 0},
    {XFA_Element::CalendarSymbols, 1, 0},
    {XFA_Element::CurrencySymbols, 1, 0},
    {XFA_Element::Typefaces, 1, 0},
    {XFA_Element::DateTimeSymbols, 1, 0},
    {XFA_Element::NumberPatterns, 1, 0},
    {XFA_Element::NumberSymbols, 1, 0},
    {XFA_Element::TimePatterns, 1, 0},
    {XFA_Element::Uri, 1, 0},
    {XFA_Element::Xsl, 1, 0},
    {XFA_Element::StartNode, 1, 0},
    {XFA_Element::OutputXSL, 1, 0},
    {XFA_Element::AdjustData, 1, 0},
    {XFA_Element::Attributes, 1, 0},
    {XFA_Element::Window, 1, 0},
    {XFA_Element::Record, 1, 0},
    {XFA_Element::Range, 1, 0},
    {XFA_Element::IncrementalLoad, 1, 0},
    {XFA_Element::Text, 1, 0},
    {XFA_Element::Time, 1, 0},
    {XFA_Element::DateTime, 1, 0},
    {XFA_Element::Image, 1, 0},
    {XFA_Element::Decimal, 1, 0},
    {XFA_Element::Boolean, 1, 0},
    {XFA_Element::Integer, 1, 0},
    {XFA_Element::ExData, 1, 0},
    {XFA_Element::Date, 1, 0},
    {XFA_Element::Float, 1, 0},
    {XFA_Element::Certificate, 1, 0},
    {XFA_Element::Ui, 1, 0},
    {XFA_Element::Margin, 1, 0},
    {XFA_Element::Para, 1, 0},
    {XFA_Element::Border, 1, 0},
    {XFA_Element::Assist, 1, 0},
    {XFA_Element::Traversal, 1, 0},
    {XFA_Element::Keep, 1, 0},
    {XFA_Element::Caption, 1, 0},
    {XFA_Element::Desc, 1, 0},
    {XFA_Element::Font, 1, 0},
    {XFA_Element::Value, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::EncryptionLevel, 1, 0},
    {XFA_Element::Encrypt, 1, 0},
    {XFA_Element::Permissions, 1, 0},
    {XFA_Element::Meridiem, 2, 0},
    {XFA_Element::SuppressBanner, 1, 0},
    {XFA_Element::VersionControl, 1, 0},
    {XFA_Element::LocaleSet, 1, 0},
    {XFA_Element::Template, 1, 0},
    {XFA_Element::ValidationMessaging, 1, 0},
    {XFA_Element::Locale, 1, 0},
    {XFA_Element::Data, 1, 0},
    {XFA_Element::Messaging, 1, 0},
    {XFA_Element::Pattern, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Solid, 1,
     XFA_PROPERTYFLAG_OneOf | XFA_PROPERTYFLAG_DefaultOneOf},
    {XFA_Element::Stipple, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Linear, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Radial, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Fill, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Map, 1, 0},
    {XFA_Element::Arc, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Text, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Time, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::DateTime, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Image, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Decimal, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Boolean, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Integer, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::ExData, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Rectangle, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Date, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Float, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Line, 1, XFA_PROPERTYFLAG_OneOf},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Destination, 1, 0},
    {XFA_Element::Message, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::ConnectString, 1, 0},
    {XFA_Element::User, 1, 0},
    {XFA_Element::Password, 1, 0},
    {XFA_Element::ModifyAnnots, 1, 0},
    {XFA_Element::ContentCopy, 1, 0},
    {XFA_Element::FormFieldFilling, 1, 0},
    {XFA_Element::Change, 1, 0},
    {XFA_Element::AccessibleContent, 1, 0},
    {XFA_Element::Print, 1, 0},
    {XFA_Element::PlaintextMetadata, 1, 0},
    {XFA_Element::PrintHighQuality, 1, 0},
    {XFA_Element::DocumentAssembly, 1, 0},
    {XFA_Element::Encrypt, 1, 0},
    {XFA_Element::NumberSymbol, 5, 0},
    {XFA_Element::FontInfo, 1, 0},
    {XFA_Element::Xdc, 1, 0},
    {XFA_Element::Color, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::TimePattern, 4, 0},
    {XFA_Element::Whitespace, 1, 0},
    {XFA_Element::Rename, 1, 0},
    {XFA_Element::IfEmpty, 1, 0},
    {XFA_Element::Presence, 1, 0},
    {XFA_Element::Picture, 1, 0},
    {XFA_Element::NameAttr, 1, 0},
    {XFA_Element::GroupParent, 1, 0},
    {XFA_Element::Script, 1, 0},
    {XFA_Element::Edge, 1, 0},
    {XFA_Element::Connect, 1, 0},
    {XFA_Element::Extras, 1, 0},
    {XFA_Element::Month, 12, 0},
};
