# python2/Sage script used to create the package
# (needs porting to python3 Sage)
import urllib
import gzip
import StringIO
from re import match,findall

# the following URL is gone, but may be found on archive.org
# webfile=urllib.urlopen("http://cage.ugent.be/~jdemeyer/cunningham/main.gz")
webfile=urllib.request.urlopen("https://web.archive.org/web/20190315214633/http://cage.ugent.be/~jdemeyer/cunningham/main.gz")
localfile=StringIO.StringIO(webfile.read())
data = gzip.GzipFile(fileobj=localfile)

L = []

for line in data:
    l=match("\(.*\)( .*)",line).groups()
    if len(l[0])>0:
        L += map(Integer,findall("[ \.]([1234567890]+)",l[0]))

# I add the factorisation of (2^4096-1) because I use it

L += [
    3, 
    5,
    17,
    257,
    641,
    65537,
    274177,
    319489,
    974849,
    2424833,
    6700417,
    45592577,
    6487031809,
    67280421310721,
    1238926361552897,
    59649589127497217,
    167988556341760475137,
    5704689200685129054721,
    3560841906445833920513,
    4659775785220018543264560743076778192897,
    7455602825647884208337395736200454918783366342657,
    93461639715357977769163558199606896584051237541638188580280321,
    741640062627530801524787141901937474059940781097519023905821316144415759504705008092818711693940737,
    130439874405488189727484768796509903946608530841611892186895295776832416251471863574140227977573104895898783928842923844831149032913798729088601617946094119449010595906710130531906171018354491609619193912488538116080712299672322806217820753127014424577,
    173462447179147555430258970864309778377421844723664084649347019061363579192879108857591038330408837177983810868451546421940712978306134189864280826014542758708589243873685563973118948869399158545506611147420216132557017260564139394366945793220968665108959685482705388072645828554151936401912464931182546092879815733057795573358504982279280090942872567591518912118622751714319229788100979251036035496917279912663527358783236647193154777091427745377038294584918917590325110939381322486044298573971650711059244462177542540706913047034664643603491382441723306598834177
]

#sort and unique
cunningham_prime_factors = sorted(list(set(L)))

F = file("cunningham_prime_factors.sobj","w")
F.write(dumps(cunningham_prime_factors))
F.close()
