/*
 * rsyncrypto - an rsync friendly encryption
 * Copyright (C) 2008 Shachar Shemesh for Lingnu Open Source Consulting ltd.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * In addition, as a special exception, the rsyncrypto authors give permission
 * to link the code of this program with the OpenSSL library (or with modified
 * versions of OpenSSL that use the same license as OpenSSL), and distribute
 * linked combinations including the two. You must obey the GNU General Public
 * License in all respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version of the file,
 * but you are not obligated to do so. If you do not wish to do so, delete this
 * exception statement from your version.
 *
 * The project's homepage is at http://rsyncrypto.lingnu.com/
 */

// This is a quick and dirty implementation, designed to plug the corrupted
// files potentially generated by rsyncrypto version 1.07 and 1.08
// The implementation is neither clean nor complete, just "good enough"

#include <precomp.h>

static void usage()
{
    std::cerr<<"rsyncrypto_recover: Recover corrupted rsyncrypto file maps"<<std::endl<<
        "Usage: rsyncrypto_recover filename > good_file"<<std::endl;
    exit(0);
}

struct file_record {
    char dirsep;
    char crypt[32];
    std::string plain;
};

int main( int argc, char *argv[] )
{
    int ret=0;
    if( argc!=2 )
        usage();

    try {
        autofd fd(argv[1], O_RDONLY);
        autommap map(fd, PROT_READ);
    
        size_t offset=0;
        enum {DIRSEP, CIPHERNAME, SPACE, PLAINNAME, INVALID, RSYNC107_INVALID} state=DIRSEP;
        int line_state=0;
        file_record record;

        while( offset<map.getsize() ) {
            unsigned char ch=map.get_uc()[offset];
            switch( state ) {
            case DIRSEP:
                record.plain="";

                // The dir separator may either be a slash or a backslash
                if( ch=='/' || ch=='\\' ) {
                    record.dirsep=ch;
                    state=CIPHERNAME;
                    line_state=0;
                } else if( ch=='\0' ) {
                    std::cerr<<"Offset "<<offset<<": Rsyncrypto 1.07 corrupted record - safetly discarded"<<std::endl;
                } else if( ch==' ' ) {
                    state=RSYNC107_INVALID;
                } else {
                    state=INVALID;
                    std::cerr<<"Offset "<<offset<<": Invalid dir separator char '"<<ch<<"'"<<std::endl;
                }
                break;
            case CIPHERNAME:
                if( (ch>='0' && ch<='9') || (ch>='A' && ch<='F') ) {
                    record.crypt[line_state]=ch;

                    // A legal hexadecimal character
                    if( (++line_state)==32 ) {
                        state=SPACE;
                    }
                } else {
                    std::cerr<<"Offset "<<offset<<": Invalid character '"<<ch<<"' in crypt name area"<<std::endl;
                    state=INVALID;
                }
                break;
            case SPACE:
                if( ch==' ' )
                    state=PLAINNAME;
                else {
                    std::cerr<<"Offset "<<offset<<": Got a '"<<ch<<"' instead of a space"<<std::endl;
                    state=INVALID;
                }
                break;
            case PLAINNAME:
                if( ch!='\0' ) {
                    record.plain+=ch;
                } else {
                    if( record.plain.length()!=0 ) {
                        // Everything is ok - print the correct record
                        std::cout<<record.dirsep<<std::string(record.crypt,32)<<" "<<record.plain<<'\0';
                        std::cerr<<"Successfully recovered data for "<<record.plain<<std::endl;
                    } else {
                        std::cerr<<"Offset "<<offset<<": Plain name for cipher "<<std::string(record.crypt,32)<<" is empty"<<std::endl;
                    }

                    state=DIRSEP;
                }
                break;
            case INVALID:
                break;
            case RSYNC107_INVALID:
                if( ch=='\0' ) {
                    std::cerr<<"Offset "<<offset<<": Rsyncrypto 1.07 corrupted record - safetly discarded"<<std::endl;
                    state=DIRSEP;
                } else {
                    state=INVALID;
                    std::cerr<<"Offset "<<offset-1<<": Invalid dir separator char ' '"<<std::endl;
                }
                break;
            }

            if( state==INVALID && ch=='\0' ) {
                state=DIRSEP;
            }

            offset++;
        }

        if( state!=DIRSEP ) {
            std::cerr<<"Last record is either corrupt or truncated"<<std::endl;
        }
    } catch( const rscerror &err ) {
        std::cerr<<err.error()<<std::endl;
        ret=1;
    }

    return ret;
}
