/* Capstone Disassembly Engine, http://www.capstone-engine.org */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2013-2022, */
/*    Rot127 <unisono@quyllur.org> 2022-2023 */
/* Automatically translated source file from LLVM. */

/* LLVM-commit: <commit> */
/* LLVM-tag: <tag> */

/* Only small edits allowed. */
/* For multiple similar edits, please create a Patch for the translator. */

/* Capstone's C++ file translator: */
/* https://github.com/capstone-engine/capstone/tree/next/suite/auto-sync */

//===- PPCInstPrinter.h - Convert PPC MCInst to assembly syntax -*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This class prints an PPC MCInst to a .s file.
//
//===----------------------------------------------------------------------===//

#ifndef CS_PPC_INSTPRINTER_H
#define CS_PPC_INSTPRINTER_H

#include <capstone/platform.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../../LEB128.h"
#include "../../MCDisassembler.h"
#include "../../MCInst.h"
#include "../../MCInstrDesc.h"
#include "../../MCRegisterInfo.h"
#include "../../SStream.h"
#include "PPCMCTargetDesc.h"
#define CONCAT(a, b) CONCAT_(a, b)
#define CONCAT_(a, b) a##_##b

bool showRegistersWithPercentPrefix(const MCInst *MI, const char *RegName);
bool showRegistersWithPrefix(const MCInst *MI);
// Autogenerated by tblgen.
void printATBitsAsHint(MCInst *MI, unsigned OpNo, SStream *O);
void printU1ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU2ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU3ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU4ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printS5ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU5ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU6ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU7ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU8ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU10ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU12ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printS12ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printS16ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printS34ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printU16ImmOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printImmZeroOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printBranchOperand(MCInst *MI, uint64_t Address, unsigned OpNo,
			SStream *O);
void printAbsBranchOperand(MCInst *MI, unsigned OpNo, SStream *O);
void printTLSCall(MCInst *MI, unsigned OpNo, SStream *O);
void printcrbitm(MCInst *MI, unsigned OpNo, SStream *O);
void printMemRegImm(MCInst *MI, unsigned OpNo, SStream *O);
void printMemRegImmPS(MCInst *MI, unsigned OpNo, SStream *O);
void printMemRegImmHash(MCInst *MI, unsigned OpNo, SStream *O);
void printMemRegImm34PCRel(MCInst *MI, unsigned OpNo, SStream *O);
void printMemRegImm34(MCInst *MI, unsigned OpNo, SStream *O);
void printMemRegReg(MCInst *MI, unsigned OpNo, SStream *O);
;
// end namespace llvm

#endif // CS_PPC_INSTPRINTER_H
