% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene2biologicalprocess.R
\name{gene2biologicalprocess}
\alias{gene2biologicalprocess}
\title{Query for given gene(s) and generates an \code{DataGeNET.RDF}}
\usage{
gene2biologicalprocess(gene, verbose = FALSE, warnings = TRUE)
}
\arguments{
\item{gene}{NCBI gene ID}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to don't see
the warnings.}
}
\value{
An object of class \code{DataGeNET.RDF}
}
\description{
Given a NCBI gene identifier, retrieves the GO (Gene Ontology) information
related to biological processes where the gene product is involved and creates
an object of type \code{DataGeNET.RDF}.
}
\examples{
gene2bp <- gene2biologicalprocess( gene = 1588 )
}
