% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringQCreport.R
\docType{methods}
\name{makeQCReport,RccSet-method}
\alias{makeQCReport,RccSet-method}
\alias{makeQCReport}
\title{Make NanoString QC report}
\usage{
\S4method{makeQCReport}{RccSet}(rccSet,
  outputBaseName = "NanoStringQCPro_QC_report", outputDir = getwd(),
  preprocOverride = FALSE,
  experimentTitle = expinfo(experimentData(rccSet))["title"],
  covar = "SampleType", method = c("cutoffByMMAD", "cutoffByVar"),
  stringency = 4, maxMiss = 0.2, sampleNameCol = "SampleID",
  heatmaps = FALSE, cleanMarkdown = TRUE, verbose = FALSE)
}
\arguments{
\item{rccSet}{RccSet object for which to generate the QC report.}

\item{outputBaseName}{Character string specifying the base filename (without extension) to use
for the output file.}

\item{outputDir}{Character string specifying the path to the output directory for the QC
report and associated files.}

\item{preprocOverride}{Logical. If TRUE, the input's preprocessing will be ignored, and a default
preprocessing configuration (specifically, the defaults for
preprocRccSet()) will be applied so that all applicable plots can be
rendered in the report.}

\item{experimentTitle}{Character string specifying an easy to read identifier of the experiment.}

\item{covar}{Character string specifying a covariate for stratifying samples (e.g.
"SampleType").}

\item{method}{Method to determine outlier samples: either "cutoffByVar" or
"cutoffByMMAD".}

\item{stringency}{Multiplier with which to adjust cutoff values for determining outlier
samples.}

\item{maxMiss}{Numeric specifying the allowable fraction of genes below the lower limit
of detection in a sample.}

\item{sampleNameCol}{Character string specifying the name of the phenoData column holding the
sample names.}

\item{heatmaps}{Logical: render and show heatmaps?}

\item{cleanMarkdown}{Logical: upon completion, delete markdown files used to produce QC report?}

\item{verbose}{Logical: print progress messages?}
}
\value{
An html report is written to disk and a copy of the input RccSet is
invisibly returned with columns added to phenoData that show the QC flags
for each sample.
}
\description{
Creates an html QC report for an RccSet object. Alongside the html file, a
directory with matching filename is produced that contains additional files
as well as high resolution versions of the various plots in the report.
In addition to generating the QC report, the function returns a copy of the
input RccSet with columns added to phenoData that show the QC flags for each
sample.

The various plots in the report depend upon correct annotation and
preprocessing in the input object. If the input is missing any elements
required for a given plot, the plot will be replaced with a message
indicating the missing elements. If the preprocOverride argument is set to
TRUE, the input's preprocessing will be ignored and a default configuration
will be used so that all applicable plots will be rendered.
}
\examples{
data(example_rccSet)
norm_example_rccSet <- preprocRccSet(example_rccSet)
qc_example_rccSet <- makeQCReport(norm_example_rccSet, "example_QC_report")

}
\author{
Dorothee Nickles, Thomas Sandmann, Robert Ziman, Richard Bourgon
}
