# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class JobList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the JobList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.preview.bulk_exports.export.job.JobList
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobList
        """
        super(JobList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, job_sid):
        """
        Constructs a JobContext

        :param job_sid: The unique string that that we created to identify the Bulk Export job

        :returns: twilio.rest.preview.bulk_exports.export.job.JobContext
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobContext
        """
        return JobContext(self._version, job_sid=job_sid, )

    def __call__(self, job_sid):
        """
        Constructs a JobContext

        :param job_sid: The unique string that that we created to identify the Bulk Export job

        :returns: twilio.rest.preview.bulk_exports.export.job.JobContext
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobContext
        """
        return JobContext(self._version, job_sid=job_sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.BulkExports.JobList>'


class JobPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the JobPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.preview.bulk_exports.export.job.JobPage
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobPage
        """
        super(JobPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of JobInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.bulk_exports.export.job.JobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobInstance
        """
        return JobInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.BulkExports.JobPage>'


class JobContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, job_sid):
        """
        Initialize the JobContext

        :param Version version: Version that contains the resource
        :param job_sid: The unique string that that we created to identify the Bulk Export job

        :returns: twilio.rest.preview.bulk_exports.export.job.JobContext
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobContext
        """
        super(JobContext, self).__init__(version)

        # Path Solution
        self._solution = {'job_sid': job_sid, }
        self._uri = '/Exports/Jobs/{job_sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the JobInstance

        :returns: The fetched JobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return JobInstance(self._version, payload, job_sid=self._solution['job_sid'], )

    def delete(self):
        """
        Deletes the JobInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.BulkExports.JobContext {}>'.format(context)


class JobInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, job_sid=None):
        """
        Initialize the JobInstance

        :returns: twilio.rest.preview.bulk_exports.export.job.JobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobInstance
        """
        super(JobInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'resource_type': payload.get('resource_type'),
            'friendly_name': payload.get('friendly_name'),
            'details': payload.get('details'),
            'start_day': payload.get('start_day'),
            'end_day': payload.get('end_day'),
            'job_sid': payload.get('job_sid'),
            'webhook_url': payload.get('webhook_url'),
            'webhook_method': payload.get('webhook_method'),
            'email': payload.get('email'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'job_sid': job_sid or self._properties['job_sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: JobContext for this JobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobContext
        """
        if self._context is None:
            self._context = JobContext(self._version, job_sid=self._solution['job_sid'], )
        return self._context

    @property
    def resource_type(self):
        """
        :returns: The type of communication – Messages, Calls, Conferences, and Participants
        :rtype: unicode
        """
        return self._properties['resource_type']

    @property
    def friendly_name(self):
        """
        :returns: The friendly name specified when creating the job
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def details(self):
        """
        :returns: This is a list of the completed, pending, or errored dates within the export time range, with one entry for each status with more than one day in that status
        :rtype: dict
        """
        return self._properties['details']

    @property
    def start_day(self):
        """
        :returns: The start time for the export specified when creating the job
        :rtype: unicode
        """
        return self._properties['start_day']

    @property
    def end_day(self):
        """
        :returns: The end time for the export specified when creating the job
        :rtype: unicode
        """
        return self._properties['end_day']

    @property
    def job_sid(self):
        """
        :returns: The job_sid returned when the export was created
        :rtype: unicode
        """
        return self._properties['job_sid']

    @property
    def webhook_url(self):
        """
        :returns: The optional webhook url called on completion
        :rtype: unicode
        """
        return self._properties['webhook_url']

    @property
    def webhook_method(self):
        """
        :returns: This is the method used to call the webhook
        :rtype: unicode
        """
        return self._properties['webhook_method']

    @property
    def email(self):
        """
        :returns: The optional email to send the completion notification to
        :rtype: unicode
        """
        return self._properties['email']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the JobInstance

        :returns: The fetched JobInstance
        :rtype: twilio.rest.preview.bulk_exports.export.job.JobInstance
        """
        return self._proxy.fetch()

    def delete(self):
        """
        Deletes the JobInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.BulkExports.JobInstance {}>'.format(context)
