/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SW_INC_UNOPRNMS_HXX
#define INCLUDED_SW_INC_UNOPRNMS_HXX

#include <sal/config.h>

#include <rtl/ustring.hxx>

inline constexpr OUString UNO_NAME_FOLLOW_STYLE = u"FollowStyle"_ustr;
inline constexpr OUString UNO_NAME_LINK_STYLE = u"LinkStyle"_ustr;
inline constexpr OUString UNO_NAME_IS_PHYSICAL = u"IsPhysical"_ustr;
inline constexpr OUString UNO_NAME_IS_AUTO_UPDATE = u"IsAutoUpdate"_ustr;
inline constexpr OUString UNO_NAME_DISPLAY_NAME = u"DisplayName"_ustr;
inline constexpr OUString UNO_NAME_PARA_GRAPHIC = u"ParaBackGraphic"_ustr;
inline constexpr OUString UNO_NAME_PARA_GRAPHIC_URL = u"ParaBackGraphicURL"_ustr;
inline constexpr OUString UNO_NAME_PARA_GRAPHIC_FILTER = u"ParaBackGraphicFilter"_ustr;
inline constexpr OUString UNO_NAME_HEADER_GRAPHIC = u"HeaderBackGraphic"_ustr;
inline constexpr OUString UNO_NAME_HEADER_GRAPHIC_URL = u"HeaderBackGraphicURL"_ustr;
inline constexpr OUString UNO_NAME_HEADER_GRAPHIC_FILTER = u"HeaderBackGraphicFilter"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_GRAPHIC = u"FooterBackGraphic"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_GRAPHIC_URL = u"FooterBackGraphicURL"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_GRAPHIC_FILTER = u"FooterBackGraphicFilter"_ustr;
inline constexpr OUString UNO_NAME_BACK_GRAPHIC_URL = u"BackGraphicURL"_ustr;
inline constexpr OUString UNO_NAME_BACK_GRAPHIC = u"BackGraphic"_ustr;
inline constexpr OUString UNO_NAME_BACK_GRAPHIC_FILTER = u"BackGraphicFilter"_ustr;
inline constexpr OUString UNO_NAME_BACK_GRAPHIC_LOCATION = u"BackGraphicLocation"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC_FILTER = u"GraphicFilter"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC_SIZE = u"GraphicSize"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC_BITMAP = u"GraphicBitmap"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC_URL = u"GraphicURL"_ustr;
inline constexpr OUString UNO_NAME_BULLET_ID = u"BulletId"_ustr;
inline constexpr OUString UNO_NAME_BULLET_CHAR = u"BulletChar"_ustr;
inline constexpr OUString UNO_NAME_BULLET_REL_SIZE = u"BulletRelSize"_ustr;
inline constexpr OUString UNO_NAME_BULLET_FONT = u"BulletFont"_ustr;
inline constexpr OUString UNO_NAME_BULLET_FONT_NAME = u"BulletFontName"_ustr;
inline constexpr OUString UNO_NAME_BULLET_COLOR = u"BulletColor"_ustr;
inline constexpr OUString UNO_NAME_PARA_GRAPHIC_LOCATION = u"ParaBackGraphicLocation"_ustr;
inline constexpr OUString UNO_NAME_HEADER_GRAPHIC_LOCATION = u"HeaderBackGraphicLocation"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_GRAPHIC_LOCATION = u"FooterBackGraphicLocation"_ustr;
inline constexpr OUString UNO_NAME_PARA_LEFT_MARGIN = u"ParaLeftMargin"_ustr;
inline constexpr OUString UNO_NAME_PARA_RIGHT_MARGIN = u"ParaRightMargin"_ustr;
inline constexpr OUString UNO_NAME_PARA_LEFT_MARGIN_RELATIVE = u"ParaLeftMarginRelative"_ustr;
inline constexpr OUString UNO_NAME_PARA_RIGHT_MARGIN_RELATIVE = u"ParaRightMarginRelative"_ustr;
inline constexpr OUString UNO_NAME_PARA_IS_AUTO_FIRST_LINE_INDENT
    = u"ParaIsAutoFirstLineIndent"_ustr;
inline constexpr OUString UNO_NAME_PARA_FIRST_LINE_INDENT = u"ParaFirstLineIndent"_ustr;
inline constexpr OUString UNO_NAME_PARA_FIRST_LINE_INDENT_RELATIVE
    = u"ParaFirstLineIndentRelative"_ustr;
inline constexpr OUString UNO_NAME_PARA_IS_HYPHENATION = u"ParaIsHyphenation"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_MAX_LEADING_CHARS
    = u"ParaHyphenationMaxLeadingChars"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_MAX_TRAILING_CHARS
    = u"ParaHyphenationMaxTrailingChars"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_COMPOUND_MIN_LEADING_CHARS
    = u"ParaHyphenationCompoundMinLeadingChars"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_MAX_HYPHENS = u"ParaHyphenationMaxHyphens"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_MIN_WORD_LENGTH
    = u"ParaHyphenationMinWordLength"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_ZONE = u"ParaHyphenationZone"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_NO_CAPS = u"ParaHyphenationNoCaps"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_NO_LAST_WORD
    = u"ParaHyphenationNoLastWord"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_KEEP = u"ParaHyphenationKeep"_ustr;
inline constexpr OUString UNO_NAME_PARA_HYPHENATION_KEEP_TYPE = u"ParaHyphenationKeepType"_ustr;
inline constexpr OUString UNO_NAME_LEFT_MARGIN = u"LeftMargin"_ustr;
inline constexpr OUString UNO_NAME_RIGHT_MARGIN = u"RightMargin"_ustr;
inline constexpr OUString UNO_NAME_GUTTER_MARGIN = u"GutterMargin"_ustr;
inline constexpr OUString UNO_NAME_HEADER_LEFT_MARGIN = u"HeaderLeftMargin"_ustr;
inline constexpr OUString UNO_NAME_HEADER_RIGHT_MARGIN = u"HeaderRightMargin"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_LEFT_MARGIN = u"FooterLeftMargin"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_RIGHT_MARGIN = u"FooterRightMargin"_ustr;
inline constexpr OUString UNO_NAME_TEXT_RANGE = u"TextRange"_ustr;
inline constexpr OUString UNO_NAME_TEXT_BOX = u"TextBox"_ustr;
inline constexpr OUString UNO_NAME_TEXT_BOX_CONTENT = u"TextBoxContent"_ustr;
inline constexpr OUString UNO_NAME_NAME = u"Name"_ustr;
inline constexpr OUString UNO_NAME_PARENT_NAME = u"ParentName"_ustr;
inline constexpr OUString UNO_NAME_CHAR_STYLE_NAME = u"CharStyleName"_ustr;
inline constexpr OUString UNO_NAME_ANCHOR_CHAR_STYLE_NAME = u"AnchorCharStyleName"_ustr;
inline constexpr OUString UNO_NAME_SUFFIX = u"Suffix"_ustr;
inline constexpr OUString UNO_NAME_PREFIX = u"Prefix"_ustr;
inline constexpr OUString UNO_NAME_LIST_FORMAT = u"ListFormat"_ustr;
inline constexpr OUString UNO_NAME_PARENT_NUMBERING = u"ParentNumbering"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_NAME = u"CharFontName"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_STYLE_NAME = u"CharFontStyleName"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_FAMILY = u"CharFontFamily"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_CHAR_SET = u"CharFontCharSet"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_PITCH = u"CharFontPitch"_ustr;
inline constexpr OUString UNO_NAME_CHAR_LOCALE = u"CharLocale"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_NAME_ASIAN = u"CharFontNameAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_STYLE_NAME_ASIAN = u"CharFontStyleNameAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_FAMILY_ASIAN = u"CharFontFamilyAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_CHAR_SET_ASIAN = u"CharFontCharSetAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_PITCH_ASIAN = u"CharFontPitchAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_POSTURE_ASIAN = u"CharPostureAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_WEIGHT_ASIAN = u"CharWeightAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_HEIGHT_ASIAN = u"CharHeightAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_LOCALE_ASIAN = u"CharLocaleAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_NAME_COMPLEX = u"CharFontNameComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_STYLE_NAME_COMPLEX = u"CharFontStyleNameComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_FAMILY_COMPLEX = u"CharFontFamilyComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_CHAR_SET_COMPLEX = u"CharFontCharSetComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_FONT_PITCH_COMPLEX = u"CharFontPitchComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_POSTURE_COMPLEX = u"CharPostureComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_WEIGHT_COMPLEX = u"CharWeightComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_HEIGHT_COMPLEX = u"CharHeightComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_LOCALE_COMPLEX = u"CharLocaleComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_AUTO_KERNING = u"CharAutoKerning"_ustr;
inline constexpr OUString UNO_NAME_CHAR_UNDERLINE_COLOR = u"CharUnderlineColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_UNDERLINE_COMPLEX_COLOR = u"CharUnderlineComplexColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_UNDERLINE_HAS_COLOR = u"CharUnderlineHasColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_ESCAPEMENT = u"CharEscapement"_ustr;
inline constexpr OUString UNO_NAME_CHAR_CASE_MAP = u"CharCaseMap"_ustr;
inline constexpr OUString UNO_NAME_CHAR_STRIKEOUT = u"CharStrikeout"_ustr;
inline constexpr OUString UNO_NAME_CHAR_CROSSED_OUT = u"CharCrossedOut"_ustr;
inline constexpr OUString UNO_NAME_CHAR_NO_HYPHENATION = u"CharNoHyphenation"_ustr;
inline constexpr OUString UNO_NAME_CHAR_AUTO_ESCAPEMENT = u"CharAutoEscapement"_ustr;
inline constexpr OUString UNO_NAME_CHAR_PROP_HEIGHT = u"CharPropHeight"_ustr;
inline constexpr OUString UNO_NAME_CHAR_DIFF_HEIGHT = u"CharDiffHeight"_ustr;
inline constexpr OUString UNO_NAME_CHAR_PROP_HEIGHT_ASIAN = u"CharPropHeightAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_DIFF_HEIGHT_ASIAN = u"CharDiffHeightAsian"_ustr;
inline constexpr OUString UNO_NAME_CHAR_PROP_HEIGHT_COMPLEX = u"CharPropHeightComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_DIFF_HEIGHT_COMPLEX = u"CharDiffHeightComplex"_ustr;
inline constexpr OUString UNO_NAME_CHAR_ESCAPEMENT_HEIGHT = u"CharEscapementHeight"_ustr;
inline constexpr OUString UNO_NAME_CHAR_TRANSPARENCE = u"CharTransparence"_ustr;
inline constexpr OUString UNO_NAME_HIDE_TAB_LEADER_AND_PAGE_NUMBERS
    = u"HideTabLeaderAndPageNumber"_ustr;
inline constexpr OUString UNO_NAME_TAB_IN_TOC = u"TabInTOC"_ustr;
inline constexpr OUString UNO_NAME_TOC_BOOKMARK = u"TOCBookmark"_ustr;
inline constexpr OUString UNO_NAME_TOC_NEWLINE = u"TOCNewLine"_ustr;
inline constexpr OUString UNO_NAME_TOC_PARAGRAPH_OUTLINE_LEVEL = u"TOCParagraphOutlineLevel"_ustr;

inline constexpr OUString UNO_NAME_CHAR_FLASH = u"CharFlash"_ustr;
inline constexpr OUString UNO_NAME_CHAR_KERNING = u"CharKerning"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BACK_COLOR = u"CharBackColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BACKGROUND_COMPLEX_COLOR
    = u"CharBackgroundComplexColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BACK_TRANSPARENT = u"CharBackTransparent"_ustr;
inline constexpr OUString UNO_NAME_CHAR_COMBINE_IS_ON = u"CharCombineIsOn"_ustr;
inline constexpr OUString UNO_NAME_CHAR_COMBINE_PREFIX = u"CharCombinePrefix"_ustr;
inline constexpr OUString UNO_NAME_CHAR_COMBINE_SUFFIX = u"CharCombineSuffix"_ustr;
inline constexpr OUString UNO_NAME_CHAR_EMPHASIS = u"CharEmphasis"_ustr;
inline constexpr OUString UNO_NAME_PARA_LINE_SPACING = u"ParaLineSpacing"_ustr;
inline constexpr OUString UNO_NAME_PARA_TOP_MARGIN = u"ParaTopMargin"_ustr;
inline constexpr OUString UNO_NAME_PARA_BOTTOM_MARGIN = u"ParaBottomMargin"_ustr;
inline constexpr OUString UNO_NAME_PARA_TOP_MARGIN_RELATIVE = u"ParaTopMarginRelative"_ustr;
inline constexpr OUString UNO_NAME_PARA_BOTTOM_MARGIN_RELATIVE = u"ParaBottomMarginRelative"_ustr;
inline constexpr OUString UNO_NAME_PARA_EXPAND_SINGLE_WORD = u"ParaExpandSingleWord"_ustr;
inline constexpr OUString UNO_NAME_END_NOTICE = u"EndNotice"_ustr;
inline constexpr OUString UNO_NAME_BEGIN_NOTICE = u"BeginNotice"_ustr;
inline constexpr OUString UNO_NAME_FRAME_STYLE_NAME = u"FrameStyleName"_ustr;
inline constexpr OUString UNO_NAME_NUMBERING_STYLE_NAME = u"NumberingStyleName"_ustr;
inline constexpr OUString UNO_NAME_NUMBERING_START_VALUE = u"NumberingStartValue"_ustr;
inline constexpr OUString UNO_NAME_NUMBERING_IS_NUMBER = u"NumberingIsNumber"_ustr;
inline constexpr OUString UNO_NAME_COUNT_LINES_IN_FRAMES = u"CountLinesInFrames"_ustr;
inline constexpr OUString UNO_NAME_DDE_COMMAND_TYPE = u"DDECommandType"_ustr;
inline constexpr OUString UNO_NAME_DDE_COMMAND_FILE = u"DDECommandFile"_ustr;
inline constexpr OUString UNO_NAME_DDE_COMMAND_ELEMENT = u"DDECommandElement"_ustr;
inline constexpr OUString UNO_NAME_IS_AUTOMATIC_UPDATE = u"IsAutomaticUpdate"_ustr;
inline constexpr OUString UNO_NAME_DISTANCE = u"Distance"_ustr;
inline constexpr OUString UNO_NAME_DROP_CAP_FORMAT = u"DropCapFormat"_ustr;
inline constexpr OUString UNO_NAME_DROP_CAP_WHOLE_WORD = u"DropCapWholeWord"_ustr;
inline constexpr OUString UNO_NAME_DROP_CAP_CHAR_STYLE_NAME = u"DropCapCharStyleName"_ustr;
inline constexpr OUString UNO_NAME_FILE_LINK = u"FileLink"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC = u"Graphic"_ustr;
inline constexpr OUString UNO_NAME_TRANSFORMED_GRAPHIC = u"TransformedGraphic"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC_PREVIEW = u"GraphicPreview"_ustr;
inline constexpr OUString UNO_NAME_IS_PROTECTED = u"IsProtected"_ustr;
inline constexpr OUString UNO_NAME_PARA_KEEP_TOGETHER = u"ParaKeepTogether"_ustr;
inline constexpr OUString UNO_NAME_KEEP_TOGETHER = u"KeepTogether"_ustr;
inline constexpr OUString UNO_NAME_IS_LANDSCAPE = u"IsLandscape"_ustr;
inline constexpr OUString UNO_NAME_SEPARATOR_TEXT = u"SeparatorText"_ustr;
inline constexpr OUString UNO_NAME_NUMBER_POSITION = u"NumberPosition"_ustr;
inline constexpr OUString UNO_NAME_PAGE_STYLE_NAME = u"PageStyleName"_ustr;
inline constexpr OUString UNO_NAME_PAGE_STYLE_LAYOUT = u"PageStyleLayout"_ustr;
inline constexpr OUString UNO_NAME_PARA_ADJUST = u"ParaAdjust"_ustr;
inline constexpr OUString UNO_NAME_PARA_REGISTER_MODE_ACTIVE = u"ParaRegisterModeActive"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLE_NAME = u"ParaStyleName"_ustr;
inline constexpr OUString UNO_NAME_PARA_LAST_LINE_ADJUST = u"ParaLastLineAdjust"_ustr;
inline constexpr OUString UNO_NAME_PARA_LINE_NUMBER_COUNT = u"ParaLineNumberCount"_ustr;
inline constexpr OUString UNO_NAME_PARA_LINE_NUMBER_START_VALUE = u"ParaLineNumberStartValue"_ustr;
inline constexpr OUString UNO_NAME_BACK_COLOR = u"BackColor"_ustr;
inline constexpr OUString UNO_NAME_BACKGROUND_COMPLEX_COLOR = u"BackgroundComplexColor"_ustr;
inline constexpr OUString UNO_NAME_PARA_BACK_COLOR = u"ParaBackColor"_ustr;
inline constexpr OUString UNO_NAME_PARA_BACKGROUND_COMPLEX_COLOR
    = u"ParaBackgroundComplexColor"_ustr;
inline constexpr OUString UNO_NAME_PARA_WIDOWS = u"ParaWidows"_ustr;
inline constexpr OUString UNO_NAME_PARA_ORPHANS = u"ParaOrphans"_ustr;
inline constexpr OUString UNO_NAME_PARA_BACK_TRANSPARENT = u"ParaBackTransparent"_ustr;
inline constexpr OUString UNO_NAME_POSITION_END_OF_DOC = u"PositionEndOfDoc"_ustr;
inline constexpr OUString UNO_NAME_POSITION_PROTECTED = u"PositionProtected"_ustr;
inline constexpr OUString UNO_NAME_ALTERNATIVE_TEXT = u"AlternativeText"_ustr;
inline constexpr OUString UNO_NAME_PRIMARY_KEY = u"PrimaryKey"_ustr;
inline constexpr OUString UNO_NAME_PRINTER_PAPER_TRAY = u"PrinterPaperTray"_ustr;
inline constexpr OUString UNO_NAME_PRINTER_PAPER_TRAY_INDEX = u"PrinterPaperTrayIndex"_ustr;
inline constexpr OUString UNO_NAME_RELATIVE_WIDTH = u"RelativeWidth"_ustr;
inline constexpr OUString UNO_NAME_RELATIVE_WIDTH_RELATION = u"RelativeWidthRelation"_ustr;
inline constexpr OUString UNO_NAME_RELATIVE_HEIGHT = u"RelativeHeight"_ustr;
inline constexpr OUString UNO_NAME_RELATIVE_HEIGHT_RELATION = u"RelativeHeightRelation"_ustr;
inline constexpr OUString UNO_NAME_REPEAT_HEADLINE = u"RepeatHeadline"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_STYLES = u"SearchStyles"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_BACKWARDS = u"SearchBackwards"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_SIMILARITY = u"SearchSimilarity"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_CASE_SENSITIVE = u"SearchCaseSensitive"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_SIMILARITY_ADD = u"SearchSimilarityAdd"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_SIMILARITY_RELAX = u"SearchSimilarityRelax"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_SIMILARITY_REMOVE = u"SearchSimilarityRemove"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_REGULAR_EXPRESSION = u"SearchRegularExpression"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_SIMILARITY_EXCHANGE = u"SearchSimilarityExchange"_ustr;
inline constexpr OUString UNO_NAME_SECONDARY_KEY = u"SecondaryKey"_ustr;
inline constexpr OUString UNO_NAME_SEPARATOR_INTERVAL = u"SeparatorInterval"_ustr;
inline constexpr OUString UNO_NAME_SHOW_BREAKS = u"ShowBreaks"_ustr;
inline constexpr OUString UNO_NAME_SHOW_SPACES = u"ShowSpaces"_ustr;
inline constexpr OUString UNO_NAME_SHOW_TABLES = u"ShowTables"_ustr;
inline constexpr OUString UNO_NAME_SHOW_GRAPHICS = u"ShowGraphics"_ustr;

inline constexpr OUString UNO_NAME_SHOW_DRAWINGS = u"ShowDrawings"_ustr;
inline constexpr OUString UNO_NAME_SHOW_TABSTOPS = u"ShowTabstops"_ustr;
inline constexpr OUString UNO_NAME_SHOW_VERT_RULER = u"ShowVertRuler"_ustr;
inline constexpr OUString UNO_NAME_SHOW_PARA_BREAKS = u"ShowParaBreaks"_ustr;
inline constexpr OUString UNO_NAME_SHOW_HIDDEN_TEXT = u"ShowHiddenText"_ustr;
inline constexpr OUString UNO_NAME_SHOW_SOFT_HYPHENS = u"ShowSoftHyphens"_ustr;
inline constexpr OUString UNO_NAME_SHOW_VERT_SCROLL_BAR = u"ShowVertScrollBar"_ustr;
inline constexpr OUString UNO_NAME_SHOW_HORI_SCROLL_BAR = u"ShowHoriScrollBar"_ustr;
inline constexpr OUString UNO_NAME_SHOW_FIELD_COMMANDS = u"ShowFieldCommands"_ustr;
inline constexpr OUString UNO_NAME_SHOW_PROTECTED_SPACES = u"ShowProtectedSpaces"_ustr;
inline constexpr OUString UNO_NAME_SHOW_HIDDEN_PARAGRAPHS = u"ShowHiddenParagraphs"_ustr;
inline constexpr OUString UNO_NAME_HIDE_WHITESPACE = u"HideWhitespace"_ustr;
inline constexpr OUString UNO_NAME_IS_SYNC_WIDTH_TO_HEIGHT = u"IsSyncWidthToHeight"_ustr;
inline constexpr OUString UNO_NAME_IS_SYNC_HEIGHT_TO_WIDTH = u"IsSyncHeightToWidth"_ustr;
inline constexpr OUString UNO_NAME_SIZE_PROTECTED = u"SizeProtected"_ustr;
inline constexpr OUString UNO_NAME_TEXT_COLUMNS = u"TextColumns"_ustr;
inline constexpr OUString UNO_NAME_BACK_TRANSPARENT = u"BackTransparent"_ustr;
inline constexpr OUString UNO_NAME_ANCHOR_TYPE = u"AnchorType"_ustr;
inline constexpr OUString UNO_NAME_ANCHOR_TYPES = u"AnchorTypes"_ustr;
inline constexpr OUString UNO_NAME_ANCHOR_PAGE_NO = u"AnchorPageNo"_ustr;
inline constexpr OUString UNO_NAME_ANCHOR_FRAME = u"AnchorFrame"_ustr;
inline constexpr OUString UNO_NAME_AUTHOR = u"Author"_ustr;
inline constexpr OUString UNO_NAME_BREAK_TYPE = u"BreakType"_ustr;
inline constexpr OUString UNO_NAME_CHAIN_NEXT_NAME = u"ChainNextName"_ustr;
inline constexpr OUString UNO_NAME_CHAIN_PREV_NAME = u"ChainPrevName"_ustr;
inline constexpr OUString UNO_NAME_CHAIN_NAME = u"ChainName"_ustr;
inline constexpr OUString UNO_NAME_CHAPTER_FORMAT = u"ChapterFormat"_ustr;
inline constexpr OUString UNO_NAME_CLIENT_MAP = u"ClientMap"_ustr;
inline constexpr OUString UNO_NAME_CONDITION = u"Condition"_ustr;
inline constexpr OUString UNO_NAME_CONTENT = u"Content"_ustr;
inline constexpr OUString UNO_NAME_CHAR_CONTOURED = u"CharContoured"_ustr;
inline constexpr OUString UNO_NAME_CONTOUR_OUTSIDE = u"ContourOutside"_ustr;
inline constexpr OUString UNO_NAME_CONTENT_PROTECTED = u"ContentProtected"_ustr;
inline constexpr OUString UNO_NAME_COUNT_EMPTY_LINES = u"CountEmptyLines"_ustr;
inline constexpr OUString UNO_NAME_RESTART_AT_EACH_PAGE = u"RestartAtEachPage"_ustr;
inline constexpr OUString UNO_NAME_DATA_BASE_NAME = u"DataBaseName"_ustr;
inline constexpr OUString UNO_NAME_DATA_TABLE_NAME = u"DataTableName"_ustr;
inline constexpr OUString UNO_NAME_DATA_COMMAND_TYPE = u"DataCommandType"_ustr;
inline constexpr OUString UNO_NAME_DATA_COLUMN_NAME = u"DataColumnName"_ustr;
inline constexpr OUString UNO_NAME_IS_DATA_BASE_FORMAT = u"DataBaseFormat"_ustr;
inline constexpr OUString UNO_NAME_DATE = u"Date"_ustr;
inline constexpr OUString UNO_NAME_IS_DATE = u"IsDate"_ustr;
inline constexpr OUString UNO_NAME_EDIT_IN_READONLY = u"EditInReadonly"_ustr;
inline constexpr OUString UNO_NAME_FALSE_CONTENT = u"FalseContent"_ustr;
inline constexpr OUString UNO_NAME_FILE_FORMAT = u"FileFormat"_ustr;
inline constexpr OUString UNO_NAME_IS_FIXED = u"IsFixed"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_COUNTING = u"FootnoteCounting"_ustr;
inline constexpr OUString UNO_NAME_FULL_NAME = u"FullName"_ustr;
inline constexpr OUString UNO_NAME_HEIGHT = u"Height"_ustr;
inline constexpr OUString UNO_NAME_IS_AUTO_HEIGHT = u"IsAutoHeight"_ustr;
inline constexpr OUString UNO_NAME_SIZE_TYPE = u"SizeType"_ustr;
inline constexpr OUString UNO_NAME_HINT = u"Hint"_ustr;
inline constexpr OUString UNO_NAME_HORI_ORIENT = u"HoriOrient"_ustr;
inline constexpr OUString UNO_NAME_HORI_MIRRORED_ON_EVEN_PAGES = u"HoriMirroredOnEvenPages"_ustr;
inline constexpr OUString UNO_NAME_HORI_MIRRORED_ON_ODD_PAGES = u"HoriMirroredOnOddPages"_ustr;
inline constexpr OUString UNO_NAME_HORI_ORIENT_RELATION = u"HoriOrientRelation"_ustr;
inline constexpr OUString UNO_NAME_HORI_ORIENT_POSITION = u"HoriOrientPosition"_ustr;
inline constexpr OUString UNO_NAME_HYPER_LINK_U_R_L = u"HyperLinkURL"_ustr;
inline constexpr OUString UNO_NAME_HYPER_LINK_TARGET = u"HyperLinkTarget"_ustr;
inline constexpr OUString UNO_NAME_HYPER_LINK_NAME = u"HyperLinkName"_ustr;
inline constexpr OUString UNO_NAME_HYPER_LINK_EVENTS = u"HyperLinkEvents"_ustr;
inline constexpr OUString UNO_NAME_INFO_TYPE = u"InfoType"_ustr;
inline constexpr OUString UNO_NAME_INFO_FORMAT = u"InfoFormat"_ustr;
inline constexpr OUString UNO_NAME_IS_INPUT = u"IsInput"_ustr;
inline constexpr OUString UNO_NAME_LEVEL = u"Level"_ustr;
inline constexpr OUString UNO_NAME_INTERVAL = u"Interval"_ustr;
inline constexpr OUString UNO_NAME_LINK_REGION = u"LinkRegion"_ustr;
inline constexpr OUString UNO_NAME_MACRO_NAME = u"MacroName"_ustr;
inline constexpr OUString UNO_NAME_SPLIT = u"Split"_ustr;
inline constexpr OUString UNO_NAME_PARA_SPLIT = u"ParaSplit"_ustr;
inline constexpr OUString UNO_NAME_NUMBER_FORMAT = u"NumberFormat"_ustr;
inline constexpr OUString UNO_NAME_NUMBERING_TYPE = u"NumberingType"_ustr;
inline constexpr OUString UNO_NAME_OFFSET = u"Offset"_ustr;
inline constexpr OUString UNO_NAME_ON = u"On"_ustr;
inline constexpr OUString UNO_NAME_OPAQUE = u"Opaque"_ustr;
inline constexpr OUString UNO_NAME_PAGE_TOGGLE = u"PageToggle"_ustr;
inline constexpr OUString UNO_NAME_PAGE_DESC_NAME = u"PageDescName"_ustr;
inline constexpr OUString UNO_NAME_PAGE_NUMBER_OFFSET = u"PageNumberOffset"_ustr;
inline constexpr OUString UNO_NAME_PLACEHOLDER = u"PlaceHolder"_ustr;
inline constexpr OUString UNO_NAME_PLACEHOLDER_TYPE = u"PlaceHolderType"_ustr;
inline constexpr OUString UNO_NAME_PRINT = u"Print"_ustr;
inline constexpr OUString UNO_NAME_REFERENCE_FIELD_FLAGS = u"ReferenceFieldFlags"_ustr;
inline constexpr OUString UNO_NAME_REFERENCE_FIELD_PART = u"ReferenceFieldPart"_ustr;
inline constexpr OUString UNO_NAME_REFERENCE_FIELD_SOURCE = u"ReferenceFieldSource"_ustr;
inline constexpr OUString UNO_NAME_REFERENCE_FIELD_LANGUAGE = u"ReferenceFieldLanguage"_ustr;
inline constexpr OUString UNO_NAME_REGISTER_PARAGRAPH_STYLE = u"RegisterParagraphStyle"_ustr;
inline constexpr OUString UNO_NAME_SCRIPT_TYPE = u"ScriptType"_ustr;
inline constexpr OUString UNO_NAME_SEARCH_ALL = u"SearchAll"_ustr;

inline constexpr OUString UNO_NAME_SEARCH_WORDS = u"SearchWords"_ustr;
inline constexpr OUString UNO_NAME_SEQUENCE_VALUE = u"SequenceValue"_ustr;
inline constexpr OUString UNO_NAME_SERVER_MAP = u"ServerMap"_ustr;
inline constexpr OUString UNO_NAME_IMAGE_MAP = u"ImageMap"_ustr;
inline constexpr OUString UNO_NAME_SET_NUMBER = u"SetNumber"_ustr;
inline constexpr OUString UNO_NAME_SHADOW_FORMAT = u"ShadowFormat"_ustr;
inline constexpr OUString UNO_NAME_SHOW_HORI_RULER = u"ShowHoriRuler"_ustr;
inline constexpr OUString UNO_NAME_SIZE = u"Size"_ustr;
inline constexpr OUString UNO_NAME_ACTUAL_SIZE = u"ActualSize"_ustr;
inline constexpr OUString UNO_NAME_SOURCE_NAME = u"SourceName"_ustr;
inline constexpr OUString UNO_NAME_START_AT = u"StartAt"_ustr;
inline constexpr OUString UNO_NAME_START_WITH = u"StartWith"_ustr;
inline constexpr OUString UNO_NAME_SUB_TYPE = u"SubType"_ustr;
inline constexpr OUString UNO_NAME_SURROUND = u"Surround"_ustr;
inline constexpr OUString UNO_NAME_IS_EXPRESSION = u"IsExpression"_ustr;
inline constexpr OUString UNO_NAME_IS_SHOW_FORMULA = u"IsShowFormula"_ustr;
inline constexpr OUString UNO_NAME_TEXT_WRAP = u"TextWrap"_ustr;
inline constexpr OUString UNO_NAME_SURROUND_CONTOUR = u"SurroundContour"_ustr;
inline constexpr OUString UNO_NAME_SURROUND_ANCHORONLY = u"SurroundAnchorOnly"_ustr;
inline constexpr OUString UNO_NAME_TABLE_NAME = u"TableName"_ustr;
inline constexpr OUString UNO_NAME_TABLE_TEMPLATE_NAME = u"TableTemplateName"_ustr;
inline constexpr OUString UNO_NAME_TABSTOPS = u"ParaTabStops"_ustr;
inline constexpr OUString UNO_NAME_TITLE = u"Title"_ustr;
inline constexpr OUString UNO_NAME_TOP_MARGIN = u"TopMargin"_ustr;
inline constexpr OUString UNO_NAME_BOTTOM_MARGIN = u"BottomMargin"_ustr;
inline constexpr OUString UNO_NAME_TRUE_CONTENT = u"TrueContent"_ustr;
inline constexpr OUString UNO_NAME_URL_CONTENT = u"URLContent"_ustr;
inline constexpr OUString UNO_NAME_USERTEXT = u"UserText"_ustr;
inline constexpr OUString UNO_NAME_USER_DATA_TYPE = u"UserDataType"_ustr;
inline constexpr OUString UNO_NAME_VALUE = u"Value"_ustr;
inline constexpr OUString UNO_NAME_VARIABLE_NAME = u"VariableName"_ustr;
inline constexpr OUString UNO_NAME_VARIABLE_SUBTYPE = u"VariableSubtype"_ustr;
inline constexpr OUString UNO_NAME_VERT_ORIENT = u"VertOrient"_ustr;
inline constexpr OUString UNO_NAME_VERT_MIRRORED = u"VertMirrored"_ustr;
inline constexpr OUString UNO_NAME_VERT_ORIENT_POSITION = u"VertOrientPosition"_ustr;
inline constexpr OUString UNO_NAME_VERT_ORIENT_RELATION = u"VertOrientRelation"_ustr;
inline constexpr OUString UNO_NAME_IS_VISIBLE = u"IsVisible"_ustr;
inline constexpr OUString UNO_NAME_WIDTH = u"Width"_ustr;
inline constexpr OUString UNO_NAME_CHAR_WORD_MODE = u"CharWordMode"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC_CROP = u"GraphicCrop"_ustr;
inline constexpr OUString UNO_NAME_DOCUMENT_INDEX_MARK = u"DocumentIndexMark"_ustr;
inline constexpr OUString UNO_NAME_DOCUMENT_INDEX = u"DocumentIndex"_ustr;
inline constexpr OUString UNO_NAME_IS_GLOBAL_DOCUMENT_SECTION = u"IsGlobalDocumentSection"_ustr;
inline constexpr OUString UNO_NAME_TEXT_FIELD = u"TextField"_ustr;
inline constexpr OUString UNO_NAME_BOOKMARK = u"Bookmark"_ustr;
inline constexpr OUString UNO_NAME_BOOKMARK_HIDDEN = u"BookmarkHidden"_ustr;
inline constexpr OUString UNO_NAME_BOOKMARK_CONDITION = u"BookmarkCondition"_ustr;
inline constexpr OUString UNO_NAME_TEXT_TABLE = u"TextTable"_ustr;
inline constexpr OUString UNO_NAME_CELL = u"Cell"_ustr;
inline constexpr OUString UNO_NAME_TEXT_FRAME = u"TextFrame"_ustr;
inline constexpr OUString UNO_NAME_REFERENCE_MARK = u"ReferenceMark"_ustr;
inline constexpr OUString UNO_NAME_TEXT_SECTION = u"TextSection"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE = u"Footnote"_ustr;
inline constexpr OUString UNO_NAME_ENDNOTE = u"Endnote"_ustr;
inline constexpr OUString UNO_NAME_CHART_ROW_AS_LABEL = u"ChartRowAsLabel"_ustr;
inline constexpr OUString UNO_NAME_CHART_COLUMN_AS_LABEL = u"ChartColumnAsLabel"_ustr;
inline constexpr OUString UNO_NAME_LEFT_BORDER = u"LeftBorder"_ustr;
inline constexpr OUString UNO_NAME_RIGHT_BORDER = u"RightBorder"_ustr;
inline constexpr OUString UNO_NAME_TOP_BORDER = u"TopBorder"_ustr;
inline constexpr OUString UNO_NAME_BOTTOM_BORDER = u"BottomBorder"_ustr;
inline constexpr OUString UNO_NAME_BORDER_DISTANCE = u"BorderDistance"_ustr;
inline constexpr OUString UNO_NAME_LEFT_BORDER_DISTANCE = u"LeftBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_RIGHT_BORDER_DISTANCE = u"RightBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_TOP_BORDER_DISTANCE = u"TopBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_BOTTOM_BORDER_DISTANCE = u"BottomBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_BORDER_BOTTOM_COMPLEX_COLOR = u"BottomBorderComplexColor"_ustr;
inline constexpr OUString UNO_NAME_BORDER_LEFT_COMPLEX_COLOR = u"LeftBorderComplexColor"_ustr;
inline constexpr OUString UNO_NAME_BORDER_RIGHT_COMPLEX_COLOR = u"RightBorderComplexColor"_ustr;
inline constexpr OUString UNO_NAME_BORDER_TOP_COMPLEX_COLOR = u"TopBorderComplexColor"_ustr;
inline constexpr OUString UNO_NAME_TABLE_BORDER = u"TableBorder"_ustr;
inline constexpr OUString UNO_NAME_TABLE_COLUMN_SEPARATORS = u"TableColumnSeparators"_ustr;
inline constexpr OUString UNO_NAME_TABLE_COLUMN_RELATIVE_SUM = u"TableColumnRelativeSum"_ustr;
inline constexpr OUString UNO_NAME_HEADER_TEXT = u"HeaderText"_ustr;
inline constexpr OUString UNO_NAME_HEADER_TEXT_LEFT = u"HeaderTextLeft"_ustr;
inline constexpr OUString UNO_NAME_HEADER_TEXT_RIGHT = u"HeaderTextRight"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_TEXT = u"FooterText"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_TEXT_LEFT = u"FooterTextLeft"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_TEXT_RIGHT = u"FooterTextRight"_ustr;
inline constexpr OUString UNO_NAME_HEADER_BACK_COLOR = u"HeaderBackColor"_ustr;
inline constexpr OUString UNO_NAME_HEADER_BACK_TRANSPARENT = u"HeaderBackTransparent"_ustr;
inline constexpr OUString UNO_NAME_HEADER_LEFT_BORDER = u"HeaderLeftBorder"_ustr;
inline constexpr OUString UNO_NAME_HEADER_RIGHT_BORDER = u"HeaderRightBorder"_ustr;
inline constexpr OUString UNO_NAME_HEADER_TOP_BORDER = u"HeaderTopBorder"_ustr;
inline constexpr OUString UNO_NAME_HEADER_BOTTOM_BORDER = u"HeaderBottomBorder"_ustr;
inline constexpr OUString UNO_NAME_HEADER_BORDER_DISTANCE = u"HeaderBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_HEADER_SHADOW_FORMAT = u"HeaderShadowFormat"_ustr;
inline constexpr OUString UNO_NAME_HEADER_BODY_DISTANCE = u"HeaderBodyDistance"_ustr;
inline constexpr OUString UNO_NAME_HEADER_IS_DYNAMIC_HEIGHT = u"HeaderIsDynamicHeight"_ustr;
inline constexpr OUString UNO_NAME_HEADER_IS_SHARED = u"HeaderIsShared"_ustr;
inline constexpr OUString UNO_NAME_HEADER_HEIGHT = u"HeaderHeight"_ustr;
inline constexpr OUString UNO_NAME_HEADER_IS_ON = u"HeaderIsOn"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_BACK_COLOR = u"FooterBackColor"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_BACK_TRANSPARENT = u"FooterBackTransparent"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_LEFT_BORDER = u"FooterLeftBorder"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_RIGHT_BORDER = u"FooterRightBorder"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_TOP_BORDER = u"FooterTopBorder"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_BOTTOM_BORDER = u"FooterBottomBorder"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_BORDER_DISTANCE = u"FooterBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_SHADOW_FORMAT = u"FooterShadowFormat"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_BODY_DISTANCE = u"FooterBodyDistance"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_IS_DYNAMIC_HEIGHT = u"FooterIsDynamicHeight"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_IS_SHARED = u"FooterIsShared"_ustr;
inline constexpr OUString UNO_NAME_TEXT_PARAGRAPH = u"TextParagraph"_ustr;
inline constexpr OUString UNO_NAME_PARENT_TEXT = u"ParentText"_ustr;
inline constexpr OUString UNO_NAME_SORTED_TEXT_ID = u"SortedTextId"_ustr;

inline constexpr OUString UNO_NAME_FOOTER_HEIGHT = u"FooterHeight"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_IS_ON = u"FooterIsOn"_ustr;
inline constexpr OUString UNO_NAME_OVERWRITE_STYLES = u"OverwriteStyles"_ustr;
inline constexpr OUString UNO_NAME_LOAD_NUMBERING_STYLES = u"LoadNumberingStyles"_ustr;
inline constexpr OUString UNO_NAME_LOAD_PAGE_STYLES = u"LoadPageStyles"_ustr;
inline constexpr OUString UNO_NAME_LOAD_FRAME_STYLES = u"LoadFrameStyles"_ustr;
inline constexpr OUString UNO_NAME_LOAD_TEXT_STYLES = u"LoadTextStyles"_ustr;
inline constexpr OUString UNO_NAME_FILE_NAME = u"FileName"_ustr;
inline constexpr OUString UNO_NAME_COPY_COUNT = u"CopyCount"_ustr;
inline constexpr OUString UNO_NAME_COLLATE = u"Collate"_ustr;
inline constexpr OUString UNO_NAME_SORT = u"Sort"_ustr;
inline constexpr OUString UNO_NAME_PAGES = u"Pages"_ustr;
inline constexpr OUString UNO_NAME_FIRST_LINE_OFFSET = u"FirstLineOffset"_ustr;
inline constexpr OUString UNO_NAME_SYMBOL_TEXT_DISTANCE = u"SymbolTextDistance"_ustr;
inline constexpr OUString UNO_NAME_USER_INDEX_NAME = u"UserIndexName"_ustr;
inline constexpr OUString UNO_NAME_REVISION = u"Revision"_ustr;
inline constexpr OUString UNO_NAME_UNVISITED_CHAR_STYLE_NAME = u"UnvisitedCharStyleName"_ustr;
inline constexpr OUString UNO_NAME_VISITED_CHAR_STYLE_NAME = u"VisitedCharStyleName"_ustr;
inline constexpr OUString UNO_NAME_PARAGRAPH_COUNT = u"ParagraphCount"_ustr;
inline constexpr OUString UNO_NAME_WORD_COUNT = u"WordCount"_ustr;
inline constexpr OUString UNO_NAME_WORD_SEPARATOR = u"WordSeparator"_ustr;
inline constexpr OUString UNO_NAME_CHARACTER_COUNT = u"CharacterCount"_ustr;
inline constexpr OUString UNO_NAME_ZOOM_VALUE = u"ZoomValue"_ustr;
inline constexpr OUString UNO_NAME_ZOOM_TYPE = u"ZoomType"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_MARKS = u"CreateFromMarks"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_OUTLINE = u"CreateFromOutline"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_CHAPTER = u"CreateFromChapter"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_LABELS = u"CreateFromLabels"_ustr;
inline constexpr OUString UNO_NAME_USE_ALPHABETICAL_SEPARATORS = u"UseAlphabeticalSeparators"_ustr;
inline constexpr OUString UNO_NAME_USE_KEY_AS_ENTRY = u"UseKeyAsEntry"_ustr;
inline constexpr OUString UNO_NAME_USE_COMBINED_ENTRIES = u"UseCombinedEntries"_ustr;
inline constexpr OUString UNO_NAME_IS_CASE_SENSITIVE = u"IsCaseSensitive"_ustr;
inline constexpr OUString UNO_NAME_USE_P_P = u"UsePP"_ustr;
inline constexpr OUString UNO_NAME_USE_DASH = u"UseDash"_ustr;
inline constexpr OUString UNO_NAME_USE_UPPER_CASE = u"UseUpperCase"_ustr;
inline constexpr OUString UNO_NAME_LABEL_CATEGORY = u"LabelCategory"_ustr;
inline constexpr OUString UNO_NAME_LABEL_DISPLAY_TYPE = u"LabelDisplayType"_ustr;
inline constexpr OUString UNO_NAME_USE_LEVEL_FROM_SOURCE = u"UseLevelFromSource"_ustr;
inline constexpr OUString UNO_NAME_LEVEL_FORMAT = u"LevelFormat"_ustr;
inline constexpr OUString UNO_NAME_LEVEL_PARAGRAPH_STYLES = u"LevelParagraphStyles"_ustr;
inline constexpr OUString UNO_NAME_MAIN_ENTRY_CHARACTER_STYLE_NAME
    = u"MainEntryCharacterStyleName"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_TABLES = u"CreateFromTables"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_TEXT_FRAMES = u"CreateFromTextFrames"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_GRAPHIC_OBJECTS = u"CreateFromGraphicObjects"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_EMBEDDED_OBJECTS = u"CreateFromEmbeddedObjects"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_STAR_MATH = u"CreateFromStarMath"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_STAR_CHART = u"CreateFromStarChart"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_STAR_CALC = u"CreateFromStarCalc"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_STAR_DRAW = u"CreateFromStarDraw"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_OTHER_EMBEDDED_OBJECTS
    = u"CreateFromOtherEmbeddedObjects"_ustr;
inline constexpr OUString UNO_NAME_INDEX_AUTO_MARK_FILE_U_R_L = u"IndexAutoMarkFileURL"_ustr;
inline constexpr OUString UNO_NAME_IS_COMMA_SEPARATED = u"IsCommaSeparated"_ustr;
inline constexpr OUString UNO_NAME_IS_RELATIVE_TABSTOPS = u"IsRelativeTabstops"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_PARAGRAPH_STYLE = u"CreateFromParagraphStyle"_ustr;
inline constexpr OUString UNO_NAME_CREATE_FROM_LEVEL_PARAGRAPH_STYLES
    = u"CreateFromLevelParagraphStyles"_ustr;
inline constexpr OUString UNO_NAME_SHOW_CHANGES = u"ShowChanges"_ustr;
inline constexpr OUString UNO_NAME_RECORD_CHANGES = u"RecordChanges"_ustr;
inline constexpr OUString UNO_LINK_DISPLAY_NAME = u"LinkDisplayName"_ustr;
inline constexpr OUString UNO_LINK_DISPLAY_BITMAP = u"LinkDisplayBitmap"_ustr;
inline constexpr OUString UNO_NAME_HEADING_STYLE_NAME = u"HeadingStyleName"_ustr;
inline constexpr OUString UNO_NAME_SHOW_ONLINE_LAYOUT = u"ShowOnlineLayout"_ustr;
inline constexpr OUString UNO_NAME_USER_DEFINED_ATTRIBUTES = u"UserDefinedAttributes"_ustr;
inline constexpr OUString UNO_NAME_TEXT_USER_DEFINED_ATTRIBUTES = u"TextUserDefinedAttributes"_ustr;
inline constexpr OUString UNO_NAME_FILE_PATH = u"FilePath"_ustr;
inline constexpr OUString UNO_NAME_PARA_CHAPTER_NUMBERING_LEVEL = u"ParaChapterNumberingLevel"_ustr;
inline constexpr OUString UNO_NAME_PARA_CONDITIONAL_STYLE_NAME = u"ParaConditionalStyleName"_ustr;
inline constexpr OUString UNO_NAME_CHAPTER_NUMBERING_LEVEL = u"ChapterNumberingLevel"_ustr;
inline constexpr OUString UNO_NAME_NUMBERING_SEPARATOR = u"NumberingSeparator"_ustr;
inline constexpr OUString UNO_NAME_IS_CONTINUOUS_NUMBERING = u"IsContinuousNumbering"_ustr;
inline constexpr OUString UNO_NAME_IS_AUTOMATIC = u"IsAutomatic"_ustr;
inline constexpr OUString UNO_NAME_IS_ABSOLUTE_MARGINS = u"IsAbsoluteMargins"_ustr;
inline constexpr OUString UNO_NAME_CATEGORY = u"Category"_ustr;
inline constexpr OUString UNO_NAME_DEPENDENT_TEXT_FIELDS = u"DependentTextFields"_ustr;
inline constexpr OUString UNO_NAME_CURRENT_PRESENTATION = u"CurrentPresentation"_ustr;
inline constexpr OUString UNO_NAME_ADJUST = u"Adjust"_ustr;
inline constexpr OUString UNO_NAME_INSTANCE_NAME = u"InstanceName"_ustr;
inline constexpr OUString UNO_NAME_TEXT_PORTION_TYPE = u"TextPortionType"_ustr;
inline constexpr OUString UNO_NAME_CONTROL_CHARACTER = u"ControlCharacter"_ustr;
inline constexpr OUString UNO_NAME_IS_COLLAPSED = u"IsCollapsed"_ustr;
inline constexpr OUString UNO_NAME_IS_START = u"IsStart"_ustr;
inline constexpr OUString UNO_NAME_SEQUENCE_NUMBER = u"SequenceNumber"_ustr;
inline constexpr OUString UNO_NAME_REFERENCE_ID = u"ReferenceId"_ustr;
inline constexpr OUString UNO_NAME_HEADER_LEFT_BORDER_DISTANCE = u"HeaderLeftBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_HEADER_RIGHT_BORDER_DISTANCE = u"HeaderRightBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_HEADER_TOP_BORDER_DISTANCE = u"HeaderTopBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_HEADER_BOTTOM_BORDER_DISTANCE
    = u"HeaderBottomBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_LEFT_BORDER_DISTANCE = u"FooterLeftBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_RIGHT_BORDER_DISTANCE = u"FooterRightBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_TOP_BORDER_DISTANCE = u"FooterTopBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_BOTTOM_BORDER_DISTANCE
    = u"FooterBottomBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_PARA_IS_NUMBERING_RESTART = u"ParaIsNumberingRestart"_ustr;
inline constexpr OUString UNO_NAME_HIDE_FIELD_TIPS = u"HideFieldTips"_ustr;
inline constexpr OUString UNO_NAME_PARA_SHADOW_FORMAT = u"ParaShadowFormat"_ustr;
inline constexpr OUString UNO_NAME_CONTOUR_POLY_POLYGON = u"ContourPolyPolygon"_ustr;

inline constexpr OUString UNO_NAME_IS_PIXEL_CONTOUR = u"IsPixelContour"_ustr;
inline constexpr OUString UNO_NAME_IS_AUTOMATIC_CONTOUR = u"IsAutomaticContour"_ustr;
inline constexpr OUString UNO_NAME_SEPARATOR_LINE_WIDTH = u"SeparatorLineWidth"_ustr;
inline constexpr OUString UNO_NAME_SEPARATOR_LINE_COLOR = u"SeparatorLineColor"_ustr;
inline constexpr OUString UNO_NAME_SEPARATOR_LINE_RELATIVE_HEIGHT
    = u"SeparatorLineRelativeHeight"_ustr;
inline constexpr OUString UNO_NAME_SEPARATOR_LINE_VERTIVAL_ALIGNMENT
    = u"SeparatorLineVerticalAlignment"_ustr;
inline constexpr OUString UNO_NAME_SEPARATOR_LINE_IS_ON = u"SeparatorLineIsOn"_ustr;
inline constexpr OUString UNO_NAME_IS_SKIP_HIDDEN_TEXT = u"IsSkipHiddenText"_ustr;
inline constexpr OUString UNO_NAME_IS_SKIP_PROTECTED_TEXT = u"IsSkipProtectedText"_ustr;
inline constexpr OUString UNO_NAME_NO_FORMAT_ATTR = u"NoFormatAttr"_ustr;
inline constexpr OUString UNO_NAME_DOCUMENT_INDEX_MARKS = u"DocumentIndexMarks"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_IS_COLLECT_AT_TEXT_END
    = u"FootnoteIsCollectAtTextEnd"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_IS_RESTART_NUMBERING
    = u"FootnoteIsRestartNumbering"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_RESTART_NUMBERING_AT
    = u"FootnoteRestartNumberingAt"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_IS_OWN_NUMBERING = u"FootnoteIsOwnNumbering"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_NUMBERING_TYPE = u"FootnoteNumberingType"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_NUMBERING_PREFIX = u"FootnoteNumberingPrefix"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_NUMBERING_SUFFIX = u"FootnoteNumberingSuffix"_ustr;
inline constexpr OUString UNO_NAME_ENDNOTE_IS_COLLECT_AT_TEXT_END
    = u"EndnoteIsCollectAtTextEnd"_ustr;
inline constexpr OUString UNO_NAME_ENDNOTE_IS_RESTART_NUMBERING = u"EndnoteIsRestartNumbering"_ustr;
inline constexpr OUString UNO_NAME_ENDNOTE_RESTART_NUMBERING_AT = u"EndnoteRestartNumberingAt"_ustr;
inline constexpr OUString UNO_NAME_ENDNOTE_IS_OWN_NUMBERING = u"EndnoteIsOwnNumbering"_ustr;
inline constexpr OUString UNO_NAME_ENDNOTE_NUMBERING_TYPE = u"EndnoteNumberingType"_ustr;
inline constexpr OUString UNO_NAME_ENDNOTE_NUMBERING_PREFIX = u"EndnoteNumberingPrefix"_ustr;
inline constexpr OUString UNO_NAME_ENDNOTE_NUMBERING_SUFFIX = u"EndnoteNumberingSuffix"_ustr;
inline constexpr OUString UNO_NAME_BRACKET_BEFORE = u"BracketBefore"_ustr;
inline constexpr OUString UNO_NAME_BRACKET_AFTER = u"BracketAfter"_ustr;
inline constexpr OUString UNO_NAME_IS_NUMBER_ENTRIES = u"IsNumberEntries"_ustr;
inline constexpr OUString UNO_NAME_IS_SORT_BY_POSITION = u"IsSortByPosition"_ustr;
inline constexpr OUString UNO_NAME_SORT_KEYS = u"SortKeys"_ustr;
inline constexpr OUString UNO_NAME_IS_SORT_ASCENDING = u"IsSortAscending"_ustr;
inline constexpr OUString UNO_NAME_SORT_KEY = u"SortKey"_ustr;
inline constexpr OUString UNO_NAME_FIELDS = u"Fields"_ustr;
inline constexpr OUString UNO_NAME_DATE_TIME_VALUE = u"DateTimeValue"_ustr;
inline constexpr OUString UNO_NAME_IS_ON = u"IsOn"_ustr;
inline constexpr OUString UNO_NAME_Z_ORDER = u"ZOrder"_ustr;
inline constexpr OUString UNO_NAME_CONTENT_SECTION = u"ContentSection"_ustr;
inline constexpr OUString UNO_NAME_HEADER_SECTION = u"HeaderSection"_ustr;
inline constexpr OUString UNO_NAME_PARA_IS_HANGING_PUNCTUATION = u"ParaIsHangingPunctuation"_ustr;
inline constexpr OUString UNO_NAME_PARA_IS_CHARACTER_DISTANCE = u"ParaIsCharacterDistance"_ustr;
inline constexpr OUString UNO_NAME_PARA_IS_FORBIDDEN_RULES = u"ParaIsForbiddenRules"_ustr;
inline constexpr OUString UNO_NAME_PARA_VERT_ALIGNMENT = u"ParaVertAlignment"_ustr;
inline constexpr OUString UNO_NAME_IS_MAIN_ENTRY = u"IsMainEntry"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC_ROTATION = u"GraphicRotation"_ustr;
inline constexpr OUString UNO_NAME_ADJUST_LUMINANCE = u"AdjustLuminance"_ustr;
inline constexpr OUString UNO_NAME_ADJUST_CONTRAST = u"AdjustContrast"_ustr;
inline constexpr OUString UNO_NAME_ADJUST_RED = u"AdjustRed"_ustr;
inline constexpr OUString UNO_NAME_ADJUST_GREEN = u"AdjustGreen"_ustr;
inline constexpr OUString UNO_NAME_ADJUST_BLUE = u"AdjustBlue"_ustr;
inline constexpr OUString UNO_NAME_GAMMA = u"Gamma"_ustr;
inline constexpr OUString UNO_NAME_GRAPHIC_IS_INVERTED = u"GraphicIsInverted"_ustr;
inline constexpr OUString UNO_NAME_TRANSPARENCY = u"Transparency"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_AUTHOR = u"RedlineAuthor"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_DATE_TIME = u"RedlineDateTime"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_MOVED_ID = u"RedlineMovedID"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_COMMENT = u"RedlineComment"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_DESCRIPTION = u"RedlineDescription"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_TYPE = u"RedlineType"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_SUCCESSOR_DATA = u"RedlineSuccessorData"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_IDENTIFIER = u"RedlineIdentifier"_ustr;
inline constexpr OUString UNO_NAME_IS_IN_HEADER_FOOTER = u"IsInHeaderFooter"_ustr;
inline constexpr OUString UNO_NAME_START_REDLINE = u"StartRedline"_ustr;
inline constexpr OUString UNO_NAME_END_REDLINE = u"EndRedline"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_START = u"RedlineStart"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_END = u"RedlineEnd"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_TEXT = u"RedlineText"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_DISPLAY_TYPE = u"RedlineDisplayType"_ustr;
inline constexpr OUString UNO_NAME_FORBIDDEN_CHARACTERS = u"ForbiddenCharacters"_ustr;
inline constexpr OUString UNO_NAME_RUBY_BASE_TEXT = u"RubyBaseText"_ustr;
inline constexpr OUString UNO_NAME_RUBY_TEXT = u"RubyText"_ustr;
inline constexpr OUString UNO_NAME_RUBY_ADJUST = u"RubyAdjust"_ustr;
inline constexpr OUString UNO_NAME_RUBY_CHAR_STYLE_NAME = u"RubyCharStyleName"_ustr;
inline constexpr OUString UNO_NAME_RUBY_IS_ABOVE = u"RubyIsAbove"_ustr;
inline constexpr OUString UNO_NAME_RUBY_POSITION = u"RubyPosition"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_HEIGHT = u"FootnoteHeight"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_LINE_WEIGHT = u"FootnoteLineWeight"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_LINE_COLOR = u"FootnoteLineColor"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_LINE_RELATIVE_WIDTH = u"FootnoteLineRelativeWidth"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_LINE_ADJUST = u"FootnoteLineAdjust"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_LINE_TEXT_DISTANCE = u"FootnoteLineTextDistance"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_LINE_DISTANCE = u"FootnoteLineDistance"_ustr;
inline constexpr OUString UNO_NAME_CHAR_ROTATION = u"CharRotation"_ustr;
inline constexpr OUString UNO_NAME_CHAR_ROTATION_IS_FIT_TO_LINE = u"CharRotationIsFitToLine"_ustr;
inline constexpr OUString UNO_NAME_CHAR_SCALE_WIDTH = u"CharScaleWidth"_ustr;
inline constexpr OUString UNO_NAME_TAB_STOP_DISTANCE = u"TabStopDistance"_ustr;
inline constexpr OUString UNO_NAME_IS_WIDTH_RELATIVE = u"IsWidthRelative"_ustr;
inline constexpr OUString UNO_NAME_CHAR_RELIEF = u"CharRelief"_ustr;
inline constexpr OUString UNO_NAME_IS_HIDDEN = u"IsHidden"_ustr;
inline constexpr OUString UNO_NAME_IS_CONDITION_TRUE = u"IsConditionTrue"_ustr;
inline constexpr OUString UNO_NAME_TWO_DIGIT_YEAR = u"TwoDigitYear"_ustr;
inline constexpr OUString UNO_NAME_PROTECTION_KEY = u"ProtectionKey"_ustr;
inline constexpr OUString UNO_NAME_REDLINE_PROTECTION_KEY = u"RedlineProtectionKey"_ustr;
inline constexpr OUString UNO_NAME_AUTOMATIC_DISTANCE = u"AutomaticDistance"_ustr;
inline constexpr OUString UNO_NAME_AUTOMATIC_CONTROL_FOCUS = u"AutomaticControlFocus"_ustr;
inline constexpr OUString UNO_NAME_APPLY_FORM_DESIGN_MODE = u"ApplyFormDesignMode"_ustr;
inline constexpr OUString UNO_NAME_LOCALE = u"Locale"_ustr;
inline constexpr OUString UNO_NAME_SORT_ALGORITHM = u"SortAlgorithm"_ustr;
inline constexpr OUString UNO_NAME_FRAME_HEIGHT_ABSOLUTE = u"FrameHeightAbsolute"_ustr;
inline constexpr OUString UNO_NAME_FRAME_HEIGHT_PERCENT = u"FrameHeightPercent"_ustr;
inline constexpr OUString UNO_NAME_FRAME_ISAUTOMATIC_HEIGHT = u"FrameIsAutomaticHeight"_ustr;
inline constexpr OUString UNO_NAME_FRAME_WIDTH_ABSOLUTE = u"FrameWidthAbsolute"_ustr;
inline constexpr OUString UNO_NAME_FRAME_WIDTH_PERCENT = u"FrameWidthPercent"_ustr;

inline constexpr OUString UNO_NAME_HEADER_FILLBMP_LOGICAL_SIZE
    = u"HeaderFillBitmapLogicalSize"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_OFFSET_X = u"HeaderFillBitmapOffsetX"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_OFFSET_Y = u"HeaderFillBitmapOffsetY"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_POSITION_OFFSET_X
    = u"HeaderFillBitmapPositionOffsetX"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_POSITION_OFFSET_Y
    = u"HeaderFillBitmapPositionOffsetY"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_RECTANGLE_POINT
    = u"HeaderFillBitmapRectanglePoint"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_SIZE_X = u"HeaderFillBitmapSizeX"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_SIZE_Y = u"HeaderFillBitmapSizeY"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_STRETCH = u"HeaderFillBitmapStretch"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_TILE = u"HeaderFillBitmapTile"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBMP_MODE = u"HeaderFillBitmapMode"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLCOLOR = u"HeaderFillColor"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBACKGROUND = u"HeaderFillBackground"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBITMAP = u"HeaderFillBitmap"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLBITMAPNAME = u"HeaderFillBitmapName"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLGRADIENTSTEPCOUNT
    = u"HeaderFillGradientStepCount"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLGRADIENT = u"HeaderFillGradient"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLGRADIENTNAME = u"HeaderFillGradientName"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLHATCH = u"HeaderFillHatch"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLHATCHNAME = u"HeaderFillHatchName"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLSTYLE = u"HeaderFillStyle"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILL_TRANSPARENCE = u"HeaderFillTransparence"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLTRANSPARENCEGRADIENT
    = u"HeaderFillTransparenceGradient"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLTRANSPARENCEGRADIENTNAME
    = u"HeaderFillTransparenceGradientName"_ustr;
inline constexpr OUString UNO_NAME_HEADER_FILLCOLOR_2 = u"HeaderFillColor2"_ustr;

inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_LOGICAL_SIZE
    = u"FooterFillBitmapLogicalSize"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_OFFSET_X = u"FooterFillBitmapOffsetX"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_OFFSET_Y = u"FooterFillBitmapOffsetY"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_POSITION_OFFSET_X
    = u"FooterFillBitmapPositionOffsetX"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_POSITION_OFFSET_Y
    = u"FooterFillBitmapPositionOffsetY"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_RECTANGLE_POINT
    = u"FooterFillBitmapRectanglePoint"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_SIZE_X = u"FooterFillBitmapSizeX"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_SIZE_Y = u"FooterFillBitmapSizeY"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_STRETCH = u"FooterFillBitmapStretch"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_TILE = u"FooterFillBitmapTile"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBMP_MODE = u"FooterFillBitmapMode"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLCOLOR = u"FooterFillColor"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBACKGROUND = u"FooterFillBackground"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBITMAP = u"FooterFillBitmap"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLBITMAPNAME = u"FooterFillBitmapName"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLGRADIENTSTEPCOUNT
    = u"FooterFillGradientStepCount"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLGRADIENT = u"FooterFillGradient"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLGRADIENTNAME = u"FooterFillGradientName"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLHATCH = u"FooterFillHatch"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLHATCHNAME = u"FooterFillHatchName"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLSTYLE = u"FooterFillStyle"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILL_TRANSPARENCE = u"FooterFillTransparence"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLTRANSPARENCEGRADIENT
    = u"FooterFillTransparenceGradient"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLTRANSPARENCEGRADIENTNAME
    = u"FooterFillTransparenceGradientName"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_FILLCOLOR_2 = u"FooterFillColor2"_ustr;

inline constexpr OUString UNO_NAME_PARA_STYLEHEADING = u"ParaStyleHeading"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL1 = u"ParaStyleLevel1"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL10 = u"ParaStyleLevel10"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL2 = u"ParaStyleLevel2"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL3 = u"ParaStyleLevel3"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL4 = u"ParaStyleLevel4"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL5 = u"ParaStyleLevel5"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL6 = u"ParaStyleLevel6"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL7 = u"ParaStyleLevel7"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL8 = u"ParaStyleLevel8"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLELEVEL9 = u"ParaStyleLevel9"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLESEPARATOR = u"ParaStyleSeparator"_ustr;
inline constexpr OUString UNO_NAME_MACRO_LIBRARY = u"MacroLibrary"_ustr;
inline constexpr OUString UNO_NAME_CELL_NAME = u"CellName"_ustr;
inline constexpr OUString UNO_NAME_PARA_USER_DEFINED_ATTRIBUTES = u"ParaUserDefinedAttributes"_ustr;
inline constexpr OUString UNO_NAME_MERGE_LAST_PARA = u"MergeLastPara"_ustr;
inline constexpr OUString UNO_NAME_WRITING_MODE = u"WritingMode"_ustr;
inline constexpr OUString UNO_NAME_GRID_COLOR = u"GridColor"_ustr;
inline constexpr OUString UNO_NAME_GRID_LINES = u"GridLines"_ustr;
inline constexpr OUString UNO_NAME_GRID_BASE_HEIGHT = u"GridBaseHeight"_ustr;
inline constexpr OUString UNO_NAME_GRID_RUBY_HEIGHT = u"GridRubyHeight"_ustr;
inline constexpr OUString UNO_NAME_GRID_MODE = u"GridMode"_ustr;
inline constexpr OUString UNO_NAME_GRID_RUBY_BELOW = u"RubyBelow"_ustr;
inline constexpr OUString UNO_NAME_GRID_PRINT = u"GridPrint"_ustr;
inline constexpr OUString UNO_NAME_GRID_DISPLAY = u"GridDisplay"_ustr;
inline constexpr OUString UNO_NAME_SNAP_TO_GRID = u"SnapToGrid"_ustr;
inline constexpr OUString UNO_NAME_DONT_BALANCE_TEXT_COLUMNS = u"DontBalanceTextColumns"_ustr;
inline constexpr OUString UNO_NAME_IS_CURRENTLY_VISIBLE = u"IsCurrentlyVisible"_ustr;
inline constexpr OUString UNO_NAME_ANCHOR_POSITION = u"AnchorPosition"_ustr;
inline constexpr OUString UNO_NAME_TEXT_READING = u"TextReading"_ustr;
inline constexpr OUString UNO_NAME_PRIMARY_KEY_READING = u"PrimaryKeyReading"_ustr;
inline constexpr OUString UNO_NAME_SECONDARY_KEY_READING = u"SecondaryKeyReading"_ustr;
inline constexpr OUString UNO_NAME_BACK_GRAPHIC_TRANSPARENCY = u"BackGraphicTransparency"_ustr;
inline constexpr OUString UNO_NAME_BACK_COLOR_R_G_B = u"BackColorRGB"_ustr;
inline constexpr OUString UNO_NAME_BACK_COLOR_TRANSPARENCY = u"BackColorTransparency"_ustr;
inline constexpr OUString UNO_NAME_HEADER_DYNAMIC_SPACING = u"HeaderDynamicSpacing"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_DYNAMIC_SPACING = u"FooterDynamicSpacing"_ustr;
inline constexpr OUString UNO_NAME_BASIC_LIBRARIES = u"BasicLibraries"_ustr;
inline constexpr OUString UNO_NAME_IS_FIXED_LANGUAGE = u"IsFixedLanguage"_ustr;
inline constexpr OUString UNO_NAME_SELECTION = u"Selection"_ustr;
inline constexpr OUString UNO_NAME_RESULT_SET = u"ResultSet"_ustr;
inline constexpr OUString UNO_NAME_CONNECTION = u"ActiveConnection"_ustr;
inline constexpr OUString UNO_NAME_MODEL = u"Model"_ustr;
inline constexpr OUString UNO_NAME_DATA_SOURCE_NAME = u"DataSourceName"_ustr;
inline constexpr OUString UNO_NAME_FILTER = u"Filter"_ustr;
inline constexpr OUString UNO_NAME_DOCUMENT_URL = u"DocumentURL"_ustr;
inline constexpr OUString UNO_NAME_OUTPUT_URL = u"OutputURL"_ustr;
inline constexpr OUString UNO_NAME_OUTPUT_TYPE = u"OutputType"_ustr;
inline constexpr OUString UNO_NAME_ESCAPE_PROCESSING = u"EscapeProcessing"_ustr;
inline constexpr OUString UNO_NAME_FILE_NAME_FROM_COLUMN = u"FileNameFromColumn"_ustr;
inline constexpr OUString UNO_NAME_FILE_NAME_PREFIX = u"FileNamePrefix"_ustr;
inline constexpr OUString UNO_NAME_CHAR_STYLE_NAMES = u"CharStyleNames"_ustr;
inline constexpr OUString UNO_NAME_DAD_COMMAND
    = u"Command"_ustr; /* DAD = DataAccessDescriptor (see com.sun.star.sdb.DataAccessDescriptor) */
inline constexpr OUString UNO_NAME_DAD_COMMAND_TYPE = u"CommandType"_ustr;
inline constexpr OUString UNO_NAME_CLSID = u"CLSID"_ustr;
inline constexpr OUString UNO_NAME_COMPONENT = u"Component"_ustr;
inline constexpr OUString UNO_NAME_SECT_LEFT_MARGIN = u"SectionLeftMargin"_ustr;
inline constexpr OUString UNO_NAME_SECT_RIGHT_MARGIN = u"SectionRightMargin"_ustr;
inline constexpr OUString UNO_NAME_PARA_IS_CONNECT_BORDER = u"ParaIsConnectBorder"_ustr;
inline constexpr OUString UNO_NAME_ITEMS = u"Items"_ustr;
inline constexpr OUString UNO_NAME_SELITEM = u"SelectedItem"_ustr;
inline constexpr OUString UNO_NAME_IS_SPLIT_ALLOWED = u"IsSplitAllowed"_ustr;
inline constexpr OUString UNO_NAME_WRAP_TEXT_AT_FLY_START = u"WrapTextAtFlyStart"_ustr;
inline constexpr OUString UNO_NAME_HAS_TEXT_CHANGES_ONLY = u"HasTextChangesOnly"_ustr;
inline constexpr OUString UNO_NAME_CHAR_HIDDEN = u"CharHidden"_ustr;
inline constexpr OUString UNO_NAME_IS_FOLLOWING_TEXT_FLOW = u"IsFollowingTextFlow"_ustr;
inline constexpr OUString UNO_NAME_WIDTH_TYPE = u"WidthType"_ustr;
inline constexpr OUString UNO_NAME_SCRIPT_URL = u"ScriptURL"_ustr;
inline constexpr OUString UNO_NAME_RUNTIME_UID = u"RuntimeUID"_ustr;
inline constexpr OUString UNO_NAME_COLLAPSING_BORDERS = u"CollapsingBorders"_ustr;
inline constexpr OUString UNO_NAME_WRAP_INFLUENCE_ON_POSITION = u"WrapInfluenceOnPosition"_ustr;
inline constexpr OUString UNO_NAME_DATA_BASE_URL = u"DataBaseURL"_ustr;
inline constexpr OUString UNO_NAME_TRANSFORMATION_IN_HORI_L2R = u"TransformationInHoriL2R"_ustr;
inline constexpr OUString UNO_NAME_POSITION_LAYOUT_DIR = u"PositionLayoutDir"_ustr;
inline constexpr OUString UNO_NAME_NUMBERING_IS_OUTLINE = u"NumberingIsOutline"_ustr;
inline constexpr OUString UNO_NAME_STARTPOSITION_IN_HORI_L2R = u"StartPositionInHoriL2R"_ustr;
inline constexpr OUString UNO_NAME_ENDPOSITION_IN_HORI_L2R = u"EndPositionInHoriL2R"_ustr;
inline constexpr OUString UNO_NAME_SUBJECT = u"Subject"_ustr;
inline constexpr OUString UNO_NAME_ADDRESS_FROM_COLUMN = u"AddressFromColumn"_ustr;
inline constexpr OUString UNO_NAME_SEND_AS_HTML = u"SendAsHTML"_ustr;
inline constexpr OUString UNO_NAME_SEND_AS_ATTACHMENT = u"SendAsAttachment"_ustr;
inline constexpr OUString UNO_NAME_MAIL_BODY = u"MailBody"_ustr;
inline constexpr OUString UNO_NAME_ATTACHMENT_NAME = u"AttachmentName"_ustr;
inline constexpr OUString UNO_NAME_ATTACHMENT_FILTER = u"AttachmentFilter"_ustr;
inline constexpr OUString UNO_NAME_PRINT_OPTIONS = u"PrintOptions"_ustr;
inline constexpr OUString UNO_NAME_SAVE_AS_SINGLE_FILE = u"SaveAsSingleFile"_ustr;
inline constexpr OUString UNO_NAME_SAVE_FILTER = u"SaveFilter"_ustr;
inline constexpr OUString UNO_NAME_COPIES_TO = u"CopiesTo"_ustr;
inline constexpr OUString UNO_NAME_BLIND_COPIES_TO = u"BlindCopiesTo"_ustr;
inline constexpr OUString UNO_NAME_IN_SERVER_PASSWORD = u"InServerPassword"_ustr;
inline constexpr OUString UNO_NAME_OUT_SERVER_PASSWORD = u"OutServerPassword"_ustr;
inline constexpr OUString UNO_NAME_SAVE_FILTER_OPTIONS = u"SaveFilterOptions"_ustr;
inline constexpr OUString UNO_NAME_SAVE_FILTER_DATA = u"SaveFilterData"_ustr;
inline constexpr OUString UNO_NAME_LOCK_UPDATES = u"LockUpdates"_ustr;
inline constexpr OUString UNO_NAME_PAGE_COUNT = u"PageCount"_ustr;
inline constexpr OUString UNO_NAME_LINE_COUNT = u"LineCount"_ustr;
inline constexpr OUString UNO_NAME_IS_CONSTANT_SPELLCHECK = u"IsConstantSpellcheck"_ustr;
inline constexpr OUString UNO_NAME_IS_HIDE_SPELL_MARKS
    = u"IsHideSpellMarks"_ustr; /* deprecated #i91949 */

inline constexpr OUString UNO_NAME_IS_FIELD_USED = u"IsFieldUsed"_ustr;
inline constexpr OUString UNO_NAME_IS_FIELD_DISPLAYED = u"IsFieldDisplayed"_ustr;
inline constexpr OUString UNO_NAME_BUILDID = u"BuildId"_ustr;
inline constexpr OUString UNO_NAME_PARA_STYLE_CONDITIONS = u"ParaStyleConditions"_ustr;
inline constexpr OUString UNO_NAME_ROLE = u"Role"_ustr;
inline constexpr OUString UNO_NAME_FIELD_CODE = u"FieldCode"_ustr;
inline constexpr OUString UNO_NAME_HAS_VALID_SIGNATURES = u"HasValidSignatures"_ustr;
inline constexpr OUString UNO_NAME_ALLOW_LINK_UPDATE = u"AllowLinkUpdate"_ustr;
inline constexpr OUString UNO_NAME_CHAR_AUTO_STYLE_NAME = u"CharAutoStyleName"_ustr;
inline constexpr OUString UNO_NAME_PARA_AUTO_STYLE_NAME = u"ParaAutoStyleName"_ustr;
inline constexpr OUString UNO_NAME_LAYOUT_SIZE = u"LayoutSize"_ustr;
inline constexpr OUString UNO_NAME_HELP = u"Help"_ustr;
inline constexpr OUString UNO_NAME_TOOLTIP = u"Tooltip"_ustr;
inline constexpr OUString UNO_NAME_DIALOG_LIBRARIES = u"DialogLibraries"_ustr;
inline constexpr OUString UNO_NAME_HEADER_ROW_COUNT = u"HeaderRowCount"_ustr;
inline constexpr OUString UNO_NAME_INPUT = u"Input"_ustr;
inline constexpr OUString UNO_NAME_ROW_SPAN = u"RowSpan"_ustr;
inline constexpr OUString UNO_NAME_POSITION_AND_SPACE_MODE = u"PositionAndSpaceMode"_ustr;
inline constexpr OUString UNO_NAME_LABEL_FOLLOWED_BY = u"LabelFollowedBy"_ustr;
inline constexpr OUString UNO_NAME_LISTTAB_STOP_POSITION = u"ListtabStopPosition"_ustr;
inline constexpr OUString UNO_NAME_FIRST_LINE_INDENT = u"FirstLineIndent"_ustr;
inline constexpr OUString UNO_NAME_INDENT_AT = u"IndentAt"_ustr;
inline constexpr OUString UNO_NAME_GRID_BASE_WIDTH = u"GridBaseWidth"_ustr;
inline constexpr OUString UNO_NAME_GRID_SNAP_TO_CHARS = u"GridSnapToChars"_ustr;
inline constexpr OUString UNO_NAME_GRID_STANDARD_PAGE_MODE = u"StandardPageMode"_ustr;
inline constexpr OUString UNO_NAME_TABLE_BORDER_DISTANCES = u"TableBorderDistances"_ustr;
inline constexpr OUString UNO_NAME_LIST_ID = u"ListId"_ustr;
inline constexpr OUString UNO_NAME_DEFAULT_LIST_ID = u"DefaultListId"_ustr;
inline constexpr OUString UNO_NAME_STREAM_NAME = u"StreamName"_ustr;
inline constexpr OUString UNO_NAME_PARA_CONTINUEING_PREVIOUS_SUB_TREE
    = u"ContinueingPreviousSubTree"_ustr;
inline constexpr OUString UNO_NAME_PARA_LIST_LABEL_STRING = u"ListLabelString"_ustr;
inline constexpr OUString UNO_NAME_PARA_LIST_AUTO_FORMAT = u"ListAutoFormat"_ustr;
inline constexpr OUString UNO_NAME_CHAR_OVERLINE = u"CharOverline"_ustr;
inline constexpr OUString UNO_NAME_CHAR_OVERLINE_COLOR = u"CharOverlineColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_OVERLINE_COMPLEX_COLOR = u"CharOverlineComplexColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_OVERLINE_HAS_COLOR = u"CharOverlineHasColor"_ustr;
inline constexpr OUString UNO_NAME_OUTLINE_CONTENT_VISIBLE = u"OutlineContentVisible"_ustr;
inline constexpr OUString UNO_NAME_OUTLINE_LEVEL = u"OutlineLevel"_ustr;
inline constexpr OUString UNO_NAME_DESCRIPTION = u"Description"_ustr;
inline constexpr OUString UNO_NAME_META = u"InContentMetadata"_ustr;
inline constexpr OUString UNO_NAME_IS_TEMPLATE = u"IsTemplate"_ustr;
inline constexpr OUString UNO_NAME_VBA_DOCOBJ = u"VBAGlobalConstantName"_ustr;
inline constexpr OUString UNO_NAME_NESTED_TEXT_CONTENT = u"NestedTextContent"_ustr;
inline constexpr OUString UNO_NAME_SEPARATOR_LINE_STYLE = u"SeparatorLineStyle"_ustr;
inline constexpr OUString UNO_NAME_FOOTNOTE_LINE_STYLE = u"FootnoteLineStyle"_ustr;
inline constexpr OUString UNO_NAME_EMBEDDED_OBJECT = u"EmbeddedObject"_ustr;
inline constexpr OUString UNO_NAME_RSID = u"Rsid"_ustr;
inline constexpr OUString UNO_NAME_PARRSID = u"ParRsid"_ustr;
inline constexpr OUString UNO_NAME_DRAW_ASPECT = u"DrawAspect"_ustr;
inline constexpr OUString UNO_NAME_VISIBLE_AREA_WIDTH = u"VisibleAreaWidth"_ustr;
inline constexpr OUString UNO_NAME_VISIBLE_AREA_HEIGHT = u"VisibleAreaHeight"_ustr;

inline constexpr OUString UNO_NAME_LINE_STYLE = u"LineStyle"_ustr;
inline constexpr OUString UNO_NAME_LINE_WIDTH = u"LineWidth"_ustr;

inline constexpr OUString UNO_NAME_PARA_CONTEXT_MARGIN = u"ParaContextMargin"_ustr;
inline constexpr OUString UNO_NAME_PARAGRAPH_STYLE_NAME = u"ParagraphStyleName"_ustr;
inline constexpr OUString UNO_NAME_FIRST_IS_SHARED = u"FirstIsShared"_ustr;
inline constexpr OUString UNO_NAME_HEADER_TEXT_FIRST = u"HeaderTextFirst"_ustr;
inline constexpr OUString UNO_NAME_FOOTER_TEXT_FIRST = u"FooterTextFirst"_ustr;
inline constexpr OUString UNO_NAME_INITIALS = u"Initials"_ustr;
inline constexpr OUString UNO_NAME_TABLE_BORDER2 = u"TableBorder2"_ustr;
inline constexpr OUString UNO_NAME_REPLACEMENT_GRAPHIC = u"ReplacementGraphic"_ustr;
inline constexpr OUString UNO_NAME_HIDDEN = u"Hidden"_ustr;
inline constexpr OUString UNO_NAME_DEFAULT_PAGE_MODE = u"DefaultPageMode"_ustr;
inline constexpr OUString UNO_NAME_CHAR_SHADING_VALUE = u"CharShadingValue"_ustr;
inline constexpr OUString UNO_NAME_PARA_INTEROP_GRAB_BAG = u"ParaInteropGrabBag"_ustr;
inline constexpr OUString UNO_NAME_CHAR_LEFT_BORDER = u"CharLeftBorder"_ustr;
inline constexpr OUString UNO_NAME_CHAR_RIGHT_BORDER = u"CharRightBorder"_ustr;
inline constexpr OUString UNO_NAME_CHAR_TOP_BORDER = u"CharTopBorder"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BOTTOM_BORDER = u"CharBottomBorder"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BORDER_DISTANCE = u"CharBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_CHAR_LEFT_BORDER_DISTANCE = u"CharLeftBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_CHAR_RIGHT_BORDER_DISTANCE = u"CharRightBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_CHAR_TOP_BORDER_DISTANCE = u"CharTopBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BOTTOM_BORDER_DISTANCE = u"CharBottomBorderDistance"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BORDER_LEFT_COMPLEX_COLOR
    = u"CharLeftBorderComplexColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BORDER_RIGHT_COMPLEX_COLOR
    = u"CharRightBorderComplexColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BORDER_TOP_COMPLEX_COLOR
    = u"CharTopBorderComplexColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_BORDER_BOTTOM_COMPLEX_COLOR
    = u"CharBottomBorderComplexColor"_ustr;
inline constexpr OUString UNO_NAME_CHAR_SHADOW_FORMAT = u"CharShadowFormat"_ustr;
inline constexpr OUString UNO_NAME_SHADOW_TRANSPARENCE = u"ShadowTransparence"_ustr;
inline constexpr OUString UNO_NAME_DOC_INTEROP_GRAB_BAG = u"InteropGrabBag"_ustr;
inline constexpr OUString UNO_NAME_FRAME_INTEROP_GRAB_BAG = u"FrameInteropGrabBag"_ustr;
inline constexpr OUString UNO_NAME_CHAR_HIGHLIGHT = u"CharHighlight"_ustr;
inline constexpr OUString UNO_NAME_STYLE_INTEROP_GRAB_BAG = u"StyleInteropGrabBag"_ustr;
inline constexpr OUString UNO_NAME_LEVEL_IS_LEGAL = u"IsLegal"_ustr;
inline constexpr OUString UNO_NAME_CHAR_INTEROP_GRAB_BAG = u"CharInteropGrabBag"_ustr;
inline constexpr OUString UNO_NAME_TEXT_VERT_ADJUST = u"TextVerticalAdjust"_ustr;
inline constexpr OUString UNO_NAME_CELL_INTEROP_GRAB_BAG = u"CellInteropGrabBag"_ustr;
inline constexpr OUString UNO_NAME_ROW_INTEROP_GRAB_BAG = u"RowInteropGrabBag"_ustr;
inline constexpr OUString UNO_NAME_TABLE_INTEROP_GRAB_BAG = u"TableInteropGrabBag"_ustr;

inline constexpr OUString UNO_NAME_TABLE_FIRST_ROW_END_COLUMN = u"FirstRowEndColumn"_ustr;
inline constexpr OUString UNO_NAME_TABLE_FIRST_ROW_START_COLUMN = u"FirstRowStartColumn"_ustr;
inline constexpr OUString UNO_NAME_TABLE_LAST_ROW_END_COLUMN = u"LastRowEndColumn"_ustr;
inline constexpr OUString UNO_NAME_TABLE_LAST_ROW_START_COLUMN = u"LastRowStartColumn"_ustr;

inline constexpr OUString UNO_NAME_RESOLVED = u"Resolved"_ustr;
inline constexpr OUString UNO_NAME_ALLOW_OVERLAP = u"AllowOverlap"_ustr;
inline constexpr OUString UNO_NAME_CLEAR = u"Clear"_ustr;
inline constexpr OUString UNO_NAME_LINEBREAK = u"LineBreak"_ustr;
inline constexpr OUString UNO_NAME_CONTENT_CONTROL = u"ContentControl"_ustr;
inline constexpr OUString UNO_NAME_SHOWING_PLACE_HOLDER = u"ShowingPlaceHolder"_ustr;
inline constexpr OUString UNO_NAME_CHECKBOX = u"Checkbox"_ustr;
inline constexpr OUString UNO_NAME_CHECKED = u"Checked"_ustr;
inline constexpr OUString UNO_NAME_CHECKED_STATE = u"CheckedState"_ustr;
inline constexpr OUString UNO_NAME_UNCHECKED_STATE = u"UncheckedState"_ustr;
inline constexpr OUString UNO_NAME_LIST_ITEMS = u"ListItems"_ustr;
inline constexpr OUString UNO_NAME_PICTURE = u"Picture"_ustr;
inline constexpr OUString UNO_NAME_DATE_FORMAT = u"DateFormat"_ustr;
inline constexpr OUString UNO_NAME_DATE_LANGUAGE = u"DateLanguage"_ustr;
inline constexpr OUString UNO_NAME_CURRENT_DATE = u"CurrentDate"_ustr;
inline constexpr OUString UNO_NAME_PLAIN_TEXT = u"PlainText"_ustr;
inline constexpr OUString UNO_NAME_COMBO_BOX = u"ComboBox"_ustr;
inline constexpr OUString UNO_NAME_DROP_DOWN = u"DropDown"_ustr;
inline constexpr OUString UNO_NAME_PLACEHOLDER_DOC_PART = u"PlaceholderDocPart"_ustr;
inline constexpr OUString UNO_NAME_DATA_BINDING_PREFIX_MAPPINGS = u"DataBindingPrefixMappings"_ustr;
inline constexpr OUString UNO_NAME_DATA_BINDING_XPATH = u"DataBindingXpath"_ustr;
inline constexpr OUString UNO_NAME_DATA_BINDING_STORE_ITEM_ID = u"DataBindingStoreItemID"_ustr;
inline constexpr OUString UNO_NAME_COLOR = u"Color"_ustr;
inline constexpr OUString UNO_NAME_APPEARANCE = u"Appearance"_ustr;
inline constexpr OUString UNO_NAME_ALIAS = u"Alias"_ustr;
inline constexpr OUString UNO_NAME_TAG = u"Tag"_ustr;
inline constexpr OUString UNO_NAME_ID = u"Id"_ustr;
inline constexpr OUString UNO_NAME_TAB_INDEX = u"TabIndex"_ustr;
inline constexpr OUString UNO_NAME_LOCK = u"Lock"_ustr;
inline constexpr OUString UNO_NAME_MULTILINE = u"MultiLine"_ustr;
inline constexpr OUString UNO_NAME_DATE_STRING = u"DateString"_ustr;
inline constexpr OUString UNO_NAME_PARA_ID = u"ParaId"_ustr;
inline constexpr OUString UNO_NAME_PARA_ID_PARENT = u"ParaIdParent"_ustr;
#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
