/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.crypto.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public final class GMACUtil {
    private GMACUtil() {
    }

    public static byte[] sign(SecretKey key, byte[] iv, byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, (Key)key, new GCMParameterSpec(128, iv));
        cipher.updateAAD(data);
        return cipher.doFinal();
    }

    public static void verify(SecretKey key, byte[] iv, byte[] tag, byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)key, new GCMParameterSpec(128, iv));
        cipher.updateAAD(data);
        cipher.doFinal(tag);
    }

    public static void verify(SecretKey key, byte[] mac, byte[] data) throws GeneralSecurityException {
        byte[] iv = Arrays.copyOfRange(mac, 0, 12);
        byte[] tag = Arrays.copyOfRange(mac, 12, mac.length);
        GMACUtil.verify(key, iv, tag, data);
    }
}

