/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUtils;
import com.paterva.maltego.ui.graph.view2d.PinUtils;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.util.ui.fonts.FontFallbackStringPainter;
import com.paterva.maltego.util.ui.laf.Colors;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import yguard.A.A.Y;
import yguard.A.I.K;
import yguard.A.J.BA;
import yguard.A.J.SA;
import yguard.A.J.X;
import yguard.A.J.ZA;
import yguard.A.J.gB;

public class EntityLabelConfigs {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static String _notesLabelConfig;
    private static String _bookmarkLabelConfig;
    private static String _pinLabelConfig;
    private static String _notesEditLabelConfig;

    private EntityLabelConfigs() {
    }

    public static synchronized String getNotesLabelConfig() {
        if (_notesLabelConfig == null) {
            _notesLabelConfig = "Notes";
            X._A factory = gB.getFactory();
            Map implementationsMap = factory.B();
            NotesConfig notesConfig = new NotesConfig();
            implementationsMap.put(X._C.class, notesConfig);
            implementationsMap.put(X._I.class, notesConfig);
            factory.A(_notesLabelConfig, implementationsMap);
        }
        return _notesLabelConfig;
    }

    public static synchronized String getBookmarkLabelConfig() {
        if (_bookmarkLabelConfig == null) {
            _bookmarkLabelConfig = "Bookmark";
            X._A factory = gB.getFactory();
            Map implementationsMap = factory.B();
            BookmarkConfig bookmarkConfig = new BookmarkConfig();
            implementationsMap.put(X._C.class, bookmarkConfig);
            implementationsMap.put(X._I.class, bookmarkConfig);
            factory.A(_bookmarkLabelConfig, implementationsMap);
        }
        return _bookmarkLabelConfig;
    }

    public static synchronized String getPinLabelConfig() {
        if (_pinLabelConfig == null) {
            _pinLabelConfig = "Pin";
            X._A factory = gB.getFactory();
            Map implementationsMap = factory.B();
            PinConfig pinConfig = new PinConfig();
            implementationsMap.put(X._C.class, pinConfig);
            implementationsMap.put(X._I.class, pinConfig);
            factory.A(_pinLabelConfig, implementationsMap);
        }
        return _pinLabelConfig;
    }

    public static synchronized String getNotesEditLabelConfig() {
        if (_notesEditLabelConfig == null) {
            _notesEditLabelConfig = "NotesEdit";
            X._A factory = gB.getFactory();
            Map implementationsMap = factory.B();
            NotesEditConfig notesEditConfig = new NotesEditConfig();
            implementationsMap.put(X._C.class, notesEditConfig);
            implementationsMap.put(X._I.class, notesEditConfig);
            factory.A(_notesEditLabelConfig, implementationsMap);
        }
        return _notesEditLabelConfig;
    }

    public static double getNotesCloseX(X label) {
        return label.getWidth() - 5.0 - 11.0;
    }

    public static double getNotesCloseY(X label) {
        return 5.0;
    }

    public static Rectangle2D.Double getNotesCloseRect(X label) {
        return new Rectangle2D.Double(EntityLabelConfigs.getNotesCloseX(label), EntityLabelConfigs.getNotesCloseY(label), 5.0, 5.0);
    }

    private static class NotesEditConfig
    extends ZA {
        private static final boolean OLD_PAINTING = false;
        private double _oldScale = 0.0;
        private boolean _updateSizes = false;

        private NotesEditConfig() {
        }

        public void paintBox(X label, Graphics2D g2D, double xPos, double yPos, double width, double height) {
            Color lineColor;
            double x2 = Math.ceil(xPos + 1.0);
            double y2 = Math.ceil(yPos + 1.0);
            double w = Math.floor(width - 5.0 - 3.0);
            double h = Math.floor(height - 5.0 - 3.0);
            Shape shape = new Rectangle2D.Double(x2, y2, w, h);
            double cx = x2 + w * 0.5;
            double cy = y2 + h * 0.5;
            if (label instanceof gB) {
                double dy;
                double dx;
                double l;
                BA labelRealizer = ((gB)label).getRealizer();
                Y node = ((gB)label).getNode();
                SA graph2D = (SA)node.H();
                BA nodeRealizer = graph2D.f(node);
                double tx = graph2D.S(node);
                double ty = graph2D.O(node);
                if (!nodeRealizer.contains(cx, cy)) {
                    double dirX = cx - labelRealizer.getCenterX();
                    double dirY = cy - labelRealizer.getCenterY();
                    Point2D.Double result = new Point2D.Double();
                    nodeRealizer.findIntersection(tx, ty, cx, cy, (Point2D)result);
                    double l0 = Math.sqrt(dirX * dirX + dirY * dirY);
                    if (l0 > 0.0) {
                        tx = ((Point2D)result).getX() - 10.0 * dirX / l0;
                        ty = ((Point2D)result).getY() - 10.0 * dirY / l0;
                    }
                }
                if ((l = Math.sqrt((dx = cx - tx) * dx + (dy = cy - ty) * dy)) > 0.0) {
                    double size = Math.min(w, h) * 0.25;
                    GeneralPath p = new GeneralPath();
                    p.moveTo((float)tx, (float)ty);
                    p.lineTo((float)(cx + dy * size / l), (float)(cy - dx * size / l));
                    p.lineTo((float)(cx - dy * size / l), (float)(cy + dx * size / l));
                    p.closePath();
                    Area area = new Area(shape);
                    area.add(new Area(p));
                    shape = area;
                }
            }
            g2D.setStroke(new BasicStroke(1.0f, 1, 1));
            Color backgroundColor = BookmarkFactory.getDefault().getColor(Integer.valueOf(NodeLabelUtils.getBookmark(label)));
            if (backgroundColor != null) {
                g2D.setColor(label.getBackgroundColor());
                g2D.fill(shape);
                g2D.setColor(backgroundColor);
                g2D.fillRect((int)x2, (int)y2, (int)w, 10);
            }
            if ((lineColor = label.getLineColor()) != null) {
                g2D.setColor(lineColor);
                g2D.draw(shape);
            }
            g2D.setColor(LAF.getColor("note-close-button-color"));
            g2D.translate(xPos, yPos);
            Rectangle2D.Double notesCloseRect = EntityLabelConfigs.getNotesCloseRect(label);
            g2D.drawLine((int)notesCloseRect.x, (int)notesCloseRect.y, (int)(notesCloseRect.x + notesCloseRect.width), (int)(notesCloseRect.y + notesCloseRect.height));
            g2D.drawLine((int)(notesCloseRect.x + notesCloseRect.width), (int)notesCloseRect.y, (int)notesCloseRect.x, (int)(notesCloseRect.y + notesCloseRect.height));
            g2D.translate(-xPos, -yPos);
        }

        public void paintContent(X ylabel, Graphics2D g2D, double x2, double y2, double width, double height) {
            if (ylabel.isVisible()) {
                this.paintBox(ylabel, g2D, x2, y2, width, height);
                x2 += 10.0;
                y2 += 10.0;
                width = width - 20.0 - 5.0;
                height = height - 20.0 - 5.0;
                String text = ylabel.getText();
                Font preferredFont = ylabel.getFont();
                Color textColor = ylabel.getTextColor();
                FontFallbackStringPainter.paint((Graphics2D)g2D, (String)text, (Font)preferredFont, (Color)textColor, (float)((float)x2), (float)((float)y2 + preferredFont.getSize2D()), (boolean)false);
            }
        }

        public void paint(X ylabel, Graphics2D g2D) {
            double scaleX = GraphicsUtils.getZoom((Graphics2D)g2D);
            if (scaleX != this._oldScale) {
                this._oldScale = scaleX;
                if (!this._updateSizes) {
                    this._updateSizes = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            _updateSizes = false;
                        }
                    });
                }
            }
            if (this._updateSizes || this.mustUpdateSize(ylabel)) {
                this.calculateContentSize(ylabel, g2D.getFontRenderContext());
            }
            K bounds = ylabel.getBox().A();
            this.paintContent(ylabel, g2D, bounds.\u00fa, bounds.\u00fc, bounds.\u00f9, bounds.\u00f8);
        }

        public void calculateContentSize(X ylabel, FontRenderContext frc) {
            try {
                ylabel.getContentBox();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int extra = 25;
            if (ylabel.isVisible()) {
                Rectangle2D size = NodeLabelUtils.calculateFontFallbackSize(ylabel, frc);
                ylabel.setContentSize(size.getWidth() + (double)extra, size.getHeight() + (double)extra);
            } else {
                ylabel.setContentSize(1.0, 1.0);
            }
        }

        private boolean mustUpdateSize(X ylabel) {
            return ylabel.isVisible() && ylabel.getContentHeight() < 2.0 || !ylabel.isVisible() && ylabel.getContentHeight() > 1.0;
        }
    }

    private static class PinConfig
    extends HoveredScaledConfig {
        private PinConfig() {
        }

        @Override
        protected void paintScaled(X ylabel, Graphics2D g2D, double w, double h) {
            boolean pinned = PinUtils.isPinned(ylabel);
            boolean isHovered = this.isHovered(ylabel);
            GraphicsUtils.drawPin((Graphics2D)g2D, (double)0.0, (double)0.0, (double)w, (boolean)pinned, (boolean)isHovered, (boolean)false);
        }

        public void calculateContentSize(X ylabel, FontRenderContext frc) {
            ylabel.setContentSize(16.0, 16.0);
        }
    }

    private static class BookmarkConfig
    extends HoveredScaledConfig {
        private BookmarkConfig() {
        }

        @Override
        protected void paintScaled(X ylabel, Graphics2D g2D, double w, double h) {
            BookmarkFactory factory = BookmarkFactory.getDefault();
            Color color = factory.getColor(Integer.valueOf(NodeLabelUtils.getBookmark(ylabel)));
            boolean isHovered = this.isHovered(ylabel);
            GraphicsUtils.drawBookMark((Graphics2D)g2D, (int)0, (int)0, (int)((int)w), (int)((int)h), (Color)color, (boolean)isHovered);
        }

        public void calculateContentSize(X ylabel, FontRenderContext frc) {
            ylabel.setContentSize(17.0, 18.0);
        }
    }

    private static class NotesConfig
    extends HoveredScaledConfig {
        private NotesConfig() {
        }

        @Override
        public void paintBox(X ylabel, Graphics2D g2D, double xPos, double yPos, double width, double height) {
            xPos = Math.ceil(xPos);
            yPos = Math.ceil(yPos);
            width = Math.floor(width - 1.0);
            height = Math.floor(height - 3.0);
            super.paintBox(ylabel, g2D, xPos, yPos, width, height);
        }

        @Override
        protected void paintScaled(X ylabel, Graphics2D g2D, double w, double h) {
            Color color = ylabel.getBackgroundColor();
            Color brightColor = Colors.getQuarkXPressShade((Color)color, (float)80.0f);
            Color darkColor = new Color(50, 50, 50, color.getAlpha());
            int corner = (int)w / 2;
            int margin = 3;
            int[] xPoints = new int[]{3, 3, (int)(w - 3.0), (int)(w - 3.0), corner, 3};
            int[] yPoints = new int[]{3, (int)(h - 3.0), (int)(h - 3.0), corner, 3, 3};
            if (this.isHovered(ylabel)) {
                g2D.setColor(color);
            } else {
                g2D.setPaint(brightColor);
            }
            g2D.fillPolygon(xPoints, yPoints, xPoints.length);
            if (this.isHovered(ylabel)) {
                g2D.setStroke(new BasicStroke(5.0f, 1, 1));
                g2D.setColor(Color.BLACK);
            } else {
                g2D.setStroke(new BasicStroke(2.0f, 1, 1));
                g2D.setColor(darkColor);
            }
            g2D.drawPolygon(xPoints, yPoints, xPoints.length);
            g2D.drawLine(corner, 3, corner, corner);
            g2D.drawLine(corner, corner, (int)(w - 3.0), corner);
        }

        public void calculateContentSize(X ylabel, FontRenderContext frc) {
            ylabel.setContentSize(12.0, 17.0);
        }
    }

    private static abstract class HoveredScaledConfig
    extends ZA {
        private HoveredScaledConfig() {
        }

        protected abstract void paintScaled(X var1, Graphics2D var2, double var3, double var5);

        public void paintBox(X ylabel, Graphics2D g2D, double xPos, double yPos, double width, double height) {
            AffineTransform oldTransform = g2D.getTransform();
            double scale = 0.1f;
            g2D.scale(scale, scale);
            double x2 = xPos / scale;
            double y2 = yPos / scale;
            double w = width / scale;
            double h = height / scale;
            g2D.translate(x2, y2);
            this.paintScaled(ylabel, g2D, w, h);
            g2D.setTransform(oldTransform);
        }

        protected boolean isHovered(X ylabel) {
            return NodeLabelUtils.isHover(ylabel);
        }
    }
}

