/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.actions.AbstractAction;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Exceptions;

class DeleteAction
extends AbstractAction {
    public DeleteAction() {
        super("delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        try {
            if (!payload.isEmpty()) {
                int parents = this.getParentLevels();
                int children = this.getChildLevels();
                if (parents == 0 && children == 0) {
                    this.delete(ctx, GraphStoreHelper.getIds(payload.getEntities()));
                } else {
                    GraphID graphID = ctx.getTargetGraphID();
                    Set<EntityID> list = this.buildDeleteList(graphID, payload, parents, children);
                    this.delete(ctx, list);
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            cb.completed(Payloads.getEmpty());
        }
    }

    private void delete(AutomationContext ctx, Set<EntityID> entities) {
        int count = 0;
        for (EntityID e : entities) {
            ctx.clearProperties(e);
            ++count;
            ctx.getLogger().debug("** Deleting %s", this.toString(ctx, e));
        }
        if (!entities.isEmpty()) {
            GraphID graphID = ctx.getTargetGraphID();
            String descriptionStr = "%s " + GraphTransactionHelper.getDescriptionForEntityIDs((GraphID)graphID, entities, (boolean)true);
            SimilarStrings description = new SimilarStrings(descriptionStr, "Delete", "Add");
            GraphTransactionHelper.doDeleteEntities((SimilarStrings)description, (GraphID)graphID, entities);
        }
        ctx.getLogger().info("Deleted %d entities", count);
    }

    private String toString(AutomationContext ctx, EntityID entityID) {
        MaltegoEntity entity = GraphStoreHelper.getEntity((GraphID)ctx.getTargetGraphID(), (EntityID)entityID);
        Object value = InheritanceHelper.getValue((SpecRegistry)ctx.getEntityRegistry(), (TypedPropertyBag)entity);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private int getParentLevels() {
        return (Integer)this.getProperty("parents", 0);
    }

    private int getChildLevels() {
        return (Integer)this.getProperty("children", 0);
    }

    private Set<EntityID> buildDeleteList(GraphID graphID, Payload payload, int parents, int children) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        HashSet<EntityID> list = new HashSet<EntityID>();
        for (EntityID entityID : payload.getEntityIDs()) {
            this.addMeAndParents(structureReader, entityID, list, parents);
            this.addMeAndChildren(structureReader, entityID, list, children);
        }
        return list;
    }

    private void addMeAndParents(GraphStructureReader structureReader, EntityID entityID, Collection<EntityID> list, int level) throws GraphStoreException {
        if (level >= 0) {
            list.add(entityID);
            --level;
            Set parents = structureReader.getParents(entityID);
            for (EntityID id : parents) {
                this.addMeAndParents(structureReader, id, list, level);
            }
        }
    }

    private void addMeAndChildren(GraphStructureReader structureReader, EntityID entityID, Collection<EntityID> list, int level) throws GraphStoreException {
        if (level >= 0) {
            list.add(entityID);
            --level;
            Set children = structureReader.getChildren(entityID);
            for (EntityID id : children) {
                this.addMeAndChildren(structureReader, id, list, level);
            }
        }
    }
}

