/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.sort.PartSortAndFilterInfo;
import com.paterva.maltego.treelist.lazy.outline.SortPermutations;
import com.paterva.maltego.treelist.parts.CachedLazyPartsProvider;
import com.paterva.maltego.treelist.parts.PartLoadedCallback;
import com.paterva.maltego.treelist.parts.PartsTreeModelEvent;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import com.paterva.maltego.util.ui.WindowUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public abstract class AbstractPartsTreelistModel<PartID extends Guid, Part extends MaltegoPart<PartID>>
implements PartsTreelistModel<PartID, Part> {
    private static final Logger LOG = Logger.getLogger(AbstractPartsTreelistModel.class.getName());
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private PropertyChangeListener _graphStoreModelListener;
    private boolean _firingDataChange = false;

    protected abstract CachedLazyPartsProvider<PartID, Part> getPartsProvider();

    protected abstract PropertyChangeListener createGraphStoreModelListener();

    protected abstract PropertyChangeListener createGraphStoreViewListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModelParts(GraphID graphID, Set<PartID> modelPartIDs) {
        GraphID previousGraphID = this.getGraphID();
        boolean incrementalUpdateWorks = false;
        boolean graphChanged = !Utilities.compareObjects((Object)graphID, (Object)previousGraphID);
        Set<PartID> oldIDs = this.getPartsProvider().getActiveModelPartIDSet();
        LOG.log(Level.FINE, "Old IDs: {0}", oldIDs);
        LOG.log(Level.FINE, "New IDs: {0}", modelPartIDs);
        if (graphChanged || !modelPartIDs.equals(oldIDs)) {
            boolean showWait = modelPartIDs.size() > 100;
            try {
                if (showWait) {
                    WindowUtil.showWaitCursor();
                }
                LOG.log(Level.FINE, "GraphID: {0}", graphID);
                LOG.log(Level.FINE, "Parts: {0}", modelPartIDs);
                this.removeListeners(previousGraphID);
                this.getPartsProvider().setGraphID(graphID);
                this.getPartsProvider().setActiveModelPartIDs(modelPartIDs);
                this.addListeners(graphID);
                this.fireGraphChanged();
            }
            finally {
                if (showWait) {
                    WindowUtil.hideWaitCursor();
                }
            }
        }
    }

    @Override
    public GraphID getGraphID() {
        return this.getPartsProvider().getGraphID();
    }

    @Override
    public int getModelPartCount() {
        List<PartID> partIDs = this.getPartsProvider().getActiveModelPartIDs();
        return partIDs == null ? 0 : partIDs.size();
    }

    @Override
    public PartID getModelPartID(int index) {
        List<PartID> partIDs = this.getPartsProvider().getActiveModelPartIDs();
        return (PartID)(partIDs == null || index >= partIDs.size() ? null : (Guid)partIDs.get(index));
    }

    @Override
    public List<PartID> getSortedFilteredPartIDs() {
        return this.getPartsProvider().getSortedModelPartIDs();
    }

    @Override
    public int getModelPartIndex(PartID modelPartID) {
        List<PartID> partIDs = this.getPartsProvider().getActiveModelPartIDs();
        return partIDs == null ? -1 : partIDs.indexOf(modelPartID);
    }

    @Override
    public Optional<Part> getModelPart(PartID modelPartID, PartLoadedCallback<Part> cb) {
        return this.getPartsProvider().getPart(modelPartID, cb);
    }

    @Override
    public SortPermutations getSortPermutations(PartSortAndFilterInfo partSortOrder) {
        return this.getPartsProvider().getSortPermutations(partSortOrder);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isFiringDataChange() {
        return this._firingDataChange;
    }

    protected void fireGraphChanged() {
        this.fire("graphChanged", null);
    }

    protected void firePartsAdded(List<Integer> indexes, List<PartID> ids) {
        LOG.log(Level.FINE, "Parts added: {0} {1}", new Object[]{ids, indexes});
        this.fire("partsAdded", new PartsTreeModelEvent<PartID>(indexes, ids));
    }

    protected void firePartsRemoved(List<Integer> indexes, List<PartID> ids) {
        LOG.log(Level.FINE, "Parts removed: {0} {1}", new Object[]{ids, indexes});
        this.fire("partsRemoved", new PartsTreeModelEvent<PartID>(indexes, ids));
    }

    protected void firePartsChanged(List<Integer> indexes, List<PartID> ids) {
        LOG.log(Level.FINE, "Parts changed: {0} {1}", new Object[]{ids, indexes});
        this.fire("partsChanged", new PartsTreeModelEvent<PartID>(indexes, ids));
    }

    private void fire(String property, PartsTreeModelEvent<PartID> event) {
        try {
            this._firingDataChange = true;
            this._changeSupport.firePropertyChange(property, "", event);
        }
        finally {
            this._firingDataChange = false;
        }
    }

    @Override
    public void addListeners() {
        this.addListeners(this.getGraphID());
    }

    @Override
    public void removeListeners() {
        this.removeListeners(this.getGraphID());
    }

    private void addListeners(GraphID graphID) {
        try {
            if (graphID != null) {
                this._graphStoreModelListener = this.createGraphStoreModelListener();
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                graphStore.addPropertyChangeListener(this._graphStoreModelListener);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void removeListeners(GraphID graphID) {
        try {
            if (graphID != null && GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                graphStore.removePropertyChangeListener(this._graphStoreModelListener);
            }
            this._graphStoreModelListener = null;
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

