/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.util.Arrays;

public class SimilarStrings {
    private static final Object[] NO_ARGS = new Object[0];
    private final String _formatString;
    private final Object[] _oneArgs;
    private final Object[] _twoArgs;

    public static String escape(String formatStringPart) {
        return formatStringPart.replace("%", "%%");
    }

    public SimilarStrings(String formatString, Object[] oneArgs, Object[] twoArgs) {
        if (formatString == null) {
            throw new IllegalArgumentException("Format string may not be null");
        }
        this._formatString = formatString;
        this._oneArgs = oneArgs;
        this._twoArgs = twoArgs;
    }

    public SimilarStrings(String formatString, String oneArg, String twoArg) {
        this(formatString, new Object[]{oneArg}, new Object[]{twoArg});
    }

    public SimilarStrings(String string) {
        this(string, NO_ARGS, NO_ARGS);
    }

    public SimilarStrings(String one, String two) {
        this("%s", new Object[]{one}, new Object[]{two});
    }

    public SimilarStrings createInverse() {
        return new SimilarStrings(this._formatString, this._twoArgs, this._oneArgs);
    }

    public String getStringOne() {
        return this.format(this.getOneArgs());
    }

    public String getStringTwo() {
        return this.format(this.getTwoArgs());
    }

    public String getFormatString() {
        return this._formatString;
    }

    public Object[] getOneArgs() {
        return this._oneArgs;
    }

    public Object[] getTwoArgs() {
        return this._twoArgs;
    }

    private String format(Object[] args) {
        try {
            return String.format(this._formatString, args);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to format '" + this._formatString + "' with args: " + Arrays.toString(args), ex);
        }
    }
}

