/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp.bosh;

import com.paterva.maltego.collab.session.xmpp.bosh.BoshDebugProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import org.apache.commons.io.input.TeeInputStream;

class BoshDebugSocket
extends Socket {
    public BoshDebugSocket() throws SocketException {
        super(new BoshSocketImpl());
    }

    private static class BoshSocketImpl
    extends SocketImpl {
        private Socket _socket;
        private PipedOutputStream _output;
        private PipedInputStream _pipedInput;
        private OutputStream _socketOutput;
        private TeeInputStream _teeInput;
        private BoshDebugProxy _proxy;

        private BoshSocketImpl() {
        }

        @Override
        protected void create(boolean stream) throws IOException {
            this._socket = new Socket();
        }

        @Override
        protected void connect(String host, int port) throws IOException {
            this.connect(new InetSocketAddress(host, port), 0);
        }

        @Override
        protected void connect(InetAddress address, int port) throws IOException {
            this.connect(new InetSocketAddress(address, port), 0);
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            this._socket.connect(address, timeout);
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
            this._socket.bind(new InetSocketAddress(host, port));
        }

        @Override
        protected void listen(int backlog) throws IOException {
        }

        @Override
        protected void accept(SocketImpl s) throws IOException {
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return this._socket.getInputStream();
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            if (this._output == null) {
                this.initProxy();
            }
            return this._output;
        }

        @Override
        protected int available() throws IOException {
            return this.getInputStream().available();
        }

        @Override
        protected void close() throws IOException {
            if (this._proxy != null) {
                this._proxy.stop();
            }
            try {
                if (this._output != null) {
                    this._output.close();
                }
            }
            finally {
                try {
                    if (this._teeInput != null) {
                        this._teeInput.close();
                    }
                }
                finally {
                    this._socket.close();
                }
            }
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            return null;
        }

        private void initProxy() throws IOException {
            this._pipedInput = new PipedInputStream();
            this._output = new PipedOutputStream(this._pipedInput);
            this._socketOutput = this._socket.getOutputStream();
            this._teeInput = new TeeInputStream(this._pipedInput, this._socketOutput, false);
            this._proxy = new BoshDebugProxy(this._teeInput);
            this._proxy.start();
        }
    }
}

