/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;

public interface SubjectCredentialManager {
    public boolean isValid(List<CredentialInput> var1);

    default public boolean isValid(CredentialInput ... inputs) {
        return this.isValid(Arrays.asList(inputs));
    }

    public boolean updateCredential(CredentialInput var1);

    public void updateStoredCredential(CredentialModel var1);

    public CredentialModel createStoredCredential(CredentialModel var1);

    public boolean removeStoredCredentialById(String var1);

    public CredentialModel getStoredCredentialById(String var1);

    public Stream<CredentialModel> getStoredCredentialsStream();

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(String var1);

    public CredentialModel getStoredCredentialByNameAndType(String var1, String var2);

    public boolean moveStoredCredentialTo(String var1, String var2);

    public void updateCredentialLabel(String var1, String var2);

    public void disableCredentialType(String var1);

    public Stream<String> getDisableableCredentialTypesStream();

    public boolean isConfiguredFor(String var1);

    @Deprecated
    public boolean isConfiguredLocally(String var1);

    @Deprecated
    public Stream<String> getConfiguredUserStorageCredentialTypesStream();

    @Deprecated
    public CredentialModel createCredentialThroughProvider(CredentialModel var1);
}

