/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

public class ServiceDiscoveryManager {
    private static String identityName = "Smack";
    private static String identityType = "pc";
    private static Map<Connection, ServiceDiscoveryManager> instances = new ConcurrentHashMap<Connection, ServiceDiscoveryManager>();
    private Connection connection;
    private final List<String> features = new ArrayList<String>();
    private DataForm extendedInfo = null;
    private Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();

    public ServiceDiscoveryManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    public static ServiceDiscoveryManager getInstanceFor(Connection connection) {
        return instances.get(connection);
    }

    public static String getIdentityName() {
        return identityName;
    }

    public static void setIdentityName(String name) {
        identityName = name;
    }

    public static String getIdentityType() {
        return identityType;
    }

    public static void setIdentityType(String type) {
        identityType = type;
    }

    private void init() {
        instances.put(this.connection, this);
        this.connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                instances.remove(ServiceDiscoveryManager.this.connection);
            }

            @Override
            public void connectionClosedOnError(Exception e) {
            }

            @Override
            public void reconnectionFailed(Exception e) {
            }

            @Override
            public void reconnectingIn(int seconds) {
            }

            @Override
            public void reconnectionSuccessful() {
            }
        });
        PacketTypeFilter packetFilter = new PacketTypeFilter(DiscoverItems.class);
        PacketListener packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                DiscoverItems discoverItems = (DiscoverItems)packet;
                if (discoverItems != null && discoverItems.getType() == IQ.Type.GET) {
                    DiscoverItems response = new DiscoverItems();
                    response.setType(IQ.Type.RESULT);
                    response.setTo(discoverItems.getFrom());
                    response.setPacketID(discoverItems.getPacketID());
                    response.setNode(discoverItems.getNode());
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                    if (nodeInformationProvider != null) {
                        List<DiscoverItems.Item> items = nodeInformationProvider.getNodeItems();
                        if (items != null) {
                            for (DiscoverItems.Item item : items) {
                                response.addItem(item);
                            }
                        }
                    } else if (discoverItems.getNode() != null) {
                        response.setType(IQ.Type.ERROR);
                        response.setError(new XMPPError(XMPPError.Condition.item_not_found));
                    }
                    ServiceDiscoveryManager.this.connection.sendPacket(response);
                }
            }
        };
        this.connection.addPacketListener(packetListener, packetFilter);
        packetFilter = new PacketTypeFilter(DiscoverInfo.class);
        packetListener = new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processPacket(Packet packet) {
                DiscoverInfo discoverInfo = (DiscoverInfo)packet;
                if (discoverInfo != null && discoverInfo.getType() == IQ.Type.GET) {
                    DiscoverInfo response = new DiscoverInfo();
                    response.setType(IQ.Type.RESULT);
                    response.setTo(discoverInfo.getFrom());
                    response.setPacketID(discoverInfo.getPacketID());
                    response.setNode(discoverInfo.getNode());
                    if (discoverInfo.getNode() == null) {
                        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("client", ServiceDiscoveryManager.getIdentityName());
                        identity.setType(ServiceDiscoveryManager.getIdentityType());
                        response.addIdentity(identity);
                        List list = ServiceDiscoveryManager.this.features;
                        synchronized (list) {
                            Iterator<String> it = ServiceDiscoveryManager.this.getFeatures();
                            while (it.hasNext()) {
                                response.addFeature(it.next());
                            }
                            if (ServiceDiscoveryManager.this.extendedInfo != null) {
                                response.addExtension(ServiceDiscoveryManager.this.extendedInfo);
                            }
                        }
                    } else {
                        NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                        if (nodeInformationProvider != null) {
                            List<DiscoverInfo.Identity> identities;
                            List<String> features = nodeInformationProvider.getNodeFeatures();
                            if (features != null) {
                                for (String feature : features) {
                                    response.addFeature(feature);
                                }
                            }
                            if ((identities = nodeInformationProvider.getNodeIdentities()) != null) {
                                for (DiscoverInfo.Identity identity : identities) {
                                    response.addIdentity(identity);
                                }
                            }
                        } else {
                            response.setType(IQ.Type.ERROR);
                            response.setError(new XMPPError(XMPPError.Condition.item_not_found));
                        }
                    }
                    ServiceDiscoveryManager.this.connection.sendPacket(response);
                }
            }
        };
        this.connection.addPacketListener(packetListener, packetFilter);
    }

    private NodeInformationProvider getNodeInformationProvider(String node) {
        if (node == null) {
            return null;
        }
        return this.nodeInformationProviders.get(node);
    }

    public void setNodeInformationProvider(String node, NodeInformationProvider listener) {
        this.nodeInformationProviders.put(node, listener);
    }

    public void removeNodeInformationProvider(String node) {
        this.nodeInformationProviders.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getFeatures() {
        List<String> list = this.features;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.features)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String feature) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.add(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String feature) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.remove(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includesFeature(String feature) {
        List<String> list = this.features;
        synchronized (list) {
            return this.features.contains(feature);
        }
    }

    public void setExtendedInfo(DataForm info) {
        this.extendedInfo = info;
    }

    public void removeExtendedInfo() {
        this.extendedInfo = null;
    }

    public DiscoverInfo discoverInfo(String entityID) throws XMPPException {
        return this.discoverInfo(entityID, null);
    }

    public DiscoverInfo discoverInfo(String entityID, String node) throws XMPPException {
        DiscoverInfo disco = new DiscoverInfo();
        disco.setType(IQ.Type.GET);
        disco.setTo(entityID);
        disco.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(disco.getPacketID()));
        this.connection.sendPacket(disco);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        return (DiscoverInfo)result;
    }

    public DiscoverItems discoverItems(String entityID) throws XMPPException {
        return this.discoverItems(entityID, null);
    }

    public DiscoverItems discoverItems(String entityID, String node) throws XMPPException {
        DiscoverItems disco = new DiscoverItems();
        disco.setType(IQ.Type.GET);
        disco.setTo(entityID);
        disco.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(disco.getPacketID()));
        this.connection.sendPacket(disco);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
        return (DiscoverItems)result;
    }

    public boolean canPublishItems(String entityID) throws XMPPException {
        DiscoverInfo info = this.discoverInfo(entityID);
        return info.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    public void publishItems(String entityID, DiscoverItems discoverItems) throws XMPPException {
        this.publishItems(entityID, null, discoverItems);
    }

    public void publishItems(String entityID, String node, DiscoverItems discoverItems) throws XMPPException {
        discoverItems.setType(IQ.Type.SET);
        discoverItems.setTo(entityID);
        discoverItems.setNode(node);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(discoverItems.getPacketID()));
        this.connection.sendPacket(discoverItems);
        IQ result = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (result == null) {
            throw new XMPPException("No response from the server.");
        }
        if (result.getType() == IQ.Type.ERROR) {
            throw new XMPPException(result.getError());
        }
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new ServiceDiscoveryManager(connection);
            }
        });
    }
}

