/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.analytics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.maltego.analytics.AnalyticsSession;
import com.maltego.analytics.api.AnalyticsClient;
import com.maltego.analytics.api.AnalyticsEvent;
import com.maltego.analytics.options.AnalyticsOptions;
import com.maltego.analytics.queue.AnalyticsQueue;
import com.maltego.analytics.queue.QueuedEvent;
import com.maltego.analytics.rest.AmplitudeRequestException;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.util.NormalException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultAnalyticsClient
implements AnalyticsClient {
    private static final Logger LOG = Logger.getLogger(AnalyticsClient.class.getName());
    private static final int SENDING_PERIOD = 60;
    private static final int RETRY_PERIOD = 300;
    private final AnalyticsQueue queue = new AnalyticsQueue("Sending Queue", 60, new AnalyticsQueue.Listener(){

        @Override
        public void onSent(List<QueuedEvent> events) {
            LOG.log(Level.FINE, "Sending queue listener - onSent: {0}", events.size());
        }

        @Override
        public void onError(List<QueuedEvent> events, AmplitudeRequestException are) {
            LOG.log(Level.FINE, "Sending queue listener - onError: {0}", events.size());
            if (are.canRetry()) {
                try {
                    DefaultAnalyticsClient.this.retryQueue.queue(events);
                    LOG.log(Level.INFO, "{0} events set to retry sending", events.size());
                }
                catch (JsonProcessingException jpe) {
                    NormalException.logStackTrace((Throwable)jpe);
                }
            }
        }
    });
    private final AnalyticsQueue retryQueue = new AnalyticsQueue("Retry Queue", 300, new AnalyticsQueue.Listener(){

        @Override
        public void onSent(List<QueuedEvent> events) {
            LOG.log(Level.FINE, "Retry queue listener - onSent: {0}", events.size());
        }

        @Override
        public void onError(List<QueuedEvent> events, AmplitudeRequestException are) {
            LOG.log(Level.FINE, "Retry queue listener - onError: {0}", events.size());
        }
    });
    private boolean currentlyActive;

    void initialize() {
        LicenseManager.A().A(e -> {
            this.determineIfAnalyticsActive();
            LOG.log(Level.INFO, "Analytics adjusted to License Mode - currentlyActive : {0}", this.currentlyActive);
        });
        AnalyticsOptions.getDefault().addPreferenceChangeListener(e -> {
            this.determineIfAnalyticsActive();
            LOG.log(Level.INFO, "Analytics adjusted to Options - currentlyActive : {0}", this.currentlyActive);
        });
        this.determineIfAnalyticsActive();
        LOG.log(Level.INFO, "Analytics initialized - currentlyActive : {0}", this.currentlyActive);
    }

    private void determineIfAnalyticsActive() {
        if (AnalyticsOptions.getDefault().isAnalyticsEnabled()) {
            boolean maltegoIdOnlineActivated;
            LicenseManager licenseManager = LicenseManager.A();
            A licenseMode = licenseManager.A(false);
            boolean bl = maltegoIdOnlineActivated = licenseMode.U() && !licenseMode.S();
            if (maltegoIdOnlineActivated) {
                if (!this.currentlyActive) {
                    AnalyticsSession.init();
                }
            } else {
                AnalyticsSession.reset();
            }
            this.currentlyActive = maltegoIdOnlineActivated;
        } else {
            this.currentlyActive = false;
        }
    }

    boolean isActive() {
        return this.currentlyActive;
    }

    @Override
    public void send(AnalyticsEvent ae) {
        if (!this.currentlyActive) {
            LOG.log(Level.FINE, "Analytics module is not active");
            return;
        }
        try {
            QueuedEvent queuedEvent = QueuedEvent.build(ae);
            this.queue.queue(queuedEvent);
            LOG.log(Level.INFO, "Event set to be sent - type: {0}, trace id: {1}", new Object[]{ae.getType(), ae.getTraceId().toString()});
        }
        catch (JsonProcessingException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
    }
}

