/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.paterva.maltego.util.StringUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.EventListenerList;

public class BinaryOptionRadioButtons
extends JPanel {
    private final GridBagLayout _gridBagLayout = new GridBagLayout();
    private final ButtonGroup _buttonGroup = new ButtonGroup();
    private final JRadioButton _option1Radio = new JRadioButton("Option1");
    private final JRadioButton _option2Radio = new JRadioButton("Option2");
    private GridBagConstraints _gbc;
    private boolean _option1;
    private final AtomicBoolean _updating = new AtomicBoolean(false);
    private EventListenerList _listeners;

    private BinaryOptionRadioButtons() {
    }

    public BinaryOptionRadioButtons(boolean option1, String option1Text, String option2Text) {
        this(option1, option1Text, option2Text, null, null);
    }

    public BinaryOptionRadioButtons(boolean option1, String option1Text, String option2Text, String option1TooltipText, String option2TooltipText) {
        this.init(option1, option1Text, option2Text, option1TooltipText, option2TooltipText);
    }

    private void init(boolean option1, String option1Text, String option2Text, String option1TooltipText, String option2TooltipText) {
        this._updating.set(true);
        this._option1Radio.setText(option1Text);
        if (!StringUtilities.isNullOrEmpty((String)option1TooltipText)) {
            this._option1Radio.setToolTipText(option1TooltipText);
        }
        this._option2Radio.setText(option2Text);
        if (!StringUtilities.isNullOrEmpty((String)option2TooltipText)) {
            this._option2Radio.setToolTipText(option2TooltipText);
        }
        this._option1 = option1;
        this.setLayout(this._gridBagLayout);
        this._buttonGroup.add(this._option1Radio);
        this._option1Radio.addActionListener(evt -> {
            if (this._updating.compareAndSet(false, true)) {
                this.setOption1(true);
                this.fireActionEvent(evt);
                this._updating.set(false);
            }
        });
        this._gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 10, 0);
        this.add((Component)this._option1Radio, this._gbc);
        this._buttonGroup.add(this._option2Radio);
        this._option2Radio.addActionListener(evt -> {
            if (this._updating.compareAndSet(false, true)) {
                this.setOption1(false);
                this.fireActionEvent(evt);
                this._updating.set(false);
            }
        });
        this._gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 10, 0);
        this.add((Component)this._option2Radio, this._gbc);
        this._updating.set(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._updating.set(true);
        this._buttonGroup.setSelected(this._option1 ? this._option1Radio.getModel() : this._option2Radio.getModel(), true);
        this._updating.set(false);
    }

    private void setOption1(boolean option1) {
        this._option1 = option1;
    }

    public boolean isOption1() {
        return this._option1;
    }

    public void addActionListener(ActionListener listener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(ActionListener.class, listener);
        }
    }

    protected void fireActionEvent(ActionEvent evt) {
        if (this._listeners != null) {
            for (ActionListener listener : (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                listener.actionPerformed(evt);
            }
        }
    }
}

