/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.InputStreamSource;
import org.htmlparser.lexer.PageIndex;
import org.htmlparser.lexer.Source;
import org.htmlparser.lexer.Stream;
import org.htmlparser.lexer.StringSource;
import org.htmlparser.util.ParserException;

public class Page
implements Serializable {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    protected String mUrl;
    protected String mBaseUrl;
    protected Source mSource;
    protected PageIndex mIndex;
    protected transient URLConnection mConnection;
    private static final String[] mFourOhFour = new String[]{"The web site you seek cannot be located, but countless more exist", "You step in the stream, but the water has moved on. This page is not here.", "Yesterday the page existed. Today it does not. The internet is like that.", "That page was so big. It might have been very useful. But now it is gone.", "Three things are certain: death, taxes and broken links. Guess which has occured.", "Chaos reigns within. Reflect, repent and enter the correct URL. Order shall return.", "Stay the patient course. Of little worth is your ire. The page is not found.", "A non-existant URL reduces your expensive computer to a simple stone.", "Many people have visited that page. Today, you are not one of the lucky ones.", "Cutting the wind with a knife. Bookmarking a URL. Both are ephemeral."};
    static /* synthetic */ Class class$java$lang$String;

    public Page() {
        this("");
    }

    public Page(URLConnection connection) throws ParserException {
        if (null == connection) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.setConnection(connection);
        this.mBaseUrl = null;
    }

    public Page(InputStream stream, String charset) throws UnsupportedEncodingException {
        if (null == stream) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        this.mSource = new InputStreamSource(stream, charset);
        this.mIndex = new PageIndex(this);
        this.mConnection = null;
        this.mUrl = null;
        this.mBaseUrl = null;
    }

    public Page(String text, String charset) {
        if (null == text) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        this.mSource = new StringSource(text, charset);
        this.mIndex = new PageIndex(this);
        this.mConnection = null;
        this.mUrl = null;
        this.mBaseUrl = null;
    }

    public Page(String text) {
        this(text, null);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (null != this.getConnection()) {
            out.writeBoolean(true);
            out.writeInt(this.mSource.offset());
            String href = this.getUrl();
            out.writeObject(href);
            this.setUrl(this.getConnection().getURL().toExternalForm());
            Source source = this.getSource();
            this.mSource = null;
            PageIndex index = this.mIndex;
            this.mIndex = null;
            out.defaultWriteObject();
            this.mSource = source;
            this.mIndex = index;
        } else {
            out.writeBoolean(false);
            String href = this.getUrl();
            out.writeObject(href);
            this.setUrl(null);
            out.defaultWriteObject();
            this.setUrl(href);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean fromurl = in.readBoolean();
        if (fromurl) {
            int offset = in.readInt();
            String href = (String)in.readObject();
            in.defaultReadObject();
            if (null != this.getUrl()) {
                URL url = new URL(this.getUrl());
                try {
                    this.setConnection(url.openConnection());
                }
                catch (ParserException pe) {
                    throw new IOException(pe.getMessage());
                }
            }
            Cursor cursor = new Cursor(this, 0);
            for (int i = 0; i < offset; ++i) {
                try {
                    this.getCharacter(cursor);
                    continue;
                }
                catch (ParserException pe) {
                    throw new IOException(pe.getMessage());
                }
            }
            this.setUrl(href);
        } else {
            String href = (String)in.readObject();
            in.defaultReadObject();
            this.setUrl(href);
        }
    }

    public void reset() {
        this.getSource().reset();
        this.mIndex = new PageIndex(this);
    }

    public URLConnection getConnection() {
        return this.mConnection;
    }

    public void setConnection(URLConnection connection) throws ParserException {
        this.mConnection = connection;
        try {
            try {
                this.getConnection().setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            this.getConnection().connect();
        }
        catch (UnknownHostException uhe) {
            int message = (int)(Math.random() * (double)mFourOhFour.length);
            throw new ParserException(mFourOhFour[message], uhe);
        }
        catch (IOException ioe) {
            throw new ParserException(ioe.getMessage(), ioe);
        }
        String type = this.getContentType();
        String charset = this.getCharset(type);
        try {
            String contentEncoding = connection.getContentEncoding();
            Stream stream = null != contentEncoding && -1 != contentEncoding.indexOf("gzip") ? new Stream(new GZIPInputStream(this.getConnection().getInputStream())) : (null != contentEncoding && -1 != contentEncoding.indexOf("deflate") ? new Stream(new InflaterInputStream(this.getConnection().getInputStream())) : new Stream(this.getConnection().getInputStream()));
            try {
                this.mSource = new InputStreamSource(stream, charset);
            }
            catch (UnsupportedEncodingException uee) {
                charset = DEFAULT_CHARSET;
                this.mSource = new InputStreamSource(stream, charset);
            }
        }
        catch (IOException ioe) {
            throw new ParserException(ioe.getMessage(), ioe);
        }
        this.mUrl = connection.getURL().toExternalForm();
        this.mIndex = new PageIndex(this);
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getBaseUrl() {
        return this.mBaseUrl;
    }

    public void setBaseUrl(String url) {
        this.mBaseUrl = url;
    }

    public Source getSource() {
        return this.mSource;
    }

    public String getContentType() {
        String content;
        String ret = DEFAULT_CONTENT_TYPE;
        URLConnection connection = this.getConnection();
        if (null != connection && null != (content = connection.getContentType())) {
            ret = content;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char getCharacter(Cursor cursor) throws ParserException {
        char ret;
        block17: {
            int i = cursor.getPosition();
            if (this.mSource.offset() < i) {
                throw new ParserException("attempt to read future characters from source");
            }
            if (this.mSource.offset() == i) {
                try {
                    i = this.mSource.read();
                    if (0 > i) {
                        return '\u0000';
                    }
                    ret = (char)i;
                    cursor.advance();
                }
                catch (IOException ioe) {
                    throw new ParserException("problem reading a character at position " + cursor.getPosition(), ioe);
                }
            }
            try {
                ret = this.mSource.getCharacter(i);
            }
            catch (IOException ioe) {
                throw new ParserException("can't read a character at position " + i, ioe);
            }
            cursor.advance();
            if ('\r' == ret) {
                ret = '\n';
                if (this.mSource.offset() == cursor.getPosition()) {
                    try {
                        i = this.mSource.read();
                        if (-1 == i) break block17;
                        if ('\n' == (char)i) {
                            cursor.advance();
                            break block17;
                        }
                        try {
                            this.mSource.unread();
                            break block17;
                        }
                        catch (IOException ioe) {
                            throw new ParserException("can't unread a character at position " + cursor.getPosition(), ioe);
                        }
                    }
                    catch (IOException ioe) {
                        throw new ParserException("problem reading a character at position " + cursor.getPosition(), ioe);
                    }
                }
                try {
                    if ('\n' == this.mSource.getCharacter(cursor.getPosition())) {
                        cursor.advance();
                    }
                }
                catch (IOException ioe) {
                    throw new ParserException("can't read a character at position " + cursor.getPosition(), ioe);
                }
            }
        }
        if (10 != ret) return ret;
        this.mIndex.add(cursor);
        return ret;
    }

    public String getCharset(String content) {
        int index;
        String CHARSET_STRING = "charset";
        String ret = DEFAULT_CHARSET;
        if (null != content && (index = content.indexOf("charset")) != -1 && (content = content.substring(index + "charset".length()).trim()).startsWith("=")) {
            index = (content = content.substring(1).trim()).indexOf(";");
            if (index != -1) {
                content = content.substring(0, index);
            }
            if (content.startsWith("\"") && content.endsWith("\"") && 1 < content.length()) {
                content = content.substring(1, content.length() - 1);
            }
            if (content.startsWith("'") && content.endsWith("'") && 1 < content.length()) {
                content = content.substring(1, content.length() - 1);
            }
            ret = this.findCharset(content, ret);
        }
        return ret;
    }

    public String findCharset(String name, String _default) {
        String ret;
        try {
            Class<?> cls = Class.forName("java.nio.charset.Charset");
            Method method = cls.getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = Page.class$("java.lang.String")) : class$java$lang$String);
            Object object = method.invoke(null, name);
            method = cls.getMethod("name", new Class[0]);
            object = method.invoke(object, new Object[0]);
            ret = (String)object;
        }
        catch (ClassNotFoundException cnfe) {
            ret = name;
        }
        catch (NoSuchMethodException nsme) {
            ret = name;
        }
        catch (IllegalAccessException ia) {
            ret = name;
        }
        catch (InvocationTargetException ita) {
            ret = _default;
            System.out.println("unable to determine cannonical charset name for " + name + " - using " + _default);
        }
        return ret;
    }

    public String getEncoding() {
        return this.getSource().getEncoding();
    }

    public void setEncoding(String character_set) throws ParserException {
        this.getSource().setEncoding(character_set);
    }

    public URL constructUrl(String link, String base) throws MalformedURLException {
        int index;
        URL url = new URL(new URL(base), link);
        String path = url.getFile();
        boolean modified = false;
        boolean absolute = link.startsWith("/");
        if (!absolute) {
            while (path.startsWith("/.")) {
                if (path.startsWith("/../")) {
                    path = path.substring(3);
                    modified = true;
                    continue;
                }
                if (!path.startsWith("/./") && !path.startsWith("/.")) break;
                path = path.substring(2);
                modified = true;
            }
        }
        while (-1 != (index = path.indexOf("/\\"))) {
            path = path.substring(0, index + 1) + path.substring(index + 2);
            modified = true;
        }
        if (modified) {
            url = new URL(url, path);
        }
        return url;
    }

    public String getAbsoluteURL(String link) {
        String ret;
        if (null == link || "".equals(link)) {
            ret = "";
        } else {
            try {
                String base = this.getBaseUrl();
                if (null == base) {
                    base = this.getUrl();
                }
                if (null == base) {
                    ret = link;
                } else {
                    URL url = this.constructUrl(link, base);
                    ret = url.toExternalForm();
                }
            }
            catch (MalformedURLException murle) {
                ret = link;
            }
        }
        return ret;
    }

    public int row(Cursor cursor) {
        return this.mIndex.row(cursor);
    }

    public int row(int position) {
        return this.mIndex.row(position);
    }

    public int column(Cursor cursor) {
        return this.mIndex.column(cursor);
    }

    public int column(int position) {
        return this.mIndex.column(position);
    }

    public String getText(int start, int end) {
        String ret;
        try {
            ret = this.mSource.getString(start, end - start);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("can't get the " + (end - start) + "characters at position " + start + " - " + ioe.getMessage());
        }
        return ret;
    }

    public void getText(StringBuffer buffer, int start, int end) {
        int length;
        if (this.mSource.offset() < start || this.mSource.offset() < end) {
            throw new IllegalArgumentException("attempt to extract future characters from source");
        }
        if (end < start) {
            length = end;
            end = start;
            start = length;
        }
        length = end - start;
        try {
            this.mSource.getCharacters(buffer, start, length);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("can't get the " + (end - start) + "characters at position " + start + " - " + ioe.getMessage());
        }
    }

    public String getText() {
        String ret;
        try {
            ret = this.mSource.getString(0, this.mSource.offset());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("can't get all the previous characters - " + ioe.getMessage());
        }
        return ret;
    }

    public void getText(StringBuffer buffer) {
        this.getText(buffer, 0, this.mSource.offset());
    }

    public void getText(char[] array, int offset, int start, int end) {
        int length;
        if (this.mSource.offset() < start || this.mSource.offset() < end) {
            throw new IllegalArgumentException("attempt to extract future characters from source");
        }
        if (end < start) {
            length = end;
            end = start;
            start = length;
        }
        length = end - start;
        try {
            this.mSource.getCharacters(array, offset, start, end);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("can't get the " + (end - start) + "characters at position " + start + " - " + ioe.getMessage());
        }
    }

    public String getLine(Cursor cursor) {
        int end;
        int start;
        int size;
        int line = this.row(cursor);
        if (line < (size = this.mIndex.size())) {
            start = this.mIndex.elementAt(line);
            end = ++line <= size ? this.mIndex.elementAt(line) : this.mSource.offset();
        } else {
            start = this.mIndex.elementAt(line - 1);
            end = this.mSource.offset();
        }
        return this.getText(start, end);
    }

    public String getLine(int position) {
        return this.getLine(new Cursor(this, position));
    }

    public String toString() {
        String ret;
        if (this.mSource.offset() > 0) {
            StringBuffer buffer = new StringBuffer(43);
            int start = this.mSource.offset() - 40;
            if (0 > start) {
                start = 0;
            } else {
                buffer.append("...");
            }
            this.getText(buffer, start, this.mSource.offset());
            ret = buffer.toString();
        } else {
            ret = super.toString();
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

