# Contributing

The Elasticsearch Go client is open source and we love to receive contributions from our community.

There are many ways to contribute, from writing tutorials or blog posts, improving the documentation, submitting bug reports and feature requests or writing code.

## Sign the Contributor License Agreement

We do ask that you sign the [Contiributor License Agreement](https://www.elastic.co/contributor-agreement)
before we can accept pull requests from you.

## Development

### Prerequisites

You need at least Go 1.21 to build the project.

Docker is used for some tests to spawn an Elasticsearch server.

### Project structure

The code for each API lives in individual files in the `esapi` subfolder, this code is entirely generated by the subproject located in the `internal/build` folder.



### Before you open a PR

Please run the tests locally with `make test` and make sure everything is in order.

If your changes address the generator, you can run the integration with the following command:

`TEST_SUITE=free STACK_VERSION=8.0.0-SNAPSHOT WORKSPACE=/tmp/workspace/$STACK_VERSION .ci/run-tests`

TEST_SUITE can either be `free` or `platinum`, STACK_VERSION reflects the targeted Elasticsearch version of the client.