# 2021-09-28 Triage Log

The largest story for the week are the massive improvements that come from enabling the new pass manager in LLVM which leads to consistent 5% to 30% improvements across almost all test cases. The regressions were mostly minor with clear paths for addressing the ones that were not made with some specific trade off in mind.

Triage done by **@rylev**.
Revision range: [7743c9fadd64886d537966ba224b9c20e6014a59..83f147b3baf21acfc367a6da1045d212cd3957e4](https://perf.rust-lang.org/?start=7743c9fadd64886d537966ba224b9c20e6014a59&end=83f147b3baf21acfc367a6da1045d212cd3957e4&absolute=false&stat=instructions%3Au)

4 Regressions, 4 Improvements, 3 Mixed; 0 of them in rollups
43 comparisons made in total

#### Regressions

Revise never type fallback algorithm [#88804](https://github.com/rust-lang/rust/issues/88804)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2b862bed9889808b69629fd7246317189b9517a5&end=900cf5e8905ba8a2a9c99a1dfc9cb2cf4754d77a&stat=instructions:u) (up to 2.7% on `full` builds of `keccak`)


Introduce `Rvalue::ShallowInitBox` [#89030](https://github.com/rust-lang/rust/issues/89030)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=218a96cae06ed1a47549a81c09c3655fbcae1363&end=e9f29a851917a706c01b6f51331894df1d15770b&stat=instructions:u) (up to 1.9% on `incr-patched: println` builds of `syn`)
- Perf regression is happening in real-world optimized builds which we would expect if we're making LLVM do more work. 
- The author has an idea for how to reduce the pressure on LLVM and perhaps win back some of the perf, but was unsure if the regression was large enough to warrant that investigation.
- Left a comment asking the author to think about prioritizing that [investigation](https://github.com/rust-lang/rust/pull/89030#issuecomment-929187148).


Fix spacing of links in inline code. [#88343](https://github.com/rust-lang/rust/issues/88343)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9620f3a84b079decfdc2e557be007580b097fe43&end=addb4da686a97da46159f0123cb6cdc2ce3d7fdb&stat=instructions:u) (up to 2.1% on `incr-unchanged` builds of `webrender-wrench`)
- This change is only in doc comments for the standard library so large regressions are quite surprising.
- This has impacted the incr-unchanged scenario of only one benchmark. Perhaps the docs led to a change in how incremental cache was being stored which could have an impact?


Suggest both of immutable and mutable trait implementations [#89263](https://github.com/rust-lang/rust/issues/89263)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=583437a6dd58ee266839d2dac940642a0752a6dd&end=3e8f32e1c52ca493c862facb7a69e7c3f1f97a18&stat=instructions:u) (up to 2.0% on `full` builds of `diesel`)
- The regression occurs in `evaluate_obligation` which seems like it would be effected by this change, but the only impacted benchmark is diesel doc which doesn't trigger this diagnostic
- The change is large enough though that it being noise would be quite surprising.
- Left a [comment](https://github.com/rust-lang/rust/pull/89263#issuecomment-929511988)


#### Improvements

Migrate in-tree crates to 2021 [#89103](https://github.com/rust-lang/rust/issues/89103)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=840acd378a273dab6798352d3d6a087fa09e4806&end=ac2d9fc509e36d1b32513744adf58c34bcc4f43c&stat=instructions:u) (up to -2.9% on `incr-full` builds of `ctfe-stress-4`)


Disable visible path calculation for PrettyPrinter in Ok path of compiler [#89120](https://github.com/rust-lang/rust/issues/89120)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=293b8f2c11cbec03f0d4daae6b82ed7541ebbf4e&end=197fc8591e6b02ac1f359ee0a72616eb4a6d4f4c&stat=instructions:u) (up to -23.1% on `incr-full` builds of `await-call-tree`)


Make `Duration` respect `width` when formatting using `Debug` [#88999](https://github.com/rust-lang/rust/issues/88999)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a0648eab3686f100c7ab9b0d38472c740079cce4&end=f06f9bbd3a2b0a2781decd6163b14f71dd59bf7f&stat=instructions:u) (up to -1.0% on `full` builds of `deeply-nested-async`)


Enable new pass manager with LLVM 13 [#88243](https://github.com/rust-lang/rust/issues/88243)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e9f29a851917a706c01b6f51331894df1d15770b&end=63cc2bb3d07d6c726dfcdc5f95cbe5ed4760641a&stat=instructions:u) (up to -31.7% on `incr-patched: println` builds of `inflate`)


#### Mixed

Use ZST for fmt unsafety [#89139](https://github.com/rust-lang/rust/issues/89139)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=30278d3cf92b581550933546370443a5d5700002&end=67365d64bcdfeae1334bf2ff49587c27d1c973f0&stat=instructions:u) (up to -1.6% on `full` builds of `cranelift-codegen`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=30278d3cf92b581550933546370443a5d5700002&end=67365d64bcdfeae1334bf2ff49587c27d1c973f0&stat=instructions:u) (up to 0.5% on `full` builds of `deeply-nested-async`)
- The regressions were already triaged [here](https://github.com/rust-lang/rust/pull/89139#issuecomment-927914624).


Support `#[track_caller]` on closures and generators [#87064](https://github.com/rust-lang/rust/issues/87064)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=15d9ba0133ce0b35348e1c8367afe00aec841ffa&end=0132f8258ae0fbc4f2b461b28d510222d22aa979&stat=instructions:u) (up to -1.8% on `incr-unchanged` builds of `webrender-wrench`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=15d9ba0133ce0b35348e1c8367afe00aec841ffa&end=0132f8258ae0fbc4f2b461b28d510222d22aa979&stat=instructions:u) (up to 0.5% on `incr-unchanged` builds of `helloworld`)
- The large majority of performance regressions were quite small and many were historically noisy benchmarks. 
- Looking at the non-noisy benchmarks nothing seemed to stand out as a clear culprit. -
- There were some test cases that indicated large jumps in incr_comp_persist_dep_graph but this did not hold true across all incremental test cases, and nothing in the changes seemed to jump out at me as potentially causing this issue.
- Added a [comment](https://github.com/rust-lang/rust/pull/87064#issuecomment-929428658) in the PR asking for additional opinions.


Don't normalize opaque types with escaping late-bound regions [#89285](https://github.com/rust-lang/rust/issues/89285)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3e8f32e1c52ca493c862facb7a69e7c3f1f97a18&end=2b6ed3b675475abc01ce7e68bb75b457f0c85684&stat=instructions:u) (up to -86.7% on `full` builds of `issue-88862`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3e8f32e1c52ca493c862facb7a69e7c3f1f97a18&end=2b6ed3b675475abc01ce7e68bb75b457f0c85684&stat=instructions:u) (up to 1.3% on `full` builds of `deeply-nested-async`)
- This has already been [triaged](https://github.com/rust-lang/rust/pull/89285#issuecomment-927417324).
- Essentially it's a targeted fix for a severe perf regression that can happen in limited circumstances. The fix will be backported to the latest beta.


#### Untriaged Pull Requests

- [#89263 Suggest both of immutable and mutable trait implementations](https://github.com/rust-lang/rust/pull/89263)
- [#89125 Don't use projection cache or candidate cache in intercrate mode](https://github.com/rust-lang/rust/pull/89125)
- [#89103 Migrate in-tree crates to 2021](https://github.com/rust-lang/rust/pull/89103)
- [#89047 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89047)
- [#89030 Introduce `Rvalue::ShallowInitBox`](https://github.com/rust-lang/rust/pull/89030)
- [#88945 Remove concept of 'completion' from the projection cache](https://github.com/rust-lang/rust/pull/88945)
- [#88881 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/88881)
- [#88824 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/88824)
- [#88804 Revise never type fallback algorithm](https://github.com/rust-lang/rust/pull/88804)
- [#88719 Point at argument instead of call for their obligations](https://github.com/rust-lang/rust/pull/88719)
- [#88710 Use index newtyping for TyVid](https://github.com/rust-lang/rust/pull/88710)
- [#88703 Gather module items after lowering.](https://github.com/rust-lang/rust/pull/88703)
- [#88627 Do not preallocate HirIds](https://github.com/rust-lang/rust/pull/88627)
- [#88597 Move global analyses from lowering to resolution](https://github.com/rust-lang/rust/pull/88597)
- [#88575 Querify `FnAbi::of_{fn_ptr,instance}` as `fn_abi_of_{fn_ptr,instance}`.](https://github.com/rust-lang/rust/pull/88575)
- [#88552 Stop allocating vtable entries for non-object-safe methods](https://github.com/rust-lang/rust/pull/88552)
- [#88533 Concrete regions can show up in mir borrowck if the originated from there](https://github.com/rust-lang/rust/pull/88533)
- [#88530 Shrink Session a bit](https://github.com/rust-lang/rust/pull/88530)
- [#88435 Avoid invoking the hir_crate query to traverse the HIR](https://github.com/rust-lang/rust/pull/88435)
- [#88343 Fix spacing of links in inline code.](https://github.com/rust-lang/rust/pull/88343)
- [#88308 Morph `layout_raw` query into `layout_of`.](https://github.com/rust-lang/rust/pull/88308)
- [#87815 encode `generics_of` for fields and ty params](https://github.com/rust-lang/rust/pull/87815)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)
- [#87688 Introduce `let...else`](https://github.com/rust-lang/rust/pull/87688)
- [#87064 Support `#[track_caller]` on closures and generators](https://github.com/rust-lang/rust/pull/87064)
- [#84373 Encode spans relative to the enclosing item](https://github.com/rust-lang/rust/pull/84373)
- [#83698 Use undef for uninitialized bytes in constants](https://github.com/rust-lang/rust/pull/83698)
- [#83302 Get piece unchecked in `write`](https://github.com/rust-lang/rust/pull/83302)
