// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple armv8.1a-linux-gnu -target-abi apcs-gnu -target-feature +neon \
// RUN:  -emit-llvm -o - %s -disable-O0-optnone | opt -passes=mem2reg,sroa,dce -S \
// RUN:  | FileCheck %s --check-prefix=CHECK-ARM

// RUN: %clang_cc1 -triple aarch64-linux-gnu -target-feature +neon \
// RUN:  -target-feature +v8.1a -emit-llvm -o - %s -disable-O0-optnone | opt -passes=mem2reg,sroa,dce -S \
// RUN:  | FileCheck %s --check-prefix=CHECK-AARCH64

// REQUIRES: arm-registered-target,aarch64-registered-target

#include <arm_neon.h>

// CHECK-ARM-LABEL: @test_vqrdmlah_s16(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[A:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[B:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S16_I:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S161_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S162_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S163_I:%.*]] = call <4 x i16> @llvm.arm.neon.vqrdmlah.v4i16(<4 x i16> [[VQRDMLAH_S16_I]], <4 x i16> [[VQRDMLAH_S161_I]], <4 x i16> [[VQRDMLAH_S162_I]])
// CHECK-ARM-NEXT:    [[VQRDMLAH_S164_I:%.*]] = bitcast <4 x i16> [[VQRDMLAH_S163_I]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <8 x i8> [[VQRDMLAH_S164_I]] to <4 x i16>
// CHECK-ARM-NEXT:    ret <4 x i16> [[TMP3]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlah_s16(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[A:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[B:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S16_I:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S161_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S162_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S163_I:%.*]] = call <4 x i16> @llvm.aarch64.neon.sqrdmlah.v4i16(<4 x i16> [[VQRDMLAH_S16_I]], <4 x i16> [[VQRDMLAH_S161_I]], <4 x i16> [[VQRDMLAH_S162_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S164_I:%.*]] = bitcast <4 x i16> [[VQRDMLAH_S163_I]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <8 x i8> [[VQRDMLAH_S164_I]] to <4 x i16>
// CHECK-AARCH64-NEXT:    ret <4 x i16> [[TMP3]]
//
int16x4_t test_vqrdmlah_s16(int16x4_t a, int16x4_t b, int16x4_t c) {

  return vqrdmlah_s16(a, b, c);
}

// CHECK-ARM-LABEL: @test_vqrdmlah_s32(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[A:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[B:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S32_I:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S321_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S322_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S323_I:%.*]] = call <2 x i32> @llvm.arm.neon.vqrdmlah.v2i32(<2 x i32> [[VQRDMLAH_S32_I]], <2 x i32> [[VQRDMLAH_S321_I]], <2 x i32> [[VQRDMLAH_S322_I]])
// CHECK-ARM-NEXT:    [[VQRDMLAH_S324_I:%.*]] = bitcast <2 x i32> [[VQRDMLAH_S323_I]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <8 x i8> [[VQRDMLAH_S324_I]] to <2 x i32>
// CHECK-ARM-NEXT:    ret <2 x i32> [[TMP3]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlah_s32(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[A:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[B:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S32_I:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S321_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S322_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S323_I:%.*]] = call <2 x i32> @llvm.aarch64.neon.sqrdmlah.v2i32(<2 x i32> [[VQRDMLAH_S32_I]], <2 x i32> [[VQRDMLAH_S321_I]], <2 x i32> [[VQRDMLAH_S322_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S324_I:%.*]] = bitcast <2 x i32> [[VQRDMLAH_S323_I]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <8 x i8> [[VQRDMLAH_S324_I]] to <2 x i32>
// CHECK-AARCH64-NEXT:    ret <2 x i32> [[TMP3]]
//
int32x2_t test_vqrdmlah_s32(int32x2_t a, int32x2_t b, int32x2_t c) {

  return vqrdmlah_s32(a, b, c);
}

// CHECK-ARM-LABEL: @test_vqrdmlahq_s16(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i16> [[B:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[C:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S16_I:%.*]] = bitcast <16 x i8> [[TMP0]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S161_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S162_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S163_I:%.*]] = call <8 x i16> @llvm.arm.neon.vqrdmlah.v8i16(<8 x i16> [[VQRDMLAHQ_S16_I]], <8 x i16> [[VQRDMLAHQ_S161_I]], <8 x i16> [[VQRDMLAHQ_S162_I]])
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S164_I:%.*]] = bitcast <8 x i16> [[VQRDMLAHQ_S163_I]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <16 x i8> [[VQRDMLAHQ_S164_I]] to <8 x i16>
// CHECK-ARM-NEXT:    ret <8 x i16> [[TMP3]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlahq_s16(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i16> [[B:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[C:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S16_I:%.*]] = bitcast <16 x i8> [[TMP0]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S161_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S162_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S163_I:%.*]] = call <8 x i16> @llvm.aarch64.neon.sqrdmlah.v8i16(<8 x i16> [[VQRDMLAHQ_S16_I]], <8 x i16> [[VQRDMLAHQ_S161_I]], <8 x i16> [[VQRDMLAHQ_S162_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S164_I:%.*]] = bitcast <8 x i16> [[VQRDMLAHQ_S163_I]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <16 x i8> [[VQRDMLAHQ_S164_I]] to <8 x i16>
// CHECK-AARCH64-NEXT:    ret <8 x i16> [[TMP3]]
//
int16x8_t test_vqrdmlahq_s16(int16x8_t a, int16x8_t b, int16x8_t c) {

  return vqrdmlahq_s16(a, b, c);
}

// CHECK-ARM-LABEL: @test_vqrdmlahq_s32(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[B:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[C:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S32_I:%.*]] = bitcast <16 x i8> [[TMP0]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S321_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S322_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S323_I:%.*]] = call <4 x i32> @llvm.arm.neon.vqrdmlah.v4i32(<4 x i32> [[VQRDMLAHQ_S32_I]], <4 x i32> [[VQRDMLAHQ_S321_I]], <4 x i32> [[VQRDMLAHQ_S322_I]])
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S324_I:%.*]] = bitcast <4 x i32> [[VQRDMLAHQ_S323_I]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <16 x i8> [[VQRDMLAHQ_S324_I]] to <4 x i32>
// CHECK-ARM-NEXT:    ret <4 x i32> [[TMP3]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlahq_s32(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[B:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[C:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S32_I:%.*]] = bitcast <16 x i8> [[TMP0]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S321_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S322_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S323_I:%.*]] = call <4 x i32> @llvm.aarch64.neon.sqrdmlah.v4i32(<4 x i32> [[VQRDMLAHQ_S32_I]], <4 x i32> [[VQRDMLAHQ_S321_I]], <4 x i32> [[VQRDMLAHQ_S322_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S324_I:%.*]] = bitcast <4 x i32> [[VQRDMLAHQ_S323_I]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <16 x i8> [[VQRDMLAHQ_S324_I]] to <4 x i32>
// CHECK-AARCH64-NEXT:    ret <4 x i32> [[TMP3]]
//
int32x4_t test_vqrdmlahq_s32(int32x4_t a, int32x4_t b, int32x4_t c) {

  return vqrdmlahq_s32(a, b, c);
}

// CHECK-ARM-LABEL: @test_vqrdmlah_lane_s16(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-ARM-NEXT:    [[LANE:%.*]] = shufflevector <4 x i16> [[TMP1]], <4 x i16> [[TMP1]], <4 x i32> <i32 3, i32 3, i32 3, i32 3>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[A:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[B:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[LANE]] to <8 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S16_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S161_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S162_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S163_I:%.*]] = call <4 x i16> @llvm.arm.neon.vqrdmlah.v4i16(<4 x i16> [[VQRDMLAH_S16_I]], <4 x i16> [[VQRDMLAH_S161_I]], <4 x i16> [[VQRDMLAH_S162_I]])
// CHECK-ARM-NEXT:    [[VQRDMLAH_S164_I:%.*]] = bitcast <4 x i16> [[VQRDMLAH_S163_I]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP5:%.*]] = bitcast <8 x i8> [[VQRDMLAH_S164_I]] to <4 x i16>
// CHECK-ARM-NEXT:    ret <4 x i16> [[TMP5]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlah_lane_s16(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[LANE:%.*]] = shufflevector <4 x i16> [[TMP1]], <4 x i16> [[TMP1]], <4 x i32> <i32 3, i32 3, i32 3, i32 3>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[A:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[B:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[LANE]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S16_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S161_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S162_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S163_I:%.*]] = call <4 x i16> @llvm.aarch64.neon.sqrdmlah.v4i16(<4 x i16> [[VQRDMLAH_S16_I]], <4 x i16> [[VQRDMLAH_S161_I]], <4 x i16> [[VQRDMLAH_S162_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S164_I:%.*]] = bitcast <4 x i16> [[VQRDMLAH_S163_I]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP5:%.*]] = bitcast <8 x i8> [[VQRDMLAH_S164_I]] to <4 x i16>
// CHECK-AARCH64-NEXT:    ret <4 x i16> [[TMP5]]
//
int16x4_t test_vqrdmlah_lane_s16(int16x4_t a, int16x4_t b, int16x4_t c) {

  return vqrdmlah_lane_s16(a, b, c, 3);
}

// CHECK-ARM-LABEL: @test_vqrdmlah_lane_s32(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-ARM-NEXT:    [[LANE:%.*]] = shufflevector <2 x i32> [[TMP1]], <2 x i32> [[TMP1]], <2 x i32> <i32 1, i32 1>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[A:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[B:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP4:%.*]] = bitcast <2 x i32> [[LANE]] to <8 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S32_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S321_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S322_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAH_S323_I:%.*]] = call <2 x i32> @llvm.arm.neon.vqrdmlah.v2i32(<2 x i32> [[VQRDMLAH_S32_I]], <2 x i32> [[VQRDMLAH_S321_I]], <2 x i32> [[VQRDMLAH_S322_I]])
// CHECK-ARM-NEXT:    [[VQRDMLAH_S324_I:%.*]] = bitcast <2 x i32> [[VQRDMLAH_S323_I]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP5:%.*]] = bitcast <8 x i8> [[VQRDMLAH_S324_I]] to <2 x i32>
// CHECK-ARM-NEXT:    ret <2 x i32> [[TMP5]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlah_lane_s32(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[LANE:%.*]] = shufflevector <2 x i32> [[TMP1]], <2 x i32> [[TMP1]], <2 x i32> <i32 1, i32 1>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[A:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[B:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP4:%.*]] = bitcast <2 x i32> [[LANE]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S32_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S321_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S322_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S323_I:%.*]] = call <2 x i32> @llvm.aarch64.neon.sqrdmlah.v2i32(<2 x i32> [[VQRDMLAH_S32_I]], <2 x i32> [[VQRDMLAH_S321_I]], <2 x i32> [[VQRDMLAH_S322_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLAH_S324_I:%.*]] = bitcast <2 x i32> [[VQRDMLAH_S323_I]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP5:%.*]] = bitcast <8 x i8> [[VQRDMLAH_S324_I]] to <2 x i32>
// CHECK-AARCH64-NEXT:    ret <2 x i32> [[TMP5]]
//
int32x2_t test_vqrdmlah_lane_s32(int32x2_t a, int32x2_t b, int32x2_t c) {

  return vqrdmlah_lane_s32(a, b, c, 1);
}

// CHECK-ARM-LABEL: @test_vqrdmlahq_lane_s16(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-ARM-NEXT:    [[LANE:%.*]] = shufflevector <4 x i16> [[TMP1]], <4 x i16> [[TMP1]], <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[B:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[LANE]] to <16 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S16_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S161_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S162_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S163_I:%.*]] = call <8 x i16> @llvm.arm.neon.vqrdmlah.v8i16(<8 x i16> [[VQRDMLAHQ_S16_I]], <8 x i16> [[VQRDMLAHQ_S161_I]], <8 x i16> [[VQRDMLAHQ_S162_I]])
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S164_I:%.*]] = bitcast <8 x i16> [[VQRDMLAHQ_S163_I]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP5:%.*]] = bitcast <16 x i8> [[VQRDMLAHQ_S164_I]] to <8 x i16>
// CHECK-ARM-NEXT:    ret <8 x i16> [[TMP5]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlahq_lane_s16(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[LANE:%.*]] = shufflevector <4 x i16> [[TMP1]], <4 x i16> [[TMP1]], <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[B:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[LANE]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S16_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S161_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S162_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S163_I:%.*]] = call <8 x i16> @llvm.aarch64.neon.sqrdmlah.v8i16(<8 x i16> [[VQRDMLAHQ_S16_I]], <8 x i16> [[VQRDMLAHQ_S161_I]], <8 x i16> [[VQRDMLAHQ_S162_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S164_I:%.*]] = bitcast <8 x i16> [[VQRDMLAHQ_S163_I]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP5:%.*]] = bitcast <16 x i8> [[VQRDMLAHQ_S164_I]] to <8 x i16>
// CHECK-AARCH64-NEXT:    ret <8 x i16> [[TMP5]]
//
int16x8_t test_vqrdmlahq_lane_s16(int16x8_t a, int16x8_t b, int16x4_t c) {

  return vqrdmlahq_lane_s16(a, b, c, 3);
}

// CHECK-ARM-LABEL: @test_vqrdmlahq_lane_s32(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-ARM-NEXT:    [[LANE:%.*]] = shufflevector <2 x i32> [[TMP1]], <2 x i32> [[TMP1]], <4 x i32> <i32 1, i32 1, i32 1, i32 1>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[B:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP4:%.*]] = bitcast <4 x i32> [[LANE]] to <16 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S32_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S321_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S322_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S323_I:%.*]] = call <4 x i32> @llvm.arm.neon.vqrdmlah.v4i32(<4 x i32> [[VQRDMLAHQ_S32_I]], <4 x i32> [[VQRDMLAHQ_S321_I]], <4 x i32> [[VQRDMLAHQ_S322_I]])
// CHECK-ARM-NEXT:    [[VQRDMLAHQ_S324_I:%.*]] = bitcast <4 x i32> [[VQRDMLAHQ_S323_I]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP5:%.*]] = bitcast <16 x i8> [[VQRDMLAHQ_S324_I]] to <4 x i32>
// CHECK-ARM-NEXT:    ret <4 x i32> [[TMP5]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlahq_lane_s32(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[LANE:%.*]] = shufflevector <2 x i32> [[TMP1]], <2 x i32> [[TMP1]], <4 x i32> <i32 1, i32 1, i32 1, i32 1>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[B:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP4:%.*]] = bitcast <4 x i32> [[LANE]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S32_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S321_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S322_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S323_I:%.*]] = call <4 x i32> @llvm.aarch64.neon.sqrdmlah.v4i32(<4 x i32> [[VQRDMLAHQ_S32_I]], <4 x i32> [[VQRDMLAHQ_S321_I]], <4 x i32> [[VQRDMLAHQ_S322_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLAHQ_S324_I:%.*]] = bitcast <4 x i32> [[VQRDMLAHQ_S323_I]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP5:%.*]] = bitcast <16 x i8> [[VQRDMLAHQ_S324_I]] to <4 x i32>
// CHECK-AARCH64-NEXT:    ret <4 x i32> [[TMP5]]
//
int32x4_t test_vqrdmlahq_lane_s32(int32x4_t a, int32x4_t b, int32x2_t c) {

  return vqrdmlahq_lane_s32(a, b, c, 1);
}

// CHECK-ARM-LABEL: @test_vqrdmlsh_s16(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[A:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[B:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S16_I:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S161_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S162_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S163_I:%.*]] = call <4 x i16> @llvm.arm.neon.vqrdmlsh.v4i16(<4 x i16> [[VQRDMLSH_S16_I]], <4 x i16> [[VQRDMLSH_S161_I]], <4 x i16> [[VQRDMLSH_S162_I]])
// CHECK-ARM-NEXT:    [[VQRDMLSH_S164_I:%.*]] = bitcast <4 x i16> [[VQRDMLSH_S163_I]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <8 x i8> [[VQRDMLSH_S164_I]] to <4 x i16>
// CHECK-ARM-NEXT:    ret <4 x i16> [[TMP3]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlsh_s16(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[A:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[B:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S16_I:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S161_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S162_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S163_I:%.*]] = call <4 x i16> @llvm.aarch64.neon.sqrdmlsh.v4i16(<4 x i16> [[VQRDMLSH_S16_I]], <4 x i16> [[VQRDMLSH_S161_I]], <4 x i16> [[VQRDMLSH_S162_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S164_I:%.*]] = bitcast <4 x i16> [[VQRDMLSH_S163_I]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <8 x i8> [[VQRDMLSH_S164_I]] to <4 x i16>
// CHECK-AARCH64-NEXT:    ret <4 x i16> [[TMP3]]
//
int16x4_t test_vqrdmlsh_s16(int16x4_t a, int16x4_t b, int16x4_t c) {

  return vqrdmlsh_s16(a, b, c);
}

// CHECK-ARM-LABEL: @test_vqrdmlsh_s32(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[A:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[B:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S32_I:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S321_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S322_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S323_I:%.*]] = call <2 x i32> @llvm.arm.neon.vqrdmlsh.v2i32(<2 x i32> [[VQRDMLSH_S32_I]], <2 x i32> [[VQRDMLSH_S321_I]], <2 x i32> [[VQRDMLSH_S322_I]])
// CHECK-ARM-NEXT:    [[VQRDMLSH_S324_I:%.*]] = bitcast <2 x i32> [[VQRDMLSH_S323_I]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <8 x i8> [[VQRDMLSH_S324_I]] to <2 x i32>
// CHECK-ARM-NEXT:    ret <2 x i32> [[TMP3]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlsh_s32(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[A:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[B:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S32_I:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S321_I:%.*]] = bitcast <8 x i8> [[TMP1]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S322_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S323_I:%.*]] = call <2 x i32> @llvm.aarch64.neon.sqrdmlsh.v2i32(<2 x i32> [[VQRDMLSH_S32_I]], <2 x i32> [[VQRDMLSH_S321_I]], <2 x i32> [[VQRDMLSH_S322_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S324_I:%.*]] = bitcast <2 x i32> [[VQRDMLSH_S323_I]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <8 x i8> [[VQRDMLSH_S324_I]] to <2 x i32>
// CHECK-AARCH64-NEXT:    ret <2 x i32> [[TMP3]]
//
int32x2_t test_vqrdmlsh_s32(int32x2_t a, int32x2_t b, int32x2_t c) {

  return vqrdmlsh_s32(a, b, c);
}

// CHECK-ARM-LABEL: @test_vqrdmlshq_s16(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i16> [[B:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[C:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S16_I:%.*]] = bitcast <16 x i8> [[TMP0]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S161_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S162_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S163_I:%.*]] = call <8 x i16> @llvm.arm.neon.vqrdmlsh.v8i16(<8 x i16> [[VQRDMLSHQ_S16_I]], <8 x i16> [[VQRDMLSHQ_S161_I]], <8 x i16> [[VQRDMLSHQ_S162_I]])
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S164_I:%.*]] = bitcast <8 x i16> [[VQRDMLSHQ_S163_I]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <16 x i8> [[VQRDMLSHQ_S164_I]] to <8 x i16>
// CHECK-ARM-NEXT:    ret <8 x i16> [[TMP3]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlshq_s16(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i16> [[B:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[C:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S16_I:%.*]] = bitcast <16 x i8> [[TMP0]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S161_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S162_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S163_I:%.*]] = call <8 x i16> @llvm.aarch64.neon.sqrdmlsh.v8i16(<8 x i16> [[VQRDMLSHQ_S16_I]], <8 x i16> [[VQRDMLSHQ_S161_I]], <8 x i16> [[VQRDMLSHQ_S162_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S164_I:%.*]] = bitcast <8 x i16> [[VQRDMLSHQ_S163_I]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <16 x i8> [[VQRDMLSHQ_S164_I]] to <8 x i16>
// CHECK-AARCH64-NEXT:    ret <8 x i16> [[TMP3]]
//
int16x8_t test_vqrdmlshq_s16(int16x8_t a, int16x8_t b, int16x8_t c) {

  return vqrdmlshq_s16(a, b, c);
}

// CHECK-ARM-LABEL: @test_vqrdmlshq_s32(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[B:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[C:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S32_I:%.*]] = bitcast <16 x i8> [[TMP0]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S321_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S322_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S323_I:%.*]] = call <4 x i32> @llvm.arm.neon.vqrdmlsh.v4i32(<4 x i32> [[VQRDMLSHQ_S32_I]], <4 x i32> [[VQRDMLSHQ_S321_I]], <4 x i32> [[VQRDMLSHQ_S322_I]])
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S324_I:%.*]] = bitcast <4 x i32> [[VQRDMLSHQ_S323_I]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <16 x i8> [[VQRDMLSHQ_S324_I]] to <4 x i32>
// CHECK-ARM-NEXT:    ret <4 x i32> [[TMP3]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlshq_s32(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <4 x i32> [[B:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[C:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S32_I:%.*]] = bitcast <16 x i8> [[TMP0]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S321_I:%.*]] = bitcast <16 x i8> [[TMP1]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S322_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S323_I:%.*]] = call <4 x i32> @llvm.aarch64.neon.sqrdmlsh.v4i32(<4 x i32> [[VQRDMLSHQ_S32_I]], <4 x i32> [[VQRDMLSHQ_S321_I]], <4 x i32> [[VQRDMLSHQ_S322_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S324_I:%.*]] = bitcast <4 x i32> [[VQRDMLSHQ_S323_I]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <16 x i8> [[VQRDMLSHQ_S324_I]] to <4 x i32>
// CHECK-AARCH64-NEXT:    ret <4 x i32> [[TMP3]]
//
int32x4_t test_vqrdmlshq_s32(int32x4_t a, int32x4_t b, int32x4_t c) {

  return vqrdmlshq_s32(a, b, c);
}

// CHECK-ARM-LABEL: @test_vqrdmlsh_lane_s16(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-ARM-NEXT:    [[LANE:%.*]] = shufflevector <4 x i16> [[TMP1]], <4 x i16> [[TMP1]], <4 x i32> <i32 3, i32 3, i32 3, i32 3>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[A:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[B:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[LANE]] to <8 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S16_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S161_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S162_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S163_I:%.*]] = call <4 x i16> @llvm.arm.neon.vqrdmlsh.v4i16(<4 x i16> [[VQRDMLSH_S16_I]], <4 x i16> [[VQRDMLSH_S161_I]], <4 x i16> [[VQRDMLSH_S162_I]])
// CHECK-ARM-NEXT:    [[VQRDMLSH_S164_I:%.*]] = bitcast <4 x i16> [[VQRDMLSH_S163_I]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP5:%.*]] = bitcast <8 x i8> [[VQRDMLSH_S164_I]] to <4 x i16>
// CHECK-ARM-NEXT:    ret <4 x i16> [[TMP5]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlsh_lane_s16(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[LANE:%.*]] = shufflevector <4 x i16> [[TMP1]], <4 x i16> [[TMP1]], <4 x i32> <i32 3, i32 3, i32 3, i32 3>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[A:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <4 x i16> [[B:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP4:%.*]] = bitcast <4 x i16> [[LANE]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S16_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S161_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S162_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S163_I:%.*]] = call <4 x i16> @llvm.aarch64.neon.sqrdmlsh.v4i16(<4 x i16> [[VQRDMLSH_S16_I]], <4 x i16> [[VQRDMLSH_S161_I]], <4 x i16> [[VQRDMLSH_S162_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S164_I:%.*]] = bitcast <4 x i16> [[VQRDMLSH_S163_I]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP5:%.*]] = bitcast <8 x i8> [[VQRDMLSH_S164_I]] to <4 x i16>
// CHECK-AARCH64-NEXT:    ret <4 x i16> [[TMP5]]
//
int16x4_t test_vqrdmlsh_lane_s16(int16x4_t a, int16x4_t b, int16x4_t c) {

  return vqrdmlsh_lane_s16(a, b, c, 3);
}

// CHECK-ARM-LABEL: @test_vqrdmlsh_lane_s32(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-ARM-NEXT:    [[LANE:%.*]] = shufflevector <2 x i32> [[TMP1]], <2 x i32> [[TMP1]], <2 x i32> <i32 1, i32 1>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[A:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[B:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP4:%.*]] = bitcast <2 x i32> [[LANE]] to <8 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S32_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S321_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S322_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <2 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSH_S323_I:%.*]] = call <2 x i32> @llvm.arm.neon.vqrdmlsh.v2i32(<2 x i32> [[VQRDMLSH_S32_I]], <2 x i32> [[VQRDMLSH_S321_I]], <2 x i32> [[VQRDMLSH_S322_I]])
// CHECK-ARM-NEXT:    [[VQRDMLSH_S324_I:%.*]] = bitcast <2 x i32> [[VQRDMLSH_S323_I]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP5:%.*]] = bitcast <8 x i8> [[VQRDMLSH_S324_I]] to <2 x i32>
// CHECK-ARM-NEXT:    ret <2 x i32> [[TMP5]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlsh_lane_s32(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[LANE:%.*]] = shufflevector <2 x i32> [[TMP1]], <2 x i32> [[TMP1]], <2 x i32> <i32 1, i32 1>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[A:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <2 x i32> [[B:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP4:%.*]] = bitcast <2 x i32> [[LANE]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S32_I:%.*]] = bitcast <8 x i8> [[TMP2]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S321_I:%.*]] = bitcast <8 x i8> [[TMP3]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S322_I:%.*]] = bitcast <8 x i8> [[TMP4]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S323_I:%.*]] = call <2 x i32> @llvm.aarch64.neon.sqrdmlsh.v2i32(<2 x i32> [[VQRDMLSH_S32_I]], <2 x i32> [[VQRDMLSH_S321_I]], <2 x i32> [[VQRDMLSH_S322_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLSH_S324_I:%.*]] = bitcast <2 x i32> [[VQRDMLSH_S323_I]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP5:%.*]] = bitcast <8 x i8> [[VQRDMLSH_S324_I]] to <2 x i32>
// CHECK-AARCH64-NEXT:    ret <2 x i32> [[TMP5]]
//
int32x2_t test_vqrdmlsh_lane_s32(int32x2_t a, int32x2_t b, int32x2_t c) {

  return vqrdmlsh_lane_s32(a, b, c, 1);
}

// CHECK-ARM-LABEL: @test_vqrdmlshq_lane_s16(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-ARM-NEXT:    [[LANE:%.*]] = shufflevector <4 x i16> [[TMP1]], <4 x i16> [[TMP1]], <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[B:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[LANE]] to <16 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S16_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S161_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S162_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x i16>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S163_I:%.*]] = call <8 x i16> @llvm.arm.neon.vqrdmlsh.v8i16(<8 x i16> [[VQRDMLSHQ_S16_I]], <8 x i16> [[VQRDMLSHQ_S161_I]], <8 x i16> [[VQRDMLSHQ_S162_I]])
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S164_I:%.*]] = bitcast <8 x i16> [[VQRDMLSHQ_S163_I]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP5:%.*]] = bitcast <16 x i8> [[VQRDMLSHQ_S164_I]] to <8 x i16>
// CHECK-ARM-NEXT:    ret <8 x i16> [[TMP5]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlshq_lane_s16(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <4 x i16> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <4 x i16>
// CHECK-AARCH64-NEXT:    [[LANE:%.*]] = shufflevector <4 x i16> [[TMP1]], <4 x i16> [[TMP1]], <8 x i32> <i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[A:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[B:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[LANE]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S16_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S161_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S162_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <8 x i16>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S163_I:%.*]] = call <8 x i16> @llvm.aarch64.neon.sqrdmlsh.v8i16(<8 x i16> [[VQRDMLSHQ_S16_I]], <8 x i16> [[VQRDMLSHQ_S161_I]], <8 x i16> [[VQRDMLSHQ_S162_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S164_I:%.*]] = bitcast <8 x i16> [[VQRDMLSHQ_S163_I]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP5:%.*]] = bitcast <16 x i8> [[VQRDMLSHQ_S164_I]] to <8 x i16>
// CHECK-AARCH64-NEXT:    ret <8 x i16> [[TMP5]]
//
int16x8_t test_vqrdmlshq_lane_s16(int16x8_t a, int16x8_t b, int16x4_t c) {

  return vqrdmlshq_lane_s16(a, b, c, 3);
}

// CHECK-ARM-LABEL: @test_vqrdmlshq_lane_s32(
// CHECK-ARM-NEXT:  entry:
// CHECK-ARM-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-ARM-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-ARM-NEXT:    [[LANE:%.*]] = shufflevector <2 x i32> [[TMP1]], <2 x i32> [[TMP1]], <4 x i32> <i32 1, i32 1, i32 1, i32 1>
// CHECK-ARM-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[B:%.*]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP4:%.*]] = bitcast <4 x i32> [[LANE]] to <16 x i8>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S32_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S321_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S322_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <4 x i32>
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S323_I:%.*]] = call <4 x i32> @llvm.arm.neon.vqrdmlsh.v4i32(<4 x i32> [[VQRDMLSHQ_S32_I]], <4 x i32> [[VQRDMLSHQ_S321_I]], <4 x i32> [[VQRDMLSHQ_S322_I]])
// CHECK-ARM-NEXT:    [[VQRDMLSHQ_S324_I:%.*]] = bitcast <4 x i32> [[VQRDMLSHQ_S323_I]] to <16 x i8>
// CHECK-ARM-NEXT:    [[TMP5:%.*]] = bitcast <16 x i8> [[VQRDMLSHQ_S324_I]] to <4 x i32>
// CHECK-ARM-NEXT:    ret <4 x i32> [[TMP5]]
//
// CHECK-AARCH64-LABEL: @test_vqrdmlshq_lane_s32(
// CHECK-AARCH64-NEXT:  entry:
// CHECK-AARCH64-NEXT:    [[TMP0:%.*]] = bitcast <2 x i32> [[C:%.*]] to <8 x i8>
// CHECK-AARCH64-NEXT:    [[TMP1:%.*]] = bitcast <8 x i8> [[TMP0]] to <2 x i32>
// CHECK-AARCH64-NEXT:    [[LANE:%.*]] = shufflevector <2 x i32> [[TMP1]], <2 x i32> [[TMP1]], <4 x i32> <i32 1, i32 1, i32 1, i32 1>
// CHECK-AARCH64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[A:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[B:%.*]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP4:%.*]] = bitcast <4 x i32> [[LANE]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S32_I:%.*]] = bitcast <16 x i8> [[TMP2]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S321_I:%.*]] = bitcast <16 x i8> [[TMP3]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S322_I:%.*]] = bitcast <16 x i8> [[TMP4]] to <4 x i32>
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S323_I:%.*]] = call <4 x i32> @llvm.aarch64.neon.sqrdmlsh.v4i32(<4 x i32> [[VQRDMLSHQ_S32_I]], <4 x i32> [[VQRDMLSHQ_S321_I]], <4 x i32> [[VQRDMLSHQ_S322_I]])
// CHECK-AARCH64-NEXT:    [[VQRDMLSHQ_S324_I:%.*]] = bitcast <4 x i32> [[VQRDMLSHQ_S323_I]] to <16 x i8>
// CHECK-AARCH64-NEXT:    [[TMP5:%.*]] = bitcast <16 x i8> [[VQRDMLSHQ_S324_I]] to <4 x i32>
// CHECK-AARCH64-NEXT:    ret <4 x i32> [[TMP5]]
//
int32x4_t test_vqrdmlshq_lane_s32(int32x4_t a, int32x4_t b, int32x2_t c) {

  return vqrdmlshq_lane_s32(a, b, c, 1);
}
