# S3 synchronisation

As of Joplin 2.x.x, Joplin supports multiple S3 providers. We expose some options that will need to be configured depending on your provider of choice. See below for the providers that have been tested and confirmed to work.

In the **desktop application** or **mobile application**, select "S3 (Beta)" as the synchronisation target in the [Configuration screen](https://github.com/laurent22/joplin/blob/dev/readme/apps/config_screen.md).

- **S3 Bucket:** The name of your Bucket, such as `joplin-bucket`
- **S3 URL:** Fully qualified URL; For AWS this should be `https://s3.<regionName>.amazonaws.com/`
- **S3 Access Key & S3 Secret Key:**  The User's programmatic access key.  To create a new key & secret on AWS, visit [IAM Security Credentials](https://console.aws.amazon.com/iam/home#/security_credentials). For other providers follow their documentation.
- **S3 Region:** Some providers require you to provide the region of your bucket. This is usually in the form of "eu-west1" or something similar depending on your region. For providers that do not require a region, you can leave it blank.
- **Force Path Style**: This setting enables Joplin to talk to S3 providers using an older style S3 Path. Depending on your provider you may need to try with this on and off.


While creating a new Bucket for Joplin, disable **Bucket Versioning**, enable **Block all public access** and enable **Default encryption** with `Amazon S3 key (SSE-S3)`. Some providers do not expose these options, and it could create a syncing problem. Do attempt and report back so we can update the documentation appropriately.

To add a **Bucket Policy** from the AWS S3 Web Console, navigate to the **Permissions** tab. Temporarily disable **Block all public access**  to edit the Bucket policy, something along the lines of:
```
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "VisualEditor0",
            "Effect": "Allow",
            "Action": [
                  "s3:ListBucket",
                  "s3:GetBucketLocation",
                  "s3:GetObject",
                  "s3:DeleteObject",
                  "s3:DeleteObjectVersion",
                  "s3:PutObject"
            ],
            "Resource": [
                "arn:aws:s3:::joplin-bucket",
                "arn:aws:s3:::joplin-bucket/*"
            ]
        }
    ]
}
```

## Configuration settings for tested providers

All providers will require a bucket, Access Key, and Secret Key.

If you provide a configuration and you receive "success!" on the "check config" then your S3 sync should work for your provider. If you do not receive success, you may need to adjust your settings, or save them, restart the app, and attempt a sync. This may reveal more clear error messaging that will help you deduce the problem.

## AWS
- URL: `https://s3.<region>.amazonaws.com/` (fill in your region, a complete list of endpoint addresses can be found [here](https://docs.aws.amazon.com/general/latest/gr/s3.html))
- Region: required
- Force Path Style: unchecked

## Backblaze
- URL: `https://s3.<region>.backblazeb2.com` (This is the endpoint URL provided by Backblaze B2)
- Region: required (Copied from the provided endpoint URL. Example: `us-east-001`)
- Force Path Style: unchecked

## Cloudflare R2
- URL: `https://<ACCOUNT_ID>.r2.cloudflarestorage.com` (clicking on API > "Use R2 with APIs" in Cloudflare Dashboard will show you the correct URL)
- S3 Access Key & S3 Secret Key: Generate an API Token by going to Manage API tokens > "Create Account API Token". Give the API Token `Object Read & Write` permissions. Use the resulting `Access Key ID` and `Secret Access Key` as the S3 Access Key & S3 Secret Key in Joplin
- Region: `auto`
- Force Path Style: unchecked

## DigitalOcean
- URL: `https://<region>.digitaloceanspaces.com` (region is selected when the bucket is created, available regions listed [here](https://docs.digitalocean.com/products/spaces/details/availability/))
- Region: required, but no impact on the actual region as it's defined in the URL. Suggest entering `us-east-1`.
- Force Path Style: unchecked

## Linode
- URL: `https://<region>.linodeobjects.com` (region is in the URL provided by Linode; this URL is also the same as the URL provided by Linode with the bucket name removed)
- Region: Anything you want to type, can't be left empty
- Force Path Style: unchecked

## Scaleway
- URL: `https://s3.<region>.scw.cloud` (The region is the same as the bucket's region. You could just copy your bucket endpoint in the bucket settings tab, then remove the bucket name from it.)
- Region: required (example: `fr-par`)
- Force Path Style: unchecked

## UpCloud
- URL: `https://<account>.<region>.upcloudobjects.com` (They will provide you with multiple URLs, the one that follows this pattern should work.)
- Region: required
- Force Path Style: unchecked

## Tebi
- URL: `https://s3.tebi.io` ((This is the endpoint URL provided by Tebi)
- Region: required
- Force Path Style: unchecked
