# HighsInfo

Scalar information about a solved model is communicated via an instance of the HighsInfo structure

## valid
- Indicates whether the values in a HighsInfo instance are valid
- Type: bool

## simplex\_iteration\_count
- The number of simplex iterations performed
- Type: integer

## ipm\_iteration\_count
- The number of interior point iterations performed
- Type: integer

## crossover\_iteration\_count
- The number of crossover iterations performed
- Type: integer

## pdlp\_iteration\_count
- The number of PDLP iterations performed
- Type: integer

## qp\_iteration\_count
- The number of QP iterations performed
- Type: integer

## primal\_solution\_status
- Comparison with [SolutionStatus](@ref) gives the status of the [primal](@ref Primal-values) solution
- Type: integer

## dual\_solution\_status
- Comparison with [SolutionStatus](@ref) gives the status of the [dual](@ref Dual-values) solution
- Type: integer

## basis\_validity
- Comparison with [BasisValidity](@ref) gives the status of any basis information
- Type: integer

## objective\_function\_value
- The optimal value of the objective function
- Type: double

## mip\_node\_count
- The number of nodes generated by the MIP solver
- Type: long integer

## mip\_dual\_bound
- The [dual bound](@ref terminology-mip) for the MIP solver
- Type: double

## mip\_gap
- The absolute value of the gap between the primal and bounds, relative to the primal bound.
- Type: double

## max\_integrality\_violation
- The maximum deviation from an integer value over all the discrete variables
- Type: double

## [num\_primal\_infeasibilities](@id info-num-primal-infeasibilities)
- The number of variables violating a bound by more than the [primal feasibility tolerance](@ref option-primal-feasibility-tolerance).
- Type: integer

## max\_primal\_infeasibility
- The maximum violation of a bound on a variable
- Type: double

## sum\_primal\_infeasibilities
- The sum of violations of bounds by variables
- Type: double

## num\_dual\_infeasibilities
- The number of variables violating dual feasibility by more than the [dual feasibility tolerance](@ref option-dual-feasibility-tolerance).
- Type: integer

## max\_dual\_infeasibility
- The maximum violation of dual feasibility
- Type: double

## sum\_dual\_infeasibilities
- The sum of violations of dual feasibility
- Type: double

## num\_relative\_primal\_infeasibilities
- The number of variables violating a bound by relatively more than the [primal feasibility tolerance](@ref option-primal-feasibility-tolerance).
- Type: integer

## max\_relative\_primal\_infeasibility
- The maximum relative violation of a bound on a variable
- Type: double

## num\_relative\_dual\_infeasibilities
- The number of variables violating dual feasibility by relatively more than the [dual feasibility tolerance](@ref option-dual-feasibility-tolerance).
- Type: integer

## max\_relative\_dual\_infeasibility
- The maximum relative violation of dual feasibility
- Type: double

## num\_primal\_residual\_errors
- The number of primal equations violated by more than the [primal residual tolerance](@ref option-primal-residual-tolerance).
- Type: integer

## max\_primal\_residual\_error
- The maximum violation of primal equations 
- Type: double

## num\_dual\_residual\_errors
- The number of dual equations violated by more than the [dual residual tolerance](@ref option-dual-residual-tolerance).
- Type: integer

## max\_dual\_residual\_error
- The maximum violation of dual equations 
- Type: double

## num\_relative\_primal\_residual\_errors
- The number of primal equations violated by relatively more than the [primal residual tolerance](@ref option-primal-residual-tolerance).
- Type: integer

## max\_relative\_primal\_residual\_error
- The maximum relative violation of primal equations 
- Type: double

## num\_relative\_dual\_residual\_errors
- The number of dual equations violated by relatively more than the [dual residual tolerance](@ref option-dual-residual-tolerance).
- Type: integer

## max\_relative\_dual\_residual\_error
- The maximum relative violation of dual equations 
- Type: double

## num\_complementarity\_violations
- The number of violations of primal-dual complementarity 
- Type: integer

## max\_complementarity\_violation
- The maximum primal-dual complementarity violation
- Type: double

## primal\_dual\_objective\_error
- The relative difference between the primal and dual objective values
- Type: double

## primal\_dual\_integral
- The primal-dual integral for MIPs
- Type: double

