package main

import (
	"fmt"
	"testing"
)

func TestValidUTF8(t *testing.T) {
	invalidCodePoints := [...]rune{
		0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
		0x08, 0x0B, 0x0C, 0x0E, 0x0F, 0x10, 0x11, 0x12,
		0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A,
		0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	}
	for _, icp := range invalidCodePoints {
		teststring := fmt.Sprintf("bla%cbla", icp)
		cleanstring := validUTF8(teststring)
		if cleanstring != "bla�bla" {
			t.Errorf("Expected 'bla�bla', got '%s'", cleanstring)
		}
	}
}

func TestGetRpad(t *testing.T) {
	rpad := getRpad(10)
	if len(rpad) != 90 {
		t.Errorf("Expected a rpad length of 90, got length of %d", len(rpad))
	}
	rpad = getRpad(99)
	if len(rpad) != 1 {
		t.Errorf("Expected a rpad length of 1, got length of %d", len(rpad))
	}
	rpad = getRpad(100)
	if len(rpad) != 100 {
		t.Errorf("Expected a rpad length of 100, got length of %d", len(rpad))
	}
	rpad = getRpad(101)
	if len(rpad) != 99 {
		t.Errorf("Expected a rpad length of 99, got length of %d", len(rpad))
	}
	rpad = getRpad(199)
	if len(rpad) != 1 {
		t.Errorf("Expected a rpad length of 1, got length of %d", len(rpad))
	}
	rpad = getRpad(201)
	if len(rpad) != 99 {
		t.Errorf("Expected a rpad length of 99, got length of %d", len(rpad))
	}
}

func TestFsFriendlyJid(t *testing.T) {
	jid := fsFriendlyJid("user@example.org")
	if jid != "user_at_example_org" {
		t.Errorf("Expected 'user_at_example_org', got '%s'", jid)
	}
}
